% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapnet.r
\docType{package}
\name{plotbiomes}
\alias{plotbiomes}
\title{Bootstrap network indices}
\description{
R package for resampling network metrics/indices (bootstrapping without
replacement). It wraps around the \href{https://cran.r-project.org/web/packages/bipartite/index.html}{bipartite} package functions
\code{\link[bipartite]{networklevel}} and
\code{\link[bipartite]{specieslevel}}.

Assuming a network/web like \code{Safariland} from the \code{bipartite} package, one
can sample interactions without replacement from the network until all
interactions have been used. The sampling procedure starts with a small
sample size to which interactions are added until all are consumed. Every
time we sample interactions, a smaller version of the entire network can be
built and a network index/metric can be computed. The sampling procedure can
be repeated as many times as needed, giving the possibility to compute mean
values with quantile-based confidence intervals. The mean values across
sample sizes can be plotted and indices of different networks can be visually
compared. See examples at
\href{https://github.com/valentinitnelav/plotbiomes/blob/develop/README.md}{README}
}
\section{Help}{

Examples at: \href{https://github.com/valentinitnelav/plotbiomes/blob/develop/README.md}{README}

GitHub page \href{https://github.com/valentinitnelav/bootstrapnet}{here}
}

\author{
Valentin Stefan, Tiffany Knight
}
