% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_gg.r
\name{gg_specieslevel_web_by_web}
\alias{gg_specieslevel_web_by_web}
\title{Plot bootstrapped species level metrics for one or more webs/networks.}
\usage{
gg_specieslevel_web_by_web(
  metrics_stats,
  sp_lower = NULL,
  sp_higher = NULL,
  size_boot_lines = 0.1,
  alpha_boot_lines = 0.1,
  size_ci = 1,
  linetype_ci = 2,
  size_mean = 1,
  linetype_mean = 1
)
}
\arguments{
\item{metrics_stats}{The output of \code{\link[bootstrapnet]{get_stats_multi}}.}

\item{sp_lower}{A character vector of one or more lower level species names (plants) shared
among the given networks. Only the bootstrapped metric values for these
species will be plotted. It can be helpful when there are too many species
in a network and the graphs could get easily cluttered. If \code{sp_lower} is
left empty, then all species will be considered for plotting. If the species
names are not shared across all given networks, then a warning will be given
for the specific network from where they are missing and the plot will be
empty or show only existing shared species names.}

\item{sp_higher}{Similar to \code{sp_lower}, but valid for higher level species names (insects).}

\item{size_boot_lines}{Size of the line connecting the bootstrapped values of the metric. Default
is 0.1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{alpha_boot_lines}{Alpha parameter of the line connecting the bootstrapped values of the
metric. Default is 0.1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{size_ci}{Size of the line used for the confidence intervals. Default is 1. Passed to
\code{\link[ggplot2:geom_path]{geom_line}}.}

\item{linetype_ci}{Type of the line used for the confidence intervals. Default is 2. Passed to
\code{\link[ggplot2:geom_path]{geom_line}}.}

\item{size_mean}{Size of the line connecting the bootstrapped mean values of the metric.
Default is 1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{linetype_mean}{Type of the line connecting the bootstrapped mean values of the metric.
Default is 1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}
}
\value{
A list of one or more ggplots.
}
\description{
To be used in combination with \code{\link[bootstrapnet]{boot_specieslevel}}
and \code{\link[bootstrapnet]{get_stats_multi}}. See the example section of
\code{\link[bootstrapnet]{boot_specieslevel}}.
}
\examples{
 # See example section of ?boot_specieslevel

}
