% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_gg.r
\name{gg_networklevel}
\alias{gg_networklevel}
\title{Plot bootstrapped network level metrics for one or multiple networks.}
\usage{
gg_networklevel(
  metrics_stats,
  size_boot_lines = 0.1,
  alpha_boot_lines = 0.1,
  size_ci = 1,
  linetype_ci = 2,
  size_mean = 1,
  linetype_mean = 1
)
}
\arguments{
\item{metrics_stats}{The output of \code{\link[bootstrapnet]{boot_networklevel}}.}

\item{size_boot_lines}{Size of the line connecting the bootstrapped values of the metric. Default
is 0.1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{alpha_boot_lines}{Alpha parameter of the line connecting the bootstrapped values of the
metric. Default is 0.1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{size_ci}{Size of the line used for the confidence intervals. Default is 1. Passed to
\code{\link[ggplot2:geom_path]{geom_line}}.}

\item{linetype_ci}{Type of the line used for the confidence intervals. Default is 2. Passed to
\code{\link[ggplot2:geom_path]{geom_line}}.}

\item{size_mean}{Size of the line connecting the bootstrapped mean values of the metric.
Default is 1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}

\item{linetype_mean}{Type of the line connecting the bootstrapped mean values of the metric.
Default is 1. Passed to \code{\link[ggplot2:geom_path]{geom_line}}.}
}
\value{
A list of one or more ggplots.
}
\description{
This function takes as input the output of
\code{\link[bootstrapnet]{boot_networklevel}}. Can be used to plot the
bootstrapped network level metrics of a single network (not that useful) or
for multiple networks (to check for overlaps in their confidence intervals).
}
\examples{
# See example section of ?boot_networklevel

}
