% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get_stats_single}
\alias{get_stats_single}
\title{Prepare bootstrapped results of a single network for \code{ggplot} friendly data
format.}
\usage{
get_stats_single(x, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{A bootstrap matrix or an array of matrices from
\code{\link[bootstrapnet]{boot_networklevel_n}} or
\code{\link[bootstrapnet]{boot_specieslevel_n}}.}

\item{probs}{A numeric vector of two probabilities in \verb{[0, 1]}. Passed to
\code{\link[matrixStats]{rowQuantiles}} and used for building the lower and
upper bounds of the confidence intervals. Defaults to \code{c(0.025, 0.975)},
which corresponds to a 95\\\% confidence interval.}
}
\value{
A list of two data frames to be used with \code{\link[ggplot2]{ggplot}}.
First one, \code{stats_df} is a 4 columns data frame, containing the sample size
(\code{spl_size}) at each iteration and the corresponding mean metric (\code{mean})
together with its bootstrap confidence interval limits (\code{ci_low}, \code{ci_up}).
The second one, \code{lines_df}, contains all the bootstrapped values (\code{value}) of
a given network metric at each iteration (\code{simulation_id}) and its
corresponding sample size (\code{spl_size}). Can be used for enhancing visual
effect when plotting the mean bootstrap values.
}
\description{
Helper to prepare the bootstrapped metric output of a single web/network
from \code{\link[bootstrapnet]{boot_networklevel_n}} or
\code{\link[bootstrapnet]{boot_specieslevel_n}} in a format ready for
\code{\link[ggplot2]{ggplot}}.
}
\examples{
library(bootstrapnet)
library(bipartite)
library(magrittr)
data(Safariland)

stats_d_lower <- Safariland \%>\%
  web_matrix_to_df() \%>\%
  boot_specieslevel_n(col_lower = "lower", # column name for plants
                        col_higher = "higher", # column name for insects
                        index = "d",
                        level = "both",
                        start = 100,
                        step = 100,
                        n_boot = 10,
                        n_cpu = 2) \%>\%
  .[["lower_level"]] \%>\%
  get_stats_single()

}
