% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get_stats_multi}
\alias{get_stats_multi}
\title{Prepare bootstrapped results of one or more networks for \code{ggplot2} friendly
data format.}
\usage{
get_stats_multi(webs_stats)
}
\arguments{
\item{webs_stats}{A list of bootstrap results from
\code{\link[bootstrapnet]{boot_specieslevel}}, or from multiple runs of
\code{\link[bootstrapnet]{boot_networklevel_n}} or
\code{\link[bootstrapnet]{boot_specieslevel_n}}.}
}
\value{
A list of two data frames to be used with \code{\link[ggplot2]{ggplot}}.
First one, \code{stats_df} is a 5 columns data frame, containing for each network
(\code{web}) the sample size (\code{spl_size}) at each iteration and the corresponding
mean metric (\code{mean}), together with its bootstrap confidence interval limits
(\code{ci_low}, \code{ci_up}). The second one, \code{lines_df}, contains all the
bootstrapped values (\code{value}) of a given network metric at each iteration
(\code{simulation_id}) and its corresponding sample size (\code{spl_size}). Can be
used for enhancing visual effect when plotting the mean bootstrap values.
}
\description{
Helper to prepare the bootstrapped metric output of one or more
webs/networks from \code{\link[bootstrapnet]{boot_specieslevel}},
\code{\link[bootstrapnet]{boot_networklevel_n}} or
\code{\link[bootstrapnet]{boot_specieslevel_n}} in a format ready for
\code{\link[ggplot2]{ggplot}}. See the examples section of
\code{\link[bootstrapnet]{boot_specieslevel}}.
}
\examples{
 # See example section of ?boot_specieslevel

}
