% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_specieslevel.r
\name{boot_specieslevel_n}
\alias{boot_specieslevel_n}
\title{Bootstrap metric at the species level multiple times.}
\usage{
boot_specieslevel_n(
  data,
  col_lower,
  col_higher,
  index,
  level,
  start,
  step,
  n_boot,
  n_cpu,
  ...
)
}
\arguments{
\item{data}{Data frame of interactions from which to build and sample web matrices. Each
interaction (row in the data frame) must be repeated as many times as it was
observed. E.g. if species_1 x species_2 was observed 5 times, then repeat
that row 5 times within the data frame. See examples below.}

\item{col_lower}{Quoted column name in \code{data} for lower trophic level species (plants).}

\item{col_higher}{Quoted column name in \code{data} for higher trophic level species (insects).}

\item{index}{Passed to \code{\link[bipartite]{specieslevel}}. See
\code{?bipartite::specieslevel} for details.}

\item{level}{Passed to \code{\link[bipartite]{specieslevel}}. See
\code{?bipartite::specieslevel} for details. For which level should the
level-specific indices be computed: 'both' (default), 'lower' or 'higher'?}

\item{start}{Integer. The sample size (number of interactions) to start the bootstrap
with. If the start sample size is small (e.g. 5 or 10), then first
iterations might results in NaN-s and warning messages are displayed.
Consider to set \code{start} to maybe 10\\\% of your total unique interactions.}

\item{step}{Integer. Sample size (number of interactions) used to increase gradually the
sampled network until all interactions are sampled. If \code{step} is too small
(e.g. 1) then the computation time is very long depending on your total
number of interactions from which samples are taken. Consider to set \code{step}
to maybe 5-10\\\% of your total unique interactions.}

\item{n_boot}{Number of desired bootstraps (50 or 100 can be enough).}

\item{n_cpu}{Number of CPU-s to use for parallel processing.}

\item{...}{Other arguments passed to \code{\link[bipartite]{specieslevel}} like
\code{logbase}, etc.}
}
\value{
Returns a list of 1, 2 or 4 arrays of matrices. The species names are stored
as the row names of each matrix. The number of columns of a matrix indicates
how many iterations took place. This is decided internally based on the given
values to \code{start}, \code{step} and the total number of rows (interactions) in
\code{data}. The column names give the sample size at each iteration. The last
iteration (last column name) is always the entire network (total number of
interactions in \code{data}). The 3rd dimension (number of matrices in the array)
corresponds to \code{n_boot} (number of bootstraps).
}
\description{
Bootstrap a single network of interactions n times in parallel. This
function is used for network metrics at the species level. Starts with a
small sample size of interactions (e.g. \code{start = 30}), builds the
corresponding web matrix/network, computes its metric (e.g. \code{index = "d"})
using \code{\link[bipartite]{specieslevel}}, then adds new interactions
(e.g. \code{step = 20}) until all interactions are sampled. The last sample is
actually the entire network. Repeats n times (as given in \code{n_boot}) these
steps in parallel on multiple CPUs.
}
\examples{

library(bootstrapnet)
library(magrittr)
library(bipartite)
data(Safariland)

Safariland \%>\%
  web_matrix_to_df() \%>\%
  boot_specieslevel_n(col_lower = "lower", # column name for plants
                      col_higher = "higher", # column name for insects
                      index = "d",
                      level = "both",
                      start = 100,
                      step = 100,
                      n_boot = 10,
                      n_cpu = 2)

}
