% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_specieslevel.r
\name{boot_specieslevel}
\alias{boot_specieslevel}
\title{Prepare for plotting the bootstrapped metrics at the species level of one or
multiple networks.}
\usage{
boot_specieslevel(
  lst,
  col_lower,
  col_higher,
  index,
  level,
  start,
  step,
  n_boot,
  n_cpu,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{lst}{A list of one or multiple data frames of interactions from which to build
and sample web matrices. Each interaction (row in the data frame) must be
repeated as many times as it was observed. E.g. if the interaction species_1
x species_2 was observed 5 times, then repeat that row 5 times within the
data frame.}

\item{col_lower}{Quoted column name in \code{data} for lower trophic level species (plants).}

\item{col_higher}{Quoted column name in \code{data} for higher trophic level species (insects).}

\item{index}{Passed to \code{\link[bipartite]{networklevel}}. See
\code{?bipartite::networklevel} for details.}

\item{level}{Passed to \code{\link[bipartite]{networklevel}}. See
\code{?bipartite::networklevel} for details. For which level should the
level-specific indices be computed: 'both' (default), 'lower' or 'higher'?}

\item{start}{Integer. The sample size (number of interactions) to start the bootstrap
with. If the start sample size is small (e.g. 5 or 10), then first
iterations might results in NaN-s and warning messages are displayed.
Consider to set \code{start} to maybe 10\\\% of your total unique interactions.}

\item{step}{Integer. Sample size (number of interactions) used to increase gradually the
sampled network until all interactions are sampled. If \code{step} is too small
(e.g. 1) then the computation time is very long depending on your total
number of interactions from which samples are taken. Consider to set \code{step}
to maybe 5-10\\\% of your total unique interactions.}

\item{n_boot}{Number of desired bootstraps (50 or 100 can be enough).}

\item{n_cpu}{Number of CPU-s to use for parallel processing.}

\item{probs}{A numeric vector of two probabilities in \verb{[0, 1]}. Passed to
\code{\link[matrixStats]{rowQuantiles}} and used for building the lower and
upper bounds of the confidence intervals. Defaults to \code{c(0.025, 0.975)},
which corresponds to a 95\\\% confidence interval.}

\item{...}{Other arguments passed to \code{\link[bipartite]{specieslevel}}.}
}
\value{
A 3 levels list of the same length as \code{lst}. The list can be passed to
\code{\link[bootstrapnet]{gg_specieslevel_compare_webs}} or to
\code{\link[bootstrapnet]{get_stats_multi}} and then its output to
\code{\link[bootstrapnet]{gg_specieslevel_web_by_web}}. Each element of the
list is a sub-list corresponding to each network. Each sub-list contains
further sub-lists with the bootstrapped metric values at 'lower', 'higher'
or 'both' levels. Each sub-sub-lists contains two data frames: \code{stats_df}
and \code{lines_df}, which can be used by the \code{ggplot2::geom_line()} function.
See the return section of \code{\link[bootstrapnet]{get_stats_single}} for
more details about \code{stats_df} and \code{lines_df} data frames.
}
\description{
Takes a list of network interactions (each interaction being repeated as
many times as it was observed), and bootstraps the given species level
metric (\code{index}) for each network. Runs \code{boot_specieslevel_n()} for a list
of network interactions and prepares the data for plotting with \code{ggplot}.
The output list can be passed to
\code{\link[bootstrapnet]{gg_specieslevel_compare_webs}} or to
\code{\link[bootstrapnet]{get_stats_multi}} and then its output to
\code{\link[bootstrapnet]{gg_specieslevel_web_by_web}}. See examples below.
}
\examples{

library(bootstrapnet)
library(bipartite)
library(magrittr)
data(Safariland)

set.seed(321)
Safariland_1 <- Safariland[, sort(sample.int(ncol(Safariland), 20))]
set.seed(123)
Safariland_2 <- Safariland[, sort(sample.int(ncol(Safariland), 20))]

lst <- list(s1 = Safariland_1, s2 = Safariland_2) \%>\%
  lapply(web_matrix_to_df) \%>\%
  boot_specieslevel(col_lower = "lower", # column name for plants
                    col_higher = "higher", # column name for insects
                    index = "betweenness",
                    level = "both",
                    start = 50,
                    step = 20,
                    n_boot = 10,
                    n_cpu = 2)

lst \%>\%
  get_stats_multi() \%>\%
  gg_specieslevel_compare_webs(sp_lower = "Alstroemeria aurea",
                               sp_higher = "Allograpta.Toxomerus")

lst \%>\%
  gg_specieslevel_web_by_web(sp_lower = c("Alstroemeria aurea",
                                          "Aristotelia chilensis"))

}
