% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_networklevel.r
\name{boot_networklevel_n}
\alias{boot_networklevel_n}
\title{Bootstrap network level metric multiple times.}
\usage{
boot_networklevel_n(
  data,
  col_lower,
  col_higher,
  index,
  level,
  start,
  step,
  n_boot,
  n_cpu,
  ...
)
}
\arguments{
\item{data}{Data frame of interactions from which to build and sample web matrices. Each
interaction (row in the data frame) must be repeated as many times as it was
observed. E.g. if the interaction species_1 x species_2 was observed 5
times, then repeat that row 5 times within the data frame. See examples
below.}

\item{col_lower}{Quoted column name in \code{data} for lower trophic level species (plants).}

\item{col_higher}{Quoted column name in \code{data} for higher trophic level species (insects).}

\item{index}{Passed to \code{\link[bipartite]{networklevel}}. See
\code{?bipartite::networklevel} for details.}

\item{level}{Passed to \code{\link[bipartite]{networklevel}}. See
\code{?bipartite::networklevel} for details. For which level should the
level-specific indices be computed: 'both' (default), 'lower' or 'higher'?}

\item{start}{Integer. The sample size (number of interactions) to start the bootstrap
with. If the start sample size is small (e.g. 5 or 10), then first
iterations might results in NaN-s and warning messages are displayed.
Consider to set \code{start} to maybe 10\\\% of your total unique interactions.}

\item{step}{Integer. Sample size (number of interactions) used to increase gradually the
sampled network until all interactions are sampled. If \code{step} is too small
(e.g. 1) then the computation time is very long depending on your total
number of interactions from which samples are taken. Consider to set \code{step}
to maybe 5-10\\\% of your total unique interactions.}

\item{n_boot}{Number of desired bootstraps (50 or 100 can be enough).}

\item{n_cpu}{Number of CPU-s to use for parallel processing.}

\item{...}{Other arguments passed to \code{\link[bipartite]{networklevel}} like
\code{logbase}, etc.}
}
\value{
Returns a list of a single matrix or a list of two matrices depending on the
provided \code{index} metric and \code{level} value. For example if
\code{index='nestedness'} and \code{level='both'}, then it returns a list of a single
matrix. But in the case of \code{index='niche overlap'}, it returns a list of two
matrices, first matrix (\code{niche.overlap.HL}) corresponding to the higher level
(e.g. insects), and the second (\code{niche.overlap.LL}) for the lower level (e.g.
plants). The number of rows of a matrix indicates how many iterations took
place. This is decided internally based on the given values to \code{start},
\code{step} and the total number of rows (interactions) in \code{data}.The row names
give the sample size at each iteration. The last iteration (last row name) is
always the entire network (total number of interactions in \code{data}). The
number of columns corresponds to \code{n_boot} (number of bootstraps).
}
\description{
Bootstrap a single network of interactions n times in parallel and collects
the network level metrics. Starts with a small sample size of interactions
(e.g. \code{start = 30}), builds the corresponding web matrix/network, computes
its metric (e.g. \code{index = "nestedness"}) using
\code{\link[bipartite]{networklevel}}, then adds new interactions (e.g.
\code{step = 20}) until all interactions are sampled. The last sample is actually
the entire network. Repeats n times (as given in \code{n_boot}) these steps in
parallel on multiple CPUs.
}
\examples{

library(bootstrapnet)
library(magrittr)
library(bipartite)
data(Safariland)

Safariland \%>\%
  web_matrix_to_df() \%>\%
  boot_networklevel_n(col_lower = "lower", # column name for plants
                      col_higher = "higher", # column name for insects
                      index = "niche overlap",
                      level = "both",
                      start = 100,
                      step = 100,
                      n_boot = 10,
                      n_cpu = 2)

}
