context("Testing get_microdata")
library(haven)
test_that("download and read data", {
  testthat::expect_error(get_microdata(year = "2018", folder = tempdir(), toR = TRUE))
  # a <- get_microdata(year = "2016", folder = tempdir(), toR = TRUE))
  # testthat::expect_equal(ncol(a),573)
  testthat::expect_error(get_microdata(year = "2010", folder = tempdir(), toR = FALSE))
  testthat::expect_error(get_microdata(year = "2016", folder = tempdir(), toR = FALSE))
  # b <- get_microdata(year = "2016", folder = tempdir(), toR = FALSE)
  # testthat::expect_equal(ncol(b),573)
  testthat::expect_error(get_microdata(folder = tempdir(), toR = FALSE))
  testthat::expect_error(get_microdata(folder = 1, toR = FALSE))

  # aaa <- haven::read_sav(paste0(tempdir(),"\\HyP_2016_Terceros.sav"))
  # testthat::expect_is(aaa, "data.frame")
  # testthat::expect_equal(nrow(aaa), 118591L)
  testthat::expect_error(get_marco(year = "2011", folder = tempdir(), toR = TRUE))
  testthat::expect_error(get_marco(year = "2011", folder = tempdir(), toR = FALSE))
  testthat::expect_error(get_marco(year = "2010", folder = tempdir(), toR = FALSE))
  testthat::expect_error(get_marco(folder = 1, toR = FALSE))
})

context("Testing get_dictionary")
test_that("download dictionaries", {
  testthat::expect_error(get_dictionary(year = 2010, folder = tempdir()))
  get_dictionary(year = 2019, folder = tempdir())
  archivo <- fs::dir_ls(tempdir(), regexp = "\\.xls$")
  archivo <- archivo[which.max(file.info(archivo)$mtime)]
  testthat::expect_equal(length(archivo), 1)
  get_dictionary(year = NULL, folder = tempdir())
  archivo <- fs::dir_ls(tempdir(), regexp = "\\.xls$")
  archivo <- archivo[which.max(file.info(archivo)$mtime)]
  testthat::expect_equal(length(archivo), 1)
  testthat::expect_error(get_dictionary(folder = 1))
})
