test_that("get_ipc works", {
  ipc_base2010 <- get_ipc(folder = tempdir())
  testthat::expect_true("ipc_base2010" %in% ls())
  ipc_region_m <- get_ipc_region(folder = tempdir(), region = "M")
  testthat::expect_equal(nrow(ipc_region_m), 36)
  ipc_region_i <- get_ipc_region(folder = tempdir(), region = "I")
  testthat::expect_equal(nrow(ipc_region_i), 36)
  cba_cbna_m <- get_cba_cbna(folder = tempdir(), sheet = 1, region = "M")
  testthat::expect_equal(nrow(cba_cbna_m), 235)
  cba_cbna_i <- get_cba_cbna(folder = tempdir(), sheet = 1, region = "I")
  testthat::expect_equal(nrow(cba_cbna_i), 235)
  cba_cbna_r <- get_cba_cbna(folder = tempdir(), sheet = 1, region = "R")
  testthat::expect_equal(nrow(cba_cbna_r), 235)
  ipab <- get_ipab(folder = tempdir(), sheet = 1)
  testthat::expect_equal(nrow(ipab), 226)
  df <- basket_goods(data = ech::cba_cbna_mdeo, year = 2018)
  testthat::expect_equal(nrow(df), 12)
})
