test_that("get_estimation_mean works", {
  df = ech::toy_ech_2018
  a <- get_estimation_mean(data = df, variable = "pobre06", level = "h", name = "hogares_pobre_mean")
  expect_equal(nrow(a), 2)
  a <- get_estimation_mean(data = df, variable = "pobre06", domain = "dpto == 1", level = "h")
  expect_equal(nrow(a), 2)
  a <- get_estimation_mean(data = df, variable = "pobre06", by.x = "mes", domain = "dpto == 1", level = "h")
  expect_equal(nrow(a), 18)
  a <- get_estimation_mean(data = df, variable = "pobre06", by.x = "region_4", level = "h")
  expect_equal(nrow(a), 8)
  a <- get_estimation_mean(data = df, variable = "pobre06", by.x = "dpto", by.y = "e26", level = "h")
  expect_equal(nrow(a), 49)
  a <- get_estimation_mean(data = df, variable = "pobre06", by.x = "e26", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(a), 35)

  b <- get_estimation_mean(data = df, variable = "ht11", level = "h", name = "hogares_pobre_mean")
  expect_equal(nrow(b), 1)
  b <- get_estimation_mean(data = df, variable = "ht11", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 1)
  b <- get_estimation_mean(data = df, variable = "ht11", by.x = "mes", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 12)
  b <- get_estimation_mean(data = df, variable = "ht11", by.x = "dpto", level = "h")
  expect_equal(nrow(b), 19)
  b <- get_estimation_mean(data = df, variable = "ht11", by.x = "dpto", by.y = "mes", level = "h")
  expect_equal(nrow(b), 149)
  b <- get_estimation_mean(data = df, variable = "ht11", by.x = "secc", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(b), 117)
})

test_that("get_estimation_total works", {
  df = ech::toy_ech_2018
  a <- get_estimation_total(data = df, variable = "pobre06", level = "h", name = "hogares_pobre_total")
  expect_equal(nrow(a), 2)
  a <- get_estimation_total(data = df, variable = "pobre06", domain = "dpto == 1", level = "h")
  expect_equal(nrow(a), 2)
  a <- get_estimation_total(data = df, variable = "pobre06", by.x = "mes", domain = "dpto == 1", level = "h")
  expect_equal(nrow(a), 18)
  a <- get_estimation_total(data = df, variable = "pobre06", by.x = "dpto", level = "h")
  expect_equal(nrow(a), 26)
  a <- get_estimation_total(data = df, variable = "pobre06", by.x = "dpto", by.y = "e26", level = "h")
  expect_equal(nrow(a), 49)
  a <- get_estimation_total(variable = "pobre06", by.x = "secc", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(a), 123)

  b <- get_estimation_total(data = df, variable = "ht11", level = "h", name = "hogares_pobre_total")
  expect_equal(nrow(b), 1)
  b <- get_estimation_total(data = df, variable = "ht11", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 1)
  b <- get_estimation_total(data = df, variable = "ht11", by.x = "mes", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 12)
  b <- get_estimation_total(data = df, variable = "ht11", by.x = "dpto", level = "h")
  expect_equal(nrow(b), 19)
  b <- get_estimation_total(data = df, variable = "ht11", by.x = "dpto", by.y = "mes", level = "h")
  expect_equal(nrow(b), 149)
  b <- get_estimation_total(data = df, variable = "ht11", by.x = "secc", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(b), 117)

  df <- housing_situation(data = ech::toy_ech_2018)
  b <- get_estimation_total(data = df, variable = "housing_situation", level = "h", name = "hogares_pobre_total")
  expect_equal(nrow(b), 4)
  b <- get_estimation_total(data = df, variable = "housing_situation", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 4)
  b <- get_estimation_total(data = df, variable = "housing_situation", by.x = "mes", domain = "dpto == 1", level = "h")
  expect_equal(nrow(b), 39)
  b <- get_estimation_total(data = df, variable = "housing_situation", by.x = "dpto", level = "h")
  expect_equal(nrow(b), 54)
  b <- get_estimation_total(data = df, variable = "housing_situation", by.x = "dpto", by.y = "mes", level = "h")
  expect_equal(nrow(b), 248)
  b <- get_estimation_total(data = df, variable = "housing_situation", by.x = "secc", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(b), 155)
})

test_that("get_estimation_ratio works", {
  ech_2018 <- employment(data = ech::toy_ech_2018, pobpcoac = "pobpcoac")
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", level = "i", name = "tasa_ocupacion")
  expect_equal(nrow(a), 1)
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", domain = "dpto == 1", level = "i")
  expect_equal(nrow(a), 1)
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", domain = "dpto == 1", by.x = "mes", level = "i")
  expect_equal(nrow(a), 12)
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", by.x = "dpto", level = "i")
  expect_equal(nrow(a), 19)
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", by.x = "dpto", by.y = "mes",level = "i")
  expect_equal(nrow(a), 149)
  a <- get_estimation_ratio(data = ech_2018, variable.x = "pd", variable.y = "pea", by.x = "secc", by.y = "mes", domain = "dpto == 1", level = "i")
  expect_equal(nrow(a), 117)
})

test_that("get_estimation_gini works", {
  ech_2018 <- income_constant_prices(data = ech::toy_ech_2018, ipc = "R",
                               base_month = "01", base_year = "2005")
  a <- get_estimation_gini(data = ech_2018, variable = "y_wrv_pc_d_r", level = "h", name = "indice_gini")
  expect_is(a, "cvystat")
})
