% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/income.R
\name{income_constant_prices}
\alias{income_constant_prices}
\title{income_constant_prices}
\usage{
income_constant_prices(
  data = ech::toy_ech_2018,
  base_month = 6,
  base_year = 2018,
  ipc = "G",
  mes = "mes",
  ht11 = "ht11",
  ht13 = "ht13",
  ht19 = "ht19"
)
}
\arguments{
\item{data}{data.frame with ECH microdata}

\item{base_month}{baseline month}

\item{base_year}{baseline year}

\item{ipc}{General ("G") or Regional ("R")}

\item{mes}{month}

\item{ht11}{Variable name of income. Default: ht11}

\item{ht13}{Variable name of rental value. Default: ht13}

\item{ht19}{Variable name of number of individuals in the household. Default: ht19}
}
\value{
data.frame
}
\description{
This function allows you to calculate the household income constant prices
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_2018 <- income_constant_prices(data = ech::toy_ech_2018)
}
}
