% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_DDModel.R
\name{Sim_DDModel}
\alias{Sim_DDModel}
\title{Function to simulate a given DDModel}
\usage{
Sim_DDModel(model = NULL, trials = 1000L, simulations = 1L, parameter = NULL)
}
\arguments{
\item{model}{\code{\linkS4class{DDModel}} object to be used in the simulation.}

\item{trials}{\code{integer} specifying the number of trials per condition.}

\item{simulations}{\code{integer} specifying the number of simulations}

\item{parameter}{\code{Data.frame} containing parameters that should be simulated}
}
\value{
\code{DDRep} object or \code{list} of \code{DDRep} depending on the input
}
\description{
Function to simulate a given DDModel
}
\details{
If 'parameter' is specified the function will undergo nrow(parameter) times simulation calls.
Depending on the input the return value will be either a \code{DDRep}, \code{list} or \code{list} of \code{lists}.
}
\examples{
# Define a Model
M1 <- DDModel(model="DSTP",task = "flanker",
          CDF_perc = c(0.1,0.3,0.5,0.7,0.9),CAF_perc = c(0.0,0.2,0.4,0.6,0.8,1.0))
# Simulate some Data with randomly generated parameters in the domain of M1
R1 <- Sim_DDModel(M1,10000L)
# If you want to reuse the randomly drawn parameters (or any other) simply insert them
R2 <- Sim_DDModel(M1,10000L,parameter = R1@PAR)
}
