% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRID.R
\name{Generate_GRID}
\alias{Generate_GRID}
\title{Generates a Grid from a given DDModel}
\usage{
Generate_GRID(model = NULL, path = NULL, name = NULL, eval_pts = NULL)
}
\arguments{
\item{model}{\code{DDModel} object}

\item{path}{\code{character} that specifies the full path to the directory in which the Grid should be saved}

\item{name}{\code{character} that represents the name of the Grid (and indirectly the name of the subdirectory set in the directory specified in path)}

\item{eval_pts}{\code{numeric} vector containing number of evaluation points of the parameters in the grid}
}
\value{
The path to the grid as a \code{character}
}
\description{
Generates a Grid from a given DDModel
}
\details{
Eval_pts specifies the number of evaluation points per parameter that are used in the grid, such the number of integers in
eval_pts needs to match the number of parameters in the model. Note that in the given function the evaluation points are allways equally spaced concerning the corresponding parameter domain in the used model.
Therefor, if one would like to specify the used evaluation points it is advised to specify the domain in the model.
}
