# ------------------------------ LOAD LIBRARIES -------------------------------
import pandas as pd
import numpy as np
from scipy.interpolate import splev, splrep, splder, sproot

import matplotlib.pyplot as plt

# ------------------------------- DEFINITIONS ---------------------------------
def quadratic_spline_roots(spline):
    roots = []
    assert spline[2] == 2
    knots = spline[0]
    for a, b in zip(knots[:-1], knots[1:]):
        u, v, w = splev(a, spline), splev((a + b) / 2, spline), splev(b, spline)
        t = np.roots([u + w - 2 * v, w - u, 2 * v])
        t = t[np.isreal(t) & (np.abs(t) <= 1)]
        roots.extend(t * (b - a) / 2 + (b + a) / 2)
    return np.array(roots)

# -------------------------------- PARAMETERS ---------------------------------   
H = [0.008, 0.004, 0.002]
DT_inv = [25, 50, 100]

for i, (h, dt_inv) in enumerate(zip(H, DT_inv)):
    # --------------------------------- DATA ----------------------------------
    file_in = "Output_TimeDepTest_diam0.022mu0.008rho1141_iso-hmax{:}dtinv{:.1f}BDF2.txt".format(h, dt_inv)
    data = pd.read_csv(file_in, sep="\t")
    m = len(data)


    # ------------------------------ PROCESSING -------------------------------
    results = {"vals": {}, "time": {}}
    for force in ["drag_r", "drag_z"]:
        t = np.linspace(data['time'].iloc[1], data['time'].iloc[-2] , int(m / 10))
        spl = splrep(x=data['time'], y=data[force], k=3, task=-1, t=t)
        spl_dt = splder(spl)
        cr_pnts = quadratic_spline_roots(spl_dt)
        cr_vals = splev(cr_pnts, spl)

        i_max = np.argmax(cr_vals)
        results["time"][force] = cr_pnts[i_max]
        results["vals"][force] = cr_vals[i_max]


    print(" & {} & \\nf{{1}}{{{}}} & & & \\num{{{:8.6e}}} & {:5.3f}\\\\".format(
        h, dt_inv, results["vals"]["drag_z"], results["time"]["drag_z"]))