import sys

import numpy as np
from scipy import interpolate
import matplotlib.pyplot as plt



# read dataset file name
assert len(sys.argv)==4,'call: python evaluation.py dataset.txt h0 radius'
datasetname = sys.argv[1]
print(datasetname)

# rubber
h0 = float(sys.argv[2])
r  = float(sys.argv[3])
mindist = 2*r


# load data
data = np.loadtxt(datasetname)

# in 2d: 5 entries
assert data.shape[1] == 5,'expect dataset with 5 columns: T dy vy fx fy'

# no of data sets
dt = data[1,0]-data[0,0]

# shorten data set
N = len(data[:,1])
NMD0 = min(np.argmax(data[:,1]<(h0-r)),len(data[:,1]))

# cubic spline interpolation
dT0 = data[max(0,NMD0-10):min(N,NMD0+10),0]
dY0 = data[max(0,NMD0-10):min(N,NMD0+10),1]-(h0-r)
dV0 = data[max(0,NMD0-10):min(N,NMD0+10),2]
dF0 = data[max(0,NMD0-10):min(N,NMD0+10),4]

sY0 = interpolate.CubicSpline(dT0,dY0,bc_type='natural')
sV0 = interpolate.CubicSpline(dT0,dV0,bc_type='natural')
sF0 = interpolate.CubicSpline(dT0,dF0,bc_type='natural')

roots0 = sY0.roots()
roots0 = roots0[roots0>dT0[0]]
roots0 = roots0[roots0<dT0[-1]]
assert (len(roots0)==1)
t0 = roots0[0]


### Tstar
NMDs = min(np.argmax(data[:,1]<mindist),len(data[:,1]))

# cubic spline interpolation
dTs = data[NMDs-10:min(N,NMDs+10),0]
dYs = data[NMDs-10:min(N,NMDs+10),1]-mindist 
dVs = data[NMDs-10:min(N,NMDs+10),2]
dFs = data[NMDs-10:min(N,NMDs+10),4]

sYs = interpolate.CubicSpline(dTs,dYs,bc_type='natural')
sVs = interpolate.CubicSpline(dTs,dVs,bc_type='natural')
sFs = interpolate.CubicSpline(dTs,dFs,bc_type='natural')

rootss = sYs.roots()
rootss = rootss[rootss>dTs[0]]
rootss = rootss[rootss<dTs[-1]]
assert (len(rootss)==1)
tstar = rootss[0]




print('&&{0}&&&{1} & {2} & {3}'.format(1/dt,tstar-t0,sVs(tstar),sFs(tstar)))
