#!/bin/bash

# Get the NGSolve sources and build the directory structure
# Alternatively, prebuilt versions of NGSolve can be downloaded from 
# https://ngsolve.org/downloads

export BASE=`pwd`
mkdir ${BASE}/NGSolve
cd ${BASE}/NGSolve
git clone https://github.com/NGSolve/ngsolve.git src-ngs
cd src-ngs
git checkout v6.2.2008
git submodule update --recursive --init
cd ..
mkdir inst
mkdir build-ngs
cd build-ngs

# The cmake options may depend on you OS and on the location of libraries such 
# as Intel MKL. For more options and OS specifics, see
# https://ngsolve.org/docu/v6.2.2008/install/install_sources.html

cmake \
-DCMAKE_BUILD_TYPE=RELEASE \
-DMKL_ROOT=/opt/intel/mkl \
-DCMAKE_INSTALL_PREFIX=${BASE}/NGSolve/inst \
-DUSE_GUI=OFF \
-DUSE_UMFPACK=ON \
-DUSE_MKL=ON \
-DUSE_MPI=OFF \
-DCMAKE_CXX_COMPILER=g++ \
-DCMAKE_C_COMPILER=gcc \
../src-ngs/

make -j4
make install


# Now download the ngs-xfem sources.

cd ${BASE}/NGSolve
git clone git@gitlab.gwdg.de:lehrenfeld/ngsxfem.git src-xfem
cd src-xfem
git checkout v1.3.2008
cd ..

mkdir build-xfem
cd build-xfem

# For details see https://github.com/ngsxfem/ngsxfem/tree/v1.3.2008#installation

cmake \
-DCMAKE_INSTALL_PREFIX=${BASE}/NGSolve/inst \
-DBUILD_NGSOLVE=OFF \
-DBUILD_STUB_FILES=OFF \
../src-xfem/

make -j4
make install

# Now the executables in NGSolve/inst/bin (OS specific location!) have to be 
# added to the PATH variable and the location of the python libraries (OS and 
# python version specific) have to be added to the PYTHONPATH variable.