/**
*
* Copyright (C) 2020 by the Gascoigne 3D authors
*
* This file is part of Gascoigne 3D
*
* Gascoigne 3D is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation, either
* version 3 of the License, or (at your option) any later
* version.
*
* Gascoigne 3D is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE.  See the GNU General Public License for more
* details.
*
* Please refer to the file LICENSE.TXT for further information
* on this license.
*
**/



#include  "problemcontainer.h"
#include  "functionalcontainer.h"
#include  "stdloop.h"

#include  "problems.h"
#include  "loop.h"
#include  "functionals.h"



/*---------------------------------------------------*/



////////////////////

int main(int argc, char** argv)
{
  // Set the name of the parameter file. 
  Gascoigne::ParamFile paramfile("stationary-rubber.param");
  if(argc>=2) {
    paramfile.SetName(argv[1]);
  }

  
  Gascoigne::FlowProblem FP;
  FP.BasicInit(paramfile);

  Gascoigne::ProblemContainer PC;
  PC.AddProblem("stationaryflow",    &FP);

  // Functionals
  Gascoigne::FunctionalContainer FC;
  Gascoigne::ForceFunctional drag("2dx");
  FC.AddFunctional("0 drag",&drag);
  Gascoigne::ForceFunctional lift("2dy");
  FC.AddFunctional("1 lift",&lift);
  
  Loop loop;
  loop.BasicInit(FP.GetData(),paramfile, &PC, &FC);
  loop.run_stationary();

  return 0;
}
