/**
*
* Copyright (C) 2020 by the Gascoigne 3D authors
*
* This file is part of Gascoigne 3D
*
* Gascoigne 3D is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation, either
* version 3 of the License, or (at your option) any later
* version.
*
* Gascoigne 3D is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE.  See the GNU General Public License for more
* details.
*
* Please refer to the file LICENSE.TXT for further information
* on this license.
*
**/


#include  "problemcontainer.h"
#include  "functionalcontainer.h"
#include  "stdloop.h"

#include  "problems.h"
#include  "loop.h"
#include  "functionals.h"

/*---------------------------------------------------*/



int main(int argc, char** argv)
{
  // Set the name of the parameter file. 
  Gascoigne::ParamFile paramfile("falling-rubber3d-22.param");
  if(argc>=2) {
    paramfile.SetName(argv[1]);
  }

  
  Gascoigne::FlowProblem FP;
  FP.BasicInit(paramfile);

  Gascoigne::NonstationaryFlowProblem3d NFP;
  NFP.BasicInit(paramfile);
  
  
  Gascoigne::ProblemContainer PC;
  PC.AddProblem("stationaryflow",    &FP);
  PC.AddProblem("nonstationaryflow", &NFP);

  // Functionals
  Gascoigne::FunctionalContainer FC; 
  Gascoigne::ForceFunctional d3x("3dx"); FC.AddFunctional("1 - x",&d3x);
  Gascoigne::ForceFunctional d3y("3dy"); FC.AddFunctional("2 - y",&d3y);
  Gascoigne::ForceFunctional d3z("3dz"); FC.AddFunctional("3 - z",&d3z);

  Gascoigne::ForceFunctional t1("t1");   FC.AddFunctional("4 - x",&t1);
  Gascoigne::ForceFunctional t2("t2");   FC.AddFunctional("5 - y",&t2);
  Gascoigne::ForceFunctional t3("t3");   FC.AddFunctional("6 - z",&t3);

  Loop loop;
  loop.BasicInit(FP.GetData(),
		 paramfile, &PC, &FC);
  loop.run_fallingball3d();

  return 0;
}
