/*----------------------------   problemdata.h     ---------------------------*/
/*      $Id:$                 */
#ifndef __problemdata_H
#define __problemdata_H
/*----------------------------   problemdata.h     ---------------------------*/



#include "numfixarray.h"
#include "paramfile.h"

namespace Gascoigne
{

  /**
   * Stores all the data required in the program that is 
   * defined in the parameter file
   * This class is used in the equation but also within 
   * Dirichlet data, right hand side, ...
   **/
  class ProblemData
  {
  public:
    
    double alpha;             // parameter for the lps stabilization
    double rho_f,rho_s,mu_f;  // material parameters

    double radius;            // radius of ball
    double cyl_radius;       // outer radius of domain (in 3d)
    

    // parameters for time-stepping
    // bdf1 is used in the first time step
    mutable bool bdf1; // true: bdf1, false: bdf2
    double dt;


    // variables to store the state of the rigid body. Also we store
    // the old state and the second last approximation, used for time
    // stepping with the BDF2 method
    
    // 2d: location (measured as (0,0.1 + def)) and velocity of sphere
    mutable double vel,def, velold,defold, veloldold,defoldold;    

    // 3d: location, velocity and rotational velocity
    mutable numfixarray<3,double> vel3d, velold3d,veloldold3d;
    mutable numfixarray<3,double> def3d, defold3d,defoldold3d;
    mutable numfixarray<3,double> rot3d, rotold3d,rotoldold3d;
    
    void BasicInit(const ParamFile &pf);
  };

}

/*----------------------------   problemdata.h     ---------------------------*/
/* end of #ifndef __problemdata_H */
#endif
/*----------------------------   problemdata.h     ---------------------------*/
