#include "problemdata.h"
#include "filescanner.h"

////////////////////////////////////////////////// DATA

namespace Gascoigne
{

  void ProblemData::BasicInit(const ParamFile &pf)
  {
    DataFormatHandler DFH;
    DFH.insert("rho_f", &rho_f, 0.);
    DFH.insert("rho_s", &rho_s, 0.);
    DFH.insert("mu_f",  &mu_f,  0.);
    DFH.insert("alpha", &alpha, 0.);
    DFH.insert("dt",    &dt, 0.);
    DFH.insert("radius",&radius, 0.);

    DFH.insert("cylinderradius",&cyl_radius, 0.);
    FileScanner FS(DFH, pf, "Equation");
    assert(mu_f>0);
    assert(alpha>0);
    assert(rho_f>0);
    assert(rho_s>0);
    assert(radius>0);
  }
}
