import sys

import numpy as np
from scipy import interpolate
import matplotlib.pyplot as plt



# read dataset file name
assert len(sys.argv)==3,'call: python evaluation.py dataset.txt radius'
datasetname = sys.argv[1]
print(datasetname)

# rubber
r = float(sys.argv[2])
mindist = 3*r


print('minimal distance',mindist)

# load data
data = np.loadtxt(datasetname)

# in 2d: 5 entries
assert data.shape[1] == 5,'expect dataset with 5 columns: T dy vy fx fy'

# no of data sets
N = data.shape[0]
assert N>1
dt = data[1,0]-data[0,0]

# cubic spline interpolation
dT = data[:,0]
dY = data[:,1]+0.1-mindist 
dV = data[:,2]
dF = data[:,4]

sY = interpolate.CubicSpline(dT,dY,bc_type='natural')
sV = interpolate.CubicSpline(dT,dV,bc_type='natural')
sF = interpolate.CubicSpline(dT,dF,bc_type='natural')

tstar = sY.roots()[0]

print('{0} & {1} & {2}'.format(tstar,sV(tstar),sF(tstar)))
