/*--------------/
ALH
main.cpp
EA: Evolutionary Algorithm (EA) for the SCPP
24/09/2019
/--------------*/

#include "io.h"
#include "fns.h"

int main(int argc, char** argv) {
    if(argc <= 1) {
        ProgramInfo();
        exit(1);
    }

    for(int j = 1; j < argc; ++j) {
        if(strcmp("-e", argv[j]) == 0) { timeLimit = atoi(argv[++j]); }
        else if(strcmp("-t", argv[j]) == 0) { tau = atoi(argv[++j]); }
        else if(strcmp("-W", argv[j]) == 0) { stripWidth = atoi(argv[++j]); }
        else if(strcmp("-p", argv[j]) == 0) { numPop = atoi(argv[++j]); }
        else if(strcmp("-x", argv[j]) == 0) { xOver = atoi(argv[++j]); }
        else if(strcmp("-s", argv[j]) == 0) { seed = atoi(argv[++j]); }
    }

    int numScores;
    double totalItemWidth;
    std::vector<int> allScores;
    std::vector<int> partners;
    std::vector<std::vector<int> > adjMatrix;
    std::vector<std::vector<int> > itemWidths;
    std::vector<std::vector<int> > itemNumbers;
    std::vector<std::vector<std::vector<int> > > population;
    std::vector<std::vector<int> > populationSum;

    srand(seed);

    std::ifstream ifs(argv[1]);
    if(!ifs) {
        std::cerr << "[ERROR]: Cannot read from file." << std::endl;
        exit(1);
    }
    CreateFromFile(ifs, numScores, totalItemWidth, allScores, partners, adjMatrix, itemWidths, itemNumbers);
    ifs.close();

    ArgumentCheck();

    int lowerBound = LowerBound(totalItemWidth);

    CreateInitPop(numScores, allScores, partners, adjMatrix, itemWidths, itemNumbers, populationSum, population);

    std::string fileNameTime;
    int n = numItem / 100;
    int w = floor(stripWidth / 1000);
    if(instType == 1) {
        fileNameTime = "TEA" + std::to_string(n) + std::to_string(w) + std::to_string(xOver) + "_" + std::to_string(tau) + "_" + std::to_string(instance) + ".txt";
    }
    else {
        fileNameTime = "TER" + std::to_string(n) + std::to_string(w) + std::to_string(xOver) + "_" + std::to_string(tau) + "_" + std::to_string(instance) + ".txt";
    }
    timeLogStream.open(fileNameTime.c_str());
    if(timeLogStream.fail()) {
        std::cerr << "[ERROR]: Cannot write to timeLogStream file." << std::endl;
        exit(1);
    }
    timeLogStream << instance << "\t" << numItem << "\t" << instType << "\t" << stripWidth << "\t" << xOver << "\t" << tau << "\t" << lowerBound << std::endl;
    timeLogStream << "#S\tFit\tTime" << std::endl;
    timeLogStream << bestSize << "\t" << bestFit << "\t0.0" << std::endl;


    Timer timer;

    while(timer.elapsed() < timeLimit) {
        EA(timer, numScores, allScores, partners, adjMatrix, itemWidths, itemNumbers, populationSum, population);
        ++numIterations;
    }

    timeLogStream.close();

    OutputEA(lowerBound);


}
