---
layout: post
title: Lee et al., 2019
---
## [Mapping person-to-person variation in viral mutations that escape polyclonal serum targeting influenza hemagglutinin](https://elifesciences.org/articles/49324)

### Abstract
> A longstanding question is how influenza virus evolves to escape human immunity, which is polyclonal and can target many distinct epitopes. Here, we map how all amino-acid mutations to influenza’s major surface protein affect viral neutralization by polyclonal human sera. The serum of some individuals is so focused that it selects single mutations that reduce viral neutralization by over an order of magnitude. However, different viral mutations escape the sera of different individuals. This individual-to-individual variation in viral escape mutations is not present among ferrets that have been infected just once with a defined viral strain. Our results show how different single mutations help influenza virus escape the immunity of different members of the human population, a phenomenon that could shape viral evolution and disease susceptibility.

### Figure 3: Mutational antigenic profiling of four human serum samples.
![Figure 3](/assets/images/lee2019mapping_fig3.jpg)

>Plot titles indicate the year the serum was collected and the age of the individual at that time. (A) Line plots show the total immune selection at each site, and logo plots show mutations at strongly selected sites. (B) Neutralization assays validate that mutations mapped to be under strong immune selection indeed have large antigenic effects. The dashed vertical lines show the serum concentrations used in the mutational antigenic profiling. We validated five amino-acid mutants against all four sera, choosing mutations for the following reasons: F193D is the most strongly selected mutation for the 21- and 65-year-old, L157D is the most selected for the 53-year-old, F159G is the most selected for the 64-year-old, K160T is modestly selected by all sera, and K189D is strongly selected by ferret sera (see below). The ‘syn’ mutant is a control with a synonymous mutation does not change the protein sequence and so should not affect antigenicity. (C) Immune selection mapped onto HA’s structure for each sera. The color scale is calibrated separately for each structure

### Figure 3: `dms-view` version

Below are links to the four patient sera shown in Figure 3.

- <a href="https://dms-view.github.io/?markdown-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Flee2019mapping.md&data-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Fflu_dms-view.csv&condition=2010-age-21&site_metric=site_Positive+Differential+Selection&mutation_metric=mut_Positive+Differential+Selection&selected_sites=144%2C157%2C159%2C160%2C189%2C193%2C222%2C224&pdb-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2F4O5N_trimer.pdb" target="_blank">Figure 3 Panel A Row 1 (2010 Age 21)</a>
- <a href="https://dms-view.github.io/?markdown-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Flee2019mapping.md&data-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Fflu_dms-view.csv&condition=2009-age-53&site_metric=site_Positive+Differential+Selection&mutation_metric=mut_Positive+Differential+Selection&selected_sites=144%2C157%2C159%2C160%2C189%2C193%2C222%2C224&pdb-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2F4O5N_trimer.pdb" target="_blank">Figure 3 Panel A Row 2 (2010 Age 53)</a>
- <a href="https://dms-view.github.io/?markdown-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Flee2019mapping.md&data-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Fflu_dms-view.csv&condition=2009-age-64&site_metric=site_Positive+Differential+Selection&mutation_metric=mut_Positive+Differential+Selection&selected_sites=144%2C157%2C159%2C160%2C189%2C193%2C222%2C224&pdb-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2F4O5N_trimer.pdb" target="_blank">Figure 3 Panel A Row 3 (2010 Age 64)</a>
- <a href="https://dms-view.github.io/?markdown-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Flee2019mapping.md&data-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2Fflu_dms-view.csv&condition=2009-age-65&site_metric=site_Positive+Differential+Selection&mutation_metric=mut_Positive+Differential+Selection&selected_sites=144%2C157%2C159%2C160%2C189%2C193%2C222%2C224&pdb-url=https%3A%2F%2Fraw.githubusercontent.com%2Fdms-view%2Fdocs%2Fmaster%2F_casestudy_data%2F4O5N_trimer.pdb" target="_blank">Figure 3 Panel A Row 4 (2010 Age 65)</a>
