Scripts used in the Ariel ML Data Challenge by the Team IWF-KNOW
================================================================

These are the scripts used to predict the relative radii of the planets in the test set from the light curves. Our solution was ranked 4th in the Ariel ML Data Challange in 2019.
See the corresponding publication [Lessons learned from the 1st Ariel Machine Learning Challenge: Correcting transiting exoplanet light curves for stellar spots](https://doi.org/10.1093/rasti/rzad050)

Authors in alphabetical order
-----------------------------

Tarek Al-Ubaidi, <talubaidi@gmail.com>, (1) DCCS, Austria, (2) Space Research Institute, Austrian Academy of Sciences, Austria  
Rachel Louise Bailey, <rachel.bailey@oeaw.ac.at>, Space Research Institute, Austrian Academy of Sciences, Austria  
Michael Granitzer, <michael.granitzer@uni-passau.de>, Chair of Data Science, University of Passau, Germany  
Sahib Julka, <sahib.julka@uni-passau.de>, Chair of Data Science, University of Passau, Germany  
Roman Kern, <rkern@know-center.at>, Know-Center GmbH - Research Center for Data-Driven Business & Big Data Analytics, Austria  
Patrick Ofner, <patrick@ofner.science>, Know-Center GmbH - Research Center for Data-Driven Business & Big Data Analytics, Austria  
Stefan Wagner, <stefan.s.wagner@gmail.com>, Commission for Astronomy, Austrian Academy of Sciences, Graz, Austria

Scripts
-------

* convert data files from the ML data challenge into CSV files:  
  01_convert_test_data.py  
  02_convert_train_data.py

* rearrange CSV files, so that a CSV file contains all instances of a planet:  
  03_rearrange_test_data.py  
  04_rearrange_train_data.py

* train model (creates the model file `model.pickle`):  
  05_train_model.py

* load model from `model.pickle`, apply it to the test data and create the result file `results.txt`:  
  06_predict_radii.py

* other files:
  * extract_features_percentile.py: non-linear feature extraction based on percentiles and feature transformation with square root
  * shrinkage_linear_regression.py: shrinkage-regularized linear regression

License
-------

Our scripts are licensed under the BSD 3-clause license:

Copyright 2020 Team IWF-KNOW

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
