#!/bin/sh

# $1: File name
# $2: "original" or "app" or "appext"
# $3: variant, e.g. "fo", "purification_ext", "supatvars_int", ...
# $4: ordering: "rpo6" or "kbo"

echo "% File    : $1"
echo "% app-encoded or not : $2"
echo "% Variant    : $3"
echo "% Ordering    : $4"
echo "% Command    : "
cat ./zp_$3.sh
/home/starexec/bin/GetComputerInfo -p THIS Model CPUModel RAMPerCPU OS | \
sed -e "s/Computer     /% Computer   /" \
    -e "s/Model        /% Model      /" \
    -e "s/CPUModel     /% CPU        /" \
    -e "s/RAMPerCPU    /% Memory     /" \
    -e "s/OS           /% OS         /"
echo -n "% CPULimit   : " ; echo "$STAREXEC_CPU_LIMIT"
echo -n "% DateTime   : " ; date


if [[ $2 == "original" ]]; then
  ./zp_$3.sh "$1" $4
elif [[ $2 == "app" ]]; then
  ./app_encode.exe "$1" -o tptp | ./zp_$3.sh "" $4
elif [[ $2 == "appext" ]]; then
  ./app_encode.exe "$1" -o tptp --app-encode-extensional | ./zp_$3.sh "" $4
else
  echo "ERROR: third argument must be \"original\" or \"app\" or \"appext\"." >&2
  exit 1
fi
