#!/usr/local/bin/python3

import re
import sys
import xmltodict
import datetime
import sys

def retrieve_spc(filename):
    file = open(filename, "r")
    regex = "^\% *SPC +: *([A-Z][A-Z][A-Z0-9])(_([A-Z][A-Z][A-Z]))?(_([A-Z][A-Z][A-Z]))?(_([A-Z][A-Z][A-Z]))?(_([A-Z][A-Z][A-Z]))?$"
    for line in file:
        m = re.search(regex, line)
        if m:
            return m.group(1,3,5,7,9)

def filter_nolambdas(filename):
    file = open(filename, "r")
    regex = "^\% +Number of variables *: *[0-9]+ \( *[0-9]+ *sgn\; *[0-9]+ *\!\; *[0-9]+ *\?\; *([0-9]+) *\^\)$"
    for line in file:
        m = re.search(regex, line)
        if m:
            return m.group(1) == "0"
    raise Exception("Number of variables not found: " + filename)

def filter_noarith(filename):
    file = open(filename, "r")
    regex = "^\% +Arithmetic symbols *: *([0-9])+"
    for line in file:
        m = re.search(regex, line)
        if m:
            return m.group(1) == "0"
    return True

def filter(filename,mode):
    spc = retrieve_spc(filename)
    if mode == "tff":
        return \
            "TF0" in spc or "TF1" in spc
    elif mode == "thf":
        return \
            "TH0" in spc or "TH1" in spc
    elif mode == "tff-noarith":
        return \
            ("TF0" in spc or "TF1" in spc) and \
            "NAR" in spc and \
            filter_noarith(filename)
    elif mode == "thf-noarith-nolambdas":
        return \
            ("TH0" in spc or "TH1" in spc) and \
            "NAR" in spc and \
            filter_nolambdas(filename)
    else:
        raise Exception("Unknown mode")

def retrieve_benchmark_names(tptp_xml_filename):
    with open(tptp_xml_filename) as fd:
        doc = xmltodict.parse(fd.read())

    benchmarks = []

    for space in doc["tns:Spaces"]["Space"]["Space"]:
        if space["@name"] == "Problems":
            for subspace in space["Space"]:
                for benchmark in subspace["Benchmark"]:
                    benchmarks.append(subspace["@name"] + "/" + benchmark["@name"])

    return benchmarks

benchmarks = retrieve_benchmark_names('./TPTP-v7.0.0.xml')
for benchmark in benchmarks:
    if filter(sys.argv[1]+"/Problems/"+benchmark,sys.argv[2]):
        print(benchmark)
