#!/usr/local/bin/python3

import xmltodict
import datetime
import sys

# Parse XML files
with open('./TPTP-v7.0.0.xml') as fd:
    doc = xmltodict.parse(fd.read())

# Load list of selected benchmarks:
selection = {}
with open(sys.argv[1]) as fd:
    for line in fd:
        selection[line.rstrip()] = True

def selected(benchmark):
    # Extract name attribute
    name = benchmark["@name"]
    # add directory name
    name = name[:3] + "/" + name
    # check if the name is listed
    return name in selection

for space in doc["tns:Spaces"]["Space"]["Space"]:
    if space["@name"] == "Problems":
        # Only keep the benchmarks in the selection
        for subspace in space["Space"]:
            benchmarks = subspace["Benchmark"]
            benchmarks[:] = [b for b in benchmarks if selected(b)]

        # Remove empty subspaces
        space["Space"][:] = \
            [s for s in space["Space"] if len(s["Benchmark"]) > 0]

        # Remove all solvers in subspaces:
        for subspace in space["Space"]:
            del subspace["Solver"]
        # Remove solvers in space "Problems"
        del space["Solver"]

# modify space name
if len(sys.argv) > 1:
    doc["tns:Spaces"]["Space"]["@name"] = sys.argv[2]
    #date = datetime.datetime.now().strftime("%Y-%m-%d_%H-%M")

print(xmltodict.unparse(doc, pretty=True))
