import csv, os

def read_csv(filename):
    with open(filename) as fd:
        content = fd.readlines()
    return list(csv.DictReader(content))

def job_output_filename(job_output_dir, dataset):
    return os.path.join(
        job_output_dir,
        os.path.dirname(dataset["benchmark"]),
        dataset["solver"]+"___"+dataset["configuration"],
        os.path.basename(dataset["benchmark"]),
        dataset["pair id"]+".txt"
    )
