#!/usr/bin/env python3

import matplotlib.pyplot as plt
import sys, argparse, os, re
from collect_data import collect
from collections import defaultdict
import matplotlib.ticker as ticker
import seaborn as sns
import pandas as pd


def plot_times(d1,d2,c1,c2):
    points = {"t1":[],"t2":[],"expected":[],"cat":[]}
    for b in d1:
        points["t1"].append(d1[b]["cpu time"])
        points["t2"].append(d2[b]["cpu time"])
        points["expected"].append(d2[b]["expected"])

        if  d1[b]["result"] in ["Theorem", "Unsatisfiable"] \
        and d2[b]["result"] in ["Theorem", "Unsatisfiable"]:
            points["cat"].append("Both Unsatisfiable")
        elif d1[b]["result"] in ["Satisfiable", "CounterSatisfiable","GaveUp"] \
        and  d2[b]["result"] in ["Satisfiable", "CounterSatisfiable","GaveUp"]:
            points["cat"].append("Both Satisfiable")
        else:
            points["cat"].append(d1[b]["result"]+" and "+d2[b]["result"])
    sns.lmplot( x="t1", y="t2", data=pd.DataFrame(points), fit_reg=False, hue='cat', legend=True)
    plt.show()
    #x=[]
    #y=[]
    #for b in d1:
    #    t1 = d1[b]["cpu time"]
    #    t2 = d2[b]["cpu time"]
        #if  d1[b]["result"] in ["Theorem", "Unsatisfiable"] \
        #and d2[b]["result"] in ["Theorem", "Unsatisfiable"]:
    #    x.append(t1)
    #    y.append(t2)

    #sns.set_style('darkgrid')

    #fig, ax = plt.subplots()
    #ax.scatter(x,y, color=red)
    #ax.set_aspect('equal')
    #ax.set_title('Bla')
    #plt.xlabel(c1)
    #plt.ylabel(c2)
    #ax.grid()
    #ax.set_xlim(xmin=0)
    #ax.set_ylim(ymin=0)
    #ax.xaxis.set_major_locator(ticker.MultipleLocator(10000))
    #ax.xaxis.set_minor_locator(ticker.MultipleLocator(1000))
    #ax.yaxis.set_major_locator(ticker.MultipleLocator(10000))
    #ax.yaxis.set_minor_locator(ticker.MultipleLocator(1000))
    #plt.show()

def stats(job_csv,job_output):
    data = collect(job_csv,job_output)
    config1 = "app_fo.sh"
    config2 = "original_fo.sh"
    d1 = data["TFF"][config1]
    d2 = data["TFF"][config2]
    plot_times(d1,d2,config1,config2)


if __name__ == "__main__":
    p = argparse.ArgumentParser('plot results')
    p.add_argument('--job_csv', help='csv file from StarExec', default=None)
    p.add_argument('--job_output', help='csv file from StarExec', default=None)
    args = p.parse_args()
    stats(args.job_csv,args.job_output)
