#!/usr/bin/env python3

import sys, argparse, os, re
from collect_data import collect
from collections import defaultdict

def stats(job_csv,job_output):
    data = collect(job_csv,job_output)

    for job in data:
        for b in data[job]["original_supatvars_int.sh"]:
            d = data[job]["original_supatvars_int.sh"][b]
            if d["result"] in ['Theorem','Unsatisfiable'] and not data[job]["app_fo.sh"][b]["result"] in ['Theorem','Unsatisfiable']:
                print (f"{b}:{data[job]['original_supatvars_int.sh'][b]['cpu time']}")


if __name__ == "__main__":
    p = argparse.ArgumentParser('analyze result file')
    p.add_argument('--job_csv', help='csv file from StarExec', default=None)
    p.add_argument('--job_output', help='csv file from StarExec', default=None)
    args = p.parse_args()
    stats(args.job_csv,args.job_output)
