#!/usr/bin/env python3

import sys, argparse, os, re
import pickle
import util
from config import JOBS_CSV, JOBS_OUTPUT, CACHE

def retrieve_steps_and_time(starexec_file):
    file = open(starexec_file, "r")
    regex = "\% done ([0-9]+) iterations in ([0-9\.]+)s$"
    for line in file:
        m = re.search(regex, line)
        if m:
            return (int(m.group(1)),float(m.group(2)))

def collect(jobs_csv=None,jobs_output=None,cachefile=None):
    if jobs_csv == None:
        jobs_csv = JOBS_CSV
    if jobs_output == None:
        jobs_output = JOBS_OUTPUT
    if cachefile == None:
        cachefile = CACHE
    if os.path.isfile(cachefile):
        file = open(cachefile,"rb")
        return pickle.load(file)
    else:
        data = collect_nocache(jobs_csv,jobs_output)
        if cachefile != None:
            file = open(cachefile,"wb")
            pickle.dump(data,file)
        return data

def collect_nocache(jobs_csv,jobs_output):
    data = {}
    for job in jobs_csv:
        job_csv = jobs_csv[job]
        job_output = jobs_output[job]
        # Read CSV
        starexec_table = util.read_csv(job_csv)

        # Add steps and time
        for row in starexec_table:
            starexec_file = util.job_output_filename(job_output,row)
            row["job_output_file"] = starexec_file
            if retrieve_steps_and_time(starexec_file) != None:
                row["zp_steps"], row["zp_time"] = retrieve_steps_and_time(starexec_file)
            else:
                row["zp_steps"], row["zp_time"] = None, None

        # Order by config
        d = {}
        for row in starexec_table:
            key = row["configuration"]
            if key not in d:
                d[key] = {}
            row["cpu time"] = float(row["cpu time"])
            row["wallclock time"] = float(row["wallclock time"])
            d[key][row["benchmark"]] = row
        data[job] = d
    return data

if __name__ == "__main__":
    p = argparse.ArgumentParser('analyze result file')
    p.add_argument('--job_csv', help='csv file from StarExec', default=None)
    p.add_argument('--job_output', help='csv file from StarExec', default=None)
    args = p.parse_args()
    collect(args.job_csv,args.job_output)
