#!/bin/sh

#SBATCH -n 24
#SBATCH --partition=256g
#SBATCH --mem-per-cpu=8gb

# reduce.sh
# Clark Evans, 20 February 2020
# Runs a full CM1 full BSS restart case automatically.
# Need to change case name and reduction increment each time.

# Load needed modules.
module load icc/15.2
module load openmpi/1.10.7
module load netcdf-4.6.2

# OpenMP threads variable...
export OMP_NUM_THREADS=24

# Change into your cm1/run directory.
cd *****

# Change known-good namelist for the first 3 h,
# then run the model.
sed "21c\ run_time = 10800.0," namelist.input.good | sed "198c\ output_basename  = 'cm1out_reduce7Kfull'" > namelist.input
./cm1.exe
rm cm1out_reduce7Kfull_rst_0000*.nc cm1out_reduce7Kfull_rst_0001[0-6]*.nc

# Loop over the next 61 times to implement BSS.
# Our first time to do so is 180, so loop from there.
# Note: inc = num/61 equals the theta value to
# reduce by (e.g., 7 = reduce by 7 K).
loop=1
while [ $loop -le 61 ]
do
  rest=`expr $loop + 179`
  sed "21c\ run_time = 60.0," namelist.input.good | sed "32c\ irst      =  1," | sed "33c\ rstnum    = ${rest}," | sed "198c\ output_basename  = 'cm1out_reduce7Kfull'" > namelist.input
  sed "4c fname=('cm1out_reduce7Kfull_rst_000${rest}.nc');" bss_full_T.m | sed "12c inc = 7/61;" | sed "42c ncwrite('cm1out_reduce7Kfull_rst_000${rest}.nc','tha',tha);" > script.m
  matlab -nojvm -nodisplay -nosplash -r "run script.m"
  ./cm1.exe
  loop=`expr $loop + 1`
done

# Run the last two hours of the simulation.
sed "21c\ run_time = 7200.0," namelist.input.good | sed "32c\ irst      = 1," | sed "33c\ rstnum     = 241," | sed "198c\ output_basename  = 'cm1out_reduce7Kfull'" > namelist.input
./cm1.exe

# Purge restart files.
rm cm1out_reduce7Kfull_rst*

# All done!
exit
