#!/bin/sh
#SBATCH -n 24
#SBATCH --partition=256g
#SBATCH --mem-per-cpu=8g

# control.sh
# Clark Evans, 21 February 2020
# Runs a full CM1 control simulation.

# Load needed modules.
module load icc/15.2
module load openmpi/1.10.7
module load netcdf-4.6.2

# OpenMP threads variable...
export OMP_NUM_THREADS=24

# Change into your cm1/run directory.
cd *****

# Change known-good namelist to suppress restart
# file creation, then run the model (OpenMP).
sed "23c\ rstfrq =  21600.0," namelist.input.good > namelist.input
./cm1.exe

# Purge restart files.
rm cm1out_control_rst*

# All done!
exit
