%% This script edits the wind profile of restart files (NetCDF format) for CM1 Simulations

%% Read in Data
fname=('cm1out_reduce5msfull_rst_000240.nc');

ncid = netcdf.open(fname,'WRITE');
varid = netcdf.inqVarID(ncid,'zh');  %get the variable id number c
zh = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'ua');  %get the variable id number 
ua = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'theta');  %get the variable id number 
theta = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'th0');  %get the variable id number 
th0 = netcdf.getVar(ncid,varid);   %read the data


%% Compute the difference in initial vs. environmental theta to determine where wind speeds will change.
% Then use this anomaly to apply the changes to the wind speed

thanom = theta-th0; 

inc = 10/61;


%% Create a vector of new wind speeds that takes into account the wind increase
for k=1:20
    perc(k,:) = zh(k,:)/zh(20,:);   %Computes the percentage of the wind increase that needs to                                          
end                                         %be accounted for in the profile

%% Decrease to 10m/s

for k = 1:20
    udif(k) = perc(k,:) * inc;
    for k = 21:100
        udif(k) = inc;
    end
end 

udif = udif';


%% Change all points
for i=1:800                         %Loop over all 800 points in x-direction
    for j=1:680   %Loop over all 680 points in y-direction    
        for k = 1:100
            ua(i,j,k)= ua(i,j,k) - udif(k);
        end
    end 
end

% RE-write file to same filename with new u-wind values
ncwrite('cm1out_reduce5msfull_rst_000240.nc','ua',ua);
exit
