%% This script edits the wind profile of restart files (NetCDF format) for CM1 Simulations

%% Read in Data
fname=('cm1out_reduce7Kfull_rst_000240.nc');

ncid = netcdf.open(fname,'WRITE');
varid = netcdf.inqVarID(ncid,'zh');  %get the variable id for zh
zh = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'tha');  %get the variable id for tha
tha = netcdf.getVar(ncid,varid);   %read the data

inc = 7/61;


%% Compute the percentage of the potential temperature decrease to account for at each height.
%% Maximum change at the lowest model level, zero change above level 9 (946.97 m).
for k=1:9
    perc(k,:) = 1.0-(zh(k,:)-zh(1,:))/(zh(9,:)-zh(1,:));
end

%% Decrease by specified change.
for k = 1:9
    thdif(k) = perc(k,:) * inc;
    for k = 10:100
        thdif(k) = 0.0;
    end
end 

thdif = thdif';


%% Change all points
for i=1:800                         %Loop over all 800 points in x-direction
    for j=1:680   %Loop over all 680 points in y-direction    
        for k = 1:100
            tha(i,j,k)= tha(i,j,k) - thdif(k);
        end
    end 
end

% RE-write file to same filename with new u-wind values
ncwrite('cm1out_reduce7Kfull_rst_000240.nc','tha',tha);
exit
