%% This script edits the wind profile of restart files (NetCDF format) for CM1 Simulations

%% Read in Data
fname=('cm1out_reduce7K_rst_000240.nc');

ncid = netcdf.open(fname,'WRITE');
varid = netcdf.inqVarID(ncid,'zh');  %get the variable id for zh
zh = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'ua');  %get the variable id for ua 
ua = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'tha');  %get the variable id for tha (perturbation potential temp)
tha = netcdf.getVar(ncid,varid);   %read the data
varid = netcdf.inqVarID(ncid,'th0');  %get the variable id for base-state theta
th0 = netcdf.getVar(ncid,varid);   %read the data


%% Increment amount per time; time step (1->61, updated by csh script); and anomaly specification.
%% Numerator on inc = total cooling at surface (7 K -> ~1 km deep approx. isothermal layer).

inc = 7/61;
time = 61;
thanom = (tha+(inc*time*1.0));

%% Compute the percentage of the potential temperature decrease to account for at each height.
%% Maximum change at the lowest model level, zero change above level 9 (946.97 m); should be level 10...
for k=1:9
    perc(k,:) = 1.0-(zh(k,:)-zh(1,:))/(zh(9,:)-zh(1,:));
end

%% Decrease by specified change.
for k = 1:9
    thdif(k) = perc(k,:) * inc;
    for k = 10:100
        thdif(k) = 0.0;
    end
end 

thdif = thdif';


%% Change the values (1-800 in x, 1-680 in y, all 100 levels in z).
%% Only act if the theta' anomaly is >= 0 at lowest model level.
for i=1:800
    for j=1:680
        for k=1:100
            if thanom(i,j,1) < 0
                tha(i,j,k)= tha(i,j,k);
            else
                tha(i,j,k)= tha(i,j,k) - thdif(k);
            end
        end
    end 
end

% RE-write file to same filename with new u-wind values
ncwrite('cm1out_reduce7K_rst_000240.nc','tha',tha);
exit
