var documenterSearchIndex = {"docs":
[{"location":"#Statreg.jl-1","page":"Home","title":"Statreg.jl","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"This is documentation for Statreg.jl – a Julia package that allows to apply Turchin's method of statistical regularisation to solve the Fredholm equation of the first kind.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Let's consider equation","category":"page"},{"location":"#","page":"Home","title":"Home","text":"f(y) = intlimits_a^b K(x y) varphi(x) dx","category":"page"},{"location":"#","page":"Home","title":"Home","text":"The problem is, given kernel function K(x y) and observed function f(y), to find the function varphi(x). f(y) contains a random noise factor both from initial statistical uncertainty of varphi(x) and additional noise from measurement procedure. The equation is ill-posed: a small measurement error of f(y) leads to big instability of varphi(x). Solving such ill-posed problems requires operation called regularisation. It means we need to introduce additional information to make the problem well-posed one.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"The idea of statistical regularisation is related to the Bayesian statistics approach: unknown statistical value varphi(x) could be reconstructed using measured value f(y), kernel K(x y) and some prior information about varphi(x) behaviour: smoothness, constraints on boundary conditions, non-negativity, etc. Also, it is important to note that statistical regularisation allows to estimate errors of the obtained solution. More information about the theory of statistical regularisation you can find here, but the main concepts will be explained further in this documentation.","category":"page"},{"location":"#Description-of-statistical-regularisation-method-1","page":"Home","title":"Description of statistical regularisation method","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"Firstly, it is necessary to make a parameterised discrete representation of the continuous functional space. We should introduce basis  psi_k _k=1^N, in which the required function will be calculated. Thus, the Fredholm equation will be сonverted to the matrix equation:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"f_m = K_mn varphi_n","category":"page"},{"location":"#","page":"Home","title":"Home","text":"where f_m = f(y_m),  varphi_n :  varphi(x) = sumlimits_k=1^N varphi_k psi_k(x),  K_mn = intlimits_a^b K(x y_m) psi_n(x) dx.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Let's introduce function overrightarrowS that will evaluate overrightarrowvarphi based on the function overrightarrowf and loss function L(overrightarrowwidehatvarphi overrightarrowS) = sumlimits_n=1^N mu_n (widehatvarphi_n - S_n)^2, where overrightarrowwidehatvarphi=overrightarrowwidehatS(overrightarrowf) – the best solution.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"For this loss function the best strategy is","category":"page"},{"location":"#","page":"Home","title":"Home","text":"overrightarrowwidehatSf=Eoverrightarrowvarphioverrightarrowf=int overrightarrowvarphi P(overrightarrowvarphioverrightarrowf) doverrightarrowvarphi","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Errors of the solution:","category":"page"},{"location":"#","page":"Home","title":"Home","text":" sigma_n^2  = int (varphi_n - widehatS_n)^2 P(overrightarrowvarphioverrightarrowf)doverrightarrowvarphi","category":"page"},{"location":"#","page":"Home","title":"Home","text":"P(overrightarrowvarphioverrightarrowf) = fracP(overrightarrowvarphi)P(overrightarrowfoverrightarrowvarphi)int doverrightarrowvarphiP(overrightarrowvarphi)P(overrightarrowfoverrightarrowvarphi)","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Thus, P(overrightarrowvarphi) and P(overrightarrowfoverrightarrowvarphi) are required to find the solution. P(overrightarrowvarphi) can be chosen using prior information about overrightarrowvarphi). P(overrightarrowfoverrightarrowvarphi) depends on overrightarrowf distribution. Let's consider different distributions of overrightarrowvarphi and overrightarrowf.","category":"page"},{"location":"#Smoothness-as-a-prior-information-1","page":"Home","title":"Smoothness as a prior information","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"We expect varphi(x) to be relatively smooth and can choose this information as a prior. The matrix of the mean value of derivatives of order p can be used as a prior information about the solution.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Omega_mn = intlimits_a^b left( fracd^p psi_m(x)dx^p right) left( fracd^p psi_n(x)dx^p right) dx","category":"page"},{"location":"#","page":"Home","title":"Home","text":"We require a certain value of the smoothness functional to be achieved:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"int (overrightarrowvarphi Omega overrightarrowvarphi) P(overrightarrowvarphi)doverrightarrowvarphi=omega","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Thus, the overrightarrowvarphi probability distribution depends on the parameter:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"P_alpha(overrightarrowvarphi)=fracalpha^Rg(Omega)2 sqrttextdet(Omega)(2pi)^N2textexpleft( -frac12 (overrightarrowvarphi Omega overrightarrowvarphi) right)","category":"page"},{"location":"#","page":"Home","title":"Home","text":"where alpha=frac1omega.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"The value of the parameter alpha is unknown and can be obtained in following ways:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"directly from some external data or manually selected\nas a maximum of a posterior information P(alphaoverrightarrowf)\nas the mean of all possible alpha, defining the prior probability density as P(overrightarrowvarphi)=int dalpha P(alpha) P(overrightarrowvarphialpha) (all alphas are equally probable).","category":"page"},{"location":"#","page":"Home","title":"Home","text":"StatReg.jl allows to apply all of these options.","category":"page"},{"location":"#Gaussian-random-process-1","page":"Home","title":"Gaussian random process","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"Experimental data usually follows a normal distribution. At that rate the regularisation has an analytical solution. Let the measurement vector f have errors described by a multidimensional Gaussian distribution with a covariance matrix Sigma:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"P(overrightarrowfoverrightarrowvarphi)=frac1(2pi)^N2Sigma^12expleft( -frac12 (overrightarrowf - Koverrightarrowvarphi)^T Sigma^-1 (overrightarrowf - Koverrightarrowvarphi) right)","category":"page"},{"location":"#","page":"Home","title":"Home","text":"Using the most probable alpha, one can get the best solution:","category":"page"},{"location":"#","page":"Home","title":"Home","text":"overrightarrowwidehatS = (K^T Sigma^-1 K + alpha^* Omega)^-1 K^T Sigma^-1 T overrightarrowf","category":"page"},{"location":"#","page":"Home","title":"Home","text":"cov(varphi_m varphi_n) = (K^T Sigma^-1 K + alpha^* Omega)^-1_mn","category":"page"},{"location":"#","page":"Home","title":"Home","text":"This package allows to apply statistical regularisation in different bases using such prior information as smoothness or zero boundary conditions, or another information provided by user in a matrix form. Omega can be set manually or calculated for every derivative  of degree p. alpha can be calculated as a maximum of a posterior information or can be set manually.","category":"page"},{"location":"#Non-Gaussian-random-process-1","page":"Home","title":"Non-Gaussian random process","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"If the f function errors do not follow Gaussian distribution, the strategy overrightarrowwidehatS can not be calculated analytically in general case.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"overrightarrowwidehatSf=Eoverrightarrowvarphioverrightarrowf=int overrightarrowvarphi P(overrightarrowvarphioverrightarrowf) doverrightarrowvarphi","category":"page"},{"location":"#","page":"Home","title":"Home","text":"The posterior probability P(overrightarrowvarphioverrightarrowf) should be obtained from MCMC sampling. It is applied in the StatReg.jl using BAT.jl, AHMC.jl and DHMC.jl packages.","category":"page"},{"location":"#Non-negativity-and-other-conditions-1","page":"Home","title":"Non-negativity and other conditions","text":"","category":"section"},{"location":"#","page":"Home","title":"Home","text":"If phi is known to be non-negative or has some value restrictions, it can be used to improve the solution. To take it into account, posterior probability is multiplied by fast declining function if phi_i reached the bound.","category":"page"},{"location":"#","page":"Home","title":"Home","text":"P(varphi  f)_varphi_min varphi  varphi_max  = P(varphi  f) cdot\ne^- C_lower cdot e^- C_higher","category":"page"},{"location":"#","page":"Home","title":"Home","text":"C_lower = sum_m=1^M I(varphi_m  varphi_mintext m) cdot fracvarphi_mintext m - varphi_mvarphi_0 m\n\nP(varphi  f)_varphi_min varphi  varphi_max  = P(varphi  f) cdot\ne^- C_lower cdot e^- C_higher","category":"page"},{"location":"#","page":"Home","title":"Home","text":"C_higher = sum_m=1^M I(varphi_m  varphi_maxtext m) cdot fracvarphi_m - varphi_maxtext mvarphi_0 m","category":"page"},{"location":"getting_started/#Getting-started-1","page":"Getting started","title":"Getting started","text":"","category":"section"},{"location":"getting_started/#Installation-1","page":"Getting started","title":"Installation","text":"","category":"section"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"To install StatReg.jl, start up Julia and type the following code-snipped into the REPL.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"import Pkg\nPkg.clone(\"https://github.com/mipt-npm/StatReg.jl.git\")","category":"page"},{"location":"getting_started/#Usage-1","page":"Getting started","title":"Usage","text":"","category":"section"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Let's consider the simplest case of deconvolution. The function to be reconstructed varphi(x) is the sum of two Gaussian distributions.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"using Plots\nplotly()\ngr(size=(500,500), html_output_format=:png)\n\na = 0\nb = 6.\n\nfunction phi(x::Real)\n    mu1 = 2.\n    mu2 = 4.\n    n1 = 4.\n    n2 = 2.\n    sig1 = 0.4\n    sig2 = 0.5\n    norm(n, mu, sig, x) = n / sqrt(2 * pi*sig^2) * exp(-(x - mu)^2 / (2 * sig^2))\n    return norm(n1, mu1, sig1, x) + norm(n2, mu2, sig2, x)\nend\n\nx = collect(range(a, stop=b, length=300));\nplot(x, phi.(x), title=\"Real phi function\", label=\"Phi(x)\")","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"(Image: real_phi)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"After integration we get data and errors. kernel - kernel function, y - measurement points, f - data points, sig - data errors.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"using QuadGK\nkernel_name = \"rectangular\"\nkernel(x::Real, y::Real) = getOpticsKernels(kernel_name)(x, y)\n\nconvolution = y -> quadgk(x -> kernel(x,y) * phi(x), a, b, rtol=10^-5, maxevals=10^7)[1]\ny = collect(range(a, stop=b, length=30))\nftrue = convolution.(y)\n\nsig = 0.1*ftrue + [0.01 for i = 1:Base.length(ftrue)]\n\nusing Compat, Random, Distributions\nnoise = []\nRandom.seed!(1234)\nfor sigma in sig\n    n = rand(Normal(0., sigma), 1)[1]\n    push!(noise, n)\nend\n\nf = ftrue + noise;\nplot(y, f, title=\"$(kernel_name) kernel\", label=\"f(y)\", seriestype=:scatter, yerr=sig)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"(Image: integrated)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Let's proceed to the reconstruction.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"To reconstruct function you need to load data f(y) and data errors delta f(y) and define kernel K(x y). There are two possibilities: use vector & matrix form or continuous form. In the first case K(x y) is matrix n times m, f(y) and delta f(y) - n-dimensional vectors. In the second case K(x y) is a function, f(y) and delta f(y) can be either functions or vectors. If they are functions, knot vector y should be specified (points where the measurement is taken).","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"We have already defined all needed data (y is a list of measurement points, f is a list of function values at these points, sig is a list of error in these points)\nBasis:","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"We will use Cubic Spline Basis with knots in data points and zero boundary conditions on both sides.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"basis = CubicSplineBasis(y, \"dirichlet\")\np = plot()\nfor func in basis.basis_functions\n    p = plot!(x, func.(x), title=\"B-spline basis functions\", legend=false, show = true)\nend\ndisplay(p)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"(Image: cubic_spline_basis)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Model:","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"To reconstruct the function, we use matrix of the second derivatives as a prior information. Then we choose a solution model. It requires basis and a set of matrices that contain prior information, in our case it is smoothness. The method we use is called \"EmpiricalBayes\", it means that alpha is chosen as a maximum of posterior probability P(alpha  f). Also, it is important to set higher and lower bounds of alpha and initial value for optimisation.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Omega = omega(basis, 2)\nmodel = GaussErrorUnfolder(basis, [Omega], \"EmpiricalBayes\", nothing, [1e-8], [10.], [0.3])","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Reconstruction:","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"To reconstruct the function we use solve() that returns PhiVec structure containing coefficients of basis function in the sum varphi(x) = sum_k=1^N coeff_n psi_n(x), their errors errors_n (delta varphi =  sum_k=1^N errors_n psi_n(x)), optimal parameter of smoothness alpha, reconstructed function and error function.","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Omega = omega(basis, 2)\nresult = solve(basis, f, sig, kernel, y, BATSampling(), ArgmaxOptim(), [Omega], PhiBounds());","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Results","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Representation of results in a convenient way is possible with PhiVec:","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"phi_reconstructed = result.solution_function.(x)\nphi_reconstructed_errors = result.error_function.(x)\n\nplot(x, phi_reconstructed, ribbon=phi_reconstructed_errors, fillalpha=0.3, label=\"Reconstructed function with errors\")\nplot!(x, phi.(x), label=\"Real function\")","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"(Image: reconstructed)","category":"page"},{"location":"getting_started/#","page":"Getting started","title":"Getting started","text":"Full notebook you can find in examples/getting_started.ipynb","category":"page"},{"location":"users_guide/#User's-Guide-1","page":"User's Guide","title":"User's Guide","text":"","category":"section"},{"location":"users_guide/#Kernel-1","page":"User's Guide","title":"Kernel","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"Kernel can be specified as a matrix or as a function. It is possible to set arbitrary function of 2 variables or use one of predefined kernels.","category":"page"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"getOpticsKernels(name::String,)","category":"page"},{"location":"users_guide/#Main.StatReg.getOpticsKernels-Tuple{String}","page":"User's Guide","title":"Main.StatReg.getOpticsKernels","text":"getOpticsKernels(name::String, alpha::Real = 1.)\n\nArguments\n\nname - name of a kernel\nalpha - kernel function parameter\n\nReturns: kernel, function of 2 variables.\n\nAvailable kernels:\n\nrectangular:\n\nK(x y) =\nbegincases\n1 textif  fracx-yalpha  1\n\ntext  0 text otherwise\nendcases\n\ndiffraction:\n\nK(x y) = left(fracsin(fracpi (x-y)s_0)fracpi (x-y)s_0right)^2\n\ns_0 = fracalpha0886\n\ngaussian:\n\nK(x y) = frac2alphasqrtfracln2pie^4ln2left(fracx-yalpharight)^2\n\ntriangular:\n\nK(x y) =\nbegincases\nfrac1 - fracx-yalphaalpha textif  fracx-yalpha  1\n\ntext  0 text otherwise\nendcases\n\ndispersive:\n\nK(x y) = fracalpha2 pileft((x-y)^2 + left(fracalpha2right)^2right)\n\nexponential:\n\nK(x y) = fracln2alphae^2ln2fracx-yalpha\n\nheaviside:\n\nK(x y) =\nbegincases\n1 textif  x0\n\ntext   0 text otherwise\nendcases\n\n\n\n\n\n","category":"method"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"discretize_kernel(basis::Basis, kernel::Function, measurement_points::AbstractVector{<:Real})","category":"page"},{"location":"users_guide/#Main.StatReg.discretize_kernel-Tuple{Basis,Function,AbstractArray{#s519,1} where #s519<:Real}","page":"User's Guide","title":"Main.StatReg.discretize_kernel","text":"discretize_kernel(basis::Basis, kernel::Function, measurement_points::AbstractVector{<:Real})\n\nArguments\n\nbasis – basis\nkernel – kernel function\nmeasurement_points – array of data points\n\nReturns: discretized kernel K::Array{Real, 2}, K_mn = intlimits_a^b K(x y_n) psi_m(x) dx - matrix of size ntimesm, where m - number of basis functions, n - number of data points.\n\n\n\n\n\n","category":"method"},{"location":"users_guide/#Bases-1","page":"User's Guide","title":"Bases","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"Basis","category":"page"},{"location":"users_guide/#Main.StatReg.Basis","page":"User's Guide","title":"Main.StatReg.Basis","text":"Abstract type for all bases.\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"omega(basis::Basis, order::Int)","category":"page"},{"location":"users_guide/#Main.StatReg.omega-Tuple{Basis,Int64}","page":"User's Guide","title":"Main.StatReg.omega","text":"omega(basis::Basis, order::Int)\n\nArguments\n\nbasis - basis\norder - order of derivatives\n\nReturns: Omega::Array{Real, 2}, Omega_mn = intlimits_a^b fracd^order psi_mdx^order fracd^order psi_ndx^order - matrix of size ntimesn of the mean values of derivatives of order order, where n - number of functions in basis.\n\n\n\n\n\n","category":"method"},{"location":"users_guide/#Fourier-basis-1","page":"User's Guide","title":"Fourier basis","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"FourierBasis","category":"page"},{"location":"users_guide/#Main.StatReg.FourierBasis","page":"User's Guide","title":"Main.StatReg.FourierBasis","text":"Fourier basis with length 2n+1: {05, sin(fracpi (x - fraca+b2)b-a), cos(fracpi (x - fraca+b2)b-a), ..., sin(fracpi n (x - fraca+b2)b-a), cos(fracpi n (x - fraca+b2)b-a)}.\n\nFourierBasis(a::Real, b::Real, n::Int)\n\na, b – the beginning and the end of the segment n – number of harmonics\n\nFields\n\na::Real – beginning of the support\nb::Real – end of the support\nn::Int – number of harmonics\nbasis_functions::AbstractVector – array of basis functions\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Cubic-Spline-basis-1","page":"User's Guide","title":"Cubic Spline basis","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"CubicSplineBasis","category":"page"},{"location":"users_guide/#Main.StatReg.CubicSplineBasis","page":"User's Guide","title":"Main.StatReg.CubicSplineBasis","text":"Cubic spline basis on given knots with length n.\n\nCubicSplineBasis(\n    knots::AbstractVector{<:Real},\n    boundary_condition::Union{Tuple{Union{String, Nothing}, Union{String, Nothing}}, Nothing, String}=nothing\n    )\n\nCubicSplineBasis(\n    a::Real, b::Real, n::Int,\n    boundary_condition::Union{Tuple{Union{String, Nothing}, Union{String, Nothing}}, Nothing, String}=nothing\n    )\n\nknots – knots of spline boundary_condition – boundary conditions of basis functions. If tuple, the first element affects left bound, the second element affects right bound. If string, both sides are affected. Possible options: \"dirichlet\", nothing\n\nFields\n\na::Real – beginning of the support, matches the first element of the array knots\nb::Real – end of the support, matches the last element of the array knots\nknots::AbstractVector{<:Real} – array of points on which the spline is built\nbasis_functions::AbstractVector – array of basis functions\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Legendre-polynomials-basis-1","page":"User's Guide","title":"Legendre polynomials basis","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"LegendreBasis","category":"page"},{"location":"users_guide/#Main.StatReg.LegendreBasis","page":"User's Guide","title":"Main.StatReg.LegendreBasis","text":"Legendre polynomials basis with length n.\n\nLegendreBasis(a::Real, b::Real, n::Int)\n\na, b – the beginning and the end of the support n – number of basis functions\n\nFields\n\na::Real – beginning of the support\nb::Real – end of the support\nbasis_functions::AbstractVector{BaseFunction} – array of basis functions\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Bernstein-polynomials-basis-1","page":"User's Guide","title":"Bernstein polynomials basis","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"BernsteinBasis","category":"page"},{"location":"users_guide/#Main.StatReg.BernsteinBasis","page":"User's Guide","title":"Main.StatReg.BernsteinBasis","text":"Bernstein polynomials basis.\n\nBernsteinBasis(\n    a::Real, b::Real, n::Int,\n    boundary_condition::Union{Tuple{Union{String, Nothing}, Union{String, Nothing}}, Nothing, String}=nothing\n    )\n\na, b – the beginning and the end of the segment n – number of basis functions boundary_condition – boundary conditions of basis functions. If tuple, the first element affects left bound, the second element affects right bound. If string, both sides are affected. Possible options: \"dirichlet\", nothing.\n\nFields\n\na::Real – beginning of the support\nb::Real – end of the support\nbasis_functions::AbstractVector{Function} – array of basis functions\nboundary_condition::Tuple{Union{String, Nothing}, Union{String, Nothing}} – boundary conditions of basis functions. Possible options: \"dirichlet\", nothing.\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Parameters-of-reconstruction-algorithm-1","page":"User's Guide","title":"Parameters of reconstruction algorithm","text":"","category":"section"},{"location":"users_guide/#Regularization-parameters-1","page":"User's Guide","title":"Regularization parameters","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"AlphasType","category":"page"},{"location":"users_guide/#Main.StatReg.AlphasType","page":"User's Guide","title":"Main.StatReg.AlphasType","text":"Abstract type for all algorithms for choosing regularization parameters\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"ArgmaxBAT","category":"page"},{"location":"users_guide/#Main.StatReg.ArgmaxBAT","page":"User's Guide","title":"Main.StatReg.ArgmaxBAT","text":"alphas = argmax(P(alphasf)) Mode of the distribution is found by sampling using BAT.jl\n\nArgmaxBAT(alphas::Union{AbstractVector{<:Real}, Nothing}=nothing,\nlower::Union{AbstractVector{<:Real}, Nothing}=nothing,\nhigher::Union{AbstractVector{<:Real}, Nothing}=nothing,\ninitial::Union{AbstractVector{<:Real}, Nothing}=nothing,\nalgo::MCMCAlgorithm=MetropolisHastings(),\nnchains::Int=2,\nnsamples::Int=1e4,\n)\n\nFields\n\nalphas::Union{AbstractVector{<:Real}, Nothing} – values of regularization parameters\nlower::Union{AbstractVector{<:Real}, Nothing} – lower possible values of regularization parameters\nhigher::Union{AbstractVector{<:Real}, Nothing} – higher possible values of regularization parameters\ninitial::Union{AbstractVector{<:Real}, Nothing} – initial values of regularization parameters\nalgo::MCMCAlgorithm – algorithm of sampling (for more info see BAT.jl documentation)\nnchains::Int – number of chains to sample\nnsamples::Int – number of samples\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"ArgmaxOptim","category":"page"},{"location":"users_guide/#Main.StatReg.ArgmaxOptim","page":"User's Guide","title":"Main.StatReg.ArgmaxOptim","text":"alphas = argmax(P(alphasf)) Mode of the distribution is found by sampling using Optim.jl\n\nArgmaxOptim(alphas::Union{AbstractVector{<:Real}, Nothing}=nothing,\nlower::Union{AbstractVector{<:Real}, Nothing}=nothing,\nhigher::Union{AbstractVector{<:Real}, Nothing}=nothing,\ninitial::Union{AbstractVector{<:Real}, Nothing}=nothing,\nalgo=BFGS()\n)\n\nFields\n\nalphas::Union{AbstractVector{<:Real}, Nothing} – values of regularization parameters\nlower::Union{AbstractVector{<:Real}, Nothing} – lower possible values of regularization parameters\nhigher::Union{AbstractVector{<:Real}, Nothing} – higher possible values of regularization parameters\ninitial::Union{AbstractVector{<:Real}, Nothing} – initial values of regularization parameters\nalgo – algorithm of optimization (for more info see Optim.jl documentation)\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"Marginalize","category":"page"},{"location":"users_guide/#Main.StatReg.Marginalize","page":"User's Guide","title":"Main.StatReg.Marginalize","text":"Allows to compute varphi averaging over all parameters\n\nMarginalize()\n\nFields\n\nalphas::Nothing – no fixed regularization parameters\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"User","category":"page"},{"location":"users_guide/#Main.StatReg.User","page":"User's Guide","title":"Main.StatReg.User","text":"User-defined parameters\n\nUser(alphas::AbstractVector{<:Real})\n\nFields\n\nalphas::AbstractVector{<:Real} – fixed regularization parameters\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Reconstruction-algorithms-1","page":"User's Guide","title":"Reconstruction algorithms","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"AlgoType","category":"page"},{"location":"users_guide/#Main.StatReg.AlgoType","page":"User's Guide","title":"Main.StatReg.AlgoType","text":"Abstract type for all solution algorithms\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"Analytically","category":"page"},{"location":"users_guide/#Main.StatReg.Analytically","page":"User's Guide","title":"Main.StatReg.Analytically","text":"Analytical solution\n\nAnalytically()\n\nFields no fields\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"BATSampling","category":"page"},{"location":"users_guide/#Main.StatReg.BATSampling","page":"User's Guide","title":"Main.StatReg.BATSampling","text":"Solve with BATSampling\n\nBATSampling(log_data_distribution::Union{Function, Nothing}=nothing,\nalgo::MCMCAlgorithm=MetropolisHastings(),\nnchains::Int=2,\nnsamples::Int=1e4\n)\n\nFields\n\nlog_data_distribution::Union{Function, Nothing} – logarithm of data distribution\nalgo::MCMCAlgorithm – algorithm foe sampling (foe more info see BAT.jlj documentation)\nnchains::Int – number of chains to sample\nnsamples::Int – number of samples\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"AHMCSampling","category":"page"},{"location":"users_guide/#Main.StatReg.AHMCSampling","page":"User's Guide","title":"Main.StatReg.AHMCSampling","text":"Solve with AHMCSampling\n\nAHMCSampling(log_data_distribution::Union{Function, Nothing}=nothing,\nnchains::Int=1,\nnsamples::Int=1e4\n)\n\nFields\n\nlog_data_distribution::Union{Function, Nothing} – logarithm of data distribution\nnchains::Int – number of chains to sample\nnsamples::Int – number of samples\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"DHMCSampling","category":"page"},{"location":"users_guide/#Main.StatReg.DHMCSampling","page":"User's Guide","title":"Main.StatReg.DHMCSampling","text":"Solve with DHMCSampling\n\nDHMCSampling(log_data_distribution::Union{Function, Nothing}=nothing,\nnchains::Int=1,\nnsamples::Int=1e4\n)\n\nFields\n\nlog_data_distribution::Union{Function, Nothing} – logarithm of data distribution\nnchains::Int – number of chains to sample\nnsamples::Int – number of samples\n\n\n\n\n\n","category":"type"},{"location":"users_guide/#Reconstruction-1","page":"User's Guide","title":"Reconstruction","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"solve","category":"page"},{"location":"users_guide/#Main.StatReg.solve","page":"User's Guide","title":"Main.StatReg.solve","text":"Solve the problem\n\nsolve(\n    basis::Basis,\n    data::Union{AbstractVector{<:Real}, Function},\n    data_errors::Union{AbstractVecOrMat{<:Real}, Function},\n    kernel::Union{Function, AbstractMatrix{<:Real}},\n    measurement_points::Union{AbstractVector{<:Real}, Nothing}=nothing,\n    algo::AlgoType=Analytically(),\n    alphas::AlphasType=ArgmaxBAT(),\n    omegas::Union{Array{Array{T, 2}, 1}, Nothing} where T<:Real = nothing,\n    phi_bounds::PhiBounds=PhiBounds(),\n    )\n\n\n\n\n\n","category":"function"},{"location":"users_guide/#Result-1","page":"User's Guide","title":"Result","text":"","category":"section"},{"location":"users_guide/#","page":"User's Guide","title":"User's Guide","text":"PhiVec","category":"page"},{"location":"users_guide/#Main.StatReg.PhiVec","page":"User's Guide","title":"Main.StatReg.PhiVec","text":"Constructs solution function by coefficients, basis and errors.\n\nPhiVec(coeff::Array{<:Real}, basis::Basis, errors::Array{<:Real})\nPhiVec(coeff::Array{<:Real}, basis::Basis)\nPhiVec(result::Dict{String, Array{<:Real}}, basis::Basis)\n\nFields\n\ncoeff::Array{<:Real} – coefficients of decomposition of a function in basis\nbasis::Basis – basis\nerrors::Union{Array{<:Real}, Nothing} – coefficients of decomposition of a function errors in basis\nsolution_function(x::Real)::Function – returns constructed function's value at given point\nerror_function(x::Real)::Union{Function, Nothing} – returns constructed function's error at given point, if errors are specified, otherwise is nothing\nalphas::Union{AbstractVector{<:Real}, Nothing} – list of regularization parameters\n\n\n\n\n\n","category":"type"},{"location":"examples/#Examples-1","page":"Examples","title":"Examples","text":"","category":"section"},{"location":"examples/#","page":"Examples","title":"Examples","text":"You can find more examples here.","category":"page"}]
}
