deriv2 <- function(gam_mod,simdat=x){
  # finite difference approach to derivatives following
  # example from ?predict.gam
  DF1  <- gam_mod$model
  eps  <- 1e-7
  # new data for prediction
  newDF <- with(DF1, data.frame(TempC = simdat))
  
  # prediction of smoothed estimates at each unique year value
  # with standard error    
  B          <- predict.gam(gam_mod,  newDF, type="response", se.fit=TRUE)
  
  # lines(scale(newDF$S_driver),scale(B$fit),pch=16,lwd=2)
  X0         <- predict(gam_mod, newDF, type = 'lpmatrix')
  newDFeps_p <- newDF + eps
  X1         <- predict(gam_mod, newDFeps_p, type = 'lpmatrix')
  X1sim      <- simulate(gam_mod,nsim=200,newdata=newDFeps_p)
  
  # finite difference approximation of first derivative
  # the design matrix
  Xp     <- (X0 - X1) / eps
  
  # first derivative
  fd_d1  <- -1*Xp %*% coef(gam_mod)
  D1_dat <- data.frame(TempC=newDF$TempC,y=fd_d1)[order(newDF$TempC),]

  # plot(D1_dat[,1],D1_dat[,2],type="l",lwd=2, xlim=c(-3,3),ylim=c(-2,2))
  
  # second derivative
  newDFeps_m <- newDF - eps
  X_1        <- predict(gam_mod, newDFeps_m, type = 'lpmatrix')
  
  # design matrix for second derivative
  Xpp        <- (X1 + X_1 - 2*X0)  / eps^2
  # second derivative
  fd_d2      <- Xpp %*% coef(gam_mod)
  
  D2_dat     <- data.frame(TempC=newDF$TempC,y=fd_d2)[order(newDF$TempC),]
  # plot(D2_dat[,1],D2_dat[,2],type="l",lwd=2, xlim=c(-3,3),ylim=c(-2,2))
  
  return(list(newDF=newDF,fd_d1=as.numeric(fd_d1),fd_d2=as.numeric(fd_d2)))
}