(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    269489,       5758]
NotebookOptionsPosition[    257903,       5466]
NotebookOutlinePosition[    258386,       5485]
CellTagsIndexPosition[    258343,       5482]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
The effectiveness of pseudomagic traits in promoting divergence and enhancing \
local adaptation\
\>", "Subtitle",
 CellChangeTimes->{{3.700583850441506*^9, 3.7005838775701838`*^9}, {
  3.803030927658338*^9, 3.803030963180952*^9}}],

Cell["Servedio and B\[UDoubleDot]rger 2020, Evolution", "Subsubtitle",
 CellChangeTimes->{3.803030968338772*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Program to produce figures in the style of Fig 1.  The example below contains \
mildly asymmetric \[Alpha] and starts with strong divergence and full LD.

Note that the code to produce the other figures are in the Supplementary \
Material files S1 and S2\
\>", "Subtitle",
 CellChangeTimes->{{3.739002981751514*^9, 3.739002990786665*^9}, {
  3.803030975281678*^9, 3.803031018347348*^9}, {3.803031191018414*^9, 
  3.803031218665464*^9}, {3.8030312697589083`*^9, 3.803031289249354*^9}}],

Cell[BoxData[
 RowBox[{"Pseudomagprog", ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]params", "=", 
     RowBox[{"{", 
      RowBox[{
      "0.1", ",", "0.12", ",", "  ", "0.135", ",", " ", "0.15", ",", " ", 
       "0.175", ",", "0.2", ",", "0.25", ",", " ", "0.3", ",", "0.35", ",", 
       " ", "0.4", ",", " ", "0.5", ",", " ", "0.6", ",", " ", "0.7", ",", 
       " ", "0.8", ",", " ", "0.9", ",", " ", "1.0", ",", "1.5", ",", " ", 
       "2.0", ",", " ", "3.0", ",", " ", "5.0", ",", " ", "6.0", ",", " ", 
       "7.0", ",", " ", "8.0", ",", " ", "9.0", ",", " ", "10.0", " ", ",", 
       " ", "11.0", ",", " ", "12.0", ",", " ", "13.0", ",", " ", "14.0", ",",
        " ", "15.0", ",", " ", "16.0", ",", " ", "17.0", ",", " ", "18.0", 
       ",", " ", "19.0", ",", "20.0", ",", "22.5", ",", " ", "25.0", ",", " ",
        "30.0", ",", "40.0", ",", "50.0", ",", " ", "75.0", ",", "100.0"}], 
      "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"c1", " ", "=", "  ", 
     RowBox[{"Length", "[", "\[Alpha]params", "]"}]}], ";", 
    RowBox[{"(*", " ", 
     RowBox[{
     "number", " ", "of", " ", "items", " ", "in", " ", "alphaparams"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"tabt12t1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tabe12t1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tabD1tetime1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tabt22t1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tabe22t1", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"tabD2tetime1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqt2pop1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqe2pop1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqDTEpop1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqt2pop2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqe2pop2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqDTEpop2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"c3", ",", "6"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c4", ",", "c1"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"rcount", " ", "=", " ", "1"}], ";", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Alpha]1", " ", "=", 
           RowBox[{"\[Alpha]params", "[", 
            RowBox[{"[", "count", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"\[Alpha]2", "=", " ", 
           RowBox[{
            RowBox[{"\[Alpha]params", "[", 
             RowBox[{"[", "count", "]"}], "]"}], "*", "1.1"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"gen", " ", "=", " ", "1"}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", "  ", 
           RowBox[{"Starting", " ", "conditions"}], " ", "*)"}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"t22", "=", "0.99"}], ";", "\[IndentingNewLine]", 
            RowBox[{"e22", "=", "0.99"}], ";", "\[IndentingNewLine]", 
            RowBox[{"D1te", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
            
            RowBox[{"t12", " ", "=", " ", "0.98"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"e12", " ", "=", " ", "0.98"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"D2te", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x1", "[", "1", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}]}], " ", "+", " ", "D1te"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x1", "[", "2", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}], "e12"}], " ", "-", " ", 
              "D1te"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x1", "[", "3", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{"t12", 
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}]}], " ", "-", " ", "D1te"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x1", "[", "4", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{"t12", " ", "e12"}], " ", "+", " ", "D1te"}]}], ";", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x2", "[", "1", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}], 
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}]}], " ", "+", " ", "D2te"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x2", "[", "2", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}], "e22"}], " ", "-", " ", 
              "D2te"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x2", "[", "3", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{"t22", 
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}]}], " ", "-", " ", "D2te"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"x2", "[", "4", "]"}], " ", "=", " ", 
             RowBox[{
              RowBox[{"t22", " ", "e22"}], " ", "+", " ", "D2te"}]}], ";"}], 
           "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
           "override", " ", "allele", " ", "freqs", " ", "for", " ", "full", 
            " ", "LD"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", "1", "]"}], " ", "=", " ", "1.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", "2", "]"}], " ", "=", " ", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", "3", "]"}], " ", "=", " ", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x1", "[", "4", "]"}], " ", "=", " ", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", "1", "]"}], " ", "=", " ", "0.05"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", "2", "]"}], " ", "=", " ", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", "3", "]"}], " ", "=", " ", "0.0"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"x2", "[", "4", "]"}], " ", "=", " ", "0.95"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Do", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"x1t1", "[", "cc", "]"}], " ", "=", " ", "2"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"cc", ",", " ", "4"}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"x2t1", "[", "cc", "]"}], " ", "=", " ", "1"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"cc", ",", " ", "4"}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"F1", "=", " ", 
           RowBox[{"Table", "[", 
            RowBox[{"0", ",", " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"F2", "=", " ", 
           RowBox[{"Table", "[", 
            RowBox[{"0", ",", " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Coef", " ", "=", " ", 
           RowBox[{"Table", "[", 
            RowBox[{"1", ",", " ", 
             RowBox[{"{", 
              RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Coef", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", " ", 
              RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Do", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Coef", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "3", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", " ", 
              RowBox[{"{", 
               RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "]"}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabt12t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", "tabt12t1", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabe12t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", 
           RowBox[{"{", "tabe12t1", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabD1tetime1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], "=", " ", 
           RowBox[{"{", "tabD1tetime1", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabt22t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", "tabt22t1", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabe22t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", "tabe22t1", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabD2tetime1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", "tabD2tetime1", "}"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"While", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x1t1", "[", "1", "]"}], " ", "-", 
                   RowBox[{"x1", "[", "1", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], " ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x1t1", "[", "2", "]"}], " ", "-", 
                   RowBox[{"x1", "[", "2", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], "  ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x1t1", "[", "3", "]"}], " ", "-", 
                   RowBox[{"x1", "[", "3", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], " ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x1t1", "[", "4", "]"}], " ", "-", 
                   RowBox[{"x1", "[", "4", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], " ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x2t1", "[", "1", "]"}], " ", "-", 
                   RowBox[{"x2", "[", "1", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], " ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x2t1", "[", "2", "]"}], " ", "-", 
                   RowBox[{"x2", "[", "2", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], "  ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x2t1", "[", "3", "]"}], " ", "-", 
                   RowBox[{"x2", "[", "3", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}], " ", "||", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                   RowBox[{"x2t1", "[", "4", "]"}], " ", "-", 
                   RowBox[{"x2", "[", "4", "]"}]}], "]"}], ">", " ", 
                 "xprecision"}], ")"}]}], ")"}], "  ", "&&", " ", 
             RowBox[{"(", 
              RowBox[{"gen", " ", "<", " ", "genlimit"}], ")"}]}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"gen", " ", ">", " ", "1"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"Do", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"x1", "[", "cc", "]"}], "=", " ", 
                   RowBox[{"x1t1", "[", "cc", "]"}]}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"cc", ",", " ", "4"}], "}"}]}], "]"}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"Do", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"x2", "[", "cc", "]"}], "=", " ", 
                   RowBox[{"x2t1", "[", "cc", "]"}]}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"cc", ",", " ", "4"}], "}"}]}], "]"}]}]}], "]"}], 
             ";", " ", 
             RowBox[{"(*", " ", "recursions", " ", "*)"}], 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"x1m", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "m1"}], ")"}], " ", 
                  RowBox[{"x1", "[", "i", "]"}]}], "+", " ", 
                 RowBox[{"m1", " ", 
                  RowBox[{"x2", "[", "i", "]"}]}]}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"x2m", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "m2"}], ")"}], " ", 
                  RowBox[{"x2", "[", "i", "]"}]}], "+", " ", 
                 RowBox[{"m2", " ", 
                  RowBox[{"x1", "[", "i", "]"}]}]}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"w1barm", " ", "=", " ", 
              RowBox[{
               RowBox[{"x1m", "[", "2", "]"}], "+", " ", 
               RowBox[{"x1m", "[", "4", "]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x1m", "[", "1", "]"}], "+", " ", 
                  RowBox[{"x1m", "[", "3", "]"}]}], ")"}]}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm1", "[", "1", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x1m", "[", "1", "]"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], "/", "w1barm"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm1", "[", "2", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x1m", "[", "2", "]"}], "/", "w1barm"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm1", "[", "3", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x1m", "[", "3", "]"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], "/", "w1barm"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm1", "[", "4", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x1m", "[", "4", "]"}], "/", "w1barm"}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"xnsf1", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{"xnsm1", "[", "i", "]"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"w2barm", " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x2m", "[", "2", "]"}], "+", " ", 
                  RowBox[{"x2m", "[", "4", "]"}]}], ")"}]}], "+", 
               RowBox[{"x2m", "[", "1", "]"}], "+", " ", 
               RowBox[{"x2m", "[", "3", "]"}]}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm2", "[", "1", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x2m", "[", "1", "]"}], "/", "w2barm"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm2", "[", "2", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x2m", "[", "2", "]"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm2", "[", "3", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x2m", "[", "3", "]"}], "/", "w2barm"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xnsm2", "[", "4", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"x2m", "[", "4", "]"}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], ";", 
             "\[IndentingNewLine]", "   ", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"xnsf2", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{"xnsm2", "[", "i", "]"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"Mate1", " ", "=", " ", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"xnsf1", "[", "i", "]"}], 
                 RowBox[{"xnsm1", "[", "j", "]"}]}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"G1", " ", "=", " ", 
              RowBox[{"Mate1", " ", "Coef"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"z1", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{"Sum", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"xnsm1", "[", "j", "]"}], " ", 
                   RowBox[{"Coef", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", 
                RowBox[{
                 RowBox[{"G1", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
                 RowBox[{"z1", "[", "i", "]"}]}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"Mate2", " ", "=", " ", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"xnsf2", "[", "i", "]"}], 
                 RowBox[{"xnsm2", "[", "j", "]"}]}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"G2", " ", "=", " ", 
              RowBox[{"Mate2", " ", "Coef"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"z2", "[", "i", "]"}], " ", "=", " ", 
                RowBox[{"Sum", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"xnsm2", "[", "j", "]"}], " ", 
                   RowBox[{"Coef", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Do", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", 
                RowBox[{
                 RowBox[{"G2", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
                 RowBox[{"z2", "[", "i", "]"}]}]}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x1t1", "[", "1", "]"}], "=", 
              RowBox[{
               RowBox[{"F1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}]}], ";", "\n", 
             "\t", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x1t1", "[", "2", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F1", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "2"}], "]"}], "]"}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "2"}], "]"}], "]"}]}]}]}], ";", "\n", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x1t1", "[", "3", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F1", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "3"}], "]"}], "]"}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "3"}], "]"}], "]"}]}]}]}], ";", "\n", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x1t1", "[", "4", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F1", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F1", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "4"}], "]"}], "]"}]}]}], ";", "\n", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x2t1", "[", "1", "]"}], "=", 
              RowBox[{
               RowBox[{"F2", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}]}], ";", "\n", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x2t1", "[", "2", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F2", "[", 
                RowBox[{"[", 
                 RowBox[{"2", ",", "2"}], "]"}], "]"}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "2"}], "]"}], "]"}]}]}]}], ";", "\n", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x2t1", "[", "3", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F2", "[", 
                RowBox[{"[", 
                 RowBox[{"3", ",", "3"}], "]"}], "]"}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "3"}], "]"}], "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"x2t1", "[", "4", "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"1", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"2", ",", "4"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"3", ",", "4"}], "]"}], "]"}]}], " ", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "1"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "2"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], " ", 
                RowBox[{"F2", "[", 
                 RowBox[{"[", 
                  RowBox[{"4", ",", "3"}], "]"}], "]"}]}], " ", "+", " ", 
               RowBox[{"F2", "[", 
                RowBox[{"[", 
                 RowBox[{"4", ",", "4"}], "]"}], "]"}]}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"t12t1", " ", "=", " ", 
              RowBox[{
               RowBox[{"x1t1", "[", "3", "]"}], "+", 
               RowBox[{"x1t1", "[", "4", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"e12t1", " ", "=", " ", 
              RowBox[{
               RowBox[{"x1t1", "[", "2", "]"}], "+", 
               RowBox[{"x1t1", "[", "4", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"D1tetime1", " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"x1t1", "[", "1", "]"}], " ", 
                RowBox[{"x1t1", "[", "4", "]"}]}], " ", "-", " ", 
               RowBox[{
                RowBox[{"x1t1", "[", "2", "]"}], " ", 
                RowBox[{"x1t1", "[", "3", "]"}]}]}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"t22t1", " ", "=", " ", 
              RowBox[{
               RowBox[{"x2t1", "[", "3", "]"}], "+", 
               RowBox[{"x2t1", "[", "4", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"e22t1", " ", "=", " ", 
              RowBox[{
               RowBox[{"x2t1", "[", "2", "]"}], "+", 
               RowBox[{"x2t1", "[", "4", "]"}]}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"D2tetime1", " ", "=", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"x2t1", "[", "1", "]"}], " ", 
                RowBox[{"x2t1", "[", "4", "]"}]}], " ", "-", " ", 
               RowBox[{
                RowBox[{"x2t1", "[", "2", "]"}], " ", 
                RowBox[{"x2t1", "[", "3", "]"}]}]}]}], " ", ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabt12t1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabt12t1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
                "t22t1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabe12t1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabe12t1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
                "e12t1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabD1tetime1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabD1tetime1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
                "D1tetime1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabt22t1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabt22t1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", 
                "t22t1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabe22t1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabe22t1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", 
                "e22t1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"tabD2tetime1", "[", 
               RowBox[{"[", 
                RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{"Append", "[", 
               RowBox[{
                RowBox[{"tabD2tetime1", "[", 
                 RowBox[{"[", 
                  RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
                "D2tetime1"}], "]"}]}], ";", "\[IndentingNewLine]", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"gen", "++"}], ";"}]}], "]"}], ";", " ", 
          RowBox[{"(*", " ", "loop", " ", "*)"}], "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabt12t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabt12t1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabe12t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabe12t1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabD1tetime1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabD1tetime1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabt22t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabt22t1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabe22t1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabe22t1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tabD2tetime1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"Delete", "[", 
            RowBox[{
             RowBox[{"tabD2tetime1", "[", 
              RowBox[{"[", 
               RowBox[{"rcount", ",", "count"}], "]"}], "]"}], ",", " ", 
             "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<run \>\"", ",", " ", "count", ",", "\"\<,  \[Alpha] = \>\"", 
            ",", " ", "\[Alpha]1", ",", " ", "\"\<,   gen = \>\"", ",", " ", 
            "gen"}], "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqt2pop1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", " ", "t12t1"}], 
            "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqe2pop1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", " ", "e12t1"}], 
            "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqDTEpop1", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", "D1tetime1"}], "}"}]}],
           ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqt2pop2", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", " ", "t22t1"}], 
            "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqe2pop2", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", " ", "e22t1"}], 
            "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"eqDTEpop2", "[", 
            RowBox[{"[", 
             RowBox[{"rcount", ",", "count"}], "]"}], "]"}], " ", "=", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]params", "[", 
              RowBox[{"[", "count", "]"}], "]"}], ",", "D2tetime1"}], 
            "}"}]}]}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"count", ",", " ", "c1"}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"rcount", "++"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"r", ",", " ", 
        RowBox[{"{", 
         RowBox[{
         "0", ",", " ", "0.001", ",", " ", "0.01", ",", " ", "0.1", ",", " ", 
          "0.25", ",", " ", "0.5"}], "}"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.399241428997723*^9, 3.399241433412466*^9}, {
   3.3992414636760273`*^9, 3.3992416282241488`*^9}, {3.399241670979774*^9, 
   3.399241709863391*^9}, {3.399241774065874*^9, 3.399241941543738*^9}, {
   3.399241976643314*^9, 3.3992419885623627`*^9}, {3.400171970357088*^9, 
   3.4001720229238453`*^9}, 3.400172074622259*^9, {3.400172414249486*^9, 
   3.400172424148631*^9}, {3.400172513377623*^9, 3.400172514113804*^9}, 
   3.400172559346572*^9, {3.4021599236673594`*^9, 3.402160156657611*^9}, {
   3.40216058471671*^9, 3.402160592928282*^9}, {3.4021606681762123`*^9, 
   3.402160687536327*^9}, {3.402160989386322*^9, 3.402160993548996*^9}, {
   3.40216105567794*^9, 3.402161101604391*^9}, {3.4021612121962214`*^9, 
   3.402161240430833*^9}, {3.402161536894498*^9, 3.402161553220756*^9}, {
   3.462538252066777*^9, 3.462538255115934*^9}, {3.538120198902273*^9, 
   3.538120402393046*^9}, {3.5381207771730547`*^9, 3.538120777956274*^9}, {
   3.538462364369955*^9, 3.5384623782763653`*^9}, 3.538462427931231*^9, {
   3.538469920737462*^9, 3.538470340319168*^9}, 3.538472746693224*^9, {
   3.538472828367403*^9, 3.538472834746614*^9}, {3.538476657628256*^9, 
   3.5384766793151293`*^9}, 3.538476736908278*^9, {3.538476769667108*^9, 
   3.53847680608073*^9}, 3.538476837478035*^9, 3.538476885166381*^9, {
   3.572351081855468*^9, 3.572351150007354*^9}, {3.5723511974982443`*^9, 
   3.5723512626658077`*^9}, {3.572351682798205*^9, 3.572351686375351*^9}, {
   3.5723562880703897`*^9, 3.57235632740576*^9}, {3.572356511106329*^9, 
   3.572356599109315*^9}, {3.5723566599935417`*^9, 3.572356666559504*^9}, {
   3.572357076575449*^9, 3.57235707775847*^9}, {3.5723571097764273`*^9, 
   3.572357125456236*^9}, {3.572357227856852*^9, 3.572357252851132*^9}, {
   3.57235729613208*^9, 3.572357480936776*^9}, {3.572357577479813*^9, 
   3.572357622653389*^9}, {3.5723578758998823`*^9, 3.572357906221106*^9}, {
   3.57235804763621*^9, 3.572358054509564*^9}, {3.572358100835342*^9, 
   3.572358127173135*^9}, {3.572358183826077*^9, 3.572358213139029*^9}, 
   3.5723583343069077`*^9, {3.572358365059185*^9, 3.572358425962906*^9}, {
   3.572358902567486*^9, 3.572358921091638*^9}, 3.572359078873015*^9, 
   3.572359152013711*^9, {3.572359259729608*^9, 3.572359324066731*^9}, {
   3.57235954322237*^9, 3.572359545865259*^9}, {3.5723596910173597`*^9, 
   3.57235969718565*^9}, {3.57235980549153*^9, 3.572359896807933*^9}, {
   3.57236002564771*^9, 3.5723600371640882`*^9}, {3.572360108454129*^9, 
   3.572360171850885*^9}, 3.5723604327307453`*^9, 3.572361030808123*^9, {
   3.572361310750642*^9, 3.572361311264797*^9}, 3.572361391761887*^9, {
   3.572361753322709*^9, 3.572361758641775*^9}, {3.572361865442526*^9, 
   3.572361971522455*^9}, {3.5723620045137053`*^9, 3.5723621565323153`*^9}, 
   3.572362667891461*^9, {3.5723627670389423`*^9, 3.572362819829939*^9}, {
   3.572362852745844*^9, 3.572363015975402*^9}, {3.5723631139301558`*^9, 
   3.572363192973521*^9}, {3.5723632330290413`*^9, 3.5723632731233892`*^9}, {
   3.5723633558621073`*^9, 3.572363549630062*^9}, {3.572363644680098*^9, 
   3.572363652682108*^9}, {3.5723639593968678`*^9, 3.572364017604096*^9}, {
   3.572364111007154*^9, 3.57236413332078*^9}, {3.572365011277051*^9, 
   3.572365079445653*^9}, {3.572365511570115*^9, 3.5723655173020973`*^9}, {
   3.5723657921803417`*^9, 3.572365901290455*^9}, {3.5723659707889013`*^9, 
   3.572365982862673*^9}, {3.5723715186294603`*^9, 3.5723715474654016`*^9}, {
   3.572630464728441*^9, 3.572630469322956*^9}, {3.5727161109866056`*^9, 
   3.572716118812899*^9}, {3.5727897239229116`*^9, 3.5727897333495607`*^9}, {
   3.573473718507827*^9, 3.573473725933896*^9}, {3.573473763896462*^9, 
   3.573473806683486*^9}, {3.573581996392004*^9, 3.573582001645907*^9}, {
   3.576336076298091*^9, 3.576336170400331*^9}, {3.576336315537446*^9, 
   3.576336316488287*^9}, {3.576336356370694*^9, 3.576336360831469*^9}, {
   3.646994814243614*^9, 3.6469948202562103`*^9}, {3.646994979697402*^9, 
   3.646994983507638*^9}, {3.646995536720419*^9, 3.646996043701733*^9}, {
   3.646996077185358*^9, 3.646996077691309*^9}, {3.646996195078274*^9, 
   3.6469961953843822`*^9}, {3.646996532880169*^9, 3.6469965623370543`*^9}, {
   3.6469967479970617`*^9, 3.646996756353084*^9}, {3.646996796425993*^9, 
   3.6469968283277273`*^9}, 3.64699697051893*^9, {3.64699711252007*^9, 
   3.646997226032887*^9}, {3.6469972713825607`*^9, 3.646997392589458*^9}, {
   3.647020744220553*^9, 3.64702076100276*^9}, {3.647022233203026*^9, 
   3.647022243651904*^9}, {3.647149792791183*^9, 3.647149794888014*^9}, 
   3.647149847107614*^9, {3.647149910348875*^9, 3.647149922291335*^9}, {
   3.64716201136334*^9, 3.6471620326103153`*^9}, {3.6562647364143353`*^9, 
   3.6562647520124617`*^9}, {3.6562650413514547`*^9, 3.656265043288118*^9}, {
   3.656265438964671*^9, 3.6562654479205112`*^9}, {3.656269673294126*^9, 
   3.656269673956703*^9}, 3.656269914972184*^9, 3.6562701927014637`*^9, {
   3.656334411900483*^9, 3.6563344408285007`*^9}, 3.656335498231703*^9, 
   3.656335636920416*^9, 3.6563358896138678`*^9, {3.656414899905869*^9, 
   3.656414917832259*^9}, {3.656414961196117*^9, 3.6564149799472237`*^9}, {
   3.656415085815999*^9, 3.656415096401392*^9}, {3.6564151823160763`*^9, 
   3.6564152072232733`*^9}, {3.656415241520002*^9, 3.656415252000555*^9}, {
   3.656415288889323*^9, 3.656415443062758*^9}, {3.656415544857275*^9, 
   3.656415556991474*^9}, {3.65641565372957*^9, 3.656415658306691*^9}, 
   3.656415734384794*^9, {3.6564182350574827`*^9, 3.6564183331067963`*^9}, {
   3.656420070990649*^9, 3.6564201244093246`*^9}, 3.6564215948346033`*^9, 
   3.656422108519774*^9, 3.656422239310802*^9, {3.656862449846066*^9, 
   3.6568625937515297`*^9}, {3.656864692010771*^9, 3.6568646973203382`*^9}, {
   3.6733343718097982`*^9, 3.673334374056134*^9}, {3.673340307621752*^9, 
   3.6733403130980797`*^9}, {3.673340346262314*^9, 3.673340351733968*^9}, {
   3.673340496057023*^9, 3.6733405083134527`*^9}, {3.6733407507319736`*^9, 
   3.673340756446398*^9}, {3.673348709546647*^9, 3.673348710493086*^9}, {
   3.6733488093719587`*^9, 3.673348873153242*^9}, 3.6733522242813063`*^9, {
   3.673353533484503*^9, 3.6733536494568768`*^9}, {3.673353692581108*^9, 
   3.6733536929720087`*^9}, {3.673354146053275*^9, 3.673354215560689*^9}, {
   3.673354941316271*^9, 3.6733549895546618`*^9}, 3.673364276434691*^9, 
   3.67336524916486*^9, {3.673366193061167*^9, 3.6733662003544817`*^9}, {
   3.6733668482074013`*^9, 3.6733668554619617`*^9}, 3.673367774049562*^9, 
   3.6733685885597258`*^9, {3.673368778575198*^9, 3.673368781887673*^9}, 
   3.673370228738863*^9, 3.673372160162334*^9, {3.675080547015477*^9, 
   3.6750805597242527`*^9}, {3.675081140977043*^9, 3.675081141439314*^9}, {
   3.675084801387966*^9, 3.675084828028002*^9}, {3.6750852044244413`*^9, 
   3.675085205166974*^9}, {3.677865383657239*^9, 3.677865386193631*^9}, {
   3.681493747854868*^9, 3.681493751598776*^9}, {3.699718704033416*^9, 
   3.699718704966916*^9}, {3.699719989814207*^9, 3.699719993345317*^9}, {
   3.699720698790882*^9, 3.699720700765986*^9}, {3.6997208811149607`*^9, 
   3.699720881457953*^9}, {3.699721034914461*^9, 3.6997210354420547`*^9}, {
   3.699964350362665*^9, 3.699964391954628*^9}, {3.699964442210018*^9, 
   3.699964458790064*^9}, {3.699964651376409*^9, 3.699964653863529*^9}, {
   3.6999740450622663`*^9, 3.699974047289352*^9}, {3.7003916656303263`*^9, 
   3.7003916662211027`*^9}, {3.700392109052108*^9, 3.7003921662805*^9}, {
   3.7003923422165527`*^9, 3.7003923450866632`*^9}, {3.700564703774561*^9, 
   3.700564705993258*^9}, {3.70058161276457*^9, 3.700581644807559*^9}, {
   3.700581681640724*^9, 3.70058185756423*^9}, {3.700581923968917*^9, 
   3.7005822212760897`*^9}, {3.700582304846354*^9, 3.7005825474971743`*^9}, {
   3.700582705362602*^9, 3.700582767887879*^9}, {3.700582814258287*^9, 
   3.700582990867049*^9}, {3.70058302156989*^9, 3.7005831890673113`*^9}, {
   3.700583262291532*^9, 3.7005832724352503`*^9}, {3.700583527223341*^9, 
   3.700583725130921*^9}, {3.700583836744713*^9, 3.700583923519373*^9}, {
   3.700584220201921*^9, 3.700584287148696*^9}, {3.700585007725932*^9, 
   3.700585010710081*^9}, {3.700585089066374*^9, 3.70058509514165*^9}, 
   3.7005852094998503`*^9, {3.700585547610482*^9, 3.700585550984014*^9}, 
   3.703435423783657*^9, {3.703590025827557*^9, 3.703590032571074*^9}, {
   3.703590832188054*^9, 3.7035908342658443`*^9}, {3.703592868954713*^9, 
   3.703592871197941*^9}, {3.7390026172899313`*^9, 3.739002635362389*^9}, {
   3.739002717333002*^9, 3.7390027199739733`*^9}, 3.73900300674124*^9, {
   3.739180192390923*^9, 3.739180291895199*^9}, {3.739180462253785*^9, 
   3.739180839716043*^9}, 3.739181003717675*^9, {3.739181054682385*^9, 
   3.739181056723651*^9}, {3.739181714132539*^9, 3.739181716917766*^9}, {
   3.739185878313163*^9, 3.7391859285767307`*^9}, {3.7391860102744083`*^9, 
   3.739186101223834*^9}, {3.739187715281465*^9, 3.7391877169746037`*^9}, 
   3.7391879508289003`*^9, {3.739188252640195*^9, 3.739188272907815*^9}, {
   3.739188338449729*^9, 3.739188344918972*^9}, {3.739189842282748*^9, 
   3.7391899766493998`*^9}, {3.739190010570589*^9, 3.739190050211577*^9}, {
   3.73919072643592*^9, 3.739190738048373*^9}, {3.739190821178645*^9, 
   3.739190927865816*^9}, {3.7391910504521923`*^9, 3.739191082256402*^9}, {
   3.7391913969544992`*^9, 3.7391914762717123`*^9}, {3.739191682133778*^9, 
   3.739191926394226*^9}, {3.7391923584848433`*^9, 3.739192428177597*^9}, {
   3.739192471856316*^9, 3.7391925018781443`*^9}, {3.739192667446788*^9, 
   3.739192675187439*^9}, {3.739196972107122*^9, 3.739197166911131*^9}, {
   3.7391972620104637`*^9, 3.7391972756209497`*^9}, {3.7391974013879213`*^9, 
   3.739197418916605*^9}, {3.7391974748971777`*^9, 3.739197544112647*^9}, {
   3.739198786644104*^9, 3.739198790151822*^9}, {3.7391988358064117`*^9, 
   3.73919884059107*^9}, {3.741364258373054*^9, 3.741364265547035*^9}, {
   3.766846905995637*^9, 3.7668469071586103`*^9}, 3.766903129074609*^9, {
   3.803032107180335*^9, 3.8030321298862953`*^9}}],

Cell[CellGroupData[{

Cell["Output", "Subsubtitle",
 CellChangeTimes->{{3.703435205543652*^9, 3.703435206431746*^9}, 
   3.70343541528563*^9, {3.803031303699931*^9, 3.803031307339072*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xprecision", " ", "=", " ", "0.000000000001"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"genlimit", " ", "=", " ", "100000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numgen", " ", "=", " ", "10000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", " ", "=", " ", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", " ", "=", " ", "0.01"}], ";"}]}], "Input",
 CellChangeTimes->{{3.647149810721342*^9, 3.647149812675156*^9}, 
   3.647149878743128*^9, {3.6568536602702503`*^9, 3.6568536604624653`*^9}, {
   3.673366328636417*^9, 3.67336632998884*^9}, {3.675080655140538*^9, 
   3.675080656550302*^9}, 3.675081155821827*^9, {3.6750845801319103`*^9, 
   3.6750845810743427`*^9}, 3.677865393545401*^9, {3.700583310282177*^9, 
   3.700583321145694*^9}, {3.700585631174396*^9, 3.7005856386571302`*^9}, 
   3.70058585178023*^9, {3.70058686291381*^9, 3.700586863384205*^9}, 
   3.700587649816948*^9, {3.700587873086753*^9, 3.700587875173749*^9}, {
   3.7005879789971027`*^9, 3.700587980004026*^9}, 3.7005880909395113`*^9, 
   3.700588476746883*^9, {3.700591915860118*^9, 3.700591916321907*^9}, {
   3.70343522330021*^9, 3.7034352265312433`*^9}, {3.7034354364017887`*^9, 
   3.703435437031279*^9}, {3.7034362241685266`*^9, 3.70343622433539*^9}, {
   3.70343644583079*^9, 3.703436446580171*^9}, 3.7034368999300222`*^9, {
   3.703503048153067*^9, 3.703503056735924*^9}, {3.703590044009873*^9, 
   3.703590046059993*^9}, {3.7035937234390497`*^9, 3.703593724469914*^9}, {
   3.739002659151018*^9, 3.739002666090495*^9}, {3.739180865360565*^9, 
   3.739180865699538*^9}, {3.73918090759474*^9, 3.739180908032246*^9}, {
   3.739186118553493*^9, 3.73918614252737*^9}, {3.7391883699341497`*^9, 
   3.7391883997507763`*^9}, {3.7391892182337*^9, 3.7391892357691813`*^9}, {
   3.739199466551608*^9, 3.739199472877407*^9}, {3.766846915901325*^9, 
   3.766846926545555*^9}, 3.76684698238658*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"time1", " ", "=", " ", 
   RowBox[{"DateList", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m1", " ", "=", " ", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m2", " ", "=", "0.01"}], 
  ";"}], "\[IndentingNewLine]", "Pseudomagprog", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"time2", " ", "=", " ", 
   RowBox[{"DateList", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"time2", "-", "time1"}]}], "Input",
 CellChangeTimes->{3.739197801460719*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4129"}],
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 4129],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903148966075*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1835"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 1835],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031497776413`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1248"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 1248],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903150494182*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "957"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 957],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031509894953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "695"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 695],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690315143119*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "550"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 550],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903151679723*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "394"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 394],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903151910096*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "311"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 311],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152071582*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "261"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 261],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152201653*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "226"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 226],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152324031*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "183"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 183],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152417851*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "156"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 156],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152516695*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "138"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 138],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031526176453`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "126"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 126],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152636904*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "116"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 116],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031527375*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "109"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 109],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152756912*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "88"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 88],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152849874*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "79"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 79],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031528661757`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "72"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152884385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "71"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 71],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152901074*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "72"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903152983366*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "75"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 75],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153000139*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "78"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 78],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153018182*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "82"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 82],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153101033*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "86"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 86],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153118042*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "91"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 91],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153200036*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "97"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 97],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690315321541*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "103"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 103],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153299975*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "109"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 109],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153317462*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "117"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 117],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031534003077`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "125"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 125],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153486802*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "135"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 135],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031535063553`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "145"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 145],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031535991697`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "157"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 157],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153684476*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "170"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 170],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153783615*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "212"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 212],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903153884863*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "271"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 271],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903154004401*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "497"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 497],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903154281455*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "911"}],
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 911],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903154743725*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "505"}],
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 505],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031549907227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "538"}],
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 538],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903155244762*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "667"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 667],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031555409527`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "10220"}],
  
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 10220],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031623538723`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2610"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 2610],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031636576633`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2198"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 2198],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903164692623*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2101"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 2101],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903165666224*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2012"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 2012],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903166600792*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1960"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 1960],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031675216*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1906"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 1906],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031683930473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1873"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 1873],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903169367673*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1850"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 1850],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903170209757*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1832"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 1832],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903171193488*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1806"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 1806],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031722840652`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1787"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 1787],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031730905313`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1773"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 1773],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031739944973`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1761"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 1761],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903174984272*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1752"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 1752],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903175780415*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1744"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 1744],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903176559696*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1716"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 1716],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903177484003*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1699"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 1699],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903178336402*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1680"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 1680],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903179192726*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1662"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 1662],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903179990069*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1657"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 1657],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903180779068*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1654"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 1654],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031815714006`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1651"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 1651],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903182414336*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1649"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 1649],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031832350397`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1647"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 1647],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903184037456*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1646"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 1646],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903184900077*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1645"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 1645],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903185707192*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1644"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 1644],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903186512104*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1643"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 1643],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690318733558*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1643"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 1643],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903188134346*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1642"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903188916132*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1642"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903189707715*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1642"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031905067997`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1642"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669031913192043`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1642"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903192150526*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1642"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 1642],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903192966422*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1644"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 1644],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903193772958*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1650"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 1650],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903194584276*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "10883"}],
  
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 10883],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903202842247*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "10511"}],
  
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 10511],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032112003813`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "10529"}],
  
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 10529],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903219246111*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "10617"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 10617],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032275480423`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9022"}],
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 9022],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903233127387*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "9258"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 9258],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903239083829*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "11571"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 11571],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903247109806*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2855"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 2855],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903248536539*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2551"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 2551],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032497874413`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2401"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 2401],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903250966547*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2245"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 2245],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903252140176*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2166"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 2166],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903253147928*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2120"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 2120],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903254154158*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2089"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 2089],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903255160256*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2050"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 2050],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903256169322*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2026"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 2026],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032571657953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2009"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 2009],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903258276115*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1995"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 1995],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032595222673`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1985"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 1985],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903260664002*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1976"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 1976],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903261639092*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1947"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 1947],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032626481323`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1930"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 1930],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903263599394*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1910"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 1910],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903264576869*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1892"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 1892],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690326552258*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1887"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 1887],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903266447905*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1884"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 1884],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032674643297`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1881"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 1881],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903268375004*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1879"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 1879],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903269263274*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1877"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 1877],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690327022013*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1876"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 1876],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690327111467*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1875"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 1875],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903272113311*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1874"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 1874],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903273018846*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1873"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 1873],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903273918679*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1873"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 1873],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903274794732*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1872"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 1872],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903275702321*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1872"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 1872],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903276603559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1872"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 1872],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690327757061*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1872"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 1872],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903278570146*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1872"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 1872],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903279610705*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "1873"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 1873],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032805407753`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1875"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 1875],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903281459092*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "1883"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 1883],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032824065847`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "10242"}],
  
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 10242],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032902990427`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9932"}],
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 9932],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669032976433783`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9952"}],
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 9952],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033052368402`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "10036"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 10036],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033127775183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "7824"}],
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 7824],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033174338837`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8055"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 8055],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903322449273*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8238"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 8238],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903327528434*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8529"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 8529],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690333323885*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "5818"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 5818],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903336833397*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5388"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 5388],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033398489227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "4840"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 4840],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033426353817`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4459"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 4459],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903345172043*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "4174"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 4174],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033475405807`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3951"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 3951],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903349734153*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3624"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 3624],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033516502037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3395"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 3395],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033535621767`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3227"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 3227],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903355339967*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3097"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 3097],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033570677443`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2995"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 2995],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903358593247*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2911"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 2911],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903360085103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2653"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 2653],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903361484527*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2518"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 2518],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903362831758*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2381"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 2381],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690336408325*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2271"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 2271],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690336522674*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2244"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 2244],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903366363184*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2226"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 2226],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033675079308`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2213"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 2213],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903368890321*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2203"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 2203],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903370227537*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2196"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 2196],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903371395279*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2190"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 2190],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903372489888*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2186"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 2186],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903373581306*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2183"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 2183],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903374678561*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2180"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 2180],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903375776741*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2179"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 2179],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903376919932*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2178"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 2178],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903378088965*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2177"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 2177],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903379223446*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2177"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 2177],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903380338272*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2178"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 2178],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903381524444*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2179"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 2179],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903382641162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2184"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 2184],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903383743918*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2193"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 2193],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669033848408747`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2239"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 2239],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903385969449*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9382"}],
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 9382],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903393015733*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9267"}],
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 9267],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903399864521*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "9283"}],
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 9283],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034065275908`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "9342"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 9342],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903413597301*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "6610"}],
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 6610],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903417395595*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "7397"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 7397],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903421764352*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "7704"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 7704],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690342640035*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8047"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 8047],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903431294138*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6851"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 6851],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903435250535*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "6557"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 6557],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690343914876*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6173"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 6173],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903442834826*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5871"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 5871],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903446294293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "5618"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 5618],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903450070636*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5402"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 5402],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903453256419*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5052"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 5052],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034561793737`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4781"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 4781],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034589296227`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4563"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 4563],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903461514839*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4386"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 4386],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690346408679*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4239"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 4239],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903466334776*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4114"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 4114],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903468639728*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3701"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 3701],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903470795033*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3470"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 3470],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903472863661*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3218"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 3218],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903474580538*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3002"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 3002],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034761010036`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2947"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 2947],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034776311607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2907"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 2907],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034790354633`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2877"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 2877],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903480608246*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2855"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 2855],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903482107342*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2837"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 2837],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034835951357`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2823"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 2823],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034850330467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2812"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 2812],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903486460284*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2804"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 2804],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903487832733*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2797"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 2797],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903489242957*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2792"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 2792],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903490697208*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2789"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 2789],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690349235461*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2787"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 2787],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903493786811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2786"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 2786],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903495294166*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2786"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 2786],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034970091963`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2787"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 2787],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669034986406803`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "2796"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 2796],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903500112793*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2814"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 2814],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903501792939*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "2902"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 2902],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903503358457*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8999"}],
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 8999],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903510262226*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8934"}],
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 8934],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903517167986*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8915"}],
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 8915],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903523936632*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8932"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 8932],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035307430563`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.1`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "7238"}],
  SequenceForm["run ", 1, ",  \[Alpha] = ", 0.1, ",   gen = ", 7238],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903535338245*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.12`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6808"}],
  SequenceForm["run ", 2, ",  \[Alpha] = ", 0.12, ",   gen = ", 6808],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903539525628*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.135`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6855"}],
  SequenceForm["run ", 3, ",  \[Alpha] = ", 0.135, ",   gen = ", 6855],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690354373386*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.15`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "7581"}],
  SequenceForm["run ", 4, ",  \[Alpha] = ", 0.15, ",   gen = ", 7581],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903548736376*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.175`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "7225"}],
  SequenceForm["run ", 5, ",  \[Alpha] = ", 0.175, ",   gen = ", 7225],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903553090645*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.2`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "7046"}],
  SequenceForm["run ", 6, ",  \[Alpha] = ", 0.2, ",   gen = ", 7046],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903557520116*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.25`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6812"}],
  SequenceForm["run ", 7, ",  \[Alpha] = ", 0.25, ",   gen = ", 6812],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903561710352*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.3`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "6620"}],
  SequenceForm["run ", 8, ",  \[Alpha] = ", 0.3, ",   gen = ", 6620],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903565714983*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "0.35`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "6450"}],
  SequenceForm["run ", 9, ",  \[Alpha] = ", 0.35, ",   gen = ", 6450],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.76690356969573*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.4`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "6298"}],
  SequenceForm["run ", 10, ",  \[Alpha] = ", 0.4, ",   gen = ", 6298],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035735791616`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "6034"}],
  SequenceForm["run ", 11, ",  \[Alpha] = ", 0.5, ",   gen = ", 6034],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903577280614*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.6`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5813"}],
  SequenceForm["run ", 12, ",  \[Alpha] = ", 0.6, ",   gen = ", 5813],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903580903023*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.7`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5626"}],
  SequenceForm["run ", 13, ",  \[Alpha] = ", 0.7, ",   gen = ", 5626],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903584579652*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.8`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5465"}],
  SequenceForm["run ", 14, ",  \[Alpha] = ", 0.8, ",   gen = ", 5465],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035878149223`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "0.9`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5326"}],
  SequenceForm["run ", 15, ",  \[Alpha] = ", 0.9, ",   gen = ", 5326],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035909201736`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "5204"}],
  SequenceForm["run ", 16, ",  \[Alpha] = ", 1., ",   gen = ", 5204],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035940806704`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "1.5`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4770"}],
  SequenceForm["run ", 17, ",  \[Alpha] = ", 1.5, ",   gen = ", 4770],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669035973802023`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "2.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4504"}],
  SequenceForm["run ", 18, ",  \[Alpha] = ", 2., ",   gen = ", 4504],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903600024391*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "3.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "4195"}],
  SequenceForm["run ", 19, ",  \[Alpha] = ", 3., ",   gen = ", 4195],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903602454578*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3913"}],
  SequenceForm["run ", 20, ",  \[Alpha] = ", 5., ",   gen = ", 3913],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903604711029*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "6.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3837"}],
  SequenceForm["run ", 21, ",  \[Alpha] = ", 6., ",   gen = ", 3837],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669036069643583`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "7.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3783"}],
  SequenceForm["run ", 22, ",  \[Alpha] = ", 7., ",   gen = ", 3783],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903609170233*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "8.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3742"}],
  SequenceForm["run ", 23, ",  \[Alpha] = ", 8., ",   gen = ", 3742],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903611303419*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "9.`", 
   "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3710"}],
  SequenceForm["run ", 24, ",  \[Alpha] = ", 9., ",   gen = ", 3710],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903613334442*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "10.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3686"}],
  SequenceForm["run ", 25, ",  \[Alpha] = ", 10., ",   gen = ", 3686],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903615358041*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "11.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3666"}],
  SequenceForm["run ", 26, ",  \[Alpha] = ", 11., ",   gen = ", 3666],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903617482945*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "12.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3651"}],
  SequenceForm["run ", 27, ",  \[Alpha] = ", 12., ",   gen = ", 3651],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903619537498*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "13.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3639"}],
  SequenceForm["run ", 28, ",  \[Alpha] = ", 13., ",   gen = ", 3639],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669036216429253`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "14.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3630"}],
  SequenceForm["run ", 29, ",  \[Alpha] = ", 14., ",   gen = ", 3630],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903623665576*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "15.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3623"}],
  SequenceForm["run ", 30, ",  \[Alpha] = ", 15., ",   gen = ", 3623],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903625643008*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "16.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3618"}],
  SequenceForm["run ", 31, ",  \[Alpha] = ", 16., ",   gen = ", 3618],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669036276477947`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "17.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3615"}],
  SequenceForm["run ", 32, ",  \[Alpha] = ", 17., ",   gen = ", 3615],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669036296785603`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "18.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3613"}],
  SequenceForm["run ", 33, ",  \[Alpha] = ", 18., ",   gen = ", 3613],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.7669036317396812`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "19.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3613"}],
  SequenceForm["run ", 34, ",  \[Alpha] = ", 19., ",   gen = ", 3613],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903633803342*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "20.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3615"}],
  SequenceForm["run ", 35, ",  \[Alpha] = ", 20., ",   gen = ", 3615],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903635822348*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "22.5`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "3627"}],
  SequenceForm["run ", 36, ",  \[Alpha] = ", 22.5, ",   gen = ", 3627],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903637831132*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "25.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3652"}],
  SequenceForm["run ", 37, ",  \[Alpha] = ", 25., ",   gen = ", 3652],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903639871969*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "30.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "3782"}],
  SequenceForm["run ", 38, ",  \[Alpha] = ", 30., ",   gen = ", 3782],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903642115759*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "40.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8698"}],
  SequenceForm["run ", 39, ",  \[Alpha] = ", 40., ",   gen = ", 8698],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903648658277*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "50.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8637"}],
  SequenceForm["run ", 40, ",  \[Alpha] = ", 50., ",   gen = ", 8637],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903655069216*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", "75.`",
    "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", "8538"}],
  SequenceForm["run ", 41, ",  \[Alpha] = ", 75., ",   gen = ", 8538],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903661807123*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"run \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\",  \[Alpha] = \"\>", "\[InvisibleSpace]", 
   "100.`", "\[InvisibleSpace]", "\<\",   gen = \"\>", "\[InvisibleSpace]", 
   "8469"}],
  SequenceForm["run ", 42, ",  \[Alpha] = ", 100., ",   gen = ", 8469],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.739197248131259*^9, 3.739197291391637*^9, 3.739197575211396*^9, 
   3.739197804800021*^9, 3.73919885981005*^9, 3.739199563829042*^9, {
   3.766846975111167*^9, 3.7668469966654987`*^9}, 3.766903668146429*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
   RowBox[{"-", "52"}], ",", "41.996693`8.074760079662948"}], "}"}]], "Output",\

 CellChangeTimes->{3.73919730612569*^9, 3.739197704901287*^9, 
  3.739197933743066*^9, 3.7391989883711777`*^9, 3.739199765725429*^9, 
  3.766846977468059*^9, 3.766847322882691*^9, 3.7669036681626997`*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"plotr", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", " ", 
     RowBox[{"{", 
      RowBox[{"c5", ",", "6"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.739199381633216*^9, 3.7391993972630253`*^9}}],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"plotr", "[", 
     RowBox[{"[", "c5", "]"}], "]"}], " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ListLogLinearPlot", "[", 
       RowBox[{
        RowBox[{"eqe2pop1", "[", 
         RowBox[{"[", "c5", "]"}], "]"}], ",", " ", 
        RowBox[{"Joined", " ", "\[Rule]", " ", "True"}], ",", " ", 
        RowBox[{"PlotRange", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1"}], "}"}]}], ",", " ", 
        RowBox[{"PlotStyle", " ", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "1.5", "]"}], ",", "Dashed", ",",
            " ", "Black"}], "}"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0.1", ",", " ", "1.0", ",", " ", "10.0", ",", " ", "100.0"}], 
            "}"}], ",", "Automatic"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"ListLogLinearPlot", "[", 
       RowBox[{
        RowBox[{"eqt2pop1", "[", 
         RowBox[{"[", "c5", "]"}], "]"}], ",", " ", 
        RowBox[{"Joined", " ", "\[Rule]", " ", "True"}], ",", " ", 
        RowBox[{"PlotRange", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1"}], "}"}]}], ",", " ", 
        RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "1.5", "]"}], ",", "Dashed", ",",
            "Gray"}], "}"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0.1", ",", " ", "1.0", ",", " ", "10.0", ",", " ", "100.0"}], 
            "}"}], ",", "Automatic"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"ListLogLinearPlot", "[", 
       RowBox[{
        RowBox[{"eqe2pop2", "[", 
         RowBox[{"[", "c5", "]"}], "]"}], ",", " ", 
        RowBox[{"Joined", " ", "\[Rule]", " ", "True"}], ",", " ", 
        RowBox[{"PlotRange", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1"}], "}"}]}], ",", " ", 
        RowBox[{"PlotStyle", " ", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "1.5", "]"}], ",", " ", 
           "Black"}], "}"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0.1", ",", " ", "1.0", ",", " ", "10.0", ",", " ", "100.0"}], 
            "}"}], ",", "Automatic"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"ListLogLinearPlot", "[", 
       RowBox[{
        RowBox[{"eqt2pop2", "[", 
         RowBox[{"[", "c5", "]"}], "]"}], ",", " ", 
        RowBox[{"Joined", " ", "\[Rule]", " ", "True"}], ",", " ", 
        RowBox[{"PlotRange", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", " ", "1"}], "}"}]}], ",", " ", 
        RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "1.5", "]"}], ",", "Gray"}], 
          "}"}]}], ",", 
        RowBox[{"Ticks", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0.1", ",", " ", "1.0", ",", " ", "10.0", ",", " ", "100.0"}], 
            "}"}], ",", "Automatic"}], "}"}]}]}], "]"}]}], "]"}]}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"c5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.656419070089164*^9, 3.656419117883933*^9}, {
   3.6564202883825083`*^9, 3.6564202899115553`*^9}, 3.673354363087408*^9, {
   3.673354557189188*^9, 3.673354584890415*^9}, {3.7003908624221087`*^9, 
   3.700390866383185*^9}, {3.7005840932330513`*^9, 3.7005840990876303`*^9}, {
   3.70058559537833*^9, 3.700585609713868*^9}, {3.700586020052052*^9, 
   3.7005860321717987`*^9}, {3.700586122784287*^9, 3.700586122960228*^9}, {
   3.700586402697667*^9, 3.700586408018127*^9}, {3.7391816221308413`*^9, 
   3.739181622362679*^9}, {3.739199241399781*^9, 3.739199334740759*^9}, {
   3.739199405380457*^9, 3.7391994074289703`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"plotr", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"plotr", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", 
     RowBox[{"plotr", "[", 
      RowBox[{"[", "3", "]"}], "]"}], ",", 
     RowBox[{"plotr", "[", 
      RowBox[{"[", "4", "]"}], "]"}], ",", 
     RowBox[{"plotr", "[", 
      RowBox[{"[", "5", "]"}], "]"}], ",", 
     RowBox[{"plotr", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}], "}"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.739199341872052*^9, 3.7391993765482388`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYD7ep//////95+Hff0XT7fGA70ZE9e
tqvgpL34FtV6EVaGA86ZsVPEo4/ZSxyxqpkV9W+/TJV9np7YEfvDnUYnjB//
3t/ovDtR2+egvXHv2++OB37u55JXqFNs3Wf/3vLXPye9b/tVZ786JfZih73i
8r1/Kpw/77d7/+l/pslW+zM5Wz2EznzYr9Oz8l3T5E325Q8efHAIers/MMzH
79mcDVD9z/a/t/6Wc/TAavsgkcZf6yIe7I9b85xrkvwK+wD7hyqHL1/b36LH
s/Fn11J7hVmzjn/vP7P/3yyV6TfmLraPceRSfPFj1/5b3zZP1VJYZM8ABbfT
4/elfVhg7zNj/xvlzzfto2ep7bx1fxbMPvtbCiuP5DVPt+dmXlv1avJH+xxz
x7kBBVNg/rOf+/Sq2aLtk+yZFLR+ca/+Y3/d3ZLz6vxJ9uFRRuuKlP7brzjZ
eVX36CT74tXW9psWMTj0Mte3lIpMhprH6LD3YEFqZPNkezFI+DvYrp8czswz
xd7HvH77Yz1mhxNblrySWj3Fvnbe5T1iD5kd5i/afvB43FT7wB5DbZZWFofE
uOC/WmrT7Jfvvi52SobV4fOB220ijNPt5T18LcVWsTpoqN7afeP9dKh/2Bxa
1iZdtfg8w76q/tfB7FVsDqoX/nwL45ll3zYx26pant2hYlek0iab2fY6m1nY
zPrYHRaVcMpqtM2xn/i4uNrpO7tDg6hxxp9Xc+01rJ9uq3rB4cCTzqT15scC
aHhwOnxSF2ZwrFhsP/sa989lptwOT59ecRA5uMqet8jI+nITr4PZ4//g9LVe
es32S978DskvIPwY9kWzpF0FHXY9gfAh4SHkMOcehA8ACTdOGA==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYD7ep//////95+Hff0XT7fGA70ZE9e
tqvgpL34FtV6EVaGA86ZsVPEo4/ZSxyxqpkV9W+/TJV9np7YEfvDnUYnjB//
3t/ovDtR2+egvXHv2++OB37u55JXqFNs3Wf/3vLXPye9b/tVZ786JfZih73i
8r1/Kpw/77d7/+l/pslW+zM5Wz2EznzYr9Oz8l3T5E325Q8efHAIers/MMzH
79mcDVD9z/a/t/6Wc/TAavsgkcZf6yIe7I9b85xrkvwK+wD7hyqHL1/b36LH
s/Fn11J7hVmzjn/vP7P/3yyV6TfmLraPceRSfPFj1/5b3zZP1VJYZM8ABbfT
4/elfVhg7zNj/xvlzzfto2ep7bx1fxbMPvtbCiuP5DVPt+dmXlv1avJH+xxz
x7kBBVNg/rOf+/Sq2aLtk+yZFLR+ca/+Y3/d3ZLz6vxJ9uFRRuuKlP7brzjZ
eVX36CT74tXW9psWMTj0Mte3lIpMhprH6LD3YEFqZPNkezFI+DvYrp8czswz
xd7HvH77Yz1mhxNblrySWj3Fvnbe5T1iD5kd5i/afvB43FT7wB5DbZZWFofE
uOC/WmrT7Jfvvi52SobV4fOB220ijNPt5T18LcVWsTpoqN7afeP9dKh/2Bxa
1iZdtfg8w76q/tfB7FVsDqoX/nwL45ll3zYx26pant2hYlek0iab2fY6m1nY
zPrYHRaVcMpqtM2xn/i4uNrpO7tDg6hxxp9Xc+01rJ9uq3rB4cCTzqT15scC
aHhwOnxSF2ZwrFhsP/sa989lptwOT59ecRA5uMqet8jI+nITr4PZ4//g9LVe
es32S978DskvIPwY9kWzpF0FHXY9gfAh4SHkMOcehA8ACTdOGA==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDApf+/f///739Ou7pu3y+MRy4sKv9
1uTE1/biW1TrRVgZDvza5OBguOm1vcQRq5pZUf/2H9j9pmfL/9f2hzuNThg/
/r2/K273jb78N/bGvW+/Ox74uT/Yv7Ap99Qb+/eWv/456X3bf/Gg//rEwLf2
isv3/qlw/rx/x5ljVYHr39qfydnqIXTmw/6euTMTvn9+a1/+4MEHh6C3+3dd
Cu7V1HgH1f9s/0rRaxoiRe/sg0Qaf62LeLC/7EjEoeOL39kH2D9UOXz52v5L
XfJ5Wcff2SvMmnX8e/+Z/aFR1fe0H72zj3HkUnzxY9f+abzqk79/e2fPAAV7
TjsKTWJ/b+8zY/8b5c837RkWlidet3gPs89+/7oVmYsD3ttzM6+tejX5o73z
jgPKXWnvYf6z73ZhncpX/N6eSUHrF/fqP/Zzdm//+ALID48yWlek9N+eXd69
UQrIL15tbb9pEYMD8/9DdbqFMPMYHVafe2KYm/feXgwS/g479gg5smYD3WNe
v/2xHrNDfOjtt/zp7+1r513eI/aQ2YF79WzDuUnv7QN7DLVZWlkcwlWf9W+L
fW+/fPd1sVMyrA5x8/Y5J0a8t5f38LUUW8XqkPmupGd+EMw/bA4Ke87WFPq8
t6+q/3UwexWbw6dXEo1XXd/bt03MtqqWZ3cwj/q484Tde3udzSxsZn3sDgse
TLB1N39vP/FxcbXTd3aHkFv53j767+01rJ9uq3rB4SBVzP1FQRIWHpwOht//
ZNf/f2c/+xr3z2Wm3A7PuJc4sx18Z89bZGR9uYnX4c2P/+D0tV56zfZL3vwO
5r8g/Bj2RbOkXQUdin9C+JDwEHKQh6oHABO+Wsk=
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDApf+/f///739Ou7pu3y+MRy4sKv9
1uTE1/biW1TrRVgZDvza5OBguOm1vcQRq5pZUf/2H9j9pmfL/9f2hzuNThg/
/r2/K273jb78N/bGvW+/Ox74uT/Yv7Ap99Qb+/eWv/456X3bf/Gg//rEwLf2
isv3/qlw/rx/x5ljVYHr39qfydnqIXTmw/6euTMTvn9+a1/+4MEHh6C3+3dd
Cu7V1HgH1f9s/0rRaxoiRe/sg0Qaf62LeLC/7EjEoeOL39kH2D9UOXz52v5L
XfJ5Wcff2SvMmnX8e/+Z/aFR1fe0H72zj3HkUnzxY9f+abzqk79/e2fPAAV7
TjsKTWJ/b+8zY/8b5c837RkWlidet3gPs89+/7oVmYsD3ttzM6+tejX5o73z
jgPKXWnvYf6z73ZhncpX/N6eSUHrF/fqP/Zzdm//+ALID48yWlek9N+eXd69
UQrIL15tbb9pEYMD8/9DdbqFMPMYHVafe2KYm/feXgwS/g479gg5smYD3WNe
v/2xHrNDfOjtt/zp7+1r513eI/aQ2YF79WzDuUnv7QN7DLVZWlkcwlWf9W+L
fW+/fPd1sVMyrA5x8/Y5J0a8t5f38LUUW8XqkPmupGd+EMw/bA4Ke87WFPq8
t6+q/3UwexWbw6dXEo1XXd/bt03MtqqWZ3cwj/q484Tde3udzSxsZn3sDgse
TLB1N39vP/FxcbXTd3aHkFv53j767+01rJ9uq3rB4SBVzP1FQRIWHpwOht//
ZNf/f2c/+xr3z2Wm3A7PuJc4sx18Z89bZGR9uYnX4c2P/+D0tV56zfZL3vwO
5r8g/Bj2RbOkXQUdin9C+JDwEHKQh6oHABO+Wsk=
           "]]}}, {}, {}, {{}, {}}}},
      
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}], 
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDJtWa9jsrbtiv456+y+cbw4EA0cj1
a1tO24tvUa0XYWU4cOiJQ3o/4wl7iSNWNbOi/u3nefWh2bHnqP3hTqMTxo9/
71daKipSNOmQvXHv2++OB37u357VIZiWccD+veWvf0563/ZL7Q99lHxzl73i
8r1/Kpw/79e8teyBxvNt9mdytnoInfmwP1k9yXu/+Bb78gcPPjgEvd1fdHXd
RKG/G6H6n+1PWbvNN0linX2QSOOvdREP9k/pb1x9UG+VfYD9Q5XDl6/t/71+
VYtY6nJ7hVmzjn/vP7P//U9p0TT/pfYxjlyKL37s2v9G/bTn9o2L7RmgIHzJ
7iK+jEX2PjP2v1H+fNNe70LF19kGc2H22Tvd1ZPia55pz828turV5I/25ZdO
nSuTnQbzn32CcmH5DMUp9kwKWr+4V/+xdws/+Gvnj8n24VFG64qU/tt/LH+3
8pDgFPvi1db2mxYxOBhwbzPcEj4Fah6jw6kVNx/Z7p9iLwYJfwf9L/zrPzhO
tfcxr9/+WI/Z4cadrA6hO1Pta+dd3iP2kNlBN5rhXGf3NPvAHkNtllYWhx5p
+QAv/+n2y3dfFzslw+rQpRXbxKw+w17ew9dSbBWrQ+43n8cfhWZC/cPmEPPy
3s4jwrPsq+p/HcxexebAmaOfM0Frtn3bxGyranl2h2urWQNORsyx19nMwmbW
x+7wbHbfGZcFc+0nPi6udvrO7tBtcPesPfN8ew3rp9uqXnA4vKme1fG9aSE0
PDgdDktoTCtnWGI/+xr3z2Wm3A683N+kF7mttuctMrK+3MTroBoPSV/rpdds
v+TN77CpHMKPYV80S9pV0OF1C4QPCQ8hhzepED4A/uM93Q==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDDGDwwX4d9/RdPt8YDkR77lN4V37K
XnyLar0IK8OBBKVP8R73jtlLHLGqmRX1bz9fjMSKxvQj9oc7jU4YP/69X+jz
TZ3/FQftjXvffnc88HO/2t5nd5bt3Wf/3vLXPye9b/u9agVWcrHstFdcvvdP
hfPn/QVrKmddd9lqfyZnq4fQmQ/7tUQP+DnO22Rf/uDBB4egt/v/sR9mKVuy
Aar/2f4LTF/3lJ5cbR8k0vhrXcSD/V/NJaY6q66wD7B/qHL48rX9Ae+lbLn7
l9orzJp1/Hv/mf3zp8878H7BYvsYRy7FFz927be9FOMzX2mRPQMULE5c+zr7
0wJ7nxn73yh/vmk///u6qZ8ezoLZZ29g4vT4fst0e27mtVWvJn+052krFfcu
nALzn/2nr2H2qTsm2TMpaP3iXv3HvuXw+S+TF0yyD48yWlek9N/+hqGw8Puj
k+yLV1vbb1rE4ND3vqXeVnQy1DxGh16d/Qu1Wybbi0HC36HhwI3vj3im2PuY
129/rMfswNL/7hfXmin2tfMu7xF7yOyw4vf29NPxU+0Dewy1WVpZHN4eUZ/r
qj7Nfvnu62KnZFgdVs7a89iTabq9vIevpdgqVoebqrySuh+nQ/3D5vD10hqp
jV9m2FfV/zqYvYrNYflT7ds/eGfZt03MtqqWZ3dIPq4Y32I3215nMwubWR+7
g2PKwvVGHXPsJz4urnb6zu5wt37jY4+3c+01rJ9uq3rB4XBPeMH/hl8LoOHB
6RBmc3phU9Vi+9nXuH8uM+V2+GIuLVl6bJU9b5GR9eUmXod//0Hgvf166TXb
L3nzO/yH8mPYF82SdhV0gKU/SHgIwfkAmChFJQ==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYD7xc9TFh8+LH9Ou7pu3y+MRz46Nog
wcn22l58i2q9CCvDAUZvdsEzka/tJY5Y1cyK+rd/eqS21JM1r+0PdxqdMH78
e39AaLO6peobe+Pet98dD/zcP33tNdmvbW/s31v++uek923/q1sxS0Ul3tor
Lt/7p8L58/7IwKl8BrVv7c/kbPUQOvNhf+XVgo9ax9/alz948MEh6O3+2/06
S2v/v4Xqf7Zfgz+lKsn/nX2QSOOvdREP9k9nre0ybX1nH2D/UOXw5Wv7e+sr
ou6sfmevMGvW8e/9Z/bv+/Tf8vWJd/YxjlyKL37s2i8iErGi/f47ewYo2M/T
/n3mx3f2PjP2v1H+fNNe7M7p+zHq72H22f+2iNhe4vjenpt5bdWryR/tTavc
Lm+IfA/zn33T3MXiMhnv7ZkUtH5xr/5jv+7NP9uizPf24VFG64qU/tvvd3HR
+wuUL15tbb9pEYPDnZ5wppB0mHmMDlcLGQ1Opry3F4OEv4OMme6GnsT39j7m
9dsf6zE73DWf3bY79r197bzLe8QeMjuc3rGnJR1of2CPoTZLK4vDpj83S2eH
vLdfvvu62CkZVge25VvqY/3f28t7+FqKrWJ1mLvErW+DJ8w/bA61qx3Mpjq/
t6+q/3UwexWbg6DOEncu2/f2bROzrarl2R2EhO4a8Jq9t9fZzMJm1sfuELTu
lOssvff2Ex8XVzt9Z3dYNSXu+xq19/Ya1k+3Vb3gcDhZ8Xr+AgFYeHA6JNRM
/Sf1/Z397GvcP5eZcjscOuyjf3XHO3veIiPry028Dm+mQNLXeuk12y958zsY
LITwY9gXzZJ2FXQ4tRzCh4SHkIP7DAgfAOTXTQk=
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQB2IQLRq6dffGbKYDDGDwwX4d9/RdPt8YDqQpWr2elfDa
XnyLar0IK8MBmZ2RGttWv7aXOGJVMyvq3/7gXm5125+v7Q93Gp0wfvx7f6y4
w5vJWW/sjXvffnc88HP/jGepQvuOvbF/b/nrn5Pet/0W6Wd+2vu/tVdcvvdP
hfPn/Refb7/9be1b+zM5Wz2EznzYH5Rcc5zz81v78gcPPjgEvd2vefX2kxr1
d1D9z/avrtDfu6bwnX2QSOOvdREP9p+7oKjetPidfYD9Q5XDl6/tX9ExZZf5
8Xf2CrNmHf/ef2b/1LVnT7I8emcf48il+OLHrv1OubrqN769s2eAgjk1tj/L
2d/b+8zY/0b58037hbz2+Sct3sPss/cUfrxkZsB7e27mtVWvJn+0PyF2PL05
7T3Mf/bJi5ICOYvf2zMpaP3iXv3H/tJv5guPgfzwKKN1RUr/7S/+sooQBfKL
V1vbb1rE4ODd8dRIoxBmHqODzOzAdel57+3FIOHv0HFTuuR/FtA95vXbH+sx
O4QsdjzOmf7evnbe5T1iD5kdVNc0LpyW9N4+sMdQm6WVxeHcfrm29bHv7Zfv
vi52SobVQTDVe31kxHt7eQ9fS7FVrA753bLR04Ng/mFz6H1/ZFaGz3v7qvpf
B7NXsTkcb1tx47Tre/u2idlW1fLsDv+itI332b2319nMwmbWx+4weRrrPmvz
9/YTHxdXO31nd3gU/narvf57ew3rp9uqXnA4iLqViAhKwsKD0+HibxH/7P/v
7Gdf4/65zJTbQabsybznB97ZcxYZWV9u4nWApS8AAWoxDA==
           "]], 
          LineBox[{{3.8376418216567427`, 1.}, {3.912023005428146, 
           0.9999999999999999}, {4.31748811353631, 1.}, {4.605170185988092, 
           0.9999999999999998}}]}}, {}, {}, {{}, {}}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}], 
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDJema9jsrbtiv456+y+cbwwEtHwhf
fItqvQgrwwGmRghf4ohVzayof/sfufTMuM16wf5wp9EJ48e/99dGqm1nvnza
3rj37XfHAz/3251Zad366oT9e8tf/5z0vu3f+OH895i7R+wVl+/9U+H8eX9a
mkjrFqlD9mdytnoInfmwv+Kiz5cbogfsyx88+OAQ9Ha/06fdrzeK7IXqf7Z/
6Ryd14YrdtgHiTT+WhfxYP81v1sNdxZvtQ+wf6hy+PK1/ZN0lkwrL95srzBr
1vHv/Wf2n9eO+Vx+aqN9jCOX4osfu/arLM5Z61K7wZ4BCvJkVDoTH62z95mx
/43y55v2ix5YnfftXwGzz/5U1KTVTzOW2nMzr616NfmjfVQBe011zCKY/+wP
Wf+2Wuu4wJ5JQesX9+o/9kk5vltPn5hvHx5ltK5I6b99XWXFw6qK+fbFq63t
Ny1icAjL3/kmNW8+1DxGh6V/T0lfmTbfXgwS/g5ZuRbOzs/m2/uY129/rMfs
cMu31+iu1gL72nmX94g9ZHbY0Wq0ubJggX1gj6E2SyuLw+oK/1nrDy2wX777
utgpGVaHTREmz04rLLSX9/C1FFvF6nDNb9G2tq6FUP+wOWyfL37j1f+F9lX1
vw5mr2JziHngPM+9cZF928Rsq2p5doet53lKNPkX2+tsZmEz62N3YPv0QDN8
1WL7iY+Lq52+szvoLMn4cyl4ib2G9dNtVS84HB7e6D0h6LwMGh6cDhU1MXpr
N6ywn32N++cyU26Hdk097uf319vzFhlZX27iddBKhKSf9dJrtl/y5ndga4fw
Y9gXzZJ2FXTYVwThQ8JDyOFBJYQPAC3uRgA=
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDDGDwwX4d9/RdPt8Y4HzxLar1IqwI
vsQRq5pZUf/268W3/AtTPW5/uNPohPHj3/v57T1kf105ZG/c+/a744Gf+xV/
9a4KMztg/97y1z8nvW/7j2fO2Nt5a6e94vK9fyqcP+/3TrpycveRrfZncrZ6
CJ35sH/SoetfmT9vsi9/8OCDQ9Db/fGrr+meerABqv/Z/qqWBsE//Gvsg0Qa
f62LeLD/wKw1d7hDVtgH2D9UOXz52v5upw95xzcstVeYNev49/4z+90KLPbt
3bXYPsaRS/HFj137XYsk3tuaL7JngAL3UuX+UuaF9j4z9r9R/nzTXqtjk8qN
z7Ng9tlPWFTJ7jVxuj0389qqV5M/2svx/NE8XjkF5j97y7b8cq79k+yZFLR+
ca/+Y28qvumy+PJJ9uFRRuuKlP7bt4QnSHSemWRfvNraftMiBofFhxf8EpaZ
DDWP0WHmOmXt2O7J9mKQ8HfwvKz1pUtkir2Pef32x3rMDt+C9GVdtkyxr513
eY/YQ2aHpm0hwRszptoH9hhqs7SyOPDXd6t9M5hmv3z3dbFTMqwOl+9L6T/j
mW4v7+FrKbaK1aH7r8LeW3+mQ/3D5nBY80zSbMaZ9lX1vw5mr2Jz6HFLdwyS
mWXfNjHbqlqe3eGwj3Vkh99se53NLGxmfewOYv+WvlefNcd+4uPiaqfv7A4M
RRHmLYzz7DWsn26resHhMKNnb1MBx0JoeHA6/F/xsT63b7H97GvcP5eZcjuU
lDGGOnxbZc9bZGR9uYnXAZZ+1kuv2X7Jmx/Oj2FfNEvaVRDOh4SHEJwPAJ6b
KsA=
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDQjMfJiw+/Nh+Hff0XT7fGA5kdEP4
4ltU60VYGQ7cWgrhSxyxqpkV9W+//7Gl7/7WvLQ/3Gl0wvjx7/17fqYpdYu9
sjfuffvd8cDP/ULMm1W9Zr2yf2/565+T3rf9i+Ze3nYx5bW94vK9fyqcP+/f
Pv2c4IRvr+3P5Gz1EDrzYb9af1TPmeQ39uUPHnxwCHq7/+95yYddO95A9T/b
nyK/domr8Vv7IJHGX+siHuxnUeA8faD9rX2A/UOVw5ev7bf4e6Q/+ehbe4VZ
s45/7z+zv9bGcaLvl7f2MY5cii9+7Nr/7+/cK7qS7+wZoIDnx/VLz83e2fvM
2P9G+fNNe7P1+1h/TngHs88+wzy5hHHfO3tu5rVVryZ/tJ+6fLHs/pfvYP6z
t+C/8MqB4709k4LWL+7Vf+wFG3lKtvK+tw+PMlpXpPTfXm1aSp+1wHv74tXW
9psWMTiclu/feQ3Ih5jH6ODs8VFKDMgXg4S/w2HB9z5+fO/tfczrtz/WY3bg
ebz4wGbu9/a18y7vEXvI7OAQUPA9HWhfYI+hNksri4NHT/KSBpb39st3Xxc7
JcPq8HFq1X5uhvf28h6+lmKrWB3W6vJ+F/wN8w+bw9yH3mYzvr6zr6r/dTB7
FZvD9Bt6ixa8f2ffNjHbqlqe3aHoTJezNtB/OptZ2Mz62B1u+mypM3v0zn7i
4+Jqp+/sDqfWauXuv/XOXsP66baqFxwOTVeYQg8chYUHp8MZsdbDumvf2c++
xv1zmSm3w7Lsq6dXFryz5y0ysr7cxOvweiok/ayXXrP9kje/w60VEH4M+6JZ
0q6CDtvmQfiQ8BBycF8E4QMAMcdT1g==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQLRq6dffGbKYDDGDwwX4d9/RdPt8Y4HzxLar1IqwI
vsQRq5pZUf/2f0/98V/22mv7w51GJ4wf/95/LO/CuwqPN/bGvW+/Ox74uT/A
e+0J1TVv7N9b/vrnpPdtv7S3pJqu/Vt7xeV7/1Q4f97vLbovumHxW/szOVs9
hM582L9kYvGTva/f2pc/ePDBIejt/mrRth2ySu+g+p/tPx0b05qa984+SKTx
17qIB/s79bNF3Ba+sw+wf6hy+PK1/XyLfqtOPvrOXmHWrOPf+8/sP/8i0n/f
g3f2MY5cii9+7Npvxvrd6MLXd/YMUFA778eh2Wzv7X1m7H+j/PmmfehJbtUg
i/cw++ydWzY1uga8t+dmXlv1avJHe5Ftbf880t7D/Gef+kw29XbRe3smBa1f
3Kv/2B9VuflrW/F7+/Aoo3VFSv/tFTRKzV4A5YtXW9tvWsTg8PvQsWs/C2Dm
MTrcCAtLMs97by8GCX+HuA75eWeygO4xr9/+WI/Z4QOXyc3LQPtq513eI/aQ
2WHSnlCB2KT39oE9htosrSwOSkVnDhfGvrdfvvu62CkZVoeeKRlq4hHv7eU9
fC3FVrE6sE7xzfYPgvmHzUH78sypUj7v7avqfx3MXsXm0Dnj4L8y1/f2bROz
rarl2R2cftdsTLR7b6+zmYXNrI/d4XKv/+prZu/tJz4urnb6zu5wfG+jwEW9
9/Ya1k+3Vb3gcLiQJZzbKgELD06Hzc/cXHb9e2c/+xr3z2Wm3A5MpZ4Ot/a/
s+ctMrK+3MTr8Pc/CLy3Xy+9Zvslb36H/1B+DPuiWdKugg6w9AUAeMo/Eg==

           "]]}}, {}, {}, {{}, {}}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}], 
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDs7M07XdW3LBfxz19l883hgPKTRC+
+BbVehFWhgNclRC+xBGrmllR//bPgfIPdxqdMH78e79WsF+b5Mbr9sa9b787
Hvi5P6rjyZu8Pdfs31v++uek922/JfNCefvsq/aKy/f+qXD+vD9TuWBGbtQV
+zM5Wz2EznzYn3s5fsvqvMv25Q8efHAIerv/dFLtY575l6D6n+1n3aOUY+p4
0T5IpPHXuogH+y8pbLRmUrtgH2D/UOXw5Wv7H7bsq/xRcc5eYdas49/7z+z3
tM79dv/jGfsYRy7FFz927ed6aLWHadlpewYoUDtz20Cl85S9z4z9b5Q/37S/
corrPPvuYzD77L9zhk3tajtiz828turV5I/2fldj3jFIHoL5z17zVYLHbbYD
9kwKWr+4V/+xz+xauJuZfb99eJTRuiKl//ZPu0S1XgXtsy9ebW2/aRGDA5/I
hr/TruyFmsfoYGuStHJm9V57MUj4Oxh05HK9s91r72Nev/2xHrPDQ8Znz7RF
99rXzru8R+whs8MrJ5Ywkb977AN7DLVZWlkcrhy7+P/opz32y3dfFzslw+qw
/vVkbvcve+zlPXwtxVaxOixIP3/DlmEv1D9sDrbPFFcdAZpXVf/rYPYqNgdN
18hZviZ77dsmZltVy7M7fL/N/XJC9F57nc0sbGZ97A6HdrFZNHXvtZ/4uLja
6Tu7w8YZW094Hdlrr2H9dFvVCw6HNc9ePL1avQ8aHpwOi0RfVRVW7reffY37
5zJTboc4wf2KpokH7XmLjKwvN/E6CELTy3rpNdsvefM7aFZB+DHsi2ZJuwo6
7ICmN0h4CDlsiYLwAdG+QQE=
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQvY57+i6fbwwHGMDgg734FtV6EVYEX+KIVc2sqH/7
YfzDnUYnjB//3r+98n9K49Vj9sa9b787Hvi5P6PDJ7Ci7ZD9e8tf/5z0vu1/
1fclc2fMHnvF5Xv/VDh/3l9medBySc52+zM5Wz2EznzY379JIXex6hb78gcP
PjgEvd1vs+Se+tTTG6H6n+3vKisUynFeax8k0vhrXcSD/V5psh82GK60D7B/
qHL48rX9bu8v2UpEL7NXmDXr+Pf+M/vX7u/32OK8xD7GkUvxxY9d+2d/vX3f
aOUiewYomDT9Z/j5lIX2PjP2v1H+fNP++Xt+q7rU2TD77EtU7jxZ/2S6PTfz
2qpXkz/a//n0cZf1tikw/9mHvM5YcubDJHsmBa1f3Kv/2Het3buw+cYk+/Ao
o3VFSv/tK7+XqUr8n2RfvNraftMiBofTz6uYrwVMhprH6NBW0dlifHiyvVjo
1t0bs5kcKpr6T7sGTLH3Ma/f/liP2eFRunvS5i9T7GvnXd4j9pDZoSVY3mPD
uqn2gT2G2iytLA7K4Zx7S2qn2S/ffV3slAyrQ54W552PCdPt5T18LcVWsTqk
HAk8vTxyBtQ/bA46G5ln92fMtK+q/3UwexWbQxPj4e2C/bPs2yZmW1XLszv0
cDAEs56fba+zmYXNrI/dwUJggeR2rbn2Ex8XVzt9Z3e49HHCtW9L5tlrWD/d
VvWCw0HDM5rFtGohNDw4HY748PyPNl5iP/sa989lptwOr/YfPVwwa409b5GR
9eUmXgdYelkvvWb7JW9+OD+GfdEsaVdBh3//QeA9NDyE4PIAYo8wfQ==
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDK2Y9TFh8+LH9Ou7pu3y+MRxIXwbh
i29RrRdhZThwdyGEL3HEqmZW1L/9yosg/MOdRieMH//e/0wsLiL6xFN74963
3x0P/Nxv9WTBm5Mfn9q/t/z1z0nv2/5CVY0T1xKe2Ssu3/unwvnz/lfzWc6f
OP3M/kzOVg+hMx/2d875Lnpd57l9+YMHHxyC3u5f8qKEQ7blOVT/s/2LxHOy
fSRf2AeJNP5aF/Fg/5Y1WR5uk1/YB9g/VDl8+dr+L0Zx9zN+vLBXmDXr+Pf+
M/t5U7jC031f2sc4cim++LFr/xEGJ+9tU1/aM0BB8Rtzu+eXX9r7zNj/Rvnz
Tfv/Zv0n/Va+gtlnzzlnz8cC1df23Mxrq15N/mh/9Vg6V8u61zD/2dvo9+V8
UX5jz6Sg9Yt79R/7B6wCD+wd39iHRxmtK1L6b+/nsGJrRegb++LV1vabFjE4
HOj05j2X/AZqHqPD0pchPwTz3tiLQcLf4dOE5c2JpW/sfczrtz/WY3Y4XvRK
o6TqjX3tvMt7xB4yOyhaJO4+UvvGPrDHUJullcVhs9Stb8vr39gv331d7JQM
q0P5pu8LIxve2Mt7+FqKrWJ12Ohd28cC5EP8w+bwzvHeyuN1b+yr6n8dzF7F
5vB/23XfnTVv7NsmZltVy7M7bDVUrX1Z+cZeZzMLm1kfu4OosGpRctkb+4mP
i6udvrM7fEks26dX9MZew/rptqoXHA4rJk7mOpnyBhoenA5/zxrrhQa/sZ99
jfvnMlNuhyVyNT9/q7yx5y0ysr7cxOvwBJp+1kuv2X7Jm98hB5p+YtgXzZJ2
FXTYAk1vkPAQctg8CcIHAO+fVcg=
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQLb5FtV6EleEAAxh8sJc4YlUzK+rffhj/cKfRCePH
v/dHWL49oi7yxt649+13xwM/92vvcpy+rOCN/XvLX/+c9L7tj/9m6LRY8K29
4vK9fyqcP++fxC6b19H41v5MzlYPoTMf9jO11Vj3XXxrX/7gwQeHoLf73dhy
1zvwvoPqf7a/LuuUjWDCO/sgkcZf6yIe7L9sLK+5ZNo7+wD7hyqHL1/bb5t/
a5Xt3nf2CrNmHf/ef2Z/bNdy9o8339nHOHIpvvixa38gq2SR2Id39gxQcCdy
8prVjO/tfWbsf6P8+aZ9hs/ky5Gm72H22X82vTifz++9PTfz2qpXkz/a369Y
+G15ynuY/+y3sOoaNRe+t2dS0PrFvfqPvdepw2uSit7bh0cZrStS+m+v58xe
3AeUL15tbb9pEYPDbbOv8lPyYeYxOti9vTv1QM57e7HQrbs3ZjM5HAtxs3XI
BLrHvH77Yz1mh/d3pi/RTX1vXzvv8h6xh8wOBpbbTs1IeG8f2GOozdLK4sD1
RpmjO/q9/fLd18VOybA6VP147c4Z9t5e3sPXUmwVq4OWRmuUaADMP2wOEjLc
J9Z5vrevqv91MHsVm0OG+uvwy07v7dsmZltVy7M7GN84kVNv/d5eZzMLm1kf
u8Ps4hL3dcbv7Sc+Lq52+s7ucGvHWdso7ff2GtZPt1W94HBo/Ms7WUEEFh6c
Dlw3XI8r/XxnP/sa989lptwOXIqvP9Vsf2fPWWRkfbmJ1wGWXgB+HxVi
           
           "]]}}, {}, {}, {{}, {}}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}], 
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDUhGa9jsrbtiv456+y+cbw4F73hC+
+BbVehFWhgP5XhC+xBGrmllR//bv6oXwD3canTB+/Ht/Sc3BJRMn37A37n37
3fHAz/05/icmmErfsH9v+eufk963/UukdskItVy3V1y+90+F8+f9G6rkEtTZ
rtufydnqIXTmw/6f3h8V3CZfsy9/8OCDQ9Db/TN+29SlalyD6n+2v/ibkUZZ
2lX7IJHGX+siHuy3fhibpLf7in2A/UOVw5ev7W9qOs9lqnzFXmHWrOPf+8/s
n9K8+9rx2ZftYxy5FF/82LXf2fiL/0Sly/YMUFCz4pftzK2X7H1m7H+j/Pmm
fTVzefR+qYsw++zVPs75f5/3gj0389qqV5M/2s85qvSzv/cszH/2FpqZjeHy
p+2ZFLR+ca/+Y8/712bx1/JT9uFRRuuKlP7bL3x48Mfr/yfti1db229axOAQ
F5nPVLr8JNQ8RgfTBPNGu9ST9mKQ8HdwkkhlLjQ+ae9jXr/9sR6zQ+aRG1st
+E7a1867vEfsIbODCM//Q38/nbAP7DHUZmllcVDp/9zz+f4J++W7r4udkmF1
ePWh/ebVyyfs5T18LcVWsTosKli3ef/ZE1D/sDmUNSZnCgL5VfW/DmavYnMI
XX3sWvzFE/ZtE7OtquXZHRgvLdiUeeuEvc5mFjazPnaHU0eTvgq8OGE/8XFx
tdN3doeIA95u4b9O2GtYP91W9YLDwWkt0/pE25PQ8OB0mBae8tdoyUn72de4
fy4z5XYQEDvn8kjjtD1vkZH15SZeB6cqSHpZL71m+yVvfoc3lRB+DPuiWdKu
gg7B0PQECQ8hh1VQ9QDREUZf
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], 
          LineBox[{{-2.3025850929940455`, 
           0.9999999999999999}, {-2.241811240729394, 1.}}], 
          LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBGIQ/Sj+3pwNtQwHGMDgg734FtV6EVaGA//+g8B7e4kj
VjWzov7th8kf7jQ6Yfz49/4Fbz+v37f3uL1x79vvjgd+7k9d87c36fch+/eW
v/456X3bf2EnZ+PVl3vsFZfv/VPh/Hm/RuI0M+dr2+3P5Gz1EDrzYb+/7aOA
r1Vb7MsfPPjgEPR2v4JT0rp84U1Q/c/2L0m/s0J341r7IJHGX+siHuz/d/Ws
3qWulfYB9g9VDl++tj9tiq1i8rJl9gqzZh3/3n9m/1KxUyEyrUvsYxy5FF/8
2LVfofUTv+XjRfYMUKDoyv5TaeZCe58Z+98of75pv05t/s2562bD7LO3mnKH
XUhhhj0389qqV5M/2rN942IMeDYF5j/7mAsLriXJTLZnUtD6xb36j72JJ7/F
e5bJ9uFRRuuKlP7bn+mQvpKhO9m+eLW1/aZFDA5yP/ZkPWqcDDWP0eFuQIHj
nu+T7cVCt+7emM3ksCX9iCZH5xR7H/P67Y/1mB2KTk7yKTWaal877/IesYfM
DksW55Z4fppqH9hjqM3SyuKw5FYTy/Xj0+yX774udkqG1eFNZe5jw83T7eU9
fC3FVrE68PVnXmXbOgPqHzYH6WSDkPZzM+2r6n8dzF7F5vDqEfeLJMbZ9m0T
s62q5dkdZvg5rTjlP8deZzMLm1kfu8Mdxw3ravfMtZ/4uLja6Tu7Q92yg5fv
ec2317B+uq3qBYfDmbMJ/K/fL4SGB6fDj22pOtMfLbGffY375zJTbgdjkav6
ulPW2fMWGVlfbuJ1gKWX9dJrtl/y5ofzY9gXzZJ2FYTzIeEhBOcDAGmFL54=

           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDSRMfJiw+/Nh+Hff0XT7fGA44dkP4
4ltU60VYGQ70dkH4EkesamZF/duvvQbCP9xpdML48e/971JyNC5efGJv3Pv2
u+OBn/uzt8+4pvPgif17y1//nPS+7fevfNBSLf7UXnH53j8Vzp/371x/MMo2
4Kn9mZytHkJnPuzP7k9fsKX1qX35gwcfHILe7s+8656fvv0pVP+z/fpL274k
CDyzDxJp/LUu4sF+8TatWW2xz+wD7B+qHL58bf9RxRefmRc+s1eYNev49/4z
+0MNXbq67zyzj3HkUnzxY9f+5yZNTfmCz+0ZoGAXb3jTLofn9j4z9r9R/nzT
frnZsisTPj6H2We/01v1yMSUF/bczGurXk3+aH/4bvtMqw8vYP6znyZi+867
9KU9k4LWL+7Vf+w1ebu/us98aR8eZbSuSOm//aNz+/KsNr+0L15tbb9pEYND
p7iFScOxl1DzGB1M2II+iF19aS8GCX+H7P0KrPYPXtr7mNdvf6zH7ODyp63w
9IuX9rXzLu8Re8jsoJeUGufz/qV9YI+hNksri8OMU2tM1b+8tF+++7rYKRlW
B5+buj+XfH9pL+/haym2itUhTctP8/fPl1D/sDlsXNNVH/j7pX1V/a+D2avY
HPRSxPYeBfLbJmZbVcuzO5xqnO6WB+TrbGZhM+tjd9gn0f0n+tdL+4mPi6ud
vrM7+Jcdmzb7x0t7Deun26pecDiUc0lvr/r4EhoenA47LxhY7H720n72Ne6f
y0y5HfacNjroffKlPW+RkfXlJl6H6kWQ9LJees32S978DgFQfgz7olnSroIO
v1dD+JDwEHJYDZUHAKDSV3U=
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYD/8Hgvf067um7fL4xwPniW1TrRVgZ
DjCAwQd7iSNWNbOi/u2H8Q93Gp0wfvx7/x6fhpVNAm/sjXvffnc88HO/wvwV
D/zS3ti/t/z1z0nv2/5duyc5LWV/a6+4fO+fCufP+1XYzpq+r3hrfyZnq4fQ
mQ/7N63+IKVw6q19+YMHHxyC3u6/ISyptpftHVT/s/03p+h9uBX1zj5IpPHX
uogH+//WnrrrNemdfYD9Q5XDl6/tn8e19Wb9znf2CrNmHf/ef2b/9VLjtUuv
vbOPceRSfPFj1/4HUbmxSm/f2TNAgaTA13+//72z95mx/43y55v2Ly4n+OYY
v4fZZ1/D80Gnwue9PTfz2qpXkz/aG4iW7IxKfg/zn/07/XvPQgre2zMpaP3i
Xv3HXkTxs7lB4Xv78CijdUVK/+2vt7d6BQLli1db229axODwWeukv3sezDxG
h5bXLY/js9/bi0HC3+Fxbub24+nv7X3M67c/1mN2eNf8JHEm0L7aeZf3iD1k
dmB+9GHfk7j39oE9htosrSwOhQ80n2yKfG+/fPd1sVMyrA5BzMLxHCHv7eU9
fC3FVrE68L0o6nrmC/MPm4Pq+dZEH/f39lX1vw5mr2JzaHjLzWHu8N6+bWK2
VbU8u4Pg/L1qiyze2+tsZmEz62N3iOB9pd9h8N5+4uPiaqfv7A4nagpmPVJ/
b69h/XRb1QsOh3sp50U38sPCg9Nhw52W7tLP7+xnX+P+ucyU26GzpLSwbv07
e94iI+vLTbwOsPS0XnrN9kve/A6w9BPDvmiWtKsgXB4SHkJweQC5HE5h
           
           "]]}}, {}, {}, {{}, {}}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}], 
     GraphicsBox[{{{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDDRtt7HZW3LBfxz19l883hgM+LyF8
8S2q9SKsDAf0ijTtQXyJI1Y1s6L+7V/WAOEf7jQ6Yfz4936nFQkXzJbcsDfu
ffvd8cDP/Q4Lgos2pdywf2/565+T3rf9Qr12ut+lbtgrLt/7p8L58347i9un
BO9dtz+Ts9VD6MyH/dXK/HOXLb1uX/7gwQeHoLf797uI3eUruA7V/2z/3kmH
PeZwX7cPEmn8tS7iwX7Dj5td1ddfsw+wf6hy+PK1/RaLZk1njLpmrzBr1vHv
/Wf2n/yz+MNE7mv2MY5cii9+7Np/vG/7ccfDV+0ZoMAt/3JRQ8NVe58Z+98o
f75p73CMydao9ArMPvuEBRd7GXZctudmXlv1avJH+8RrUtMkD16C+c9erk21
j/XwRXsmBa1f3Kv/2LuKvBJ6WHXRPjzKaF2R0n/78Cuqng9dL9oXr7a237SI
weFA0kmJ77IXoeYxOtxltfQo/H/BXgwS/g5rmyb6fnx+wd7HvH77Yz1mBw3V
WsNHVy/Y1867vEfsIbODnf/DUN0TF+wDewy1WVpZHHbeDH3Nt++C/fLd18VO
ybA6HKmLW/R72wV7eQ9fS7FVrA5M79tsJmy6APUPm0NW7Xzu9g0X7Kvqfx3M
XsXmoLNoufZGIL9tYrZVtTy7w0KDmSafgOp1NrOwmfWxO1it2b3KdvsF+4mP
i6udvrM73P395cTUvRfsNayfbqt6weGQ9dfYm+H6BWh4cDq80NVUu8Rw0X72
Ne6fy0y5HdSO77US2HzRnrfIyPpyE6+DQxQkvayXXrP9kje/Q0QohB/DvmiW
tKugA08rhA8JDyEHp14IHwBY+EQ/
           
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAGIQLRq6dffGbKYDDGDwwX4d9/RdPt8Y4HzxLar1IqwI
vsQRq5pZUf/2/weD9/aHO41OGD/+vX+aFUftdbET9sa9b787Hvi5v6GllCFb
9bD9e8tf/5z0vu3neRkSuUB2r73i8r1/Kpw/7495aTtR9d92+zM5Wz2EznzY
z8a5SUBizhb78gcPPjgEvd2/wkZdRtpgE1T/s/0zzz+ztrq/1j5IpPHXuogH
+5fd3vbp48aV9gH2D1UOX762f9LKDevPnlhmrzBr1vHv/Wf2F2jN/CqzZIl9
jCOX4osfu/b/S1fTWvx/kT0DFKQWaJi3bV5o7zNj/xvlzzftHxm5nz1/fTbM
Pvs8+Q/HOF1m2HMzr616Nfmjfb+Jx1c5tqkw/9lzJFkwnrWebM+koPWLe/Uf
ewlm5pbdqpPtw6OM1hUp/bcP2N4yzzpgsn3xamv7TYsYHI4tUF/jtXwy1DxG
B0lJzigXhSn2YpDwdzg+xfGo/dYp9j7m9dsf6zE7rFjyu/1H0lT72nmX94g9
ZHaoP7Zc9rj6NPvAHkNtllYWB5n9xp/EmKfbL999XeyUDKtDUtxjEZmv0+3l
PXwtxVaxOmhVnfux+t8MqH/YHNb8WJ+srTjLvqr+18HsVWwOzS8j93fFzbZv
m5htVS3P7rBHeu8J351z7HU2s7CZ9bE7BK6z+TjXZJ79xMfF1U7f2R1m3Eta
nHFlvr2G9dNtVS84HC433W62C14EDQ9OB4bpTSkOVUvtZ1/j/rnMlNth9hXr
ciP3Dfa8RUbWl5t4HWDpZ730mu2XvPnhfACA9SSP
           "]], 
          LineBox[{{4.509276161837498, 1.}, {4.605170185988092, 
           0.9999999999999999}}]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYD4nbZCYsPP7Zfxz19l883hgPfIyF8
8S2q9SKsDAfy5j0E8yWOWNXMivq3f8VSCP9wp9EJ48e/9xsK/OPZGv3E3rj3
7XfHAz/3s+rufTc16Yn9e8tf/5z0vu3f3rzCwKbpib3i8r1/Kpw/77dIL/Mr
XPzE/kzOVg+hMx/2n3WS1xM//MS+/MGDDw5Bb/c3TmnxP/oApv/Z/phatdN1
Yk/tg0Qaf62LeLD/5tneRVtdn9oH2D9UOXz52v42pf9bevKf2ivMmnX8e/+Z
/Zbr60zeTnlqH+PIpfjix679u+a87+vd9tSeAQrEKrqW/L3y1N5nxv43yp9v
2i96bJfV4PUMZp+9Y3FSyd5Zz+y5mddWvZr80f62+goDV8bnMP/Zi6fJry/I
fG7PpKD1i3v1H3tZpWhLxvbn9uFRRuuKlP7b//Us/3NpznP74tXW9psWMTiY
nJasTl77HGoeo0P+5/nMZrue24tBwt/h4ZePes5Hntv7mNdvf6zH7GBZmzjH
8Mxz+9p5l/eIPWR2yE2Y+abk0nP7wB5DbZZWFoddM4NXxV9/br9893WxUzKs
DlwxH1T0bj+3l/fwtRRbxepgunC7J++951D/sDkwBKfIyT94bl9V/+tg9io2
B73QhSdqHz63b5uYbVUtz+4wOyNore2j5/Y6m1nYzPrYHQ5ENP3NA/InPi6u
dvrO7sAlkPlSDsjXsH66reoFh8OM9PkH0u/DwoPT4f8N65qSW8/tZ1/j/rnM
lNuBMfYrc/eF5/a8RUbWl5t4HaomQdLLeuk12y958zv874fwY9gXzZJ2FXS4
tRzCh4SHkMPX1RA+AH5lUhk=
           "]]}}, {}, {}, {{}, {}}}, {{}, {{}, {}, 
         {GrayLevel[0.5], PointSize[0.012833333333333334`], AbsoluteThickness[
          1.5], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQLRq6dffGbKYDDGDwwX4d9/RdPt8YDvz7DwLv7cW3
qNaLsCL4EkesamZF/dv/H8o/3Gl0wvjx7/0Jj4L4a/jf2Bv3vv3ueODn/pez
6tUzkt7Yv7f89c9J79v+CIuwtnPMb+0Vl+/9U+H8ef8f9766vtK39mdytnoI
nfmwX+iCErPy8bf25Q8efHAIervf3U46mo/lHVT/s/0H5ypdmx3xzj5IpPHX
uogH+9OuTWwKm/DOPsD+ocrhy9f2G3ErbD6w/Z29wqxZx7/3n9nfw29kxnf1
nX2MI5fiix+79r+av3XCytfv7BmgoHBiUvfsv+/sfWbsf6P8+aZ904xtH4OM
3sPss3+lmbe83vu9PTfz2qpXkz/aVwS7HKlJeg/zn31NTb1cVf57eyYFrV/c
q//YL3t8XM+34L19eJTRuiKl//bXNnbrJQHli1db229axOAgw//is0cuzDxG
h+g6oSj/rPf2YpDwd0gQF5BelPbe3se8fvtjPWaHht5/m6KB9tXOu7xH7CGz
g9mLolPdse/tA3sMtVlaWRy0lJj1rSPe2y/ffV3slAyrw7KUfOG8oPf28h6+
lmKrWB3KgtpSVX1g/mFzuGLouDDe9b19Vf2vg9mr2BzCVq2JkLR7b982Mduq
Wp7dQSfw5ARfs/f2OptZ2Mz62B3CTghwfNN9bz/xcXG103d2h31zvMq4Vd/b
a1g/3Vb1gsPhonpKGAcPLDw4HR7I7rl76N07+9nXuH8uM+V2OMd0LXfJynf2
vEVG1pebeB1g6WW99Jrtl7z5Hf5C+THsi2ZJuwo6wNIfJDyE4HwAoapIEw==

           "]]}}, {}, {}, {{}, {}}}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{-2.556678955795147, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {
         Charting`ScaledTicks[{Log, Exp}], 
         Charting`ScaledFrameTicks[{Log, Exp}]}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Part[{{Log, Exp}, {Identity, Identity}}, 1, 2][#]& )[
             Part[#, 1]], 
            (Part[{{Log, Exp}, {Identity, Identity}}, 2, 2][#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-2.4464966613061736`, 4.605170185988092}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{{{-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1.`", TraditionalForm]}, {2.302585092994046, 
          FormBox["10.`", TraditionalForm]}, {4.605170185988092, 
          FormBox["100.`", TraditionalForm]}}, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.739199377128791*^9, 3.7391994185216103`*^9, 
  3.739199839642394*^9, 3.766847323767543*^9, 3.7669036692039022`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Kernel 6",
WindowSize->{1033, 734},
WindowMargins->{{Automatic, 0}, {60, Automatic}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 241, 5, 91, "Subtitle"],
Cell[823, 29, 112, 1, 33, "Subsubtitle"]
}, Open  ]],
Cell[CellGroupData[{
Cell[972, 35, 494, 9, 220, "Subtitle"],
Cell[1469, 46, 66526, 1475, 4502, "Input"],
Cell[CellGroupData[{
Cell[68020, 1525, 166, 2, 33, "Subsubtitle"],
Cell[68189, 1529, 1958, 32, 134, "Input"],
Cell[CellGroupData[{
Cell[70172, 1565, 529, 13, 158, "Input"],
Cell[CellGroupData[{
Cell[70726, 1582, 575, 10, 36, "Print"],
Cell[71304, 1594, 583, 11, 36, "Print"],
Cell[71890, 1607, 583, 11, 36, "Print"],
Cell[72476, 1620, 581, 11, 36, "Print"],
Cell[73060, 1633, 580, 11, 36, "Print"],
Cell[73643, 1646, 573, 10, 36, "Print"],
Cell[74219, 1658, 579, 11, 36, "Print"],
Cell[74801, 1671, 573, 10, 36, "Print"],
Cell[75377, 1683, 579, 11, 36, "Print"],
Cell[75959, 1696, 575, 10, 36, "Print"],
Cell[76537, 1708, 575, 10, 36, "Print"],
Cell[77115, 1720, 575, 10, 36, "Print"],
Cell[77693, 1732, 577, 10, 36, "Print"],
Cell[78273, 1744, 575, 10, 36, "Print"],
Cell[78851, 1756, 573, 10, 36, "Print"],
Cell[79427, 1768, 573, 10, 36, "Print"],
Cell[80003, 1780, 573, 10, 36, "Print"],
Cell[80579, 1792, 573, 10, 36, "Print"],
Cell[81155, 1804, 571, 10, 36, "Print"],
Cell[81729, 1816, 571, 10, 36, "Print"],
Cell[82303, 1828, 571, 10, 36, "Print"],
Cell[82877, 1840, 571, 10, 36, "Print"],
Cell[83451, 1852, 571, 10, 36, "Print"],
Cell[84025, 1864, 571, 10, 36, "Print"],
Cell[84599, 1876, 573, 10, 36, "Print"],
Cell[85175, 1888, 573, 10, 36, "Print"],
Cell[85751, 1900, 572, 10, 36, "Print"],
Cell[86326, 1912, 575, 10, 36, "Print"],
Cell[86904, 1924, 575, 10, 36, "Print"],
Cell[87482, 1936, 577, 10, 36, "Print"],
Cell[88062, 1948, 575, 10, 36, "Print"],
Cell[88640, 1960, 577, 10, 36, "Print"],
Cell[89220, 1972, 577, 10, 36, "Print"],
Cell[89800, 1984, 575, 10, 36, "Print"],
Cell[90378, 1996, 575, 10, 36, "Print"],
Cell[90956, 2008, 581, 11, 36, "Print"],
Cell[91540, 2021, 575, 10, 36, "Print"],
Cell[92118, 2033, 575, 10, 36, "Print"],
Cell[92696, 2045, 575, 10, 36, "Print"],
Cell[93274, 2057, 577, 10, 36, "Print"],
Cell[93854, 2069, 575, 10, 36, "Print"],
Cell[94432, 2081, 583, 11, 36, "Print"],
Cell[95018, 2094, 582, 11, 36, "Print"],
Cell[95603, 2107, 583, 11, 36, "Print"],
Cell[96189, 2120, 583, 11, 36, "Print"],
Cell[96775, 2133, 581, 11, 36, "Print"],
Cell[97359, 2146, 583, 11, 36, "Print"],
Cell[97945, 2159, 573, 10, 36, "Print"],
Cell[98521, 2171, 583, 11, 36, "Print"],
Cell[99107, 2184, 575, 10, 36, "Print"],
Cell[99685, 2196, 581, 11, 36, "Print"],
Cell[100269, 2209, 577, 10, 36, "Print"],
Cell[100849, 2221, 579, 10, 36, "Print"],
Cell[101431, 2233, 579, 10, 36, "Print"],
Cell[102013, 2245, 579, 10, 36, "Print"],
Cell[102595, 2257, 577, 10, 36, "Print"],
Cell[103175, 2269, 577, 10, 36, "Print"],
Cell[103755, 2281, 575, 10, 36, "Print"],
Cell[104333, 2293, 577, 10, 36, "Print"],
Cell[104913, 2305, 575, 10, 36, "Print"],
Cell[105491, 2317, 575, 10, 36, "Print"],
Cell[106069, 2329, 575, 10, 36, "Print"],
Cell[106647, 2341, 575, 10, 36, "Print"],
Cell[107225, 2353, 577, 10, 36, "Print"],
Cell[107805, 2365, 575, 10, 36, "Print"],
Cell[108383, 2377, 577, 10, 36, "Print"],
Cell[108963, 2389, 577, 10, 36, "Print"],
Cell[109543, 2401, 577, 10, 36, "Print"],
Cell[110123, 2413, 577, 10, 36, "Print"],
Cell[110703, 2425, 577, 10, 36, "Print"],
Cell[111283, 2437, 576, 10, 36, "Print"],
Cell[111862, 2449, 577, 10, 36, "Print"],
Cell[112442, 2461, 577, 10, 36, "Print"],
Cell[113022, 2473, 577, 10, 36, "Print"],
Cell[113602, 2485, 579, 10, 36, "Print"],
Cell[114184, 2497, 579, 10, 36, "Print"],
Cell[114766, 2509, 577, 10, 36, "Print"],
Cell[115346, 2521, 583, 11, 36, "Print"],
Cell[115932, 2534, 577, 10, 36, "Print"],
Cell[116512, 2546, 577, 10, 36, "Print"],
Cell[117092, 2558, 582, 11, 36, "Print"],
Cell[117677, 2571, 584, 11, 36, "Print"],
Cell[118264, 2584, 582, 11, 36, "Print"],
Cell[118849, 2597, 587, 11, 36, "Print"],
Cell[119439, 2610, 575, 10, 36, "Print"],
Cell[120017, 2622, 581, 11, 36, "Print"],
Cell[120601, 2635, 585, 11, 36, "Print"],
Cell[121189, 2648, 581, 11, 36, "Print"],
Cell[121773, 2661, 585, 11, 36, "Print"],
Cell[122361, 2674, 575, 10, 36, "Print"],
Cell[122939, 2686, 581, 11, 36, "Print"],
Cell[123523, 2699, 575, 10, 36, "Print"],
Cell[124101, 2711, 581, 11, 36, "Print"],
Cell[124685, 2724, 577, 10, 36, "Print"],
Cell[125265, 2736, 577, 10, 36, "Print"],
Cell[125845, 2748, 579, 10, 36, "Print"],
Cell[126427, 2760, 577, 10, 36, "Print"],
Cell[127007, 2772, 579, 10, 36, "Print"],
Cell[127589, 2784, 577, 10, 36, "Print"],
Cell[128169, 2796, 575, 10, 36, "Print"],
Cell[128747, 2808, 579, 10, 36, "Print"],
Cell[129329, 2820, 575, 10, 36, "Print"],
Cell[129907, 2832, 575, 10, 36, "Print"],
Cell[130485, 2844, 574, 10, 36, "Print"],
Cell[131062, 2856, 575, 10, 36, "Print"],
Cell[131640, 2868, 577, 10, 36, "Print"],
Cell[132220, 2880, 575, 10, 36, "Print"],
Cell[132798, 2892, 575, 10, 36, "Print"],
Cell[133376, 2904, 576, 10, 36, "Print"],
Cell[133955, 2916, 576, 10, 36, "Print"],
Cell[134534, 2928, 577, 10, 36, "Print"],
Cell[135114, 2940, 577, 10, 36, "Print"],
Cell[135694, 2952, 577, 10, 36, "Print"],
Cell[136274, 2964, 577, 10, 36, "Print"],
Cell[136854, 2976, 577, 10, 36, "Print"],
Cell[137434, 2988, 577, 10, 36, "Print"],
Cell[138014, 3000, 576, 10, 36, "Print"],
Cell[138593, 3012, 577, 10, 36, "Print"],
Cell[139173, 3024, 577, 10, 36, "Print"],
Cell[139753, 3036, 585, 11, 36, "Print"],
Cell[140341, 3049, 577, 10, 36, "Print"],
Cell[140921, 3061, 579, 10, 36, "Print"],
Cell[141503, 3073, 584, 11, 36, "Print"],
Cell[142090, 3086, 579, 10, 36, "Print"],
Cell[142672, 3098, 579, 10, 36, "Print"],
Cell[143254, 3110, 587, 11, 36, "Print"],
Cell[143844, 3123, 577, 10, 36, "Print"],
Cell[144424, 3135, 581, 11, 36, "Print"],
Cell[145008, 3148, 583, 11, 36, "Print"],
Cell[145594, 3161, 580, 11, 36, "Print"],
Cell[146177, 3174, 583, 11, 36, "Print"],
Cell[146763, 3187, 577, 10, 36, "Print"],
Cell[147343, 3199, 583, 11, 36, "Print"],
Cell[147929, 3212, 575, 10, 36, "Print"],
Cell[148507, 3224, 583, 11, 36, "Print"],
Cell[149093, 3237, 577, 10, 36, "Print"],
Cell[149673, 3249, 579, 10, 36, "Print"],
Cell[150255, 3261, 579, 10, 36, "Print"],
Cell[150837, 3273, 577, 10, 36, "Print"],
Cell[151417, 3285, 579, 10, 36, "Print"],
Cell[151999, 3297, 577, 10, 36, "Print"],
Cell[152579, 3309, 575, 10, 36, "Print"],
Cell[153157, 3321, 577, 10, 36, "Print"],
Cell[153737, 3333, 575, 10, 36, "Print"],
Cell[154315, 3345, 574, 10, 36, "Print"],
Cell[154892, 3357, 574, 10, 36, "Print"],
Cell[155469, 3369, 575, 10, 36, "Print"],
Cell[156047, 3381, 577, 10, 36, "Print"],
Cell[156627, 3393, 575, 10, 36, "Print"],
Cell[157205, 3405, 575, 10, 36, "Print"],
Cell[157783, 3417, 577, 10, 36, "Print"],
Cell[158363, 3429, 577, 10, 36, "Print"],
Cell[158943, 3441, 577, 10, 36, "Print"],
Cell[159523, 3453, 577, 10, 36, "Print"],
Cell[160103, 3465, 577, 10, 36, "Print"],
Cell[160683, 3477, 577, 10, 36, "Print"],
Cell[161263, 3489, 577, 10, 36, "Print"],
Cell[161843, 3501, 577, 10, 36, "Print"],
Cell[162423, 3513, 577, 10, 36, "Print"],
Cell[163003, 3525, 577, 10, 36, "Print"],
Cell[163583, 3537, 577, 10, 36, "Print"],
Cell[164163, 3549, 583, 11, 36, "Print"],
Cell[164749, 3562, 579, 10, 36, "Print"],
Cell[165331, 3574, 577, 10, 36, "Print"],
Cell[165911, 3586, 577, 10, 36, "Print"],
Cell[166491, 3598, 577, 10, 36, "Print"],
Cell[167071, 3610, 579, 10, 36, "Print"],
Cell[167653, 3622, 583, 11, 36, "Print"],
Cell[168239, 3635, 575, 10, 36, "Print"],
Cell[168817, 3647, 581, 11, 36, "Print"],
Cell[169401, 3660, 582, 11, 36, "Print"],
Cell[169986, 3673, 581, 11, 36, "Print"],
Cell[170570, 3686, 583, 11, 36, "Print"],
Cell[171156, 3699, 574, 10, 36, "Print"],
Cell[171733, 3711, 581, 11, 36, "Print"],
Cell[172317, 3724, 575, 10, 36, "Print"],
Cell[172895, 3736, 581, 11, 36, "Print"],
Cell[173479, 3749, 577, 10, 36, "Print"],
Cell[174059, 3761, 579, 10, 36, "Print"],
Cell[174641, 3773, 579, 10, 36, "Print"],
Cell[175223, 3785, 577, 10, 36, "Print"],
Cell[175803, 3797, 576, 10, 36, "Print"],
Cell[176382, 3809, 577, 10, 36, "Print"],
Cell[176962, 3821, 575, 10, 36, "Print"],
Cell[177540, 3833, 577, 10, 36, "Print"],
Cell[178120, 3845, 575, 10, 36, "Print"],
Cell[178698, 3857, 575, 10, 36, "Print"],
Cell[179276, 3869, 577, 10, 36, "Print"],
Cell[179856, 3881, 577, 10, 36, "Print"],
Cell[180436, 3893, 577, 10, 36, "Print"],
Cell[181016, 3905, 575, 10, 36, "Print"],
Cell[181594, 3917, 575, 10, 36, "Print"],
Cell[182172, 3929, 579, 10, 36, "Print"],
Cell[182754, 3941, 579, 10, 36, "Print"],
Cell[183336, 3953, 577, 10, 36, "Print"],
Cell[183916, 3965, 577, 10, 36, "Print"],
Cell[184496, 3977, 577, 10, 36, "Print"],
Cell[185076, 3989, 577, 10, 36, "Print"],
Cell[185656, 4001, 576, 10, 36, "Print"],
Cell[186235, 4013, 577, 10, 36, "Print"],
Cell[186815, 4025, 577, 10, 36, "Print"],
Cell[187395, 4037, 579, 10, 36, "Print"],
Cell[187977, 4049, 579, 10, 36, "Print"],
Cell[188559, 4061, 583, 11, 36, "Print"],
Cell[189145, 4074, 577, 10, 36, "Print"],
Cell[189725, 4086, 577, 10, 36, "Print"],
Cell[190305, 4098, 577, 10, 36, "Print"],
Cell[190885, 4110, 577, 10, 36, "Print"],
Cell[191465, 4122, 577, 10, 36, "Print"],
Cell[192045, 4134, 585, 11, 36, "Print"],
Cell[192633, 4147, 575, 10, 36, "Print"],
Cell[193211, 4159, 581, 11, 36, "Print"],
Cell[193795, 4172, 582, 11, 36, "Print"],
Cell[194380, 4185, 581, 11, 36, "Print"],
Cell[194964, 4198, 583, 11, 36, "Print"],
Cell[195550, 4211, 575, 10, 36, "Print"],
Cell[196128, 4223, 581, 11, 36, "Print"],
Cell[196712, 4236, 575, 10, 36, "Print"],
Cell[197290, 4248, 580, 11, 36, "Print"],
Cell[197873, 4261, 579, 10, 36, "Print"],
Cell[198455, 4273, 577, 10, 36, "Print"],
Cell[199035, 4285, 577, 10, 36, "Print"],
Cell[199615, 4297, 577, 10, 36, "Print"],
Cell[200195, 4309, 579, 10, 36, "Print"],
Cell[200777, 4321, 579, 10, 36, "Print"],
Cell[201359, 4333, 577, 10, 36, "Print"],
Cell[201939, 4345, 579, 10, 36, "Print"],
Cell[202521, 4357, 575, 10, 36, "Print"],
Cell[203099, 4369, 575, 10, 36, "Print"],
Cell[203677, 4381, 575, 10, 36, "Print"],
Cell[204255, 4393, 577, 10, 36, "Print"],
Cell[204835, 4405, 575, 10, 36, "Print"],
Cell[205413, 4417, 575, 10, 36, "Print"],
Cell[205991, 4429, 575, 10, 36, "Print"],
Cell[206569, 4441, 577, 10, 36, "Print"],
Cell[207149, 4453, 577, 10, 36, "Print"],
Cell[207729, 4465, 577, 10, 36, "Print"],
Cell[208309, 4477, 579, 10, 36, "Print"],
Cell[208891, 4489, 577, 10, 36, "Print"],
Cell[209471, 4501, 577, 10, 36, "Print"],
Cell[210051, 4513, 579, 10, 36, "Print"],
Cell[210633, 4525, 579, 10, 36, "Print"],
Cell[211215, 4537, 579, 10, 36, "Print"],
Cell[211797, 4549, 577, 10, 36, "Print"],
Cell[212377, 4561, 577, 10, 36, "Print"],
Cell[212957, 4573, 583, 11, 36, "Print"],
Cell[213543, 4586, 577, 10, 36, "Print"],
Cell[214123, 4598, 577, 10, 36, "Print"],
Cell[214703, 4610, 577, 10, 36, "Print"],
Cell[215283, 4622, 577, 10, 36, "Print"],
Cell[215863, 4634, 577, 10, 36, "Print"],
Cell[216443, 4646, 583, 11, 36, "Print"]
}, Open  ]],
Cell[217041, 4660, 366, 7, 46, "Output"]
}, Closed]],
Cell[217422, 4670, 266, 7, 29, "Input"],
Cell[217691, 4679, 4179, 99, 326, "Input"],
Cell[CellGroupData[{
Cell[221895, 4782, 609, 17, 37, "Input"],
Cell[222507, 4801, 35356, 660, 167, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

