(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2265773,      55194]
NotebookOptionsPosition[   2191739,      53450]
NotebookOutlinePosition[   2192115,      53466]
CellTagsIndexPosition[   2192072,      53463]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Supporting Material: File S2",
  FontColor->GrayLevel[0]],
 "\nThe effectiveness of pseudomagic traits in promoting divergence and \
enhancing local adaptation \n",
 StyleBox["by",
  FontSize->36,
  FontColor->GrayLevel[0]],
 "\nMaria Servedio and Reinhard B\[UDoubleDot]rger"
}], "Title",
 CellChangeTimes->{{3.7402268209643927`*^9, 3.740226864049459*^9}, {
   3.7662355660027003`*^9, 3.7662355871931577`*^9}, {3.7752236981525507`*^9, 
   3.7752237205571156`*^9}, {3.7752242465020905`*^9, 3.775224292796219*^9}, 
   3.780410595381174*^9, 3.787756710891692*^9, {3.7957860721064763`*^9, 
   3.7957861044649615`*^9}},ExpressionUUID->"b4b2c31b-f37d-422c-9936-\
a117fac247e9"],

Cell[TextData[StyleBox["Theory for the continent-island model",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.7752243167869587`*^9, 
  3.7752243418145494`*^9}},ExpressionUUID->"48b3efcb-a73f-40f6-849f-\
3bc0adfacc2f"],

Cell[CellGroupData[{

Cell["1. Brief recap of model and notation", "Subchapter",
 CellChangeTimes->{{3.7746824040090675`*^9, 3.774682428065282*^9}, {
   3.775224901380258*^9, 3.7752249015447407`*^9}, 
   3.798553896960417*^9},ExpressionUUID->"066e3f6c-e046-42c2-b492-\
437b4d9d9c7f"],

Cell["\<\
Locus T is a neutral phenotype matching locus. Allelic type T1 prefers T1 by \
a factor 1+\[Alpha]1, T2 prefers T2 by a factor 1+\[Alpha]2.
Locus E is under divergent (ecological) selection. Relative fitnesses of \
alleles E1 and E2 are 1 and 1+s, respectively, in deme 2 (=island).
Deme 1 (=continent) is constant and fixed for T1E1.
The type T1E1 immigrates in deme 2 at rate m.
Viability selection acts on both sexes.
The recombination rate between T and E is r.\
\>", "Text",
 CellChangeTimes->{{3.740226881148731*^9, 3.7402270575997944`*^9}, {
  3.740227176305213*^9, 3.7402271902732697`*^9}, {3.7662291582299957`*^9, 
  3.7662291585425067`*^9}, {3.7662356268834248`*^9, 3.7662356742245193`*^9}, {
  3.7662358685982885`*^9, 3.7662358938498826`*^9}, {3.775224443585087*^9, 
  3.7752246055777864`*^9}, {3.780402534529189*^9, 3.7804026095263352`*^9}, {
  3.780410821480466*^9, 
  3.780410824155935*^9}},ExpressionUUID->"301429bc-91e9-48a3-875b-\
6c1656ddd692"],

Cell["\<\
The frequencies of the four genotypes T1E1, T1E2, T2E1, and T2E2 are denoted \
by 
x1[1] = 1 frequency of T1E1 in deme 1
x1[2]=x1[3]=x1[4]=0 in deme1
x2[1] = frequency of T1E1 in deme 2
x2[2] = frequency of T1E2 in deme 2
x2[3] = frequency of T2E1 in deme 2
x2[4] = frequency of T2E2 in deme 2\
\>", "Text",
 CellChangeTimes->{{3.7402271267505245`*^9, 3.7402271669454813`*^9}, {
  3.740227221754402*^9, 3.7402272661623735`*^9}, {3.7662356977589226`*^9, 
  3.7662357040729055`*^9}, {3.7662358239077272`*^9, 3.766235857129408*^9}, {
  3.780402628868245*^9, 
  3.7804026383977976`*^9}},ExpressionUUID->"ac08bace-0e33-46fd-adf2-\
a614ff7feee3"],

Cell["\<\
t22 = x2[3] + x2[4] = frequency of allele T2 in deme 2 (Note : the ordering \
of subscripts differs from that in the manuscript)
e22 = x2[2] + x2[4] = frequency of trait allele E2 in deme 2 (Note : the \
ordering of subscripts differs from that in the manuscript)
dd2 = x2[1] x2[4] - x2[2] x2[3] = linkage disequilibrium between T and E in \
deme 2.\
\>", "Text",
 CellChangeTimes->{{3.7402272818066216`*^9, 3.7402272818096247`*^9}, 
   3.740227368148076*^9, {3.7402290740915337`*^9, 3.7402291191309814`*^9}, {
   3.76623572743414*^9, 3.7662357625731325`*^9}, {3.785492666783112*^9, 
   3.7854926677765417`*^9}},ExpressionUUID->"7ff298e0-5bf1-4783-b682-\
f8c49672dc10"],

Cell["\<\
For proper comparison with the corresponding magic trait model, in which only \
T1E1 and T2E2 occur, one has to assume x2[2] = x2[3] = 0.

Cells (boxes) with light gray background are initialization cells (can be \
initialized by Mathematica to be able to perform all computations in this \
notebook.
Cells with light red background summarize the results of a (sub) section.\
\>", "Text",
 CellChangeTimes->{{3.7662330601979785`*^9, 3.766233130468777*^9}, {
   3.7752246751246986`*^9, 3.775224689578125*^9}, 3.7854926579153614`*^9, {
   3.7900072476899633`*^9, 
   3.7900072487133884`*^9}},ExpressionUUID->"9033e903-80a4-48e7-84a6-\
b43b9b2e152d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Model and recursions", "Subchapter",
 CellChangeTimes->{{3.7402892585535984`*^9, 3.740289274637845*^9}, {
  3.7746824777618513`*^9, 3.7746824833448677`*^9}, {3.7752249054921913`*^9, 
  3.77522490689091*^9}, {3.780411089151849*^9, 
  3.780411089940421*^9}},ExpressionUUID->"73d087bd-c491-4f78-8afa-\
dece7c399e83"],

Cell["\<\
Because we assume that the continent is fixed for T1TE, we set\
\>", "Text",
 CellChangeTimes->{{3.766236383989106*^9, 3.7662363853797774`*^9}, {
   3.766236440089771*^9, 3.7662364825009136`*^9}, 
   3.7692422763411417`*^9},ExpressionUUID->"25c8ec7f-c507-4514-b5cc-\
8644b78e04b0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "1", "]"}], "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "2", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "3", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "4", "]"}], "=", "0"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7662363983189745`*^9, 
  3.766236426586541*^9}},ExpressionUUID->"1f7d916d-8657-4594-9977-\
bb445667156b"],

Cell[CellGroupData[{

Cell["2.1 Migration", "Section",
 CellChangeTimes->{{3.740227373411515*^9, 3.74022738118511*^9}, {
  3.7752249279519067`*^9, 
  3.77522493212117*^9}},ExpressionUUID->"779952e6-43fd-45cc-80f4-\
c947805d5b85"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x2m", "[", "i", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "m2"}], ")"}], " ", 
      RowBox[{"x2", "[", "i", "]"}]}], "+", " ", 
     RowBox[{"m2", " ", 
      RowBox[{"x1", "[", "i", "]"}]}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7005629683328648`*^9, 3.700562977196281*^9}, 
   3.701093442260399*^9},ExpressionUUID->"2044102e-40c7-4be6-8dc7-\
51720b4ddf8d"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2 Viability selection", "Section",
 CellChangeTimes->{{3.7402274155898933`*^9, 3.740227424149059*^9}, {
  3.775224934519376*^9, 
  3.7752249366330338`*^9}},ExpressionUUID->"7a2c2d08-9729-4689-a3b3-\
fa245d6ffe68"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w2barm", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x2m", "[", "2", "]"}], "+", " ", 
       RowBox[{"x2m", "[", "4", "]"}]}], ")"}]}], "+", 
    RowBox[{"x2m", "[", "1", "]"}], "+", " ", 
    RowBox[{"x2m", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "1", "]"}], "/", "w2barm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "2", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "3", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "3", "]"}], "/", "w2barm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "4", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "4", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.7005641085294123`*^9, {3.7005641825943413`*^9, 3.7005642771991873`*^9}, {
   3.70109346723495*^9, 3.7010934771180553`*^9}, 3.7402274486126537`*^9, {
   3.7402468705979214`*^9, 
   3.740246875614117*^9}},ExpressionUUID->"6518472b-ced2-4276-ba99-\
ddf3cadcd94d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xnsf2", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"xnsm2", "[", "i", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700564153336898*^9, 3.7005641633638563`*^9}, 
   3.701093462232667*^9, {3.7402275909335833`*^9, 3.7402275913178606`*^9}, {
   3.7662360156841497`*^9, 
   3.7662360160904245`*^9}},ExpressionUUID->"cdd62dba-dd8f-4b66-ad4d-\
b23dd013c218"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3 Mating and sexual selection", "Section",
 CellChangeTimes->{{3.7402274649354053`*^9, 3.740227474980341*^9}, {
  3.7752249431031914`*^9, 
  3.7752249445710998`*^9}},ExpressionUUID->"051131ed-4291-4615-bba3-\
d34f7272dbc0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Coef", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coef", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coef", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.700562926738367*^9, {3.700563714686079*^9, 3.7005637432782793`*^9}, {
   3.700563792010023*^9, 3.700563932065588*^9}, {3.7010933937344923`*^9, 
   3.701093409745647*^9}, 
   3.7402275193009963`*^9},ExpressionUUID->"304b2de4-9938-4224-a1f8-\
7ea11bfd9279"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "Coef", "]"}]], "Input",
 CellChangeTimes->{{3.70109224436022*^9, 
  3.701092251755431*^9}},ExpressionUUID->"42729d73-3175-4115-95d8-\
469ca7ffbabc"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"1", "+", "\[Alpha]1"}], 
     RowBox[{"1", "+", "\[Alpha]1"}], "1", "1"},
    {
     RowBox[{"1", "+", "\[Alpha]1"}], 
     RowBox[{"1", "+", "\[Alpha]1"}], "1", "1"},
    {"1", "1", 
     RowBox[{"1", "+", "\[Alpha]2"}], 
     RowBox[{"1", "+", "\[Alpha]2"}]},
    {"1", "1", 
     RowBox[{"1", "+", "\[Alpha]2"}], 
     RowBox[{"1", "+", "\[Alpha]2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.701092297819088*^9, 3.701093434119123*^9, 3.701094102260694*^9, 
   3.701871735409504*^9, 3.7045454172721853`*^9, 3.737966084556911*^9, 
   3.7379661415339193`*^9, 3.739006471374028*^9, {3.73900660034249*^9, 
   3.73900662656387*^9}, 
   3.739008024276458*^9},ExpressionUUID->"446238c8-7c5f-45c0-8335-\
793ee927cab3"]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Mate2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"xnsf2", "[", "i", "]"}], 
      RowBox[{"xnsm2", "[", "j", "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", " ", "=", " ", 
   RowBox[{"Mate2", " ", "Coef"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.700564745735652*^9, {3.700565744404601*^9, 3.700565751475971*^9}, {
   3.701093546067524*^9, 
   3.7010935473945103`*^9}},ExpressionUUID->"c65f7a39-8898-43ca-9ecf-\
8e844e88f178"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "G2", "]"}]], "Input",
 CellChangeTimes->{{3.700564767168315*^9, 3.700564797394866*^9}, 
   3.700565411607293*^9, 3.700565753059012*^9, 
   3.766388324785186*^9},ExpressionUUID->"248fe3e7-3de9-4422-bed8-\
5c8b0c413042"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "2", "]"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "3", "]"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "4", "]"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "2", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m2"}], ")"}], " ", 
             RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.766388325787902*^9},ExpressionUUID->"f8cd3b28-74eb-43b1-b7e1-\
31bf8c053dd8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"z2", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnsm2", "[", "j", "]"}], " ", 
        RowBox[{"Coef", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"F2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"G2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
      RowBox[{"z2", "[", "i", "]"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", "F2", "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700564813779233*^9, 3.700564828637002*^9}, 
   3.7005657547476053`*^9, {3.701093551675559*^9, 3.701093553160282*^9}, {
   3.740227686822119*^9, 
   3.7402276927103586`*^9}},ExpressionUUID->"a0a9ddf3-d29a-4cad-8887-\
a8ad184753b6"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "2", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "3", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "4", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwAOK0c+dLXt997djREKz2GUhLb9mU+wVIz7njJMV577Xj
kbsKbQZA+lX0egZTIL06MeBLOpCuC8zNzADSsrNZW0H0ldOVMSb3XzsWvHjw
0vfLa8dDLxontfG/cSydd301iGbnvOJ3Hkh/e6j3iEngjeORfL8nIUCa7UiL
ZSmQjtDmfVgFpC+YXmjsBtJFHslMi4D0mp3X5p8C0iemNk/8DaQ1jFhCnESB
5lS+PGsn9sbx7PcNak3ybxxvxhU/XwSk/7V9NpJRfONYp5Z/oFvrjaNacf+U
PiDd5/TyHIhODF+v4WIMlD9w1SYDSH+c5nZ0GpAuyLMuPQoSl2f+/BFIH79b
fUfQ5I1jhTe/kSyQlorSFXQE0r9STkkeA9KHJqUunGj2xtHfLdVM1/qNo8UE
tsgIIB02123aG9c3jtOS319jdXvjONk2upUDSOtwBfE/dn/j2HH5ihyb1xvH
g2KG1d4BbxwBt7i/gw==
  "],ExpressionUUID->"d6ac67fe-8df4-450b-b970-0c8df69e3712"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "[", "F2", "]"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.7663883592286596`*^9, 
  3.766388375444294*^9}},ExpressionUUID->"f819411b-9a64-43e6-accf-\
bc6ba4858bbe"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "m2"}], "-", 
          RowBox[{"x2", "[", "1", "]"}], "+", 
          RowBox[{"m2", " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "2", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "3", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "4", "]"}], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "m2"}], "-", 
         RowBox[{"x2", "[", "1", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "1", "]"}]}], "-", 
         RowBox[{"x2", "[", "2", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "-", 
         RowBox[{"x2", "[", "3", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "3", "]"}]}], "-", 
         RowBox[{"x2", "[", "4", "]"}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "-", 
         RowBox[{"s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}], "+", 
         RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.766388369538064*^9, 
  3.7663883763889728`*^9}},ExpressionUUID->"f4212499-97dc-4bdf-a22e-\
84b8e740b32c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"z2", "[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663883981255684`*^9, 
  3.766388408699155*^9}},ExpressionUUID->"15565e25-5a95-4154-88aa-\
918ec0a1deed"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"\[Alpha]1", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}], 
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.7663884094476924`*^9},ExpressionUUID->"a382222d-392c-49ed-8844-\
e8ab30346d68"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"z2", "[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.766388420740798*^9},ExpressionUUID->"cc1617c8-96cf-4d3b-aae6-\
6bf43fef7f7b"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"m2", " ", "\[Alpha]1"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"\[Alpha]1", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", "\[Alpha]1", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}], 
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.766388421699484*^9},ExpressionUUID->"faa80515-a885-412d-b29b-\
dd3fa1ccd337"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"z2", "[", "3", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.766388438255368*^9},ExpressionUUID->"59a35e5f-0679-4197-9e4e-\
9da951fe6090"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"\[Alpha]2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"\[Alpha]2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "\[Alpha]2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", "\[Alpha]2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", "\[Alpha]2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}], 
  RowBox[{
   RowBox[{"-", "m2"}], "-", 
   RowBox[{"x2", "[", "1", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "1", "]"}]}], "-", 
   RowBox[{"x2", "[", "2", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "2", "]"}]}], "-", 
   RowBox[{"x2", "[", "3", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "3", "]"}]}], "-", 
   RowBox[{"x2", "[", "4", "]"}], "+", 
   RowBox[{"m2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "-", 
   RowBox[{"s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}], "+", 
   RowBox[{"m2", " ", "s2", " ", 
    RowBox[{"x2", "[", "4", "]"}]}]}]]], "Output",
 CellChangeTimes->{
  3.766388440504992*^9},ExpressionUUID->"ce9504e4-d9d1-4996-b71a-\
2b082604e43d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4 Recombination", "Section",
 CellChangeTimes->{{3.7402278884583654`*^9, 3.740227895256271*^9}, {
  3.775224953802636*^9, 
  3.775224955558305*^9}},ExpressionUUID->"e7acf9f7-004a-488e-95da-\
812e8dec2ce5"],

Cell["Only for deme 2", "Text",
 CellChangeTimes->{{3.538468479471239*^9, 3.538468480127818*^9}, {
  3.7752249582104034`*^9, 3.7752249629690104`*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"4b3b4190-40d5-4cb9-be9a-02ae4a60f069"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x2t1", "[", "1", "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"F2", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538468433384053*^9, 3.538468509764133*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"e055ffc1-6daf-4951-b646-eeeef383bd85"],

Cell["\<\
x2t1[2] = Simplify[(1/2) F2[[1,2]] + (1/2) r F2[[1,4]] + 
\t(1/2) F2[[2,1]] + F2[[2,2]] + (1/2)(1-r)F2[[2,3]] + 
\t(1/2) F2[[2,4]] + (1/2) (1-r) F2[[3,2]] + 
\t(1/2) r F2[[4,1]] + (1/2) F2[[4,2]]];\
\>", "Input",
 CellChangeTimes->{{3.538468435569471*^9, 3.5384685099268303`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"3176f29a-4f37-4199-9f8e-0a1a0fe8d542"],

Cell["\<\
x2t1[3] = Simplify[(1/2) F2[[1,3]] + (1/2) r F2[[1,4]] +
\t(1/2) (1-r) F2[[2,3]] + (1/2) F2[[3,1]] + 
\t(1/2) (1-r) F2[[3,2]] + F2[[3,3]] + (1/2) F2[[3,4]] +
\t(1/2) r F2[[4,1]] + (1/2) F2[[4,3]]];\
\>", "Input",
 CellChangeTimes->{{3.538468436777104*^9, 3.538468457124481*^9}, {
  3.538468490283471*^9, 3.538468510081058*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"69a7d81e-f841-49fc-b26d-5adb14cc95f4"],

Cell["\<\
x2t1[4] = Simplify[(1/2) (1-r) F2[[1,4]] + (1/2) r F2[[2,3]] + 
\t(1/2) F2[[2,4]] + (1/2) r F2[[3,2]] + (1/2) F2[[3,4]] +
\t(1/2) (1-r) F2[[4,1]] + (1/2) F2[[4,2]] + (1/2) F2[[4,3]] + F2[[4,4]]];\
\>", "Input",
 CellChangeTimes->{{3.5384684380894537`*^9, 3.538468457275229*^9}, {
  3.538468492645274*^9, 3.538468509609948*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"8e979822-cc2d-4444-86cb-a8dad82bb9c4"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5 Recursion relations for allele frequencies and LD", "Section",
 CellChangeTimes->{{3.740227990421271*^9, 3.740228009281849*^9}, {
  3.7752249663509984`*^9, 
  3.775224967682541*^9}},ExpressionUUID->"ba3f3524-3772-403f-8dcb-\
78f8a3d31bed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"substxtoetdd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x2", "[", "1", "]"}], " ", "->", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "t22"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "e22"}], ")"}]}], " ", "+", "dd2"}]}], ",", 
     RowBox[{
      RowBox[{"x2", "[", "2", "]"}], " ", "->", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "t22"}], ")"}], "e22"}], "-", " ", "dd2"}]}], ",", 
     RowBox[{
      RowBox[{"x2", "[", "3", "]"}], " ", "->", " ", 
      RowBox[{
       RowBox[{"t22", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "e22"}], ")"}]}], " ", "-", " ", "dd2"}]}], ",", 
     RowBox[{
      RowBox[{"x2", "[", "4", "]"}], " ", "->", " ", 
      RowBox[{
       RowBox[{"t22", " ", "e22"}], " ", "+", " ", "dd2"}]}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.701093765952938*^9, 3.7010938338911047`*^9}, {
  3.701093999535063*^9, 3.701094019264434*^9}, {3.7402280193531003`*^9, 
  3.7402281143308067`*^9}, {3.7662360705965424`*^9, 3.766236071284033*^9}, {
  3.7663881211156816`*^9, 
  3.766388175923637*^9}},ExpressionUUID->"69ea3880-ae5b-438f-938f-\
2d890238aaa3"],

Cell["e22 is E2 in deme2;  t22 is T2 in deme 2", "Text",
 CellChangeTimes->{{3.740228362289694*^9, 3.7402284206205215`*^9}, {
  3.766236085081152*^9, 
  3.7662360948638716`*^9}},ExpressionUUID->"2a666075-3b6b-4931-b7ae-\
2064aa1a8700"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e22time1", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x2t1", "[", "2", "]"}], " ", "+", " ", 
    RowBox[{"x2t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701093841355938*^9, 3.701093868213223*^9}, {
  3.7010940435361967`*^9, 
  3.701094068009466*^9}},ExpressionUUID->"3df3851a-efae-44f6-9172-\
ca47d5f248cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox["s2", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dd2", " ", "s2"}], "+", "t22"}], ")"}], " ", 
          "\[Alpha]2"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["e22", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"m2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"t22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "m2", "+", 
               RowBox[{"4", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"m2", "-", 
               RowBox[{"4", " ", "\[Alpha]2"}], "+", 
               RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"m2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["m2", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "t22", "+", 
            RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
         RowBox[{"\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["dd2", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
             SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", 
               RowBox[{"m2", " ", "t22"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}]}], 
              ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"2", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "m2", "-", 
                  RowBox[{"4", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.701094119583796*^9, 3.701871772210101*^9, 
  3.7045454459347982`*^9, 3.739006487414225*^9, 3.739008040639377*^9, 
  3.740228617552244*^9, 3.7402469829847174`*^9, 
  3.7662366456599145`*^9},ExpressionUUID->"f9d940a7-43aa-4401-902f-\
f9138e97ea22"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t22time1", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x2t1", "[", "3", "]"}], " ", "+", " ", 
    RowBox[{"x2t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.70109385814884*^9, 3.701093878237994*^9}, {
  3.7010940446160803`*^9, 
  3.701094069865596*^9}},ExpressionUUID->"2e66684d-f9eb-49c3-8d50-\
1b250307c369"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dd2", " ", "s2"}], "+", "t22", "+", 
      RowBox[{"e22", " ", "s2", " ", "t22"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
      RowBox[{
      "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", "m2", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox["s2", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t22", "+", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "m2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "m2"}], ")"}], " ", "t22", " ", 
             "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             SuperscriptBox["t22", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"t22", "-", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.701094121338036*^9, 3.701871774026083*^9, 
  3.704545448333626*^9, 3.7390064918084917`*^9, 3.739008044563121*^9, 
  3.7402286229781523`*^9, 3.7402469898604565`*^9, 
  3.766236654255122*^9},ExpressionUUID->"e462dc6e-9238-4fbb-b138-\
8ef151ed2ba5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dd2time1", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x2t1", "[", "1", "]"}], " ", 
     RowBox[{"x2t1", "[", "4", "]"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"x2t1", "[", "2", "]"}], " ", 
     RowBox[{"x2t1", "[", "3", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7010938816863823`*^9, 3.701093892910983*^9}, {
  3.7010940460003757`*^9, 3.701094065137371*^9}, {3.740229455094648*^9, 
  3.740229456839904*^9}, {3.76623666725673*^9, 
  3.7662366711943197`*^9}},ExpressionUUID->"220ef574-5472-4e8f-8256-\
285fd4714abb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{"s2", "-", 
         RowBox[{"m2", " ", "s2"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
             ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", "\[Alpha]1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}]], "-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
              RowBox[{"m2", " ", "t22"}]}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", "\[Alpha]1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}]], "-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
              RowBox[{"m2", " ", "t22"}]}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", "\[Alpha]1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
              RowBox[{"m2", " ", "t22"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", "\[Alpha]1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}]], "+", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
               RowBox[{"m2", " ", "t22"}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", "\[Alpha]1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}]], "-", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
             ")"}]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             "\[Alpha]2"}], "-", 
            RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}]], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
              RowBox[{"m2", " ", "t22"}]}], ")"}]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             "\[Alpha]2"}], "-", 
            RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}]], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", "-", 
              RowBox[{"m2", " ", "t22"}]}], ")"}]}], 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             "\[Alpha]2"}], "-", 
            RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}]]}], ")"}]}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["dd2", "3"]}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
          SuperscriptBox["s2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
            RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["dd2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", "\[Alpha]2"}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", "e22", " ", "s2"}]}], ")"}], " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}]}],
            ")"}]}], "-", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
            RowBox[{
             SuperscriptBox["m2", "2"], " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             SuperscriptBox["m2", "2"], " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
            "+", 
            RowBox[{
            "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
            "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
             "-", 
            RowBox[{"4", " ", "m2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
             "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["m2", "2"], " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
             "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "\[Alpha]1", "-", 
               RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
               RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                  "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                   "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"4", "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                   "\[Alpha]2"}], "+", 
                  RowBox[{"4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                   SuperscriptBox["t22", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["e22", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
             SuperscriptBox["s2", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   SuperscriptBox["t22", "2"], " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"e22", " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"e22", " ", "s2"}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
                " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "t22", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"e22", " ", "s2"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                   "\[Alpha]1"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"2", " ", "e22", " ", "s2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "-", 
                  RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                    " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{"t22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                   "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", "t22", " ", 
                   RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["m2", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["e22", "2"], " ", 
                SuperscriptBox["s2", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "-", 
                  RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                    " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                 ")"}]}], "+", 
               RowBox[{"t22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"r", " ", 
                   RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
                  RowBox[{"t22", " ", 
                   RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", "s2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"r", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                  RowBox[{"t22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["dd2", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
            SuperscriptBox["s2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
              RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox["dd2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "r", "-", 
                  RowBox[{"3", " ", "e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", 
                  RowBox[{"2", " ", "t22"}], "-", 
                  RowBox[{"2", " ", "m2", " ", "t22"}]}], ")"}]}], " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "r", "+", 
                 RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"4", " ", "e22", " ", "s2", " ", "\[Alpha]2"}], "-", 
                 RowBox[{
                 "4", " ", "e22", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
                 "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"3", " ", "e22", " ", "s2"}]}], ")"}], " ", "t22",
                   " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", 
              RowBox[{"2", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t22", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
              "+", 
              RowBox[{
              "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                 RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                 RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                 RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                    "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["e22", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"2", "-", 
                    RowBox[{"6", " ", "t22"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]2"}],
                  "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                   " ", 
                  RowBox[{"(", 
                   RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "m2"}], ")"}], " ", "t22"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]2"}],
                  "+", 
                 RowBox[{"\[Alpha]1", " ", 
                  RowBox[{"(", 
                   RowBox[{"5", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2", "-", 
                    RowBox[{"10", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"6", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"2", " ", "t22"}], "+", 
              RowBox[{"2", " ", "m2", " ", "r", " ", "t22"}], "+", 
              RowBox[{"2", " ", "\[Alpha]1"}], "-", 
              RowBox[{"3", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m2", " ", "r", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"m2", " ", "r", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", "r", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "+", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"3", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"m2", " ", "r", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", "r", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
              "-", 
              RowBox[{
              "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"6", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["e22", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                   " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  SuperscriptBox["t22", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"m2", " ", "\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "r", "-", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"4", "+", "r"}], ")"}], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"4", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}], "-", 
                 RowBox[{"t22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "4"}], "-", 
                    RowBox[{"6", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]1"}], ")"}]}], "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["dd2", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
            SuperscriptBox["s2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
              RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], 
           "+", 
           RowBox[{
            SuperscriptBox["dd2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], 
                ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", "\[Alpha]2"}],
               "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"3", " ", "e22"}]}], ")"}], " ", "s2"}]}], ")"}], 
               " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                 RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{"4", " ", "m2", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"3", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{
              "3", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", "m2", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
              "+", 
              RowBox[{
              "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{
              "2", " ", "s2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{
              "2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"8", " ", "m2", " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["m2", "2"], " ", "s2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                 RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                 RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                 RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                    "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", 
                 RowBox[{"3", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", "m2", "+", "s2", "-", 
                    RowBox[{"m2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{"2", " ", "\[Alpha]1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2", "+", "s2", "-", 
                    RowBox[{"m2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["e22", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{"\[Alpha]1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"t22", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "\[Alpha]1", "-", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
              RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
              "-", 
              RowBox[{
              "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
               "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["e22", "3"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                   " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["e22", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "s2"}]}], ")"}]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["m2", "2"], " ", "t22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}], "-", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "-", 
                    RowBox[{"9", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"4", "+", 
                    RowBox[{"8", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], "3"], 
    " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.701094122097896*^9, 3.701871774855743*^9, 
  3.704545449879075*^9, 3.73900649194268*^9, 3.73900804472447*^9, 
  3.7402286239888945`*^9, 3.7402294604955373`*^9, 3.740246990141737*^9, 
  3.766236663005335*^9, 
  3.76623669811705*^9},ExpressionUUID->"d9323cf9-853a-45e4-b9ec-d0a0ca227e5e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.6 The main recursion itpseudomCI[s2, \[Alpha]1, \[Alpha]2, m2, r][{t22, \
e22, dd2}]\
\>", "Section",
 CellChangeTimes->{{3.740228744175974*^9, 3.7402287477835712`*^9}, {
  3.740228784183831*^9, 3.7402288216597786`*^9}, {3.740229205798175*^9, 
  3.740229213884983*^9}, {3.766236123587365*^9, 3.7662361423390813`*^9}, {
  3.7662368741958995`*^9, 3.7662368744458733`*^9}, {3.7752249753559427`*^9, 
  3.7752249775878773`*^9}},ExpressionUUID->"e33c7d42-2413-4681-94a4-\
223c28a02441"],

Cell["\<\
For given parameters {s2, \[Alpha]1, \[Alpha]2, m2, r}, itpseudomCI computes \
{t22(t+1), e22(t+1), dd2(t+1)} from  t22(t), e22(t), dd2(t)} .
Because computation of e22time1, etc. (see above) is time consuming, we \
define itpseudomCI[s2,\[Alpha]1,\[Alpha]2,m2,r][{t22,e22,dd2}] explicitly by \
the right-hand side of {t22time1,e22time1,dd2time1}.\
\>", "Text",
 CellChangeTimes->{{3.718640529283265*^9, 3.7186406415024853`*^9}, {
   3.7186406839757323`*^9, 3.7186406994152765`*^9}, {3.7251782532936277`*^9, 
   3.7251782548857718`*^9}, 3.725874063048973*^9, 3.7402288352185307`*^9, {
   3.740229219806268*^9, 3.7402292412457*^9}, {3.7402293663597527`*^9, 
   3.7402294436554327`*^9}, {3.7662361625750628`*^9, 
   3.7662362320692673`*^9}, {3.7662368704144917`*^9, 3.766236870601982*^9}, {
   3.7900072843345604`*^9, 3.7900073559430475`*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"6607fd88-1089-4811-955d-4cd2673763ab"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"itpseudomCI", "[", 
      RowBox[{
      "s2_", ",", "\[Alpha]1_", ",", "\[Alpha]2_", ",", "m2_", ",", "r_"}], 
      "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"t22_", ",", "e22_", ",", "dd2_"}], "}"}], "]"}], ":=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"dd2", " ", "s2"}], "+", "t22", "+", 
           RowBox[{"e22", " ", "s2", " ", "t22"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
           RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "+", 
           RowBox[{
            SuperscriptBox["dd2", "2"], " ", 
            SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["dd2", "2"], " ", "m2", " ", 
            SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["dd2", "2"], " ", 
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}],
            "-", 
           RowBox[{
           "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "dd2", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "m2", " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", "\[Alpha]1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["e22", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
            SuperscriptBox["s2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", 
              RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "t22", "+", 
                 RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
              RowBox[{
              "3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
              RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{
              "2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
              "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
               "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  SuperscriptBox["t22", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"dd2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["e22", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
            SuperscriptBox["s2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]1"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               "\[Alpha]1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
               "\[Alpha]1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"dd2", " ", "s2"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["e22", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
              RowBox[{
              "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"t22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "4"}], "+", "m2", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"2", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}], 
                 "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"m2", "-", 
                    RowBox[{"4", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}], 
                 "+", 
                 RowBox[{"2", " ", "dd2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", "t22", "+", 
                 RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["dd2", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                  SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                   ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"m2", " ", "t22"}], "-", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}]}], 
                   ")"}]}], "+", 
                 RowBox[{"dd2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2", "-", 
                    RowBox[{"4", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{"s2", "-", 
              RowBox[{"m2", " ", "s2"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "r", 
                  " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                    ")"}], " ", "\[Alpha]1"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                    ")"}], " ", "\[Alpha]1"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                    ")"}], " ", "\[Alpha]1"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                    ")"}], " ", "\[Alpha]1"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                    ")"}], " ", "\[Alpha]1"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "r", 
                  " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   "\[Alpha]2"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   "\[Alpha]2"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
               "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "s2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", "t22", 
                    "-", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   "\[Alpha]2"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}],
               ")"}]}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["dd2", "3"]}], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                 RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}],
               "-", 
              RowBox[{
               SuperscriptBox["dd2", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], 
                   ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"3", " ", "e22", " ", "s2"}]}], ")"}], " ", "t22",
                   " ", 
                  RowBox[{"(", 
                   RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                   ")"}]}]}], ")"}]}], "-", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                 RowBox[{"2", " ", "m2", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                 RowBox[{
                  SuperscriptBox["m2", "2"], " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                 RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{"2", " ", "m2", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                  SuperscriptBox["m2", "2"], " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{
                 "2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                 "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                  "\[Alpha]2"}], "-", 
                 RowBox[{"4", " ", "m2", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["m2", "2"], " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                  "\[Alpha]2"}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]1", "-", 
                    RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                    "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{"4", "-", 
                    RowBox[{"3", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["e22", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                  SuperscriptBox["s2", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"e22", " ", "s2"}]}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                   ")"}]}], "-", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"e22", " ", "s2"}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"2", " ", "e22", " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["m2", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["e22", "2"], " ", 
                    SuperscriptBox["s2", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                    RowBox[{"e22", " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["dd2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                 SuperscriptBox["s2", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                   RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["dd2", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "r", "-", 
                    RowBox[{"3", " ", "e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}], "+", 
                    RowBox[{"2", " ", "t22"}], "-", 
                    RowBox[{"2", " ", "m2", " ", "t22"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "r", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "e22", " ", "s2", " ", "\[Alpha]2"}], 
                    "-", 
                    RowBox[{
                    "4", " ", "e22", " ", "m2", " ", "s2", " ", "\[Alpha]2"}],
                     "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "e22", " ", "s2"}]}], ")"}], " ", "t22",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"dd2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "-", 
                   RowBox[{"2", " ", "\[Alpha]1"}], "+", 
                   RowBox[{"t22", " ", "\[Alpha]1"}], "-", 
                   RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], 
                   "+", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                   "2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]1", "-", 
                    RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                    "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["e22", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                    SuperscriptBox["s2", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"6", " ", "t22"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]2"}],
                     "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"4", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "m2"}], ")"}], " ", "t22"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]2"}],
                     "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2", "-", 
                    RowBox[{"10", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"6", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "-", 
                   RowBox[{"2", " ", "t22"}], "+", 
                   RowBox[{"2", " ", "m2", " ", "r", " ", "t22"}], "+", 
                   RowBox[{"2", " ", "\[Alpha]1"}], "-", 
                   RowBox[{"3", " ", "t22", " ", "\[Alpha]1"}], "+", 
                   RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                   RowBox[{"m2", " ", "r", " ", "t22", " ", "\[Alpha]1"}], 
                   "+", 
                   RowBox[{"m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"m2", " ", "r", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", "r", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], 
                   "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{"m2", " ", "r", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", "r", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                   "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"6", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "3"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["e22", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                    SuperscriptBox["s2", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    SuperscriptBox["t22", "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"m2", " ", "\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "r", "-", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"4", "+", "r"}], ")"}], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"4", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}], "-", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "-", 
                    RowBox[{"6", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]1"}], ")"}]}], "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["dd2", "3"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                 SuperscriptBox["s2", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                   RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["dd2", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], 
                    ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"3", " ", "e22"}]}], ")"}], " ", "s2"}]}], ")"}], 
                    " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{"dd2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{"4", " ", "m2", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], 
                   "+", 
                   RowBox[{"3", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
                   "-", 
                   RowBox[{
                   "3", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
                   "+", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{"4", " ", "m2", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                   "2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "s2", " ", "t22", " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{
                   "2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1", 
                    " ", "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"8", " ", "m2", " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["m2", "2"], " ", "s2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]1", "-", 
                    RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
                    RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22", "+", 
                    RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
                    "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", "m2"}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "-", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", 
                    RowBox[{"3", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2", "+", "s2", "-", 
                    RowBox[{"m2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "m2", "+", "s2", "-", 
                    RowBox[{"m2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["e22", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                    SuperscriptBox["s2", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{"t22", " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "\[Alpha]1", "-", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
                   RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
                   RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], 
                   "-", 
                   RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
                   RowBox[{
                   "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["m2", "2"], " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                    "\[Alpha]2"}], "+", 
                   RowBox[{
                    SuperscriptBox["e22", "3"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                    SuperscriptBox["s2", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                   RowBox[{
                    SuperscriptBox["e22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}]}], " ", 
                    "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "s2"}]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                     " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "t22", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["m2", "2"], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "s2"}]}], ")"}], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "r"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "s2"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                    "\[Alpha]2"}], "-", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                    RowBox[{"s2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "-", 
                    RowBox[{"9", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "-", 
                    RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"4", "+", 
                    RowBox[{"8", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
             ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
                  ")"}], " ", "\[Alpha]1"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"dd2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 "\[Alpha]2"}], "-", 
                RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
             ")"}]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], 
          "3"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], 
             ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
               "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
        ")"}]}]}], "}"}]}], ";"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7402295108197556`*^9, 3.740229520783454*^9}, {
   3.740229558792274*^9, 3.7402295607016487`*^9}, {3.740229600499233*^9, 
   3.7402296862549133`*^9}, {3.740230067852441*^9, 3.740230084292277*^9}, {
   3.7402302277200713`*^9, 3.740230269534949*^9}, 3.7402470130504513`*^9, {
   3.7402470581334248`*^9, 3.7402470869958944`*^9}, {3.740247118343014*^9, 
   3.740247136704363*^9}, {3.7402471691609755`*^9, 3.7402471951481447`*^9}, 
   3.766235925665171*^9, {3.76623620939565*^9, 3.7662362095519037`*^9}, {
   3.766236749481466*^9, 3.7662367603098536`*^9}, {3.7662367923118043`*^9, 
   3.766236850850051*^9}},ExpressionUUID->"6fc87d43-0009-4a93-bf9a-\
f2bff2469a9c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Denominator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"itpseudomCI", "[", 
      RowBox[{"s2", ",", "\[Alpha]1", ",", "\[Alpha]2", ",", "m2", ",", "r"}],
       "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "]"}], "]"}], "//",
   "Simplify"}]], "Input",
 CellChangeTimes->{{3.7663885217522774`*^9, 3.766388524169013*^9}, {
  3.766388561647909*^9, 
  3.766388596560627*^9}},ExpressionUUID->"625bbf28-2db9-40a0-9b5b-\
444a3b843710"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
       " ", "\[Alpha]1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], "2"], 
    " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"dd2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22"}]}], ")"}], 
        " ", "\[Alpha]1"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
         ")"}]}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"dd2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
        "\[Alpha]2"}], "-", 
       RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}], "2"]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7663885999750323`*^9},ExpressionUUID->"762b3f75-14ff-4db1-8a34-\
75b26d80cb9e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"denom", "=", 
  RowBox[{
   RowBox[{"Denominator", "[", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"itpseudomCI", "[", 
       RowBox[{
       "s2", ",", "\[Alpha]1", ",", "\[Alpha]2", ",", "m2", ",", "r"}], "]"}],
       "[", 
      RowBox[{"{", 
       RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "]"}], "]"}], 
   "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.766388625027684*^9, 
  3.7663886629233847`*^9}},ExpressionUUID->"09794b82-aff9-490f-acbf-\
b6252c99144b"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"e22", " ", "s2"}], "+", 
    RowBox[{"e22", " ", "m2", " ", "s2"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"e22", " ", "s2"}], "-", 
    RowBox[{"e22", " ", "m2", " ", "s2"}], "+", "\[Alpha]1", "-", 
    RowBox[{"dd2", " ", "s2", " ", "\[Alpha]1"}], "+", 
    RowBox[{"e22", " ", "s2", " ", "\[Alpha]1"}], "+", 
    RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
    RowBox[{"e22", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
    RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
    RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "-", 
    RowBox[{"e22", " ", "s2", " ", "t22", " ", "\[Alpha]1"}], "+", 
    RowBox[{"e22", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1"}]}], 
   ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"e22", " ", "s2"}], "+", 
    RowBox[{"e22", " ", "m2", " ", "s2"}], "-", 
    RowBox[{"dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
    RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
    RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
    RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
    RowBox[{"e22", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
    RowBox[{"e22", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.7663886566009274`*^9, 3.766388664090205*^9}, 
   3.7664908987449017`*^9, 3.766658851883127*^9, 3.7667250690251374`*^9, 
   3.766736649283265*^9, 3.7667707034910836`*^9, 3.7668167879463453`*^9, 
   3.7668999675193143`*^9, 3.7670002053308144`*^9, 3.769242273268936*^9, 
   3.7697593442337427`*^9, 3.7746158625230026`*^9, 3.7746829405389967`*^9, 
   3.7754556405118694`*^9, 3.780402692523847*^9, 3.7804084855841675`*^9, 
   3.7804089526125937`*^9, 3.78497466237191*^9, 3.7850485519329376`*^9, 
   3.7851438511733823`*^9, 3.78523946638791*^9, 3.7853305850869684`*^9, 
   3.785395940875236*^9, 3.7854191530806036`*^9, 3.7854926185335903`*^9, 
   3.7857650712173166`*^9, 3.7867061881060658`*^9, 3.789121972027325*^9, 
   3.789210313270503*^9, 3.7947567872111406`*^9, 3.7948085045193*^9, 
   3.794813995859682*^9, 3.7957858515741453`*^9, 3.79690623163227*^9, 
   3.8001940103638115`*^9},ExpressionUUID->"b767b42f-9528-4372-af2e-\
e7e52876cbf3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Denominator", "[", 
   RowBox[{
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"itpseudomCI", "[", 
       RowBox[{
       "s2", ",", "\[Alpha]1", ",", "\[Alpha]2", ",", "m2", ",", "r"}], "]"}],
       "[", 
      RowBox[{"{", 
       RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "]"}], 
    RowBox[{"{", 
     RowBox[{"denom", ",", "denom", ",", 
      RowBox[{"denom", "^", "2"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663886708369627`*^9, 3.7663887201657124`*^9}, {
  3.76638875183403*^9, 3.766388769474457*^9}, {3.7663888162424035`*^9, 
  3.7663888239408274`*^9}},ExpressionUUID->"9112c5a5-fec6-46e8-a4e7-\
2f837f729e0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.7663887276770225`*^9, 3.7663887916901026`*^9, 
  3.766388825510933*^9},ExpressionUUID->"e0d00c5d-092c-4d0b-9e23-\
5268afd84181"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Analysis", "Subchapter",
 CellChangeTimes->{{3.740289335827756*^9, 3.7402893433600245`*^9}, {
  3.775224987066078*^9, 
  3.7752249877037716`*^9}},ExpressionUUID->"d9fbf30c-7271-4a60-b18c-\
576f02eb07b9"],

Cell[CellGroupData[{

Cell["3.1 Equilibria under random mating (\[Alpha]1 = \[Alpha]2 = 0)", \
"Section",
 CellChangeTimes->{{3.740290951770843*^9, 3.7402909612816477`*^9}, {
   3.7746827370664034`*^9, 3.7746827461068726`*^9}, {3.775224990896264*^9, 
   3.775224991608153*^9}, 3.780411432333787*^9, {3.78041153178717*^9, 
   3.7804115390059786`*^9}},ExpressionUUID->"5e2c766d-aaf4-466c-a036-\
50e2956af62e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"itpseudomCI", "[", 
     RowBox[{"s2", ",", "0", ",", "0", ",", "m2", ",", "r"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "-", 
   RowBox[{"{", 
    RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.740290980321225*^9, 3.740290986065326*^9}, {
  3.740291082867441*^9, 3.7402910836179767`*^9}, {3.7662369346096044`*^9, 
  3.7662369474226556`*^9}},ExpressionUUID->"785f5aa6-4417-4307-8b0d-\
0909cd34c9a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"dd2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
     RowBox[{"m2", " ", "t22"}]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"e22", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"e22", " ", 
      RowBox[{"(", 
       RowBox[{"s2", "-", 
        RowBox[{"e22", " ", "s2"}], "+", 
        RowBox[{"m2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "s2"}]}], 
          ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "dd2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["e22", "2"], " ", 
         SuperscriptBox["m2", "2"], " ", 
         SuperscriptBox["s2", "2"]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s2"}], ")"}]}], "+", 
        RowBox[{"s2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "e22"}], "+", 
           RowBox[{
            SuperscriptBox["e22", "2"], " ", "s2"}]}], ")"}]}], "-", 
        RowBox[{"m2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "r", "-", "s2", "+", 
           RowBox[{"2", " ", "e22", " ", "s2"}], "+", 
           RowBox[{"r", " ", "s2"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["e22", "2"], " ", 
            SuperscriptBox["s2", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
     RowBox[{"e22", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "m2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s2"}], ")"}], " ", "t22"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}], ")"}], 
     "2"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7402910794850264`*^9, 3.740291086458027*^9}, 
   3.7662369524228125`*^9},ExpressionUUID->"08bbff48-43d7-4006-916b-\
a4174f01677c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"s2", "-", 
            RowBox[{"e22", " ", "s2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "s2"}]}], 
              ")"}]}]}], ")"}]}], 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]}]]}], "}"}], 
      "\[Equal]", "0"}], ",", 
     RowBox[{"{", "e22", "}"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s1", ">", "0"}], ",", 
      RowBox[{"s2", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.740291199357988*^9, 3.7402912581646*^9}, {
  3.7662369751179457`*^9, 
  3.766236980055688*^9}},ExpressionUUID->"4afe95d6-79d2-4353-86fc-\
ffaef78d4491"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", 
     FractionBox[
      RowBox[{"m2", "-", "s2", "+", 
       RowBox[{"m2", " ", "s2"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.740291239399724*^9, 3.740291260757517*^9}, 
   3.766236981572674*^9},ExpressionUUID->"229b09c3-9038-42d7-9e66-\
ffc2da633094"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"itpseudomCI", "[", 
        RowBox[{"s2", ",", "0", ",", "0", ",", "m2", ",", "r"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "-", 
      RowBox[{"{", 
       RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}]}], ")"}], "/.", 
    RowBox[{"e22", "\[Rule]", "0"}]}], "/.", 
   RowBox[{"dd2", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.774682928461355*^9, 
  3.774682962683874*^9}},ExpressionUUID->"bdc561c5-ab70-48fe-8300-\
09617d205b56"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "m2"}], " ", "t22"}], ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.7746829412445197`*^9, 
  3.7746829632982826`*^9}},ExpressionUUID->"a743c168-908e-4706-8830-\
6096c8fd0d49"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"itpseudomCI", "[", 
       RowBox[{"s2", ",", "0", ",", "0", ",", "m2", ",", "r"}], "]"}], "[", 
      RowBox[{"{", 
       RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "-", 
     RowBox[{"{", 
      RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}]}], ")"}], "/.", 
   RowBox[{"e22", "\[Rule]", 
    FractionBox[
     RowBox[{"m2", "-", "s2", "+", 
      RowBox[{"m2", " ", "s2"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}]]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.774682978308024*^9, 
  3.774682984927763*^9}},ExpressionUUID->"65ae37d8-c2b9-44c3-88b6-\
1e72c8bfa0f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"dd2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "+", 
     RowBox[{"m2", " ", "t22"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}]}]], ",", "0", ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "dd2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
      RowBox[{"(", 
       RowBox[{"m2", "-", "r", "-", "s2", "+", 
        RowBox[{"m2", " ", "s2"}]}], ")"}]}], "+", 
     RowBox[{"m2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"m2", "-", "s2", "+", 
        RowBox[{"m2", " ", "s2"}]}], ")"}], " ", "t22"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "s2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7746829864128227`*^9},ExpressionUUID->"700c65ba-18ca-46c0-9105-\
0a5a029a7e81"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "dd2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7746829954392815`*^9, 
  3.7746830107432337`*^9}},ExpressionUUID->"6b7244ed-e858-4e2b-869d-\
b29c955071f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t22", "\[Rule]", "0"}], ",", 
    RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.774683011489771*^9},ExpressionUUID->"f2cd7cbb-b4a6-454d-bd44-\
2d6158141008"]
}, Closed]],

Cell[BoxData[{
 RowBox[{"Thus", ",", " ", 
  RowBox[{"there", " ", "are", " ", "the", " ", "two", " ", "equilibria", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
   RowBox[{"(", 
    RowBox[{
    "swamping", " ", "of", " ", "the", " ", "island", " ", "by", " ", "the", 
     " ", "continent"}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"and", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t22", "\[Rule]", "0"}], ",", 
    RowBox[{"e22", "\[Rule]", 
     RowBox[{"1", "-", 
      FractionBox["m2", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], " ", "s2"}]]}]}], ",", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "m2"}], "+", "s2", "-", 
      RowBox[{"m2", " ", "s2"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "m2"}], ")"}], " ", "s2"}]], ",", 
    RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
  RowBox[{"(", 
   RowBox[{
   "polymorphism", " ", "at", " ", "E", " ", "and", " ", "loss", " ", "of", 
    " ", "T2"}], ")"}]}]}], "Text",
 CellChangeTimes->{{3.7746828731737924`*^9, 3.7746828805310574`*^9}, {
  3.774683023920663*^9, 3.7746831856503935`*^9}, {3.780403507715558*^9, 
  3.7804035276504035`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"1f0020dd-b0ab-4d4e-9632-d82d3bbf6cae"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.2 Equilibria and their stability if m = 0 (an isolated population)\
\>", "Section",
 CellChangeTimes->{{3.7670027271733956`*^9, 3.767002761149217*^9}, {
  3.774683406327307*^9, 3.774683420574532*^9}, {3.7752249986318274`*^9, 
  3.7752249992174196`*^9}, {3.785504994859355*^9, 3.785504996724269*^9}, {
  3.7968200963703527`*^9, 
  3.796820102408863*^9}},ExpressionUUID->"b45697a4-c6b9-4260-bdf9-\
c36743b13f58"],

Cell[CellGroupData[{

Cell["3.2.1 Existence of equilibria and invariance of dd2 = 0", "Subsection",
 CellChangeTimes->{{3.785505087730028*^9, 
  3.7855051055278053`*^9}},ExpressionUUID->"d897ba76-7d16-4185-9dbb-\
1b7af1e5520c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"deltam0", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"itpseudomCI", "[", 
      RowBox[{"s", ",", "\[Alpha]1", ",", "\[Alpha]2", ",", "0", ",", "r"}], 
      "]"}], "[", 
     RowBox[{"{", 
      RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "-", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.767002112105283*^9, 3.7670021193397856`*^9}, {
   3.7670022028464217`*^9, 3.7670022124058943`*^9}, 
   3.7746835335573516`*^9},ExpressionUUID->"78b283b3-efff-40a8-802d-\
bf617ce9cc0c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "t22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd2", " ", "s"}], "+", "t22", "+", 
         RowBox[{"e22", " ", "s", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["dd2", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd2", " ", "s", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
          " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t22", "+", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{"s", "+", 
               RowBox[{"2", " ", "s", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "t22", "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"e22", " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "-", 
            RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"dd2", " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "t22", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"dd2", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{"e22", " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
           ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"s", "+", 
            RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "e22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["e22", "3"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
             "\[Alpha]1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
             "\[Alpha]2"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["e22", "2"], " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", "s", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
              ")"}]}]}], ")"}]}], "+", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "dd2"}], " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "t22"}], ")"}], " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["dd2", "2"], " ", 
                SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"dd2", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{"3", "-", "t22", "-", 
                  RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{"e22", " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
           ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"s", "+", 
            RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "dd2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["dd2", "3"], " ", 
             SuperscriptBox["s", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], 
            "+", 
            RowBox[{"e22", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
                " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "t22", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["dd2", "2"], " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"r", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "e22", " ", "s"}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}], " ",
                 "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "r", "+", 
                  RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"4", " ", "e22", " ", "s", " ", "\[Alpha]2"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "e22", " ", "s"}]}], ")"}], " ", "t22", 
                   " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"2", " ", "\[Alpha]1"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[Alpha]1", "-", 
                  RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                  RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{"6", " ", "t22"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]2"}],
                   "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1",
                    " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["dd2", "3"], " ", 
             SuperscriptBox["s", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
                " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "t22", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["dd2", "2"], " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"3", " ", "e22"}]}], ")"}], " ", "s"}]}], ")"}], 
                " ", "t22", " ", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
               RowBox[{"2", " ", "s", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"3", " ", "s", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "s", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{
               "2", " ", "s", " ", "t22", " ", "\[Alpha]1", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"4", " ", "s", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                   "\[Alpha]1"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "-", 
                  RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"\[Alpha]1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "s"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                   "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1", "-", 
                  RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "s"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1", "-", 
                  RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"s", "+", 
                  RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "s"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "t22"}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"s", "+", 
                  RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "s"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"s", "+", 
                  RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], "2"], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"s", "+", 
                  RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "s"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"s", "+", 
                  RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["dd2", "3"], " ", 
             SuperscriptBox["s", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}], 
            "+", 
            RowBox[{"e22", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
                " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "t22", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["dd2", "2"], " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]1", "-", "\[Alpha]2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"3", "+", 
                  RowBox[{"2", " ", "\[Alpha]1"}]}], ")"}], " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "+", 
                  RowBox[{"3", " ", "e22", " ", "s"}]}], ")"}], " ", "t22", 
                " ", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "\[Alpha]1", "-", 
                  RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
                  RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", "s", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "-", 
                  RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"\[Alpha]1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"3", "+", 
                    RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{"e22", " ", "s", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"s", "+", 
             RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}], 
        "2"]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7746835447933903`*^9},ExpressionUUID->"f3c6ecfe-ee67-42ea-8b2d-\
53b248c076b4"]
}, Closed]],

Cell["Here is the change in e22 :", "Text",
 CellChangeTimes->{{3.785504593841614*^9, 
  3.785504603466092*^9}},ExpressionUUID->"b178a1de-a29f-4ded-94b3-\
9b9ddeb0325c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"deltae22", "=", 
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "e22"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["e22", "3"], " ", 
           SuperscriptBox["s", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"dd2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
              "\[Alpha]1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
              "\[Alpha]2"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["e22", "2"], " ", "s", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "-", 
             RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
              " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
             RowBox[{"dd2", " ", "s", " ", "\[Alpha]1", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "dd2"}], " ", "s", " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", "t22"}], ")"}], " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
             RowBox[{"\[Alpha]1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["dd2", "2"], " ", 
                 SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                RowBox[{"dd2", " ", "s", " ", 
                 RowBox[{"(", 
                  RowBox[{"3", "-", "t22", "-", 
                   RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd2", " ", "s"}], "+", "t22"}], ")"}], " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{"e22", " ", "s", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"s", "+", 
             RowBox[{"s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}], ")"}]}]}], "/.", 
    RowBox[{"\[Alpha]1", "\[Rule]", "\[Alpha]2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.785494199219557*^9, 3.785494235257799*^9}, {
  3.785494277747329*^9, 
  3.785494280479749*^9}},ExpressionUUID->"73d7ebfc-cf01-411f-83af-\
76ddbd225d6c"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "e22", " ", "s"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "2"], " ", "s"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "4"], " ", 
       SuperscriptBox["s", "3"]}], "-", 
      RowBox[{"dd2", " ", "\[Alpha]2"}], "-", 
      RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", "s", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "e22", " ", "s", " ", "\[Alpha]2"}], "-", 
      RowBox[{"dd2", " ", "e22", " ", "s", " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "2"], " ", "s", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"dd2", " ", "e22", " ", 
       SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "4"], " ", 
       SuperscriptBox["s", "3"], " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "s", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "2", " ", "dd2", " ", "e22", " ", "s", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{"2", " ", "dd2", " ", "e22", " ", 
       SuperscriptBox["s", "2"], " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "e22", " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", "e22", " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", "e22", " ", "s", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "2"], " ", "s", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"4", " ", "dd2", " ", "e22", " ", 
       SuperscriptBox["s", "2"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"4", " ", "dd2", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "2"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"4", " ", "dd2", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "3"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"4", " ", "dd2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "4"], " ", 
       SuperscriptBox["s", "3"], " ", "t22", " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", "e22", " ", "s", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "2"], " ", "s", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e22", "4"], " ", 
       SuperscriptBox["s", "3"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]2", "2"]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"e22", " ", "s"}], "+", 
        RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "+", 
        RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
        RowBox[{"e22", " ", "s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"e22", " ", "s"}], "-", "\[Alpha]2", "+", 
        RowBox[{"dd2", " ", "s", " ", "\[Alpha]2"}], "-", 
        RowBox[{"e22", " ", "s", " ", "\[Alpha]2"}], "+", 
        RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
        RowBox[{"e22", " ", "s", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7854942034071474`*^9, 3.7854942360243573`*^9, 
  3.785494281292281*^9},ExpressionUUID->"f3bdf2aa-ce02-4900-ae1a-\
3f8f5f23c4a3"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Normal", "[", "%", "]"}], "/.", 
   RowBox[{"dd2", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.78550447807509*^9, 
  3.785504518206046*^9}},ExpressionUUID->"5e8ca531-5abb-49be-8d3e-\
69d964e5be38"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "e22", " ", "s"}], 
   RowBox[{"1", "+", 
    RowBox[{"e22", " ", "s"}]}]]}]], "Output",
 CellChangeTimes->{{3.785504498768208*^9, 
  3.7855045189726243`*^9}},ExpressionUUID->"1c68b6db-70cd-4949-846f-\
9e8003676350"]
}, Closed]],

Cell["Therefore, close to dd2 = 0, e22 increases.", "Text",
 CellChangeTimes->{{3.785504613302458*^9, 
  3.7855046322785444`*^9}},ExpressionUUID->"b0d32e36-f74e-4f8a-a0f1-\
26c0d81dc313"],

Cell["\<\
Now we give an example that e22 may decrease (dealing directly with deltae22 \
is too slow):\
\>", "Text",
 CellChangeTimes->{{3.785504645764814*^9, 
  3.785504713052163*^9}},ExpressionUUID->"6a2773a3-2f22-4eba-9aac-\
fd5335a9134e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{"deltae22", ",", 
    RowBox[{"{", 
     RowBox[{"dd2", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.78550433426667*^9, 3.7855043900046635`*^9}, 
   3.7855045307058687`*^9},ExpressionUUID->"b18c04a2-453c-4499-bab2-\
5558449b9922"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "e22", " ", "s"}], 
     RowBox[{"1", "+", 
      RowBox[{"e22", " ", "s"}]}]]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], ")"}], " ", 
     "dd2"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]2"}]}], 
        ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"s", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}], " ", "\[Alpha]2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", "\[Alpha]2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "t22"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Alpha]2", "2"]}]}], ")"}], " ", 
     SuperscriptBox["dd2", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"e22", " ", "s"}]}], ")"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]2"}]}], 
       ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["s", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
       SuperscriptBox["\[Alpha]2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"3", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "t22", "+", 
            SuperscriptBox["t22", "2"]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]2", "2"]}]}], ")"}]}], ")"}], " ", 
     SuperscriptBox["dd2", "3"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]2"}]}], 
         ")"}], "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], "3"]}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "dd2", "]"}], "4"],
    SeriesData[$CellContext`dd2, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`dd2, 
   0, {-(-1 + $CellContext`e22) $CellContext`e22 $CellContext`s/(
    1 + $CellContext`e22 $CellContext`s), 
    Rational[-1, 2] (
     1 + $CellContext`s) (1 + $CellContext`e22 $CellContext`s)^(-2) (-1 + 
     2 $CellContext`t22) $CellContext`\[Alpha]2 (-1 + (-1 + $CellContext`t22) \
$CellContext`\[Alpha]2)^(-1)/(1 + $CellContext`t22 $CellContext`\[Alpha]2), 
    Rational[1, 2] $CellContext`s (
     1 + $CellContext`s) (
      1 + $CellContext`e22 $CellContext`s)^(-3) $CellContext`\[Alpha]2 (-1 + \
(-1 + $CellContext`t22) $CellContext`\[Alpha]2)^(-2) (
      1 + $CellContext`t22 $CellContext`\[Alpha]2)^(-2) (2 + 
     2 $CellContext`\[Alpha]2 + (1 - 2 $CellContext`t22 + 
       2 $CellContext`t22^2) $CellContext`\[Alpha]2^2), 
    Rational[-1, 2] $CellContext`s^2 (
     1 + $CellContext`s) (1 + $CellContext`e22 $CellContext`s)^(-4) (-1 + 
     2 $CellContext`t22) $CellContext`\[Alpha]2^3 (-1 + (-1 + \
$CellContext`t22) $CellContext`\[Alpha]2)^(-3) (
      1 + $CellContext`t22 $CellContext`\[Alpha]2)^(-3) (3 + 
     3 $CellContext`\[Alpha]2 + (
       1 - $CellContext`t22 + $CellContext`t22^2) $CellContext`\[Alpha]2^2)}, 
   0, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.7855043621226735`*^9, 3.7855043910670533`*^9}, 
   3.7855044756105056`*^9, 
   3.7855045324618597`*^9},ExpressionUUID->"8b6013d2-3f08-4314-9b86-\
ee838975423b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "e22", " ", "s"}], 
        RowBox[{"1", "+", 
         RowBox[{"e22", " ", "s"}]}]]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], ")"}], 
        " ", "dd2"}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]2"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], ")"}]}]]}], "<", 
     "0"}], "&&", 
    RowBox[{"\[Alpha]2", ">", "0"}], "&&", 
    RowBox[{"s", ">", "0"}], "&&", 
    RowBox[{"0", "<", "e22", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "<", "t22", "<", "1"}], "&&", 
    RowBox[{"dd2", ">", 
     RowBox[{
      RowBox[{"-", "e22"}], "*", "t22"}]}], "&&", 
    RowBox[{"dd2", ">", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "-", "e22"}], ")"}]}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "t22"}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]2", ",", "s", ",", "e22", ",", "t22", ",", "dd2"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7854968764275184`*^9, {3.785497054068406*^9, 
   3.7854971118252277`*^9}},ExpressionUUID->"6e4ae324-6457-465b-90a8-\
47ad62fe19bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]2", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"s", "\[Rule]", 
     FractionBox["1", "32"]}], ",", 
    RowBox[{"e22", "\[Rule]", 
     FractionBox["1", "64"]}], ",", 
    RowBox[{"t22", "\[Rule]", 
     FractionBox["2", "3"]}], ",", 
    RowBox[{"dd2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["5", "512"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.7854970787941914`*^9, 3.785497113252391*^9, 
  3.7855047408621907`*^9},ExpressionUUID->"808ebd37-5390-45e8-8933-\
f106588cd340"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"deltae22", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]2", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"s", "\[Rule]", 
      FractionBox["1", "32"]}], ",", 
     RowBox[{"e22", "\[Rule]", 
      FractionBox["1", "64"]}], ",", 
     RowBox[{"t22", "\[Rule]", 
      FractionBox["2", "3"]}], ",", 
     RowBox[{"dd2", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["5", "512"]}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7855005782529316`*^9, 
  3.785500590829651*^9}},ExpressionUUID->"6ab809c2-d4df-4f1e-babb-\
2d5219cd4f51"],

Cell[BoxData[
 RowBox[{"-", "0.00005756822661053791`"}]], "Output",
 CellChangeTimes->{3.785500591689168*^9, 
  3.7855047860482616`*^9},ExpressionUUID->"0fb094f8-e4b0-4298-9040-\
40ee46dec8f0"]
}, Closed]],

Cell["Therefore, deltae22<0 is possible!", "Text",
 CellChangeTimes->{{3.7855005113724003`*^9, 3.7855005198415337`*^9}, {
  3.7855048323466578`*^9, 
  3.7855048476518836`*^9}},ExpressionUUID->"66c39949-8e77-42c9-b86c-\
bae35df45c43"],

Cell["\<\
Finding equilibria with dd2\[NotEqual]0 is too complicated (see above). 
Therefore, we study existence of equilibria in linkage equilibrium:\
\>", "Text",
 CellChangeTimes->{{3.7746843651239333`*^9, 3.7746843933129473`*^9}, {
   3.774684449734912*^9, 3.7746844580338163`*^9}, 3.7854934013226795`*^9, {
   3.7855048768401103`*^9, 
   3.785504921183648*^9}},ExpressionUUID->"5a29735d-7e3c-4061-84b4-\
de34fdb283d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"deltam0", "/.", 
   RowBox[{"dd2", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.77468446395304*^9, 
  3.774684474919878*^9}},ExpressionUUID->"0d995477-7636-43af-8e6d-\
ee7cb8bfdfce"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
      ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "e22", " ", "s"}], 
     RowBox[{"1", "+", 
      RowBox[{"e22", " ", "s"}]}]]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.774684475615375*^9},ExpressionUUID->"d20e86c0-fdeb-440e-a7db-\
083a65e58c52"]
}, Closed]],

Cell["This shows that the LE manifold is invariant!", "Text",
 CellChangeTimes->{{3.785493375432709*^9, 
  3.7854933905239553`*^9}},ExpressionUUID->"986c7603-82b7-4393-a80a-\
c89eab3f5e95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.774684495433573*^9, 
  3.774684511573106*^9}},ExpressionUUID->"4c40dca4-ded6-4949-939a-\
3768f72af432"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "1"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "1"}], ",", 
     RowBox[{"e22", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox["\[Alpha]1", 
       RowBox[{"\[Alpha]1", "+", "\[Alpha]2"}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox["\[Alpha]1", 
       RowBox[{"\[Alpha]1", "+", "\[Alpha]2"}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.774684512128502*^9},ExpressionUUID->"0518f64a-71bf-448c-831d-\
37c4daaa7189"]
}, Closed]],

Cell["\<\
Thus, there are six equilibria, which are in LE: the four monomorphic \
equilibria and the one-locus polymorphisms in t22\
\>", "Text",
 CellChangeTimes->{{3.7746845472206316`*^9, 3.7746845831092944`*^9}, {
  3.7854932881533103`*^9, 3.7854933336309233`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"8dc5db8f-b8c2-4cae-86bd-1f9b32782c39"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.2 Local stability", "Subsection",
 CellChangeTimes->{{3.774683645850705*^9, 3.77468365288474*^9}, {
  3.7855051159288177`*^9, 
  3.7855051205901394`*^9}},ExpressionUUID->"4ad52c3a-d31c-4b94-881f-\
836ff435c012"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"itpseudomCI", "[", 
        RowBox[{
        "s", ",", " ", "\[Alpha]1", ",", " ", "\[Alpha]2", ",", " ", "0", ",",
          " ", "r"}], "]"}], "[", 
       RowBox[{"{", 
        RowBox[{"t22", ",", " ", "e22", ",", "dd2"}], "}"}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "}"}]}], 
     "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"e22", " ", "->", " ", "0"}], ",", " ", 
      RowBox[{"dd2", " ", "->", " ", "0"}]}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.7670029430137672`*^9, 3.767002965718484*^9}, {
  3.7670033438890796`*^9, 
  3.767003346626774*^9}},ExpressionUUID->"2fd5c484-2da5-44c9-bcfe-\
c4107c5f9c7c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{"2", "+", 
       RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["t22", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Alpha]2"}], ")"}], " ", "\[Alpha]2"}], 
       "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["t22", "3"], " ", 
        SuperscriptBox["\[Alpha]2", "2"]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
        SuperscriptBox["\[Alpha]1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["t22", "2"], " ", "\[Alpha]2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
          RowBox[{"t22", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["t22", "2"], " ", 
           SuperscriptBox["\[Alpha]2", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["t22", "3"], " ", 
           SuperscriptBox["\[Alpha]2", "2"]}], "-", 
          RowBox[{"t22", " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"10", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
         ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], "2"]}]], "0", 
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["t22", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "\[Alpha]2"}], ")"}], " ", "\[Alpha]2"}],
          "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "3"], " ", 
          SuperscriptBox["\[Alpha]2", "2"]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
          SuperscriptBox["\[Alpha]1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"t22", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["t22", "2"], " ", 
             SuperscriptBox["\[Alpha]2", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["t22", "3"], " ", 
             SuperscriptBox["\[Alpha]2", "2"]}], "-", 
            RowBox[{"t22", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"10", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
         ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], "2"]}]]},
    {"0", 
     RowBox[{"1", "+", "s"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}], "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
         ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]]}]},
    {"0", "0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"10", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["t22", "2"], " ", 
          SuperscriptBox["\[Alpha]2", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["t22", "3"], " ", 
          SuperscriptBox["\[Alpha]2", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["t22", "4"], " ", 
          SuperscriptBox["\[Alpha]2", "2"]}], "-", 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}], 
            "-", 
            RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{
             SuperscriptBox["t22", "3"], " ", "\[Alpha]2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"5", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
          SuperscriptBox["\[Alpha]1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"t22", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"6", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t22", "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}], "2"]}], 
           ")"}]}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
         ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}], "2"]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.767002966452818*^9, 
  3.7670033505646114`*^9},ExpressionUUID->"cf3a3ac1-ff6c-4fa6-b548-\
c43e9eb68d43"]
}, Closed]],

Cell["\<\
Therefore, there is always the eigenvalue 1+s (which is bigger than 1). \
Hence, equilibria with e22 = 0 cannot be stable!\
\>", "Text",
 CellChangeTimes->{{3.7670029832201242`*^9, 3.7670030004250135`*^9}, {
  3.774684617384823*^9, 3.774684640725525*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"94953975-fe20-439a-84c8-005a8da46499"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Jacobm0t0e1", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{
         "s", ",", " ", "\[Alpha]1", ",", " ", "\[Alpha]2", ",", " ", "0", 
          ",", " ", "r"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "]"}], ",",
        " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "}"}]}], 
      "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t22", " ", "->", " ", "0"}], ",", " ", 
       RowBox[{"e22", " ", "->", " ", "1"}], ",", " ", 
       RowBox[{"dd2", " ", "->", " ", "0"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.7668227660708413`*^9, 3.76682276936775*^9}, {
   3.76700280506479*^9, 3.76700285586034*^9}, {3.7670030134790773`*^9, 
   3.7670030348100777`*^9}, {3.7670033558303685`*^9, 
   3.7670033637055063`*^9}},ExpressionUUID->"92b81e6f-f4a2-4bbb-8825-\
980b10cc56c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "Jacobm0t0e1", "]"}]], "Input",
 CellChangeTimes->{{3.7670028720637093`*^9, 3.7670028851591215`*^9}, {
  3.7670030419820776`*^9, 
  3.7670030430914736`*^9}},ExpressionUUID->"e571c2c1-0960-4e62-95ea-\
e95a330aa9b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "s"}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]1"}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{"2", "+", "\[Alpha]1"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.7670028857684526`*^9, 3.7670030436539288`*^9, 
  3.7670033701118317`*^9, 
  3.774684678107273*^9},ExpressionUUID->"df79e04f-cd18-4e49-ac63-\
a2fe8869939a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"0", "<", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Alpha]1"}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]]}], "<", "1"}], "&&", 
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7670030663601055`*^9, 3.7670031304907317`*^9}, 
   3.7670032284566164`*^9, {3.767003375769459*^9, 
   3.767003385113758*^9}},ExpressionUUID->"b0d74eca-9c58-4323-a0ab-\
56640e2dd907"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.767003109832879*^9, 3.767003131063938*^9}, 
   3.767003229159717*^9, 3.7670033866293564`*^9, 
   3.7746846808222165`*^9},ExpressionUUID->"ce6a7c41-ecff-4875-8f2a-\
14645acc7491"]
}, Closed]],

Cell["This equilibrium is always asymptotically stable.", "Text",
 CellChangeTimes->{{3.7670031473624907`*^9, 
  3.76700316244088*^9}},ExpressionUUID->"c75e8083-3e98-4a23-bf14-\
cce9ab03d8d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Jacobm0t1e1", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{
         "s", ",", " ", "\[Alpha]1", ",", " ", "\[Alpha]2", ",", " ", "0", 
          ",", " ", "r"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "]"}], ",",
        " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "}"}]}], 
      "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t22", " ", "->", " ", "1"}], ",", " ", 
       RowBox[{"e22", " ", "->", " ", "1"}], ",", " ", 
       RowBox[{"dd2", " ", "->", " ", "0"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.7668227660708413`*^9, 3.76682276936775*^9}, {
   3.76700280506479*^9, 3.76700285586034*^9}, {3.7670030134790773`*^9, 
   3.7670030348100777`*^9}, {3.767003190350232*^9, 3.7670031936159134`*^9}, {
   3.76700339178575*^9, 
   3.7670033933304844`*^9}},ExpressionUUID->"b05f7e03-2221-4d05-b9dc-\
80efb7b376d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "Jacobm0t1e1", "]"}]], "Input",
 CellChangeTimes->{{3.7670028720637093`*^9, 3.7670028851591215`*^9}, {
  3.7670030419820776`*^9, 3.7670030430914736`*^9}, {3.767003200912917*^9, 
  3.767003200975418*^9}},ExpressionUUID->"0d40de6c-c869-4fdb-97ac-\
761c15179494"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "s"}]], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]2"}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{"2", "+", "\[Alpha]2"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{3.7670028857684526`*^9, 3.7670030436539288`*^9, 
  3.767003201616018*^9, 
  3.7670034008808823`*^9},ExpressionUUID->"410ec901-1473-4003-a953-\
e8f0739e625c"]
}, Closed]],

Cell["\<\
Eigenvalues are analogous to the above case t22=0 and e22=1. Therefore, this \
equilibrium is always asymptotically stable.\
\>", "Text",
 CellChangeTimes->{{3.7670031473624907`*^9, 3.76700316244088*^9}, {
  3.7670032438176317`*^9, 3.7670032656475344`*^9}, {3.774684702949051*^9, 
  3.7746847034614477`*^9}, {3.774684953232155*^9, 
  3.774684963939841*^9}},ExpressionUUID->"ba9aafe2-3145-43ad-9e28-\
7f2cb0cb7c19"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Jacobm0tpole1", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{
         "s", ",", " ", "\[Alpha]1", ",", " ", "\[Alpha]2", ",", " ", "0", 
          ",", " ", "r"}], "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "]"}], ",",
        " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", " ", "e22", ",", " ", "dd2"}], "}"}], "}"}]}], 
      "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t22", " ", "->", " ", 
        FractionBox["\[Alpha]1", 
         RowBox[{"\[Alpha]1", "+", "\[Alpha]2"}]]}], ",", " ", 
       RowBox[{"e22", " ", "->", " ", "1"}], ",", " ", 
       RowBox[{"dd2", " ", "->", " ", "0"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Code",
 InitializationCell->False,
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.7668227660708413`*^9, 3.76682276936775*^9}, {
   3.76700280506479*^9, 3.76700285586034*^9}, {3.7670030134790773`*^9, 
   3.7670030348100777`*^9}, {3.767003190350232*^9, 3.7670031936159134`*^9}, {
   3.767003301310667*^9, 3.767003310874909*^9}, {3.7670034088449297`*^9, 
   3.7670034103918858`*^9}},ExpressionUUID->"584f6158-ae59-47d5-ab36-\
bd40923f542b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Eigenvalues", "[", "Jacobm0tpole1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7670028720637093`*^9, 3.7670028851591215`*^9}, {
  3.7670030419820776`*^9, 3.7670030430914736`*^9}, {3.767003200912917*^9, 
  3.767003200975418*^9}, {3.767003317609455*^9, 3.767003318484471*^9}, {
  3.7670034289716873`*^9, 
  3.7670034359418106`*^9}},ExpressionUUID->"1560a083-a61b-4727-b660-\
508e7e239be1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "s"}]], ",", 
   FractionBox[
    RowBox[{"\[Alpha]2", "-", 
     RowBox[{"r", " ", "\[Alpha]2"}], "+", 
     RowBox[{"\[Alpha]1", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "r", "+", "\[Alpha]2"}], ")"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
       RowBox[{"\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
       RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "\[Alpha]2"}], "+", 
       RowBox[{"\[Alpha]1", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
        RowBox[{"\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}], "2"]}]]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7670028857684526`*^9, 3.7670030436539288`*^9, 3.767003201616018*^9, 
   3.7670033192656813`*^9, {3.7670034165794525`*^9, 3.7670034368636484`*^9}, 
   3.77468473684932*^9},ExpressionUUID->"df101b3b-56ad-4c35-b16a-\
d2720e4c3826"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"0", "<", 
      FractionBox[
       RowBox[{"\[Alpha]2", "-", 
        RowBox[{"r", " ", "\[Alpha]2"}], "+", 
        RowBox[{"\[Alpha]1", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "r", "+", "\[Alpha]2"}], ")"}]}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
          RowBox[{"\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}]}]], "<", "1"}], "&&", 
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]2"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]2"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.767004028119382*^9, 
  3.76700404451171*^9}},ExpressionUUID->"efb08006-56ca-4924-bcd1-\
edd4c9e8bf72"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.7670040471210966`*^9},ExpressionUUID->"ff06de86-feab-4b14-a5d8-\
5486b2759d91"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "<", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
          RowBox[{"2", " ", "\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "\[Alpha]2"}], "+", 
          RowBox[{"\[Alpha]1", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"\[Alpha]1", "+", "\[Alpha]2", "+", 
           RowBox[{"\[Alpha]1", " ", "\[Alpha]2"}]}], ")"}], "2"]}]], "<", 
      "1"}], "&&", 
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]2"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"0", "<", "s"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]1"}], "&&", 
     RowBox[{"0", "<", "\[Alpha]2"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.767004069851838*^9, 
  3.7670040780864105`*^9}},ExpressionUUID->"55c859d7-c742-4bb8-b65a-\
83af9bcedcaa"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{{3.7670040715862417`*^9, 
  3.767004078648883*^9}},ExpressionUUID->"660ad217-d9d0-421d-ae85-\
2020589e9bac"]
}, Closed]],

Cell["\<\
Therefore, this equilibrium is always unstable (already within the edge \
e22=1).\
\>", "Text",
 CellChangeTimes->{{3.7670031473624907`*^9, 3.76700316244088*^9}, {
  3.7670032438176317`*^9, 3.7670032656475344`*^9}, {3.767004094602326*^9, 
  3.767004123698956*^9}, {3.785503202117008*^9, 
  3.785503203448243*^9}},ExpressionUUID->"f629527a-d2b8-40e1-8923-\
a1577a980e49"],

Cell["\<\
In summary, there are two asymptotically stable boundary equilibria, both \
corresponding to fixation of E2,
namely {t22 -> 0, e22 -> 1, dd2 -> 0} and {t22 -> 1, e22 -> 1, dd2 -> 0}.
In addition, we know that dd2=0 is invariant. It is unclear whether there are \
equilibria with dd2 \[NotEqual] 0 (presumably not).
Most likely, e22 will always go to fixation. However, it is not necessarily \
monotone increasing. 
Whether t22 is fixed or lost will depend on initial conditions.\
\>", "Text",
 CellChangeTimes->{{3.774684888890136*^9, 3.7746849325333405`*^9}, {
  3.7746849919818993`*^9, 3.7746850615126314`*^9}, {3.7854931242087264`*^9, 
  3.7854931592713003`*^9}, {3.785503229601212*^9, 3.7855032871181555`*^9}, {
  3.785503332865863*^9, 3.7855034261442547`*^9}, {3.787757583994903*^9, 
  3.7877575862666187`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"153098bc-3db8-408b-a3c4-aae0f98fe479"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.3 Examples of numerical iterations", "Subsection",
 CellChangeTimes->{{3.7855051313879414`*^9, 3.785505157650859*^9}, 
   3.7855060245143948`*^9},ExpressionUUID->"9b3f6fe5-6f2a-4fac-951f-\
6e69cab01378"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{"itpseudomCI", "[", 
    RowBox[{"0.02", ",", "5", ",", "5", ",", "0", ",", "0.01"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t2", ",", "e2", ",", "dd"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t2", "\[Rule]", "0.6"}], ",", 
      RowBox[{"e2", "\[Rule]", "0.2"}], ",", 
      RowBox[{"dd", "\[Rule]", 
       RowBox[{"-", "0.01"}]}]}], "}"}]}], ",", "50"}], "]"}]], "Input",
 CellChangeTimes->{{3.7855051647218056`*^9, 3.785505178063139*^9}, {
  3.785505247101601*^9, 3.7855052608047533`*^9}, {3.7855053007249002`*^9, 
  3.7855053097267675`*^9}, {3.7855053399924374`*^9, 
  3.7855053688319297`*^9}},ExpressionUUID->"be09b3d9-cb0d-44a4-bc2f-\
5cb6d2183a58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.6`", ",", "0.2`", ",", 
     RowBox[{"-", "0.01`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6097817039602192`", ",", "0.20276650547298766`", ",", 
     RowBox[{"-", "0.010001195129476746`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6204946947479756`", ",", "0.20552252481871178`", ",", 
     RowBox[{"-", "0.00998259495856348`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6322123396649768`", ",", "0.2082638597067704`", ",", 
     RowBox[{"-", "0.009940299541959265`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6450082967556886`", ",", "0.21098619321571302`", ",", 
     RowBox[{"-", "0.009869749519784638`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6589541947625184`", ",", "0.21368519544020553`", ",", 
     RowBox[{"-", "0.009765671037281142`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6741163400751424`", ",", "0.2163566779111149`", ",", 
     RowBox[{"-", "0.009622048768938466`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6905511452739234`", ",", "0.21899681281201525`", ",", 
     RowBox[{"-", "0.009432149690034688`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7082989058559409`", ",", "0.22160243674781194`", ",", 
     RowBox[{"-", "0.00918863066111463`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.727375490278384`", ",", "0.22417146240808228`", ",", 
     RowBox[{"-", "0.008883776167348919`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7477614794605126`", ",", "0.22670342361194076`", ",", 
     RowBox[{"-", "0.008509927925287535`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7693883481592224`", ",", "0.22920017731528997`", ",", 
     RowBox[{"-", "0.008060182700765433`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7921215226385877`", ",", "0.2316667751886754`", ",", 
     RowBox[{"-", "0.00752944156679087`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8157407551357139`", ",", "0.2341124883483462`", ",", 
     RowBox[{"-", "0.006915878423806708`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8399195136339235`", ",", "0.2365519071021166`", ",", 
     RowBox[{"-", "0.0062228315224596405`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8642073859086439`", ",", "0.23900592299235196`", ",", 
     RowBox[{"-", "0.005460968389656844`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8880231656413284`", ",", "0.24150221530991667`", ",", 
     RowBox[{"-", "0.00465028651673292`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9106709869138144`", ",", "0.24407462300991942`", ",", 
     RowBox[{"-", "0.0038210829129514522`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9313952134457052`", ",", "0.2467606013159643`", ",", 
     RowBox[{"-", "0.0030125975432031015`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9494855151291465`", ",", "0.2495961503945654`", ",", 
     RowBox[{"-", "0.0022680583802355387`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.964422595376279`", ",", "0.2526086208939977`", ",", 
     RowBox[{"-", "0.0016260569467817397`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9760165804225566`", ",", "0.25580971155482235`", ",", 
     RowBox[{"-", "0.0011108143215805488`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9844614161995574`", ",", "0.2591924528857016`", ",", 
     RowBox[{"-", "0.0007262918681362318`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9902574710924715`", ",", "0.2627346382076335`", ",", 
     RowBox[{"-", "0.0004579696612581006`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9940408544103024`", ",", "0.2664069438736251`", ",", 
     RowBox[{"-", "0.00028097178442304966`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9964174245376023`", ",", "0.2701809873138797`", ",", 
     RowBox[{"-", "0.00016910832572007473`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9978704837223913`", ",", "0.2740339010997602`", ",", 
     RowBox[{"-", "0.00010050296923412069`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9987431929007597`", ",", "0.2779493002449134`", ",", 
     RowBox[{"-", "0.000059253801210834586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9992614791471797`", ",", "0.2819162671201418`", ",", 
     RowBox[{"-", "0.00003476179828926757`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9995671672154164`", ",", "0.28592781421894`", ",", 
     RowBox[{"-", "0.00002033149690218614`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9997467190986821`", ",", "0.2899795373498364`", ",", 
     RowBox[{"-", "0.000011869300684179594`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9998519234553105`", ",", "0.2940686427826274`", ",", 
     RowBox[{"-", "6.921073741817779`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999134761934915`", ",", "0.29819330802385846`", ",", 
     RowBox[{"-", "4.03268532134629`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999494586236332`", ",", "0.3023522828153781`", ",", 
     RowBox[{"-", "2.3485158041465085`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999704826558208`", ",", "0.30654464718406976`", ",", 
     RowBox[{"-", "1.3672023412557768`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999827630896048`", ",", "0.3107696671532153`", ",", 
     RowBox[{"-", "7.956979803281726`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999899350210433`", ",", "0.3150267095359407`", ",", 
     RowBox[{"-", "4.6297837757250615`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999941230916376`", ",", "0.31931519192065144`", ",", 
     RowBox[{"-", "2.693283737566245`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999965685779107`", ",", "0.32363455343415826`", ",", 
     RowBox[{"-", "1.5664596952200124`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999979964861074`", ",", "0.3279842377117447`", ",", 
     RowBox[{"-", "9.109106877982819`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999988302157509`", ",", "0.3323636830206736`", ",", 
     RowBox[{"-", "5.296071033196203`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999993170079662`", ",", "0.3367723165720714`", ",", 
     RowBox[{"-", "3.078606509415994`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999996012298168`", ",", "0.3412095512865617`", ",", 
     RowBox[{"-", "1.78927585076941`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999997671762504`", ",", "0.34567478400063306`", ",", 
     RowBox[{"-", "1.039736178903122`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999998640655144`", ",", "0.3501673945227988`", ",", 
     RowBox[{"-", "6.040759797094779`*^-9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999206348426`", ",", "0.35468674519505444`", ",", 
     RowBox[{"-", "3.5089908574333793`*^-9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999536629894`", ",", "0.35923218075888563`", ",", 
     RowBox[{"-", "2.0379561693954943`*^-9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999729464641`", ",", "0.36380302840887047`", ",", 
     RowBox[{"-", "1.1833929962649965`*^-9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999842050623`", ",", "0.3683985979657087`", ",", 
     RowBox[{"-", "6.870432270813436`*^-10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999907783289`", ",", "0.37301818212892507`", ",", 
     RowBox[{"-", "3.988044228514551`*^-10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999999994616073`", ",", "0.3776610567860027`", ",", 
     RowBox[{"-", "2.3144957021681852`*^-10"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7855051885301275`*^9, {3.785505293747892*^9, 3.7855053115467067`*^9}, {
   3.7855053442550097`*^9, 
   3.785505369691453*^9}},ExpressionUUID->"2bddb56f-d685-48ff-bd01-\
07a62f5f291e"]
}, Closed]],

Cell["\<\
In the following example (numerical values from above), e22 decreases \
initially before going to fixation :\
\>", "Text",
 CellChangeTimes->{{3.785505937796109*^9, 
  3.7855059705363274`*^9}},ExpressionUUID->"11dfec70-e382-4d89-a3ab-\
75a90d7673ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{"itpseudomCI", "[", 
    RowBox[{
     FractionBox["1.", "32"], ",", 
     FractionBox["1.", "2"], ",", 
     FractionBox["1.", "2"], ",", "0", ",", "0.01"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"e22", "\[Rule]", 
       FractionBox["1", "64"]}], ",", 
      RowBox[{"t22", "\[Rule]", 
       FractionBox["2", "3"]}], ",", 
      RowBox[{"dd2", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["5", "512"]}]}]}], "}"}]}], ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.7855054283418736`*^9, 3.7855055275520983`*^9}, {
  3.785505588310301*^9, 3.7855055925109158`*^9}, {3.785505722988167*^9, 
  3.7855057250529838`*^9}, {3.785505763600913*^9, 3.785505777148147*^9}, {
  3.7855058420449686`*^9, 3.7855058421928844`*^9}, {3.7855058814074283`*^9, 
  3.785505887210087*^9}},ExpressionUUID->"7ec2ec7b-adb9-4280-8d98-\
c3fd650852f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", 
     FractionBox["1", "64"], ",", 
     RowBox[{"-", 
      FractionBox["5", "512"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6782498519771878`", ",", "0.015567431773389461`", ",", 
     RowBox[{"-", "0.00979473144019381`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6904397202346986`", ",", "0.015468579929674972`", ",", 
     RowBox[{"-", "0.009797105346117328`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7032205844601958`", ",", "0.015326575977114119`", ",", 
     RowBox[{"-", "0.009769315553951406`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7165650045200558`", ",", "0.015140083217322556`", ",", 
     RowBox[{"-", "0.009707940812665024`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.730432152913462`", ",", "0.014908443171646923`", ",", 
     RowBox[{"-", "0.00960971213236455`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7447664095417589`", ",", "0.014631825317890453`", ",", 
     RowBox[{"-", "0.009471689681562537`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7594963666373693`", ",", "0.014311369843669092`", ",", 
     RowBox[{"-", "0.009291470280748238`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7745344505054937`", ",", "0.013949310017206805`", ",", 
     RowBox[{"-", "0.009067415925958177`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7897773731636358`", ",", "0.013549058292177299`", ",", 
     RowBox[{"-", "0.008798887162324912`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8051076037421491`", ",", "0.01311523917888534`", ",", 
     RowBox[{"-", "0.00848645845325891`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8203959875257197`", ",", "0.012653653082778205`", ",", 
     RowBox[{"-", "0.008132087442465354`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.835505535818104`", ",", "0.012171159444070928`", ",", 
     RowBox[{"-", "0.007739208043424218`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8502962676364605`", ",", "0.01167547487956522`", ",", 
     RowBox[{"-", "0.00731272041048265`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8646308218888387`", ",", "0.011174892157359298`", ",", 
     RowBox[{"-", "0.0068588601138003065`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8783804052510767`", ",", "0.010677937341671715`", ",", 
     RowBox[{"-", "0.006384943887911938`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8914305323314653`", ",", "0.010192993138210529`", ",", 
     RowBox[{"-", "0.0058990079276960644`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9036859839803792`", ",", "0.009727923821692689`", ",", 
     RowBox[{"-", "0.005409372998185757`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9150744754233459`", ",", "0.009289739017446948`", ",", 
     RowBox[{"-", "0.004924184065556565`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9255486835303501`", ",", "0.008884329105197514`", ",", 
     RowBox[{"-", "0.004450977024676669`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9350865022516693`", ",", "0.008516294824155097`", ",", 
     RowBox[{"-", "0.003996319898757531`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9436896300457653`", ",", "0.008188880017536726`", ",", 
     RowBox[{"-", "0.003565561990592758`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9513807932385852`", ",", "0.00790400242575647`", ",", 
     RowBox[{"-", "0.0031627056310087644`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9582000374619726`", ",", "0.0076623659340200505`", ",", 
     RowBox[{"-", "0.0027903961562373114`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9642005606246297`", ",", "0.00746363061528017`", ",", 
     RowBox[{"-", "0.0024500106800395068`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9694445233224497`", ",", "0.007306614807217244`", ",", 
     RowBox[{"-", "0.0021418174546989537`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9739991804029097`", ",", "0.007189505598616807`", ",", 
     RowBox[{"-", "0.001865175405339749`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9779335605675394`", ",", "0.007110059008430147`", ",", 
     RowBox[{"-", "0.0016187464348736194`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9813158060103253`", ",", "0.007065777194655799`", ",", 
     RowBox[{"-", "0.0014006992287360057`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9842111889861557`", ",", "0.007054055892131951`", ",", 
     RowBox[{"-", "0.0012088904663998133`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9866807549116305`", ",", "0.007072300106697814`", ",", 
     RowBox[{"-", "0.0010410160226881169`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9887805022395276`", ",", "0.007118009541336816`", ",", 
     RowBox[{"-", "0.0008947300488685618`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9905609932164013`", ",", "0.007188837322265744`", ",", 
     RowBox[{"-", "0.000767733487289389`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9920672901196177`", ",", "0.007282626566161975`", ",", 
     RowBox[{"-", "0.0006578357171977109`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9933391222048242`", ",", "0.007397429497029675`", ",", 
     RowBox[{"-", "0.0005629939744034922`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9944112041303084`", ",", "0.0075315134826453`", ",", 
     RowBox[{"-", "0.0004813353026960882`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.995313643368852`", ",", "0.0076833577581829765`", ",", 
     RowBox[{"-", "0.00041116540975491566`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9960723898116585`", ",", "0.007851643910395995`", ",", 
     RowBox[{"-", "0.00035096816757244415`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9967096942667353`", ",", "0.008035242517752275`", ",", 
     RowBox[{"-", "0.0002993987893973242`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9972445534692436`", ",", "0.008233197738771536`", ",", 
     RowBox[{"-", "0.0002552730360166291`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9976931276246922`", ",", "0.008444711136774101`", ",", 
     RowBox[{"-", "0.00021755420751269394`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9980691227029701`", ",", "0.00866912562728854`", ",", 
     RowBox[{"-", "0.00018533918260331625`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9983841340852613`", ",", "0.008905910125770676`", ",", 
     RowBox[{"-", "0.0001578443763947643`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9986479511315349`", ",", "0.00915464524416972`", ",", 
     RowBox[{"-", "0.00013439218845097745`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9988688241355566`", ",", "0.009415010220124987`", ",", 
     RowBox[{"-", "0.00011439829182827678`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9990536962595152`", ",", "0.009686771148015458`", ",", 
     RowBox[{"-", "0.00009735995482710946`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9992084036222999`", ",", "0.009969770504471199`", ",", 
     RowBox[{"-", "0.0000828454766307871`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9993378469297091`", ",", "0.010263917912266527`", ",", 
     RowBox[{"-", "0.0000704847437846518`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999446138010757`", ",", "0.010569182057852953`", ",", 
     RowBox[{"-", "0.000059960866932425385`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9995367244543061`", ",", "0.01088558366311763`", ",", 
     RowBox[{"-", "0.000051002828795991686`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999612495288978`", ",", "0.011213189406766626`", ",", 
     RowBox[{"-", "0.000043379059301589056`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9996758703602731`", ",", "0.011552106691745159`", ",", 
     RowBox[{"-", "0.000036891847739783235`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9997288757605031`", ",", "0.011902479159969198`", ",", 
     RowBox[{"-", "0.000031372501784132614`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9997732073772815`", ",", "0.012264482862709942`", ",", 
     RowBox[{"-", "0.00002667716686019053`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9998102843552465`", ",", "0.012638323003119888`", ",", 
     RowBox[{"-", "0.000022683225196469863`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9998412940187386`", ",", "0.013024231175868373`", ",", 
     RowBox[{"-", "0.00001928620083669165`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9998672295823867`", ",", "0.013422463037186552`", ",", 
     RowBox[{"-", "0.000016397104237607606`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9998889217819179`", ",", "0.01383329634651513`", ",", 
     RowBox[{"-", "0.000013940157361047189`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999070653877479`", ",", "0.014257029328241433`", ",", 
     RowBox[{"-", "0.000011850847111679021`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999222414170627`", ",", "0.014693979308630638`", ",", 
     RowBox[{"-", "0.000010074261414379402`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999349357339197`", ",", "0.015144481588981651`", ",", 
     RowBox[{"-", "8.563668089853258`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999455546190142`", ",", "0.01560888852128929`", ",", 
     RowBox[{"-", "7.2793019517033125`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999954437798932`", ",", "0.016087568757310676`", ",", 
     RowBox[{"-", "6.187330223230964`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999618693467909`", ",", "0.016580906645965936`", ",", 
     RowBox[{"-", "5.2589704899362145`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999968086800267`", ",", "0.01708930175750717`", ",", 
     RowBox[{"-", "4.469739006807389`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999732887873503`", ",", "0.01761316851592154`", ",", 
     RowBox[{"-", "3.7988103160595122`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999776414032862`", ",", "0.018152935923648514`", ",", 
     RowBox[{"-", "3.2284718501388133`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999812835427314`", ",", "0.018709047364938527`", ",", 
     RowBox[{"-", "2.7436595441962866`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999843313579808`", ",", "0.019281960476107064`", ",", 
     RowBox[{"-", "2.3315625065881026`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999868819863297`", ",", "0.019872147072586513`", ",", 
     RowBox[{"-", "1.981286536331175`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999890166662803`", ",", "0.02048009312408452`", ",", 
     RowBox[{"-", "1.6835677700279506`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999908033427533`", ",", "0.021106298770356052`", ",", 
     RowBox[{"-", "1.4305290204403474`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999992298845083`", ",", "0.021751278371114516`", ",", 
     RowBox[{"-", "1.2154724641839486`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999935507078641`", ",", "0.022415560584471465`", ",", 
     RowBox[{"-", "1.0327032722738602`*^-6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999945986932257`", ",", "0.02309968846902481`", ",", 
     RowBox[{"-", "8.773795770023109`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999954760635222`", ",", "0.023804219605332612`", ",", 
     RowBox[{"-", "7.453848513600853`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999962106453874`", ",", "0.024529726233028373`", ",", 
     RowBox[{"-", "6.33219359454932`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999968257193751`", ",", "0.025276795400268785`", ",", 
     RowBox[{"-", "5.379078330483782`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999973407638114`", ",", "0.026046029122567982`", ",", 
     RowBox[{"-", "4.569209524576154`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999977720767647`", ",", "0.026838044548373977`", ",", 
     RowBox[{"-", "3.881085706002974`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999998133296131`", ",", "0.027653474128991433`", ",", 
     RowBox[{"-", "3.2964292618224566`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999984358345437`", ",", "0.028492965790658145`", ",", 
     RowBox[{"-", "2.799703534255516`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999986892430724`", ",", "0.029357183106747082`", ",", 
     RowBox[{"-", "2.377702184560904`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999989015153857`", ",", "0.030246805468196653`", ",", 
     RowBox[{"-", "2.0192000199573366`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999990793421432`", ",", "0.031162528250374143`", ",", 
     RowBox[{"-", "1.7146560925699196`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999992283237604`", ",", "0.03210506297465452`", ",", 
     RowBox[{"-", "1.4559612522931935`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999993531483833`", ",", "0.03307513746305349`", ",", 
     RowBox[{"-", "1.2362235038501776`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999994577407547`", ",", "0.034073495984290936`", ",", 
     RowBox[{"-", "1.0495855117016276`*^-7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999995453867502`", ",", "0.035100899389683596`", ",", 
     RowBox[{"-", "8.91069442095995`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999996188375639`", ",", "0.03615812523727399`", ",", 
     RowBox[{"-", "7.564450505347486`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999996803968734`", ",", "0.03724596790259935`", ",", 
     RowBox[{"-", "6.421175353080533`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999997319937697`", ",", "0.038365238674491174`", ",", 
     RowBox[{"-", "5.4503219752029754`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999997752437811`", ",", "0.039516765834273875`", ",", 
     RowBox[{"-", "4.625933915157874`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999998114999396`", ",", "0.04070139471670164`", ",", 
     RowBox[{"-", "3.9259562539825607`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999998418955115`", ",", "0.04191998775093662`", ",", 
     RowBox[{"-", "3.331649917566414`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.999999867379764`", ",", "0.04317342447983114`", ",", 
     RowBox[{"-", "2.827093811797874`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999998887478966`", ",", "0.0444626015557303`", ",", 
     RowBox[{"-", "2.3987616286909097`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999066660966`", ",", "0.0457884327109629`", ",", 
     RowBox[{"-", "2.035162135342142`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999216925098`", ",", "0.0471518487011365`", ",", 
     RowBox[{"-", "1.726533428826184`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999342947983`", ",", "0.048553797219298395`", ",", 
     RowBox[{"-", "1.4645830695710567`*^-8"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9999999448648387`", ",", "0.04999524277896896`", ",", 
     RowBox[{"-", "1.2422672220570087`*^-8"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7855054555263186`*^9, 3.785505497609256*^9}, 
   3.7855055283376527`*^9, 3.7855055933743987`*^9, 3.785505725730609*^9, {
   3.78550576888288*^9, 3.785505777704831*^9}, 3.7855058434971404`*^9, {
   3.7855058824288225`*^9, 
   3.7855058881335535`*^9}},ExpressionUUID->"8533cf8a-2dac-428e-b548-\
e265df55415a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{"itpseudomCI", "[", 
    RowBox[{
     FractionBox["1.", "32"], ",", 
     FractionBox["1.", "2"], ",", 
     FractionBox["1.", "2"], ",", "0", ",", "0.01"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"e22", "\[Rule]", 
       FractionBox["1", "64"]}], ",", 
      RowBox[{"t22", "\[Rule]", 
       FractionBox["2", "3"]}], ",", 
      RowBox[{"dd2", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["5", "512"]}]}]}], "}"}]}], ",", "500"}], "]"}]], "Input",
 CellChangeTimes->{{3.785505895973086*^9, 3.785505914289564*^9}, {
  3.7855059998365345`*^9, 
  3.785506007720016*^9}},ExpressionUUID->"c8643368-377a-489d-9eba-\
277580a8ae54"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000000000002`", ",", "0.9999142616056528`", ",", 
   "2.0726195622632597`*^-20"}], "}"}]], "Output",
 CellChangeTimes->{{3.785505897535184*^9, 3.7855059161415014`*^9}, {
  3.785505985586701*^9, 
  3.785506008791402*^9}},ExpressionUUID->"bd7aae84-b37f-4427-8c81-\
6b40fa850367"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.3 Equilibria with migration if at least one allele is fixed\
\>", "Section",
 CellChangeTimes->{{3.766395069335984*^9, 3.766395080019636*^9}, {
  3.766395810239232*^9, 3.7663958183590026`*^9}, {3.774698067782794*^9, 
  3.77469807078795*^9}, {3.774935357857418*^9, 3.7749353601610413`*^9}, {
  3.7752247554622974`*^9, 3.775224760780569*^9}, {3.775225001599717*^9, 
  3.775225002218364*^9}},ExpressionUUID->"dc3c6ff5-7c1b-4e02-9e13-\
9372c4ee71af"],

Cell[CellGroupData[{

Cell["\<\
3.3.1 Brief summary of results shown below (\[Alpha]1=\[Alpha]2=\[Alpha] is \
assumed):\
\>", "Subsubsection",
 CellChangeTimes->{{3.7749353730961223`*^9, 3.774935391560095*^9}, {
  3.7804038430042057`*^9, 3.7804038662302465`*^9}, {3.794815622414444*^9, 
  3.7948156264011655`*^9}},ExpressionUUID->"87476763-94ef-4b34-87d3-\
cbbc3ba42c7a"],

Cell[BoxData[
 RowBox[{"1.", " ", "The", " ", "following", " ", "equilibria", " ", "may", 
  " ", 
  RowBox[{"exist", ":"}]}]], "Text",
 CellChangeTimes->{{3.7749354906682277`*^9, 3.774935542648873*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"849d7b1e-83e4-4315-80e8-e52cda3b26ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equ00", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t22", "\[Rule]", "0"}], ",", 
      RowBox[{"e22", "\[Rule]", "0"}], ",", 
      RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
    RowBox[{"(", 
     RowBox[{
     "fixation", " ", "of", " ", "the", " ", "continental", " ", "type", " ", 
      "T1E1"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"equ1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t22", "\[Rule]", "0"}], ",", 
      RowBox[{"e22", "->", 
       FractionBox[
        RowBox[{
         RowBox[{"s", 
          RowBox[{"(", 
           RowBox[{"1", "-", "m"}], ")"}]}], "-", "m"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", "s"}]]}], ",", 
      RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loss", " ", "of", " ", "T2", " ", "and", " ", "migration"}], 
      "-", 
      RowBox[{
      "selection", " ", "balance", " ", "at", " ", "the", " ", "ecological", 
       " ", "locus", " ", "E"}]}], ")"}]}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"equ2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t22", "\[Rule]", 
       FractionBox[
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "m"}], ")"}], " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", 
           RowBox[{"3", "/", "2"}]]}], "-", 
         SqrtBox[
          RowBox[{"\[Alpha]", "-", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"9", " ", "\[Alpha]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"33", " ", "\[Alpha]"}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m", "-", 
           RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
      RowBox[{"e22", "\[Rule]", "0"}], ",", 
      RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"loss", " ", "of", " ", "E2", " ", "and", " ", "migration"}], 
      "-", 
      RowBox[{
      "sexual", " ", "selection", " ", "balance", " ", "at", " ", "T"}]}], 
     ")"}]}]}], ",", 
  RowBox[{"equ3", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"t22", "\[Rule]", 
       FractionBox[
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "m"}], ")"}], " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", 
           RowBox[{"3", "/", "2"}]]}], "+", 
         SqrtBox[
          RowBox[{"\[Alpha]", "-", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"9", " ", "\[Alpha]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"33", " ", "\[Alpha]"}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m", "-", 
           RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
      RowBox[{"e22", "->", "0"}], ",", 
      RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"loss", " ", "of", " ", "E2", " ", "and", " ", "migration"}], 
       "-", 
       RowBox[{
       "sexual", " ", "selection", " ", "balance", " ", "at", " ", "T"}]}], 
      ")"}], "."}]}]}]}]], "Text",
 CellChangeTimes->{
  3.774935549692865*^9, {3.7749355847034793`*^9, 3.7749357346158123`*^9}, {
   3.774935820948448*^9, 3.7749358450633855`*^9}, {3.7749359645363226`*^9, 
   3.7749359679707537`*^9}, {3.7804036283700533`*^9, 
   3.7804036374874997`*^9}, {3.7948079334097323`*^9, 3.7948079483260202`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"0ce16f26-7917-4d47-8536-312db0a6026f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2.", " ", "equ00", " ", "exists", " ", 
    RowBox[{"always", ".", " ", "It"}], " ", "is", " ", "locally", " ", 
    RowBox[{"(", "asymptotically", ")"}], " ", "stable", " ", "if", " ", 
    "m"}], ">", 
   RowBox[{
    FractionBox["s", 
     RowBox[{"1", "+", "s"}]], ".", " ", "Otherwise"}]}], ",", " ", 
  RowBox[{"it", " ", "is", " ", "a", " ", "saddle", " ", 
   RowBox[{"point", "."}]}]}]], "Text",
 CellChangeTimes->{{3.774935851451875*^9, 3.7749358790652976`*^9}, {
  3.7749363840887165`*^9, 3.7749364043089447`*^9}, {3.7804036583837843`*^9, 
  3.7804036609921846`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"eeb55744-12d0-4cd9-a77d-95d902ec431e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3.", " ", "equ1", " ", "exists", " ", "if", " ", "s"}], ">", 
   RowBox[{
    FractionBox["m", 
     RowBox[{"1", "-", "m"}]], " ", "or"}]}], ",", " ", "equivalently", ",", 
  RowBox[{
   RowBox[{"if", "  ", "m"}], "<", 
   FractionBox["s", 
    RowBox[{"1", "+", "s"}]]}], ",", " ", "\[IndentingNewLine]", 
  RowBox[{"i", ".", "e", "."}], ",", " ", 
  RowBox[{"if", " ", 
   RowBox[{"(", "ecological", ")"}], "selection", " ", "is", " ", 
   "sufficiently", " ", "strong", " ", "relative", " ", "to", " ", 
   RowBox[{"migration", ".", " ", "In"}], " ", "this", " ", "case"}], ",", 
  " ", 
  RowBox[{"it", " ", "also", " ", "locally", " ", 
   RowBox[{"(", "asymptotically", ")"}], 
   RowBox[{"stable", "."}]}]}]], "Text",
 CellChangeTimes->{{3.7749358545800705`*^9, 3.7749358568376627`*^9}, {
   3.7749359217352533`*^9, 3.7749359969480925`*^9}, {3.7749360674642677`*^9, 
   3.7749360823437443`*^9}, {3.7749365102407207`*^9, 3.77493651053093*^9}, 
   3.7749366118243303`*^9},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"2447fc5f-8aef-4a87-a8ab-3662ebaddc9b"],

Cell[BoxData[{
 RowBox[{"4.", " ", "The", " ", "equilibria", " ", "equ2", " ", "and", " ", 
  "equ3", " ", "exist", " ", "if", " ", "and", " ", "only", " ", 
  "if"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"0", " ", "\[LessEqual]", "m", "<", "mcrit"}], "=", 
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
      RowBox[{"4", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}]]}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"which", " ", "requires"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", " ", 
     RowBox[{"N", "[", 
      RowBox[{"mcrit", "/.", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", "\[Rule]", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"54", "-", 
               RowBox[{"6", " ", 
                SqrtBox["33"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 SqrtBox["33"]}], ")"}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}]}], "]"}]}], "=", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"0.0326211", ".", "\[IndentingNewLine]", "For"}], " ", "given", 
      " ", "m"}], "<", "mcrit"}]}], ",", " ", 
   RowBox[{"there", " ", "is", " ", "an", " ", 
    RowBox[{"interval", " ", "[", 
     RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "]"}], " ", "for", " ", "which",
     " ", "the", " ", "equilibria", " ", "exist", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"obtained", " ", "by", " ", "solving", " ", "m"}], "=", 
       RowBox[{"mcrit", " ", "for", " ", "alpha"}]}], ")"}], ".", " ", 
     "This"}], " ", "interval", " ", "contains"}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"\[Alpha]_crit", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"54", "-", 
         RowBox[{"6", " ", 
          SqrtBox["33"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"6", " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SqrtBox["33"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}]}], "=", 
   RowBox[{"2.38298", "."}]}]}]}], "Text",
 CellChangeTimes->{{3.774935887075906*^9, 3.7749358883457956`*^9}, {
  3.774936641004016*^9, 3.7749366702547507`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"a24aa9ba-c9b9-44ff-9a06-507af653ee7f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "5.", " ", "The", " ", "equilibrium", " ", "equ2", " ", "is", " ", "always",
    " ", 
   RowBox[{"unstable", ".", " ", "\[IndentingNewLine]", "The"}], " ", 
   "equilibrium", " ", "equ3", " ", "is", " ", "locally", " ", "stable", " ", 
   "if", " ", "it", " ", "is", " ", "admissible", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
     "which", " ", "is", " ", "the", " ", "case", " ", "if", " ", "m"}], "<", 
     "mcrit"}], ")"}], " ", "and", " ", "if"}], ",", "approximately", ",", 
  RowBox[{
   FormBox[
    FractionBox["s", "m"],
    TraditionalForm], "<", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}]], ".", " ", 
     "\[IndentingNewLine]", "Not"}], " ", "surprisingly"}]}], ",", 
  RowBox[{"weak", " ", "selection", " ", 
   RowBox[{"(", 
    RowBox[{"relative", " ", "to", " ", "migration"}], ")"}], " ", "is", " ", 
   "necessary", " ", "for", " ", "the", " ", "stability", " ", "of", " ", 
   "this", " ", 
   RowBox[{"equilibrium", ".", "\[IndentingNewLine]", "In"}], " ", 
   "addition"}], ",", 
  RowBox[{
  "larger", " ", "r", " ", "facilitates", " ", "stability", " ", "of", " ", 
   RowBox[{"equ3", "."}]}]}]], "Text",
 CellChangeTimes->{{3.774936760017382*^9, 3.774936828624016*^9}, {
  3.774936864643546*^9, 3.7749369421436653`*^9}, {3.774937000098763*^9, 
  3.774937009328291*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"2b34f266-65d0-4a2f-8772-89349bc01564"],

Cell["\<\
6. Fully polymorphic equilibria could not be determined explicitly.  If \
selection is sufficiently strong relative to migration, then the numerical \
work shows that a unique stable equilibrium exists, where t22 is relatively \
close to the value of equ3 (and, of course, e22 > 0).\
\>", "Text",
 CellChangeTimes->{{3.774936934776262*^9, 3.7749369792099466`*^9}, {
  3.7749370161991673`*^9, 3.774937117886834*^9}, {3.7804037200194187`*^9, 
  3.7804037201313705`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"8ee33d17-baf3-47d5-a155-216cd6b996e7"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3.2 Simplify recursion", "Subsubsection",
 CellChangeTimes->{{3.7749354174357796`*^9, 3.7749354247289076`*^9}, {
   3.775225010234677*^9, 3.7752250123824234`*^9}, 
   3.7948156495258904`*^9},ExpressionUUID->"71c332f8-db8a-42cf-8ed6-\
452cba9d7761"],

Cell["\<\
We assume \[Alpha]1 = \[Alpha]2 = \[Alpha]. If one allele is fixed, then D = \
0. Equilibria must be the zeros of the following expression, which we will \
call deltasymCID0:\
\>", "Text",
 CellChangeTimes->{{3.774698171268824*^9, 3.774698221995125*^9}, {
  3.774698514445405*^9, 
  3.7746985522567015`*^9}},ExpressionUUID->"32c3b317-d386-4f9d-9314-\
5448afd03a89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], "-", 
       RowBox[{"{", 
        RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}]}], ")"}], "/.", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.740289470540201*^9, 3.7402894871720963`*^9}, {
  3.74028951729615*^9, 3.7402895352526646`*^9}, {3.740289602719573*^9, 
  3.7402896088298235`*^9}, {3.7663909909733973`*^9, 3.7663910025946555`*^9}, {
  3.774698260748856*^9, 3.774698273173749*^9}, {3.7746983702642236`*^9, 
  3.774698372966178*^9}, {3.774698456152336*^9, 
  3.7746984813755455`*^9}},ExpressionUUID->"00cac470-952d-4bbd-ab38-\
feacbabb66de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"e22", " ", "s"}]}], ")"}], "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "t22"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"6", " ", "t22"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["t22", "2"]}], "+", 
            RowBox[{"3", " ", "e22", " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"3", " ", "t22"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}]}]}], ")"}], " ", 
          "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"3", " ", "t22"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"t22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "e22", " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "-", 
               RowBox[{"6", " ", "t22"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["m", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["e22", "3"], " ", 
          SuperscriptBox["s", "3"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"3", " ", "t22"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
         RowBox[{"e22", " ", "s", " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "-", 
               RowBox[{"6", " ", "t22"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "e22"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "s", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "t22", "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "e22", " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "+", "t22", "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"2", "-", "e22", "-", 
               RowBox[{"3", " ", "t22"}], "+", 
               RowBox[{"2", " ", "e22", " ", "t22"}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["m", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["e22", "3"], " ", 
          SuperscriptBox["s", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{"e22", " ", "s", " ", "t22", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "\[Alpha]"}], "-", 
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
            RowBox[{"s", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]", "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"s", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
                SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["m", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["e22", "3"], " ", 
          SuperscriptBox["s", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{"t22", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s", "+", 
            RowBox[{"2", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "s", " ", "\[Alpha]"}], "-", 
            RowBox[{"4", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
            RowBox[{"2", " ", "s", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"3", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "e22", " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "+", "t22", "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"s", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "+", "t22", "-", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
               "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "-", 
                  RowBox[{"3", " ", "t22"}]}], ")"}], " ", "t22", " ", 
                SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"3", " ", "s", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
                SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "e22"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}], " ", "t22", " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"6", " ", "\[Alpha]"}], "+", 
      RowBox[{"8", " ", "t22", " ", "\[Alpha]"}], "-", 
      RowBox[{"8", " ", "m", " ", "t22", " ", "\[Alpha]"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "+", 
      RowBox[{"16", " ", "m", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"15", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"15", " ", "m", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"11", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"22", " ", "m", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"11", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"24", " ", "m", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "4"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"6", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"6", " ", "m", " ", "t22", " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"4", " ", "m", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"48", " ", "m", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"32", " ", "m", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"48", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "-", 
      RowBox[{"32", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "4"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "-", 
      RowBox[{"8", " ", "m", " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"24", " ", "m", " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "3"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "-", 
      RowBox[{"16", " ", "m", " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["m", "4"], " ", 
       SuperscriptBox["t22", "4"], " ", 
       SuperscriptBox["\[Alpha]", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["e22", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], "4"], " ", 
       SuperscriptBox["s", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6", "+", 
            RowBox[{"8", " ", "t22"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"15", " ", "t22"}], "-", 
            RowBox[{"11", " ", 
             SuperscriptBox["t22", "2"]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["t22", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"2", " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "t22", "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["t22", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
          SuperscriptBox["t22", "2"], " ", 
          SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["e22", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], "3"], " ", 
       SuperscriptBox["s", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "16"}], "-", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{"3", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "m"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "8"}], "+", 
            RowBox[{"15", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "m"}], ")"}], " ", "t22"}], "-", 
            RowBox[{"22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
             SuperscriptBox["t22", "2"]}], "-", 
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", "m"}]}], ")"}], " ", 
             SuperscriptBox["t22", "3"]}], "+", 
            RowBox[{"16", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
             SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"2", " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", "t22", "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}]}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "t22"}], "-", 
               RowBox[{"24", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"16", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "3"]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
          SuperscriptBox["t22", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"2", " ", "t22"}], "+", 
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
       SuperscriptBox["s", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"24", "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"6", "-", 
               RowBox[{"6", " ", "m"}], "+", 
               SuperscriptBox["m", "2"]}], ")"}], " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"12", "-", 
            RowBox[{"45", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t22"}], "-", 
            RowBox[{"11", " ", 
             RowBox[{"(", 
              RowBox[{"6", "-", 
               RowBox[{"6", " ", "m"}], "+", 
               SuperscriptBox["m", "2"]}], ")"}], " ", 
             SuperscriptBox["t22", "2"]}], "-", 
            RowBox[{"24", " ", 
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"3", " ", "m"}], "+", 
               SuperscriptBox["m", "2"]}], ")"}], " ", 
             SuperscriptBox["t22", "3"]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
             SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"2", " ", "t22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["m", "2"], " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"24", " ", "t22"}], "+", 
               RowBox[{"24", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", "t22", "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}]}], "-", 
            RowBox[{"3", " ", "m", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{"2", " ", "t22"}], "-", 
               RowBox[{"24", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"16", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["t22", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"]}], "-", 
            RowBox[{"6", " ", "m", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"3", " ", "t22"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["m", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"6", " ", "t22"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]}], ")"}], "2"],
        " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "\[Alpha]", "-", 
         RowBox[{"t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"m", " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["t22", "2"], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["t22", "2"], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["m", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
          SuperscriptBox["s", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"2", " ", "\[Alpha]"}], "+", 
            RowBox[{"t22", " ", 
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"2", " ", "t22"}], "+", 
               RowBox[{"m", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"2", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"e22", " ", "s", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["m", "4"], " ", 
          SuperscriptBox["t22", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["m", "3"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "8"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "11"}], "-", 
               RowBox[{"28", " ", "t22"}], "+", 
               RowBox[{"32", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "-", 
               RowBox[{"56", " ", "t22"}], "+", 
               RowBox[{"64", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"7", " ", "t22"}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"6", "+", 
               RowBox[{"8", " ", "t22"}], "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"2", "+", 
               RowBox[{"15", " ", "t22"}], "-", 
               RowBox[{"11", " ", 
                SuperscriptBox["t22", "2"]}], "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "3"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", "t22", "-", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
             SuperscriptBox["t22", "2"], " ", 
             SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "-", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"16", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"24", "+", 
               RowBox[{"56", " ", "t22"}], "-", 
               RowBox[{"80", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"105", " ", "t22"}], "-", 
               RowBox[{"110", " ", 
                SuperscriptBox["t22", "2"]}], "-", 
               RowBox[{"104", " ", 
                SuperscriptBox["t22", "3"]}], "+", 
               RowBox[{"64", " ", 
                SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"2", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{"21", "+", 
               RowBox[{"10", " ", "t22"}], "-", 
               RowBox[{"104", " ", 
                SuperscriptBox["t22", "2"]}], "+", 
               RowBox[{"64", " ", 
                SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "3"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["t22", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"5", "-", 
               RowBox[{"13", " ", "t22"}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["m", "2"], " ", "t22", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "120"}], " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["t22", "3"], " ", "\[Alpha]", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"15", " ", "\[Alpha]"}], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
            RowBox[{"8", " ", "t22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "-", 
               RowBox[{"11", " ", "\[Alpha]"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["\[Alpha]", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.740289576238056*^9, 3.7402896501974096`*^9, 
  3.7663910043929358`*^9, 3.7746982907893505`*^9, 3.7746983768729506`*^9, 
  3.774698484588869*^9},ExpressionUUID->"ed66210d-5b56-426c-a642-\
8400aa8cd952"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"deltasymCID0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"e22", " ", "s"}]}], ")"}], "3"]}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"3", " ", "t22"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
        RowBox[{"m", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"e22", " ", "s"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"6", " ", "t22"}], "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["t22", "2"]}], "+", 
              RowBox[{"3", " ", "e22", " ", "s", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"3", " ", "t22"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}]}]}], ")"}], " ", 
            "\[Alpha]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"e22", " ", "s"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["e22", "2"], " ", 
            SuperscriptBox["s", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"3", " ", "t22"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{"t22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "e22", " ", "s", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 RowBox[{"6", " ", "t22"}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["m", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["e22", "3"], " ", 
            SuperscriptBox["s", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"3", " ", "t22"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
           RowBox[{"e22", " ", "s", " ", "t22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["e22", "2"], " ", 
            SuperscriptBox["s", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 RowBox[{"6", " ", "t22"}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"e22", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["m", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
        RowBox[{"s", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"2", " ", "\[Alpha]"}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["e22", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "3"], " ", 
         SuperscriptBox["s", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"m", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", "t22", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"s", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "+", "t22", "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{"2", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{"3", " ", "t22"}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", "t22", " ", "\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "\[Alpha]"}], "+", 
           RowBox[{"4", " ", "t22", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
           RowBox[{"s", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"2", " ", "\[Alpha]"}], "+", 
              RowBox[{"t22", " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"6", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{"e22", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "s"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", "t22", " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", 
              RowBox[{"2", " ", "\[Alpha]"}], "+", 
              RowBox[{"2", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
              RowBox[{"s", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "+", "t22", "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{"2", " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"s", " ", 
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"4", "+", "t22", "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
                 "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"3", "-", 
                    RowBox[{"4", " ", "t22"}]}], ")"}], " ", "t22", " ", 
                  SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["e22", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
         SuperscriptBox["s", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "s"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]", "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"s", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
                  SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "e22"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}], " ", "t22", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"6", " ", "\[Alpha]"}], "+", 
        RowBox[{"8", " ", "t22", " ", "\[Alpha]"}], "-", 
        RowBox[{"8", " ", "m", " ", "t22", " ", "\[Alpha]"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"15", " ", "t22", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"15", " ", "m", " ", "t22", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"11", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"22", " ", "m", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"11", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"24", " ", "m", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"24", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"6", " ", "t22", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"6", " ", "m", " ", "t22", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"4", " ", "m", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"48", " ", "m", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"32", " ", "m", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"8", " ", "m", " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"24", " ", "m", " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"24", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["t22", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["e22", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "4"], " ", 
         SuperscriptBox["s", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"6", "+", 
              RowBox[{"8", " ", "t22"}], "-", 
              RowBox[{"8", " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"15", " ", "t22"}], "-", 
              RowBox[{"11", " ", 
               SuperscriptBox["t22", "2"]}], "-", 
              RowBox[{"8", " ", 
               SuperscriptBox["t22", "3"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"2", " ", "t22", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", "t22", "-", 
              RowBox[{"8", " ", 
               SuperscriptBox["t22", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
            SuperscriptBox["t22", "2"], " ", 
            SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["e22", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "3"], " ", 
         SuperscriptBox["s", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "16"}], "-", 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{"3", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "m"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{"15", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", "m"}], ")"}], " ", "t22"}], "-", 
              RowBox[{"22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
               SuperscriptBox["t22", "2"]}], "-", 
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "4"}], "+", 
                 RowBox[{"3", " ", "m"}]}], ")"}], " ", 
               SuperscriptBox["t22", "3"]}], "+", 
              RowBox[{"16", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
               SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"2", " ", "t22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "4"}], " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", "t22", "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}]}], "+", 
              RowBox[{"m", " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "t22"}], "-", 
                 RowBox[{"24", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"16", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
            SuperscriptBox["t22", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"2", "-", 
              RowBox[{"2", " ", "t22"}], "+", 
              RowBox[{"m", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"2", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["e22", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
         SuperscriptBox["s", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "9"}], "+", 
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"6", "-", 
                 RowBox[{"6", " ", "m"}], "+", 
                 SuperscriptBox["m", "2"]}], ")"}], " ", 
               SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"12", "-", 
              RowBox[{"45", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t22"}], "-", 
              RowBox[{"11", " ", 
               RowBox[{"(", 
                RowBox[{"6", "-", 
                 RowBox[{"6", " ", "m"}], "+", 
                 SuperscriptBox["m", "2"]}], ")"}], " ", 
               SuperscriptBox["t22", "2"]}], "-", 
              RowBox[{"24", " ", 
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"3", " ", "m"}], "+", 
                 SuperscriptBox["m", "2"]}], ")"}], " ", 
               SuperscriptBox["t22", "3"]}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
               SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"2", " ", "t22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["m", "2"], " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"24", " ", "t22"}], "+", 
                 RowBox[{"24", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}]}], "+", 
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", "t22", "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}]}], "-", 
              RowBox[{"3", " ", "m", " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", 
                 RowBox[{"2", " ", "t22"}], "-", 
                 RowBox[{"24", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"16", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["t22", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"6", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"]}], "-", 
              RowBox[{"6", " ", "m", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"3", " ", "t22"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["m", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"6", " ", "t22"}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]}], ")"}], 
          "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "\[Alpha]", "-", 
           RowBox[{"t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"m", " ", "t22", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["t22", "2"], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "-", 
           RowBox[{"2", " ", "m", " ", 
            SuperscriptBox["t22", "2"], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            SuperscriptBox["t22", "2"], " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["e22", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
            SuperscriptBox["s", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", 
              RowBox[{"2", " ", "\[Alpha]"}], "+", 
              RowBox[{"t22", " ", 
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"2", " ", "t22"}], "+", 
                 RowBox[{"m", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"e22", " ", "s", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["m", "4"], " ", 
            SuperscriptBox["t22", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "t22"}]}], ")"}], " ", 
            SuperscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["m", "3"], " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "11"}], "-", 
                 RowBox[{"28", " ", "t22"}], "+", 
                 RowBox[{"32", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{"56", " ", "t22"}], "+", 
                 RowBox[{"64", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"7", " ", "t22"}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"6", "+", 
                 RowBox[{"8", " ", "t22"}], "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"15", " ", "t22"}], "-", 
                 RowBox[{"11", " ", 
                  SuperscriptBox["t22", "2"]}], "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "3"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"2", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"3", "+", "t22", "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "3"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], "2"], " ", 
               SuperscriptBox["t22", "2"], " ", 
               SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "-", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"24", "+", 
                 RowBox[{"56", " ", "t22"}], "-", 
                 RowBox[{"80", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 RowBox[{"105", " ", "t22"}], "-", 
                 RowBox[{"110", " ", 
                  SuperscriptBox["t22", "2"]}], "-", 
                 RowBox[{"104", " ", 
                  SuperscriptBox["t22", "3"]}], "+", 
                 RowBox[{"64", " ", 
                  SuperscriptBox["t22", "4"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"2", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{"21", "+", 
                 RowBox[{"10", " ", "t22"}], "-", 
                 RowBox[{"104", " ", 
                  SuperscriptBox["t22", "2"]}], "+", 
                 RowBox[{"64", " ", 
                  SuperscriptBox["t22", "3"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "3"]}], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["t22", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"5", "-", 
                 RowBox[{"13", " ", "t22"}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["t22", "2"]}]}], ")"}], " ", 
               SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", "t22", " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "120"}], " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "+", 
              RowBox[{"96", " ", 
               SuperscriptBox["t22", "3"], " ", "\[Alpha]", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"]}], "+", 
              RowBox[{"3", " ", 
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 RowBox[{"15", " ", "\[Alpha]"}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
              RowBox[{"8", " ", "t22", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "8"}], "-", 
                 RowBox[{"11", " ", "\[Alpha]"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["\[Alpha]", "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], ")"}]}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.740290088680867*^9, 3.74029009917931*^9}, {
  3.740290138325017*^9, 3.7402901442771945`*^9}, {3.766391023566563*^9, 
  3.7663910462837143`*^9}},ExpressionUUID->"e68b2dd0-7427-46c0-abd9-\
1871804d5537"],

Cell["\<\
Clearly, with migration (m>0), e22 and t22 can never be fixed.\
\>", "Text",
 CellChangeTimes->{{3.7746979581203012`*^9, 3.7746979887842426`*^9}, {
  3.774698028746848*^9, 
  3.7746980311305447`*^9}},ExpressionUUID->"0cee3608-e7f6-4e49-9a9b-\
6156c3c70b36"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3.3 Equilibria with t22 = 0", "Subsubsection",
 CellChangeTimes->{{3.7669000715181527`*^9, 3.766900085034814*^9}, {
   3.7752250153492756`*^9, 3.7752250169505672`*^9}, 
   3.794815651513749*^9},ExpressionUUID->"47d396c7-fdb0-477e-8092-\
2b78a18ec549"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"deltasymCID0", "/.", 
   RowBox[{"t22", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.76639508573974*^9, 
  3.7663951051326575`*^9}},ExpressionUUID->"f8bbb677-cb3b-4b66-bd4a-\
2e4e03c828d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"2", " ", "e22", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"e22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]}], ")"}], "2"], 
    " ", 
    RowBox[{"(", 
     RowBox[{"s", "-", 
      RowBox[{"e22", " ", "s"}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "e22"}], ")"}], " ", "s"}]}], ")"}]}]}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.766395105922222*^9},ExpressionUUID->"666b8826-c8d8-4dfb-85eb-\
12902e008e0e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "\[Equal]", "0"}], ",", "e22"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663951110949354`*^9, 
  3.766395126398918*^9}},ExpressionUUID->"bdef4073-0901-4043-bb90-\
5e3290fbfd5b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e22", "\[Rule]", 
     FractionBox[
      RowBox[{"m", "-", "s", "+", 
       RowBox[{"m", " ", "s"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.766395129177909*^9},ExpressionUUID->"066308a1-1a00-444a-9c54-\
0224df6e431c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"0", "<", 
     FractionBox[
      RowBox[{"m", "-", "s", "+", 
       RowBox[{"m", " ", "s"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s"}]], "<", "1"}], 
    "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "<", "m", "<", "1"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766395165188766*^9, 
  3.76639523802081*^9}},ExpressionUUID->"7e96b4d7-8fcf-47d0-a8c2-\
13fc1bb9c271"],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "+", 
   RowBox[{"m", " ", "s"}]}], "<", "s"}]], "Output",
 CellChangeTimes->{{3.766395206251213*^9, 
  3.7663952389824944`*^9}},ExpressionUUID->"e08ec05f-1d2f-4021-8252-\
a5a8081c6acf"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
   "The", " ", "following", " ", "is", " ", "an", " ", "equilibrium", " ", 
    "if", " ", "s"}], ">", 
   RowBox[{
    FractionBox["m", 
     RowBox[{"1", "-", "m"}]], " ", "or"}]}], ",", " ", "equivalently", ",", 
  " ", 
  RowBox[{
   RowBox[{"m", "<", 
    FractionBox["s", 
     RowBox[{"1", "+", "s"}]]}], ":"}]}]], "Text",
 CellChangeTimes->{{3.76639556018717*^9, 3.7663956107694654`*^9}, {
  3.769242794690155*^9, 3.769242797875458*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"117b3766-684c-44ef-9b66-594789fefce4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equ1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "->", 
      FractionBox[
       RowBox[{
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}]}], "-", "m"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], " ", "s"}]]}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.766395266794279*^9, 3.7663952793131647`*^9}, {
  3.7663953471613955`*^9, 3.7663953529695225`*^9}, {3.766395384898218*^9, 
  3.7663953997477727`*^9}},ExpressionUUID->"5a3dce7b-f9ae-4282-955c-\
2f170bfb993c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"deltasymCID0", "/.", "equ1"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663956182568407`*^9, 
  3.766395632605133*^9}},ExpressionUUID->"96414444-1454-4b1a-bcc9-\
8111e9cf2075"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7663956352009954`*^9},ExpressionUUID->"a31c95a3-3fec-47c9-895e-\
5d137ca46837"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.3.4 Equilibria with e22 = 0
(This case reduces to the phenotype matching model with no viability \
selection studied in Appendix S1 in Servedio and B\[UDoubleDot]rger 2015).\
\>", "Subsubsection",
 CellChangeTimes->{{3.7669000423591948`*^9, 3.766900062453063*^9}, {
   3.7749613650609636`*^9, 3.7749614857790623`*^9}, {3.775225019024046*^9, 
   3.7752250206925135`*^9}, 3.7754552803517675`*^9, {3.794814183566141*^9, 
   3.794814187391944*^9}, 
   3.7948156538454027`*^9},ExpressionUUID->"25057a0d-8cec-40ac-bdc9-\
d8f31be294d2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"deltasymCID0", "/.", 
   RowBox[{"e22", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.76639508573974*^9, 3.7663951051326575`*^9}, 
   3.766395833708913*^9},ExpressionUUID->"a22cdec4-277d-40bf-8a5a-\
d794972fcf48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "t22"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["m", "2"], " ", "t22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"6", " ", "t22"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], ",", "0", 
   ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.766395105922222*^9, 
  3.7663958346505995`*^9},ExpressionUUID->"6f058b07-6cab-44ec-a0e5-\
2d8ff02c621f"]
}, Closed]],

Cell["The following gives three potential equilibria if e22 = 0:", "Text",
 CellChangeTimes->{{3.774615346681667*^9, 3.7746153629650097`*^9}, {
  3.7746155969190483`*^9, 
  3.7746156016813745`*^9}},ExpressionUUID->"498fa26b-928d-4720-ac4e-\
9029fe215cf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "\[Equal]", "0"}], ",", "t22"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663951110949354`*^9, 3.766395126398918*^9}, 
   3.7663958462758474`*^9},ExpressionUUID->"d812c974-022c-49fb-81ba-\
da10b84718b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t22", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t22", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox["\[Alpha]", 
         RowBox[{"3", "/", "2"}]]}], "-", 
       SqrtBox[
        RowBox[{"\[Alpha]", "-", 
         RowBox[{"2", " ", "m", " ", 
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"9", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"16", "+", 
            RowBox[{"33", " ", "\[Alpha]"}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       SqrtBox["\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m", "+", 
         RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t22", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"]}], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox["\[Alpha]", 
         RowBox[{"3", "/", "2"}]]}], "+", 
       SqrtBox[
        RowBox[{"\[Alpha]", "-", 
         RowBox[{"2", " ", "m", " ", 
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"9", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["m", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"16", "+", 
            RowBox[{"33", " ", "\[Alpha]"}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       SqrtBox["\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m", "+", 
         RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.766395129177909*^9, 
  3.7663958483663344`*^9},ExpressionUUID->"b6f2a106-5fe2-4e74-8e62-\
2af28e27cfdc"]
}, Closed]],

Cell["Therefore, there may exist the three equilibria", "Text",
 CellChangeTimes->{{3.7664122923907995`*^9, 3.766412305664324*^9}, 
   3.766412367991047*^9, {3.766413187617178*^9, 3.7664131884657974`*^9}, {
   3.774615609428814*^9, 
   3.7746156126180587`*^9}},ExpressionUUID->"cb39ac7e-219f-4b67-902e-\
74a0d84df11f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equ00", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";", 
  RowBox[{"equ2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "m"}], ")"}], " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", 
           RowBox[{"3", "/", "2"}]]}], "-", 
         SqrtBox[
          RowBox[{"\[Alpha]", "-", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"9", " ", "\[Alpha]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"33", " ", "\[Alpha]"}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m", "-", 
           RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}], ")"}]}]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";", 
  RowBox[{"equ3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "m"}], ")"}], " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", 
           RowBox[{"3", "/", "2"}]]}], "+", 
         SqrtBox[
          RowBox[{"\[Alpha]", "-", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"9", " ", "\[Alpha]"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"16", "+", 
              RowBox[{"33", " ", "\[Alpha]"}], "+", 
              RowBox[{"20", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m", "-", 
           RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}], ")"}]}]}], ",", 
     RowBox[{"e22", "->", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.766412310166554*^9, 3.766412355588149*^9}, {
   3.7664133560190134`*^9, 3.766413356126107*^9}, 3.76641367399218*^9, {
   3.7692459696811132`*^9, 3.7692460025056405`*^9}, {3.7746156151748524`*^9, 
   3.7746156383461714`*^9}, 
   3.7746164005187445`*^9},ExpressionUUID->"d812b3ac-a810-4bab-951e-\
1a46ed45b657"],

Cell[TextData[{
 "Clearly, equ0 exists always and equ3 \[GreaterEqual] equ2. In Appendix S1 \
of Servedio and B\[UDoubleDot]rger (2015), the equilibria equ2 and equ3 were \
denoted by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["t", "^"], 
    RowBox[{"2", ",", "2"}]], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "5d09385f-1ffb-417e-a0ce-b06053c727b7"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["t", "^"], 
    RowBox[{"2", ",", "3"}]], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "ce42a243-797d-4227-94d1-a5b9d33626e3"],
 ", respectively."
}], "Text",
 CellChangeTimes->{{3.7746156584833007`*^9, 3.774615675348159*^9}, {
  3.774698620011611*^9, 3.774698636112234*^9}, {3.774961774326597*^9, 
  3.7749619085225477`*^9}},ExpressionUUID->"1d7fb2af-04d6-40dc-b210-\
267573daaf56"],

Cell["\<\
Next we investigate admissibility of equ2 and equ3. Therefore, we study the \
polynomial that yields them as its zeros:\
\>", "Text",
 CellChangeTimes->{{3.7746156775547094`*^9, 
  3.7746157454134283`*^9}},ExpressionUUID->"581c988d-718a-4795-80cf-\
72cdda6b2447"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "t22"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m", "3"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["m", "2"], " ", "t22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"6", " ", "t22"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.766395165188766*^9, 3.76639523802081*^9}, {
  3.7663959236618557`*^9, 
  3.766395934480546*^9}},ExpressionUUID->"dd3a5130-cb8c-4266-bf8d-\
6f9bc04f3768"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Alpha]"}], "-", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}], " ", "t22"}], 
   "+", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m", "+", 
      RowBox[{"m", " ", "\[Alpha]"}]}], ")"}], " ", 
    SuperscriptBox["t22", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t22", "]"}], "3"],
    SeriesData[$CellContext`t22, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`t22, 
   0, {-$CellContext`\[Alpha] - $CellContext`m (
     2 + $CellContext`\[Alpha]), (-1 + $CellContext`m) $CellContext`\[Alpha] \
(-3 + $CellContext`m (3 + 2 $CellContext`\[Alpha])), 
    2 (-1 + $CellContext`m)^2 $CellContext`\[Alpha] (-1 + $CellContext`m + \
$CellContext`m $CellContext`\[Alpha])}, 0, 3, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.766395206251213*^9, 3.7663952389824944`*^9}, 
   3.766395936670102*^9},ExpressionUUID->"a13662aa-dc67-4594-a092-\
9615dbee995d"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "The", " ", "leading", " ", "coefficient", " ", "is", " ", "negative", " ", 
   "if", " ", "and", " ", "only", " ", "if", " ", "\[Alpha]"}], "<", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", "m"}], "m"], "."}]}]], "Text",
 CellChangeTimes->{{3.7663960463720846`*^9, 
  3.7663960908026743`*^9}},ExpressionUUID->"afb1570f-88c1-4d5c-8a8d-\
731e4512f2c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", "t22"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["m", "3"], " ", 
      SuperscriptBox["t22", "2"], " ", "\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", "t22", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"6", " ", "t22"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["t22", "2"]}]}], ")"}], " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "t22", " ", 
         SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], "/.", 
   RowBox[{"t22", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7663959970880513`*^9, 
  3.7663960055670795`*^9}},ExpressionUUID->"f79424a9-63a6-4c16-8f93-\
4ad714a9ab6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[Alpha]"}], "-", 
  RowBox[{"m", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.7663960063616433`*^9},ExpressionUUID->"4e43b87c-476b-4b8b-9c76-\
4d5b782ec5da"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"This", " ", "is", " ", "always", " ", 
   RowBox[{"negative", ".", "\[IndentingNewLine]", "Therefore"}]}], ",", " ", 
  RowBox[{
   RowBox[{
   "there", " ", "is", " ", "exactly", " ", "one", " ", "positive", " ", 
    "solution", " ", "if", " ", "\[Alpha]"}], ">", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", "m"}], "m"], ".", " ", "Otherwise"}]}], ",", " ", 
  RowBox[{"there", " ", "are", " ", "2", " ", "or", " ", "0."}]}]], "Text",
 CellChangeTimes->{{3.76639610808095*^9, 3.7663961391590424`*^9}, {
  3.766396180141178*^9, 
  3.7663961920386314`*^9}},ExpressionUUID->"6d13862d-db65-4132-9494-\
cf944d831011"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"0", "<", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        SqrtBox[
         RowBox[{"\[Alpha]", "-", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"9", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"33", " ", "\[Alpha]"}], "+", 
             RowBox[{"20", " ", 
              SuperscriptBox["\[Alpha]", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m", "+", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]], "<", "1"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "<", "m", "<", "1"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", ">", "0"}], ",", 
      RowBox[{"0", "<", "m", "<", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7663963821367636`*^9, 
  3.7663964552687483`*^9}},ExpressionUUID->"869813cf-f2bb-4693-aeb2-\
d6c27367ff29"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"1", "+", "\[Alpha]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
   RowBox[{"m", " ", 
    RowBox[{"(", 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], "\[LessEqual]", 
  RowBox[{"8", "+", 
   RowBox[{"9", " ", "\[Alpha]"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Alpha]", "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.766396462102606*^9},ExpressionUUID->"70a48f2d-3091-4b09-aa73-\
d9efe92b587e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"0", "<", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        SqrtBox[
         RowBox[{"\[Alpha]", "-", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"9", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"33", " ", "\[Alpha]"}], "+", 
             RowBox[{"20", " ", 
              SuperscriptBox["\[Alpha]", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m", "+", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]], "<", "1"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "<", "m", "<", "1"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", ">", "0"}], ",", 
      RowBox[{"0", "<", "m", "<", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.76639649535124*^9, {3.7663990696372747`*^9, 
   3.7663990767993946`*^9}},ExpressionUUID->"90ec2f66-8852-4cef-a7a2-\
a51b1790b900"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"1", "+", "\[Alpha]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
   RowBox[{"m", " ", 
    RowBox[{"(", 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], "\[LessEqual]", 
  RowBox[{"8", "+", 
   RowBox[{"9", " ", "\[Alpha]"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Alpha]", "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.7663964981442256`*^9, {3.7663990722371216`*^9, 
   3.7663990778271327`*^9}},ExpressionUUID->"29782984-e833-45cc-bcb5-\
6acae83d7de2"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SqrtBox[
         RowBox[{"1", "+", "\[Alpha]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], ")"}]}], ">", "0"}], "&&", 
    RowBox[{"\[Alpha]", ">", "0"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663990010484095`*^9, 
  3.7663990433875065`*^9}},ExpressionUUID->"847f2c22-0cd2-4ae1-a993-\
773fba7c300c"],

Cell[BoxData[
 RowBox[{"\[Alpha]", ">", "0"}]], "Output",
 CellChangeTimes->{{3.7663990197827272`*^9, 3.7663990441880755`*^9}, 
   3.7663990814127064`*^9},ExpressionUUID->"4e333cfa-a994-4c05-9068-\
e303d030b250"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{"16", "+", 
         RowBox[{"33", " ", "\[Alpha]"}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], "==", 
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}]}]}], ",", "m"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.766396569838211*^9, 
  3.7663966088959527`*^9}},ExpressionUUID->"af7abce8-7c71-4c81-9ef3-\
54ac81758aff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"m", "\[Rule]", 
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
      RowBox[{"4", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.7663965887726483`*^9, 
  3.766396609658496*^9}},ExpressionUUID->"1184a427-77dd-4a59-974c-\
384fd8dd762b"]
}, Closed]],

Cell[BoxData[
 RowBox[{"Therefore", ",", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
    "both", " ", "solutions", " ", "are", " ", "admissible", " ", "if", " ", 
     "0"}], " ", "<", "m", "<", "mcrit"}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
      RowBox[{"4", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}]], ".", " ", "Otherwise"}]}], ",", 
  " ", 
  RowBox[{"there", " ", "is", " ", 
   RowBox[{"none", "!"}]}]}]], "Text",
 CellChangeTimes->{{3.7663990931561317`*^9, 3.766399122600259*^9}, {
  3.766399191975041*^9, 3.766399198287568*^9}, {3.7697594964060926`*^9, 
  3.76975949815633*^9}, {3.7746987382890196`*^9, 
  3.7746987445084934`*^9}},ExpressionUUID->"da2973f5-e236-4aa4-be0d-\
b744c3524944"],

Cell[BoxData[
 RowBox[{
  RowBox[{"mcrit", "[", "\[Alpha]_", "]"}], ":=", 
  FractionBox[
   RowBox[{"8", "+", 
    RowBox[{"9", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "-", 
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
    RowBox[{"4", " ", "\[Alpha]", " ", 
     SqrtBox[
      RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
   RowBox[{"16", "+", 
    RowBox[{"33", " ", "\[Alpha]"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["\[Alpha]", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Alpha]", "3"]}]}]]}]], "Code",
 CellChangeTimes->{{3.769246321545313*^9, 3.769246331396372*^9}, {
   3.769256255860108*^9, 3.7692562565335903`*^9}, 
   3.7697594263342233`*^9},ExpressionUUID->"749ec635-e8b7-4eef-a5b0-\
95474f9f7b82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"mcrit", "[", "\[Alpha]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7692505082940044`*^9, 3.769250545357569*^9}, {
  3.769256261031843*^9, 
  3.769256261698341*^9}},ExpressionUUID->"393d1553-762b-454d-8af2-\
205d6ea9822b"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJwVlnk41VsXx4/jGCpK5iSZUobXcJOMrZ3xkIRUhpdbiGMqmaejYz5mGRPO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          "]]}}},
      Annotation[#, "Charting`Private`Tag$5899#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50}, {0., 0.03262108510207642}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7692505255974064`*^9, 3.7692505462392063`*^9}, 
   3.76925626245088*^9, 
   3.769759511461321*^9},ExpressionUUID->"eac40367-cf25-4e5a-ae99-\
0dedca59be79"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mcrit", "[", "1.", "]"}]], "Input",
 CellChangeTimes->{{3.769246338756649*^9, 3.7692463457246423`*^9}, {
  3.769256265577148*^9, 
  3.769256266214609*^9}},ExpressionUUID->"e215aff5-124c-4df6-8e6b-\
a43966719737"],

Cell[BoxData["0.02780051029483366`"], "Output",
 CellChangeTimes->{{3.7692463422051196`*^9, 3.7692463462360067`*^9}, 
   3.769256266856058*^9},ExpressionUUID->"52c0acec-a2b0-4f18-88f8-\
31d0a4a59fe1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}], ",", 
    RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.766399236422933*^9, 3.7663992480202565`*^9}, {
  3.769759543154507*^9, 
  3.769759545529769*^9}},ExpressionUUID->"c01c6ddf-8e0c-4fd7-97b9-\
d3bb3205bc94"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.769242932051479*^9, 
  3.769759546216958*^9},ExpressionUUID->"2edc480b-1ec4-4eed-a65e-\
1848429d7862"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}], ",", 
    RowBox[{"\[Alpha]", "\[Rule]", "Infinity"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.766399281439245*^9, 3.7663992855431795`*^9}, 
   3.7697595544246874`*^9},ExpressionUUID->"9ae18408-6245-46b8-bd4e-\
1a28b3a76bc0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.766399286221666*^9, 
  3.7697595557393923`*^9},ExpressionUUID->"7893ad9e-0abd-43fc-8f25-\
724d47715886"]
}, Closed]],

Cell["\<\
Thus, for given m > 0, there may be an interval of values \[Alpha] for which \
both solutions (yielding the equilibria equ2 and equ3) exist! This interval \
exists if m < 0.0326211 (see below). At m=0.0326212, it emerges at \
\[Alpha]=2.38298\
\>", "Text",
 CellChangeTimes->{{3.766399301293483*^9, 3.766399330820489*^9}, {
  3.7663997095890045`*^9, 3.7663997503722734`*^9}, {3.7663998051725907`*^9, 
  3.7663998303976917`*^9}, {3.774615781995798*^9, 3.7746157965400515`*^9}, {
  3.7746987783058825`*^9, 
  3.7746987787692165`*^9}},ExpressionUUID->"395535c4-987e-4cd6-bcc8-\
57190d52b9e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"mcrit", "[", "\[Alpha]", "]"}], ",", "\[Alpha]"}], "]"}], 
     "\[Equal]", "0"}], ",", "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.766399565748028*^9, 3.766399585046997*^9}, {
   3.7663996674016247`*^9, 3.766399674270598*^9}, 
   3.769759589689085*^9},ExpressionUUID->"6cc84c4c-c9c5-4af1-8177-\
385296ea99e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"54", "-", 
          RowBox[{"6", " ", 
           SqrtBox["33"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            SqrtBox["33"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7663995859666653`*^9, {3.7663996699024186`*^9, 3.766399674786956*^9}, 
   3.76975959137563*^9},ExpressionUUID->"f0e77ce7-77c6-4fa5-a3e3-\
c8407fa72de6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.7663995992833023`*^9, 
  3.7663996021974125`*^9}},ExpressionUUID->"528af4e9-62b1-4678-b79c-\
cd0734b30039"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", "2.3829757679062373`"}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7663996035223694`*^9, 3.766399682077236*^9, 
  3.7697595976508427`*^9},ExpressionUUID->"1e2078dd-a46e-4282-b443-\
3b036feb4fbb"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"mcrit", "[", "\[Alpha]", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"54", "-", 
           RowBox[{"6", " ", 
            SqrtBox["33"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"6", " ", 
           RowBox[{"(", 
            RowBox[{"9", "+", 
             SqrtBox["33"]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766399621621472*^9, 3.7663996562525396`*^9}, 
   3.769759613179466*^9},ExpressionUUID->"9795138b-ec43-4372-aca0-\
caf961f519a0"],

Cell[BoxData["0.03262110412276136`"], "Output",
 CellChangeTimes->{{3.766399644861293*^9, 3.766399657203228*^9}, 
   3.769759614273506*^9},ExpressionUUID->"1f96ddcd-dd60-45ff-a1b6-\
f36bb3b67cc3"]
}, Closed]],

Cell["\<\
The following shows the \"bubble\" (as in Figure S10), but for a linear scale \
of \[Alpha]:\
\>", "Text",
 CellChangeTimes->{{3.7957857547675085`*^9, 3.7957858303153143`*^9}, {
  3.795785864143953*^9, 3.795785879749032*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"abd25eec-e178-4d84-a794-7078786e6b6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"t22", "/.", "equ2"}], "/.", 
      RowBox[{"m", "\[Rule]", "0.01"}]}], ",", 
     RowBox[{
      RowBox[{"t22", "/.", "equ3"}], "/.", 
      RowBox[{"m", "\[Rule]", "0.01"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", " ", "t22"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Dashed"}], "]"}], ",", "Black"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7663956182568407`*^9, 3.766395632605133*^9}, {
  3.7663962009889965`*^9, 3.766396349837821*^9}, {3.769759689584133*^9, 
  3.769759732946352*^9}, {3.7746158346628227`*^9, 3.7746158929521565`*^9}, {
  3.7957858404825263`*^9, 3.795785844418274*^9}, {3.7957858878744073`*^9, 
  3.7957859628065042`*^9}},ExpressionUUID->"41d68b25-b143-4bb5-8a99-\
566c469f8609"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV1nk4VdsbB/BjnlKJpJJL/EgZIyF630RpkkLlKJpkvoaKa8jURKGSEhEi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         "]]}},
      Annotation[#, "Charting`Private`Tag$43036#1"]& ], 
     TagBox[{
       {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV13k8lF8XAHCkIpRsY8ueLWuphHFOmyhUZN9KC1kSJaFQaKEkZGlB2eUN
Ka1KClF+2VppISnM8zxCoch756/5fD9z594755z7POcqewfZ7ebj4eHZx8vD
w/2ss1sedpN6DmcuRf6OKvsBqtFZP4PjmiBLnvfhUMgAVNSYGQ1HvABdebew
iVODYDb1+dC+4BbYsnbLuJH2EDSZxN7j+LwCRfnBDR+zh+C6mXjU8vJWeK8V
VP9vcgh+du3KOVjaBgZvUXjVOg4YR1bXVhW0w4Omg7TzcQ5EyQr0juR2gOOy
5z4edzjw7J7LrKWXOyG6UKbY6hsH5rlcVwvOeA2zHrn/Pi1CwZaJqfUVKW+g
4F9Tr5YhBRkZtj7M2bcwWnutc3QLBZ9W5J7SO/0OSnJKz8UFUqD25mdJYNx7
cNi4+ZPTSQr8Qte+KIv+AM0ln2XbsimokLjAGYroghMNWxVX36Lgd1W/yJJD
3WB80u34YCMFbHtjfb/gj9DqXV7O/4GC5vNdwT98PsPV+Udjzf9QcCozvSnV
8Au485ljkQANOr7guqz8C5T37XeQlKLh1cofg+06PbB91OzJVRUaQuaejwwp
7YGH8Wlsbz0aJN+uEhbT7IUDK0827F1Fw93C3suVBb0wJ0BxbtNaGv6tN3o0
nPsVTDgrXzY60nBV8qNtskIfDBQV90d70bDuW/xn/ct94HXhg/0THxoS497y
BGV8g4GpMU3+MBr0tsWcny/ZD2kSz7ZJRtHQrqqlciOlHySHLFJfxdEg/TRi
LXX2O/j9Oa/hdJ6GBymqnWeEfsDA3moJ/QwaPL1f7tI5/QOqsjt21F+mIZ9X
4YR/3AC8NJBOYxfRsKGtQUqIbxDy05W71ctoGMwNKiqNHgT+pYluHytoMMQn
zwcihsB2XkJNzT0aOhf4uZyeGIIeo3GGU0PD4c9ig5qHOOC2T41/7AkNj6J2
CfkGU9CnkOyX0kTDxpq5tv0+DNwlCVz3lsw34/1LapiBTTunt5Z+oOGMktd/
qmbDYP/MOv7nRxoOet8P3fZsGDhRa25r9dHgO8u3KUDgJ/TIFSQu+k6De77k
onjrn+BuGrRxYoDEr3//s9udP2G/Qqa5D0OTvCtI/yc9Amv9ovKmf5J8ar70
73cntqq1ix6jQdxPQ5z1bQR8N91nW07S0Et93HH41yg8D3qpNJePgTdJibeT
V43BUVcb1QX8DDTrrxIsOToGfLXnkwTmMHAzOK3i/exf8OV4OdMmyMCxXxtn
TKR+Q2/4z4AWUQYOpk/Y2bv+BhjSjAsSY8B3ZWGhf/ZviIoNHZ4jwcCWcF7b
y+rjEBJ7fDOLxYDS9J3L0ysmIHTFxc+N8gxIZO8eloycAE4VHFFQYEAAxNfp
PZ6AWYGpCwIVGWBi9g15bpiEtnE+jVFlBh7xLzapdfoDY/51nSXqZH8F7Wff
XfoDohccJxs0GCi0iOkZ/vwHDDxg4KMmA0mnuk4p+/6Fg25PBia1GfAQTnl7
/PAUiLE82Ywe2d//YMmlh1NwuELz0md9BtbZUlFVPNMQr+An8cKAAZ1kS/W+
U9Pge92rL3UpA1PiMwfXZ/0DCfuaY8PLGWgRWSHI78GDiXzBu2lTBto3iWX+
d4QHHbqu9KaYMfDuNK2edZkHu7OOpBmxGeibXbROr5sH5Wt73gSZk/mmWTHO
bryomvkwuhEZ4DMbm68ayYv3vmdudlpN4hHReoW6yItTqyKa+ojFf596cPwD
L7puVKMn1jCgTU/+LnPhw5DmNZvmrmfAQOdNfFg4H879pvMonniF302JNVl8
+GlyeiWfBQNr+v2Wvn3Hh5fHB3x/Ebt86grkdZ6FXz+JtNRbMnDqv5o+B0d+
9G+UMZeyJvETvnhA6RA/Vj9V9QwnTtt4iG/oAj9Gl/EIdxHnNOgpxbzmR6tN
E0su2jBQ/SjHrXTbbHxT7qwvsJmBbzeOtf+zm4O3K9U8i7cyMMjx2NEUMgfv
Rr3RHyce1jYZTk2Zg/p3+gbW2ZF4FI6IaLXPwamqA1ofiSVydlrZb52L/gn2
W3m3kf2fW19btFkA8z8teCXnyEDMxlsl7fsEsPyj8hcX4kezVVOnzwrgJoNB
pQxikyM8e+xfCuA/ma/sBU4MLNv7QGjGUhB3J02t/E2sttbQyXHNPCwRs0q5
6sKA978cPLZjHhrXNQ13EOfem69dFjMPQ+9Ul8x2ZUDegDPF+3ge+m5tX+ZD
LLmo6Nr/TIXQYn3FNxU3BuaMy9P8y4WxJUQ6Psqd1NPNxLf624hTD8cWER8P
/FPrekAY77d3/31F/O/r29SKSmGsnA7YoejBwHhryip3PRGU6zTUvUv8o1Qg
vkpjPi7+s2BRhycD6nvC9n2ymI/dDIaNEe9S7ncS3DMfB8Psd0p6MfAl46m2
V/58PCi9+rcD8fu4qNZ5yguwKFJCu514t/4fEUMRUVz8W6f1znYGrLtOFkgr
iGK+9zWF18RGJyXZPPqi+PzHSt4RYv7PBgGvtojih4PvTmrvYOBakk9zYJoo
fn/sXpNOnGDya4dDgSjqW/u8qiAO7j8+aVYtisFBK6KbidE8W1P4nSjKi2Q+
nCL+THWeKJVbiPbp+S/dvRloyPJWSNFZiMv5DIcOEN9YP3w7nL0QlQ3/licQ
R10R+mbptRAP+68wuEMsb7Nm7fdrCxEfDi8W3knqt6x8RlVbDNWNessLidGZ
nSFkKoY775/JvUusyf9Cb3STGP5TPbu+mXjCrd+jLlAM5TLyyznE6UKLHm6v
FMMfhcoyervIendK7S3rxND2a+wTNvHuncZD+h1iKJq+SM2G2OiBvezMmBhO
1N+W9Sfu8Es4fMVYHFNs1b7kEd+XkhaNtxJHW/eZgEria3UFRQGu4mj+a/O9
R8Qhsk/emB4Rx0mJ+pR3xKLN40YfHovjeeMbLoK7GbDR2v1TaoME8jrYVHsR
/0kMffDRUQLDvDd98CUupuPj8/dIoF5+U0swMf+tQpmlJyTQJLtHLZb4vvmP
1Tb1EvgrPjQ7j9j36oSQxGsJVN930Oo6sSS/4JsPfRI4y0Ow8Sbx/iYtP19+
SUx6u9f0CbH6Nv+U2LWSqCI4LtZN3Fkd6b7RXhLf8ue69xIfkzmjvnCnJN54
dT3yB3H3p7L72ccl8YSTuekYccLqmrjdKZJY2uXfPUlsnN9iq3NNEqOeWW2b
IU7dS/feeyKJIbddmgT3kHy9/FcW0yaJMZ+0G+cT03oLwjb0SOL3W4OXxYk3
jukLveaRwvECvzZ5Yp7o4GXDIIXRrOI9usQ3eo5NV2+WQs9kQx1DYrd1KY1H
vaRQ5P7fF0bE1YJVbkLRUphs73/JlHhXwNPF7UlSWOt96YU58cJXHUxmNhnv
o/x2NXFA2lis+iMp7JMwO7aBWHac35ZqId+vcVDaSNzoIil96yP5/f6WS9bE
Bx8u7o2gpFBjwbdRW2IVxRVlq6elsL6zS3Mrcesxi0MCIizUqB82sSeO6nPE
V/IsFFjqre1A/L4krNPdjIVenluuOROfED6VrWrNwhWeFktciY2CMn0H3Vg4
6JWY4kbc21a8tNKfhdVeru/ciZON7k2FRbKQc5ua8iA2z2hqME9k4aR0NI8X
8dDk++TZl1iYnrPhK9eZ7oOuL0tZOFQXXbCd2OLxH7XU+ywM2+61YQfxmLIQ
49LMwg0PFzVxfTVO7p7SBxY2Hf+p7U1s+31J7PcBFn5oFg3kesrKzObGJAur
WJXnuC4ts2aFCkpjnevcVK6dFnj0mMpIY+avDWFc84cEXufTksY7DwrNuL7Z
eTS0yVgavcccv3LXK47f5d1rJY3rPVS3c529YtPmv67SeNrP+x53v2nfDc0k
AqRxGu0Z7v9JyJTW0j0qjQttjfi4jrGakbRIksYNG9eOcONx6M83Pq8caaww
rXnMjVfA9ZdMWIU02h3+5MeN5073qu7kJ9KYXNw76kLsKnKxqaRdGqOa+N24
+djyKKa67qs0mutH5zpy4xXkk9c1Jo0yJxOfbSM2U7JNHpstg2PvvRvtiJe2
GR0VYcmgXRK7ZAux5nE5P3VNGczxs/fj1odE34+1zhtlMC5XONGKeN6FVwbB
bjIoGS4/ZMGtb4vqRQkBZHwkLllHzCmKHX+QJIOsqAxrbr32Ovv1debIIMdm
qR63nt8Jbm2jKmTQc6hieCVxvb/CdcUOGTwzW1WGex4eys/ONO6Twd1fwqO5
5+Vmy1Dc1l8yeNMyslGLG1/9e56xLFnclW8+rcyN16i92Hc3WZQZGeZfyI1X
vsnMTIAsJnk2HRUm9nZQ5khHyaLUSO37udx6uEPXb8yVxbqzj0z/kfOtEXk6
/EafLM5KqSgbIFbQ2b+n8ZcsHkles7aPWOKjo/2XOXJY2WL16BMxD6jpimnJ
YXqhq3cH8Tu+x19CA+VwafWXPQ+I/6sqaEmKksOQSxGLbxM/23XmftE5OTQ1
e9Z0g7iywSXtfaUcKm2eenqV+/xJGNvA/i2Hs2/xxp4gNhXTLuePlsfATrON
m7jz8bo2tZyTR6G3O7LWEm//efpreq48rjq7us2UOK51gKVVJ4+7XUr+LuGO
TyqJsZm9CM2+2psLcccLadmlJy7CZW4jqfXk+R3Hr/lLI1MBP3p6rNImlhpz
WvCzWAHPa9CdisTFX09q3b+ngO4z4e6SxC113z2suxSwc16XPg93/LGihv0K
ihjCVhrsJO+jkmn1zHv5ikipTj2KIPb5m3KlwFkJdeevCblL3n9ptpyn4duV
8K/+vOQy4tqr6wdtfJUwpzoyO5dY2nJixe8wJVSZPnf2FPHzNI9WiwwljHYd
vO1ErKWnOevHayV0fLXfZJS8j4e21/hq2ytjuVzWbkXioIbvy8ptVPBN7OtE
W9Iv1GKZv46jCqZLZH1mE4s+2J9X4qmCG32d1HSJK8onxfKDVFBJaihGiHgk
U2gk87wKvss4fLKR9CeH/PUrjr9WwUXphu1mxEdEw3QcPVQxYbgtS570Nwmu
cxZPB6hhR+G7pJukn9rZGLnH0FcdRXW3+uY7MPBkrsxWfxdNnD00GTR3CwOG
C2PSBw5q4//0Ek4bW5F8jLJ1bAN00M+vb4EB6YevZtfLj5/Vw7Toc5+bVzFQ
lWTS1W5ngDv3rF18l/TzB++zt1yxNsTeiu7mA+S+8Li5YOS021LUn29Vu4/c
R/ZuWFWz13kZOhk96lFeyMDlYsPb/n5GqLhdeOzqLAbOj9Yc2x+2HK8uiVg8
RO5X/aWhh3xDVuBM1Yxy2TcanlmkZB4/vhIdJG/N0u+ggXfzh95zMca42/rq
+zuPaeBZXc2bG74KrxYI9iwqpeEUa9ym/aQJUnOf8mmfoyHt+fOvdYkmeKhc
al1NEg054RfDq86ZoG5P79otxNVd7IK0DBO0Eek4GnqWhm85cVOORSZoXXK0
42EiDWs0xa53NZjglYu9jeanaJgy1hX4NtsU01bffCFyjIb9rjvrxmNN8XyR
EzYE0zA/Z/CL2SlT1Ag/ymtGXPY1eObYGVNU12t2r9xPw/eAGDPhC6YYcbL2
88Ugcr+OvlKtVGiKYRIgsDeQBuv8t6VWz01xtL/D96cvDZr0ptRLwmaY7Fy0
7Qa57/ccM9oFF8zwqY7GvapNNKhLzU/an2WGBhJ1evOJ/Uq/37l6xQzfJd5h
+W6kYaz9ohB/oRm2+LJR1ooGATXequfVZmj1XKgjzIIGvYYWXrt3ZrhIUHoZ
azUNEfN8cnbJsXGdbsTE5+U0PM7GpguKbLxYVcSjQcy/THa0QZWNzy363QKN
aDjr1mKhpcPG1bKtcyaW0pBbtoymzNiolqcrPNuAhkZbHnaYJxvHG/DulBYN
EqlZH05fZWPprfavzotomPdavC2kgI2sA05tF+RJPllJjW4lbBStf8PTLkcD
dfH4Ld1KNupd0FGylKWh4Zp/UlstG43z5I2XsGg4fJO9RuYLGyvzqo6+EKXh
Y1tPSbGCOcoNOvX4zqKhU9w997yKOaYGLZ5J4KOh2eFNeoS6Of5dVK1Zxkvy
/7451lqPeFNz+tAMBck9VR7DbHN0f1Z3zXOKgjU/4xcae5jjS8ndMeK/KCgU
1Q5vvGSOhmEfqgq/UaDX7zLBn2uO3X/dus/1UXDnwemwNfnmWHOo63jYVwqe
7xkIrSkzxwX/e2C8poeCwYfFIVU15shxm3rxrJsC3b0aATmfzfEJc21vRAcF
t56oeYWpAmYF/hA99pgCs4xtn25pAB6NTBjWf0RBfUCcx8gSQO/ftmndDyl4
w+ojeQBU1Rmeq3+fgvHAPOed6wEXuNXfvHOLAhNZFbvNPoB1lvf/bS6h4EmI
4nqN64BO2Z7tNskU/PnFJMuXA577tTivJokCo/Da7oVVgJbB/9PTPktBcfSO
g1P3ATWjMo0nT5P4nMnLa2sGXNLrsTkwloLthRp8RwYBt49bHboSSsFFrQkb
UvaYJ/2loPUABZ1lz7P2jAAeWWvjPBNMgWXVXsOtfwAF/MU+2e6jQPqLg4H4
bMQRi8deVXsomOFkeP2QQNT438inUEcKLuvFzP4qhbjJaFGl3TYKjPf7Xv8o
jbhkz4LXmnYUhIwaj7fLI3qMHrWqtaGgf/J9Uo0aYg79/vWFdRTEmtYZ3VVH
3H2wfPnKNRQoHS39cFMTMdPHRbgVKHDliVQv1kEstAxl+k0o+G+O/KMUI8Rn
4fyYa0CBvyX/rrMrEFsnCpTHdCkQSOAInjJGTPf9e8FsCakPkRqHo2aIyi9F
LUsWU1At7kn5rEOMyu9a3itDgb2DRaq3BaLzBWP2CykKhtP1VnlYIoZ0rPuS
J06BtuxMnJ01Imvxjr1KIhRkK+XKs7chxg+/j9Kc4cD8BMPnuo6IeQ0DlbF/
ORA9WndAwRlx1i613PpxDmxv+NY844Zot36Hxm+GA636YYeGPRD/OyXr9WWI
A6uzBFR6vBCjnd4cKv7OAZWAJeF1OxEjHMcv13/iQMrrh2pVuxH1VDbPEf/A
gVlg25rng1gxV6tO7zUH+hYGa8T7Iw6Hrn5wt5kD2yL5OkIDEc+rR2xg1XOg
vi81ak8Q4qjaTLPqYw4U3ql+veEAYphrVvK8mxyQUrY8ZhyKGLo10eVeKQdO
JrzX0Qoj61dXtt69xoGJUb93MuGICsxzv/YsDvh6TMXOi0TkqTlbfP0cB941
nNX/ewRxqpXekhnLASsDxa6hKETZHlp75AAH7mdVnOiOQdS90aP4wIkDR5xC
DOcfQ0xLndNuuIUD/wd8Bd5M
         "]]}},
      Annotation[#, "Charting`Private`Tag$43036#2"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\[Alpha]", HoldForm], TraditionalForm], 
    FormBox["t22", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 33.00824564059346}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.774615863420703*^9, 3.774615893882872*^9}, 
   3.7957858552630515`*^9, 3.7957859047577124`*^9, {3.7957859373450637`*^9, 
   3.7957859636290216`*^9}},ExpressionUUID->"d8e78a9d-aa98-489e-9c30-\
428036e4a37f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}], "\[Equal]", "0.01"}], ",", 
   "\[Alpha]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7663994388901997`*^9, 3.766399455655334*^9}, {
   3.7697598047596474`*^9, 3.769759808513853*^9}, 
   3.7746159191140585`*^9},ExpressionUUID->"45e3faf0-9f1d-41a2-a255-\
222af549efee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0.19413238678496728`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "33.00873279249816`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7663994564378996`*^9, 3.769759809749757*^9, 
  3.7746159199597025`*^9},ExpressionUUID->"deff26a7-5887-4a73-b337-\
a4e226a2e2ed"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"equ2", ",", "equ3"}], "}"}], "/.", 
   RowBox[{"m", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.769252324107692*^9, 
  3.769252344009977*^9}},ExpressionUUID->"de047112-3d44-493d-9204-\
e925cbdad70e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "1"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.769252334156895*^9, 
  3.7692523453619266`*^9}},ExpressionUUID->"4786cd1e-8782-4a50-93c9-\
eec171ffa81f"]
}, Closed]],

Cell["\<\
The following displays the region {\[Alpha], m} in which equ2 and equ3 are \
admissible (with \[Alpha]<100)\
\>", "Text",
 CellChangeTimes->{{3.7747905114401526`*^9, 
  3.774790582658114*^9}},ExpressionUUID->"d735e7e0-8a9d-42db-befe-\
e8dfb0eae7b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"0", "<", "m", "<", 
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "0.035"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"m", ",", "\[Alpha]"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7747901808703156`*^9, 3.7747902238726015`*^9}, {
  3.7747902622268267`*^9, 3.7747903140579023`*^9}, {3.7747904958049583`*^9, 
  3.7747904964253983`*^9}},ExpressionUUID->"eeb3cdd1-bd0f-4b3b-89a7-\
1bdd5806a8ab"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlmXk4FdrXx4lKSYMSGQuhzFMirF0yRMYKDVRSKWWOzEOmJHNmh0ShQYkM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   "], {{{
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[0.3], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHn8ndMRxs/cyL4vsorsSWPJQhUJkUhiSS3xC4mmtiwaQgWp2iUIopaI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          "]], PolygonBox[CompressedData["
1:eJwtlnmwj2UUx8/54crSovXWHS0zNZRoX6em3UyjVYtKq5Y/TNyQXalE22hP
i6hQKFv2hLpaCFlCWXO1YJCSigh9vvN9//jM833e9XnPOc/3vMe1qWzZvhQR
A6AmrMmIH2Ah+mfoh+4LDdGD4DV0E/gePQHao6+Ckeh3oSe6ggfWZXyM+TDG
ZrAC/QmMRJ8CK9GfQht0Xa7fg94L/Zm/BB+jK+EZ9NO6B/0eXIFuzPWHM7Zm
fifjPvgHvQMWoRdAL/Tc8NouTN+rNb6FPlnfiJ4EL6JPgmXhdx7Gs1swH4Gu
zfgONIXlzKfAZehGXHMoYwvmZzHOhTnoarhb3w2jtXa4Fn05DEOPgunoadAN
PQtuRlemY/c7XIDeBlvCMZ+H/gZ6ht9xEfp43n9gEZMzGD+HL9E/wkfosTAD
3RlOVSxhJnoVjENPhM/QXeAD9IfpXDysGKPfT+eqE9yCflTXoPvAjegHFRf0
ZqjDWu5h/pyeBdej28Jg9AI4QrmC3uFjF3PuBOYHM57NvEprge7hb9iLvkM5
D8fsa30b9JCGXukaU21pDWeiv0qfWwun61vSsV0Dr6MHpnPdAd5WrNO57AjX
oZvrm8M5U+7PT9e6aqALOkqurRvgdua907l8SjFD74a/0M3hNPRk5QS9Gq5G
XwJDwjHsjt6f55UY68E1cCkMVe7gZfSA9N56CFqjd8H28DsUizkwOxwTxe4L
xSAcQ9XWTB0L19gk5RKq0F3DtfStaipcU1PS1+ic1rwE/RtsQD8CLbXXdU/Y
E25C/wGbwjWqvfYdzAvvuSfRfaABeiC8mv4mfct4aIxeDUvQCm0TYtGhqIVy
7c2SY6pYVjDeqr2tdzIfC01LzolycTRjGfNaJXvBLh1DN4RW6J1QA12z5HM6
Jq+4K31OnlGv5JwoF/uY/8v4E/RDb4P6nL+feQ1IOES1C+04V4v5Dvgb+obX
eBDnGpR8ri3zPYz/FV6hHCrXO9PPVs7P1T7m+mMYfw174b3FWuSJ21VbsBXd
KOx98hh5izzwAOY9GOsXazy25DXo3TpWDVfC+vDzN6E3w/DwntVe1B7X3tae
lLe0Ynwi7DEbYGN6bz8rP+F8M/glvOa1xTv0bB2bnfbE6nCNyiu1Z7RX5Jl/
pj1PXqdvWow+RzEP15BqSx4jb1GNrUj3JPWixTBftQLrwjW8JR1DvV812y3d
U9RL9I2z0h4hb9Ae2Zr2eHn7xnBty7PkVarx8WmPlDfKM7W2pTA/vMYX0j1K
vWlc2Dtq87zdYQ9RL3klXevqKSein09fuxQ6FTWtWpYnLEvvOe01vWO5ajv9
rYvCuTsvvZeUw9sKz5BXqOYUi4XpXqeYPKDcwRh0GePj6TXo3Tq2Er0q/Wzt
0THpHqHeoJ7xZtoz5ZUTw717OEwL9/AR6Z6hXqFjE9KeJ69TT5ma9mB5bxW0
Q5cTnzrpf4J1yn0Re/UEeYHWXFZ4wlFce2TJta57ZqR7nHqbPK1j2jPKixrt
nPaMimLPdk17hLxBPUT/Km+kv0X/LKPTPVK9cXr4X2RUWuufRL1+CEwN9/zB
6Z6hXjEZ7kt7grxAHj403TPVK3WP/i0Gpa/VP8Z+XLs+vXdUI/8DduhKcg==

          "]]}]}}, {}, {}, {}, {}}, {{
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       LineBox[CompressedData["
1:eJwl1Hecz3UcwPG7k5XZNQgZJ9xxlyOccEI4cjhHRV2Os93Zm1BZ2WVlb1kh
q6JSRpllhGxlk4YZsp6/x/3x/L3en893/H7f3+P3+BVJ6ZLYOTgoKCjMSziB
+QAhhFKQcKKJIZYaxBFPAk1oShLJpNCG9qSSRieecdNQniYXT5GbwvT3xjm1
jWbX1ppD+2k2baVPaor2JcJcR//kCpdpSVb7cXqJi1wgi73M1DYn8D4tAs9r
r5aOoZA5I5kI4Qky8AIFCSbZeY9oHpz+BfXWKO2j5znHuzykJg0ZTBIlnPea
jqaA+b4+4B7v8D89iXSsl57lDHe5Qw0a8Da3+I/bNKMHxV1XXesziKYUs1dN
R9GNUtbddSBv8aL1q/oRI+lKUXuxGk/gh1HSuou+yXVucoOqjOB5x/ORl07W
+XWAvkcqaTThX97gGlUYxnDaE+aaSlqPZ81/6z/8wXPWeehg7kgjDpPIb5zk
KI05wnGOUZkhDKUdRdzjFa3L75ymjL3X9RQvmaMpTUXrq/zFrxziIDHs5wC/
sI+9VGAPP7OT3eyiPNvZwTZ+4kfKsYWtfM9mfuBlvmMTG/mWbyjL12xgPV/x
ZeDzs5Z1fMEaVhPNSlaxnBV8TmmWsozPWMLiwLOzkEXMYwHziWIOc5nJbGYR
yXRm8CnTmEopJjOFCUxiIiX5mE8Yy3jGEcEHfEhbTgSn/wc9Biasi0k=
        "]]}}}}],
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\[Alpha]", TraditionalForm], None}, {
     FormBox["m", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
    "AxesInFront" -> True},
  PlotRange->{{0, 0.035}, {0, 100}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7747902247862444`*^9, {3.7747902674395432`*^9, 3.7747903151837053`*^9}, 
   3.7747904991223483`*^9},ExpressionUUID->"06963e0d-2324-4c07-ba42-\
bad87ce8f1f1"]
}, Closed]],

Cell["Some properties of equ2 and equ3:", "Text",
 CellChangeTimes->{{3.7746159491809287`*^9, 
  3.7746159654362993`*^9}},ExpressionUUID->"0b152f25-9c14-4786-a57b-\
153e88fae14d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"equ2", ",", "equ3"}], "}"}], "/.", 
   RowBox[{"m", "\[Rule]", 
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7692524059483523`*^9, 3.7692524121007643`*^9}, {
  3.769759886791129*^9, 
  3.7697598903766775`*^9}},ExpressionUUID->"781e970f-c480-4b74-a590-\
19b419e03012"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{"8", "-", 
        RowBox[{"8", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"18", "-", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
              RowBox[{"\[Alpha]", " ", 
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 RowBox[{"2", " ", "\[Alpha]"}], "-", 
                 RowBox[{"2", " ", 
                  SqrtBox[
                   RowBox[{"1", "+", "\[Alpha]"}]]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Alpha]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{"8", "-", 
        RowBox[{"8", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"20", "-", 
           RowBox[{"16", " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"18", "-", 
              RowBox[{"11", " ", 
               SqrtBox[
                RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
              RowBox[{"\[Alpha]", " ", 
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 RowBox[{"2", " ", "\[Alpha]"}], "-", 
                 RowBox[{"2", " ", 
                  SqrtBox[
                   RowBox[{"1", "+", "\[Alpha]"}]]}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Alpha]", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.769252407000105*^9, 3.7692524135147743`*^9}, 
   3.769759891906885*^9},ExpressionUUID->"24fe65d7-e83d-4dc8-ae08-\
e62e93e17a5c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"8", "-", 
     RowBox[{"8", " ", 
      SqrtBox[
       RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
     RowBox[{"\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"20", "-", 
        RowBox[{"16", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"18", "-", 
           RowBox[{"11", " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              RowBox[{"2", " ", "\[Alpha]"}], "-", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"1", "+", "\[Alpha]"}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Alpha]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]], ",", 
   RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.769252505298563*^9, 3.7692525218404303`*^9}, {
  3.769759923100305*^9, 3.769759961028675*^9}, {3.7697601070717754`*^9, 
  3.769760119682517*^9}, {3.769760372298003*^9, 
  3.7697603785337925`*^9}},ExpressionUUID->"c3ca1d73-9799-493b-9c4b-\
2b121094e197"],

Cell[BoxData[
 FractionBox["3", "4"]], "Output",
 CellChangeTimes->{{3.7697601087121954`*^9, 3.769760120619813*^9}, {
  3.7697603737201037`*^9, 
  3.7697603792522316`*^9}},ExpressionUUID->"94dbfbcb-9f01-4601-9cb9-\
3149db7fd4fd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"8", "-", 
     RowBox[{"8", " ", 
      SqrtBox[
       RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
     RowBox[{"\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"20", "-", 
        RowBox[{"16", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"18", "-", 
           RowBox[{"11", " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              RowBox[{"2", " ", "\[Alpha]"}], "-", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"1", "+", "\[Alpha]"}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Alpha]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]], ",", 
   RowBox[{"\[Alpha]", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7697599872109146`*^9, {3.7697604009858913`*^9, 
   3.7697604061156416`*^9}},ExpressionUUID->"17e3de4c-ceca-441f-adef-\
1ae8f0161d44"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.7697599880230765`*^9, 
  3.7697604069717207`*^9},ExpressionUUID->"90de786c-2513-41f3-823d-\
eaf1931f5108"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"8", "-", 
     RowBox[{"8", " ", 
      SqrtBox[
       RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
     RowBox[{"\[Alpha]", " ", 
      RowBox[{"(", 
       RowBox[{"20", "-", 
        RowBox[{"16", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"18", "-", 
           RowBox[{"11", " ", 
            SqrtBox[
             RowBox[{"1", "+", "\[Alpha]"}]]}], "+", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              RowBox[{"2", " ", "\[Alpha]"}], "-", 
              RowBox[{"2", " ", 
               SqrtBox[
                RowBox[{"1", "+", "\[Alpha]"}]]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Alpha]", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7692524575803795`*^9, 3.7692524930838084`*^9}, {
   3.769760578274626*^9, 3.769760590765684*^9}, {3.769760638888777*^9, 
   3.7697606707539425`*^9}, 
   3.769760731534545*^9},ExpressionUUID->"a2b6abae-a1a2-4d90-bd95-\
72b321d815db"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV0Xk0lesXB3AJ0UAKFyFDg+GkDKnUOXsrQ4RwDZlDyFCZKnMyD2UoumUo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         "]]}},
      Annotation[#, "Charting`Private`Tag$16074#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.7541801640004575},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.769252473391693*^9, 3.7692524937072554`*^9}, {
   3.7697606572363534`*^9, 3.769760671840499*^9}, 
   3.7697607324092703`*^9},ExpressionUUID->"8d3c3abb-dc38-4a3e-b960-\
15a5f5e11feb"]
}, Closed]],

Cell["\<\
If \[Alpha] is above the highest solution, then t22 is not in [0, 1].\
\>", "Text",
 CellChangeTimes->{{3.769762066662122*^9, 
  3.7697620937096653`*^9}},ExpressionUUID->"a9cbb2b7-d447-4bb0-936f-\
c59e4edf2d19"],

Cell[BoxData[{
 RowBox[{"Summary", ":", "\[IndentingNewLine]", 
  RowBox[{
  "The", " ", "equilibria", " ", "equ2", " ", "and", " ", "equ3", " ", 
   "exist", " ", "if"}]}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"0", " ", "\[LessEqual]", "m", "<", "mcrit"}], "=", 
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
      RowBox[{"4", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}]]}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"which", " ", "requires"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", " ", 
     RowBox[{"N", "[", 
      RowBox[{"mcrit", "/.", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", "\[Rule]", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"54", "-", 
               RowBox[{"6", " ", 
                SqrtBox["33"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 SqrtBox["33"]}], ")"}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}]}], "]"}]}], "=", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"0.0326211", ".", "\[IndentingNewLine]", "For"}], " ", "given", 
      " ", "m"}], "<", "mcrit"}]}], ",", " ", 
   RowBox[{"there", " ", "is", " ", "an", " ", 
    RowBox[{"interval", " ", "[", 
     RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "]"}], " ", "for", " ", "which",
     " ", "the", " ", "equilibria", " ", "exist", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"obtained", " ", "by", " ", "solving", " ", "m"}], "=", 
       RowBox[{"mcrit", " ", "for", " ", "alpha"}]}], ")"}], ".", " ", 
     "This"}], " ", "interval", " ", "contains"}]}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]_crit", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"54", "-", 
          RowBox[{"6", " ", 
           SqrtBox["33"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            SqrtBox["33"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"2.38298", ".", "\[IndentingNewLine]", "We"}], " ", "have"}]}]}],
   ",", " ", 
  RowBox[{
   RowBox[{
   "1", "\[GreaterEqual]", "equ3", "\[GreaterEqual]", "equ2", 
    "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"1", "/", "2"}], " ", "when", " ", "they", " ", 
     RowBox[{"exist", ".", " ", "If"}], " ", "m"}]}], "=", "0"}], ",", " ", 
  RowBox[{
   RowBox[{"then", " ", "equ2"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "2"}], "and", " ", "equ3"}], "=", 
    RowBox[{
     RowBox[{"1.", " ", "If", "  ", "m"}], " ", "=", " ", "mcrit"}]}]}], ",", 
  " ", 
  RowBox[{
   RowBox[{"then", " ", "equ2"}], "=", 
   RowBox[{"equ3", "=", 
    RowBox[{"3", "/", "4."}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"The", " ", 
    RowBox[{"interval", " ", "[", 
     RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "]"}], " ", "is", " ", "also", 
    " ", "the", " ", "interval", " ", "when", " ", "a", " ", "polymorphism", 
    " ", "in", " ", "t22", " ", "and", " ", "e22", " ", "is", " ", 
    "maintained", " ", "if", "  ", "m"}], ">", 
   FractionBox["s", 
    RowBox[{"1", "+", "s"}]]}], ",", " ", 
  RowBox[{
  "in", " ", "which", " ", "case", " ", "migration", " ", "and", " ", 
   "selection", " ", "alone", " ", "cannot", " ", "maintain", " ", "a", " ", 
   "polymorphism", " ", "at", " ", "an", " ", "isolated", " ", "locus", " ", 
   RowBox[{"E", ".", " "}]}]}]}], "Text",
 CellChangeTimes->{{3.7664132290178947`*^9, 3.766413239658518*^9}, {
   3.7664132876619673`*^9, 3.766413292200221*^9}, {3.7664133333397465`*^9, 
   3.766413338726601*^9}, {3.766413506337886*^9, 3.766413542148568*^9}, {
   3.7664136205618367`*^9, 3.7664136488901634`*^9}, 3.7692523655834208`*^9, {
   3.7692527029902625`*^9, 3.7692527622647696`*^9}, {3.7692527996245294`*^9, 
   3.769252855220364*^9}, {3.769259692813298*^9, 3.7692597158368106`*^9}, {
   3.769259781840787*^9, 3.7692599926235285`*^9}, {3.769760828921544*^9, 
   3.769760829609067*^9}, {3.7746150626392326`*^9, 3.774615070479497*^9}, {
   3.7746160262485394`*^9, 3.7746160731802187`*^9}, {3.77469881758924*^9, 
   3.7746988569196568`*^9}, {3.77469891815684*^9, 3.7746989197339797`*^9}, {
   3.774785564608531*^9, 3.774785578162216*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"4a2457b9-fde9-4559-839a-b2acc46fd903"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"equ2", ",", "equ3"}], "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
     RowBox[{"m", "\[Rule]", "0.02"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7664139267515574`*^9, 
  3.766413961190285*^9}},ExpressionUUID->"266f854d-7510-40c4-96e4-\
bfe7e56b69dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.6149521558699257`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.9430904159975313`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.7664139618027115`*^9, 
  3.766413970847184*^9}},ExpressionUUID->"c91caada-a33b-4b1d-a08d-\
7b126c603191"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"deltasymCID0", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"e22", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
      RowBox[{"m", "\[Rule]", "0.03"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t22", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7664137764286795`*^9, 3.7664138514154863`*^9}, 
   3.766413896633936*^9, {3.7664149394602194`*^9, 
   3.766414951484849*^9}},ExpressionUUID->"c0559a69-dc03-4cd6-a98e-\
ddf954936be2"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13c8Ve8fAHCkjIyEQiSiZKeQho9NRnYlskJlFpIyQla2e28qM6MhGUkR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          "]]}}},
      Annotation[#, "Charting`Private`Tag$208338#1"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1}, {-0.30666278087296234`, 0.019737878733997533`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7664138525402927`*^9, 3.7664138984002*^9, 3.7664147968108616`*^9, {
   3.766414940680093*^9, 
   3.7664149525886545`*^9}},ExpressionUUID->"8c74dee6-2b3b-499d-a290-\
3e672612799a"]
}, Closed]],

Cell["\<\
Therefore, t22 = 0 is stable, equ2 is unstable, and equ3 is stable within the \
edge e22 = 0 (if \[Alpha]\[Rule]2.5,m\[Rule]0.03).\
\>", "Text",
 CellChangeTimes->{{3.766413996387509*^9, 3.766414047958517*^9}, {
  3.774616150061609*^9, 
  3.774616159129218*^9}},ExpressionUUID->"83e93447-dd2a-4ac3-b0ca-\
8aceea521297"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"equ1", ",", "equ2", ",", "equ3"}], "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
     RowBox[{"m", "\[Rule]", "0.03"}], ",", 
     RowBox[{"s", "\[Rule]", "0.1"}], ",", 
     RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7664167507409077`*^9, 
  3.7664167717790046`*^9}},ExpressionUUID->"cd9a9856-eced-4c94-b95c-\
35e26feb95f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.6907216494845362`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.7180835159095897`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.8715035370190517`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7664167724194627`*^9},ExpressionUUID->"1a7fb531-fe31-4b45-ba05-\
45e4e3e51d0b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"deltasymCI", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
          RowBox[{"m", "\[Rule]", "0.03"}], ",", 
          RowBox[{"s", "\[Rule]", "0.1"}], ",", 
          RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], ")"}], "\[Equal]", 
      "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "t22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "e22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"t22", " ", "e22"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "t22"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "e22"}], ")"}]}]}], "]"}]}], "\[LessEqual]", " ",
       "dd2", "\[LessEqual]", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"t22", 
         RowBox[{"(", 
          RowBox[{"1", "-", "e22"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t22"}], ")"}], "e22"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], ",", "Reals"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.766414892711684*^9, 3.7664149261316566`*^9}, {
  3.766414958100591*^9, 3.766414999727475*^9}, {3.76641593947478*^9, 
  3.76641594280217*^9}, {3.766416281998562*^9, 3.7664163033508916`*^9}, {
  3.766416551005596*^9, 3.766416637206442*^9}, {3.7664168037079163`*^9, 
  3.766416809133829*^9}},ExpressionUUID->"dfb3ce01-cd12-4856-8488-\
19f9a6cc0eeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.6907216494845362`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.7180835159095894`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.7180835159095896`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.8715035370188985`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.8715035370190519`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.871503537019052`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.8715035370190545`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7664160100264044`*^9, 3.766416372899805*^9, 
  3.7664166094665365`*^9, 3.7664167063490677`*^9, 
  3.7664168782844267`*^9},ExpressionUUID->"eff4c7c0-f10a-4b3c-bfe8-\
716472f2c778"]
}, Closed]],

Cell["\<\
The above shows that NSolve does not find all equilibria, because :\
\>", "Text",
 CellChangeTimes->{{3.774616266029101*^9, 
  3.774616287377655*^9}},ExpressionUUID->"f015dc9d-68a3-4035-9384-\
e282436b6c77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"deltasymCI", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
        RowBox[{"m", "\[Rule]", "0.03"}], ",", 
        RowBox[{"s", "\[Rule]", "0.1"}], ",", 
        RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t22", ",", "0.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e22", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dd2", ",", "0.01"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766415863569344*^9, 3.7664159150562906`*^9}, {
   3.766415972015135*^9, 3.766415975619718*^9}, 
   3.7664160658594713`*^9},ExpressionUUID->"50b2369e-c3ec-44d2-b996-\
3c9ed9c62d86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t22", "\[Rule]", "0.6417563021923373`"}], ",", 
   RowBox[{"e22", "\[Rule]", "0.7332814941258163`"}], ",", 
   RowBox[{"dd2", "\[Rule]", "0.03344642773111806`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.766415908882828*^9, 3.7664159157997913`*^9}, 
   3.766416032739707*^9, 
   3.7664160668151727`*^9},ExpressionUUID->"0058862e-7271-4140-9b60-\
3f2566ef3811"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"equ1", ",", "equ2", ",", "equ3"}], "}"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
     RowBox[{"m", "\[Rule]", "0.04"}], ",", 
     RowBox[{"s", "\[Rule]", "0.1"}], ",", 
     RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766416852152675*^9, 
  3.766416856422741*^9}},ExpressionUUID->"d96d06f0-65bc-4ba0-8764-\
2b3a470eae16"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.5833333333333334`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      RowBox[{"0.8115310077519382`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.1330160262915925`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      RowBox[{"0.8115310077519382`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.1330160262915925`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"e22", "\[Rule]", "0.`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.766416878459553*^9},ExpressionUUID->"077f1ed4-379c-4faf-afae-\
58c97dc13140"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"deltasymCI", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
          RowBox[{"m", "\[Rule]", "0.04"}], ",", 
          RowBox[{"s", "\[Rule]", "0.1"}], ",", 
          RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], ")"}], "\[Equal]", 
      "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "t22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "e22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"t22", " ", "e22"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "t22"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "e22"}], ")"}]}]}], "]"}]}], "\[LessEqual]", " ",
       "dd2", "\[LessEqual]", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"t22", 
         RowBox[{"(", 
          RowBox[{"1", "-", "e22"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t22"}], ")"}], "e22"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], ",", "Reals"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.7664168364293947`*^9},ExpressionUUID->"5137c466-00af-4446-9fef-\
2a9bb8254cc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.5833333333333331`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.5833333333333334`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.76641695063134*^9},ExpressionUUID->"61cfe91c-7430-463c-ac48-f63ac9cb947d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"deltasymCI", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]", "\[Rule]", "5"}], ",", 
          RowBox[{"m", "\[Rule]", "0.04"}], ",", 
          RowBox[{"s", "\[Rule]", "0.2"}], ",", 
          RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], ")"}], "\[Equal]", 
      "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "t22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "e22", "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"t22", " ", "e22"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "t22"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "e22"}], ")"}]}]}], "]"}]}], "\[LessEqual]", " ",
       "dd2", "\[LessEqual]", 
      RowBox[{"Min", "[", 
       RowBox[{
        RowBox[{"t22", 
         RowBox[{"(", 
          RowBox[{"1", "-", "e22"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t22"}], ")"}], "e22"}]}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], ",", "Reals"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7664170272623277`*^9, 
  3.7664170308178787`*^9}},ExpressionUUID->"93e48e43-c853-406b-aaf3-\
26aa3478d1ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0.7916666666666667`"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.766417090840953*^9},ExpressionUUID->"eb9dd66d-f623-49ca-9b81-\
687af3928529"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"deltasymCI", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Alpha]", "\[Rule]", "2.5"}], ",", 
        RowBox[{"m", "\[Rule]", "0.03"}], ",", 
        RowBox[{"s", "\[Rule]", "0.1"}], ",", 
        RowBox[{"r", "\[Rule]", "0.5"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t22", ",", "0.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e22", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dd2", ",", "0.01"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7664160834460907`*^9},ExpressionUUID->"c0561828-e382-4aa1-a0f2-\
86d9e543efd1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t22", "\[Rule]", "0.7180835159095896`"}], ",", 
   RowBox[{"e22", "\[Rule]", "3.3478965607998857`*^-20"}], ",", 
   RowBox[{"dd2", "\[Rule]", "1.7535536707037314`*^-20"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7664160839885006`*^9},ExpressionUUID->"760b8086-f8a6-4769-86d8-\
0169fa0381c9"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.3.5 Plotting the dashed curves (frequency of t22 for an isolated locus T) \
shown in panels c and d of various figures\
\>", "Subsubsection",
 CellChangeTimes->{{3.7948139708677015`*^9, 3.794814097519562*^9}, {
   3.794814128533749*^9, 3.7948141408237157`*^9}, 
   3.7948156565118604`*^9},ExpressionUUID->"57de61fb-de50-4293-b2a7-\
29b8cce6ad78"],

Cell["The following is equ3 :", "Text",
 CellChangeTimes->{{3.7948141526419053`*^9, 
  3.7948141627301254`*^9}},ExpressionUUID->"fed47b2d-2b4e-4d88-b689-\
a296d02be7e2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"equCI3", "[", 
    RowBox[{"m_", ",", "\[Alpha]_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"m", ">", 
      FractionBox[
       RowBox[{"8", "+", 
        RowBox[{"9", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"8", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
        RowBox[{"4", " ", "\[Alpha]", " ", 
         SqrtBox[
          RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
       RowBox[{"16", "+", 
        RowBox[{"33", " ", "\[Alpha]"}], "+", 
        RowBox[{"20", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Alpha]", "3"]}]}]]}], ",", "0", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        SqrtBox[
         RowBox[{"\[Alpha]", "-", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"9", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"33", " ", "\[Alpha]"}], "+", 
             RowBox[{"20", " ", 
              SuperscriptBox["\[Alpha]", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m", "+", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}], ")"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.774966946795247*^9, 3.774966972969632*^9}, {
   3.7749670732329025`*^9, 3.774967153916586*^9}, {3.7749672743469276`*^9, 
   3.774967312885002*^9}, {3.7749674729314747`*^9, 3.7749674941413746`*^9}, {
   3.7749676420233793`*^9, 3.774967654769414*^9}, 3.7749678105367756`*^9, {
   3.774967847407915*^9, 3.774967848359584*^9}, {3.7749679366760902`*^9, 
   3.774967981127317*^9}, {3.774968021764869*^9, 3.7749680365452547`*^9}, 
   3.7749681190702515`*^9, {3.774968239120696*^9, 3.774968267717966*^9}, {
   3.77496830309104*^9, 3.774968316693691*^9}, 3.775127409995613*^9, {
   3.7751274844260263`*^9, 3.7751274885659876`*^9}, {3.7751275948234577`*^9, 
   3.7751276592182055`*^9}, {3.775127760309159*^9, 
   3.7751277611637764`*^9}},ExpressionUUID->"1183bd73-edfd-48d3-909e-\
bfdc272636f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotCIeq3t", "=", 
  RowBox[{"ListLinePlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", 
        RowBox[{"equCI3", "[", 
         RowBox[{"0.01", ",", 
          RowBox[{"10", "^", "\[Beta]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", 
        RowBox[{"-", "2"}], ",", "4", ",", "0.01"}], "}"}]}], "]"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Black", ",", 
       RowBox[{"Dashing", "[", 
        RowBox[{"{", 
         RowBox[{"0.02", ",", "0.02"}], "}"}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7751273308090777`*^9, 3.7751273489390755`*^9}, {
  3.7751276841699266`*^9, 3.7751277121088037`*^9}, {3.7751277795099306`*^9, 
  3.7751277802554765`*^9}, {3.785577214040914*^9, 3.785577214519643*^9}, {
  3.7868909939862485`*^9, 
  3.786891004394436*^9}},ExpressionUUID->"679360db-00df-4dcd-b525-\
205cee589883"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {
      {GrayLevel[0], PointSize[0.011111111111111112`], AbsoluteThickness[2], 
       Dashing[{0.02, 0.02}], LineBox[CompressedData["
1:eJxd2Hl8DecawHE7ESGt2mpfSlvbpYRQHmtjCSIUsUSIpFoVQa/YCYJagg8R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        "]]}}}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-2., 4.}, {0, 0.9812481190028993}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.794813996519313*^9, 3.794813999342727*^9}, 
   3.7957858519789114`*^9, 3.796906232011041*^9, 
   3.8001940107158723`*^9},ExpressionUUID->"88b70d10-b7fb-4495-9be7-\
f95d05603b06"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4 Stability of boundary equilibria", "Section",
 CellChangeTimes->{{3.766816817738822*^9, 3.766816826754998*^9}, {
  3.7752250327485332`*^9, 
  3.77522503513593*^9}},ExpressionUUID->"849482a9-99eb-4095-b2a4-\
50861302a856"],

Cell[CellGroupData[{

Cell["\<\
3.4.1 Stability of the equilibrium equ00 (swamping by the continental type)\
\>", "Subsection",
 CellChangeTimes->{{3.766817344164525*^9, 3.7668173500865283`*^9}, {
   3.7668224999521737`*^9, 3.7668225044521313`*^9}, {3.7668227245369654`*^9, 
   3.7668227290525827`*^9}, {3.7668283587478213`*^9, 3.766828390750953*^9}, {
   3.774698963224376*^9, 3.7746989717645507`*^9}, {3.7752250555752244`*^9, 
   3.775225063493314*^9}, {3.775225098677825*^9, 3.7752251039970036`*^9}, {
   3.775455013528373*^9, 3.775455048527495*^9}, 
   3.785065365644396*^9},ExpressionUUID->"d22c0e12-f9c5-4a2b-9e5b-\
40565f81930c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equ00", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", "0"}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7668227403651714`*^9, 
  3.7668227535851173`*^9}},ExpressionUUID->"a8c45490-3dae-4fdc-8a33-\
24dd195a22e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobsymCIequ00", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ00"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.7668227660708413`*^9, 
   3.76682276936775*^9}},ExpressionUUID->"a38d0c24-cd30-49b8-b778-\
b60ac1b806b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobsymCIequ00", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.766817420464999*^9, 3.766817422636921*^9}, {
  3.766822776305307*^9, 
  3.7668227764303107`*^9}},ExpressionUUID->"20dc6224-5fa3-47cc-a6ba-\
35aac62caa74"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}]},
    {"0", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}]}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}]}], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", "\[Alpha]"}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]},
    {"0", "0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7668227770240655`*^9},ExpressionUUID->"c6c22226-252b-47ed-a630-\
c2db5abd0735"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"evalsequ00", "=", 
  RowBox[{"Eigenvalues", "[", "JacobsymCIequ00", " ", "]"}]}]], "Input",
 CellChangeTimes->{{3.766817390134531*^9, 3.766817399572656*^9}, {
  3.766818041015176*^9, 3.766818050406002*^9}, {3.766822795729498*^9, 
  3.766822795885732*^9}, {3.7668228341785355`*^9, 
  3.7668228343347883`*^9}},ExpressionUUID->"d572bc30-f8b2-4848-bf92-\
1261685919d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "\[Alpha]"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7668174001976695`*^9, 3.766817427727903*^9}, {
   3.7668180442027445`*^9, 3.7668180511872735`*^9}, 3.766822797323225*^9, 
   3.766822835116068*^9},ExpressionUUID->"f7399d6a-524b-4a9d-b390-\
03c803746242"]
}, Closed]],

Cell[TextData[{
 "All eigenvalues are positive.\nThe second is greater than 1 if and only if \
m < ",
 Cell[BoxData[
  FormBox[
   FractionBox["s", 
    RowBox[{"1", "+", "s"}]], TraditionalForm]],ExpressionUUID->
  "13b619fa-5b07-4731-ba20-79ec8cedba17"],
 "."
}], "Text",
 CellChangeTimes->{{3.7668228522268906`*^9, 3.7668228593643856`*^9}, 
   3.766822890772352*^9, {3.766822947600218*^9, 3.76682298524232*^9}, {
   3.7692447307376413`*^9, 
   3.769244731821396*^9}},ExpressionUUID->"ee0a000f-767f-40e1-a85d-\
b4c89a42ed2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}]}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}]}], "<", "1"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", "1"}], "&&", 
     RowBox[{"s", ">", "0"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766822908072522*^9, 
  3.7668229354125524`*^9}},ExpressionUUID->"8d1fde54-44f5-478e-8d97-\
25129c4df26f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "+", 
   RowBox[{"m", " ", "s"}]}], ">", "s"}]], "Output",
 CellChangeTimes->{{3.766822920119581*^9, 
  3.7668229361781626`*^9}},ExpressionUUID->"219c21ef-4c47-4357-a0d6-\
4b1686da9eb6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"0", "<", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "<", "1"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", "1"}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766823707379953*^9, 
  3.766823743644782*^9}},ExpressionUUID->"9eff4bf2-b09b-41a2-97cf-\
21c199e631d0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.766823744363532*^9},ExpressionUUID->"7fac0424-bd23-4e3c-8759-\
8f2a7fa63388"]
}, Closed]],

Cell["The above eigenvalue is always between 0 and 1!", "Text",
 CellChangeTimes->{{3.769252027189336*^9, 
  3.7692520423662205`*^9}},ExpressionUUID->"f78be7c0-8b58-4f82-98ac-\
a9f8d46a4afe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "<", "1"}], "&&", 
     RowBox[{
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]], "<", "m", "<", "1"}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]], "<", "m", "<", "1"}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7668237359570475`*^9, 3.76682382434217*^9}, {
   3.766824028186145*^9, 3.7668240402745256`*^9}, 
   3.766828176769843*^9},ExpressionUUID->"95332b88-165a-41db-8472-\
678c0d4ced1b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.7668237382539873`*^9, 3.7668237580370455`*^9}, {
   3.766823788618185*^9, 3.7668238251234393`*^9}, 3.766824030326775*^9, 
   3.7668281789730577`*^9},ExpressionUUID->"82c4ff06-dba8-49f6-a796-\
3bb486af9b4d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "<", "1"}], "&&", 
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"1", ">", "s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"1", ">", "s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "<", "r", "<", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7668237359570475`*^9, 3.76682382434217*^9}, {
   3.766824028186145*^9, 3.7668240402745256`*^9}, 3.766828176769843*^9, 
   3.7692431597391186`*^9, {3.769251909860236*^9, 3.7692519677307153`*^9}, {
   3.7692520621844187`*^9, 
   3.769252073203314*^9}},ExpressionUUID->"248ab6c5-3f63-4856-8455-\
6afb3cc002e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "+", 
      RowBox[{"r", " ", "s"}]}], "\[LessEqual]", 
     RowBox[{"s", "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}]}]}]}], "&&", 
    RowBox[{
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], ">", 
     RowBox[{
      RowBox[{"2", " ", "s"}], "+", 
      RowBox[{"s", " ", "\[Alpha]"}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}]}]}], ")"}], "||", 
  RowBox[{
   RowBox[{"s", "+", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}]}]}], "<", 
   RowBox[{"r", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s"}], ")"}]}]}], "||", 
  RowBox[{
   RowBox[{"r", "+", 
    RowBox[{"r", " ", "s"}]}], "\[GreaterEqual]", "s"}]}]], "Output",
 CellChangeTimes->{
  3.7692431606497717`*^9, {3.7692519108579645`*^9, 3.769251925152196*^9}, 
   3.769251957284226*^9, 3.7692520416697116`*^9, 
   3.7692520760823774`*^9},ExpressionUUID->"b27b8c20-02fa-4045-b417-\
2b1043cbb598"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "<", "1"}], "&&", 
    RowBox[{"0", "<", "m", "<", 
     FractionBox["s", 
      RowBox[{"1", "+", "s"}]]}], "&&", 
    RowBox[{"1", ">", "s", ">", "0"}], "&&", 
    RowBox[{"\[Alpha]", ">", "0"}], "&&", 
    RowBox[{"0", "<", "r", "<", 
     RowBox[{"1", "/", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "m", ",", "\[Alpha]", ",", "r"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7692521351707306`*^9, 
  3.769252169496338*^9}},ExpressionUUID->"fcfb5680-4fc5-4aa3-a480-\
3d0efefffcd3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"m", "\[Rule]", 
     FractionBox["1", "16"]}], ",", 
    RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
    RowBox[{"r", "\[Rule]", 
     FractionBox["1", "4"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7692521941990404`*^9},ExpressionUUID->"4651fe26-e497-4177-8a5e-\
98451ca68dd7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], ">", "1"}], "&&", 
    RowBox[{"0", "<", "m", "<", 
     FractionBox["s", 
      RowBox[{"1", "+", "s"}]]}], "&&", 
    RowBox[{"1", ">", "s", ">", "0"}], "&&", 
    RowBox[{"\[Alpha]", ">", "0"}], "&&", 
    RowBox[{"0", "<", "r", "<", 
     RowBox[{"1", "/", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "m", ",", "\[Alpha]", ",", "r"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.769252189535697*^9},ExpressionUUID->"8bad1c97-00f7-4289-8328-\
dc34143fa021"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"s", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"m", "\[Rule]", 
     FractionBox["1", "16"]}], ",", 
    RowBox[{"\[Alpha]", "\[Rule]", 
     FractionBox["1", "16"]}], ",", 
    RowBox[{"r", "\[Rule]", 
     FractionBox["1", "4"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.769252191129841*^9},ExpressionUUID->"a54cc39b-b726-4eaf-a020-\
32789eda1170"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "s"}], "+", 
      RowBox[{"s", " ", "\[Alpha]"}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], "==", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}]}], ",", "r"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.766823844615526*^9, 
  3.7668238651942787`*^9}},ExpressionUUID->"9b1a70ff-f57c-4cfe-86fb-\
a8c6cf836504"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"r", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Alpha]", "-", 
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.775455641054247*^9},ExpressionUUID->"0bb6e551-4990-4b93-9a23-\
f0d8873e6063"]
}, Closed]],

Cell[TextData[{
 "Hence, equ00 is asymptotically (locally) stable if  and only if ",
 Cell[BoxData[
  RowBox[{"m", ">", 
   FractionBox["s", 
    RowBox[{"1", "+", "s"}]]}]],ExpressionUUID->
  "3005c35d-6479-487b-a8b2-63f36e60a51a"],
 ". Otherwise, it is a saddle with one or two stable directions."
}], "Text",
 CellChangeTimes->{{3.7668193511690173`*^9, 3.7668193547161055`*^9}, {
  3.7668193918324647`*^9, 3.7668193966950507`*^9}, {3.766828202361557*^9, 
  3.7668282680914936`*^9}, {3.7692447746803875`*^9, 3.769244781642421*^9}, {
  3.769252218554038*^9, 3.7692522373055153`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"eb0a081b-0cf3-4321-b3c6-9c9e733f3b24"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.4.2 Stability of the equilibrium equ1 (T2 absent, migration-selection \
balance at E)\
\>", "Subsection",
 CellChangeTimes->{{3.7754549111326523`*^9, 
  3.7754549505475464`*^9}},ExpressionUUID->"057607a0-6311-4f82-b41e-\
13126e42cebd"],

Cell[BoxData[
 RowBox[{"equ1", ":", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t22", "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"e22", "\[Rule]", 
      RowBox[{"1", "-", 
       FractionBox["m", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], "s"}]]}]}], "=", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], "s"}], "-", "m"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m"}], ")"}], "s"}]]}], ",", 
    RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}]], "Text",
 CellChangeTimes->{{3.7754549559464474`*^9, 
  3.775454957310466*^9}},ExpressionUUID->"f4568baa-7b9d-401d-a1df-\
2522dc05ef46"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "This", " ", "equilibrium", " ", "is", " ", "admissible", " ", "if", " ", 
   "and", " ", "only", " ", "if", " ", "m"}], "<", 
  FractionBox["s", 
   RowBox[{"1", "+", "s"}]]}]], "Text",
 CellChangeTimes->{{3.7668284898272905`*^9, 
  3.766828511374764*^9}},ExpressionUUID->"596db431-de5f-4d59-b643-\
b5cc9024591a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobsymCIequ1", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ1"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.7668227660708413`*^9, 3.76682276936775*^9}, {
   3.766828412755722*^9, 
   3.766828415710122*^9}},ExpressionUUID->"a368fd4d-3712-4dfe-91bc-\
a67b631f0676"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobsymCIequ1", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.766817420464999*^9, 3.766817422636921*^9}, {
  3.766822776305307*^9, 3.7668227764303107`*^9}, {3.766828422960362*^9, 
  3.76682842389785*^9}},ExpressionUUID->"030fc32c-7b1e-4af9-acd5-\
002c44bca52d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "s", "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "s"}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"s", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{"m", "-", "s", "+", 
         RowBox[{"m", " ", "s"}]}], ")"}], " ", "\[Alpha]"}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "s", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], 
     FractionBox["1", 
      RowBox[{"1", "-", "m", "+", "s", "-", 
       RowBox[{"m", " ", "s"}]}]], 
     FractionBox["\[Alpha]", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{"m", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m", "-", "s", "+", 
         RowBox[{"m", " ", "s"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "s", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.7668227770240655`*^9, 
  3.766828425039773*^9},ExpressionUUID->"fe08c0a1-da81-4634-b7d7-\
fde332f62dd7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"evalsequ1", "=", 
  RowBox[{"Eigenvalues", "[", "JacobsymCIequ1", " ", "]"}]}]], "Input",
 CellChangeTimes->{{3.766817390134531*^9, 3.766817399572656*^9}, {
  3.766818041015176*^9, 3.766818050406002*^9}, {3.766822795729498*^9, 
  3.766822795885732*^9}, {3.7668228341785355`*^9, 3.7668228343347883`*^9}, {
  3.7668284352119317`*^9, 
  3.7668284376807656`*^9}},ExpressionUUID->"345f911a-33c2-49fd-b3f8-\
ccf61a69e2a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "s"}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"4", " ", "s"}], "-", 
     RowBox[{"8", " ", "m", " ", "s"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["m", "2"], " ", "s"}], "-", 
     RowBox[{"2", " ", "r", " ", "s"}], "+", 
     RowBox[{"2", " ", "m", " ", "r", " ", "s"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s", "2"]}], "-", 
     RowBox[{"4", " ", "m", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", " ", "s", " ", "\[Alpha]"}], "-", 
     RowBox[{"4", " ", "m", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["m", "2"], " ", "s", " ", "\[Alpha]"}], "-", 
     RowBox[{"r", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{"m", " ", "r", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "-", 
     RowBox[{"2", " ", "m", " ", 
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "m", " ", "r"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", "r"}], "+", 
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"2", " ", "r", " ", "s"}], "-", 
        RowBox[{"6", " ", "m", " ", "r", " ", "s"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "s"}], "+", 
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["s", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["s", "2"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "s", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"4", " ", "s"}], "-", 
     RowBox[{"8", " ", "m", " ", "s"}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["m", "2"], " ", "s"}], "-", 
     RowBox[{"2", " ", "r", " ", "s"}], "+", 
     RowBox[{"2", " ", "m", " ", "r", " ", "s"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s", "2"]}], "-", 
     RowBox[{"4", " ", "m", " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", " ", "s", " ", "\[Alpha]"}], "-", 
     RowBox[{"4", " ", "m", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["m", "2"], " ", "s", " ", "\[Alpha]"}], "-", 
     RowBox[{"r", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{"m", " ", "r", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "-", 
     RowBox[{"2", " ", "m", " ", 
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "s", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "m", " ", "r"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", "r"}], "+", 
        SuperscriptBox["r", "2"], "+", 
        RowBox[{"2", " ", "r", " ", "s"}], "-", 
        RowBox[{"6", " ", "m", " ", "r", " ", "s"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "s"}], "+", 
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["s", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["s", "2"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "s", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "s"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.7668174001976695`*^9, 3.766817427727903*^9}, {
   3.7668180442027445`*^9, 3.7668180511872735`*^9}, 3.766822797323225*^9, 
   3.766822835116068*^9, 3.76682843911829*^9, 
   3.767000563511228*^9},ExpressionUUID->"72ccd521-9ec5-446c-9a45-\
d49f1d11084c"]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"The", " ", "first", " ", "eigenvalue", " ", "is"}], " ", "<", 
  RowBox[{"1", " ", "if", " ", "and", " ", "only", " ", "if", " ", "m"}], "<", 
  FractionBox["s", 
   RowBox[{"1", "+", "s"}]]}]], "Text",
 CellChangeTimes->{{3.766828451932253*^9, 3.7668284843887577`*^9}, 
   3.7668285224861345`*^9},ExpressionUUID->"fad9c1ca-1c49-44ed-8600-\
7862997fe204"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", "m", " ", "r"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["m", "2"], " ", "r"}], "+", 
       SuperscriptBox["r", "2"], "+", 
       RowBox[{"2", " ", "r", " ", "s"}], "-", 
       RowBox[{"6", " ", "m", " ", "r", " ", "s"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["m", "2"], " ", "r", " ", "s"}], "+", 
       SuperscriptBox["s", "2"], "-", 
       RowBox[{"2", " ", "m", " ", 
        SuperscriptBox["s", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["m", "2"], " ", 
        SuperscriptBox["s", "2"]}]}], ">", "0"}], "&&", 
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766828541739029*^9, 3.766828634653294*^9}, 
   3.7668286707190485`*^9},ExpressionUUID->"b07670cc-4723-48f8-a8ac-\
084f80349ca0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.766828602165242*^9, 3.7668286359501905`*^9}, 
   3.7668286730628643`*^9},ExpressionUUID->"613f8e2b-b24e-4ade-8f02-\
aab4e029e814"]
}, Closed]],

Cell["Therefore, all eigenvalues are real", "Text",
 CellChangeTimes->{{3.7668286805786514`*^9, 
  3.7668286948771505`*^9}},ExpressionUUID->"319fe903-2e69-4c8b-a906-\
c90508b877f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"evalsequ1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ">", 
      RowBox[{"evalsequ1", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], "&&", 
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.766828707439904*^9, 
  3.766828742814171*^9}},ExpressionUUID->"0df64595-47b3-49a5-8c71-\
ccb97f1aae5c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.767000567636349*^9},ExpressionUUID->"9c78d51f-459c-46d9-a911-\
5c03f77789da"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"1", ">", 
      RowBox[{"evalsequ1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ">", 
      RowBox[{"evalsequ1", "[", 
       RowBox[{"[", "3", "]"}], "]"}], ">", "0"}], "&&", 
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"0", "<", "m", "<", 
      FractionBox["s", 
       RowBox[{"1", "+", "s"}]]}], "&&", 
     RowBox[{"s", ">", "0"}], "&&", 
     RowBox[{"\[Alpha]", ">", "0"}], "&&", 
     RowBox[{"0", "\[LessEqual]", "r", "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7668287953129387`*^9, 3.7668287999380465`*^9}, 
   3.7668288505823793`*^9},ExpressionUUID->"d5838be1-5955-467c-84b4-\
a1222470471c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.766828811236028*^9, {3.766828851707388*^9, 
   3.7668288574106474`*^9}},ExpressionUUID->"1e6b1010-1351-4e5f-b261-\
2b57bebd39ec"]
}, Closed]],

Cell["\<\
This can also be shown by studying the characteristic polynomial!\
\>", "Text",
 CellChangeTimes->{{3.766828868202651*^9, 
  3.766828891815003*^9}},ExpressionUUID->"ba96945a-a361-4950-86a0-\
8fa9b4d3c4c9"],

Cell[TextData[{
 "Hence, if equ1 is admissible, which it is if ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"m", "<", 
    FractionBox["s", 
     RowBox[{"1", "+", "s"}]]}]}]],
  CellChangeTimes->{{3.766817701608747*^9, 3.766817741966297*^9}},
  ExpressionUUID->"aa00817e-82e6-498e-8fad-6d9c8653a924"],
 ", then it is asymptotically (locally) stable!"
}], "Text",
 CellChangeTimes->{{3.7668193511690173`*^9, 3.7668193547161055`*^9}, {
  3.7668193918324647`*^9, 3.7668193966950507`*^9}, {3.7670005482295556`*^9, 
  3.767000548995202*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"98b1702f-300d-47cd-a19e-982d501ca4a4"],

Cell[BoxData[
 RowBox[{"Therefore", ",", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"there", " ", "is", " ", 
     StyleBox[
      RowBox[{
      "always", " ", "an", " ", "equilibrium", " ", "with", " ", "t22"}],
      FontWeight->"Bold"]}], 
    StyleBox["=",
     FontWeight->"Bold"], 
    StyleBox[
     RowBox[{"0", " ", "that", " ", "is", " ", "locally", " ", "stable"}],
     FontWeight->"Bold"]}], ";", " ", 
   RowBox[{
    RowBox[{"it", " ", "is", " ", "either", " ", "t22"}], "=", 
    RowBox[{"e22", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"0", " ", 
        RowBox[{"(", 
         RowBox[{"swamping", " ", "by", " ", "the", " ", "continent"}], ")"}],
         " ", "or", " ", "the", " ", "migration"}], "-", 
       RowBox[{"selection", " ", "balance", "  ", "e22"}]}], "=", 
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{
         FractionBox["m", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m"}], ")"}], "s"}]], "with", " ", "t22"}]}], 
       "=", "0."}]}]}]}]}]}]], "Text",
 CellChangeTimes->{{3.767000691023988*^9, 3.7670007689090633`*^9}, {
  3.7670008338253803`*^9, 3.767000841013096*^9}, {3.7746993372376122`*^9, 
  3.7746993414356155`*^9}, {3.7746994571604247`*^9, 3.7746994696593695`*^9}, {
  3.7754546618934965`*^9, 3.7754546629872684`*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"da98582d-8e53-49b8-a5a1-fa2ecdd1d69a"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.4.3 Stability of the equilibria equ2 and equ3 (T polymorphic, E2 absent)\
\>", "Subsection",
 CellChangeTimes->{{3.775454751107896*^9, 3.775454790236844*^9}, {
  3.7754548335397415`*^9, 
  3.775454886212017*^9}},ExpressionUUID->"74b2b070-d535-4329-aea2-\
1929f8e4b320"],

Cell[BoxData[
 RowBox[{
  RowBox[{"equ2", ":", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        SqrtBox[
         RowBox[{"\[Alpha]", "-", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"9", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"33", " ", "\[Alpha]"}], "+", 
             RowBox[{"20", " ", 
              SuperscriptBox["\[Alpha]", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m", "-", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
  RowBox[{"equ3", ":", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        SqrtBox[
         RowBox[{"\[Alpha]", "-", 
          RowBox[{"2", " ", "m", " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"9", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["m", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"16", "+", 
             RowBox[{"33", " ", "\[Alpha]"}], "+", 
             RowBox[{"20", " ", 
              SuperscriptBox["\[Alpha]", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m", "-", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}]}]], "Text",
 CellChangeTimes->{
  3.775454806568499*^9},ExpressionUUID->"7d2c6856-62bd-419e-a087-\
666ce3d3a10e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
     "Recall", " ", "that", " ", "equ2", " ", "and", " ", "equ3", " ", 
      "exist", " ", "if", " ", "and", " ", "only", " ", "if", " ", "0"}], " ",
      "<", "m", "<", "mcrit"}], "=", 
    FractionBox[
     RowBox[{"8", "+", 
      RowBox[{"9", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}], "-", 
      RowBox[{"4", " ", "\[Alpha]", " ", 
       SqrtBox[
        RowBox[{"1", "+", "\[Alpha]"}]]}]}], 
     RowBox[{"16", "+", 
      RowBox[{"33", " ", "\[Alpha]"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["\[Alpha]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Alpha]", "3"]}]}]]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"which", " ", "requires", " ", "m"}], "<", " ", 
     RowBox[{"N", "[", 
      RowBox[{"mcrit", "/.", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", "\[Rule]", 
         RowBox[{
          FractionBox["1", "3"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"54", "-", 
               RowBox[{"6", " ", 
                SqrtBox["33"]}]}], ")"}], 
             RowBox[{"1", "/", "3"}]], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 SqrtBox["33"]}], ")"}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "}"}]}], "]"}]}], "=", 
    " ", 
    RowBox[{
     RowBox[{"0.0326211", ".", "\[IndentingNewLine]", "For"}], " ", "given", 
     " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{
    "the", " ", "equilibria", " ", "exist", " ", "and", " ", "are", " ", 
     "admissible", " ", "precisely", " ", "in", " ", "an", " ", 
     RowBox[{"interval", " ", "[", 
      RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "]"}], " ", "which", " ", "is",
      " ", "obtained", " ", "by", " ", "solving", " ", "m"}], "=", 
    RowBox[{"mcrit", " ", "for", " ", 
     RowBox[{"alpha", ".", " ", "\[IndentingNewLine]", "This"}], " ", 
     "interval", " ", "contains"}]}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{"\[Alpha]_crit", "=", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"54", "-", 
         RowBox[{"6", " ", 
          SqrtBox["33"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"6", " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           SqrtBox["33"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}]}], "=", 
   RowBox[{"2.38298", "."}]}]}]}], "Text",
 CellChangeTimes->{{3.7664132290178947`*^9, 3.766413239658518*^9}, {
  3.7664132876619673`*^9, 3.766413292200221*^9}, {3.7664133333397465`*^9, 
  3.766413338726601*^9}, {3.766413506337886*^9, 3.766413542148568*^9}, {
  3.7664136205618367`*^9, 3.7664136488901634`*^9}, {3.7668226364158*^9, 
  3.766822641634561*^9}, {3.769759442470133*^9, 3.769759444458598*^9}, {
  3.7697608900944843`*^9, 3.769760890748252*^9}, {3.7746164808238764`*^9, 
  3.7746164841292343`*^9}, {3.7747856788462644`*^9, 3.774785726014017*^9}, {
  3.774787919750022*^9, 3.7747879979719725`*^9}, {3.7747880413750315`*^9, 
  3.7747880498551197`*^9}},ExpressionUUID->"09725f7e-5c96-4403-8702-\
efed14aab0e8"],

Cell["\<\
We note that the following stability analysis of the equilibria equ2 and equ3 \
is more general than in Appendix S1 of Servedio and B\[UDoubleDot]rger \
(2015), because here stability is studied in the two-locus case (with E \
present and linked).\
\>", "Text",
 CellChangeTimes->{{3.7749615985319815`*^9, 
  3.7749617469392047`*^9}},ExpressionUUID->"4cba6b8c-258a-45bb-b2c5-\
6d7daab4c748"],

Cell[BoxData[
 RowBox[{
  RowBox[{"To", " ", "simplify", " ", "expressions"}], ",", " ", 
  RowBox[{"we", " ", "write", " ", "Q", " ", "for", " ", 
   SqrtBox[
    RowBox[{"\[Alpha]", "-", 
     RowBox[{"2", " ", "m", " ", 
      RowBox[{"(", 
       RowBox[{"8", "+", 
        RowBox[{"9", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"16", "+", 
        RowBox[{"33", " ", "\[Alpha]"}], "+", 
        RowBox[{"20", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]], "and", " ", 
   "define"}]}]], "Text",
 CellChangeTimes->{{3.77478237296084*^9, 3.774782407288406*^9}, {
  3.774788081797958*^9, 
  3.774788083328052*^9}},ExpressionUUID->"92546cbf-8e76-4837-911e-\
08a00719b388"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"equ2Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", "Q"}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m", "-", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"equ3Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t22", "\[Rule]", 
      FractionBox[
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "m"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", "Q"}], 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m"}], ")"}], " ", 
        SqrtBox["\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "m", "-", 
          RowBox[{"m", " ", "\[Alpha]"}]}], ")"}]}]]}], ",", 
     RowBox[{"e22", "\[Rule]", "0"}], ",", 
     RowBox[{"dd2", "\[Rule]", "0"}]}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.774782417171477*^9, 3.7747824501681004`*^9}, {
  3.7747825943642893`*^9, 
  3.7747826016554956`*^9}},ExpressionUUID->"0fa1dc56-1775-4a22-a050-\
7ce2c568a69e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQnum", "[", 
   RowBox[{"\[Alpha]_", ",", "m_"}], "]"}], ":=", 
  SqrtBox[
   RowBox[{"\[Alpha]", "-", 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"9", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["m", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"16", "+", 
       RowBox[{"33", " ", "\[Alpha]"}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox["\[Alpha]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}]]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.774782321319909*^9, 3.774782367185711*^9}, {
  3.785239610203599*^9, 
  3.78523961277313*^9}},ExpressionUUID->"8ffa29f3-e7d0-46eb-9cf4-\
4b1aa5d0b919"],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobsymCIequ2Q", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ2Q"}], "]"}]}], ";", 
  RowBox[{"JacobsymCIequ3Q", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ3Q"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7747826188278*^9, 3.774782622108156*^9}, {
  3.7747870113467836`*^9, 
  3.7747870214210033`*^9}},ExpressionUUID->"21179c75-7056-4fc8-943a-\
92274495d16f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"JacobsymCIequ2", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JacobsymCIequ3", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"itpseudomCI", "[", 
         RowBox[{"s", ",", "\[Alpha]", ",", "\[Alpha]", ",", "m", ",", "r"}], 
         "]"}], "[", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t22", ",", "e22", ",", "dd2"}], "}"}], "}"}]}], "]"}], "/.",
      "equ3"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.766817262994308*^9, 3.76681734116446*^9}, 
   3.766817411167926*^9, {3.766822585675943*^9, 3.7668225887084985`*^9}, {
   3.7692461839407053`*^9, 
   3.7692461908056293`*^9}},ExpressionUUID->"fed76fe6-446e-46cf-b7ed-\
f1a40ecf848e"],

Cell["\<\
The eigenvalues can be computed explicitly because for both equilibria the \
characteristic polynomial factorizes into a linear and a quadratic \
polynomial. The quadratic polynomial is very complicated and depends on r; \
the linear term is independent of r. \
\>", "Text",
 CellChangeTimes->{{3.7746165895113573`*^9, 3.774616633404073*^9}, {
   3.774787850957778*^9, 3.774787900793439*^9}, 3.7747907182731495`*^9, {
   3.7853332756300535`*^9, 
   3.785333333591714*^9}},ExpressionUUID->"3f3b5c86-143b-450c-b507-\
0a37668186e6"],

Cell[CellGroupData[{

Cell["3.4.3a equ2 is unstable", "Subsubsection",
 CellChangeTimes->{{3.7855081195593767`*^9, 3.7855081477651777`*^9}, {
  3.7855082987755194`*^9, 
  3.785508313134285*^9}},ExpressionUUID->"0df86a59-7187-4a63-b25b-\
7ac916b85fb8"],

Cell["Here is the first eigenvalue of equ2 :", "Text",
 CellChangeTimes->{{3.7747907790556602`*^9, 
  3.774790794346588*^9}},ExpressionUUID->"868f605a-fa8e-4fe5-b883-\
ac60165fd821"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev1equ2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Eigenvalues", "[", "JacobsymCIequ2Q", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7747875047538557`*^9, 
  3.774787554722612*^9}},ExpressionUUID->"f40c051b-fcc7-4688-b066-\
3aba6d50d878"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"256", "+", 
        RowBox[{"272", " ", "\[Alpha]"}], "+", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"16", " ", "\[Alpha]"}], "+", 
           SuperscriptBox["\[Alpha]", "2"]}], ")"}]}], "+", 
        RowBox[{"4", " ", "Q", " ", 
         SqrtBox["\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"24", "+", 
           RowBox[{"16", " ", "\[Alpha]"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["m", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"256", "+", 
           RowBox[{"1296", " ", "\[Alpha]"}], "+", 
           RowBox[{"2816", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"3353", " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"2320", " ", 
            SuperscriptBox["\[Alpha]", "4"]}], "+", 
           RowBox[{"920", " ", 
            SuperscriptBox["\[Alpha]", "5"]}], "+", 
           RowBox[{"192", " ", 
            SuperscriptBox["\[Alpha]", "6"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "m", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "256"}], "-", 
           RowBox[{"528", " ", "\[Alpha]"}], "+", 
           RowBox[{
            SuperscriptBox["Q", "3"], " ", 
            SuperscriptBox["\[Alpha]", 
             RowBox[{"3", "/", "2"}]]}], "-", 
           RowBox[{"392", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "-", 
           RowBox[{"121", " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["\[Alpha]", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["Q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"24", "+", 
              RowBox[{"40", " ", "\[Alpha]"}], "+", 
              RowBox[{"17", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "-", 
           RowBox[{"Q", " ", 
            SqrtBox["\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"72", "+", 
              RowBox[{"96", " ", "\[Alpha]"}], "+", 
              RowBox[{"41", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"256", "+", 
           RowBox[{"1040", " ", "\[Alpha]"}], "+", 
           RowBox[{"1752", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"1537", " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"724", " ", 
            SuperscriptBox["\[Alpha]", "4"]}], "+", 
           RowBox[{"172", " ", 
            SuperscriptBox["\[Alpha]", "5"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["\[Alpha]", "6"]}], "+", 
           RowBox[{"Q", " ", 
            SqrtBox["\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"24", "+", 
              RowBox[{"64", " ", "\[Alpha]"}], "+", 
              RowBox[{"59", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["\[Alpha]", "3"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1536", "+", 
           RowBox[{"4704", " ", "\[Alpha]"}], "+", 
           RowBox[{"5664", " ", 
            SuperscriptBox["\[Alpha]", "2"]}], "+", 
           RowBox[{"3270", " ", 
            SuperscriptBox["\[Alpha]", "3"]}], "+", 
           RowBox[{"880", " ", 
            SuperscriptBox["\[Alpha]", "4"]}], "+", 
           RowBox[{"88", " ", 
            SuperscriptBox["\[Alpha]", "5"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["Q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"24", "+", 
              RowBox[{"64", " ", "\[Alpha]"}], "+", 
              RowBox[{"57", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["\[Alpha]", "3"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", "Q", " ", 
            SqrtBox["\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"72", "+", 
              RowBox[{"144", " ", "\[Alpha]"}], "+", 
              RowBox[{"97", " ", 
               SuperscriptBox["\[Alpha]", "2"]}], "+", 
              RowBox[{"32", " ", 
               SuperscriptBox["\[Alpha]", "3"]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"Q", " ", 
          SqrtBox["\[Alpha]"]}], "+", "\[Alpha]", "-", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"5", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"Q", " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"3", " ", "\[Alpha]"}], "+", 
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"7", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], "2"]}], 
     ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.7747875595130215`*^9},ExpressionUUID->"6ecda468-0f61-4164-b6d7-\
26b0d894b02f"]
}, Closed]],

Cell["\<\
At the boundary of the interval, where equ2 exists, this eigenvalue is 1 :\
\>", "Text",
 CellChangeTimes->{{3.7747908766110845`*^9, 
  3.774790904894346*^9}},ExpressionUUID->"9428f031-1d93-4a3d-8c45-\
274998060212"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ev1equ2", "/.", 
    RowBox[{"Q", "\[Rule]", 
     RowBox[{"SQnum", "[", 
      RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], "/.", 
   RowBox[{"m", "\[Rule]", 
    RowBox[{"mcrit", "[", "\[Alpha]", "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7747909084228487`*^9, 
  3.7747909285032215`*^9}},ExpressionUUID->"746514a1-cc90-4a7c-8cd9-\
024251a44f08"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.7747909295129595`*^9},ExpressionUUID->"d2e5eb08-120a-4eab-a25f-\
48f69dc40ae8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ev1equ2", "/.", 
    RowBox[{"Q", "\[Rule]", 
     RowBox[{"SQnum", "[", 
      RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], "/.", 
   RowBox[{"\[Alpha]", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{3.774791003914199*^9, 
  3.77479111479453*^9},ExpressionUUID->"22e9ac71-f4cf-441c-97ea-41602c1825db"],

Cell[BoxData[
 FractionBox[
  RowBox[{"16", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1095", " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"190", "-", 
        RowBox[{"119", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"38", " ", "m"}], "+", 
           RowBox[{"73", " ", 
            SuperscriptBox["m", "2"]}]}]]}]}], ")"}]}], "-", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"23", "+", 
        RowBox[{"7", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"38", " ", "m"}], "+", 
           RowBox[{"73", " ", 
            SuperscriptBox["m", "2"]}]}]]}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["m", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1304"}], "+", 
        RowBox[{"51", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"38", " ", "m"}], "+", 
           RowBox[{"73", " ", 
            SuperscriptBox["m", "2"]}]}]]}]}], ")"}]}], "+", 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{"232", "+", 
        RowBox[{"89", " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"38", " ", "m"}], "+", 
           RowBox[{"73", " ", 
            SuperscriptBox["m", "2"]}]}]]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"11", " ", "m"}], "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"38", " ", "m"}], "+", 
        RowBox[{"73", " ", 
         SuperscriptBox["m", "2"]}]}]]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "7"}], "+", 
      RowBox[{"13", " ", "m"}], "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"38", " ", "m"}], "+", 
        RowBox[{"73", " ", 
         SuperscriptBox["m", "2"]}]}]]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.7747911157251916`*^9},ExpressionUUID->"8f6f21f6-8b0a-4e24-b28e-\
02d5c139d79e"]
}, Closed]],

Cell["\<\
For small values of m, this eigenvalue is always greater than 1:\
\>", "Text",
 CellChangeTimes->{{3.7747911848586617`*^9, 
  3.7747912385761013`*^9}},ExpressionUUID->"57741ada-7e78-4821-94e4-\
fa9d4507edc0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"ev1equ2", "/.", 
     RowBox[{"Q", "\[Rule]", 
      RowBox[{"SQnum", "[", 
       RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7747911536113005`*^9, 
  3.7747911730722275`*^9}},ExpressionUUID->"998c8960-5222-4625-ad0a-\
6ababcf73ea9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", "\[Alpha]"}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", "m"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 
   0, {(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha])^(-2) (
     4 + $CellContext`\[Alpha]), -(
     1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha])^(-2) (
     4 + $CellContext`\[Alpha])}, 0, 2, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.774791174047927*^9},ExpressionUUID->"feed1a2d-7934-434e-bda4-\
7c8c8eb07479"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "\[Alpha]"}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"]], ">", "1"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.774699857433855*^9, 
  3.774699886658766*^9}},ExpressionUUID->"3e49dc54-c4f0-4fc1-8162-\
de5ee3b4641f"],

Cell[BoxData[
 RowBox[{"\[Alpha]", ">", "0"}]], "Output",
 CellChangeTimes->{{3.7746998738746347`*^9, 3.7746998874753494`*^9}, 
   3.774791603311977*^9},ExpressionUUID->"e0d47bab-d258-47bc-a1da-\
9052d953c8eb"]
}, Closed]],

Cell["\<\
Indeed, the following graphs show that ev1equ2 > 1 whenever equ2 is \
admissible :\
\>", "Text",
 CellChangeTimes->{{3.7747912411429377`*^9, 3.7747912873660173`*^9}, {
  3.7747913736657677`*^9, 
  3.774791379120677*^9}},ExpressionUUID->"06753f9c-b158-4880-babe-\
9a130df3ac5b"],

Cell["For m = 0.01, the relevant interval is:", "Text",
 CellChangeTimes->{{3.7747900801979666`*^9, 3.7747901073291817`*^9}, {
  3.7747912973521643`*^9, 
  3.7747912996328115`*^9}},ExpressionUUID->"a11b60c4-5837-43ce-9a89-\
aa42fafdebed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mcrit", "[", "\[Alpha]", "]"}], "\[Equal]", "0.01"}], ",", 
    "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7692504074367127`*^9, 3.7692504783955736`*^9}, {
  3.769256270498688*^9, 
  3.769256271091116*^9}},ExpressionUUID->"a34029d5-90b2-4120-b12b-\
b465306c6093"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0.19413238678496728`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "33.00873279249816`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.7692504330390635`*^9, 3.7692504790930886`*^9}, 
   3.769256271801632*^9},ExpressionUUID->"848504bc-8a7e-4bc8-9681-\
4e738312e52e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"ev1equ2", "/.", 
       RowBox[{"Q", "\[Rule]", 
        RowBox[{"SQnum", "[", 
         RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], "/.", 
      RowBox[{"m", "\[Rule]", "0.01"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "35"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.99", ",", "1.12"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.77478725642914*^9, 3.7747873187237186`*^9}, 
   3.774787610188287*^9, {3.774791418562786*^9, 
   3.774791467762995*^9}},ExpressionUUID->"faff563a-13ee-4f7e-922f-\
5d022df987ff"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV13c4VX8YAPBrRpklW5KsKET9JHnfyK0oIWkqIy3ZEhpGSqWQyoqyiVIR
GdEgpGElJStkxzm4mfH79sd9zvN5nnvOe859x32PnJ2LhQM7g8GYIJ9/R6pv
6lVcWxV8rzv0yJabgt7FMc1rpKpB5L+CqnvqFIgqfEv67fsBztlLMvsNKTD6
T8zxUfNHSPP89Wfdbgo8t1tpOep+hm2B5R6iNhQkH7w7oxJbA100iPo6UtC/
fsB2/HwtRNvekvp6hgLGa96KBrU6YD+sF+zkR4H4dpVVuS118OH93eunrlKw
7eCJUTe9BogNMH82F02BTXewlflQAygkfy0tSKDgrFN6kUbcF0j+kc1akUFB
ml9P4MhMIzyoaFZUyaeglIe793PWV1D1PlJd95KCxlsKJtkHm+B+9+7nW8oo
4Ew5usSp+Bto8AldiK6hwL6qM3nA9wekjwyUMXso8DVn56le1QKQr5h2d5CC
iGa50w+bW8Dti/H3txQFb4dstE/otoG+bNSzkmkKwq+6dI6e74AnFy2D9vDT
IL3T707nlw4YPx62p0CYhgzhMGa92k/Y5aHPYBel4VVsduazlp/Q5GbasWMZ
DcOPfru76nWBgrbnpYbVNOysc+QYnvkFx5PUJOW20/D112Ejw4M9oFmsNHlu
Bw2Hp82Do4t6wKkj165sFw2u8jqLDH16gfV7YbGEFQ0RZziXRP/pA/mtVApl
S4Pk9QnL33v6IbbpufbLozQk3x+INMjrh7fMUw/PHqfheWWt5G+PAQhMDXny
6jSJJxG/woAehE6z1nvxXiTemvCjUWZDsOyKcSPtTUOvwaW0oSdDcOyWSKjO
ORomHU+uinL+DTKFzgn3/WiQKl23dmhwGMwyI+u+BNOQUq/sudlkBFLduuPL
r9Gg1iuVH5k5AoObZuczQmiQ5WGLT9CmgKMzwc0sjAYNzd7lJmMUbDivrLE8
kgbP4o43rBU0JAnz/iiKoqHAqNkuwYLcp79TrUkMDZsPfEphPaPB9MAea/M4
Giwu5SonuI7CY0UJESqRhkj+x++NE0ZhzGVI3SCZhuaotFOsmlHgFi2fD0mh
wf5RzCNj9TGYKrppvSCdxGv002D9HoPOWpZpYhaJd8Sn7oHMOIReGjXNe0TD
bL+7u/HOcTBo49R8+5iGy3MOzx88GoeIUi/5yickntIOHWNHFuiIHLAIyCXx
nhl9H49lwYCu7NSR5+R59cD3QTULVJ7p+evkkfowW/tyXOUPCMx4JDXl01Do
I44P+v6ATp7SxrpCGkJrd2yUWzoBsp4ttl5FNNgpBaxP3jwBbh9EhkSLaeBr
7FdLj50A3y0lvsYvafipukxZpXIC6hjiaa3E+YEW8lljEzCdWBN4uoQGG41i
iSc7JiHkxLbYC6U0rAseEdH0mQSr6lVT88QL2+SFclMnQVvnqfnFV6Q+Qm5w
v5ibBK9iK22X1zTw9FqPlT6dAo93n8Pk39LQuiliGFunwDDu481g4pw7Ff1v
eafBvoFvQR/xIQP1jgq7aSixfJd2v4wGzRj7H9vCpqEXTAfGibmpqK/VxdMw
dWVT19ZyGp7GMz59FpmBa1OZat3El8e1q8w2z8Bue73o1e9oOGBysqzeaQZc
Za1HPIg5p+oKv1bMwNRI9+0J4u+7uPP2jc0Az5Vr09oVNGSn6T5tlp2Fszm6
fi7E+yyT09q8Z8FIoHNxC/HqrKZEm1RisaMbBCppYGfni++sm4XMs3yPNxE3
7cPoo3OzcG9AzucU8aMnnrd7Vv0Fc8GijDvEAdwPQ0/s/QuvDxYxXxJbWbde
G7j0F2Z4v1v/JGYsYvoPt/yFmFx7uZVVNDTa+p5z5Z0De+59nZuJMwuyvUbX
zUHc8gtG1sR+gl1unnZzELkl09KL2PKYmNOf0Dnwun9D4iaxSonJCe/iOWAK
ZsQnEs8t8bef7p2D+rG9A7nE9aeeHz4vMg+/e2p4yonT3/Ttn8N5eO8nzV5P
fF5cZo+/0zwI861sbyU2czE3Y4+dB2VmekYvsULFZZOginlwXWBwfIR4WrqI
yT02D3V/HOVZxH0bJpaXCzLwppbPr0liC4dby7gUGRg4G5s3TfwyXFWaqcfA
7t0d9/5Z6eU7iWALBp59sD7h3/cjeo+IVZ1gYJTRqepx4tnF0yK8fgz8wVRa
8S/eMf07i43vMjDyy1T2v/upO7lGKCSLgWrdpt5txHp3q/g/vmHgjVeelxuI
017bLeL/xsDjEfdaK4iFhmZ5TIcZ+G68MbiA+JxYFHcYJxtmuEuEZBC//hRl
aCPJhqsD04yjiLmDov01NdiwoyTGP4jYRDemhJ3JhrSzlpYrcTgVM91wkA3/
dsSeOPAvf2mx/6W6sSGrtk3RkFjS+p6nVzAbcjWzPFYRp7yPGxbPZUMrH7b6
cZL/fr941YEqNpyxcB5uIl6z/v6J4jY2fBD14GkhcUHSg07rhew4XbVdz4f4
47mkr0m27Kiu1sfVT+pTeG3yEs+z7Gg+gz1viK36ks2MbrKjc4VmZAxxh2Vq
dW8BO8a5bPM2ImatzihVE+JAw08a78NIP+h2Z8z8VeDAxwcKM48Q+8c+1KnZ
yIF9Et/81xAvXJCV43acA4cfLZR+T/ptWcfjtPxSDhS3WnJplPSnfWR2V/AX
Dsz2u3OxiDhjx5Pl+wc4sHiLa1gA8drCp7EzSznx0w0vBj/x1ojcUHTixOFu
y2AJ0v+uWwq9qqW4UFHVXYePzI83GeXMNm9udMxLlXMm84tbq7T3ajg3SvO6
+IkTG5e8uKqVwY31vFN6b8m8q6/LrL7axI0ioh5dS4i7p8NNtdYvwPk/NhpP
C8j5O62tro4twKkKeZ0aMk+NaZbDWmdenLf9blVA5nHDBqXLV+z58LtOc19q
Eg0Xst24bo4LoVZMUS0P+T+agFNbL40uQY1tNaLvnGh4p6btFdApiuzbcWmu
JQ3xnZnbWA8k8NWg1kIVoOGguF7s3WhpXOTyfmWjCg0rxXzDsg7L4pJJnbf5
YjQkFJQXHF0kh8383N/PLaAhMXV/P+/lFVhWpOZ5aoICpYnywZO/5HH60+Vf
+f0UJFwtWW1jr4BSHxxMpFsoKKtcduxAsyJmNl971072k9OOVq6COsq4YZuR
yP53FPDskio6kKuCdeZ5itVFFKhE5TfaLFVFA/2tVunPKNgk267x944aQtzG
5x5kP5qxdA2M51+DuWrte/jI/qQ/0pQ6eVodUy0ow3yyXxUfPcbJ8tTA2zxa
4niLAgnOj8s+KGqi8gJ/kdzrFOyYdtCWb9TERT3ZHxKCKPAJrzjJjFiL4f3m
ig4XKejbt5in0kAL+5M1b3V4U2D+ZmXFYnZtPKWyV0fDg4Iwf0e/jhJtvNPi
3dzqRIGge3ziIqd1aF1wIVz6JAXXOCK72FTXY7S9ULnSUQqYlT6he1rW44sV
93Y+O0LBt5+3tFWv/4fW4nK/3A+SfS3OdfoDUwc7K+VEJqwo0Lymq1L9Rwfr
Tru3t1lQMLn0w9nbeRuwVFfmgp8pBeyNTPWi47p4zFJ92M2Ygp8Df37aiW7E
kJKdX7yYFBQmOD3/2rARe3Vk40QNKPhytWYkPUgPz3/ijOjaRPZXoUnjLVs2
4ZWkS4kyGyhoGLFMtGPoowSPAqcA2VvmGfE2bU/0ccg0N6hiDQXlGyXON+Xo
41ZLL/ox8VWvu1G1efr47THvzrvEi4dufn5brI/5r0Zr7IlXNl3US68kHuqZ
n19N9t/HNuKu7fo4u5OvXZs4Yv/KWjZBQDG6ZFWYKgVWdxIGp4UBFaoNhTyJ
pWqkF4yLAI7Wv2/dR5yyZal+jyRggP8b9RXEL9S5H1UrAmrP3EzPXUVBC1df
8G19wKCjsil1KhQo5GSBgjOgEMcOzwklCnJiPtQOugJ2+TpUNBNjwKBtjgdg
s8fLqRLiQ2aqQeAD6Lcnlj2IOGI4s2p/EOBZh7FbAsRzqzLNQ2MBra4FbpVR
JPlLzrCfqADUfV1+V2YlBcdCqsZL3gPGLp9TmpWnYMy973LQR8CEoPTrzcQC
BsoZwvWAZfv2l0YSG3WkD6m2AsoxUt/zEedIp5+xGQN0z3uRMyxHQUV1fVm3
IOJhS4l7gbIU6CrtF9osjNh8W2rtAeInl9oPxS9GzHLn8dEkjtYbYu1Zihjr
wC/UvoyCU9lcypWSiA+5UjTXEwtE6Nx4qIC44OuLoHppCgKHS79xKSHGkf0n
hXjC2EjBThmR37nT7QxxB4dFqaQqYnAShIgS55xxpEI0EC+Ifmm3kCL52n/f
0nkjon1SVstTCQqq81YmVush7hXrqvQhhsVZvxX1ETMENrAZECt/eHGlHRFl
6WpmrTgF03p1BWZMxI6hz8e6xChwjtnL9Xgr4vMEDoE04i5WqznvdsT1K+ar
jxN/zB4YeGOCuPtwjG2fKAX3l3PKaJkjftJxaG1ZSurvwvWTYRaI+ypp4Sji
4O9C+YO7EaNmEhhmxK4RMrtSrBAvXt/+qUSEAgPO/wKWHkIsqBKQCV5CQb5N
ySc3a8SF+b/l1hGrlhhKfj6M6PDn+IafiykQ8TLLvWKLyG1hsUKL+FfvyV8T
xxBHXBKjCoUoiK1Tr3I7gZjddVnDhNi0mJU5eJL8/l5Sld8EyfVDA1zbTyOy
Xm0z7BEg+fHeunu/MyKHUNkKB2JZO/71DS7keoeK+lr5SX+ti5mpcEe8szo4
t5CPAj3ZI23oiZjpWu0kSUzzKLwpOkPqw2hsu+si8r44OpCsfRZRzi9NoHAh
BQdanl7J9kasinqRTPOS/Fd4nVT2RWSWyAUsJS57orcj6RxiraLoVRkeCrxj
2NWlLyAmeeTs/Evel9UuVQlHXiT5Oxoqdo+L1MPp0HFBf8R17sqOmRwUnAvP
8REPQMyfX/LlOoOC/wEgk7H1
         "]]}},
      Annotation[#, "Charting`Private`Tag$127193#1"]& ], 
     TagBox[{
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQfUpv2tNV35fbMYDBB/tl9c+a3v++ag/j+17MZn73
+ymcv7NSwmH+i29wfrX4dLZ+FkYHGP/giiNu9yrY4PzLluqtbck8cH7tukLW
3i8CcP53+yz35k/CcP5RHZOyxkdicP7cR6s8vs6XhPOjJWxmTZ0hA+eriFf1
r46Th/MX7DiyI4VbEc5fuDTyJWerEpyv/v3I68ynygj1HXt1E5JV4fzDx+XS
om6pwfk52WEF/BYacD6Hv/SuqM2acL7m9G1XE0S14Xxb+fsGf6fowPm/Qwqa
5vLqwfl2768v/ZGjD+fvTklj+VpiAOdLspyRO61mCOf7/Eo1Ub6K4FdOOJbp
NskIzn8RIcRx3MkYzg88qHJMiMkEzu9vyK5/sBfB5y+au5A71xTO72Se9phR
2wzOdzte2Rd6B8G/8XCiiXaXOZyfPKfg12k3CzjfsNNK89Q3BP+H6OnyyVst
4Xymq276u9Kt4PyHr749TBKzhvN3Lsjdcu0ygn+l4/z75S02cP5LgR9eLi62
cP7l9yELkxjs4Pz/DHMT7q1H8FU3rbZXzbOH84+dunT4Cb8DnP/0eebT72kI
PkPok2kFRxF82+grf6bLOsL5ThbZv0/7Ifjuoky//tcj+ACCEPoI
         "]]}},
      Annotation[#, "Charting`Private`Tag$127193#2"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.99},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 34.99999928571429}, {0.99, 1.12}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7747873195052958`*^9, 3.7747876114862156`*^9, {3.774791432885016*^9, 
   3.774791468650608*^9}},ExpressionUUID->"c562c0da-0294-40c3-90be-\
2d11ad6a5e13"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mcrit", "[", "\[Alpha]", "]"}], "\[Equal]", "0.02"}], ",", 
    "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.774791337245726*^9},ExpressionUUID->"5fe481fb-7ce8-4fd0-8a58-\
35350a734473"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0.5082498903256554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "11.793990819491604`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7747914018328123`*^9},ExpressionUUID->"1887b615-b3b7-46dd-a205-\
5064eff3d0cd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"ev1equ2", "/.", 
       RowBox[{"Q", "\[Rule]", 
        RowBox[{"SQnum", "[", 
         RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], "/.", 
      RowBox[{"m", "\[Rule]", "0.02"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "12"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.99", ",", "1.1"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.774791397645938*^9, 3.7747914059697556`*^9}, {
  3.7747914875971684`*^9, 
  3.7747915095068445`*^9}},ExpressionUUID->"699d4d6e-3f02-4ed9-af9d-\
1639c8c4dea6"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV13c81V0YAPB7r5kRXisjK+59pYSGUTxHpKShkpWVFYWQkigiNCgZ2UQh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         "]]}},
      Annotation[#, "Charting`Private`Tag$127853#1"]& ], 
     TagBox[{
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/cM7b25A/gQ7BjD4YJ+/oOykv9o+exj/YE/Pbl+1
c3A+K1sR+8us+3C+Z31i69aw53D+9srUu0svvoPzb0Zl6xeVf4bzBd170w46
fIfzBa6kbjKP/g3nKyvkrGxN+g/nW9zNPe04idEB7p5fDT5XZjPD+Rn7T5zY
18QK589MXi4lmsAO5+tGPPz2L5UTzr/32f+cgyc3nP/pvqSBWCgvnD9hdVV6
eDg/nK/Gz+FbMVsAzt9W0LC6b74gnH9FdTJ74CQhOF+l+bJG7ExhON8y4L7J
/NkicP7dgla73h5ROH+TZSTv0YlicL5Y2PGbK1rF4Xz7RwwTD5VIIPwnlsGr
ViEJ5zfNy2w3zZKC8+eem3Gsr0Aazq/Nm/xBtkgGzn+dqCERmSQL53f/fcVy
L00Ozt/1xv09X5Q8nH9N1eKRlYoCIrw1k/UnL0XwD4ZFVzvKKcL5xhGvVoos
RPBzmt2u20orwfkdaRy/GCcj+HtlE/+/ElGG83f+a2PW6kPwz212ftUrqALn
H1VIO9YzCcFv2R668CGXKpwfo3QnLroXwf+9TV9am10Nzq9hfnlmah2CL6Zi
majKoA7nl+eFfeGqRPBFkvnLWvcg+BvDT3z//x/BBwAFVez9
         "]]}},
      Annotation[#, "Charting`Private`Tag$127853#2"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.99},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 11.99999975510204}, {0.99, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.774791407028511*^9, {3.774791495462797*^9, 
   3.774791510477561*^9}},ExpressionUUID->"da03aa11-805b-45c2-b747-\
831d8d91b6ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mcrit", "[", "\[Alpha]", "]"}], "\[Equal]", "0.001"}], ",", 
    "\[Alpha]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7747913469096427`*^9, 
  3.7747913469846897`*^9}},ExpressionUUID->"ccd3bdc5-1913-4f62-9aed-\
7aafea37bf8e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0.016277512581821283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "452.7023773910078`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7747913476621604`*^9},ExpressionUUID->"1104c8bc-378c-4d71-9a0c-\
a70cded05ee1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"ev1equ2", "/.", 
       RowBox[{"Q", "\[Rule]", 
        RowBox[{"SQnum", "[", 
         RowBox[{"m", ",", "\[Alpha]"}], "]"}]}]}], "/.", 
      RowBox[{"m", "\[Rule]", "0.001"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0", ",", "460"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.99", ",", "1.13"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7747915264609766`*^9, 
  3.774791548717905*^9}},ExpressionUUID->"1f110531-d2e1-4d84-9126-\
51d98863609f"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[{
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwV1nk0Vd0bB3CRWcnQNY+ZCtHNVGI/yaxkHko3IQklY9x7VeRFSqKSjI1e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         "]]}},
      Annotation[#, "Charting`Private`Tag$129036#1"]& ], 
     TagBox[{
       {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzXh6mg3zhsd2DGDwwT6Xd3XJJz4hBxh/yc1Vlh/5
lOB8t2+nbOMuGsH5aqdlZE2+WsP5L2TcmCeVOsH5De/PnjgQ6A7nn3vevPb5
LW84f/3flo2LkgLg/Fe55/kizgTB+QwfN1R38oTC+dsbfwWE1YbD+V6qt03n
H4mE8/31nefmMcTA+d/chHNv5sTB+XssbNUehCcg3HNFxWvhxEQ4X1IlYP3S
o0lw/sU/bjIvniTD+VF3Cm0rZFLh/EDXjDQ3+zQ4X2LrJOekqnSEeTcYkg6u
z4Dz21usOuIuZML5x8xXJHlyZsP5xSUPXYp0c+D8yJS4jHveuXC+QDS/w4ym
PDjf5Ha3/IQl+XC+qOG8m1n5BXC+rp+Ey3rOQjj/t37FpkkzEXwj0U+/5pgW
wfny+wPd3Y4j+Cudgk0Ew4rh/Nkn834zfUTwXUQLjk1uLIHzw1K6s73lSuF8
uYoekUUbEPzmVP04KYcyOD8g7E3jztsI/hXu/pXfc8rh/INHvFfHcFXA+V7h
q3wfL0Hwu9a9+8xhWonwD6dvSehFBH+ixsQfDslVcH6vYrms3ycE/6NsuUxT
bzWcz3M/Rj5UrgbO3553qEsrH8FP+qf+7f9+BB8AydH0pA==
         "]]}},
      Annotation[#, "Charting`Private`Tag$129036#2"]& ]}}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.99},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 459.9999906122449}, {0.99, 1.13}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.774791535379359*^9, 
  3.7747915492873325`*^9}},ExpressionUUID->"79550111-1d63-459e-b917-\
e39d07dd09a0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4.3b Stability of equ3", "Subsubsection",
 CellChangeTimes->{{3.7855082663661213`*^9, 
  3.7855082830925145`*^9}},ExpressionUUID->"98e9943a-3f75-46aa-974c-\
cbd4b564a66d"],

Cell["\<\
Below, we want to show that equ3 is asymptotically stable if it is admissible \
and s is sufficiently small.
If s is above a threshold, then equ3 will be unstable (because E2 will \
invade). This threshold will depend on r.
However, some numerical arguments are needed to support this.\
\>", "Text",
 CellChangeTimes->{{3.7747916396990247`*^9, 3.774791670129797*^9}, {
   3.774791798285487*^9, 3.7747918129810033`*^9}, 3.7804051366401415`*^9, {
   3.780405174551862*^9, 3.780405232624731*^9}, {3.785065455390389*^9, 
   3.7850654579750433`*^9}, {3.7853318760559316`*^9, 3.785331926483092*^9}},
 Background->RGBColor[
  1, 0.85, 0.85],ExpressionUUID->"33125ff5-2c0c-4387-b0be-d99cc6615eeb"],

Cell["Here is the characteristic polynomial:", "Text",
 CellChangeTimes->{{3.794755387394116*^9, 
  3.794755401706789*^9}},ExpressionUUID->"fe6c7772-fd90-43dc-80d0-\
200aa1b30200"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"Det", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"JacobsymCIequ3Q", "/.", 
      RowBox[{"s", "\[Rule]", "0"}]}], ")"}], "-", 
    RowBox[{"x", " ", 
     RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.789122097241393*^9},ExpressionUUID->"647f3ef3-b5e3-4b5e-bc52-\
208341f9d97f"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "256"}], "+", 
        RowBox[{"1280", " ", "m"}], "-", 
        RowBox[{"2560", " ", 
         SuperscriptBox["m", "2"]}], "+", 
        RowBox[{"2560", " ", 
         SuperscriptBox["m", "3"]}], "-", 
        RowBox[{"1280", " ", 
         SuperscriptBox["m", "4"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "5"]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["Q", "2"]}], "-", 
        RowBox[{"144", " ", "m", " ", 
         SuperscriptBox["Q", "2"]}], "+", 
        RowBox[{"144", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"]}], "+", 
        RowBox[{"256", " ", "x"}], "-", 
        RowBox[{"1024", " ", "m", " ", "x"}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "2"], " ", "x"}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["m", "3"], " ", "x"}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "4"], " ", "x"}], "+", 
        RowBox[{"96", " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"384", " ", "m", " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"576", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"384", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"528", " ", "\[Alpha]"}], "+", 
        RowBox[{"3664", " ", "m", " ", "\[Alpha]"}], "-", 
        RowBox[{"9376", " ", 
         SuperscriptBox["m", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"11424", " ", 
         SuperscriptBox["m", "3"], " ", "\[Alpha]"}], "-", 
        RowBox[{"6736", " ", 
         SuperscriptBox["m", "4"], " ", "\[Alpha]"}], "+", 
        RowBox[{"1552", " ", 
         SuperscriptBox["m", "5"], " ", "\[Alpha]"}], "+", 
        RowBox[{"80", " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"336", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"432", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"176", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "+", 
        RowBox[{"m", " ", 
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "+", 
        RowBox[{"512", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"3072", " ", "m", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"6144", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"160", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"832", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"1216", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"352", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"8", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"192", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"368", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4048", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"14048", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"21536", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"15280", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"4112", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"34", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"262", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"470", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"242", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"m", " ", 
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"352", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3456", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"9792", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"10624", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"3936", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"128", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"76", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"624", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"1512", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"1456", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"492", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"8", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"320", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"448", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"105", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"2157", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"10986", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"22090", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"19325", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"6169", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"86", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"246", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"162", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"96", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"1856", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"8064", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"11968", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"5664", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"68", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"98", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"12", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"208", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"712", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"848", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"332", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"12", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"164", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"356", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"204", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"541", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"4682", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"13194", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"14717", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"5673", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"72", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"56", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"9", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"484", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"3670", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"7972", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"5033", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"32", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"176", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"112", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"48", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"1016", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"4552", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"6824", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"3240", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"48", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"880", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"3152", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"2832", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"840", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"1864", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"1112", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"688", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"984", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"272", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"208", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "8"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"256", "-", 
        RowBox[{"1536", " ", "m"}], "+", 
        RowBox[{"3840", " ", 
         SuperscriptBox["m", "2"]}], "-", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "3"]}], "+", 
        RowBox[{"3840", " ", 
         SuperscriptBox["m", "4"]}], "-", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "5"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "6"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"]}], "+", 
        RowBox[{"128", " ", "m", " ", 
         SuperscriptBox["Q", "2"]}], "-", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"]}], "+", 
        SuperscriptBox["Q", "4"], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["Q", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "4"]}], "-", 
        RowBox[{"256", " ", "r"}], "+", 
        RowBox[{"1536", " ", "m", " ", "r"}], "-", 
        RowBox[{"3840", " ", 
         SuperscriptBox["m", "2"], " ", "r"}], "+", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "3"], " ", "r"}], "-", 
        RowBox[{"3840", " ", 
         SuperscriptBox["m", "4"], " ", "r"}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "5"], " ", "r"}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "6"], " ", "r"}], "-", 
        RowBox[{"512", " ", "x"}], "+", 
        RowBox[{"2560", " ", "m", " ", "x"}], "-", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "2"], " ", "x"}], "+", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "3"], " ", "x"}], "-", 
        RowBox[{"2560", " ", 
         SuperscriptBox["m", "4"], " ", "x"}], "+", 
        RowBox[{"512", " ", 
         SuperscriptBox["m", "5"], " ", "x"}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"], " ", "x"}], "-", 
        RowBox[{"112", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x"}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x"}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x"}], "-", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", "x"}], "+", 
        RowBox[{"m", " ", 
         SuperscriptBox["Q", "4"], " ", "x"}], "+", 
        RowBox[{"256", " ", "r", " ", "x"}], "-", 
        RowBox[{"1280", " ", "m", " ", "r", " ", "x"}], "+", 
        RowBox[{"2560", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x"}], "-", 
        RowBox[{"2560", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x"}], "+", 
        RowBox[{"1280", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x"}], "-", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x"}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"1024", " ", "m", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"1024", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"64", " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"320", " ", "m", " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"640", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"640", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"12", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"64", " ", "Q", " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"320", " ", "m", " ", "Q", " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"576", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"448", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"8", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SqrtBox["\[Alpha]"]}], "+", 
        RowBox[{"480", " ", "\[Alpha]"}], "-", 
        RowBox[{"3904", " ", "m", " ", "\[Alpha]"}], "+", 
        RowBox[{"12320", " ", 
         SuperscriptBox["m", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"19840", " ", 
         SuperscriptBox["m", "3"], " ", "\[Alpha]"}], "+", 
        RowBox[{"17440", " ", 
         SuperscriptBox["m", "4"], " ", "\[Alpha]"}], "-", 
        RowBox[{"8000", " ", 
         SuperscriptBox["m", "5"], " ", "\[Alpha]"}], "+", 
        RowBox[{"1504", " ", 
         SuperscriptBox["m", "6"], " ", "\[Alpha]"}], "-", 
        RowBox[{"62", " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"312", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"564", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"440", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"126", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "-", 
        RowBox[{"4", " ", "m", " ", 
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "-", 
        RowBox[{"384", " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"3328", " ", "m", " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"10880", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"17920", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"16000", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"7424", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"1408", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "\[Alpha]"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "\[Alpha]"}], "-", 
        RowBox[{"992", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"6960", " ", "m", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"17920", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"21920", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"12960", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"2992", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"94", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"362", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"474", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"206", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "4"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"3", " ", "m", " ", 
         SuperscriptBox["Q", "4"], " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"384", " ", "r", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"2944", " ", "m", " ", "r", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"7936", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"9984", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"6016", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"1408", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"48", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", "\[Alpha]"}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", "\[Alpha]"}], "+", 
        RowBox[{"512", " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"3072", " ", "m", " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"6144", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"5120", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"1536", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "+", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", "\[Alpha]"}], "-", 
        RowBox[{"132", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"788", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"1832", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"2088", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"1172", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"260", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"24", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"24", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"160", " ", "m", " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"160", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"196", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"976", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"1912", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"1680", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"548", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"22", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"14", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"128", " ", "m", " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"192", " ", "m", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "-", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"317", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3886", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"16211", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"32324", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"33811", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"17966", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"3837", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"28", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"248", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"608", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"584", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"196", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"176", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"2592", " ", "m", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"11856", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"25024", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"27216", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"14880", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3248", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"64", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"144", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"669", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"7329", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"25570", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"39426", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"28113", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"7597", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"60", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"372", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"628", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"332", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"2", " ", "m", " ", 
         SuperscriptBox["Q", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"176", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"2416", " ", "m", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"9440", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"15584", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"11632", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3248", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"56", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"352", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"3456", " ", "m", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"9792", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"10624", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"3936", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{"128", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["Q", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "-", 
        RowBox[{"72", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"632", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"1872", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2544", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"1640", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"408", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"12", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"144", " ", "m", " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"416", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"544", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"336", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"80", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"136", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"950", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2258", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"2338", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"894", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"128", " ", "m", " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"288", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"80", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"320", " ", "m", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"448", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "-", 
        RowBox[{"4", " ", "m", " ", 
         SuperscriptBox["Q", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"90", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"1940", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"11390", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"28984", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"36662", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"22772", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"5554", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"88", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"150", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"24", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"880", " ", "m", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"6344", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"18080", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"24616", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"16112", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"4088", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"80", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"186", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"3793", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"19296", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"38926", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"34206", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"10969", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"156", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"402", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"266", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"24", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"856", " ", "m", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"5488", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"12592", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"12024", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"4088", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"1856", " ", "m", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"8064", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"11968", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"5664", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"68", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"98", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "-", 
        RowBox[{"12", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"220", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"896", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"1488", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"1108", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"308", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", "m", " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"160", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"288", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"224", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"24", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"384", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"1242", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"1556", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"706", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", "m", " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"160", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"12", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"164", " ", "m", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "-", 
        RowBox[{"356", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"204", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"486", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"4531", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"15492", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"24271", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"17814", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"4981", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"56", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"112", " ", "m", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"1696", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"7200", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"12800", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"10224", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"3040", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"18", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"970", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"8178", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"22878", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"25492", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"9840", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"32", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"136", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"108", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"112", " ", "m", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"1584", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"5616", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"7184", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"3040", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"484", " ", "m", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"3670", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"7972", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"5033", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"16", " ", "m", " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{"32", " ", "m", " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"208", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"432", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"368", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"112", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", "r", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", "m", " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"336", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"272", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", "m", " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"96", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "-", 
        RowBox[{"48", " ", "m", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"968", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"4928", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"9968", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8784", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"2824", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"184", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"1504", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"3792", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"3808", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"1336", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"96", " ", "m", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"1848", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"8012", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"11856", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"5596", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["Q", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"184", " ", 
         SuperscriptBox["m", "2"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"1320", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"2472", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"1336", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"48", " ", "m", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"880", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"3152", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"2832", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["Q", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"48", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "5"], " ", "Q", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"40", " ", 
         SuperscriptBox["m", "4"], " ", "Q", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "3"], " ", "Q", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"864", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"2448", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"2656", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"984", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"576", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"768", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"176", " ", 
         SuperscriptBox["m", "2"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"1552", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"3336", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"1960", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"448", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"88", " ", 
         SuperscriptBox["m", "2"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"688", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"984", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"320", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"448", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "6"], " ", "r", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"128", " ", 
         SuperscriptBox["m", "3"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"512", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"384", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "5"], " ", "r", " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "-", 
        RowBox[{"64", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"192", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "5"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "6"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "4"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["m", "5"], " ", "x", " ", 
         SuperscriptBox["\[Alpha]", "8"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["m", "4"], " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"4", " ", "m"}], "+", 
         RowBox[{"Q", " ", 
          SqrtBox["\[Alpha]"]}], "-", "\[Alpha]", "+", 
         RowBox[{"5", " ", "m", " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"4", " ", "m"}], "-", 
         RowBox[{"Q", " ", 
          SqrtBox["\[Alpha]"]}], "-", 
         RowBox[{"3", " ", "\[Alpha]"}], "+", 
         RowBox[{"7", " ", "m", " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}], "4"]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.7891220983937473`*^9},ExpressionUUID->"2ea22fab-59a0-4b10-adf9-\
518b0f70f9a7"]
}, Closed]],

Cell["The following evaluation takes a few minutes:", "Text",
 CellChangeTimes->{{3.7747918400443697`*^9, 3.774791856925449*^9}, {
  3.7747919288709326`*^9, 3.774791929185159*^9}, {3.7853337483397675`*^9, 
  3.785333750221698*^9}},ExpressionUUID->"b29bc4e4-dec9-47a4-bf5c-\
e3d4b95b41ce"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Eigenvalues", "[", "JacobsymCIequ3Q", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7747826686324205`*^9, 3.7747826845107937`*^9}, {
  3.7747917106247597`*^9, 3.7747917186735497`*^9}, {3.7853333810454597`*^9, 
  3.7853334108622856`*^9}},ExpressionUUID->"b3828c3f-0e71-4f91-9389-\
714340594c6e"],

Cell["\<\
Therefore, we use this result and define the eigenvalues explicitly (in the \
following list):\
\>", "Text",
 CellChangeTimes->{{3.785333432287966*^9, 3.7853335529537425`*^9}, {
  3.785333704345996*^9, 3.7853337148129807`*^9}, {3.7853337545881853`*^9, 
  3.785333756019371*^9}, {3.7855083291690884`*^9, 
  3.785508355869774*^9}},ExpressionUUID->"5ae93353-95e7-4b6e-86f8-\
84bb0d377f05"],

Cell[BoxData[
 RowBox[{
  RowBox[{"evalsequ3Q", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"256", "+", 
            RowBox[{"272", " ", "\[Alpha]"}], "+", 
            RowBox[{
             SuperscriptBox["Q", "4"], " ", "\[Alpha]"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["Q", "3"], " ", 
             SuperscriptBox["\[Alpha]", 
              RowBox[{"3", "/", "2"}]]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["\[Alpha]", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["\[Alpha]", "3"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["Q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"24", "+", 
               RowBox[{"16", " ", "\[Alpha]"}], "+", 
               SuperscriptBox["\[Alpha]", "2"]}], ")"}]}], "-", 
            RowBox[{"4", " ", "Q", " ", 
             SqrtBox["\[Alpha]"], " ", 
             RowBox[{"(", 
              RowBox[{"24", "+", 
               RowBox[{"16", " ", "\[Alpha]"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["m", "4"], " ", 
             RowBox[{"(", 
              RowBox[{"256", "+", 
               RowBox[{"1296", " ", "\[Alpha]"}], "+", 
               RowBox[{"2816", " ", 
                SuperscriptBox["\[Alpha]", "2"]}], "+", 
               RowBox[{"3353", " ", 
                SuperscriptBox["\[Alpha]", "3"]}], "+", 
               RowBox[{"2320", " ", 
                SuperscriptBox["\[Alpha]", "4"]}], "+", 
               RowBox[{"920", " ", 
                SuperscriptBox["\[Alpha]", "5"]}], "+", 
               RowBox[{"192", " ", 
                SuperscriptBox["\[Alpha]", "6"]}], "+", 
               RowBox[{"16", " ", 
                SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", "m", " ", 
             RowBox[{"(", 
              RowBox[{"256", "+", 
               RowBox[{"528", " ", "\[Alpha]"}], "+", 
               RowBox[{
                SuperscriptBox["Q", "3"], " ", 
                SuperscriptBox["\[Alpha]", 
                 RowBox[{"3", "/", "2"}]]}], "+", 
               RowBox[{"392", " ", 
                SuperscriptBox["\[Alpha]", "2"]}], "+", 
               RowBox[{"121", " ", 
                SuperscriptBox["\[Alpha]", "3"]}], "+", 
               RowBox[{"12", " ", 
                SuperscriptBox["\[Alpha]", "4"]}], "-", 
               RowBox[{
                SuperscriptBox["Q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"24", "+", 
                  RowBox[{"40", " ", "\[Alpha]"}], "+", 
                  RowBox[{"17", " ", 
                   SuperscriptBox["\[Alpha]", "2"]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "-", 
               RowBox[{"Q", " ", 
                SqrtBox["\[Alpha]"], " ", 
                RowBox[{"(", 
                 RowBox[{"72", "+", 
                  RowBox[{"96", " ", "\[Alpha]"}], "+", 
                  RowBox[{"41", " ", 
                   SuperscriptBox["\[Alpha]", "2"]}], "+", 
                  RowBox[{"8", " ", 
                   SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["m", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "256"}], "-", 
               RowBox[{"1040", " ", "\[Alpha]"}], "-", 
               RowBox[{"1752", " ", 
                SuperscriptBox["\[Alpha]", "2"]}], "-", 
               RowBox[{"1537", " ", 
                SuperscriptBox["\[Alpha]", "3"]}], "-", 
               RowBox[{"724", " ", 
                SuperscriptBox["\[Alpha]", "4"]}], "-", 
               RowBox[{"172", " ", 
                SuperscriptBox["\[Alpha]", "5"]}], "-", 
               RowBox[{"16", " ", 
                SuperscriptBox["\[Alpha]", "6"]}], "+", 
               RowBox[{"Q", " ", 
                SqrtBox["\[Alpha]"], " ", 
                RowBox[{"(", 
                 RowBox[{"24", "+", 
                  RowBox[{"64", " ", "\[Alpha]"}], "+", 
                  RowBox[{"59", " ", 
                   SuperscriptBox["\[Alpha]", "2"]}], "+", 
                  RowBox[{"24", " ", 
                   SuperscriptBox["\[Alpha]", "3"]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}]}], ")"}]}], 
            "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["m", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "768"}], "-", 
               RowBox[{"2352", " ", "\[Alpha]"}], "-", 
               RowBox[{"2832", " ", 
                SuperscriptBox["\[Alpha]", "2"]}], "-", 
               RowBox[{"1635", " ", 
                SuperscriptBox["\[Alpha]", "3"]}], "-", 
               RowBox[{"440", " ", 
                SuperscriptBox["\[Alpha]", "4"]}], "-", 
               RowBox[{"44", " ", 
                SuperscriptBox["\[Alpha]", "5"]}], "+", 
               RowBox[{
                SuperscriptBox["Q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"24", "+", 
                  RowBox[{"64", " ", "\[Alpha]"}], "+", 
                  RowBox[{"57", " ", 
                   SuperscriptBox["\[Alpha]", "2"]}], "+", 
                  RowBox[{"24", " ", 
                   SuperscriptBox["\[Alpha]", "3"]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
               RowBox[{"2", " ", "Q", " ", 
                SqrtBox["\[Alpha]"], " ", 
                RowBox[{"(", 
                 RowBox[{"72", "+", 
                  RowBox[{"144", " ", "\[Alpha]"}], "+", 
                  RowBox[{"97", " ", 
                   SuperscriptBox["\[Alpha]", "2"]}], "+", 
                  RowBox[{"32", " ", 
                   SuperscriptBox["\[Alpha]", "3"]}], "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"Q", " ", 
              SqrtBox["\[Alpha]"]}], "+", "\[Alpha]", "-", 
             RowBox[{"m", " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"5", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], "2"], 
          " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"4", "+", 
             RowBox[{"Q", " ", 
              SqrtBox["\[Alpha]"]}], "+", 
             RowBox[{"3", " ", "\[Alpha]"}], "-", 
             RowBox[{"m", " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"7", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], 
           "2"]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"32", " ", 
            SuperscriptBox["Q", "2"]}], "-", 
           SuperscriptBox["Q", "4"], "+", 
           RowBox[{"48", " ", 
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["Q", "2"], "+", 
              RowBox[{"32", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{"16", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"64", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"256", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "r"}], ")"}]}], "-", 
           RowBox[{"1024", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SqrtBox["\[Alpha]"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "3"], " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{"16", "-", 
           RowBox[{"48", " ", "m"}], "+", 
           RowBox[{"32", " ", 
            SuperscriptBox["m", "2"]}], "-", 
           SuperscriptBox["Q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"496", "+", 
           SuperscriptBox["Q", "4"], "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"7504", "-", 
              RowBox[{"3520", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"192", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["Q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "47"}], "+", 
              RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "219"}], "+", 
              RowBox[{"104", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"9984", "-", 
              RowBox[{"4480", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "277"}], "+", 
                 RowBox[{"24", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["Q", "4"]}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"197", "-", 
                 RowBox[{"24", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"8", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "467"}], "+", 
                 RowBox[{"200", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"127", "-", 
                 RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"16", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "781"}], "+", 
                 RowBox[{"360", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"3", "/", "2"}]]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"], " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{"98", "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["Q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"662", "-", 
              RowBox[{"48", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"16", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "169"}], "+", 
              RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "422"}], "+", 
              RowBox[{"9", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"48", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "669"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["Q", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"48670", "-", 
              RowBox[{"20896", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["Q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"60", "-", 
              RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"176", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["m", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "10589"}], "+", 
              RowBox[{"4656", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "89459"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"538", "-", 
                 RowBox[{"56", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"37200", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "39859"}], "-", 
              RowBox[{"5", " ", 
               SuperscriptBox["Q", "4"]}], "+", 
              RowBox[{"14800", " ", "r"}], "-", 
              RowBox[{"6", " ", 
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "227"}], "+", 
                 RowBox[{"32", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"8990", "+", 
              RowBox[{"6", " ", 
               SuperscriptBox["Q", "4"]}], "-", 
              RowBox[{"2976", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "526"}], "+", 
                 RowBox[{"80", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"41458", "-", 
              RowBox[{"16480", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "717"}], "+", 
                 RowBox[{"88", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"5", "/", "2"}]]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"1735", "-", 
              RowBox[{"176", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"573", "-", 
              RowBox[{"12", " ", 
               SuperscriptBox["Q", "2"]}], "-", 
              RowBox[{"80", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "17"}], "+", 
              SuperscriptBox["Q", "2"], "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "103"}], "+", 
              RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1519"}], "+", 
              RowBox[{"12", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"192", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "3"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "93"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["Q", "2"]}], "+", 
           RowBox[{"12", " ", "r"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "9161"}], "+", 
              RowBox[{"3468", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "9283"}], "+", 
              RowBox[{"3668", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "56279"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"299", "-", 
                 RowBox[{"36", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"20100", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"15209", "+", 
              SuperscriptBox["Q", "4"], "-", 
              RowBox[{"4380", " ", "r"}], "+", 
              RowBox[{"15", " ", 
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "31"}], "+", 
                 RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{"2324", "+", 
              SuperscriptBox["Q", "4"], "-", 
              RowBox[{"528", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "55"}], "+", 
                 RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"10474", "-", 
              RowBox[{"3440", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "54"}], "+", 
                 RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"7", "/", "2"}]]}], "+", 
        RowBox[{"2", " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"2300", "-", 
              RowBox[{"240", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "68"}], "+", 
              SuperscriptBox["Q", "2"], "+", 
              RowBox[{"6", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "100"}], "+", 
              RowBox[{"9", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "161"}], "+", 
              SuperscriptBox["Q", "2"], "+", 
              RowBox[{"18", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"32", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "79"}], "+", 
                 RowBox[{"9", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "4"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "18"}], "+", 
           RowBox[{
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{"69538", "-", 
              RowBox[{"22248", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "587"}], "+", 
              RowBox[{"18", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"68", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "12941"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"324", "-", 
                 RowBox[{"24", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"2552", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "20809"}], "+", 
              RowBox[{"7128", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "87296"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"374", "-", 
                 RowBox[{"40", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"25392", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"25176", "-", 
              RowBox[{"6344", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "323"}], "+", 
                 RowBox[{"32", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"9", "/", "2"}]]}], "+", 
        RowBox[{"2", " ", "m", " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "44"}], "-", 
           RowBox[{"8", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "49"}], "+", 
              RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"26", " ", 
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "45"}], "+", 
              RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"11", " ", 
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "95"}], "+", 
              RowBox[{"8", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "489"}], "+", 
              RowBox[{"40", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "5"]}], "+", 
        RowBox[{"2", " ", "m", " ", 
         RowBox[{"(", 
          RowBox[{"57", "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"9019", "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "21"}], "+", "r"}], ")"}]}], "-", 
              RowBox[{"1544", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1457"}], "+", 
              RowBox[{"24", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"148", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["m", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2684"}], "+", 
              RowBox[{"687", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "5"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "7718"}], "+", 
              RowBox[{"2188", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "21373"}], "+", 
              RowBox[{
               SuperscriptBox["Q", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"62", "-", 
                 RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
              RowBox[{"4704", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"11", "/", "2"}]]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "2"], " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{"12", "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"77", "-", 
              RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "39"}], "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "6"]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SuperscriptBox["m", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"68", "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"2399", "-", 
              RowBox[{"396", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "826"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["Q", "2"]}], "+", 
              RowBox[{"78", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1889"}], "+", 
              RowBox[{"414", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"13", "/", "2"}]]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["m", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"4", "-", 
           RowBox[{"8", " ", "m"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["m", "2"]}]}], ")"}], " ", "Q", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", "7"]}], "+", 
        RowBox[{"8", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SuperscriptBox["m", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "38"}], "-", 
           RowBox[{"4", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "59"}], "+", 
              RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["m", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "293"}], "+", 
              RowBox[{"44", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"15", "/", "2"}]]}], "+", 
        RowBox[{"32", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SuperscriptBox["m", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", 
           RowBox[{"m", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "13"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"17", "/", "2"}]]}], "-", 
        RowBox[{"32", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
         SuperscriptBox["m", "5"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "s"}], ")"}], " ", 
         SuperscriptBox["\[Alpha]", 
          RowBox[{"19", "/", "2"}]]}], "-", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "s"}], ")"}], "2"], " ", "\[Alpha]", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m", "+", 
              RowBox[{"m", " ", "\[Alpha]"}]}], ")"}], "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["Q", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["Q", "3"], " ", 
                  SqrtBox["\[Alpha]"], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "-", 
                 RowBox[{"\[Alpha]", " ", 
                  RowBox[{"(", 
                   RowBox[{"32", "+", 
                    RowBox[{"35", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"4", " ", "Q", " ", 
                  SqrtBox["\[Alpha]"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "16"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "17"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["Q", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "16"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "15"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"8", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"32", "+", 
                    RowBox[{"48", " ", "\[Alpha]"}], "+", 
                    RowBox[{"22", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}]}], ")"}], 
               "2"]}], "+", 
             RowBox[{
              SuperscriptBox["m", "9"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"64", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"32", "+", 
                    RowBox[{"144", " ", "\[Alpha]"}], "+", 
                    RowBox[{"262", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"249", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"131", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"36", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}], "2"]}], "+", 
                RowBox[{"16", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"2560", "+", 
                   RowBox[{"17760", " ", "\[Alpha]"}], "+", 
                   RowBox[{"54288", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"96610", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"111123", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"86433", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"46058", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"16600", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"3872", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"528", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"49152", "+", 
                   RowBox[{"370432", " ", "\[Alpha]"}], "+", 
                   RowBox[{"1258016", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2546935", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"3419048", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"3195516", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"2120432", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"997872", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"325888", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"70208", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"8960", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}], "+", 
                   RowBox[{"512", " ", 
                    SuperscriptBox["\[Alpha]", "11"]}]}], ")"}]}]}], ")"}]}], 
             "+", 
             RowBox[{"m", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["Q", "8"], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"5", " ", "\[Alpha]"}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "7"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{"19", " ", "\[Alpha]"}], "+", 
                   RowBox[{"18", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "5"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "448"}], "+", 
                   RowBox[{"24", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "65"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1673"}], "+", 
                    RowBox[{"592", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "614"}], "+", 
                    RowBox[{"344", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "17"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "6"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "56"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "185"}], "+", 
                    RowBox[{"24", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "39"}], "+", 
                    RowBox[{"19", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "22"}], "+", 
                    RowBox[{"48", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "6"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
                RowBox[{"64", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"2304", "+", 
                   RowBox[{"6400", " ", "\[Alpha]"}], "+", 
                   RowBox[{"6752", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"3392", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"817", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"75", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                RowBox[{"16", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"10752", "+", 
                   RowBox[{"32864", " ", "\[Alpha]"}], "+", 
                   RowBox[{"40176", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"25250", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"8685", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"1562", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"114", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"49152", "+", 
                   RowBox[{"135168", " ", "\[Alpha]"}], "+", 
                   RowBox[{"145440", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"78607", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"22623", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"3188", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"168", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Q", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"3072", "+", 
                   RowBox[{"7120", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2075", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "-", 
                   RowBox[{"4167", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"2536", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"508", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "+", 
                    RowBox[{"3", " ", "\[Alpha]"}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"160", "+", 
                    RowBox[{"1040", " ", "\[Alpha]"}], "+", 
                    RowBox[{"1594", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"785", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"150", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"18", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "3"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"7680", "+", 
                   RowBox[{"22528", " ", "\[Alpha]"}], "+", 
                   RowBox[{"21636", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"7833", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"918", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"90", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"192", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "3"]}], "-", 
                   RowBox[{"16", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"192", "+", 
                    RowBox[{"1248", " ", "\[Alpha]"}], "+", 
                    RowBox[{"1956", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1188", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"325", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"38", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"4", " ", "Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"16384", "+", 
                   RowBox[{"38400", " ", "\[Alpha]"}], "+", 
                   RowBox[{"27712", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"3184", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"4061", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"1726", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "-", 
                   RowBox[{"190", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"64", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"128", "+", 
                    RowBox[{"208", " ", "\[Alpha]"}], "+", 
                    RowBox[{"104", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"17", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"9216", "+", 
                    RowBox[{"28672", " ", "\[Alpha]"}], "+", 
                    RowBox[{"34688", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"20976", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"6782", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"1119", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"70", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"4096", "-", 
                   RowBox[{"1536", " ", "\[Alpha]"}], "-", 
                   RowBox[{"27224", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "-", 
                   RowBox[{"35695", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"18134", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"4134", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "-", 
                   RowBox[{"302", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"112", "+", 
                    RowBox[{"192", " ", "\[Alpha]"}], "+", 
                    RowBox[{"87", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"11", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "+", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "7680"}], "-", 
                    RowBox[{"23872", " ", "\[Alpha]"}], "-", 
                    RowBox[{"25248", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "-", 
                    RowBox[{"10514", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                    RowBox[{"1041", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"400", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"98", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}]}], ")"}]}]}],
                ")"}]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["m", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["Q", "7"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"11", " ", "\[Alpha]"}], "+", 
                   RowBox[{"11", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["Q", "6"], " ", 
                 RowBox[{"(", 
                  RowBox[{"64", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"257", "-", 
                    RowBox[{"24", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"324", "-", 
                    RowBox[{"92", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"182", "-", 
                    RowBox[{"80", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"68", "-", 
                    RowBox[{"20", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["Q", "5"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"768", "-", 
                   RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "781"}], "+", 
                    RowBox[{"72", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"4395", "-", 
                    RowBox[{"1056", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2723", "-", 
                    RowBox[{"824", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"866", "-", 
                    RowBox[{"184", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"120", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{"4608", "+", 
                   RowBox[{"14080", " ", "\[Alpha]"}], "+", 
                   RowBox[{"16320", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"9056", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"2450", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"259", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"49152", "+", 
                   RowBox[{"176000", " ", "\[Alpha]"}], "+", 
                   RowBox[{"260672", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"208296", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"97764", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"27138", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"4149", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"272", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"98304", "+", 
                   RowBox[{"348608", " ", "\[Alpha]"}], "+", 
                   RowBox[{"515968", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"416863", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"199890", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"56856", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"8840", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"572", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["Q", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"3648", "+", 
                   RowBox[{"11776", " ", "\[Alpha]"}], "+", 
                   RowBox[{"11163", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"1430", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"2476", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"1344", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "-", 
                   RowBox[{"228", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"16", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"10", "+", 
                    RowBox[{"12", " ", "\[Alpha]"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"320", "+", 
                    RowBox[{"2400", " ", "\[Alpha]"}], "+", 
                    RowBox[{"4724", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"3666", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"1486", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"373", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"48", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox["Q", "3"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"23552", "+", 
                   RowBox[{"89024", " ", "\[Alpha]"}], "+", 
                   RowBox[{"124842", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"84885", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"31269", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"5918", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"432", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"192", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "+", 
                    RowBox[{"5", " ", "\[Alpha]"}], "+", 
                    SuperscriptBox["\[Alpha]", "2"]}], ")"}]}], "-", 
                   RowBox[{"16", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"480", "+", 
                    RowBox[{"3600", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6986", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"5763", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"2417", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"527", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"48", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox["Q", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "24576"}], "-", 
                   RowBox[{"42112", " ", "\[Alpha]"}], "+", 
                   RowBox[{"47936", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"156773", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"141696", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"63098", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"14284", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"1324", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "-", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"336", "+", 
                    RowBox[{"816", " ", "\[Alpha]"}], "+", 
                    RowBox[{"661", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"226", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"31", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "+", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"24576", "+", 
                    RowBox[{"93376", " ", "\[Alpha]"}], "+", 
                    RowBox[{"132512", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"91798", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"34239", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"6936", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"699", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"114688", "+", 
                   RowBox[{"386048", " ", "\[Alpha]"}], "+", 
                   RowBox[{"513856", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"350424", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"129909", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"23437", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"894", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "-", 
                   RowBox[{"200", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"64", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"448", "+", 
                    RowBox[{"1008", " ", "\[Alpha]"}], "+", 
                    RowBox[{"804", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"279", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"37", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"35840", "+", 
                    RowBox[{"132864", " ", "\[Alpha]"}], "+", 
                    RowBox[{"199936", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"160296", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"75246", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"21003", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"3271", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"224", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}]}], ")"}]}]}],
                ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["m", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["Q", "6"]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"24", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"91", "-", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"97", "-", 
                    RowBox[{"28", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"51", "-", 
                    RowBox[{"12", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["Q", "5"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"576", "-", 
                   RowBox[{"24", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "113"}], "+", 
                    RowBox[{"8", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"4635", "-", 
                    RowBox[{"816", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3764", "-", 
                    RowBox[{"808", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1616", "-", 
                    RowBox[{"240", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "44"}], "+", "r"}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"24", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"21504", "+", 
                   RowBox[{"93184", " ", "\[Alpha]"}], "+", 
                   RowBox[{"167552", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"163072", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"93492", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"31796", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"5973", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"481", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"129024", "+", 
                   RowBox[{"534912", " ", "\[Alpha]"}], "+", 
                   RowBox[{"936640", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"909448", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"538164", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"199246", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"45071", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"5682", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"304", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"344064", "+", 
                   RowBox[{"1472576", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2708000", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2816691", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"1822953", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"753664", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"194585", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"28692", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"1848", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Q", "3"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"18944", "+", 
                   RowBox[{"86144", " ", "\[Alpha]"}], "+", 
                   RowBox[{"154588", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"145853", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"81580", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"27724", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"5392", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"488", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{"10", "+", 
                    RowBox[{"10", " ", "\[Alpha]"}], "+", 
                    SuperscriptBox["\[Alpha]", "2"]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"160", "+", 
                    RowBox[{"1200", " ", "\[Alpha]"}], "+", 
                    RowBox[{"1926", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1066", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"275", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox["Q", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"4288", "+", 
                   RowBox[{"17520", " ", "\[Alpha]"}], "+", 
                   RowBox[{"25611", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"16795", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"5432", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"861", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"100", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"40", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"16", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"10", "+", 
                    RowBox[{"18", " ", "\[Alpha]"}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    SuperscriptBox["\[Alpha]", "3"]}], ")"}]}], "-", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"320", "+", 
                    RowBox[{"2720", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6548", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"6802", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"3882", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"1359", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"262", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{
                 SuperscriptBox["Q", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "61440"}], "-", 
                   RowBox[{"179840", " ", "\[Alpha]"}], "-", 
                   RowBox[{"91576", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"219307", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"372234", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"260700", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"99099", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"20284", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"1808", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "-", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"560", "+", 
                    RowBox[{"1760", " ", "\[Alpha]"}], "+", 
                    RowBox[{"2035", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1125", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"315", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"37", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"43520", "+", 
                    RowBox[{"196160", " ", "\[Alpha]"}], "+", 
                    RowBox[{"348320", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"326490", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"184157", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"67170", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"16429", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"2644", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"224", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"344064", "+", 
                   RowBox[{"1452544", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2575936", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2540432", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"1540703", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"589476", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"138344", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"17984", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"952", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"64", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"896", "+", 
                    RowBox[{"2576", " ", "\[Alpha]"}], "+", 
                    RowBox[{"2808", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1477", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"382", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"39", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"78848", "+", 
                    RowBox[{"342016", " ", "\[Alpha]"}], "+", 
                    RowBox[{"618368", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"615824", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"374342", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"143719", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"34326", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"4709", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"288", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}]}], ")"}]}]}],
                ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["m", "4"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 SuperscriptBox["Q", "5"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"160", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"702", "-", 
                    RowBox[{"48", " ", "r"}]}], ")"}], " ", "\[Alpha]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1027", "-", 
                    RowBox[{"184", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"668", "-", 
                    RowBox[{"96", " ", "r"}]}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "27"}], "+", "r"}], ")"}], " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"24", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                RowBox[{"32", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"32256", "+", 
                   RowBox[{"164864", " ", "\[Alpha]"}], "+", 
                   RowBox[{"357952", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"433216", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"321454", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"150568", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"43679", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"7206", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"520", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}], "+", 
                RowBox[{"8", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"215040", "+", 
                   RowBox[{"1019200", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2071008", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"2376668", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"1701558", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"787646", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"234577", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"42828", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"4232", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"160", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"1376256", "+", 
                   RowBox[{"6878592", " ", "\[Alpha]"}], "+", 
                   RowBox[{"15038784", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"18995433", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"15347000", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"8247324", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"2953276", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"680624", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"91776", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"5536", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["Q", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"4992", "+", 
                   RowBox[{"24544", " ", "\[Alpha]"}], "+", 
                   RowBox[{"46955", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"47072", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"29468", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"13060", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"4240", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"960", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"96", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "+", 
                    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "\[Alpha]"}], "+", 
                    SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"160", "+", 
                    RowBox[{"1520", " ", "\[Alpha]"}], "+", 
                    RowBox[{"4330", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"5601", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"4040", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"1767", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"428", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"40", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["Q", "3"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"16896", "+", 
                   RowBox[{"89120", " ", "\[Alpha]"}], "+", 
                   RowBox[{"192405", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"227169", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"165071", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"76904", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"22592", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"3864", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"288", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"96", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"5", "+", 
                    RowBox[{"10", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    SuperscriptBox["\[Alpha]", "3"]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"480", "+", 
                    RowBox[{"4560", " ", "\[Alpha]"}], "+", 
                    RowBox[{"12426", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"15621", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"10720", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"4196", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"873", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"72", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Q", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"81920", "+", 
                   RowBox[{"321280", " ", "\[Alpha]"}], "+", 
                   RowBox[{"413744", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"78157", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "-", 
                   RowBox[{"325876", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"391704", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "-", 
                   RowBox[{"219020", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "-", 
                   RowBox[{"68432", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "-", 
                   RowBox[{"11552", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "-", 
                   RowBox[{"800", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"560", "+", 
                    RowBox[{"2160", " ", "\[Alpha]"}], "+", 
                    RowBox[{"3235", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"2460", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"1030", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"228", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"20", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}], "-", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"46080", "+", 
                    RowBox[{"240960", " ", "\[Alpha]"}], "+", 
                    RowBox[{"513760", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"601210", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"440433", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"216830", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"74046", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"17296", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"2496", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"160", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"2", " ", "Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"573440", "+", 
                   RowBox[{"2887680", " ", "\[Alpha]"}], "+", 
                   RowBox[{"6296320", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"7898204", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"6345945", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"3406759", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"1226700", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"286736", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"39640", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"2496", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"320", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "3"], " ", 
                    RowBox[{"(", 
                    RowBox[{"112", "+", 
                    RowBox[{"336", " ", "\[Alpha]"}], "+", 
                    RowBox[{"373", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"193", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"47", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"107520", "+", 
                    RowBox[{"536960", " ", "\[Alpha]"}], "+", 
                    RowBox[{"1138880", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1358820", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"1013900", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"493239", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"156631", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"31193", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"3488", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"160", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}]}], ")"}]}]}], ")"}]}]}],
                ")"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m", "5"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"32", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"32256", "+", 
                   RowBox[{"189952", " ", "\[Alpha]"}], "+", 
                   RowBox[{"483392", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"699776", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"637294", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"379906", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"148617", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"36847", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"5256", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"328", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}]}], ")"}]}], "+", 
                RowBox[{"8", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"236544", "+", 
                   RowBox[{"1266496", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2941216", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"3909884", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"3296902", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"1838122", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"681415", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"163390", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"23480", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"1680", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}], "-", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"1720320", "+", 
                   RowBox[{"9822848", " ", "\[Alpha]"}], "+", 
                   RowBox[{"24840160", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"36804233", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"35499869", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"23337316", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"10600822", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"3287808", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"666648", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"79840", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"4288", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["Q", "4"], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1152", "+", 
                   RowBox[{"5456", " ", "\[Alpha]"}], "+", 
                   RowBox[{"9967", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"9898", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"6478", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"2808", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"776", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"96", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"3", " ", "\[Alpha]"}], "+", 
                    SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"32", "+", 
                    RowBox[{"304", " ", "\[Alpha]"}], "+", 
                    RowBox[{"802", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"907", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"573", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"190", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Q", "3"], " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"15872", "+", 
                   RowBox[{"94976", " ", "\[Alpha]"}], "+", 
                   RowBox[{"238212", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"334205", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"294122", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"169810", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"64160", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"15152", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"1952", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"96", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"192", " ", 
                    SuperscriptBox["r", "2"], " ", 
                    SuperscriptBox["\[Alpha]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "3"]}], "-", 
                   RowBox[{"16", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"192", "+", 
                    RowBox[{"2016", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6308", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"9324", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"7649", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"3652", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"969", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"120", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Q", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"61440", "+", 
                   RowBox[{"296704", " ", "\[Alpha]"}], "+", 
                   RowBox[{"553240", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"476659", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"119158", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "-", 
                   RowBox[{"132094", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "-", 
                   RowBox[{"140680", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "-", 
                   RowBox[{"60160", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "-", 
                   RowBox[{"12664", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "-", 
                   RowBox[{"960", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}], "+", 
                   RowBox[{"32", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"336", "+", 
                    RowBox[{"1536", " ", "\[Alpha]"}], "+", 
                    RowBox[{"2821", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"2725", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"1510", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"478", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"76", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "-", 
                   RowBox[{"4", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"29184", "+", 
                    RowBox[{"174016", " ", "\[Alpha]"}], "+", 
                    RowBox[{"433376", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"606262", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"541219", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"329540", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"140728", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"41720", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"8032", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"848", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                    RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}]}], ")"}]}], 
                "-", 
                RowBox[{"2", " ", "Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"573440", "+", 
                   RowBox[{"3344896", " ", "\[Alpha]"}], "+", 
                   RowBox[{"8609472", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"13000976", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"12853193", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"8733170", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"4141874", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"1356896", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"294416", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"38304", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"2272", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}], "+", 
                   RowBox[{"64", " ", 
                    SuperscriptBox["r", "2"], " ", "\[Alpha]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"896", "+", 
                    RowBox[{"3696", " ", "\[Alpha]"}], "+", 
                    RowBox[{"6168", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"5395", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"2660", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"726", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"96", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}]}], ")"}]}], "-", 
                   RowBox[{"8", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{"93184", "+", 
                    RowBox[{"528384", " ", "\[Alpha]"}], "+", 
                    RowBox[{"1290880", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"1801104", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"1597978", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"943621", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"374330", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"97426", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"15504", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"1272", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                    RowBox[{"32", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["m", "8"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "64"}], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{"3", " ", "\[Alpha]"}], "+", 
                    SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"16", "+", 
                   RowBox[{"48", " ", "\[Alpha]"}], "+", 
                   RowBox[{"51", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"24", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"144", "+", 
                   RowBox[{"464", " ", "\[Alpha]"}], "-", 
                   RowBox[{"4", " ", "Q", " ", 
                    SuperscriptBox["\[Alpha]", 
                    RowBox[{"3", "/", "2"}]]}], "+", 
                   RowBox[{"555", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "-", 
                   RowBox[{"4", " ", "Q", " ", 
                    SuperscriptBox["\[Alpha]", 
                    RowBox[{"5", "/", "2"}]]}], "+", 
                   RowBox[{"314", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"84", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"8", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", "Q", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"16384", "+", 
                   RowBox[{"134144", " ", "\[Alpha]"}], "+", 
                   RowBox[{"499616", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"1124186", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"1706795", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"1844009", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"1453104", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"840192", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"352856", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"104592", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"20672", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}], "+", 
                   RowBox[{"2432", " ", 
                    SuperscriptBox["\[Alpha]", "11"]}], "+", 
                   RowBox[{"128", " ", 
                    SuperscriptBox["\[Alpha]", "12"]}]}], ")"}]}], "+", 
                RowBox[{"\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"393216", "+", 
                   RowBox[{"3079424", " ", "\[Alpha]"}], "+", 
                   RowBox[{"10914880", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"23189679", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"32919124", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"32896652", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"23717048", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"12416256", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"4676928", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"1233344", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"215424", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}], "+", 
                   RowBox[{"22272", " ", 
                    SuperscriptBox["\[Alpha]", "11"]}], "+", 
                   RowBox[{"1024", " ", 
                    SuperscriptBox["\[Alpha]", "12"]}]}], ")"}]}], "-", 
                RowBox[{"16", " ", "r", " ", 
                 SqrtBox["\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "Q", " ", 
                    RowBox[{"(", 
                    RowBox[{"1024", "+", 
                    RowBox[{"7456", " ", "\[Alpha]"}], "+", 
                    RowBox[{"23776", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"43939", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"52329", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"42051", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"23077", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"8512", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"2008", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"272", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}], "+", 
                   RowBox[{
                    SqrtBox["\[Alpha]"], " ", 
                    RowBox[{"(", 
                    RowBox[{"10752", "+", 
                    RowBox[{"72880", " ", "\[Alpha]"}], "+", 
                    RowBox[{"216560", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                    RowBox[{"372129", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                    RowBox[{"409970", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                    RowBox[{"302515", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                    RowBox[{"151132", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                    RowBox[{"50280", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                    RowBox[{"10592", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                    RowBox[{"1264", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["m", "6"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"16", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"2", "+", "\[Alpha]"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"21504", "+", 
                   RowBox[{"143360", " ", "\[Alpha]"}], "+", 
                   RowBox[{"418432", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"705152", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"761012", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"550184", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"269865", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBox[{"88532", " ", 
                    SuperscriptBox["\[Alpha]", "7"]}], "+", 
                   RowBox[{"18512", " ", 
                    SuperscriptBox["\[Alpha]", "8"]}], "+", 
                   RowBox[{"2208", " ", 
                    SuperscriptBox["\[Alpha]", "9"]}], "+", 
                   RowBox[{"112", " ", 
                    SuperscriptBox["\[Alpha]", "10"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", "r", " ", "\[Alpha]", " ", 
                 RowBox[{"(", 
                  RowBox[{"172032", "+", 
                   RowBox[{"1029504", " ", "\[Alpha]"}], "+", 
                   RowBox[{"2697536", " ", 
                    SuperscriptBox["\[Alpha]", "2"]}], "+", 
                   RowBox[{"4088520", " ", 
                    SuperscriptBox["\[Alpha]", "3"]}], "+", 
                   RowBox[{"3980020", " ", 
                    SuperscriptBox["\[Alpha]", "4"]}], "+", 
                   RowBox[{"2603734", " ", 
                    SuperscriptBox["\[Alpha]", "5"]}], "+", 
                   RowBox[{"1159119", " ", 
                    SuperscriptBox["\[Alpha]", "6"]}], "+", 
                   RowBo