(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4144768,     103510]
NotebookOptionsPosition[   4037436,     101014]
NotebookOutlinePosition[   4037810,     101030]
CellTagsIndexPosition[   4037767,     101027]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Supporting Material: File S1",
  FontColor->GrayLevel[0]],
 "\nThe effectiveness of pseudomagic traits in promoting divergence \n",
 StyleBox["by",
  FontSize->36,
  FontColor->GrayLevel[0]],
 "\nMaria Servedio and Reinhard B\[UDoubleDot]rger"
}], "Title",
 CellChangeTimes->{{3.7402268209643927`*^9, 3.740226864049459*^9}, {
   3.7662355660027003`*^9, 3.7662355871931577`*^9}, {3.7752236981525507`*^9, 
   3.7752237205571156`*^9}, {3.7752242465020905`*^9, 3.775224292796219*^9}, 
   3.7877567432735343`*^9, 3.8006264998495483`*^9, 3.800626581756181*^9, 
   3.801229739372122*^9, 
   3.8012298442872553`*^9},ExpressionUUID->"7f8b46b8-6582-49ba-b67c-\
1b03b8f5115e"],

Cell[TextData[StyleBox["Theory for the two-island model",
 FontSize->36]], "Text",
 CellChangeTimes->{{3.7752243167869587`*^9, 3.7752243418145494`*^9}, {
  3.7804106074561462`*^9, 
  3.7804106077279754`*^9}},ExpressionUUID->"8232da8a-aeff-4013-91de-\
bdd664674e93"],

Cell[CellGroupData[{

Cell["1. Brief recap of model and notation", "Subchapter",
 CellChangeTimes->{{3.7746824040090675`*^9, 3.774682428065282*^9}, {
   3.775224901380258*^9, 3.7752249015447407`*^9}, 
   3.786707749813239*^9},ExpressionUUID->"94f45cc4-afe2-4797-a3aa-\
875905186643"],

Cell["\<\
Locus T is a neutral phenotype matching locus. Allelic type T1 prefers T1 by \
a factor 1+\[Alpha]1, T2 prefers T2 by a factor 1+\[Alpha]2.
Locus E is under divergent (ecological) selection. Relative fitnesses of \
alleles E1 and E2 are 1+s1 and 1 in deme 1, respectively, and 1 and 1+s2 in \
deme 2.
Viability selection acts on both sexes.
The recombination rate between T and E is r.\
\>", "Text",
 CellChangeTimes->{{3.740226881148731*^9, 3.7402270575997944`*^9}, {
  3.740227176305213*^9, 3.7402271902732697`*^9}, {3.7662291582299957`*^9, 
  3.7662291585425067`*^9}, {3.7662356268834248`*^9, 3.7662356742245193`*^9}, {
  3.7662358685982885`*^9, 3.7662358938498826`*^9}, {3.775224443585087*^9, 
  3.7752246055777864`*^9}, {3.780402534529189*^9, 3.7804026095263352`*^9}, {
  3.780410689448383*^9, 3.780410730406522*^9}, {3.7804107689450645`*^9, 
  3.780410837636074*^9}},ExpressionUUID->"7c99e285-c256-454d-ac0b-\
fe06132baff9"],

Cell["\<\
The frequencies of the four genotypes T1E1, T1E2, T2E1, and T2E2 are denoted \
by 
x1[1] = frequency of T1E1 in deme 1
x1[2] = frequency of T1E2 in deme 1
x1[3] = frequency of T2E1 in deme 1
x1[4] = frequency of T2E2 in deme 1
x2[1] = frequency of T1E1 in deme 2
x2[2] = frequency of T1E2 in deme 2
x2[3] = frequency of T2E1 in deme 2
x2[4] = frequency of T2E2 in deme 2\
\>", "Text",
 CellChangeTimes->{{3.7402271267505245`*^9, 3.7402271669454813`*^9}, {
   3.740227221754402*^9, 3.7402272661623735`*^9}, {3.7662356977589226`*^9, 
   3.7662357040729055`*^9}, {3.7662358239077272`*^9, 3.766235857129408*^9}, {
   3.780402628868245*^9, 3.7804026383977976`*^9}, 
   3.780410875019306*^9},ExpressionUUID->"f709b41d-342d-497e-9a56-\
378ca9c2042f"],

Cell["\<\
t12 = x1[3] + x1[4] = frequency of allele T2 in deme 1 (Note : the ordering \
of subscripts differs from that in the manuscript)
e12 = x1[2] + x1[4] = frequency of trait allele E2 in deme 1 (Note : the \
ordering of subscripts differs from that in the manuscript)
dd1 = x1[1] x1[4] - x1[2] x1[3] = linkage disequilibrium between T and E in \
deme 1

t22 = x2[3] + x2[4] = frequency of allele T2 in deme 2 (Note: the ordering of \
subscripts differs from that in the manuscript)
e22 = x2[2] + x2[4] = frequency of trait allele E2 in deme 2 (Note: the \
ordering of subscripts differs from that in the manuscript)
dd2 = x2[1] x2[4] - x2[2] x2[3] = linkage disequilibrium between T and E in \
deme 2
\
\>", "Text",
 CellChangeTimes->{{3.7402272818066216`*^9, 3.7402272818096247`*^9}, 
   3.740227368148076*^9, {3.7402290740915337`*^9, 3.7402291191309814`*^9}, {
   3.76623572743414*^9, 3.7662357625731325`*^9}, {3.780410958179943*^9, 
   3.780410989350832*^9}},ExpressionUUID->"d6abb6f4-5034-4902-b3e2-\
1138bb0ba594"],

Cell["\<\
For proper comparison with the corresponding magic trait model, in which only \
T1E1 and T2E2 occur, one has to assume that x1[2] = x1[3] = x2[2] = x2[3] = 0.\
\>", "Text",
 CellChangeTimes->{{3.7662330601979785`*^9, 3.766233130468777*^9}, {
  3.7752246751246986`*^9, 
  3.775224689578125*^9}},ExpressionUUID->"e103590d-f8ad-4881-96ab-\
7ffa2b03fb4e"],

Cell["\<\
Cells (boxes) with light gray background are initialization cells (can be \
initialized by Mathematica to be able to perform all computations in this \
notebook.
Cells with light red background summarize the results of a (sub) section.\
\>", "Text",
 CellChangeTimes->{{3.7900069686796384`*^9, 
  3.790007101477361*^9}},ExpressionUUID->"ebaadc81-c7bb-445c-8518-\
f77dd730c93e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Model and recursions", "Subchapter",
 CellChangeTimes->{{3.7402892585535984`*^9, 3.740289274637845*^9}, {
  3.780411078522024*^9, 
  3.780411083236295*^9}},ExpressionUUID->"45674efc-498b-4b66-8e57-\
160003a46aef"],

Cell[CellGroupData[{

Cell["2.1 Migration", "Section",
 CellChangeTimes->{{3.740227373411515*^9, 3.74022738118511*^9}, {
  3.780411103325637*^9, 
  3.780411104789783*^9}},ExpressionUUID->"e4ee8a82-14b2-4491-be31-\
2e577816f581"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x1m", "[", "i", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "m1"}], ")"}], " ", 
      RowBox[{"x1", "[", "i", "]"}]}], "+", " ", 
     RowBox[{"m1", " ", 
      RowBox[{"x2", "[", "i", "]"}]}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700562938642748*^9, 3.700562962731615*^9}, 
   3.701093439589613*^9},ExpressionUUID->"6a7c39ab-5983-480e-864a-\
108b4cfcac44"],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x2m", "[", "i", "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "m2"}], ")"}], " ", 
      RowBox[{"x2", "[", "i", "]"}]}], "+", " ", 
     RowBox[{"m2", " ", 
      RowBox[{"x1", "[", "i", "]"}]}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7005629683328648`*^9, 3.700562977196281*^9}, 
   3.701093442260399*^9},ExpressionUUID->"b75ff3b8-1e82-4c25-bf60-\
d7a63dae7941"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2 Viability selection", "Section",
 CellChangeTimes->{{3.7402274155898933`*^9, 3.740227424149059*^9}, {
  3.7804111078809814`*^9, 
  3.7804111092921667`*^9}},ExpressionUUID->"f92178a1-b183-4c63-a2ab-\
844c62495001"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w1barm", " ", "=", " ", 
   RowBox[{
    RowBox[{"x1m", "[", "2", "]"}], "+", " ", 
    RowBox[{"x1m", "[", "4", "]"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x1m", "[", "1", "]"}], "+", " ", 
       RowBox[{"x1m", "[", "3", "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm1", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x1m", "[", "1", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s1"}], ")"}], "/", "w1barm"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm1", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x1m", "[", "2", "]"}], "/", "w1barm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm1", "[", "3", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x1m", "[", "3", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s1"}], ")"}], "/", "w1barm"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm1", "[", "4", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x1m", "[", "4", "]"}], "/", "w1barm"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.7005641085294123`*^9, {3.701093445933653*^9, 3.701093452542705*^9}, 
   3.7402274446117907`*^9, {3.740246846282809*^9, 
   3.7402468588154078`*^9}},ExpressionUUID->"f4a7411e-f6c2-4a06-bc1f-\
dd875afaa2a5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w2barm", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x2m", "[", "2", "]"}], "+", " ", 
       RowBox[{"x2m", "[", "4", "]"}]}], ")"}]}], "+", 
    RowBox[{"x2m", "[", "1", "]"}], "+", " ", 
    RowBox[{"x2m", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "1", "]"}], "/", "w2barm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "2", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "3", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "3", "]"}], "/", "w2barm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xnsm2", "[", "4", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"x2m", "[", "4", "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], "/", "w2barm"}]}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.7005641085294123`*^9, {3.7005641825943413`*^9, 3.7005642771991873`*^9}, {
   3.70109346723495*^9, 3.7010934771180553`*^9}, 3.7402274486126537`*^9, {
   3.7402468705979214`*^9, 
   3.740246875614117*^9}},ExpressionUUID->"986f3bf9-4811-49e6-9a64-\
85939856eea6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xnsf1", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"xnsm1", "[", "i", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xnsf2", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"xnsm2", "[", "i", "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "4"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700564153336898*^9, 3.7005641633638563`*^9}, 
   3.701093462232667*^9, {3.7402275909335833`*^9, 
   3.7402275913178606`*^9}},ExpressionUUID->"2ff8af9a-6cff-4ebf-80f4-\
e1d5ee5bcc7e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3 Mating and sexual selection", "Section",
 CellChangeTimes->{{3.7402274649354053`*^9, 3.740227474980341*^9}, {
  3.780411113147907*^9, 
  3.7804111140114346`*^9}},ExpressionUUID->"585b79f0-76b2-4fe6-89cb-\
b7a0741afbb5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Coef", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coef", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coef", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.700562926738367*^9, {3.700563714686079*^9, 3.7005637432782793`*^9}, {
   3.700563792010023*^9, 3.700563932065588*^9}, {3.7010933937344923`*^9, 
   3.701093409745647*^9}, 
   3.7402275193009963`*^9},ExpressionUUID->"ae9b53f0-95e3-4bd1-9a4e-\
2889480ab72b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "Coef", "]"}]], "Input",
 CellChangeTimes->{{3.70109224436022*^9, 
  3.701092251755431*^9}},ExpressionUUID->"42729d73-3175-4115-95d8-\
469ca7ffbabc"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"1", "+", "\[Alpha]1"}], 
     RowBox[{"1", "+", "\[Alpha]1"}], "1", "1"},
    {
     RowBox[{"1", "+", "\[Alpha]1"}], 
     RowBox[{"1", "+", "\[Alpha]1"}], "1", "1"},
    {"1", "1", 
     RowBox[{"1", "+", "\[Alpha]2"}], 
     RowBox[{"1", "+", "\[Alpha]2"}]},
    {"1", "1", 
     RowBox[{"1", "+", "\[Alpha]2"}], 
     RowBox[{"1", "+", "\[Alpha]2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.701092297819088*^9, 3.701093434119123*^9, 3.701094102260694*^9, 
   3.701871735409504*^9, 3.7045454172721853`*^9, 3.737966084556911*^9, 
   3.7379661415339193`*^9, 3.739006471374028*^9, {3.73900660034249*^9, 
   3.73900662656387*^9}, 3.739008024276458*^9, 
   3.7856697090770493`*^9},ExpressionUUID->"4af1b733-bf61-4c8d-bd79-\
bb9b02fa40e7"]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Mate1", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"xnsf1", "[", "i", "]"}], 
      RowBox[{"xnsm1", "[", "j", "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G1", " ", "=", " ", 
   RowBox[{"Mate1", " ", "Coef"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.700564745735652*^9, {3.701093487784154*^9, 
   3.701093493743311*^9}},ExpressionUUID->"b671eef5-8b0f-4431-bf51-\
bd825f159dd2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "G1", "]"}]], "Input",
 CellChangeTimes->{{3.700564767168315*^9, 3.700564797394866*^9}, 
   3.700565411607293*^9, 
   3.701093501583993*^9},ExpressionUUID->"675f5b17-8dc4-477f-bc5a-\
f5acc435e6ed"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s1"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "1", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s1"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "2", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s1"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s1"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "3", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "4", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.7005647725791397`*^9, 3.7005647974058933`*^9}, 
   3.700565269328731*^9, 3.7005653247405977`*^9, 3.70109350277806*^9, 
   3.7010941042128763`*^9, 3.701871751359385*^9, 3.70454542303692*^9, {
   3.7379660850700808`*^9, 3.737966113501313*^9}, 3.737966150699645*^9, 
   3.739006471871078*^9, 3.739006601692979*^9, 3.739006638894753*^9, 
   3.739008025625187*^9, 
   3.785669709148011*^9},ExpressionUUID->"76c2880d-42c1-4534-9a49-\
0809e987e90e"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "1", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "2", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "3", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "1", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "3", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "3", "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m1"}], ")"}], " ", 
           RowBox[{"x1", "[", "4", "]"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m1"}], ")"}], " ", 
          RowBox[{"x1", "[", "4", "]"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "2", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "1", "]"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "m1"}], ")"}], " ", 
             RowBox[{"x1", "[", "3", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "1", "]"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"x2", "[", "3", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"x2", "[", "4", "]"}]}]}], ")"}], "2"]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.7005647725791397`*^9, 3.7005647974058933`*^9}, 
   3.700565269328731*^9, 3.7005653247405977`*^9, 3.70109350277806*^9, 
   3.7010941042128763`*^9, 3.701871751359385*^9, 3.70454542303692*^9, {
   3.7379660850700808`*^9, 3.737966113501313*^9}, 3.737966150699645*^9, 
   3.739006471871078*^9, 3.739006601692979*^9, 3.739006638894753*^9, 
   3.739008025625187*^9},ExpressionUUID->"e9cdee71-f5b7-4b85-bc0b-\
c77995f66f9a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F1", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"z1", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnsm1", "[", "j", "]"}], " ", 
        RowBox[{"Coef", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"F1", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"G1", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
      RowBox[{"z1", "[", "i", "]"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"F1", "[", 
     RowBox[{"[", 
      RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}], "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700564813779233*^9, 3.700564828637002*^9}, {
  3.701093517680121*^9, 3.701093519040131*^9}, {3.7402276614538565`*^9, 
  3.740227668286763*^9}},ExpressionUUID->"1dca5266-fbd1-4e96-ac6f-\
0b45e511c19f"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.7402285183488455`*^9, 3.7402442744159255`*^9, 3.740246893381338*^9, 
   3.7402892339483194`*^9, 3.7403699689020753`*^9, 3.740379141354968*^9, 
   3.740483490293106*^9, 3.740484427228709*^9, 3.7404846479876957`*^9, 
   3.7409021156498823`*^9, 3.7519644948722496`*^9, 3.7673508757520776`*^9, 
   3.7674443842729373`*^9, 3.7675965644092875`*^9, 3.76761844389228*^9, 
   3.767701227766004*^9, 3.769764219002515*^9, 3.7744167519617643`*^9, 
   3.7751082587871017`*^9, 3.775378383954702*^9, 3.7754543129616537`*^9, 
   3.7755385436206446`*^9, 3.7804110580219345`*^9, 3.780574020568384*^9, 
   3.7806587091807613`*^9, 3.780744783540606*^9, 3.780824601221381*^9, 
   3.780826788396846*^9, 3.7832481269822364`*^9, 3.784552190900449*^9, 
   3.784633443304057*^9, {3.785669703970108*^9, 3.7856697091699953`*^9}, 
   3.785741585299638*^9, 3.785765117756749*^9, 3.785917351429299*^9, 
   3.7859198907686214`*^9, 3.7859446857134695`*^9, 3.786009033980343*^9, 
   3.7860233233892937`*^9, 3.7861149719524965`*^9, 3.7863775837337017`*^9, 
   3.786459662680676*^9, 3.787922486491074*^9, 3.7886932841241903`*^9, 
   3.7887890511329575`*^9, 3.7888569719946213`*^9, 3.7889448830311174`*^9, 
   3.789041791290393*^9, 3.789201022256713*^9, 3.7896710833982816`*^9, 
   3.7948960802772903`*^9, 3.794981427024085*^9, 3.7950068911811814`*^9, 
   3.7950691525105824`*^9, 3.7950905619179134`*^9, 3.7953285854672728`*^9, 
   3.7954124589889174`*^9, 3.7954126040698595`*^9, 3.795872423600733*^9, 
   3.7967388369610395`*^9, 3.7974217365018044`*^9, 3.799664762818962*^9, 
   3.799737657060459*^9, 3.7998416845594196`*^9, 3.800103884207407*^9, 
   3.8001813499426093`*^9, 3.8001950829132056`*^9, 3.8005345283915834`*^9, 
   3.800625954104615*^9, {3.80070689048212*^9, 3.8007069015114145`*^9}, 
   3.800712663693735*^9, 3.801149294618143*^9, 
   3.8012268082746067`*^9},ExpressionUUID->"ecc68088-b472-4ae5-92ea-\
d9d46a06c4a4"]
}, Closed]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Mate2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"xnsf2", "[", "i", "]"}], 
      RowBox[{"xnsm2", "[", "j", "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", " ", "=", " ", 
   RowBox[{"Mate2", " ", "Coef"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.700564745735652*^9, {3.700565744404601*^9, 3.700565751475971*^9}, {
   3.701093546067524*^9, 
   3.7010935473945103`*^9}},ExpressionUUID->"165845f6-eb8f-4ab2-96bd-\
e04c1ed02628"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TableForm", "[", "G2", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.700564767168315*^9, 3.700564797394866*^9}, 
   3.700565411607293*^9, 
   3.700565753059012*^9},ExpressionUUID->"248fe3e7-3de9-4422-bed8-\
5c8b0c413042"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F2", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"j", ",", " ", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"z2", "[", "i", "]"}], " ", "=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xnsm2", "[", "j", "]"}], " ", 
        RowBox[{"Coef", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"F2", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", 
     RowBox[{
      RowBox[{"G2", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
      RowBox[{"z2", "[", "i", "]"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", "F2", "]"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.700564813779233*^9, 3.700564828637002*^9}, 
   3.7005657547476053`*^9, {3.701093551675559*^9, 3.701093553160282*^9}, {
   3.740227686822119*^9, 
   3.7402276927103586`*^9}},ExpressionUUID->"f832c0dc-3421-4c0f-a58e-\
da57f4afa815"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "2", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"m2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "1", "]"}]}]}], ")"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "3", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "3", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "m2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"m2", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "m2"}], ")"}], " ", 
          RowBox[{"x2", "[", "1", "]"}]}]}], ")"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"x2", "[", "2", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       RowBox[{"x2", "[", "3", "]"}], " ", 
       RowBox[{"x2", "[", "4", "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "s2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"x2", "[", "4", "]"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "1", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "2", "]"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "m2"}], ")"}], " ", 
              RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"x2", "[", "2", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "3", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}], " ", 
           RowBox[{"x2", "[", "4", "]"}]}], 
          RowBox[{"m2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "1", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "m2"}], ")"}], " ", 
            RowBox[{"x2", "[", "3", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "2", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "m2"}], ")"}], " ", 
               RowBox[{"x2", "[", "4", "]"}]}]}], ")"}]}]}]]}], ")"}]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.740228518493945*^9, 3.74024427460944*^9, 3.7402468935844855`*^9, 
   3.74028923408943*^9, 3.740369969027071*^9, 3.74037914147997*^9, 
   3.7404834905119224`*^9, 3.740484427416198*^9, 3.7404846481751847`*^9, 
   3.7409021158061314`*^9, 3.7519644950283737`*^9, 3.767350875923956*^9, 
   3.7674443844604425`*^9, 3.7675965646124167`*^9, 3.7676184440954094`*^9, 
   3.7677012279160852`*^9, 3.7697642191744137`*^9, 3.7744167521198792`*^9, 
   3.775108258916192*^9, 3.775378384089797*^9, 3.7754543131607924`*^9, 
   3.7755385438322144`*^9, 3.780411058199833*^9, 3.780574020741286*^9, 
   3.7806587093266706`*^9, 3.7807447837025137`*^9, 3.78082460139828*^9, 
   3.7808267885427694`*^9, 3.783248127145132*^9, 3.7845521910723515`*^9, 
   3.784633443529955*^9, {3.7856697041360097`*^9, 3.7856697093578997`*^9}, 
   3.7857415854685535`*^9, 3.785765117888669*^9, 3.7859173516129694`*^9, 
   3.785919890984497*^9, 3.785944685900381*^9, 3.786009034157029*^9, 
   3.7860233235754457`*^9, 3.7861149722210035`*^9, 3.786377583934589*^9, 
   3.7864596628545675`*^9, 3.7879224866389894`*^9, 3.788693284266096*^9, 
   3.7887890512828875`*^9, 3.788856972153525*^9, 3.788944883233*^9, 
   3.789041791470304*^9, 3.789201022460636*^9, 3.789671083610162*^9, 
   3.7948960805561333`*^9, 3.794981427326911*^9, 3.795006891412051*^9, 
   3.795069152777856*^9, 3.7950905621787667`*^9, 3.795328585849062*^9, 
   3.7954124593366995`*^9, 3.7954126044256544`*^9, 3.7958724238715925`*^9, 
   3.79673883721591*^9, 3.7974217367876415`*^9, 3.799664763126238*^9, 
   3.7997376572868853`*^9, 3.799841684923464*^9, 3.800103884454747*^9, 
   3.800181350203912*^9, 3.8001950831755104`*^9, 3.800534528617977*^9, 
   3.8006259543599668`*^9, 3.800706890747455*^9, 3.800712663948054*^9, 
   3.8011492948594522`*^9, 
   3.801226808467066*^9},ExpressionUUID->"75646b6e-49c6-4753-98c2-\
e94aa3c77ea9"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4 Recombination", "Section",
 CellChangeTimes->{{3.7402278884583654`*^9, 3.740227895256271*^9}, {
  3.780411116394022*^9, 
  3.780411117300498*^9}},ExpressionUUID->"ca2cd561-adc1-4aef-84ee-\
f94acd890634"],

Cell["pop 1", "Text",
 CellChangeTimes->{{3.538468475616063*^9, 3.538468476934721*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"a5fc3a9f-8e31-43df-9884-02c994032103"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x1t1", "[", "1", "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"F1", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], " ", 
      RowBox[{"F1", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538468433384053*^9, 3.5384684566926107`*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"62179801-294c-4c62-9c7e-149bd42ceeba"],

Cell["\<\
x1t1[2] = Simplify[(1/2) F1[[1,2]] + (1/2) r F1[[1,4]] + 
\t(1/2) F1[[2,1]] + F1[[2,2]] + (1/2)(1-r)F1[[2,3]] + 
\t(1/2) F1[[2,4]] + (1/2) (1-r) F1[[3,2]] + 
\t(1/2) r F1[[4,1]] + (1/2) F1[[4,2]]];\
\>", "Input",
 CellChangeTimes->{{3.538468435569471*^9, 3.538468456960092*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"a8db8bec-4019-4fda-8eca-c067991683f4"],

Cell["\<\
x1t1[3] = Simplify[(1/2) F1[[1,3]] + (1/2) r F1[[1,4]] +
\t(1/2) (1-r) F1[[2,3]] + (1/2) F1[[3,1]] + 
\t(1/2) (1-r) F1[[3,2]] + F1[[3,3]] + (1/2) F1[[3,4]] +
\t(1/2) r F1[[4,1]] + (1/2) F1[[4,3]]];\
\>", "Input",
 CellChangeTimes->{{3.538468436777104*^9, 3.538468457124481*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"8af30bce-afc5-4717-8e1f-873fd55a6126"],

Cell["\<\
x1t1[4] = Simplify[(1/2) (1-r) F1[[1,4]] + (1/2) r F1[[2,3]] + 
\t(1/2) F1[[2,4]] + (1/2) r F1[[3,2]] + (1/2) F1[[3,4]] +
\t(1/2) (1-r) F1[[4,1]] + (1/2) F1[[4,2]] + (1/2) F1[[4,3]] + F1[[4,4]]];\
\>", "Input",
 CellChangeTimes->{{3.5384684380894537`*^9, 3.538468457275229*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"3033b513-68ef-4674-9775-34ba941eb8c1"],

Cell["pop 2", "Text",
 CellChangeTimes->{{3.538468479471239*^9, 3.538468480127818*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"4b3b4190-40d5-4cb9-be9a-02ae4a60f069"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x2t1", "[", "1", "]"}], "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"F2", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "4"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "3"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "1"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", "r", " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "2"}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], " ", 
      RowBox[{"F2", "[", 
       RowBox[{"[", 
        RowBox[{"4", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.538468433384053*^9, 3.538468509764133*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"7414bd3c-8f82-4a3b-8d23-18830e1d4e48"],

Cell["\<\
x2t1[2] = Simplify[(1/2) F2[[1,2]] + (1/2) r F2[[1,4]] + 
\t(1/2) F2[[2,1]] + F2[[2,2]] + (1/2)(1-r)F2[[2,3]] + 
\t(1/2) F2[[2,4]] + (1/2) (1-r) F2[[3,2]] + 
\t(1/2) r F2[[4,1]] + (1/2) F2[[4,2]]];\
\>", "Input",
 CellChangeTimes->{{3.538468435569471*^9, 3.5384685099268303`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"86cc909a-34bb-4651-bd06-5d9ba0613150"],

Cell["\<\
x2t1[3] = Simplify[(1/2) F2[[1,3]] + (1/2) r F2[[1,4]] +
\t(1/2) (1-r) F2[[2,3]] + (1/2) F2[[3,1]] + 
\t(1/2) (1-r) F2[[3,2]] + F2[[3,3]] + (1/2) F2[[3,4]] +
\t(1/2) r F2[[4,1]] + (1/2) F2[[4,3]]];\
\>", "Input",
 CellChangeTimes->{{3.538468436777104*^9, 3.538468457124481*^9}, {
  3.538468490283471*^9, 3.538468510081058*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"0740709f-45d9-4ee8-87bd-235dd6cd3c57"],

Cell["\<\
x2t1[4] = Simplify[(1/2) (1-r) F2[[1,4]] + (1/2) r F2[[2,3]] + 
\t(1/2) F2[[2,4]] + (1/2) r F2[[3,2]] + (1/2) F2[[3,4]] +
\t(1/2) (1-r) F2[[4,1]] + (1/2) F2[[4,2]] + (1/2) F2[[4,3]] + F2[[4,4]]];\
\>", "Input",
 CellChangeTimes->{{3.5384684380894537`*^9, 3.538468457275229*^9}, {
  3.538468492645274*^9, 3.538468509609948*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"125dbbf9-2071-40e3-baf6-a67844d37387"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5 Recursion relations for allele frequencies and LD", "Section",
 CellChangeTimes->{{3.740227990421271*^9, 3.740228009281849*^9}, {
  3.780411164898862*^9, 
  3.780411165770355*^9}},ExpressionUUID->"f6fa4d2b-e18f-409d-b0a7-\
cf9641835255"],

Cell[CellGroupData[{

Cell["2.5.1 ", "Subsection",
 CellChangeTimes->{{3.790006403484215*^9, 
  3.790006513128176*^9}},ExpressionUUID->"9ad52433-627e-4f77-9ea8-\
845647f73b13"],

Cell["\<\
In 2.5.2, the recursion relations are computed. Because this is time \
consuming, the result obtained here is simply used as a definition for \
itpseudom[s1, s2, \[Alpha]1, \[Alpha]2, m1, m2, r][{t12, e12, dd1, t22, e22, \
dd2}] in 2.6.\
\>", "Text",
 CellChangeTimes->{{3.7900065157465577`*^9, 
  3.790006600575121*^9}},ExpressionUUID->"5b9577f9-cd81-44a8-a07f-\
20a36ce7c645"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5.2 Computation", "Subsection",
 CellChangeTimes->{{3.7900064882625475`*^9, 
  3.7900065080852947`*^9}},ExpressionUUID->"cc75ea4d-286f-4e9d-85f2-\
5004708d1819"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t12"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "e12"}], ")"}]}], " ", "+", "dd1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t12"}], ")"}], "e12"}], "-", " ", "dd1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "3", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"t12", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "e12"}], ")"}]}], " ", "-", " ", "dd1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x1", "[", "4", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"t12", " ", "e12"}], " ", "+", " ", "dd1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x2", "[", "1", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t22"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "e22"}], ")"}]}], " ", "+", "dd2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x2", "[", "2", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t22"}], ")"}], "e22"}], "-", " ", "dd2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x2", "[", "3", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"t22", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "e22"}], ")"}]}], " ", "-", " ", "dd2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x2", "[", "4", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"t22", " ", "e22"}], " ", "+", " ", "dd2"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.701093765952938*^9, 3.7010938338911047`*^9}, {
  3.701093999535063*^9, 3.701094019264434*^9}, {3.7402280193531003`*^9, 
  3.7402281143308067`*^9}},ExpressionUUID->"7c5b804c-8e2e-4d97-b6e4-\
90f9535f16e2"],

Cell["e12 is E2 in deme1;  t12 is T2 in deme 1, etc.", "Text",
 CellChangeTimes->{{3.740228362289694*^9, 
  3.7402284206205215`*^9}},ExpressionUUID->"5cb7c134-a0ba-4a9e-8abe-\
f5bbfe4ed844"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e12time1", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x1t1", "[", "2", "]"}], " ", "+", " ", 
    RowBox[{"x1t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701093841355938*^9, 
  3.701093868213223*^9}},ExpressionUUID->"1fd31648-1bcd-472d-87e9-\
4bba2dc366eb"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s1", "+", 
      RowBox[{"e12", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
      RowBox[{"e22", " ", "m1", " ", "s1"}]}], ")"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e22", " ", "m1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e22", " ", "m1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"dd1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}],
         "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e22", " ", "m1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}], "+", 
          RowBox[{"e22", " ", "m1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"dd1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
        RowBox[{"e12", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
        RowBox[{"m1", " ", 
         RowBox[{"(", 
          RowBox[{"dd2", "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"dd1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
        RowBox[{"dd2", " ", "m1"}], "-", 
        RowBox[{"e12", " ", "t12"}], "+", 
        RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
        RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], 
     RowBox[{"1", "+", 
      RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"t12", " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]2", "-", 
         RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
      RowBox[{"s1", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"m1", "+", 
            RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
        ")"}]}]}]], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e22", " ", "m1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"t12", " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]2", "-", 
          RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"m1", "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e22", " ", "m1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"t12", " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]2", "-", 
          RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"m1", "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"t12", " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]2", "-", 
          RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"m1", "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"t12", " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]2", "-", 
          RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"m1", "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "-", 
         RowBox[{"e12", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"dd1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
         RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}], "-", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
       RowBox[{"t12", " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]2", "-", 
          RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
       RowBox[{"s1", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"m1", "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"dd1", "-", 
         RowBox[{"dd1", " ", "m1"}], "+", 
         RowBox[{"dd2", " ", "m1"}], "+", 
         RowBox[{"e12", " ", "t12"}], "-", 
         RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
         RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], 
     RowBox[{"1", "+", 
      RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"t12", " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]2", "-", 
         RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
      RowBox[{"s1", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"m1", "+", 
            RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
        ")"}]}]}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7010941105309343`*^9, 3.701871757809156*^9, 
  3.70454542862932*^9, 3.739006374052558*^9, 3.7390064792103987`*^9, 
  3.739007986836006*^9, 3.739008031937326*^9, 3.740228595765559*^9, 
  3.740246958185178*^9, 
  3.7856697434427567`*^9},ExpressionUUID->"fbbbb8cb-691c-4482-8590-\
b39ee7b510a4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t12time1", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x1t1", "[", "3", "]"}], " ", "+", " ", 
    RowBox[{"x1t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.70109385814884*^9, 
  3.701093878237994*^9}},ExpressionUUID->"8bff96ed-ad44-4a9c-b692-\
17692eda0f7b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dd1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
      RowBox[{"dd2", " ", "m1", " ", "s1"}], "+", "t12", "-", 
      RowBox[{"m1", " ", "t12"}], "+", 
      RowBox[{"s1", " ", "t12"}], "-", 
      RowBox[{"e12", " ", "s1", " ", "t12"}], "-", 
      RowBox[{"m1", " ", "s1", " ", "t12"}], "+", 
      RowBox[{"e12", " ", "m1", " ", "s1", " ", "t12"}], "+", 
      RowBox[{"m1", " ", "t22"}], "+", 
      RowBox[{"m1", " ", "s1", " ", "t22"}], "-", 
      RowBox[{"e22", " ", "m1", " ", "s1", " ", "t22"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
      RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", "m1", " ", 
       SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["m1", "2"], " ", 
       SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{
       SuperscriptBox["m1", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12"}], "-", 
         RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{"m1", " ", 
          RowBox[{"(", 
           RowBox[{"t22", "+", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       "+", 
      RowBox[{"s1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", 
         RowBox[{"2", " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"4", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1"}], 
         "+", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "+", 
         RowBox[{"4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
         RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"6", " ", "t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"6", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"6", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
         RowBox[{
         "2", " ", "dd1", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "2", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"4", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
         RowBox[{
         "4", " ", "dd1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "4", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "8", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{
         "4", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"8", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{
         "4", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{
         "4", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{
         "8", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]1",
           " ", "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"e22", " ", "m1", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "m1", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
               RowBox[{"m1", " ", "t22", " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
             SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"t12", " ", 
             RowBox[{"(", 
              RowBox[{"6", "-", 
               RowBox[{"3", " ", "m1"}], "-", 
               RowBox[{"2", " ", "m1", " ", "t22"}]}], ")"}], " ", 
             "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                SuperscriptBox["t12", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
               RowBox[{"m1", " ", "t12", " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "+", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["s1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
         RowBox[{
          SuperscriptBox["dd1", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]1"}], 
         "+", 
         RowBox[{
          SuperscriptBox["dd1", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "+", 
         RowBox[{
          SuperscriptBox["dd2", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
         RowBox[{
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1"}], 
         "+", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "-", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "+", 
         RowBox[{"2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], 
         "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
          "\[Alpha]1"}], "+", 
         RowBox[{
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
         RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["dd1", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
          SuperscriptBox["dd1", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["dd2", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["dd1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{
         "2", " ", "dd1", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{
         "2", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "4", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["dd1", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"4", " ", "dd1", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["dd2", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"2", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
         RowBox[{
         "4", " ", "dd1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "8", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{
         "4", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"4", " ", "m1", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{
         "2", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{
         "4", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"4", " ", "dd1", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", "dd2", " ", 
          SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{
         "4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]1",
           " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["m1", "2"], " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
          SuperscriptBox["e12", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{
             SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "t12", "+", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["e22", "2"], " ", 
          SuperscriptBox["m1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "t22", "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"e22", " ", "m1", " ", 
          RowBox[{"(", 
           RowBox[{"4", "-", 
            RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "-", 
            RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
            "2", " ", "dd2", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
            "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "m1", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
            RowBox[{"dd1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"t12", " ", "t22"}], "-", 
               RowBox[{"m1", " ", "t12", " ", "t22"}], "+", 
               RowBox[{"m1", " ", 
                SuperscriptBox["t22", "2"]}], "-", 
               RowBox[{"t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{"2", " ", "m1", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"dd2", " ", "m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "t22"}], "+", "\[Alpha]2", "-", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"dd1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"4", "-", 
            RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
            RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
            RowBox[{"6", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "-", 
            RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
            RowBox[{
            "2", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{
            "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "m1", " ", 
             SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{
            "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["t12", "2"], "-", 
               RowBox[{"m1", " ", 
                SuperscriptBox["t12", "2"]}], "+", 
               RowBox[{"m1", " ", "t12", " ", "t22"}], "-", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m1", " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{"dd2", " ", "m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "t12"}], "+", "\[Alpha]2", "-", 
                  RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
               RowBox[{"dd1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"t12", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{"e22", " ", "m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "-", 
               RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t12", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", 
                  RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"t12", " ", 
                   RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], 
  "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "s1", "+", 
      RowBox[{"e12", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
      RowBox[{"e22", " ", "m1", " ", "s1"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t12", "-", 
         RowBox[{"m1", " ", "t12"}], "+", 
         RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
      RowBox[{"s1", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
         RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
         RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
         RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
         RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
         RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
         RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}], 
           ")"}]}], "+", 
         RowBox[{"e22", " ", "m1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1", "-", 
            RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
    " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"t12", " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]2", "-", 
         RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
      RowBox[{"s1", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
         RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
         RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"e12", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
         RowBox[{"e22", " ", 
          RowBox[{"(", 
           RowBox[{"m1", "+", 
            RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.7010941166398487`*^9, 3.701871768000951*^9, 3.704545435308175*^9, 
   3.739006483364356*^9, 3.7390080359231853`*^9, 3.7402286054215097`*^9, {
   3.740246968670679*^9, 3.7402469783748455`*^9}, 
   3.785669747877144*^9},ExpressionUUID->"ef77f795-e7d3-42f8-8ec5-\
2a37c2fa7d67"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dd1time1", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"x1t1", "[", "1", "]"}], " ", 
    RowBox[{"x1t1", "[", "4", "]"}]}], " ", "-", " ", 
   RowBox[{
    RowBox[{"x1t1", "[", "2", "]"}], " ", 
    RowBox[{"x1t1", "[", "3", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7010938816863823`*^9, 3.701093892910983*^9}, {
  3.740229475687477*^9, 
  3.740229476374968*^9}},ExpressionUUID->"d0457090-d67b-4992-8118-\
75fc2bdd6344"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
            " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s1"}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "m1"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}]}], ")"}], "2"]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
           "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e12", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd1", "+", 
            RowBox[{"e12", " ", "t12"}], "-", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "+", 
          RowBox[{"m1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
             "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "dd1"}], "+", 
           RowBox[{"e12", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"dd1", "+", 
           RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
        RowBox[{"m1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "dd2"}], "+", 
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"m1", " ", 
         RowBox[{"(", 
          RowBox[{"dd2", "+", 
           RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "s1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "m1"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e12"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
           RowBox[{"m1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd1"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
           "+", 
           RowBox[{"m1", " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"m1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
          ")"}]}]}], ")"}], "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.7010941174422626`*^9, 3.7018717693091183`*^9, 
  3.704545441163533*^9, 3.739006483583737*^9, 3.739008036113738*^9, 
  3.740228605743743*^9, 3.7402294789668407`*^9, 3.740246978640499*^9, 
  3.7856697480640345`*^9},ExpressionUUID->"a56d8479-e839-4384-8eb8-\
5af54a7e667e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e22time1", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x2t1", "[", "2", "]"}], " ", "+", " ", 
    RowBox[{"x2t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.701093841355938*^9, 3.701093868213223*^9}, {
  3.7010940435361967`*^9, 
  3.701094068009466*^9}},ExpressionUUID->"b78740fe-2d67-47d8-b98a-\
81eea629522c"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "s2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["e12", "3"], " ", 
         SuperscriptBox["m2", "3"], " ", 
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["e22", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], "3"], " ", 
         SuperscriptBox["s2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"dd2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "-", 
           RowBox[{"dd1", " ", "m2"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
              RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
              RowBox[{"m2", " ", "t12"}], "-", "t22", "+", 
              RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
              RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
              RowBox[{"m2", " ", "t12"}], "-", "t22", "+", 
              RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
          ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["e12", "2"], " ", 
         SuperscriptBox["m2", "2"], " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "-", 
           RowBox[{"2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "+", 
           RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"m2", " ", 
            SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"\[Alpha]1", " ", 
            RowBox[{"(", 
             RowBox[{"4", "-", 
              RowBox[{"3", " ", "t12"}], "-", 
              RowBox[{"m2", " ", "t12"}], "+", 
              SuperscriptBox["t12", "2"], "-", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t12", "2"]}], "-", "t22", "+", 
              RowBox[{"m2", " ", "t22"}], "-", 
              RowBox[{"t12", " ", "t22"}], "+", 
              RowBox[{"m2", " ", "t12", " ", "t22"}], "+", 
              RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
              "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]2", "+", 
                 RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t12"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["e22", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "-", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "+", 
           RowBox[{"2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "-", 
           RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
           RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"m2", " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{"\[Alpha]1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "4"}], "+", 
              RowBox[{"m2", " ", "t12"}], "+", 
              RowBox[{"4", " ", "t22"}], "-", 
              RowBox[{"m2", " ", "t22"}], "+", 
              RowBox[{"m2", " ", "t12", " ", "t22"}], "-", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t22", "2"]}], "-", 
              RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
              "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "\[Alpha]2", "+", 
                 RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", "dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                ")"}]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "e12", " ", "m2", " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "-", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", "t12", "-", 
                 RowBox[{"2", " ", "t22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "\[Alpha]2"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                 RowBox[{"t12", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"e12", " ", "m2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "+", 
           RowBox[{"2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "-", 
           RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "t12", " ", "\[Alpha]2"}],
            "-", 
           RowBox[{
           "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{
           "3", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{"dd1", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"dd2", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"m2", " ", 
            SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{
           "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{
           "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"dd1", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{"dd2", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"3", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}],
            "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "m2", " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{"\[Alpha]1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["dd2", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["dd1", "2"], " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t12", "-", "t22"}], ")"}]}], "+", "t22"}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"2", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"t12", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2", "+", 
                    RowBox[{"2", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}], "+", 
              RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"t12", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "m2", "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}], "-", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                 RowBox[{
                 "4", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
                 "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"t12", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "m2", "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"e22", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "+", 
           RowBox[{"2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
           "-", 
           RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
           RowBox[{
           "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]2"}], "+", 
           RowBox[{"dd1", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"dd2", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{
           "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"dd1", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{"dd2", " ", 
            SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
            "\[Alpha]2"}], "+", 
           RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
            "\[Alpha]2"}], "-", 
           RowBox[{"m2", " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["e12", "2"], " ", 
            SuperscriptBox["m2", "2"], " ", 
            SuperscriptBox["s2", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "-", 
              RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", "t22", "+", 
                 RowBox[{
                  SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"2", " ", "t12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"e12", " ", "m2", " ", "s2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "8"}], "-", 
              RowBox[{"4", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
              RowBox[{
              "4", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
              RowBox[{
              "4", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
              RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"4", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"4", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
              RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
              RowBox[{"m2", " ", 
               SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"\[Alpha]1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "8"}], "+", 
                 RowBox[{"3", " ", "t12"}], "+", 
                 RowBox[{"2", " ", "m2", " ", "t12"}], "+", 
                 RowBox[{"m2", " ", 
                  SuperscriptBox["t12", "2"]}], "+", 
                 RowBox[{"5", " ", "t22"}], "-", 
                 RowBox[{"2", " ", "m2", " ", "t22"}], "-", 
                 RowBox[{"t12", " ", "t22"}], "+", 
                 SuperscriptBox["t22", "2"], "-", 
                 RowBox[{"m2", " ", 
                  SuperscriptBox["t22", "2"]}], "-", 
                 RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                 RowBox[{"4", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"4", " ", "m2", " ", 
                  SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"4", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"4", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{"4", " ", "m2", " ", 
                  SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                 RowBox[{"4", " ", "dd2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t12", "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"4", " ", "dd1", " ", "m2", " ", "s2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t12", "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{"\[Alpha]1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["dd2", "2"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
               SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["dd1", "2"], " ", 
               SuperscriptBox["m2", "2"], " ", 
               SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t12", "-", "t22"}], ")"}]}], "+", "t22"}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", 
                 RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t12", "-", "t22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{"3", "-", 
                 RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"t22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t12", "-", "t22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"dd2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "3"}], "+", "t22", "+", 
                 RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                 RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"t22", "-", 
                    RowBox[{"4", " ", "dd1", " ", "s2", " ", "\[Alpha]2"}], 
                    "+", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"e22", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
        RowBox[{"e12", " ", "m2", " ", "s2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Alpha]1", "-", 
        RowBox[{"dd2", " ", "s2", " ", "\[Alpha]1"}], "-", 
        RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "+", 
        RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
        RowBox[{"m2", " ", "t12", " ", "\[Alpha]1"}], "-", 
        RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
        RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
        RowBox[{"e12", " ", "m2", " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]1", "-", 
           RowBox[{"t12", " ", "\[Alpha]1"}]}], ")"}]}], "+", 
        RowBox[{"e22", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
          ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
        RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
        RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
        RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
        RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
        RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
        RowBox[{"e12", " ", "m2", " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
        RowBox[{"e22", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.701094119583796*^9, 3.701871772210101*^9, 
  3.7045454459347982`*^9, 3.739006487414225*^9, 3.739008040639377*^9, 
  3.740228617552244*^9, 3.7402469829847174`*^9, 
  3.785669751569967*^9},ExpressionUUID->"51c6dea0-3d6f-4760-8b63-\
3c02a19e6aa6"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t22time1", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"x2t1", "[", "3", "]"}], " ", "+", " ", 
    RowBox[{"x2t1", "[", "4", "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.70109385814884*^9, 3.701093878237994*^9}, {
  3.7010940446160803`*^9, 
  3.701094069865596*^9}},ExpressionUUID->"7d7c2083-bec3-421c-af82-\
0f794261a92c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dd2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
      RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
      RowBox[{"m2", " ", "t12"}], "-", 
      RowBox[{"e12", " ", "m2", " ", "s2", " ", "t12"}], "-", "t22", "+", 
      RowBox[{"m2", " ", "t22"}], "-", 
      RowBox[{"e22", " ", "s2", " ", "t22"}], "+", 
      RowBox[{"e22", " ", "m2", " ", "s2", " ", "t22"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{
       SuperscriptBox["dd1", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "-", 
      RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{
      "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]1"}], 
      "+", 
      RowBox[{"2", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1"}], 
      "-", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1"}], 
      "+", 
      RowBox[{
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]1"}], "+", 
      RowBox[{
      "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1"}], 
      "-", 
      RowBox[{
      "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1"}], 
      "-", 
      RowBox[{"2", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1"}], 
      "+", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1"}], 
      "+", 
      RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]1"}], 
      "+", 
      RowBox[{
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
      RowBox[{"2", " ", "m2", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
      RowBox[{
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
      RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
      RowBox[{"3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["dd1", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{"2", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]2"}], 
      "-", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "-", 
      RowBox[{
      "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "-", 
      RowBox[{"2", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{"2", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
      "+", 
      RowBox[{
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", "m2", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
      RowBox[{
      "2", " ", "dd2", " ", "s2", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{
      "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1", " ", 
       "\[Alpha]2"}], "+", 
      RowBox[{
      "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1", " ", 
       "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{"4", " ", "dd1", " ", "dd2", " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["dd2", "2"], " ", "m2", " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd1", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", "dd1", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["dd2", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{
      "2", " ", "m2", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "+", 
      RowBox[{"4", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "4", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]1", " ", 
       "\[Alpha]2"}], "+", 
      RowBox[{
      "4", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "-", 
      RowBox[{
      "8", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", "dd1", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "+", 
      RowBox[{"4", " ", "dd2", " ", 
       SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "+", 
      RowBox[{
      "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
       "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", "\[Alpha]1", 
       " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "-", 
      RowBox[{"4", " ", "m2", " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
      RowBox[{
       SuperscriptBox["e12", "2"], " ", 
       SuperscriptBox["m2", "2"], " ", 
       SuperscriptBox["s2", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t12", "+", 
            RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       "+", 
      RowBox[{
       SuperscriptBox["e22", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
       SuperscriptBox["s2", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t22", "+", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}],
       "-", 
      RowBox[{"e12", " ", "m2", " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{
         "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t12", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "m2", " ", 
          SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
         RowBox[{"dd2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{"2", " ", "t12"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"m2", " ", 
             SuperscriptBox["t12", "2"]}], "-", 
            RowBox[{"t12", " ", "t22"}], "+", 
            RowBox[{"m2", " ", "t12", " ", "t22"}], "+", 
            RowBox[{"t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "m2", " ", 
             SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{
            "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "t12"}], "+", "\[Alpha]2", "-", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"t12", "-", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], "-", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "-", 
         RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
         RowBox[{"3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
         "-", 
         RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
         RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{
         "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", 
          "\[Alpha]2"}], "-", 
         RowBox[{
         "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
          "\[Alpha]2"}], "+", 
         RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "m2", " ", 
          SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
         RowBox[{"2", " ", "\[Alpha]1", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"m2", " ", "t12", " ", "t22"}], "-", 
            SuperscriptBox["t22", "2"], "+", 
            RowBox[{"m2", " ", 
             SuperscriptBox["t22", "2"]}], "+", 
            RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{
            "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "m2", " ", 
             SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
            RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "t22"}], "+", "\[Alpha]2", "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"dd2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"t22", "-", "\[Alpha]2", "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"e12", " ", "m2", " ", "s2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "-", 
            RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"t12", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
            RowBox[{"2", " ", "\[Alpha]1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "-", 
               RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"t12", " ", 
                RowBox[{"(", 
                 RowBox[{"t22", "-", "\[Alpha]2", "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
              ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"e12", " ", "m2", " ", "s2"}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{"s2", "-", 
         RowBox[{"m2", " ", "s2"}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]1", "-", 
      RowBox[{"dd2", " ", "s2", " ", "\[Alpha]1"}], "-", 
      RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "+", 
      RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
      RowBox[{"m2", " ", "t12", " ", "\[Alpha]1"}], "-", 
      RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
      RowBox[{"e12", " ", "m2", " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]1", "-", 
         RowBox[{"t12", " ", "\[Alpha]1"}]}], ")"}]}], "+", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}], 
        ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
      RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
      RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
      RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
      RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
      RowBox[{"e12", " ", "m2", " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
      RowBox[{"e22", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.701094121338036*^9, 3.701871774026083*^9, 
  3.704545448333626*^9, 3.7390064918084917`*^9, 3.739008044563121*^9, 
  3.7402286229781523`*^9, 3.7402469898604565`*^9, 
  3.7856697554317107`*^9},ExpressionUUID->"83e8762c-0f2d-45a1-aae3-\
b3b72ef0e22d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dd2time1", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"x2t1", "[", "1", "]"}], " ", 
    RowBox[{"x2t1", "[", "4", "]"}]}], " ", "-", " ", 
   RowBox[{
    RowBox[{"x2t1", "[", "2", "]"}], " ", 
    RowBox[{"x2t1", "[", "3", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7010938816863823`*^9, 3.701093892910983*^9}, {
  3.7010940460003757`*^9, 3.701094065137371*^9}, {3.740229455094648*^9, 
  3.740229456839904*^9}},ExpressionUUID->"be552c87-6678-4e33-8d1f-\
fff285a894e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "s2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
            "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
            "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
          "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "s2"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "dd2"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"dd2", "+", 
              RowBox[{"e22", " ", "t22"}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", "dd2", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}], "+", 
               RowBox[{"m2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", "dd2", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}], "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
        "2"]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "s2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "dd2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", "dd2", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"dd2", "+", 
            RowBox[{"e22", " ", "t22"}], "+", 
            RowBox[{"m2", " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "-", "dd2", "+", 
               RowBox[{"e12", " ", "t12"}], "-", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"(", 
            RowBox[{"dd1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e12"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "dd2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}]}],
             ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"dd2", "+", 
             RowBox[{"e22", " ", "t22"}], "+", 
             RowBox[{"m2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", "dd2", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m2", " ", 
         RowBox[{"(", 
          RowBox[{"dd1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e12"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"m2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "dd1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"dd2", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e22"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "dd2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "s2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e22", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", "t22"}], ")"}]}], "+", 
           RowBox[{"e22", " ", "t22"}], "+", 
           RowBox[{"m2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"1", "-", "t22"}], ")"}]}], "-", 
              RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}]}], ")"}], 
      "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.701094122097896*^9, 3.701871774855743*^9, 
  3.704545449879075*^9, 3.73900649194268*^9, 3.73900804472447*^9, 
  3.7402286239888945`*^9, 3.7402294604955373`*^9, 3.740246990141737*^9, 
  3.7856697556015935`*^9},ExpressionUUID->"ab039c82-9f91-40a2-9a79-\
55b1c755b949"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
2.6 The main recursion itpseudom[s1, s2, \[Alpha]1, \[Alpha]2, m1, m2, \
r][{t12, e12, dd1, t22, e22, dd2}]\
\>", "Section",
 CellChangeTimes->{{3.740228744175974*^9, 3.7402287477835712`*^9}, {
  3.740228784183831*^9, 3.7402288216597786`*^9}, {3.740229205798175*^9, 
  3.740229213884983*^9}, {3.780411167883108*^9, 
  3.78041116891051*^9}},ExpressionUUID->"aceee533-0cdd-4bfa-9206-\
27243b25cc5d"],

Cell["\<\
For given parameters {s1, s2, \[Alpha]1, \[Alpha]2, m1, m2, r}, itpseudom \
computes {t12(t+1), e12(t+1), dd1(t+1), t22(t+1), e22(t+1), dd2(t+1)} from \
{t12(t), e12(t), dd1(t), t22(t), e22(t), dd2(t)} .
Because computation of e12time1, etc (see above) is time consuming, we define \
itpseudom[s1,s2,\[Alpha]1,\[Alpha]2,m1,m2,r][{t12,e12,dd1,t22,e22,dd2}] \
explicitly by the right-hand side of {t12time1, e12time1, dd1time1, t22time1, \
e22time1, dd2time1}, where the latter was computed in 2.5.2.\
\>", "Text",
 CellChangeTimes->{{3.718640529283265*^9, 3.7186406415024853`*^9}, {
   3.7186406839757323`*^9, 3.7186406994152765`*^9}, {3.7251782532936277`*^9, 
   3.7251782548857718`*^9}, 3.725874063048973*^9, 3.7402288352185307`*^9, {
   3.740229219806268*^9, 3.7402292412457*^9}, {3.7402293663597527`*^9, 
   3.7402294436554327`*^9}, 3.7804112394555845`*^9, 3.790006362551173*^9, {
   3.7900066161924644`*^9, 3.7900067497704625`*^9}},
 FontColor->GrayLevel[
  0],ExpressionUUID->"f17e0918-4c67-44eb-985b-e7e8d140090e"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"itpseudom", "[", 
     RowBox[{
     "s1_", ",", "s2_", ",", "\[Alpha]1_", ",", "\[Alpha]2_", ",", "m1_", ",",
       "m2_", ",", "r_"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{
     "t12_", ",", "e12_", ",", "dd1_", ",", "t22_", ",", "e22_", ",", 
      "dd2_"}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"dd1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
          RowBox[{"dd2", " ", "m1", " ", "s1"}], "+", "t12", "-", 
          RowBox[{"m1", " ", "t12"}], "+", 
          RowBox[{"s1", " ", "t12"}], "-", 
          RowBox[{"e12", " ", "s1", " ", "t12"}], "-", 
          RowBox[{"m1", " ", "s1", " ", "t12"}], "+", 
          RowBox[{"e12", " ", "m1", " ", "s1", " ", "t12"}], "+", 
          RowBox[{"m1", " ", "t22"}], "+", 
          RowBox[{"m1", " ", "s1", " ", "t22"}], "-", 
          RowBox[{"e22", " ", "m1", " ", "s1", " ", "t22"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", 
          RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", "m1", " ", 
           SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["m1", "2"], " ", 
           SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["m1", "2"], " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"t22", "+", 
                RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{"s1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "-", 
             RowBox[{"2", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], "-", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{"4", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "+", 
             RowBox[{
             "4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
             RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "-", 
             RowBox[{"6", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"6", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"6", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
             "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "+", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{"4", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
             "-", 
             RowBox[{
             "4", " ", "dd1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "4", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "+", 
             RowBox[{
             "8", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "4", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"8", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "4", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "8", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"e22", " ", "m1", " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{"2", " ", "m1", " ", 
                 SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], 
                "+", 
                RowBox[{"2", " ", "\[Alpha]1", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], 
                   "-", 
                   RowBox[{"m1", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "-", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                 SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"t12", " ", 
                 RowBox[{"(", 
                  RowBox[{"6", "-", 
                   RowBox[{"3", " ", "m1"}], "-", 
                   RowBox[{"2", " ", "m1", " ", "t22"}]}], ")"}], " ", 
                 "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", "\[Alpha]1", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                    SuperscriptBox["t12", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
                   RowBox[{"m1", " ", "t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "+", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["s1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
             RowBox[{
              SuperscriptBox["dd1", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]1"}], "+", 
             RowBox[{
             "2", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
             RowBox[{
              SuperscriptBox["dd1", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "+", 
             RowBox[{
              SuperscriptBox["dd2", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], "-", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
             RowBox[{
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1"}], "+", 
             RowBox[{
             "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]1"}], "+", 
             RowBox[{
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
             RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["dd1", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["dd1", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["dd2", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "dd1", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
             "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["dd1", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["dd1", "2"], " ", "m1", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "+", 
             RowBox[{
             "4", " ", "dd1", " ", "dd2", " ", "m1", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["dd1", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{"4", " ", "dd1", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["dd2", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{"2", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
             "-", 
             RowBox[{
             "4", " ", "dd1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "+", 
             RowBox[{
             "8", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "4", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "m1", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}],
              "-", 
             RowBox[{
             "4", " ", "dd1", " ", "m1", " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{"4", " ", "dd1", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", "dd2", " ", 
              SuperscriptBox["m1", "2"], " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "4", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["m1", "2"], " ", "t12", " ", "t22", " ", 
              "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["m1", "2"], " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["e12", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "-", 
                RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
                RowBox[{
                 SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1", 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "t12", "+", 
                   RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["e22", "2"], " ", 
              SuperscriptBox["m1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "-", 
                RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{
                 SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "t22", "+", 
                   RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"e22", " ", "m1", " ", 
              RowBox[{"(", 
               RowBox[{"4", "-", 
                RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "-", 
                RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{
                "2", " ", "dd2", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{
                "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", "m1", " ", 
                 SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                RowBox[{"dd1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", "\[Alpha]1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   RowBox[{"t12", " ", "t22"}], "-", 
                   RowBox[{"m1", " ", "t12", " ", "t22"}], "+", 
                   RowBox[{"m1", " ", 
                    SuperscriptBox["t22", "2"]}], "-", 
                   RowBox[{"t12", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
                   RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                   RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                   "-", 
                   RowBox[{
                   "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}],
                    "+", 
                   RowBox[{"2", " ", "m1", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                   RowBox[{"dd2", " ", "m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "t22"}], "+", "\[Alpha]2", "-", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], 
                   "+", 
                   RowBox[{"dd1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}], "-", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"4", "-", 
                RowBox[{"3", " ", "dd1", " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
                RowBox[{"3", " ", "dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
                RowBox[{"6", " ", "t12", " ", "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", "dd1", " ", "t12", " ", "\[Alpha]2"}], "-", 
                RowBox[{"3", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], "-", 
                RowBox[{
                "2", " ", "dd1", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
                "+", 
                RowBox[{
                "2", " ", "dd2", " ", "m1", " ", "t12", " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", "m1", " ", 
                 SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"3", " ", "m1", " ", "t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{
                "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", "\[Alpha]1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   SuperscriptBox["t12", "2"], "-", 
                   RowBox[{"m1", " ", 
                    SuperscriptBox["t12", "2"]}], "+", 
                   RowBox[{"m1", " ", "t12", " ", "t22"}], "-", 
                   RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"2", " ", "m1", " ", 
                    SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                   RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{
                   "2", " ", "m1", " ", "t12", " ", "t22", " ", "\[Alpha]2"}],
                    "+", 
                   RowBox[{"dd2", " ", "m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "t12"}], "+", "\[Alpha]2", "-", 
                    RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], 
                   "+", 
                   RowBox[{"dd1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"t12", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                  ")"}]}], "+", 
                RowBox[{"e22", " ", "m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4"}], "-", 
                   RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], 
                   "+", 
                   RowBox[{"2", " ", "\[Alpha]1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "s1", "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
          RowBox[{"e22", " ", "m1", " ", "s1"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
          RowBox[{"s1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
             RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
             RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
             RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
             RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
             RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                 "\[Alpha]1"}]}], ")"}]}], "+", 
             RowBox[{"e22", " ", "m1", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]1", "-", 
                RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t12", " ", 
           RowBox[{"(", 
            RowBox[{"\[Alpha]2", "-", 
             RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
          RowBox[{"s1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
             RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
             RowBox[{"e22", " ", 
              RowBox[{"(", 
               RowBox[{"m1", "+", 
                RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "s1", "+", 
          RowBox[{"e12", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", "s1"}], "-", 
          RowBox[{"e22", " ", "m1", " ", "s1"}]}], ")"}]}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", 
             RowBox[{"e22", " ", "m1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", 
             RowBox[{"e22", " ", "m1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"dd1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
             ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", 
             RowBox[{"e22", " ", "m1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t12", "-", 
              RowBox[{"m1", " ", "t12"}], "+", 
              RowBox[{"m1", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "-", "\[Alpha]1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]1"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]1"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]1"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]1"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]1"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                  "\[Alpha]1"}]}], ")"}]}], "+", 
              RowBox[{"e22", " ", "m1", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1", "-", 
                 RowBox[{"t22", " ", "\[Alpha]1"}]}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", 
             RowBox[{"e22", " ", "m1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", 
             RowBox[{"e22", " ", "m1"}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "+", "t12", "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "+", 
             RowBox[{"e12", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}]}], "-", 
             RowBox[{"m1", " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "t22"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "-", 
             RowBox[{"e12", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"dd1", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], "-", 
             RowBox[{"dd2", " ", "m1"}], "+", "t12", "-", 
             RowBox[{"e12", " ", "t12"}], "-", 
             RowBox[{"m1", " ", "t12"}], "+", 
             RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
             RowBox[{"m1", " ", "t22"}], "-", 
             RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"dd1", "-", 
              RowBox[{"dd1", " ", "m1"}], "+", 
              RowBox[{"dd2", " ", "m1"}], "+", 
              RowBox[{"e12", " ", "t12"}], "-", 
              RowBox[{"e12", " ", "m1", " ", "t12"}], "+", 
              RowBox[{"e22", " ", "m1", " ", "t22"}]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
           RowBox[{"t12", " ", 
            RowBox[{"(", 
             RowBox[{"\[Alpha]2", "-", 
              RowBox[{"m1", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
           RowBox[{"s1", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"dd1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"dd1", " ", "m1", " ", "\[Alpha]2"}], "-", 
              RowBox[{"dd2", " ", "m1", " ", "\[Alpha]2"}], "+", 
              RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
              RowBox[{"m1", " ", "t12", " ", "\[Alpha]2"}], "+", 
              RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}], "+", 
              RowBox[{"e12", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
              RowBox[{"e22", " ", 
               RowBox[{"(", 
                RowBox[{"m1", "+", 
                 RowBox[{"m1", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e12", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
                " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s1"}], ")"}], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                   "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{"e12", " ", "t12"}], "-", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                  RowBox[{"m1", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
                "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s1"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                    "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                   RowBox[{"m1", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "m1"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}]}], ")"}], "2"]}], ")"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "s1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
               " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e12", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s1"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd1", "+", 
                RowBox[{"e12", " ", "t12"}], "-", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                RowBox[{"m1", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], "2"], 
              " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{"e12", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"m1", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s1"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                  "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd2"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{"e12", " ", "t12"}], "-", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "+", 
                    RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
                 RowBox[{"m1", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd2", "+", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], 
          ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m1"}], ")"}]}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd1"}], "+", 
               RowBox[{"e12", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"dd1", "+", 
               RowBox[{"e12", " ", "t12"}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "dd2"}], "+", 
               RowBox[{"e22", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"m1", " ", 
             RowBox[{"(", 
              RowBox[{"dd2", "+", 
               RowBox[{"e22", " ", "t22"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "s1"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "m1"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"m1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                 ")"}]}]}], ")"}]}]}], ")"}], "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"dd2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
          RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
          RowBox[{"m2", " ", "t12"}], "-", 
          RowBox[{"e12", " ", "m2", " ", "s2", " ", "t12"}], "-", "t22", "+", 
          RowBox[{"m2", " ", "t22"}], "-", 
          RowBox[{"e22", " ", "s2", " ", "t22"}], "+", 
          RowBox[{"e22", " ", "m2", " ", "s2", " ", "t22"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "\[Alpha]1", "+", 
          RowBox[{
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["dd2", "2"], " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{
           SuperscriptBox["dd1", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "-", 
          RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{
          "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{"2", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
           "\[Alpha]1"}], "-", 
          RowBox[{"2", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t12", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]1"}], 
          "+", 
          RowBox[{
          "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", 
           "\[Alpha]1"}], "-", 
          RowBox[{
          "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
           "\[Alpha]1"}], "-", 
          RowBox[{"2", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{"2", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]1"}], 
          "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
           "\[Alpha]1"}], "+", 
          RowBox[{
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
          RowBox[{"2", " ", "m2", " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "+", 
          RowBox[{
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1"}], "-", 
          RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
          RowBox[{"3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{"3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "dd1", " ", "dd2", " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["dd2", "2"], " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["dd1", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", "dd1", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{
          "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
           "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{
          "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", 
           "\[Alpha]2"}], "-", 
          RowBox[{
          "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
           "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{"2", " ", "m2", " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
          RowBox[{
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
          RowBox[{
          "2", " ", "dd2", " ", "s2", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{
          "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{
          "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{"4", " ", "dd1", " ", "dd2", " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["dd2", "2"], " ", "m2", " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["dd1", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"4", " ", "dd1", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["dd2", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{
          "2", " ", "m2", " ", "t12", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{
          "4", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "+", 
          RowBox[{"4", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "-", 
          RowBox[{"4", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t12", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
          RowBox[{
          "2", " ", "m2", " ", "t22", " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{
          "4", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]1", " ", 
           "\[Alpha]2"}], "+", 
          RowBox[{
          "4", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "-", 
          RowBox[{
          "8", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "-", 
          RowBox[{"4", " ", "dd1", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "+", 
          RowBox[{"4", " ", "dd2", " ", 
           SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", "\[Alpha]1",
            " ", "\[Alpha]2"}], "+", 
          RowBox[{
          "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]1", " ", 
           "\[Alpha]2"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
           "\[Alpha]1", " ", "\[Alpha]2"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "-", 
          RowBox[{"4", " ", "m2", " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["t22", "2"], " ", "\[Alpha]1", " ", "\[Alpha]2"}], 
          "+", 
          RowBox[{
           SuperscriptBox["e12", "2"], " ", 
           SuperscriptBox["m2", "2"], " ", 
           SuperscriptBox["s2", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "-", 
             RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", "\[Alpha]1", 
              " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "t12", "+", 
                RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
            ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["e22", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
           SuperscriptBox["s2", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "-", 
             RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
              SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1", 
              " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "t22", "+", 
                RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
            ")"}]}], "-", 
          RowBox[{"e12", " ", "m2", " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{"4", "+", 
             RowBox[{
             "3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "t12", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t12", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "m2", " ", 
              SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
             RowBox[{"dd2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "3"}], "+", 
                RowBox[{"2", " ", "t12"}]}], ")"}], " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", "\[Alpha]1", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"m2", " ", 
                 SuperscriptBox["t12", "2"]}], "-", 
                RowBox[{"t12", " ", "t22"}], "+", 
                RowBox[{"m2", " ", "t12", " ", "t22"}], "+", 
                RowBox[{"t12", " ", "\[Alpha]2"}], "+", 
                RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                RowBox[{"2", " ", "m2", " ", 
                 SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{"2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{
                "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                "+", 
                RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "t12"}], "+", "\[Alpha]2", "-", 
                   RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], 
                "+", 
                RowBox[{"dd2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{"t12", "-", "\[Alpha]2", "+", 
                   RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}]}], 
               ")"}]}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "-", 
             RowBox[{"3", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
             RowBox[{
             "3", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "3", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
             RowBox[{"3", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
             RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"3", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t22", " ", 
              "\[Alpha]2"}], "-", 
             RowBox[{
             "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
              "\[Alpha]2"}], "+", 
             RowBox[{
             "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "m2", " ", 
              SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
             RowBox[{"2", " ", "\[Alpha]1", " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"m2", " ", "t12", " ", "t22"}], "-", 
                SuperscriptBox["t22", "2"], "+", 
                RowBox[{"m2", " ", 
                 SuperscriptBox["t22", "2"]}], "+", 
                RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                RowBox[{
                "2", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                "-", 
                RowBox[{"2", " ", 
                 SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"2", " ", "m2", " ", 
                 SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "t22"}], "+", "\[Alpha]2", "-", 
                   RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], 
                "+", 
                RowBox[{"dd2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                 RowBox[{"(", 
                  RowBox[{"t22", "-", "\[Alpha]2", "+", 
                   RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
               ")"}]}], "+", 
             RowBox[{"e12", " ", "m2", " ", "s2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "4"}], "-", 
                RowBox[{"3", " ", "t22", " ", "\[Alpha]2"}], "+", 
                RowBox[{"t12", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", 
                   RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}], 
                "+", 
                RowBox[{"2", " ", "\[Alpha]1", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "-", 
                   RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                   RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"e12", " ", "m2", " ", "s2"}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{"s2", "-", 
             RowBox[{"m2", " ", "s2"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]1", "-", 
          RowBox[{"dd2", " ", "s2", " ", "\[Alpha]1"}], "-", 
          RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "+", 
          RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
          RowBox[{"m2", " ", "t12", " ", "\[Alpha]1"}], "-", 
          RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
          RowBox[{"e12", " ", "m2", " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]1", "-", 
             RowBox[{"t12", " ", "\[Alpha]1"}]}], ")"}]}], "+", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", "\[Alpha]1"}]}],
             ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
          RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
          RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
          RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
          RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
          RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
          RowBox[{"e12", " ", "m2", " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
          RowBox[{"e22", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], ")"}]}],
      ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "s2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["e12", "3"], " ", 
             SuperscriptBox["m2", "3"], " ", 
             SuperscriptBox["s2", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t12"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["e22", "3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], "3"], " ", 
             SuperscriptBox["s2", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"dd2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "m2"}], ")"}]}], "-", 
               RowBox[{"dd1", " ", "m2"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
                  RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
                  RowBox[{"m2", " ", "t12"}], "-", "t22", "+", 
                  RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]1"}], 
               "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
                  RowBox[{"dd1", " ", "m2", " ", "s2"}], "-", 
                  RowBox[{"m2", " ", "t12"}], "-", "t22", "+", 
                  RowBox[{"m2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
              ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["e12", "2"], " ", 
             SuperscriptBox["m2", "2"], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"m2", " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{"4", "-", 
                  RowBox[{"3", " ", "t12"}], "-", 
                  RowBox[{"m2", " ", "t12"}], "+", 
                  SuperscriptBox["t12", "2"], "-", 
                  RowBox[{"m2", " ", 
                   SuperscriptBox["t12", "2"]}], "-", "t22", "+", 
                  RowBox[{"m2", " ", "t22"}], "-", 
                  RowBox[{"t12", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", "t12", " ", "t22"}], "+", 
                  RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"4", " ", "m2", " ", 
                   SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"4", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                  "+", 
                  RowBox[{
                  "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                  "-", 
                  RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}]}], ")"}]}], 
                  "+", 
                  RowBox[{"2", " ", "dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t12"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["e22", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "-", 
               RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
               RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"m2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", 
                  RowBox[{"m2", " ", "t12"}], "+", 
                  RowBox[{"4", " ", "t22"}], "-", 
                  RowBox[{"m2", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", "t12", " ", "t22"}], "-", 
                  RowBox[{"m2", " ", 
                   SuperscriptBox["t22", "2"]}], "-", 
                  RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                  "4", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                  "+", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                  RowBox[{"4", " ", "m2", " ", 
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", "dd1", " ", "m2", " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "\[Alpha]2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}]}], ")"}]}], 
                  "-", 
                  RowBox[{"2", " ", "dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}], "+", 
               RowBox[{"2", " ", "e12", " ", "m2", " ", "s2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "-", 
                  RowBox[{"t12", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"\[Alpha]1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "t12", "-", 
                    RowBox[{"2", " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "\[Alpha]2"}], ")"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "t22"}]}], ")"}], " ", "\[Alpha]2"}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"e12", " ", "m2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "dd2", " ", "s2", " ", "t12", " ", "\[Alpha]2"}], 
               "-", 
               RowBox[{
               "2", " ", "dd1", " ", "m2", " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{
               "3", " ", "dd2", " ", "m2", " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"dd1", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"dd2", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"m2", " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["m2", "2"], " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
               "-", 
               RowBox[{
               "2", " ", "dd2", " ", "m2", " ", "s2", " ", "t22", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"dd1", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"dd2", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "3", " ", "m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
               "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["m2", "2"], " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["dd2", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                   SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["dd1", "2"], " ", 
                   SuperscriptBox["m2", "2"], " ", 
                   SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"t12", "-", "t22"}], ")"}]}], "+", "t22"}], ")"}],
                    " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2", "+", 
                    RowBox[{"2", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "+", 
                  RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "m2", "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}], "-", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{
                    "4", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}],
                     "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "t22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "m2", "+", 
                    RowBox[{"4", " ", "m2", " ", "\[Alpha]2"}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", 
               RowBox[{"2", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "2", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "2", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
               RowBox[{
               "dd2", " ", "m2", " ", "s2", " ", "t12", " ", "\[Alpha]2"}], 
               "+", 
               RowBox[{"dd1", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"dd2", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t12", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["m2", "2"], " ", 
                SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"dd2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{
               "dd1", " ", "m2", " ", "s2", " ", "t22", " ", "\[Alpha]2"}], 
               "-", 
               RowBox[{"dd1", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"dd2", " ", 
                SuperscriptBox["m2", "2"], " ", "s2", " ", "t22", " ", 
                "\[Alpha]2"}], "+", 
               RowBox[{"m2", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["m2", "2"], " ", "t12", " ", "t22", " ", 
                "\[Alpha]2"}], "-", 
               RowBox[{"m2", " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{
                SuperscriptBox["m2", "2"], " ", 
                SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["e12", "2"], " ", 
                SuperscriptBox["m2", "2"], " ", 
                SuperscriptBox["s2", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "-", 
                  RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"\[Alpha]1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "t22", "+", 
                    RowBox[{
                    SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{"t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"2", " ", "t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"e12", " ", "m2", " ", "s2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "8"}], "-", 
                  RowBox[{"4", " ", "dd2", " ", "s2", " ", "\[Alpha]2"}], "-", 
                  RowBox[{
                  "4", " ", "dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
                  "+", 
                  RowBox[{
                  "4", " ", "dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], 
                  "-", 
                  RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"4", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"m2", " ", 
                   SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                  RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{"4", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], "-", 
                  RowBox[{"t12", " ", "t22", " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                  RowBox[{"m2", " ", 
                   SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"\[Alpha]1", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "+", 
                    RowBox[{"3", " ", "t12"}], "+", 
                    RowBox[{"2", " ", "m2", " ", "t12"}], "+", 
                    RowBox[{"m2", " ", 
                    SuperscriptBox["t12", "2"]}], "+", 
                    RowBox[{"5", " ", "t22"}], "-", 
                    RowBox[{"2", " ", "m2", " ", "t22"}], "-", 
                    RowBox[{"t12", " ", "t22"}], "+", 
                    SuperscriptBox["t22", "2"], "-", 
                    RowBox[{"m2", " ", 
                    SuperscriptBox["t22", "2"]}], "-", 
                    RowBox[{"2", " ", "t12", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"4", " ", "m2", " ", "t12", " ", "\[Alpha]2"}], 
                    "+", 
                    RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t12", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{"6", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"4", " ", "m2", " ", "t22", " ", "\[Alpha]2"}], 
                    "+", 
                    RowBox[{"4", " ", "t12", " ", "t22", " ", "\[Alpha]2"}], 
                    "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{"4", " ", "m2", " ", 
                    SuperscriptBox["t22", "2"], " ", "\[Alpha]2"}], "-", 
                    RowBox[{"4", " ", "dd2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t12", "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"4", " ", "dd1", " ", "m2", " ", "s2", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t12", "+", "t22"}], ")"}], " ", 
                    "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
               RowBox[{"\[Alpha]1", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", 
                   SuperscriptBox["dd2", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], "2"], " ", 
                   SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{"2", " ", 
                   SuperscriptBox["dd1", "2"], " ", 
                   SuperscriptBox["m2", "2"], " ", 
                   SuperscriptBox["s2", "2"], " ", "\[Alpha]2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"t12", "-", "t22"}], ")"}]}], "+", "t22"}], ")"}],
                    " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", 
                    RowBox[{"2", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"t12", "-", "t22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{"dd1", " ", "m2", " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{"3", "-", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"t22", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"t12", "-", "t22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
                  "+", 
                  RowBox[{"dd2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "t22", "+", 
                    RowBox[{"2", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "+", 
                    RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"t22", "-", 
                    RowBox[{"4", " ", "dd1", " ", "s2", " ", "\[Alpha]2"}], 
                    "+", 
                    RowBox[{"4", " ", "t22", " ", "\[Alpha]2"}], "-", 
                    RowBox[{"t12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"4", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2"}], "-", 
            RowBox[{"e12", " ", "m2", " ", "s2"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]1", "-", 
            RowBox[{"dd2", " ", "s2", " ", "\[Alpha]1"}], "-", 
            RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "+", 
            RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]1"}], "-", 
            RowBox[{"m2", " ", "t12", " ", "\[Alpha]1"}], "-", 
            RowBox[{"t22", " ", "\[Alpha]1"}], "+", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]1"}], "+", 
            RowBox[{"e12", " ", "m2", " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "\[Alpha]1", "-", 
               RowBox[{"t12", " ", "\[Alpha]1"}]}], ")"}]}], "+", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "t22"}], ")"}], " ", 
                "\[Alpha]1"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"dd2", " ", "s2", " ", "\[Alpha]2"}], "+", 
            RowBox[{"dd1", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "-", 
            RowBox[{"dd2", " ", "m2", " ", "s2", " ", "\[Alpha]2"}], "+", 
            RowBox[{"m2", " ", "t12", " ", "\[Alpha]2"}], "+", 
            RowBox[{"t22", " ", "\[Alpha]2"}], "-", 
            RowBox[{"m2", " ", "t22", " ", "\[Alpha]2"}], "+", 
            RowBox[{"e12", " ", "m2", " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t12", " ", "\[Alpha]2"}]}], ")"}]}], "-", 
            RowBox[{"e22", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", "s2", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"t22", " ", "\[Alpha]2"}]}], ")"}]}]}], ")"}]}], 
         ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "s2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], 
            ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}],
                 "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"e22", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "s2"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "dd2"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"dd2", "+", 
                  RowBox[{"e22", " ", "t22"}], "+", 
                  RowBox[{"m2", " ", 
                   RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd2"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                    ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", "s2"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"dd2", "+", 
                   RowBox[{"e22", " ", "t22"}], "+", 
                   RowBox[{"m2", " ", 
                    RowBox[{"(", 
                    RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], 
            ")"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}], "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}]}], 
             ")"}], "2"]}], ")"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "s2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd1"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}]}], ")"}]}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], ")"}]}], 
              "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]1"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                  ")"}]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "s2"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"dd2", "+", 
                RowBox[{"e22", " ", "t22"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{"dd1", "-", "dd2", "+", 
                   RowBox[{"e12", " ", "t12"}], "-", 
                   RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}]}], ")"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"m2", " ", 
               RowBox[{"(", 
                RowBox[{"dd1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e12"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t12"}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "m2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                    RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"e22", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "dd2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e12"}], ")"}], " ", "t12"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}]}], 
                   ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "+", "s2"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"dd2", "+", 
                 RowBox[{"e22", " ", "t22"}], "+", 
                 RowBox[{"m2", " ", 
                  RowBox[{"(", 
                   RowBox[{"dd1", "-", "dd2", "+", 
                    RowBox[{"e12", " ", "t12"}], "-", 
                    RowBox[{"e22", " ", "t22"}]}], ")"}]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "\[Alpha]2"}], ")"}]}]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{"m2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "dd1"}], "+", "dd2", "+", 
                   RowBox[{"e12", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t12"}], ")"}]}], "-", 
                   RowBox[{"e22", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"e22", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "t22"}], ")"}]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "dd2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "e22"}], ")"}], " ", "t22"}], "+", 
                RowBox[