##RScriptPSPM_EvolutionDirectDevelopment_StageStructured####
###LIBS####
library(PSPManalysis)
library(ggplot2)
###multiplot function#####
# Multiple plot function
#
# ggplot objects can be passed in ..., or to plotlist (as a list of ggplot objects)
# - cols:   Number of columns in layout
# - layout: A matrix specifying the layout. If present, 'cols' is ignored.
#
# If the layout is something like matrix(c(1,2,3,3), nrow=2, byrow=TRUE),
# then plot 1 will go in the upper left, 2 will go in the upper right, and
# 3 will go all the way across the bottom.
#
multiplot <- function(..., plotlist=NULL, file, cols=1, layout=NULL) {
  library(grid)
  
  # Make a list from the ... arguments and plotlist
  plots <- c(list(...), plotlist)
  
  numPlots = length(plots)
  
  # If layout is NULL, then use 'cols' to determine layout
  if (is.null(layout)) {
    # Make the panel
    # ncol: Number of columns of plots
    # nrow: Number of rows needed, calculated from # of cols
    layout <- matrix(seq(1, cols * ceiling(numPlots/cols)),
                     ncol = cols, nrow = ceiling(numPlots/cols))
  }
  
  if (numPlots==1) {
    print(plots[[1]])
    
  } else {
    # Set up the page
    grid.newpage()
    pushViewport(viewport(layout = grid.layout(nrow(layout), ncol(layout))))
    
    # Make each plot, in the correct location
    for (i in 1:numPlots) {
      # Get the i,j matrix positions of the regions that contain this subplot
      matchidx <- as.data.frame(which(layout == i, arr.ind = TRUE))
      
      print(plots[[i]], vp = viewport(layout.pos.row = matchidx$row,
                                      layout.pos.col = matchidx$col))
    }
  }
}
#####Name function#####
'%ni%' <- Negate('%in%')
SelGradNames=c("R0_x[psi]", "R0_x[meta]")
SelGradNames2=c("R0_x[psi]", "R0_x[meta]", "R0_x[SB]")
SelGradNames3 = c("R0_x[psi]",  "R0_x[meta]", "R0_x[SJ]" ) 
SelGradNamesAll = c("R0_x[psi]",  "R0_x[meta]", "R0_x[SJ]",  "R0_x[SB]" ) 
evo.names=c("SJ_alt", "SB")
ESSmult.names=c( "eig J",  "eig H", "eig (J+J')/2", "Z^T C01 Z")
ESSsingle.names=c("R0_xx", "R0_yy")
output = c("In1_L", "In2_L", 
           "Lm", "Lm2","Jm","Am",
           "L","L2","J","A")
NameData=function(BifList,evonames=evo.names,datalist=NULL,bifpar="bifpar",extranames=SelGradNames){
  Data<-as.data.frame(BifList$curvepoints)
  if(length(evonames)==1){
    ESSnames<-ESSsingle.names
    ESSCalc = 1
  } else {
    ESSnames<-ESSmult.names
    ESSCalc = 2
  }
  colnames(Data) <- c(bifpar,Env.names,evonames,output,"R0",extranames,ESSnames,"Rhsnorm")
  if ("SJ_alt" %in% evonames){
    Data$SJ <- Data$SJ_alt + xmin
  }
  if ("Meta" %ni% evonames){
    Data$Meta <- 1
  }
  if ("Psi" %ni% evonames) {
    Data$Psi <- 0
  }
  ###
  if ("R0_x[meta]" %in% extranames) {
    Data$Meta_Evo = 0
    Data$Meta_Evo[Data$`R0_x[meta]` < 0] = 1
  }
  if ("R0_x[psi]" %in% extranames) {
    Data$Psi_Evo = 0
    Data$Psi_Evo[Data$`R0_x[psi]` > 0] = 1
  }
  ##ESS calculation##
  if(ESSCalc == 2){
    Data$ESS =  ifelse(Data$`eig J` == Inf, "ESS", ifelse(Data$`eig J`>0, "ERP", ifelse(Data$`eig H`<0&Data$`eig (J+J')/2`<0, 'Strong CSS', ifelse(Data$`eig H`<0, 'Weak CSS', ifelse(Data$`Z^T C01 Z`<=0, 'EBP', "?")))))
    } else {
    Data$R0_xx_yy = Data$R0_xx -  Data$R0_yy
    Data$ESS = ifelse(is.na(Data$R0_xx_yy), 'ESS', ifelse(Data$R0_xx == Inf, 'ESS' ,ifelse(Data$R0_xx_yy<0, "ERP", ifelse(Data$R0_yy<0, "CSS", "EBP"))))}
  AllData<-list()
  AllData$info<-BifList$curvedesc
  if ("bifpoints" %in% names(BifList)) {
    BifPoints<-as.data.frame(BifList$bifpoints)
    colnames(BifPoints) = c(bifpar,Env.names,evonames,output,"R0",extranames,ESSnames,"Rhsnorm")
    if ("SJ_alt" %in% evonames){
      BifPoints$SJ = BifPoints$SJ_alt+xmin}
    if ("Meta" %ni% evonames){
      BifPoints$Meta = 1
    }
    if ("Psi" %ni% evonames) {
      BifPoints$Psi = 0
    }
    if(ESSCalc == 2){
      BifPoints$ESS = ifelse(BifPoints$`eig J`>0, "ERP", ifelse(BifPoints$`eig H`<0&BifPoints$`eig (J+J')/2` < 0, 'Strong CSS', ifelse(BifPoints$`eig H`<0, 'Weak CSS', ifelse(BifPoints$`Z^T C01 Z`<=0, 'EBP', "?"))))
      BifPoints$ESS_alt = ifelse(BifPoints$`eig (J+J')/2`>0, "ERP", ifelse(BifPoints$`eig H`<0&BifPoints$`eig (J+J')/2` < 0, 'Strong CSS', ifelse(BifPoints$`eig H`<0, 'Weak CSS', ifelse(BifPoints$`Z^T C01 Z`<=0, 'EBP', "?"))))
    } else {
      BifPoints$R0_xx_yy = BifPoints$R0_xx -  BifPoints$R0_yy
      BifPoints$ESS = ifelse(is.na(BifPoints$R0_xx_yy), 'ESS', ifelse(BifPoints$R0_xx_yy<0, "ERP", ifelse(BifPoints$R0_yy<0, "CSS", "EBP")))
    }
    AllData$Bifpoints<-BifPoints
    AllData$BifTypes<-BifList$biftypes
  }
  AllData$data<-Data
  assign(datalist,AllData, envir = .GlobalEnv)
}

#
#####Plot Layout#####
layout=theme_bw()+theme(legend.title=element_blank(),legend.position="none")+
  theme(panel.grid.minor=element_blank(), panel.grid.major=element_blank(),
        text=element_text(size=10,colour="black"),
        axis.text =element_text(size=10,colour='black'),
        axis.title=element_text(size=10,colour='black'),
        legend.text = element_text(size=10,colour='black'),
        plot.title = element_text(hjust = 0.5, size=10,colour='black'))+
  theme(axis.title.y = element_text(margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.x = element_text(margin = margin(t = 10, r = 0, b = 0, l = 0)))
#
#####Parameters#####
model = "Stagestructured"
delta = 0.1
Xmax1=1
Xmax2=1
Qs=0.4  ###The higher, the more expensive 
Rho=0.5 #Prob to survive metamorphosis
Sm=0.1 #Size at maturation
Sb= Sm*0.01
Sj=5E-6
Sj_min=5E-6
Sjmin = Sj_min
Xbmin=5E-6
Sbmin =Xbmin
Xbmax=Sm
xmin=0.01  #Size at which R2 becomes available
MaxSj=Sm-xmin #Max size where metamorphosis can take place
Sjmax = Sm - xmin
Psi=0
Psi_min = 0
Meta=1
Mu=0.02
Sig=100
Q=1
Amax=0.6
Amin=0.06
Tr = 0.1 #mass specific maintenance rate
H = 1 #Handing
epsilon = 0.5 #Conversion efficiency
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
####Names of parameters and output####
pars.names=c("Delta","Xmax1","Xmax2","Sigma","Q","T","Amax","Amin","H","Sig","Sb","Sj","Sm","Mur","Xmin",
             "Psi","Meta","Qs","Rho" )
pars.names2Spec=c("Delta","Xmax1","Xmax2","Sigma","Q","T","Amax","Amin","H","Sig","Sm","Mur","Xmin",
                  "Qs","Rho" , "Sb_S1", "Sj_S1", "Psi_S1", "Meta_S1",
                  "Sb_S2", "Sj_S2", "Psi_S2", "Meta_S2")
output = c("In1_L", "In2_L", 
           "Lm", "Lm2","Jm","Am",
           "L","L2","J","A")
output2Spec = c("SP1_In1_L", "SP1_In2_L", "SP1_Lm", "SP1_Lm2","SP1_Jm","SP1_Am","SP1_L","SP1_L2","SP1_J","SP1_A", "SP1_In1_Large", "SP1_In2_Large",
                "SP2_In1_L", "SP2_In2_L", "SP2_Lm", "SP2_Lm2","SP2_Jm","SP2_Am","SP2_L","SP2_L2","SP2_J","SP2_A", "SP2_In1_Large", "SP2_In2_Large")
Env.names=c("X1","X2","birthrate")
Env.names2Spec=c("X1","X2","SP1_birthrate","SP2_birthrate")
meta_index=which(pars.names == 'Meta')-1
Sj_index=which(pars.names == 'Sj')-1
psi_index <- which(pars.names == 'Psi')-1
Psi_index <- which(pars.names == 'Psi')-1
Sb_index <- which(pars.names== 'Sb')-1

Meta_S1_index=which(pars.names2Spec == 'Meta_S1')-1
Sj_S1_index=which(pars.names2Spec == 'Sj_S1')-1
Psi_S1_index <- which(pars.names2Spec == 'Psi_S1')-1
Sb_S1_index <- which(pars.names2Spec== 'Sb_S1')-1

Meta_S2_index=which(pars.names2Spec == 'Meta_S2')-1
Sj_S2_index=which(pars.names2Spec == 'Sj_S2')-1
Psi_S2_index <- which(pars.names2Spec == 'Psi_S2')-1
Sb_S2_index <- which(pars.names2Spec== 'Sb_S2')-1




#####Bifurcation over Xmax1, with low Xmax2 (EXTINCTION)#####
Xmax1 = 0.680498
Xmax2 = 5.51602787E-01
Env = c(5.39935501E-01, 5.39931151E-01, 1.47443200E+01)
Sj = 8.99173901E-02
Sb = Sbmin
Meta = 1
Psi = 0
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
pnt = c( 5.39935670E-01, 5.39930125E-01, 1.47445248E+01, 0.00000000E+00, 1.00000000E+00, 8.99188965E-02, 5.00000000E-06)
###Find ESS###
EvoDyn=PSPMevodyn(modelname="Stagestructured", 
                  startpoint=pnt, 
                  curvepars=c(0.0001,0.2),
                  evopars=c(0,psi_index,Psi_min,1,
                            0, meta_index, 0, 1,
                            0, Sj_index,Sjmin,Sjmax,
                            0,Sb_index,Xbmin,Sm),
                  covars = c(1,0,0,0,
                             0,1,0,0,
                             0,0,1,0,
                             0,0,0,1),
                  parameters = Pars,
                  options=NULL,
                  clean=TRUE)
#Continue the ESS#
Env = c(5.39935501E-01, 5.39931153E-01, 1.47443526E+01)
Sj = 8.99303071E-02
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Bif_Xmax1_Forwards_Xmax2_0p55_Part1<-PSPMequi(modelname="Stagestructured",
                                              biftype='ESS',
                                              startpoint=c(Xmax1,Env,Sj),
                                              stepsize=.1,
                                              parbnds=c(1,0,10,
                                                        0,Sj_index,Sjmin,Sjmax),
                                              parameters=Pars,
                                              options=c( "popEVO", "0",'parEVO','15', 
                                                         "popEVO", "0",'parEVO','16',
                                                         "popEVO", "0",'parEVO','10'),
                                              clean=TRUE)

Bif_Xmax1_Backwards_Xmax2_0p55_Part1<-PSPMequi(modelname="Stagestructured",
                                               biftype='ESS',
                                               startpoint=c(Xmax1,Env,Sj),
                                               stepsize=-.1,
                                               parbnds=c(1,0,10,
                                                         0,Sj_index,Sjmin,Sjmax),
                                               #0,Sb_index,Xbmin,Xbmax),
                                               parameters=Pars,
                                               options=c( "popEVO", "0",'parEVO','15', 
                                                          "popEVO", "0",'parEVO','16',
                                                          "popEVO", "0",'parEVO','10'),
                                               clean=TRUE)
SelGradNames4 = c("R0_x[psi]",  "R0_x[meta]", "R0_x[SB]")
#Give names to data 
NameData(BifList = Bif_Xmax1_Backwards_Xmax2_0p55_Part1, evonames=c("SJ_alt"), bifpar="Xmax1",extranames=SelGradNames4,datalist="BifXmax1_Backwards_Xmax2_0p55_Part1")
NameData(BifList = Bif_Xmax1_Forwards_Xmax2_0p55_Part1, evonames=c("SJ_alt"), bifpar="Xmax1",extranames=SelGradNames4,datalist="BifXmax1_Forwards_Xmax2_0p55_Part1")
BifXmax1_Backwards_Xmax2_0p55_Part1$data$Sb = Sbmin
BifXmax1_Forwards_Xmax2_0p55_Part1$data$Sb = Sbmin
###Sj at minimum###
Xmax1 =  5.82727389E-01
Sj = Sjmin
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Env = c(5.39946310E-01, 5.39902840E-01, 6.71632581E+00)
Bif_Xmax1_Backwards_Xmax2_0p55_Part2<-PSPMequi(modelname="Stagestructured",
                                               biftype='EQ',
                                               startpoint=c(Xmax1,Env),
                                               stepsize=-.1,
                                               parbnds=c(1,0,10),
                                               #0,Sj_index,Sjmin,Sjmax),
                                               #0,Sb_index,Xbmin,Xbmax),
                                               parameters=Pars,
                                               options=c( "popEVO", "0",'parEVO','15', 
                                                          "popEVO", "0",'parEVO','16',
                                                          "popEVO", "0",'parEVO','11',
                                                          "popEVO", "0",'parEVO','10'),
                                               clean=TRUE)

SelGradNamesAll = c("R0_x[psi]",  "R0_x[meta]", "R0_x[SB]","R0_x[SJ]")
BifXmax1_Backwards_Xmax2_0p55_Part2 = as.data.frame(Bif_Xmax1_Backwards_Xmax2_0p55_Part2$curvepoints)
colnames(BifXmax1_Backwards_Xmax2_0p55_Part2) = c("Xmax1", Env.names, output,"R0",SelGradNamesAll, "Rhsnorm" )
BifXmax1_Backwards_Xmax2_0p55_Part2$SJ_alt = Sjmin 
BifXmax1_Backwards_Xmax2_0p55_Part2$SJ = BifXmax1_Backwards_Xmax2_0p55_Part2$SJ_alt + xmin
BifXmax1_Backwards_Xmax2_0p55_Part2$Sb = Sbmin
BifXmax1_Backwards_Xmax2_0p55_Part2$ESS = "CSS"

##Plot
BP_point = subset(BifXmax1_Backwards_Xmax2_0p55_Part2, birthrate==0)
ExtinctionPlot = ggplot(data=BifXmax1_Backwards_Xmax2_0p55_Part1$data, aes(x=Xmax1*0.1, y=SJ))+
  layout+
  geom_path(size = 2, aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb, colour = "at birth"), size = 2)+
  geom_path(data=subset(BifXmax1_Backwards_Xmax2_0p55_Part2, birthrate>=0), size = 2,  aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb , colour = "at birth"),data=subset(BifXmax1_Backwards_Xmax2_0p55_Part2, birthrate>=0), size = 2)+
  geom_path(data=subset(BifXmax1_Forwards_Xmax2_0p55_Part1$data, birthrate>=0), size = 2,  aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb, colour = "at birth"),data=subset(BifXmax1_Forwards_Xmax2_0p55_Part1$data, birthrate>=0), size = 2)+
  geom_hline(aes(yintercept = xmin), linetype = 'dashed')+
  coord_cartesian(xlim = c(0.05, 0.066), ylim=c(-0.001,0.101),expand = c(0,0))+
  scale_y_continuous(breaks=c(0,0.01,0.025,0.05,0.075, 0.1),
                     labels=c(0, expression(italic(s)[min]), 0.025,0.05,0.075, 0.1))+
  geom_vline(aes(xintercept = 0.1*as.numeric(BP_point[1])), linetype = 'dotted')+
  scale_colour_manual(values=c(X0col,Xjcol))+
  theme(legend.position=c(0.55,0.85),
        legend.background = element_blank(),
        legend.box.background = element_blank(),
        legend.key = element_blank())+
  annotate(geom="text", x=0.0515, y=0.042,label = "Extinction",
           size=3,colour='black',
           family="Arial",
           angle=90)+
  ylab("Body mass (mg)")+
  xlab(expression(atop("Supply of primary food source,", paste(delta*X["1,max"], " (mg ", L^-1, day^-1,")"))))
ExtinctionPlot


###THE EBP leads to branching-extinction cycles around very small values of the traits####

#Calculation
Xmax1 = 0.6004052		
Xmax2 =  5.51602787E-01
Env=c(0.5399453,	0.5399048,	6.818856)	
Env_2Spec=c(Env[1],Env[2],Env[3]/2,Env[3]/2)
Sj = 0.0126235400
Sb = Sbmin
Meta = 1
Psi = 0

####
Sb_S1 =  Sb	 
Sj_S1 = Sj - 0.000001
Psi_S1 = Psi 
Meta_S1 = 1
Sb_S2 = 	Sb	 
Sj_S2 = Sj + 0.000001
Psi_S2 =  Psi 
Meta_S2 = Meta_S1 
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Pars2Spec=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sm,Mu,xmin,
            Qs,Rho,  Sb_S1,Sj_S1,Psi_S1,Meta_S1,Sb_S2,Sj_S2,Psi_S2,Meta_S2)

EvoDyn=PSPMevodyn(modelname="Stagestructured_twospecies",
                  startpoint=c(Env_2Spec, Psi_S1,Psi_S2,Meta_S1,Meta_S2,Sj_S1, Sj_S2, Sb_S1,Sb_S2),
                  curvepars=c(0.00001,100),#0.000134),
                  evopars=c(0,Psi_S1_index,Psi_min,1,
                            1,Psi_S2_index,Psi_min,1,
                            0, Meta_S1_index, 0, 1,
                            1, Meta_S2_index, 0, 1,
                            0, Sj_S1_index,Sjmin,Sjmax,
                            1, Sj_S2_index,Sjmin,Sjmax,
                            0,Sb_S1_index,Xbmin,Sm,
                            1,Sb_S2_index,Xbmin,Sm),
                  covars = NULL,
                  parameters = Pars2Spec,
                  options=c("report", "100"),
                  clean=TRUE)

EvoNames = c("Psi_S1", "Psi_S2", "Meta_S1", "Meta_S2","Sj_S1", 'Sj_S2',"Sb_S1",   "Sb_S2")
Canonical2Species = as.data.frame(EvoDyn$curvepoint)
colnames(Canonical2Species) =c("Evol.time", Env.names2Spec, EvoNames,output2Spec, "R0_S1", "R0_S2", "RhsNorm")
ggplot(data=Canonical2Species, aes(x=Evol.time,y=Sj_S1))+geom_path(aes(colour="S1"))+
  geom_path(aes(colour="S2", y=Sj_S2))
ggplot(data=Canonical2Species, aes(x=Evol.time,y=SP1_birthrate))+geom_path(aes(colour="S1"))+
  geom_path(aes(colour="S2", y=SP2_birthrate))
#Pop S2 goes extinct 

Env = c(5.39938792E-01, 5.39919558E-01, 8.20111519E+00)
Sj = 1.26236692E-02
Psi = 0
Meta = 1
Sb = Sbmin
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
EvoDyn=PSPMevodyn(modelname="Stagestructured", 
                  startpoint=c(Env, Psi,Meta,Sj, Sb), 
                  curvepars=c(0.00001,0.0000001),
                  evopars=c(0,psi_index,Psi_min,1,
                            0, meta_index, 0, 1,
                            0, Sj_index,Sjmin,Sjmax,
                            0,Sb_index,Xbmin,Sm),
                  covars = NULL,
                  parameters = Pars,
                  options=NULL,
                  clean=TRUE)
#And pop 1 goes back to ESS 

###Bifurcation over Xmax1, with high Xmax2 (Direct development)#####
Env = c(5.68508789E-01, 5.56468724E-01, 1.30615766E-01 )
Psi =  8.61295897E-07
Sb = 7.45902608E-03
Xmax1 = 0.5963540	
Xmax2 = 0.8
Meta = 1
Sj = Sjmin
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Bif_Xmax1_Backwards_Xmax2_0.8_part1<-PSPMequi(modelname=model,
                                              biftype='ESS',
                                              startpoint=c(Xmax1,Env,Psi,Sb),
                                              stepsize=-.1,
                                              parbnds=c(1,0,10,
                                                        0, Psi_index,0,1,
                                                        #0,Sj_index,Sjmin,Sjmax),
                                                        0,Sb_index,Xbmin,Xbmax),
                                              parameters=Pars,
                                              options=c(
                                                #"popEVO", "0",'parEVO','15', 
                                                "popEVO", "0",'parEVO','16',
                                                "popEVO", "0",'parEVO','11'),
                                              clean=TRUE)
Bif_Xmax1_Forwards_Xmax2_0.8_part1<-PSPMequi(modelname=model,
                                             biftype='ESS',
                                             startpoint=c(Xmax1,Env,Psi,Sb),
                                             stepsize=.1,
                                             parbnds=c(1,0,10,
                                                       0, Psi_index,0,1,
                                                       #0,Sj_index,Sjmin,Sjmax),
                                                       0,Sb_index,Xbmin,Xbmax),
                                             parameters=Pars,
                                             options=c(
                                               #"popEVO", "0",'parEVO','15', 
                                               "popEVO", "0",'parEVO','16',
                                               "popEVO", "0",'parEVO','11'),
                                             clean=TRUE)

Xmax1 = 7.11244520E-01
Env =c(5.39348142E-01, 5.63261262E-01, 4.29270337E-01)
Sb = 2.29591743E-03
Psi = 0
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Bif_Xmax1_Forwards_Xmax2_0.8_part2<-PSPMequi(modelname=model,
                                             biftype='ESS',
                                             startpoint=c(Xmax1,Env,Sb),
                                             stepsize=.1,
                                             parbnds=c(1,0,10,
                                                       #0, Psi_index,0,1,
                                                       #0,Sj_index,Sjmin,Sjmax),
                                                       0,Sb_index,Xbmin,Xbmax),
                                             parameters=Pars,
                                             options=c(
                                               "popEVO", "0",'parEVO','15', 
                                               "popEVO", "0",'parEVO','16',
                                               "popEVO", "0",'parEVO','11'),
                                             clean=TRUE)

NameData(BifList = Bif_Xmax1_Backwards_Xmax2_0.8_part1, evonames=c("Psi","Sb"), bifpar="Xmax1",
         extranames=c("R0_x[meta]", "R0_[SJ]"),
         datalist="BifXmax1_Backwards_Xmax2_0.8_part1")
NameData(BifList = Bif_Xmax1_Forwards_Xmax2_0.8_part1, evonames=c("Psi","Sb"), bifpar="Xmax1",
         extranames=c("R0_x[meta]", "R0_[SJ]"),
         datalist="BifXmax1_Forwards_Xmax2_0.8_part1")
NameData(BifList = Bif_Xmax1_Forwards_Xmax2_0.8_part2, evonames=c("Sb"), bifpar="Xmax1",
         extranames=c("R0_x[psi]","R0_x[meta]", "R0_[SJ]"),
         datalist="BifXmax1_Forwards_Xmax2_0.8_part2")
BifXmax1_Backwards_Xmax2_0.8_part1$data$Sj = Sjmin + xmin
BifXmax1_Forwards_Xmax2_0.8_part1$data$Sj = Sjmin + xmin
BifXmax1_Forwards_Xmax2_0.8_part2$data$Sj = Sjmin + xmin

###What happens with Xb after DD has evolved?
Xmax2 = 0.8
Xmax1 = 0
Psi = 1
Meta = 0
Sj = Sjmin
Sb = 0.010006
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
bpxm1 = 1
BPfind<-PSPMequi(modelname=model, 
                 biftype="EQ", 
                 startpoint=c(bpxm1,Xmax1,Xmax2), 
                 stepsize=-.1,
                 parbnds=c(2,0.3,5),
                 parameters=Pars,
                 options=c("popZE", "0"),
                 clean=TRUE,
                 force=FALSE)
bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
Nontriv <- PSPMequi(modelname=model,
                    biftype='EQ',
                    startpoint=c(bound.point, 0),
                    stepsize=1, 
                    parbnds=c(2, 0.0, Xmax2), 
                    parameters=Pars,
                    #options=c("popEVO", "0"),
                    clean=TRUE)
dataGoed = as.data.frame(Nontriv$curvepoints)
InitPoint = as.numeric(dataGoed[nrow(dataGoed), c(2:4)])
EvoDyn=PSPMevodyn(modelname="Stagestructured", 
                  startpoint=c(Env, Psi,Meta,Sj, Sb), 
                  curvepars=c(0.0000001,100),
                  evopars=c(0,psi_index,Psi_min,1,
                            0, meta_index, 0, 1,
                            0, Sj_index,Sjmin,Sjmax,
                            0,Sb_index,Xbmin,Sm),
                  covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                  parameters = Pars,
                  options=c("report", "1"),
                  clean=TRUE)

Xmax2 =0.8
Xmax1 = 0
Env = c(0,5.26315805E-01, 6.88638138E-02)
Sb = 1.00404939E-02
Psi = 1
Meta = 9.28760815E-07
Sj = Sjmin
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Bif_Xmax1_Forwards_Xmax2_0.8_part3<-PSPMequi(modelname=model,
                                             biftype='ESS',
                                             startpoint=c(Xmax1,Env,Sb),
                                             stepsize=.1,
                                             parbnds=c(1,0,2.6,
                                                       0,Sb_index,Xbmin,Xbmax),
                                             parameters=Pars,
                                             options=
                                               c("popEVO", "0",'parEVO','15', 
                                                 "popEVO", "0",'parEVO','16',
                                                 "popEVO", "0",'parEVO','11'),
                                             clean=TRUE)

NameData(BifList = Bif_Xmax1_Forwards_Xmax2_0.8_part3, evonames=c("Sb"), bifpar="Xmax1",
         extranames=c("R0_x[psi]","R0_x[Meta]", "R0_[SJ]"),
         datalist="BifXmax1_Forwards_Xmax2_0.8_part3")

###Plot direct development
DirectDevelopmentPoint = min(BifXmax1_Backwards_Xmax2_0.8_part1$data$Xmax1)
DirectDevelopmentData = data.frame(Xmax1=c(DirectDevelopmentPoint,DirectDevelopmentPoint), Sj = c(0.00055,0.012))
DirectDevelopmentPlot = ggplot(data=BifXmax1_Forwards_Xmax2_0.8_part2$data, aes(x=Xmax1*0.1, y=Sj))+
  layout+
  geom_path(size = 2, aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb, colour = "at birth"), size = 2)+
  geom_path(data=BifXmax1_Forwards_Xmax2_0.8_part1$data, size = 2,  aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb , colour = "at birth"), data=BifXmax1_Forwards_Xmax2_0.8_part1$data, size = 2)+
  geom_path(data=BifXmax1_Backwards_Xmax2_0.8_part1$data,  size = 2,  aes(colour = "at metamorphosis"))+
  geom_path(aes(y=Sb, colour = "at birth"),data=BifXmax1_Backwards_Xmax2_0.8_part1$data, size = 2)+
  geom_path(aes(y=Sb, colour = "at birth"),data=subset(BifXmax1_Forwards_Xmax2_0.8_part3$data, Xmax1<DirectDevelopmentPoint), size = 2)+
  geom_hline(aes(yintercept = xmin), linetype = 'dashed')+
  coord_cartesian(xlim = c(0, 0.11), ylim=c(0,0.012),expand = c(0,0))+
  scale_y_continuous(breaks=c(0,0.003,0.006,0.009,0.01,0.012),
                     labels=c(0,0.003,0.006,0.009,expression(italic(s)[min]),0.012))+
  #geom_vline(aes(xintercept = 0.1*as.numeric(DirectDevelopmentPoint)), linetype = 'dotted')+
  geom_line(data=DirectDevelopmentData, linetype = 'dotted')+
  scale_colour_manual(values=c(X0col,Xjcol))+
  theme(legend.position=c(0.34,0.12),
        legend.background = element_blank(),
        legend.box.background = element_blank(),
        legend.key = element_blank())+
  annotate(geom="text", x=0.025, y=0.006,label = "Direct development\nonly",
           size=3,colour='black',
           family="Arial",
           angle=90)+
  ylab("Body mass (mg)")+
  xlab(expression(atop("Supply of primary food source,", paste(delta*X["1,max"], " (mg ", L^-1, day^-1,")"))))
DirectDevelopmentPlot

###For high values of Xmax1, the ESS is an ERP#####
Xmax1=0.7575021	
Xmax2 = 0.8
Env = c(0.5352226,	0.5658058,	0.6315352)	
Sb = 	0.0015819300
Psi = 0
Meta = 1
Sj = Sjmin
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
EvoDyn=PSPMevodyn(modelname="Stagestructured", 
                  startpoint=c(Env, Psi,Meta,Sj, Sb), 
                  curvepars=c(0.0000001,100),
                  evopars=c(0,psi_index,Psi_min,1,
                            0, meta_index, 0, 1,
                            0, Sj_index,Sjmin,Sjmax,
                            0,Sb_index,Xbmin,Sm),
                  covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                  parameters = Pars,
                  options=c("report", "1"),
                  clean=TRUE)

EvoData = as.data.frame(EvoDyn$curvepoints)
EvoData$part = 0
EvoData$Evol.time2 = EvoData$Evol.time
sizeplot=ggplot(data=EvoData,  aes(x=Evol.time,y=SJ+xmin))+
  geom_path(colour='blue')+
  geom_path(aes(y=SB),colour='red')+
  geom_hline(aes(yintercept=xmin),linetype='dotted')+
  #geom_hline(aes(yintercept=Sm),linetype='dotted')+
  NULL
metaplot=ggplot(data=EvoData,aes(x=Evol.time,y=META))+geom_path()
psiplot = ggplot(data=EvoData,aes(x=Evol.time,y=PSI))+geom_path()
multiplot(sizeplot,metaplot,psiplot, cols=3)

#Canonical equation, switch to alternative equi at the LP#
i_start=0
i_end = 20 
i=i_start
f = 0
for (i in c(i_start:i_end)){
  if (f == 3){
    beep(2)
    break
  }
  i=i+1
  print(i)
  LastPoint = as.numeric(EvoData[nrow(EvoData),])
  Env_old = LastPoint[c(2:4)]
  Psi=min(1,max(0,LastPoint[5]))
  Meta=min(1,max(0,LastPoint[6]))
  Sj=min(Sjmax,max(Sjmin,LastPoint[7]))
  Sb=min(Sm,max(Xbmin,LastPoint[8]))
  pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
         Psi,Meta,Qs,Rho)
  bpxm1 = 1
  #Find BP
  BPfind<-PSPMequi(modelname=model, 
                   biftype="EQ", 
                   startpoint=c(bpxm1,bpxm1,Xmax2), 
                   stepsize=-.1,
                   parbnds=c(1,0.3,5),
                   parameters=pars,
                   options=c("popZE", "0"),
                   clean=TRUE,
                   force=FALSE)
  bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
  Nontriv <- PSPMequi(modelname=model,
                      biftype='EQ',
                      startpoint=c(bound.point, 0),
                      stepsize=.1, 
                      parbnds=c(1, 0.0, Xmax1+0.7), 
                      parameters=pars,
                      clean=TRUE)
  #check that it is different from old env, if not, take the other env (before/after lp)
  if (length(Nontriv$biftypes)  == 0){
    dataGoed = as.data.frame(Nontriv$curvepoints)
  } else if (length(Nontriv$biftypes)  == 2) {
    dataNow=as.data.frame(Nontriv$curvepoints)
    indexLP1=which.min(abs(Nontriv$curvepoints[,1] - Nontriv$bifpoints[1,1]))
    indexLP2=which.min(abs(Nontriv$curvepoints[,1] - Nontriv$bifpoints[2,1]))
    if (i %% 2 == 0){
      dataGoed = dataNow[c(1:indexLP1),]
    }
    else {
      dataGoed = dataNow[c(indexLP2:nrow(dataNow)),]
    }
  } else if (length(Nontriv$biftypes)  == 1){
    dataNow=as.data.frame(Nontriv$curvepoints)
    indexLP=which.min(abs(Nontriv$curvepoints[,1] - Nontriv$bifpoints[1,1]))
    data1=dataNow[c(1:indexLP),]
    data2=dataNow[c(indexLP:nrow(dataNow)),]
    if (i %% 2 == 0){
      dataGoed = data1
    }
    else {
      dataGoed = data2
    }
  }
  index = which.min(abs(dataGoed[,1] - Xmax1))
  Init_point = as.numeric(dataGoed[index, c(2:4)])
  EvoDyn=PSPMevodyn(modelname=model, 
                    startpoint=c(Init_point, Psi,Meta,Sj, Sb), 
                    curvepars=c(0.00000001,100),
                    evopars=c(0,psi_index,Psi_min,1,
                              0, meta_index, 0, 1,
                              0, Sj_index,Sjmin,Sjmax,
                              0,Sb_index,Xbmin,Sm),
                    covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                    parameters = pars,
                    options=NULL,
                    clean=TRUE)
  CanData=as.data.frame(EvoDyn$curvepoints)
  if (nrow(CanData) < 5){
    f = f + 1
  } else {
    f = 0
  }
  CanData$Evol.time2=CanData$Evol.time+max(EvoData$Evol.time2)
  CanData$part = i
  EvoData=rbind(EvoData,CanData)
  EvoData$ID <- seq.int(nrow(EvoData))
  if (i %% 1 == 0){
    sizeplot=ggplot(data=EvoData,  aes(x=ID,y=SJ+xmin))+
      geom_path(colour='blue')+
      geom_path(aes(y=SB),colour='red')+
      geom_hline(aes(yintercept=xmin),linetype='dotted')+
      ggtitle(i)+
      NULL
    metaplot=ggplot(data=EvoData,aes(x=ID,y=META))+geom_path()
    psiplot = ggplot(data=EvoData,aes(x=ID,y=PSI))+geom_path()
    Sjplot =ggplot(data=EvoData,aes(x=ID,y=SJ+xmin))+geom_path()
    Sbplot  =ggplot(data=EvoData,aes(x=ID,y=SB))+geom_path()
    multiplot(Sjplot,Sbplot,metaplot,psiplot, cols=2)
    EvoData = EvoData[,c(1:22)]
    Sys.sleep(1)}
}



###For lower values, the ESS is an EBP, Calculation of a branching extinction cycle, low Xmax1 #####
Xmax2 = 0.8
Meta = 1
Sj = Sjmin
Xmax1 = 5.82123486E-01
Env = c(5.81206798E-01, 5.56057399E-01, 1.00069165E-01)
Psi = 9.95592573E-07
Sb = 9.90089423E-03
Sb_S1 =  Sb	 - 0.0000001
Sj_S1 = Sj 
Psi_S1 = Psi 
Meta_S1 = 1
Sb_S2 = 	Sb	 + 0.0000001
Sj_S2 = Sj 
Psi_S2 =  Psi 
Meta_S2 = Meta_S1 
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Pars2Spec=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sm,Mu,xmin,
            Qs,Rho, Sb_S1,Sj_S1,Psi_S1,Meta_S1,Sb_S2,Sj_S2,Psi_S2,Meta_S2)
Env_2Spec = c(Env[1],Env[2],Env[3]/2,Env[3]/2)
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)

EvoDyn=PSPMevodyn(modelname="Stagestructured_twospecies",
                  startpoint=c(Env_2Spec, Psi_S1,Psi_S2,Meta_S1,Meta_S2,Sj_S1, Sj_S2, Sb_S1,Sb_S2),
                  curvepars=c(0.000001,1000000000),
                  evopars=c(0,Psi_S1_index,Psi_min,1,
                            1,Psi_S2_index,Psi_min,1,
                            0, Meta_S1_index, 0, 1,
                            1, Meta_S2_index, 0, 1,
                            0, Sj_S1_index,Sjmin,Sjmax,
                            1, Sj_S2_index,Sjmin,Sjmax,
                            0,Sb_S1_index,Xbmin,Sm,
                            1,Sb_S2_index,Xbmin,Sm),
                  covars = NULL,
                  parameters = Pars2Spec,
                  options=c("report", "100"),
                  clean=TRUE)
#Extinction of species 1, Continue with species 2##
Env=c(5.82266702E-01, 5.56055127E-01, 2.46890416E+00)
Psi = 9.45019410E-07
Sb = 9.90331954E-03
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
EvoDyn_part2=PSPMevodyn(modelname="Stagestructured", 
                        startpoint=c(Env, Psi,Meta,Sj, Sb), 
                        curvepars=c(0.00000001,100),
                        evopars=c(0,psi_index,Psi_min,1,
                                  0, meta_index, 0, 1,
                                  0, Sj_index,Sjmin,Sjmax,
                                  0,Sb_index,Xbmin,Sm),
                        covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,10000), ##These covars to speed up calc. Same results with Identity matrix
                        parameters = Pars,
                        options=c("report", "100"),
                        clean=TRUE)
EvoNames= c("PSI", "META", "SJ", "SB")
CanonicalOneSpecies = as.data.frame(EvoDyn_part2$curvepoints)
colnames(CanonicalOneSpecies) = c("Evol.time", Env.names, EvoNames, output, "R0", "RhsNorm")


###For lower values, the ESS is an EBP, Calculation of a branching extinction cycle,  higher Xmax1#####
Xmax1 = 5.95551104E-01
Env = c(5.69035471E-01, 5.56433875E-01, 1.28989174E-01)
Psi = 8.68150420E-07
Sb = 7.55712815E-03

Sb_S1 =  Sb	 - 0.0000001
Sj_S1 = Sj 
Psi_S1 = Psi 
Meta_S1 = 1
Sb_S2 = 	Sb	 + 0.0000001
Sj_S2 = Sj 
Psi_S2 =  Psi 
Meta_S2 = Meta_S1 

Pars2Spec=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sm,Mu,xmin,
            Qs,Rho, Sb_S1,Sj_S1,Psi_S1,Meta_S1,Sb_S2,Sj_S2,Psi_S2,Meta_S2)

Env_2Spec = c(Env[1],Env[2],Env[3]/2,Env[3]/2)

EvoDyn=PSPMevodyn(modelname="Stagestructured_twospecies",
                  startpoint=c(Env_2Spec, Psi_S1,Psi_S2,Meta_S1,Meta_S2,Sj_S1, Sj_S2, Sb_S1,Sb_S2),
                  curvepars=c(0.000001,100),
                  evopars=c(0,Psi_S1_index,Psi_min,1,
                            1,Psi_S2_index,Psi_min,1,
                            0, Meta_S1_index, 0, 1,
                            1, Meta_S2_index, 0, 1,
                            0, Sj_S1_index,Sjmin,Sjmax,
                            1, Sj_S2_index,Sjmin,Sjmax,
                            0,Sb_S1_index,Xbmin,Sm,
                            1,Sb_S2_index,Xbmin,Sm),
                  covars = NULL,
                  parameters = Pars2Spec,
                  options=c("report", "100"),
                  clean=TRUE)

data=as.data.frame(EvoDyn$curvepoints)
colnames(data) =c("Evol.time", Env.names2Spec, EvoNames,output2Spec, "R0_S1", "R0_S2", "RhsNorm")

#Extinction of species 1, Continue with species 2##
Env=c(0.569067, 0.5564318,0.1399369)
Psi =8.023128e-07   
Sb = 0.00755898
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
EvoDyn_part2=PSPMevodyn(modelname="Stagestructured", 
                        startpoint=c(Env, Psi,Meta,Sj, Sb), 
                        curvepars=c(0.00000001,100),
                        evopars=c(0,psi_index,Psi_min,1,
                                  0, meta_index, 0, 1,
                                  0, Sj_index,Sjmin,Sjmax,
                                  0,Sb_index,Xbmin,Sm),
                        covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,10000), ##These covars to speed up calc. Same results with Identity matrix
                        parameters = Pars,
                        options=c("report", "100"),
                        clean=TRUE)
EvoNames= c("PSI", "META", "SJ", "SB")
CanonicalOneSpecies = as.data.frame(EvoDyn_part2$curvepoints)
colnames(CanonicalOneSpecies) = c("Evol.time", Env.names, EvoNames, output, "R0", "RhsNorm")


###When extinction, when direct development?#####
Meta = 1
Xmax2 = 0.504
Xmax1 = 0
Psi = 0
Q = 1
xmin = 1e-5
Sb = xmin+1E-5
Pars=c(delta,Xmax1,Xmax2,epsilon,Q,Tr,Amax,Amin,H,Sig,Sb,Sj,Sm,Mu,xmin,
       Psi,Meta,Qs,Rho)
Xs1 = 3

BPfind<-PSPMequi(modelname="Stagestructured", 
                 biftype="EQ", 
                 startpoint=c(Xs1,Xmax1,Xs1), 
                 stepsize=-.1,
                 parbnds=c(which(pars.names == 'Xmax2') - 1,0.3,5),
                 parameters=Pars,
                 options=c("popZE", "0"),
                 clean=TRUE,
                 force=FALSE)
bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
bound.point
BPcont_P1<-PSPMequi(modelname="Stagestructured", 
                    biftype="BP", 
                    startpoint=c(bound.point, Sb), 
                    stepsize=-1,
                    parbnds=c(which(pars.names == 'Xmax2') - 1,0,5, Sb_index, Sbmin, Sm),
                    parameters=Pars,
                    options=c("popBP", "0"),
                    clean=TRUE,
                    force=FALSE)
BPcont_P2<-PSPMequi(modelname="Stagestructured", 
                    biftype="BP", 
                    startpoint=c(bound.point, Sb), 
                    stepsize=.1,
                    parbnds=c(which(pars.names == 'Xmax2') - 1,0,5, Sb_index, Sbmin, Sm),
                    parameters=Pars,
                    options=c("popBP", "0"),
                    clean=TRUE,
                    force=FALSE)
TwoParPlot=ggplot(data=as.data.frame(BPcont_P1$curvepoints),aes(x=R2max*0.1,y=SB))+
  geom_path(size=2)+
  geom_path(data=as.data.frame(BPcont_P2$curvepoints),size=2)+
  layout+
  coord_cartesian(xlim=c(0.054,.0655), ylim=c(0,0.101), expand = c(0,0))+
  ylab(expression(atop("Body mass where secondary food ", paste("source becomes available, ",italic(s)["min"]," (mg)"))))+
  xlab(expression(atop("Supply of secondary food source,", paste(delta*X["1,max"], " (mg ", L^-1, day^-1,")"))))+
  scale_y_continuous(breaks=c(0,0.025,0.05,0.075, 0.1),
                     labels=c(0, 0.025,0.05,0.075, expression(italic(s)[m])))+
  scale_x_continuous(breaks=c(0.055, 0.06, 0.065))+
  annotate(geom="text", x=0.062, y=0.025,label = "Direct development\n evolves for low\nresource supply",size=3,colour='black',
           family="Arial")+
  annotate(geom="text", x=0.0585, y=0.08,label = "Population goes extinct\nfor low resource\nsupply",size=3,colour='black',
           family="Arial")
TwoParPlot

