###Calculations of direct development paper#####
###LIBS######
library(grid)
library(gridExtra)
library(gtable)
library(colorspace)
library(scales)
library(plyr)
#devtools::install_bitbucket("amderoos/pspmanalysis/R") #If pspmanalysis is not installed
library(PSPManalysis)
#for manual: PSPMhelp("pdf") or PSPMhelp("htlm")
#####Standard par values####
#Par as in persson et al. (1998)
#Multiply all resource densities with 1.1*10^-2 to get densities in mg/Liter or  1.1*10^-5 for g/l
weight= (1.1*10^-5) #Weight of prey
Xjmin=1e-05 ###Minimum value for size at meta (which is Xj + Xmin)
Xbmin=0.0001/1.742 ##Minimum size for eggs
X0=Xbmin
Xj=Xjmin
Delta=0.1
Amin=10000
Amax=100000
Alpha=0.93
W0=17.42
chi1=4E-06
chi2=8.19E-05
chi3=0.68
chi4=0.00115
m1=0.033
m2=0.77
k1=6.71E-06
k2=0.5
Xf=5
Qj=0.742
Qa=1
Qs=0.2
mu0=0.01
Sigma=100*weight
Rho=0.5
Mu_H1 = 0
####Find ESS where meta is present##### 
Xmin = 0.1
psi = 0
Meta = 1
Xb = 0.014
Xmax1=3
Xmax2=10
Xj = 0.025
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1) 
bpxm1 =1.5
#Find BP
BPfind<-PSPMequi(modelname="Loss_of_Meta_pspm", 
                 biftype="EQ", 
                 startpoint=c(bpxm1,bpxm1,Xmax2), 
                 stepsize=-.01,
                 parbnds=c(1,0,15),
                 parameters=pars,
                 options=c("popZE", "0"),
                 clean=TRUE,
                 force=FALSE)
bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
#Step2: Continue non-triv equi over xmax1 to find equilibrium values
#Xmaxvalue<-Pars[which(pars.names == 'Xmax1')]
Nontriv <- PSPMequi(modelname="Loss_of_Meta_pspm",
                    biftype='EQ',
                    startpoint=c(bound.point, 0),
                    stepsize=.1, 
                    parbnds=c(1, 0.0, Xmax1), 
                    parameters=pars,
                    options=c("popEVO", "0"),
                    clean=TRUE)
Init_point = as.numeric(Nontriv$curvepoints[nrow(Nontriv$curvepoints), c(2:4)])

###Canonical
EvoDyn = PSPMevodyn(modelname="Loss_of_Meta_pspm", 
                    startpoint=c(Init_point, psi,Meta,Xj, Xb), 
                    curvepars=c(1,3000),
                    evopars=c(0,Psi_index, 0, 1, 0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1),
                    covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                    parameters = pars,
                    options=NULL,
                    clean=TRUE)
evo1=as.data.frame(EvoDyn$curvepoints)


alldata=evo1
alldata$run=0
#Cycling, go to different equi at the LP
for (i in 1:5) {
  dat=as.data.frame(EvoDyn$curvepoints)
  pnt =as.numeric(dat[nrow(dat),c(2:8),])
  psi = min(1,max(0,pnt[4]))
  Meta = min(1,max(0,pnt[5]))
  Xj=pnt[6]
  Xb = pnt[7]
  pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
           Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
           m2,k1,k2, Xb,Xmin, Xj, Xf,
           Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
  bpxm2 =4
  bpxm1 = 1.2
  f = 1
  if (f==1){
    #Find BP
    BPfind<-PSPMequi(modelname="Loss_of_Meta_pspm",
                     biftype="EQ",
                     startpoint=c(bpxm2,Xmax1,bpxm2),
                     stepsize=-.1,
                     parbnds=c(2,0.9,8),
                     parameters=pars,
                     options=c("popZE", "0"),
                     clean=TRUE,
                     force=FALSE)
    bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
    Nontriv2 <- PSPMequi(modelname="Loss_of_Meta_pspm",
                         biftype='EQ',
                         startpoint=c(bound.point, 0),
                         stepsize=.1,
                         parbnds=c(2, 0.0, Xmax2+2),
                         parameters=pars,
                         clean=TRUE)
    Init_point = as.numeric(Nontriv2$curvepoints[nrow(Nontriv2$curvepoints), c(2:4)])
    a=as.data.frame(Nontriv2$curvepoints)
    Index = which.min(abs(a$R2max-Xmax2))
    Init_point=as.numeric(a[Index,c(2:4)])
    
    Lpindex1=which.min(abs(a$R2max-as.numeric(Nontriv2$bifpoints[1,1])))
    Lpindex2=which.min(abs(a$R2max-as.numeric(Nontriv2$bifpoints[2,1])))
    part1=a[1:Lpindex1,]
    part2=a[Lpindex2:nrow(a),]
    if(i%%2 ==0){
      Index = which.min(abs(part1$R2max-Xmax2))
      Init_point=as.numeric(part1[Index,c(2:4)])
    }else {
      Index = which.min(abs(part2$R2max-Xmax2))
      Init_point=as.numeric(part2[Index,c(2:4)])
    }
  } else{
    BPfind<-PSPMequi(modelname="Loss_of_Meta_pspm",
                     biftype="EQ",
                     startpoint=c(bpxm1,bpxm1,Xmax2),
                     stepsize=-.01,
                     parbnds=c(1,0.7,8),
                     parameters=pars,
                     options=c("popZE", "0"),
                     clean=TRUE,
                     force=FALSE)
    bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
    Nontriv2 <- PSPMequi(modelname="Loss_of_Meta_pspm",
                         biftype='EQ',
                         startpoint=c(bound.point, 0),
                         stepsize=.1,
                         parbnds=c(1, 0.0, Xmax1+2),
                         parameters=pars,
                         clean=TRUE)
    a=as.data.frame(Nontriv2$curvepoints)
    Lpindex1=which.min(abs(a$R1max-as.numeric(Nontriv2$bifpoints[1,1])))
    Lpindex2=which.min(abs(a$R1max-as.numeric(Nontriv2$bifpoints[2,1])))
    part1=a[1:Lpindex1,]
    part2=a[Lpindex2:nrow(a),]
    if(i%%2 ==1){
      Index = which.min(abs(part1$R1max-Xmax1))
      Init_point=as.numeric(part1[Index,c(2:4)])
    }else {
      Index = which.min(abs(part2$R1max-Xmax1))
      Init_point=as.numeric(part2[Index,c(2:4)])
    }
  }
  dir=1
  EvoDyn = PSPMevodyn(modelname="Loss_of_Meta_pspm", 
                      startpoint=c(Init_point, psi,Meta,Xj, Xb), 
                      curvepars=c(10,1000000),
                      evopars=c(0,Psi_index, 0, 1, 0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1),
                      covars = c(1*dir,0,0,0,0,dir*1,0,0,0,0,dir*1,0,0,0,0,dir*1),
                      parameters = pars,
                      options=NULL,
                      clean=TRUE,
                      force=FALSE)
  data=as.data.frame(EvoDyn$curvepoints)
  data$Evol.time=data$Evol.time+max(alldata$Evol.time)
  data$run= i
  alldata=rbind(alldata,data)
  print(i)
  if(i%%100==0){
    saveRDS(alldata,"backupcanonical.rds")
  }
}



pnt = c(8.68422823E-01, 3.87327022E+00, 4.43167216E-06,-9.58940299E-06, 9.99040845E-01, 2.44480151E-02, 9.52318676E-03)
psi = min(1,max(0,pnt[4]))
Meta = min(1,max(0,pnt[5]))
Xj=pnt[6]
Xb = pnt[7]
Env = pnt[c(1:3)]

######Bif Over Xmax2#####
psi = 0
Meta = 0.9990667
Xj = 0.02444777
Xb = 0.00952302
Env = c(8.684038e-01, 3.873324e+00, 4.431747e-06)
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1) 
BifXmax2_A = PSPMequi(modelname="Loss_of_Meta_pspm",
                      biftype='ESS',
                      startpoint=c(Xmax2,Env,Meta,Xj,Xb),
                      stepsize=.1,
                      parbnds=c(2,0,20,0,Meta_index,0,1,0,Xj_index,Xjmin,5,0,Xb_index,Xbmin,5),
                      parameters=pars,
                      options=c("popEVO", "0",'parEVO','24'),
                      clean=TRUE)

BifXmax2_B = PSPMequi(modelname="Loss_of_Meta_pspm",
                      biftype='ESS',
                      startpoint=c(Xmax2,Env,Meta,Xj,Xb),
                      stepsize=-0.1,
                      parbnds=c(2,0,20,0,Meta_index,0,1,0,Xj_index,Xjmin,5,0,Xb_index,Xbmin,5),
                      parameters=pars,
                      options=c("popEVO", "0",'parEVO','24'),
                      clean=TRUE)
Xmax2 = 6.09956746E+00
Meta = 1
Xj = 7.50163334E-02
Xb = 2.54012171E-03
Env = c(9.80241908E-01, 2.12416284E+00, 6.09204679E-06)
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho) 
BifXmax2_C = PSPMequi(modelname="Loss_of_Meta_pspm",
                      biftype='ESS',
                      startpoint=c(Xmax2,Env,Xj,Xb),
                      stepsize=-0.1,
                      parbnds=c(2,0,20,0,Xj_index,Xjmin,5,0,Xb_index,Xbmin,5),
                      parameters=pars,
                      options=c("popEVO", "0",'parEVO','24',
                                "popEVO", "0",'parEVO','25'),
                      clean=TRUE)


BifXmax2_AData=as.data.frame(BifXmax2_A$curvepoints)
BifXmax2_AData$`R0_x[25]` = 0
BifXmax2_BData=as.data.frame(BifXmax2_B$curvepoints)
BifXmax2_BData$`R0_x[25]` = 0
BifXmax2_CData=as.data.frame(BifXmax2_C$curvepoints)
BifXmax2_CData$Meta = 1
BifXmax2_All = rbind(BifXmax2_AData,BifXmax2_BData,
                     BifXmax2_CData)
BifXmax2_All$psi = 0
#
#######Bif over Xmin#######
Xmax2 = 10
Xmax1 = 3
Xmin = 0.1

BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
psi=0
Meta=min(1,Initpnt[5])
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmin_forwards = PSPMequi(modelname="Loss_of_Meta_pspm",
                            biftype='ESS',
                            startpoint=c(Xmin,Env, Meta, Xj, Xb),
                            stepsize=.1,
                            parbnds=c(16,0,10,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                            parameters=pars,
                            options=c("popEVO", "0",'parEVO','24'),
                            clean=TRUE)
p2 = as.data.frame(BifXmin_forwards$curvepoints)
BifXmin_backwards = PSPMequi(modelname="Loss_of_Meta_pspm",
                             biftype='ESS',
                             startpoint=c(Xmin,Env, Meta, Xj, Xb),
                             stepsize=-.1,
                             parbnds=c(16,0,10,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
p1 = as.data.frame(BifXmin_backwards$curvepoints)
pnt = as.numeric(p1[nrow(p1),c(1:4,6:7)])
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmin_backwards2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                              biftype='ESS',
                              startpoint=pnt,
                              stepsize=-.01,
                              parbnds=c(16,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24',
                                        "popEVO", "0",'parEVO','25'),
                              clean=TRUE)

p1b = as.data.frame(BifXmin_backwards2$curvepoints)
p1b$Meta = 1
p1b = subset(p1b, `R0_x[25]`>=0)
p2$`R0_x[25]` = 0
p1$`R0_x[25]` = 0
XminHighXmax2 = rbind(p2[c(nrow(p2):1),],p1,p1b)
info = BifXmin_backwards2$curvedesc
XminHighXmax2All=list(data=XminHighXmax2,info=info)


###Continue bif over Xmin####
Xmin = 0.04115517	
pnt = c(0.9206028,	2.461707,	7.228993e-06,	0.9999432,	0.02046721,	0.00488071)
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax2_Extra = PSPMequi(modelname="Loss_of_Meta_pspm",
                          biftype='ESS',
                          startpoint=c(Xmax2,pnt),
                          stepsize=-.1,
                          parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                          parameters=pars,
                          options=c("popEVO", "0",'parEVO','24'),
                          clean=TRUE)
pnt = c(8.91696642E+00, 9.52500617E-01, 2.16856558E+00, 7.89069638E-06, 2.75678514E-02, 3.40081401E-03)
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax2_Extra_b = PSPMequi(modelname="Loss_of_Meta_pspm",
                            biftype='ESS',
                            startpoint=pnt,
                            stepsize=-.1,
                            parbnds=c(2,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                            parameters=pars,
                            options=c("popEVO", "0",'parEVO','24',
                                      "popEVO", "0",'parEVO','25'),
                            clean=TRUE)
#Get xmin data for Xmax2 onwards##
Xmax2=5
pnt = c(1.12418639E+00, 1.38021117E+00, 7.53898322E-06, 1.50393779E-01, 7.12036182E-04)
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmin_backwards3 = PSPMequi(modelname="Loss_of_Meta_pspm",
                              biftype='ESS',
                              startpoint=c(Xmin,pnt),
                              stepsize=-.1,
                              parbnds=c(16,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24',
                                        "popEVO", "0",'parEVO','25',
                                        'noLP'),
                              clean=TRUE)
p1c = as.data.frame(BifXmin_backwards3$curvepoints)
All=list(data=p1c,info=BifXmin_backwards3$curvedesc)
XminMedXmax2 =All


#####Fig 2 (Direct development) Meta Calculation####
Xmax2=15
Xmax1=3
Xmin=0.1
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
psi=0
Meta=min(1,Initpnt[5])
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]

Meta = 0.8840179 
Xj  = 0.01595754
Xb = 0.02115194
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax1_No_Evo = PSPMequi(modelname="Loss_of_Meta_pspm",
                           biftype='EQ',
                           startpoint=c(Xmax1,Env),
                           stepsize=-.1,
                           parbnds=c(1,0,10),
                           parameters=pars,
                           options=NULL,
                           clean=TRUE)
Meta_EcoOnly = as.data.frame(BifXmax1_No_Evo$curvepoints)
colnames(Meta_EcoOnly) = c("R1max", "R1", "R2", "b[0]", 
                           outputnames2, "R0", "rhsnorm")
EcoDD = list(data=Meta_EcoOnly, info=BifXmax1_No_Evo$curvedesc)

BifXmax1_backwards = PSPMequi(modelname="Loss_of_Meta_pspm",
                              biftype='ESS',
                              startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                              stepsize=-.1,
                              parbnds=c(1,0,10,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)
BifXmax1_forwards = PSPMequi(modelname="Loss_of_Meta_pspm",
                             biftype='ESS',
                             startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                             stepsize=.1,
                             parbnds=c(1,0,10,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
p1 = as.data.frame(BifXmax1_backwards$curvepoints)
p2 = as.data.frame(BifXmax1_forwards$curvepoints)

pnt = as.numeric(p2[nrow(p2),])
Xmax1 = pnt[1]
Env = pnt[c(2:4)]
Xj = pnt[6]
Xb = pnt[7]
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax1_forwards2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                              biftype='ESS',
                              startpoint=c(Xmax1,Env,  Xj, Xb),
                              stepsize=.1,
                              parbnds=c(1,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24',
                                        "popEVO", "0",'parEVO','25'),
                              clean=TRUE)
p3 = as.data.frame(BifXmax1_forwards2$curvepoints)

colnames(p1) = c("R1max", "R1", "R2", "b[0]", "Meta", "Xj","x0",
                 outputnames2, "R0","R0_x[24]", ESS_multiplenames)
colnames(p2) = c("R1max", "R1", "R2", "b[0]", "Meta", "Xj","x0",
                 outputnames2, "R0","R0_x[24]", ESS_multiplenames)
p1$`R0_x[25]` = 0
p2$`R0_x[25]` = 0
colnames(p3) = c("R1max", "R1", "R2", "b[0]","Xj","x0",
                 outputnames2, "R0","R0_x[24]","R0_x[25]", ESS_multiplenames)
p3$Meta = 1
BifHighData = rbind(p1[nrow(p1):1,],p2,p3)
BifHighData$ESS = ifelse(BifHighData$`eig J`>0, "ERP", ifelse(BifHighData$`eig H`<0&BifHighData$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifHighData$`eig H`<0, 'Weak CSS', ifelse(BifHighData$`Z^T C01 Z`<=0, 'EBP', "?"))))
BifHighData$Psi = 0


HighXmax2 = list(info=BifXmax1_backwards$curvedesc,data=BifHighData)

BifXmax1_backwardsHigh=HighXmax2
BifHighData = BifXmax1_backwardsHigh$data

#

#####Fig 2 (Direct development) Direct development calculation ######
Xj=0.01468212
Xb=0.1244735
Meta=0
psi=1
Xmax1=1.09155
Xmax2=15
Env=c(1.09132,
      3.563944,
      6.031719e-07)
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifDD1 = PSPMequi(modelname="Loss_of_Meta_pspm",
                  biftype='ESS',
                  startpoint = c(Xmax1,Env,Xb),
                  stepsize=.1,
                  parbnds=c(1,0,20, 0, Xb_index,0,5),
                  parameters=pars,
                  clean=FALSE,
                  options = c('noLP','noBP',
                              "popEVO", "0",'parEVO','17',
                              "popEVO", "0",'parEVO','24',
                              "popEVO", "0",'parEVO','25'))
BifDD2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                  biftype='ESS',
                  startpoint = c(Xmax1,Env,Xb),
                  stepsize=-.1,
                  parbnds=c(1,0,20, 0, Xb_index,0,5),
                  parameters=pars,
                  clean=FALSE,
                  options = c('noLP','noBP',
                              "popEVO", "0",'parEVO','17',
                              "popEVO", "0",'parEVO','24',
                              "popEVO", "0",'parEVO','25'))


part1=as.data.frame(BifDD1$curvepoints)
part2=as.data.frame(BifDD2$curvepoints)
All=rbind(part2[c(nrow(part2):1),],part1)
All$xxyy = All$`R0_xx` - All$`R0_yy`
All$ESS = ifelse(All$xxyy <= 0, "ERP", ifelse ( All$`R0_yy` <=0, 'CSS', ifelse( All$`R0_yy` >0 & All$xxyy >0, "EBP", "ESS")))
colnames(All) = c("R1max", "R1", "R2", "b[0]","x0",
                  outputnames2, "R0","R0_x[17]","R0_x[24]","R0_x[25]", ESSsingle.names,"rhsnorm","xxyy","ESS")
All$Meta = 0
All$Psi = 1
DirectDataHigh = list(data=All, info = BifDD2$curvedesc)




#####Fig 2 (Direct development) ERP Calculation ######
Xmin = 0.1
a = subset(BifHighData,`R0_x[24]`<=0)
pnt = as.numeric(a[1,])
Xmax1 = pnt[1]
Xmax2 = 15
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
Xb = pnt[7]
Psi = 0 
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax1_ERP_P1 = PSPMequi(modelname="Loss_of_Meta_pspm",
                           biftype='ESS',
                           startpoint=c(Xmax1,Env, Xb, Psi, Meta,Xj),
                           stepsize=.1,
                           parbnds=c(1,0,8.3, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                     0,Meta_index,0,1,0,Xj_index,0,1),
                           options=c("noLP", "noBP"),
                           parameters=pars,
                           clean=TRUE)

ERP1 = as.data.frame(BifXmax1_ERP_P1$curvepoints)
colnames(ERP1) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                   outputnames2, "R0", ESS_multiplenames)

ERPnieuw = subset(ERP1, R1max<=1.47047450E+00)

pnt = c(1.477396, 1.332038, 4.749233, 7.671286e-07, 0.1030347, 0.4358282, 0.5638789, 0.01650055)
BifXmax1_ERP_P2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                           biftype='ESS',
                           startpoint=pnt,
                           stepsize=.1,
                           parbnds=c(1,0,8.3, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                     0,Meta_index,0,1,0,Xj_index,0,1),
                           options=c("noLP", "noBP"),
                           parameters=pars,
                           clean=TRUE)
ERP2 = as.data.frame(BifXmax1_ERP_P2$curvepoints)
colnames(ERP2) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                   outputnames2, "R0", ESS_multiplenames)
pnt = c(2.88483932E+00, 2.83091535E+00, 3.89214298E+00, 6.65927902E-07, 1.15780359E-01, 7.85389402E-01, 2.14614712E-01, 2.26259883E-02)
BifXmax1_ERP_P3 = PSPMequi(modelname="Loss_of_Meta_pspm",
                           biftype='ESS',
                           startpoint=pnt,
                           stepsize=.1,
                           parbnds=c(1,0,8.3, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                     0,Meta_index,0,1,0,Xj_index,0,1),
                           options=c("noLP", "noBP"),
                           parameters=pars,
                           clean=TRUE)
ERP3 = as.data.frame(BifXmax1_ERP_P3$curvepoints)
colnames(ERP3) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                   outputnames2, "R0", ESS_multiplenames)



ERPData = rbind(ERPnieuw,ERP2,ERP3)
ERPData$ESS = ifelse(ERPData$`eig J` == Inf, "NA", ifelse(ERPData$`eig J`>0, "ERP", ifelse(ERPData$`eig H`<0&ERPData$`eig (J+J)/2`<0, 'Strong CSS', ifelse(ERPData$`eig H`<0, 'Weak CSS', ifelse(ERPData$`ZC01Z`<=0, 'EBP', "?")))))

AllData = list(data=ERPData,info=BifXmax1_ERP_P2$curvedesc)
ERPDataAll= AllData

#####Fig 3 (Direct development) Canonical equation calculation#####
DirectData_Metamorphosis=BifHighData
index = which.min(abs(DirectData_Metamorphosis$data$`R0_x[24]`))
pnt = as.numeric(DirectData_Metamorphosis$data[index-1,]) #Get point where psi will evolve away
DirectData_Metamorphosis$data[index-1,]
Xmax2 = 15
Xmax1 = pnt[1]
Xmax1 * weight
Xmax1 * weight * Delta * 1000
Env  = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
Xb = pnt[7]
psi = 0
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
Canonical_DD=PSPMevodyn(modelname="Loss_of_Meta_pspm", 
                        startpoint=c(Env, psi,Meta,Xj, Xb), 
                        curvepars=c(100,3000000000),
                        evopars=c(0,Psi_index, 0, 1, 0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1),
                        covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                        parameters = pars,
                        options=NULL,
                        clean=TRUE)
evo1=as.data.frame(Canonical_DD$curvepoints)


colnames(evo1) = c("Evol.time", Env.names,"Psi","Meta","Xj","x0",outputnames2,"R0", "Rhsnorm")
CanonicalData = list(data=AllEvo,info=Canonical_DD5$curvedesc)


###Fig 4 (Extinction) Meta Calculation#####
Xmin = 0.1
Xmax2 = 6
Xmax1 = 3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
psi=0
Meta=min(1,Initpnt[5])
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
Xj = 0.07840522
Xb = 0.00242021
Psi = 0
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax1_backwards_NoEvo = PSPMequi(modelname="Loss_of_Meta_pspm",
                                    biftype='EQ',
                                    startpoint = c(Xmax1,Env),
                                    stepsize=-.1,
                                    parbnds=c(1,0,10),
                                    parameters=pars,
                                    options=NULL,
                                    clean=TRUE,
                                    force=TRUE)
Extin_EcoOnly = as.data.frame(BifXmax1_backwards_NoEvo$curvepoints)
colnames(Extin_EcoOnly) = c("R1max", "R1", "R2", "b[0]", 
                            outputnames2, "R0", "rhsnorm")
EcoExtin = list(data=Extin_EcoOnly, info=BifXmax1_backwards_NoEvo$curvedesc)

BifXmax1_backwards_P1 = PSPMequi(modelname="Loss_of_Meta_pspm",
                                 biftype='ESS',
                                 startpoint = c(Xmax1,Env,Xj,Xb),
                                 stepsize=-.1,
                                 parbnds=c(1,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24',
                                           "popEVO", "0",'parEVO','25'),
                                 clean=TRUE,
                                 force=TRUE)
Extp1 = as.data.frame(BifXmax1_backwards_P1$curvepoints)
Extp1 = subset(Extp1, `R0_x[25]`>=0)
Extp1$Meta = 1
pnt = as.numeric(Extp1[nrow(Extp1),])
init=pnt[c(1:6)]
BifXmax1_backwards_P2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                                 biftype='ESS',
                                 startpoint = c(init,Meta),
                                 stepsize=-.1,
                                 parbnds=c(1,0,10, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5,0,Meta_index,0,1),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24'),
                                 clean=TRUE,
                                 force=TRUE)

Extp2 = as.data.frame(BifXmax1_backwards_P2$curvepoints)
Extp2$`R0_x[25]` = 0
BifLowData = rbind(Extp1,Extp2)

BifLowData$ESS = ifelse(BifLowData$`eig J`>0, "ERP", ifelse(BifLowData$`eig H`<0&BifLowData$`eig (J+J')/2`<0, 'Strong CSS', ifelse(BifLowData$`eig H`<0, 'Weak CSS', ifelse(BifLowData$`Z^T C01 Z`<=0, 'EBP', "?"))))
colnames(BifLowData) = c("R1max", "R1", "R2", "b[0]", "Meta", "Xj","x0",
                         outputnames2, "R0","R0_x[24]", ESS_multiplenames,"ESS")


LowXmax2 = list(info=BifXmax1_backwards$curvedesc,data=subset(BifLowData,`b[0]`>=0))
BifXmax1_backwardsLow=LowXmax2








###Fig 4  (Extinction) ERP Calculation######
pnt = c(1.53420366E+00, 4.48506663E+00, 1.03951508E-07, 1.07508073E-01, 5.19904015E-01, 4.79928592E-01, 1.79284755E-02)
Xmax2 = 6

pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifXmax1_ERP_Ext_P1 = PSPMequi(modelname="Loss_of_Meta_pspm",
                               biftype='ESS',
                               startpoint=c(Xmax1,pnt),
                               stepsize=-.1,
                               parbnds=c(1,0,15, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                         0,Meta_index,0,1,0,Xj_index,0,1),
                               options=c("noLP", "noBP"),
                               parameters=pars,
                               clean=TRUE)
ERP1_ext = as.data.frame(BifXmax1_ERP_Ext_P1$curvepoints)
colnames(ERP1_ext) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                       outputnames2, "R0", ESS_multiplenames)
BifXmax1_ERP_Ext_P2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                               biftype='ESS',
                               startpoint=c(Xmax1,pnt),
                               stepsize=.1,
                               parbnds=c(1,0,15, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                         0,Meta_index,0,1,0,Xj_index,0,1),
                               options=c("noLP", "noBP"),
                               parameters=pars,
                               clean=TRUE)
ERP2_ext = as.data.frame(BifXmax1_ERP_Ext_P2$curvepoints)
colnames(ERP2_ext) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                       outputnames2, "R0", ESS_multiplenames)

pnt2 = c(1.241551, 1.22342, 4.959249, 8.177675e-08, 0.1000631, 0.3844516, 0.6151533, 0.01541023)
BifXmax1_ERP_Ext_P3 = PSPMequi(modelname="Loss_of_Meta_pspm",
                               biftype='ESS',
                               startpoint=pnt2,
                               stepsize=-.1,
                               parbnds=c(1,0,15, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                         0,Meta_index,0,1,0,Xj_index,0,1),
                               options=c("noLP", "noBP"),
                               parameters=pars,
                               clean=TRUE)

ERP3_ext = as.data.frame(BifXmax1_ERP_Ext_P3$curvepoints)
colnames(ERP3_ext) = c("R1max", "R1", "R2", "b[0]", "x0","Psi","Meta", "Xj",
                       outputnames2, "R0", ESS_multiplenames)


AllErp =rbind(ERP3_ext[c(nrow(ERP3_ext):1),], ERP1_ext[c(28:1),], ERP2_ext)
ExtinctionERP = list(data=AllErp, info=BifXmax1_ERP_Ext_P1$curvedesc)


###Fig 4 (Extinction) Direct development calculation####
Xj=0.01468212
Meta=0
psi=1
Xmax1=1.09155
Xmax2 =6
Env =c( 1.09150243E+00, 3.56394451E+00, 1.24617865E-07)
Xb = 1.24473552E-01
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifDD_Ext1 = PSPMequi(modelname="Loss_of_Meta_pspm",
                      biftype='ESS',
                      startpoint = c(Xmax1,Env,Xb),
                      stepsize=-.1,
                      parbnds=c(1,0,20, 0, Xb_index,0,5),
                      parameters=pars,
                      clean=FALSE,
                      options = c('noLP','noBP',
                                  "popEVO", "0",'parEVO','17',
                                  "popEVO", "0",'parEVO','24',
                                  "popEVO", "0",'parEVO','25'))
BifDD_Ext2 = PSPMequi(modelname="Loss_of_Meta_pspm",
                      biftype='ESS',
                      startpoint = c(Xmax1,Env,Xb),
                      stepsize=.1,
                      parbnds=c(1,0,20, 0, Xb_index,0,5),
                      parameters=pars,
                      clean=FALSE,
                      options = c('noLP','noBP',
                                  "popEVO", "0",'parEVO','17',
                                  "popEVO", "0",'parEVO','24',
                                  "popEVO", "0",'parEVO','25'))
part1=as.data.frame(BifDD_Ext1$curvepoints)
part2=as.data.frame(BifDD_Ext2$curvepoints)
All=rbind(part2[c(nrow(part2):1),],part1)
All$xxyy = All$`R0_xx` - All$`R0_yy`
All$ESS = ifelse(All$xxyy <= 0, "ERP", ifelse ( All$`R0_yy` <=0, 'CSS', ifelse( All$`R0_yy` >0 & All$xxyy >0, "EBP", "ESS")))
colnames(All) = c("R1max", "R1", "R2", "b[0]","x0",
                  outputnames2, "R0","R0_x[17]","R0_x[24]","R0_x[25]", ESSsingle.names,"rhsnorm","xxyy","ESS")
All$Meta = 0
All$Psi = 1
DirectDataLow = All



###Find Direct Development points####
####Xmin = 0.012 (7.24)#####
Xmin = 0.01491617
index = which.min(abs(XminMedXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 5
Psi = 0
pnt = as.numeric(XminMedXmax2$data[index,])
Xmin = 0.01491617
Env = pnt[c(2:4)]
Meta = 1
Xj = pnt[5]
x0 = pnt[6]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Xj, x0),
                             stepsize=.1,
                             parbnds=c(2,0,20,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24',
                                       "popEVO", "0",'parEVO','25'),
                             clean=TRUE)
BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,20,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24',
                                        "popEVO", "0",'parEVO','25'),
                              clean=TRUE)
c = as.data.frame(BifXmax2_forwards$curvepoints)
a = as.data.frame(BifXmax2_backwards$curvepoints)

pnt = as.numeric(a[nrow(a),])
Init = pnt[c(1:4,6:7)]
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_backwards_P2 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                                 biftype='ESS',
                                 startpoint=Init,
                                 stepsize=-.1,
                                 parbnds=c(2,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24',
                                           "popEVO", "0",'parEVO','25'),
                                 clean=TRUE)
b = as.data.frame(BifXmax2_backwards_P2$curvepoints)
b$Meta =1

BifXmax2_All = rbind(a,c)

##
# 5 is extinc, 7 is extin
# 
Xmax2=3
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=1
Xj=Initpnt[5]
Xb=Initpnt[6]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env,  Xj, Xb),
                    stepsize=-.1,
                    parbnds=c(1,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24',
                              "popEVO", "0",'parEVO','25'),
                    clean=TRUE)
plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))


max(plotdata2$`R0_x[24]`)

Xmax1 = 1.229823	
Env = c(1.055471,	2.721491,	1.152178e-06)
Xj = 0.00713056	
Xb = 0.0012581800
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1_B = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                      biftype='ESS',
                      startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                      stepsize=-.1,
                      parbnds=c(1,0,10,0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                      parameters=pars,
                      options=c("popEVO", "0",'parEVO','24'),
                      clean=TRUE)
View(BifXmax1_B$curvepoints)



####Xmin = 0.07 (5.44)#####
Xmin = 0.07
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)

a = as.data.frame(BifXmax2_backwards$curvepoints)
a$`R0_x[25]`=0
pnt = as.numeric(a[nrow(a),])
Init = pnt[c(1:4,6:7)]
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_backwards_P2 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                                 biftype='ESS',
                                 startpoint=Init,
                                 stepsize=-.1,
                                 parbnds=c(2,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24',
                                           "popEVO", "0",'parEVO','25'),
                                 clean=TRUE)
b = as.data.frame(BifXmax2_backwards_P2$curvepoints)
b$Meta =1

BifXmax2_All = rbind(a,b)

##
#5 5.43 is extionction
# 5.45 6, 7 is DD
Xmax2=5.43 #
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)
plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))



max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.05 (5.05)#####
Xmin = 0.06
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)

a = as.data.frame(BifXmax2_backwards$curvepoints)
a$`R0_x[25]`=0
pnt = as.numeric(a[nrow(a),])
Init = pnt[c(1:4,6:7)]
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_backwards_P2 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                                 biftype='ESS',
                                 startpoint=Init,
                                 stepsize=-.1,
                                 parbnds=c(2,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24',
                                           "popEVO", "0",'parEVO','25'),
                                 clean=TRUE)
b = as.data.frame(BifXmax2_backwards_P2$curvepoints)
b$Meta =1

BifXmax2_All = rbind(a,b)

##
#5  is extionction
# 5.1 6is DD
Xmax2=5 #
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)

BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env,  Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24',
                              "popEVO", "0",'parEVO','25'),
                    clean=TRUE)
plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))


max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.1 (7.24)#####
Xmin = 0.1
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)

a = as.data.frame(BifXmax2_backwards$curvepoints)
a$`R0_x[25]`=0
pnt = as.numeric(a[nrow(a),])
Init = pnt[c(1:4,6:7)]
Meta = 1
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_backwards_P2 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                                 biftype='ESS',
                                 startpoint=Init,
                                 stepsize=-.1,
                                 parbnds=c(2,0,10,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                                 parameters=pars,
                                 options=c("popEVO", "0",'parEVO','24',
                                           "popEVO", "0",'parEVO','25'),
                                 clean=TRUE)
b = as.data.frame(BifXmax2_backwards_P2$curvepoints)
b$Meta =1

BifXmax2_All = rbind(a,b)


#6.6 7 7.2 7.23 is extionction
# 7.25 7.3 7.5 8 is DD
Xmax2=7.23 #6.45 extinction 6.6 DD ###
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)
plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))

max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.15 (11.875)#####
Xmin = 0.15
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)
a = as.data.frame(BifXmax2_backwards$curvepoints)

BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=.1,
                             parbnds=c(2,0,20, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)

BifXmax2_All = rbind(a,b)

##
#extinction 10 11.75
# DD 12
Xmax2=11.75
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,3, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)
plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))

max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.2 (19.85)#####
Xmin = 0.2
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
XminHighXmax2$data[index,]
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,7,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)
a = as.data.frame(BifXmax2_backwards$curvepoints)

BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=1,
                             parbnds=c(2,0,70, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)

BifXmax2_All = rbind(a,b)

##
#extionction 15 18 19.7
#DD 25 20 19.9
Xmax2=19.8
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)


plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))

max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.25 (35.5)#####
Xmin = 0.25
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
XminHighXmax2$data[index,]
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=1,
                             parbnds=c(2,0,70, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)
BifXmax2_All = b
##
#extionction 33 35
#DD 40 37 36 35.5
Xmax2=35.5
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)

plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))

max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.275 (45.5)#####
Xmin = 0.275
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
XminHighXmax2$data[index,]
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)
BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=1,
                             parbnds=c(2,0,70, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)
BifXmax2_All = b
##
#extionction 45
#DD 50 47 46
Xmax2=45.5
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)

plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))



max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.3 (69.05)#####
Xmin = 0.3
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
XminHighXmax2$data[index,]
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_backwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                              biftype='ESS',
                              startpoint=c(Xmax2,Env, Meta,Xj, x0),
                              stepsize=-.1,
                              parbnds=c(2,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                              parameters=pars,
                              options=c("popEVO", "0",'parEVO','24'),
                              clean=TRUE)
a = as.data.frame(BifXmax2_backwards$curvepoints)

BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=1,
                             parbnds=c(2,0,100, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)

BifXmax2_All = rbind(a,b)

##
#60 65 67 68 69 69.5 69.8 is extionction
# 70 is DD 69.9 69.8 69.5 69.3 69.1
Xmax2=69
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-.1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)


plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))
max(plotdata2$`R0_x[24]`)
View(plotdata2)

####Xmin = 0.35 (164.5)#####
Xmin = 0.35
index = which.min(abs(XminHighXmax2$data$xmin - Xmin))
Xmax1 = 3
Xmax2 = 10
Psi = 0
pnt = as.numeric(XminHighXmax2$data[index,])
XminHighXmax2$data[index,]
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
x0 = pnt[7]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, x0,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax2_forwards = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                             biftype='ESS',
                             startpoint=c(Xmax2,Env, Meta,Xj, x0),
                             stepsize=1,
                             parbnds=c(2,0,1000, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                             parameters=pars,
                             options=c("popEVO", "0",'parEVO','24'),
                             clean=TRUE)
b = as.data.frame(BifXmax2_forwards$curvepoints)

BifXmax2_All = b

##
# Extionction:100 150 160 162 163
# DD: 176 170 165 164
Xmax2=164
Xmax1=3
BifIndex = which.min(abs(BifXmax2_All$R2max-Xmax2))
Initpnt = as.numeric(BifXmax2_All[BifIndex,])
BifXmax2_All[BifIndex,]
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
BifXmax1 = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='ESS',
                    startpoint=c(Xmax1,Env, Meta, Xj, Xb),
                    stepsize=-.1,
                    parbnds=c(1,0,10, 0,Meta_index,0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)


plotdata2=as.data.frame(BifXmax1$curvepoints)
BifXmax1$biftypes
plotdata2$ESS = ifelse(plotdata2$`eig J`>0, "ERP", ifelse(plotdata2$`eig H`<0&plotdata2$`eig (J+J')/2`, 'Strong CSS', ifelse(plotdata2$`eig H`<0, 'Weak CSS', ifelse(plotdata2$`Z^T C01 Z`<=0, 'EBP', "?"))))
c=subset(plotdata2,`R0_x[24]`>=0)
ifelse(nrow(c)==0,"Extinction",ifelse(sign(c$`b[0]`[1])==1,"DirectDevelopment",ifelse(sign(c$`b[0]`[1])<0,"Extinction", "Boundary")))


max(plotdata2$`R0_x[24]`)
View(plotdata2)













#####Limit point calculation#####
Xmax1= 5	
Xmax2 = 15
Env =c(0.8699431,	3.832014,	8.199820e-06)
Meta = 0.9990525	
Xj = 0.02487088	
Xb = 0.00932094

DirectData_Metamorphosis=BifXmax1_backwardsHigh
Xmax2=15
Xmax1=5
Xmin=0.1
BifIndex = which.min(abs(DirectData_Metamorphosis$data$R1max-Xmax1))
Initpnt = as.numeric(DirectData_Metamorphosis$data[BifIndex,])
psi=0
Meta=Initpnt[5]
Xj=Initpnt[6]
Xb=Initpnt[7]
Meta_ESS = Initpnt[5]
Xj_ESS = Initpnt[6]
Xb_ESS = Initpnt[7]
Psi_ESS = 0
Xmax1=Initpnt[1]

Env = Initpnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)


EvoDyn=PSPMevodyn(modelname="Loss_of_Meta_pspmnew", 
                  startpoint=c(Env, psi,Meta,Xj, Xb), 
                  curvepars=c(1,1000),
                  evopars=c(0,Psi_index, 0, 1, 0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1),
                  covars = c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                  parameters = pars,
                  options=NULL,
                  clean=TRUE)

alldata=as.data.frame(EvoDyn$curvepoints)
alldata$run=0

for (i in 1:500) {
  dat=as.data.frame(EvoDyn$curvepoints)
  pnt =as.numeric(dat[nrow(dat),c(2:8),])
  psi = min(1,max(0,pnt[4]))
  Meta = min(1,max(0,pnt[5]))
  Xj=pnt[6]
  Xb = pnt[7]
  pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
           Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
           m2,k1,k2, Xb,Xmin, Xj, Xf,
           Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho,Mu_H1)
  bpxm2 =4
  bpxm1 = 1.2
  f = 1
  if (f==1){
    #Find BP
    BPfind<-PSPMequi(modelname="Loss_of_Meta_pspmnew",
                     biftype="EQ",
                     startpoint=c(bpxm2,Xmax1,bpxm2),
                     stepsize=-.1,
                     parbnds=c(2,0.9,8),
                     parameters=pars,
                     options=c("popZE", "0"),
                     clean=TRUE,
                     force=FALSE)
    bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
    Nontriv2 <- PSPMequi(modelname="Loss_of_Meta_pspmnew",
                         biftype='EQ',
                         startpoint=c(bound.point, 0),
                         stepsize=.1,
                         parbnds=c(2, 0.0, Xmax2+10),
                         parameters=pars,
                         clean=TRUE)
    Init_point = as.numeric(Nontriv2$curvepoints[nrow(Nontriv2$curvepoints), c(2:4)])
    a=as.data.frame(Nontriv2$curvepoints)
    Index = which.min(abs(a$R2max-Xmax2))
    Init_point=as.numeric(a[Index,c(2:4)])
    
    Lpindex1=which.min(abs(a$R2max-as.numeric(Nontriv2$bifpoints[1,1])))
    Lpindex2=which.min(abs(a$R2max-as.numeric(Nontriv2$bifpoints[2,1])))
    part1=a[1:Lpindex1,]
    part2=a[Lpindex2:nrow(a),]
    if(i%%2 ==0){
      Index = which.min(abs(part1$R2max-Xmax2))
      Init_point=as.numeric(part1[Index,c(2:4)])
    }else {
      Index = which.min(abs(part2$R2max-Xmax2))
      Init_point=as.numeric(part2[Index,c(2:4)])
    }
  } else{
    BPfind<-PSPMequi(modelname="Loss_of_Meta_pspmnew",
                     biftype="EQ",
                     startpoint=c(bpxm1,bpxm1,Xmax2),
                     stepsize=-.01,
                     parbnds=c(1,0.7,8),
                     parameters=pars,
                     options=c("popZE", "0"),
                     clean=TRUE,
                     force=FALSE)
    bound.point <- as.numeric(BPfind$bifpoints[BPfind$biftypes == "BP #0"])[c(1:3)]
    Nontriv2 <- PSPMequi(modelname="Loss_of_Meta_pspmnew",
                         biftype='EQ',
                         startpoint=c(bound.point, 0),
                         stepsize=.1,
                         parbnds=c(1, 0.0, Xmax1+2),
                         parameters=pars,
                         clean=TRUE)
    a=as.data.frame(Nontriv2$curvepoints)
    Lpindex1=which.min(abs(a$R1max-as.numeric(Nontriv2$bifpoints[1,1])))
    Lpindex2=which.min(abs(a$R1max-as.numeric(Nontriv2$bifpoints[2,1])))
    part1=a[1:Lpindex1,]
    part2=a[Lpindex2:nrow(a),]
    if(i%%2 ==1){
      Index = which.min(abs(part1$R1max-Xmax1))
      Init_point=as.numeric(part1[Index,c(2:4)])
    }else {
      Index = which.min(abs(part2$R1max-Xmax1))
      Init_point=as.numeric(part2[Index,c(2:4)])
    }
  }
  dir=1
  EvoDyn = PSPMevodyn(modelname="Loss_of_Meta_pspmnew", 
                      startpoint=c(Init_point, psi,Meta,Xj, Xb), 
                      curvepars=c(0.1,1000000),
                      evopars=c(0,Psi_index, 0, 1, 0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1),
                      covars = c(1*dir,0,0,0,0,dir*1,0,0,0,0,dir*1,0,0,0,0,dir*1),
                      parameters = pars,
                      options=NULL,
                      clean=TRUE,
                      force=FALSE)
  data=as.data.frame(EvoDyn$curvepoints)
  data$Evol.time=data$Evol.time+max(alldata$Evol.time)
  data$run= i
  alldata=rbind(alldata,data)
  print(i)
  
  if(i%%100==0){
    saveRDS(alldata,"backupcanonical.rds")
  }
}

All_Evo=alldata
All_Evo[All_Evo$Meta>1,]$Meta = 1
All_Evo[All_Evo$PSI<0,]$PSI = 0



######Mortality calculations#####
###High Xmax2 en High Xmax1 bifurcation#####
DirectData_Metamorphosis=BifXmax1_backwardsHigh
Direct_Meta = subset(DirectData_Metamorphosis$data, `R0_x[24]`<=0)

Xmax1=3.00000000E+00
Xmin = 0.1
Xmax2=15
index = which.min(abs(Direct_Meta$R1max - Xmax1))
pnt = as.numeric(Direct_Meta[index,])
psi = 0
Meta = 	pnt[5]
Xj = pnt[6]
Xb =  pnt[7]
MuH1 = 0
Env = pnt[c(2:4)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, MuH1)
NoEvoBif = PSPMequi(modelname="Loss_of_Meta_pspmnew",
                    biftype='EQ',
                    startpoint=c(MuH1,Env),
                    stepsize=.1,
                    parbnds=c(27,0,1),
                    parameters=pars,
                    options=c("popEVO", "0"),
                    clean=TRUE)
NoEvoBifData=as.data.frame(NoEvoBif$curvepoints)
colnames(NoEvoBifData) = c("Mu_H1", Env.names, outputnames2, "R0", "R0_x[mu1]",
                           'rhsnorm')

BifMort1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                    biftype='ESS',
                    startpoint=c(MuH1,Env, Meta, Xj, Xb),
                    stepsize=.1,
                    parbnds=c(27,0,1,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)

info_HighHigh=BifMort1$curvedesc
BifMort_HighHigh_P1 = as.data.frame(BifMort1$curvepoints)
colnames(BifMort_HighHigh_P1) = c("Mu_H1", Env.names,"Meta","Xj", "Xb", outputnames2, "R0", "R0_x[psi]",
                                  ESS_multiplenames)

BifMort_HighHigh_P1$`R0_x[15]` = 0
Xb = Xbmin
pnt = as.numeric(BifMort_HighHigh_P1[nrow(BifMort_HighHigh_P1),])
Init = pnt[c(1:6)]
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, MuH1)
BifMort1_P2 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                       biftype='ESS',
                       startpoint=Init,
                       stepsize=.1,
                       parbnds=c(27,0,1,0,Meta_index,0,1, 0,Xj_index,Xjmin,5),
                       parameters=pars,
                       options=c("popEVO", "0",'parEVO','15',
                                 "popEVO", "0",'parEVO','24'),
                       clean=TRUE)

BifMort_HighHigh_P2 = as.data.frame(BifMort1_P2$curvepoints)
colnames(BifMort_HighHigh_P2) = c("Mu_H1", Env.names,"Meta","Xj", outputnames2, "R0", "R0_x[15]","R0_x[psi]",
                                  ESS_multiplenames)
BifMort_HighHigh_P2$Xb = Xbmin
BifMort_HighHigh = rbind(BifMort_HighHigh_P1,BifMort_HighHigh_P2)
BifMort_HighHigh$ESS = ifelse(BifMort_HighHigh$`eig J`>0, "ERP", ifelse(BifMort_HighHigh$`eig H`<0&BifMort_HighHigh$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_HighHigh$`eig H`<0, 'Weak CSS', ifelse(BifMort_HighHigh$ZC01Z<=0, 'EBP', "?"))))


max(BifMort_HighHigh$`R0_x[psi]`)
BifMort_HighHigh$Psi = 0


HighHigh = list(BifMort_HighHigh=BifMort_HighHigh, NoEvoBifData=NoEvoBifData,info=info_HighHigh,
                remark="High productivities, no direct development")


###High Xmax2 en Low Xmax1, Metamorphosis bifurcation#####
DirectData_Metamorphosis=BifXmax1_backwardsHigh
Direct_Meta = subset(DirectData_Metamorphosis$data, `R0_x[24]`<=0)

Xmin = 0.1
Xmax1=1.181818
Xmax2=15
psi = 0
MuH1 = 0
Xmin = 0.1
Xmax2=15
index = which.min(abs(Direct_Meta$R1max - Xmax1))
pnt = as.numeric(Direct_Meta[index,])
psi = 0
Meta = 	pnt[5]
Xj = pnt[6]
Xb =  pnt[7]
MuH1 = 0
Env = pnt[c(2:4)]

pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, MuH1)
BifMort1Eco = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                       biftype='EQ',
                       startpoint=c(MuH1,Env),
                       stepsize=0.1,
                       parbnds=c(27,0,1),
                       parameters=pars,
                       options=c("popEVO", "0"),
                       clean=TRUE)

NoEvoBifData=as.data.frame(BifMort1Eco$curvepoints)
colnames(NoEvoBifData) = c("Mu_H1", Env.names, outputnames2, "R0", "R0_x[mu1]",
                           'rhsnorm')
BifMort1_P1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                       biftype='ESS',
                       startpoint=c(MuH1,Env, Meta, Xj, Xb),
                       stepsize=0.1,
                       parbnds=c(27,0,1,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                       parameters=pars,
                       options=c("popEVO", "0",'parEVO','24'),
                       clean=TRUE)

info_LowHigh=BifMort1_P1$curvedesc
BifMort_LowHigh = as.data.frame(BifMort1_P1$curvepoints)
colnames(BifMort_LowHigh) = c("Mu_H1", Env.names,"Meta","Xj", "Xb", outputnames2, "R0", "R0_x[psi]",
                              ESS_multiplenames)

BifMort_LowHigh$ESS = ifelse(BifMort_LowHigh$`eig J`>0, "ERP", ifelse(BifMort_LowHigh$`eig H`<0&BifMort_LowHigh$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_LowHigh$`eig H`<0, 'Weak CSS', ifelse(BifMort_LowHigh$ZC01Z<=0, 'EBP', "?"))))
index = which.min(abs(BifMort_LowHigh$`R0_x[psi]`))+1

BifMort_LowHigh= BifMort_LowHigh[c(1:index),]


pnt = as.numeric(BifMort_LowHigh[nrow(BifMort_LowHigh),c(2:7)])
MuH1= as.numeric(BifMort_LowHigh[nrow(BifMort_LowHigh),1])
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, MuH1)
EvoDyn_LowHigh = PSPMevodyn(modelname="Loss_of_Meta_pspmnew2", 
                            startpoint=c(pnt,psi), 
                            curvepars=c(10,300000000),
                            evopars=c(0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1,0,Psi_index, 0, 1),
                            covars = NULL,#c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                            parameters = pars,
                            options=NULL,
                            clean=TRUE)


EvoRun_LowHighInfo = EvoDyn_LowHigh$curvedesc
EvoRun_LowHigh  = as.data.frame(EvoDyn_LowHigh$curvepoints)
colnames(EvoRun_LowHigh ) = c("Evol.time", Env.names,  "Meta", "Xj", "Xb", "Psi",
                              outputnames2, "R0", "Rhsnorm")
pnt = c(8.96455783E-01, 7.15907268E+00, 8.67255873E-07, 8.19540541E-01, 1.24339971E-02, 7.66275396E-02, 2.02460783E-04)
EvoDyn_LowHigh2 = PSPMevodyn(modelname="Loss_of_Meta_pspmnew2", 
                             startpoint=pnt, 
                             curvepars=c(100,300000000),
                             evopars=c(0, Meta_index, 0 , 1, 0, Xj_index, Xjmin, 5, 0, Xb_index, Xbmin, 1,0,Psi_index, 0, 1),
                             covars = NULL,#c(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),
                             parameters = pars,
                             options=NULL,
                             clean=TRUE)


EvoDyn_LowHighP2 = as.data.frame(EvoDyn_LowHigh2$curvepoints)
colnames(EvoDyn_LowHighP2) = c("Evol.time", Env.names,  "Meta", "Xj", "Xb", "Psi",
                               outputnames2, "R0", "Rhsnorm")
EvoDyn_LowHighP2$Evol.time2 = EvoDyn_LowHighP2$Evol.time + max(EvoRun_LowHigh$Evol.time)
EvoRun_LowHigh$Evol.time2 = EvoRun_LowHigh$Evol.time

EvoDyn_LowHighAll = rbind(EvoRun_LowHigh,EvoDyn_LowHighP2)


LowHigh = list(Bif=BifMort_LowHigh,BifInfo = info_LowHigh,Canonical=EvoDyn_LowHighAll,Canonicalinfo=
                 EvoRun_LowHighInfo, remark="High Xmax2, low Xmax1 leads to direct development")
LowHigh$NoEvo = NoEvoBifData

###High Xmax2 en Low Xmax1, DD bifurcation#####
DirectData_DirectDevelopment = DirectDataHigh
Direct_Direct = subset(DirectData_DirectDevelopment$data, `R0_x[24]`>=0)
Xmin = 0.1
Xmax1=1.181818
Xmax2=15
psi = 1
Meta = 0
MuH1 = 0
index = which.min(abs(Direct_Direct$R1max-Xmax1))
pnt = as.numeric(Direct_Direct[index,])
Env = pnt[c(2:4)]
Xb = pnt[5]
Mu_H1 = 0
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,psi,Meta,Rho, Mu_H1)
BifDD1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                  biftype='ESS',
                  startpoint = c(Mu_H1,Env,Xb),
                  stepsize=.1,
                  parbnds=c(27,0,1, 0, Xb_index,0,5),
                  parameters=pars,
                  clean=FALSE,
                  options = c('noLP','noBP',
                              "popEVO", "0",'parEVO','17',
                              "popEVO", "0",'parEVO','24',
                              "popEVO", "0",'parEVO','25'))
All = as.data.frame(BifDD1$curvepoints)
colnames(All) = c("R1max", "R1", "R2", "b[0]","x0",
                  outputnames2, "R0","R0_x[17]","R0_x[24]","R0_x[25]", ESSsingle.names,"rhsnorm")
All$xxyy = All$`R0_xx` - All$`R0_yy`
All$ESS = ifelse(All$xxyy <= 0, "ERP", ifelse ( All$`R0_yy` <=0, 'CSS', ifelse( All$`R0_yy` >0 & All$xxyy >0, "EBP", "ESS")))

All$Meta = 0
All$Psi = 1
DirectDataHighMort = list(data=All, info = BifDD1$curvedesc)

###High Xmax2 en low Xmax1, ERP bifurcation####
index = which.min(abs(LowHigh$Bif$`R0_x[psi]`))
pnt = as.numeric(LowHigh$Bif[index,])
Mu_H1 = pnt[1]-0.000001
Env = pnt[c(2:4)]
Meta = pnt[5]
Xj = pnt[6]
Xb = pnt[7]
Xmin = 0.1
Xmax1=1.181818
Xmax2=15
Psi = 0
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, Mu_H1)

BifXmax1_ERP_P1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                           biftype='ESS',
                           startpoint=c(Mu_H1,Env, Xb, Psi, Meta,Xj),
                           stepsize=-.001,
                           parbnds=c(27,0,1, 0,Xb_index,Xbmin,5, 0, Psi_index,0,1,
                                     0,Meta_index,0,1,0,Xj_index,0,1),
                           options=c("noLP", "noBP"),
                           parameters=pars,
                           clean=TRUE)





#
###Low Xmax2 en High Xmax1 bifurcation#####
BifXmax1_backwardsLow$data$Psi = 0
Ext_Meta = subset(BifXmax1_backwardsLow$data, `b[0]`>0)
Xmax2 = 6
Xmax1 = 3
index = which.min(abs(Ext_Meta$R1max-Xmax1))
pnt = as.numeric(Ext_Meta[index,])
Env = pnt[c(2:4)]
Meta = 1
Xj = pnt[6]
Xb = pnt[7]
Psi = 0
MuH1 = 0
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, MuH1)
BifMortNoEvo = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                        biftype='EQ',
                        startpoint=c(MuH1,Env),
                        stepsize=.1,
                        parbnds=c(27, 0,1),
                        parameters=pars,
                        options=c("popEVO", "0"),
                        clean=TRUE)

NoEvoBifData=as.data.frame(BifMortNoEvo$curvepoints)
colnames(NoEvoBifData) = c("Mu_H1", Env.names, outputnames2, "R0", "R0_x[mu1]",
                           'rhsnorm')

BifMort1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                    biftype='ESS',
                    startpoint=c(MuH1,Env, Xj, Xb),
                    stepsize=.1,
                    parbnds=c(27, 0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24',
                              "popEVO","0",'parEVO','25'),
                    clean=TRUE)

info_LowHigh=BifMort1$curvedesc
BifMort_LowHigh = as.data.frame(BifMort1$curvepoints)
colnames(BifMort_LowHigh) = c("Mu_H1", Env.names,"Xj", "Xb", outputnames2, "R0", "R0_x[psi]","R0_x[meta]",
                              ESS_multiplenames)
BifMort_LowHigh$ESS = ifelse(BifMort_LowHigh$`eig J`>0, "ERP", ifelse(BifMort_LowHigh$`eig H`<0&BifMort_LowHigh$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_LowHigh$`eig H`<0, 'Weak CSS', ifelse(BifMort_LowHigh$ZC01Z<=0, 'EBP', "?"))))
index = which.min(abs(BifMort_LowHigh$`R0_x[meta]`))
BifMort_LowHigh=BifMort_LowHigh[c(1:index),]
BifMort_LowHigh$Meta = 1
BifMort_LowHigh$Psi = 0
pnt = as.numeric(BifMort_LowHigh[nrow(BifMort_LowHigh),c(1:6)])
BifMort2 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                    biftype='ESS',
                    startpoint=c(pnt,Meta),
                    stepsize=.1,
                    parbnds=c(27, 0,1,0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5,0,Meta_index,0,1),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)
BifMort_LowHigh2 = as.data.frame(BifMort2$curvepoints)
colnames(BifMort_LowHigh2) = c("Mu_H1", Env.names,"Xj", "Xb","Meta", outputnames2, "R0", "R0_x[psi]",
                               ESS_multiplenames)
BifMort_LowHigh2$ESS = ifelse(BifMort_LowHigh2$`eig J`>0, "ERP", ifelse(BifMort_LowHigh2$`eig H`<0&BifMort_LowHigh2$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_LowHigh2$`eig H`<0, 'Weak CSS', ifelse(BifMort_LowHigh2$ZC01Z<=0, 'EBP', "?"))))
BifMort_LowHigh2$Psi = 0

Xb=Xbmin
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, MuH1)
pnt = as.numeric(BifMort_LowHigh2[nrow(BifMort_LowHigh2),])
Init = pnt[c(1:5,7)]
BifMort3 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                    biftype='ESS',
                    startpoint=Init,
                    stepsize=.1,
                    parbnds=c(27, 0,1,0,Xj_index,Xjmin,5,0,Meta_index,0,1),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','15',
                              "popEVO", "0",'parEVO','24'),
                    clean=TRUE)
BifMort_LowHigh3 = as.data.frame(BifMort3$curvepoints)
colnames(BifMort_LowHigh3) = c("Mu_H1", Env.names,"Xj", "Meta", outputnames2, "R0", "R0_x[15]","R0_x[psi]",
                               ESS_multiplenames)
BifMort_LowHigh3$ESS = ifelse(BifMort_LowHigh3$`eig J`>0, "ERP", ifelse(BifMort_LowHigh3$`eig H`<0&BifMort_LowHigh3$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_LowHigh3$`eig H`<0, 'Weak CSS', ifelse(BifMort_LowHigh3$ZC01Z<=0, 'EBP', "?"))))
BifMort_LowHigh3$Psi = 0
BifMort_LowHigh3$Xb = Xbmin
BifMort_LowHigh2$`R0_x[15]`=0
BifMort_LowHigh2$Psi = 0
BifMort_LowHigh$`R0_x[15]`=0
BifMort_LowHigh$Meta = 1  
BifMort_LowHigh3$`R0_x[meta]`=0
BifMort_LowHigh2$`R0_x[meta]`=0
BifMort_LowHigh2$`R0_[15]`=0
BifMort_LowHigh3$`R0_[15]`=0


BifMort_LowHighAll = rbind(BifMort_LowHigh,BifMort_LowHigh2,BifMort_LowHigh3)

LowHigh = list(ecodata = NoEvoBifData,BifMort_LowHigh=BifMort_LowHighAll, info=info_LowHigh,remark="High productivities, no direct development")




####Low Xmax2 en Low Xmax1 bifurcation####
BifXmax1_backwardsLow$data$Psi = 0
Ext_Meta = subset(BifXmax1_backwardsLow$data, `b[0]`>0)
Xmax2 = 6
Xmax1=1.181818
index = which.min(abs(Ext_Meta$R1max-Xmax1))
pnt = as.numeric(Ext_Meta[index,])
Env = pnt[c(2:4)]
Meta =pnt[5]
Xj = pnt[6]
Xb = pnt[7]
Psi = 0
MuH1 = 0
pars = c(Delta, Xmax1, Xmax2, Amin,Amax,
         Alpha, W0, chi1 ,chi2,chi3, chi4,m1,
         m2,k1,k2, Xb,Xmin, Xj, Xf,
         Qj,Qa,Qs,mu0,Sigma,Psi,Meta,Rho, MuH1)

BifMortNoEvo = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                        biftype='EQ',
                        startpoint=c(MuH1,Env),
                        stepsize=.1,
                        parbnds=c(27, 0,1),
                        parameters=pars,
                        options=c("popEVO", "0"),
                        clean=TRUE)

NoEvoBifData=as.data.frame(BifMortNoEvo$curvepoints)
colnames(NoEvoBifData) = c("Mu_H1", Env.names, outputnames2, "R0", "R0_x[mu1]",
                           'rhsnorm')

BifMort1 = PSPMequi(modelname="Loss_of_Meta_pspmnew2",
                    biftype='ESS',
                    startpoint=c(MuH1,Env, Meta, Xj, Xb),
                    stepsize=.1,
                    parbnds=c(27,0,1,0,Meta_index,0,1, 0,Xj_index,Xjmin,5, 0,Xb_index,Xbmin,5),
                    parameters=pars,
                    options=c("popEVO", "0",'parEVO','24'),
                    clean=TRUE)
info_LowLow=BifMort1$curvedesc
BifMort_LowLow = as.data.frame(BifMort1$curvepoints)
colnames(BifMort_LowLow) = c("Mu_H1", Env.names,"Meta","Xj", "Xb", outputnames2, "R0", "R0_x[psi]",
                             ESS_multiplenames)
BifMort_LowLow$ESS = ifelse(BifMort_LowLow$`eig J`>0, "ERP", ifelse(BifMort_LowLow$`eig H`<0&BifMort_LowLow$`eig (J+J)/2`<0, 'Strong CSS', ifelse(BifMort_LowLow$`eig H`<0, 'Weak CSS', ifelse(BifMort_LowLow$ZC01Z<=0, 'EBP', "?"))))

LowLow = list(ecodata=NoEvoBifData,BifMort_LowLow=BifMort_LowLow, info=info_LowLow,remark="Low productivities, no direct development")
BifMort_LowLow=LowLow


