les_ele <- function(fitted_data,timeseries_data,year){
  
  ## Current year 
  crr_year = year
  fyear = fitted_data[which(fitted_data$year == crr_year),]
  
  #########################
  ## PROJECTION MATRIX A ##
  #########################
  
  ## BUILD A LESLIE MATRIX UNDER THE FORMATION OF CASWELL, 2001 (2.9) 
  lm = matrix(nrow = nrow(fyear), ncol = nrow(fyear), 0)
  delta = row(lm) - col(lm)
  
  lm[1,] = fyear$Fert
  capsurv = length(fyear$Surv)
  lm[delta == 1] = fyear$Surv[1:capsurv-1]
  
  ############################
  ## NT0 from starting year ##
  ############################
  # Population composition at starting year
  
  ages = unique(fyear$age)
  n_t0 = vector()
  for(i in 1:length(ages)){
    crr = ages[i]
    n_t0[i] = nrow(timeseries_data[which(timeseries_data$year == crr_year & timeseries_data$age == crr),]) 
  }
  
  return(list("projection_matrix" = lm, "NT0" = n_t0))
}