(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[  11043866,     202435]
NotebookOptionsPosition[  10965416,     200254]
NotebookOutlinePosition[  10966135,     200281]
CellTagsIndexPosition[  10966092,     200278]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Supplementary Material: 
\[OpenCurlyDoubleQuote]On the Evolutionary Epidemiology of SARS-CoV-2\
\[CloseCurlyDoubleQuote]\
\>", "Section",
 CellChangeTimes->{{3.795801232488412*^9, 3.79580126677142*^9}, {
   3.7967964476943555`*^9, 3.796796457945162*^9}, {3.796797102192574*^9, 
   3.7967971060361404`*^9}, 3.798657261258766*^9, 3.798930804814332*^9, {
   3.800536542492093*^9, 3.800536551152404*^9}, {3.800536599824469*^9, 
   3.800536605851945*^9}},
 ExpressionUUID -> "2e673ad4-cb43-433e-be56-4b7b2c2a8546"],

Cell[CellGroupData[{

Cell["\<\
Troy Day, Sylvain Gandon, S\[EAcute]bastien Lion, & Sarah P. Otto
June 5, 2020\
\>", "Subsubtitle",
 CellChangeTimes->{{3.7958012406250057`*^9, 3.795801253831758*^9}, {
   3.798657267440051*^9, 3.798657269810342*^9}, {3.800187881742947*^9, 
   3.800187883872279*^9}, 3.800536610494759*^9},
 ExpressionUUID -> "6a21b806-9261-4964-9ae1-ef05d5fded13"],

Cell[CellGroupData[{

Cell["\<\
Analysis of model with genetic variation (wildtype and mutant subtypes)\
\>", "Subsection",
 CellChangeTimes->{{3.795095233478459*^9, 3.795095252380425*^9}, {
   3.795095705087064*^9, 3.79509571745501*^9}, 3.7953724288054857`*^9, 
   3.795387287969595*^9, {3.7953942222970753`*^9, 3.795394224461396*^9}, {
   3.795395422249237*^9, 3.795395423753776*^9}, {3.7953961378459873`*^9, 
   3.7953961699895897`*^9}, {3.7953990683074923`*^9, 3.795399068517149*^9}, {
   3.795801282245741*^9, 3.7958012858543663`*^9}, {3.795801504341165*^9, 
   3.7958015165736113`*^9}},ExpressionUUID->"66b82597-ab4c-47c3-b037-\
0a970e181c5e"],

Cell["Based on Figure 2:", "Text",
 CellChangeTimes->{{3.7958013077905188`*^9, 3.7958013192887077`*^9}, 
   3.798925219930007*^9},
 ExpressionUUID -> "ee2e98f5-f62b-4a4b-8a46-53649211f564"],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.0010416666666666667`], 
   {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 0.}, {959.76, 
     0.}, {959.76, 540.}, {0., 540.}}}]}, 
   {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 0.}, {960., 
     0.}, {960., 540.}, {0., 540.}}}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
     0}, {0, 1, 0}}}, {{{366.13849999999996`, 283.1537}, {400.6621, 
     283.1537}, {400.6621, 277.6537}, {366.13849999999996`, 277.6537}}, {{
     400.6621, 280.40369999999996`}, {389.66220000000004`, 294.1537}, {
     417.1621, 280.4036}, {389.6621, 266.6537}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.9411765], Opacity[0.4]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     154.13389999999998`, 280.4009}, {154.13389999999998`, 302.1227}, {
     171.7429, 319.73169999999993`}, {193.4646, 319.73169999999993`}, {
     215.18640000000002`, 319.73169999999993`}, {232.7953, 302.1227}, {
     232.7953, 280.4009}, {232.7953, 258.67920000000004`}, {
     215.18640000000002`, 241.0702}, {193.4646, 241.0702}, {171.7429, 
     241.0702}, {154.13389999999998`, 258.67920000000004`}, {
     154.13389999999998`, 280.4009}}}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxllF1Ik1EYx7WwcGXpAsNAwixDbVZbRA7EE31oopSuiIIxsdy7ZdP3fRNJ
jYxu9MJKjMq0cDEUmRmhF+kgEvr0oxC9GNonDGfZvDEwW6Rt5//oy/DiXPx4
/s/nec5JKCorKF4dFhYWHjhFgbMqcObWmJpyNQKTMlRuxyeRLXFmAKP7RZas
bxyq0QtsndshvneKrME+v9d7UmDjDjFj4gHpy8D+myIz2l4vzN4Dq+pE9nIs
tXj8g8Jcv8ESwrsY2NkAfeV58PQj2H11Fp4/owf5k1osvN5zQwoH7cbpUH44
j/q33gVrIiRen7oeHBUtIf918MwW4kvIf3YH6U3IZ9gt8fr+5ECflw77rAb8
/LDE8y2uhd6RL/F62icF1hZo97SR7O8wb48F+dZ3Yz455Ygf14L5P62BfbgO
/kI94iVV4z5szRTfBnttB9hrBmf1KhzUdw0ozPubRP0F5WDXP+r/Ft23WgY7
Ue+vnTL3PzoCe94BGfcVjnlNHIL+sdaCeo/LPL5cQvM/BftwZyjnuhUO6hsX
4f/MILOUwLxat1t5/METsI8es3L95zz4+2Qrn9e3bOJWK6937CC4/jL8VVPo
t1u3kvm+/wXLaVae/60K+WYTkU8TS/3EIf7tBNRnUsG/Pxnz6JvD/fekgdM9
mI9LB3/tAO3zfsyzvSOUvdcU5vmN8NdraX6ZiK9LIf8EC8/PtkHfrYL+wmby
99M+RVL+n9iP39RvgQd2u09hvi8fQzlqEPtZ6cO+NLuwT28WsB+GLnovMfS+
7LTP+1BfYQN4XKD3cxV8/w7tSynF74V+TyHxCP0PBgn78B39J2Yhv9kPHkun
9xKB+3Wloh5tDO6rJ572Pxb3aYtSOJh/yi8uM+/nC/1PkYjnf4X/qW+G9v0J
7BdH6X6b8N987UT99lr8h+oq9HujmvTZ0FeVkX4j9KKV7CPCMgftpjaF+X1W
YN66EvrvjtD7LUV9ZzZBz2SK7zXjPVVQ/S/MvJ74K8g3/MO84v9f4v8h6tJc

     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
     0}, {0, 1, 0}}}, {{{232.12630000000001`, 283.1537}, {266.64990000000006`,
      283.1537}, {266.64990000000006`, 277.6537}, {232.12630000000001`, 
     277.6537}}, {{266.64990000000006`, 280.40369999999996`}, {
     255.64989999999997`, 294.1537}, {283.14990000000006`, 280.4036}, {
     255.64989999999997`, 266.6537}}}]}, 
   {FaceForm[{RGBColor[0.5254902, 0.11372550000000002`, 0.], Opacity[0.702]}],
     FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     558.6628999999999, 282.7758}, {558.6628999999999, 304.4976}, {
     576.2719000000001, 322.1065}, {597.9936, 322.1065}, {619.7154, 
     322.1065}, {637.3243, 304.4976}, {637.3243, 282.7758}, {637.3243, 
     261.0541}, {619.7154, 243.4451}, {597.9936, 243.4451}, {
     576.2719000000001, 243.4451}, {558.6628999999999, 261.0541}, {
     558.6628999999999, 282.7758}}}]}, 
   {FaceForm[{RGBColor[1., 0.7529412000000001, 0.], Opacity[0.4]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     490.8481, 148.52240000000003`}, {490.8481, 170.24419999999998`}, {
     508.45709999999997`, 187.85320000000002`}, {530.1788000000001, 
     187.85320000000002`}, {551.9005, 187.85320000000002`}, {569.5095, 
     170.24419999999998`}, {569.5095, 148.52240000000003`}, {569.5095, 
     126.80069999999999`}, {551.9005, 109.1917}, {530.1788000000001, 
     109.1917}, {508.45709999999997`, 109.1917}, {490.8481, 
     126.80069999999999`}, {490.8481, 148.52240000000003`}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     697.9410999999999, 278.2489}, {697.9410999999999, 299.97069999999997`}, {
     715.55, 317.5796}, {737.2718000000001, 317.5796}, {758.9935, 317.5796}, {
     776.6025, 299.97069999999997`}, {776.6025, 278.2489}, {776.6025, 
     256.5272}, {758.9935, 238.9182}, {737.2718000000001, 238.9182}, {715.55, 
     238.9182}, {697.9410999999999, 256.5272}, {697.9410999999999, 
     278.2489}}}]}, 
   {FaceForm[{RGBColor[1., 0.7960784, 0.7411764999999999], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     288.7349, 280.4009}, {288.7349, 302.1227}, {306.34380000000004`, 
     319.73169999999993`}, {328.0656, 319.73169999999993`}, {
     349.78729999999996`, 319.73169999999993`}, {367.39629999999994`, 
     302.1227}, {367.39629999999994`, 280.4009}, {367.39629999999994`, 
     258.67920000000004`}, {349.78729999999996`, 241.0702}, {328.0656, 
     241.0702}, {306.34380000000004`, 241.0702}, {288.7349, 
     258.67920000000004`}, {288.7349, 280.4009}}}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxllFloE1EYhVODitMWlVbrBkkpbWnEIEYqkUavCBXBYmmVUpcHBRGk4mRm
og8uqKFVkGowLmAUquNuHoZU4xZR8tBoRFxGG0dbsSgWU5RCCoJRcOaeq5fa
h3n4OOee///vMuWbdzRtsdtstgLzW21+48zvxKH2dbm1AWKook9olsjje3c6
L/sYD/pJ/tvQI+/ssbxUyKhiHvx1ZoBcMuWUIFFeWRYghaZcPA18rRT6VodE
rHrBqdD3VqFebzHyGl3w1wjwL3JLJGXqPePhfzZfIu5yx0jUFiB+n5ApWYC8
cF6h+nYPePmIQvudtRD+RJazldexk7NVr7UBLOz2U336cc7W+jkq501rmqqd
mkLr6/sY31UwXwfjJPw/O7G+6KlC59t/BvlfdKbfwP4ZOc6Wv+418uVqcFt8
LFv1Br3sPG6x+ev9dH49Bn1iA/NrqN/VDO6Lol66Bf6Kq8gPtkLfoyLPtx66
PcL2awP6jx/lTP31nK35X8xAXviYSPt7cpCzlfcpxNnKm3AW/f4IQfdcRP0H
YbAchX76FPy1N1HPFRFR/z70XedF3KckOHMF/qo05tc0+Nteor49gfzut8jb
lhJp/2SAnW8v9JIhrCdZzFPD7utf9n6HXxXZfDF5FOtxmea/O4D60Ycy7W9F
EPUae2SaF2qHnkhDv30YXPcc+vAR8K9XMt2fjSHGb8C/TyJvigE+FwF/fI9+
ghfY/B+Qp10HFw3A3x9Dv7nPbH0S651ZVt+Av6+S7VcW92/SXHZ+BRL1d83D
fg2Xcrb0lorRuujG+zNc7Dxr8V5XVbL7uBjvWXfgPvQvwXpnGXuPy6B7CjnT
+zRZ+fc/+///9gcwhjyI
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
     0}, {0, 1, 0}}}, {{{637.0661999999999, 283.2102}, {671.5898000000001, 
     283.2102}, {671.5898000000001, 277.7102}, {637.0661999999999, 
     277.71029999999996`}}, {{671.5898000000001, 280.4602}, {
     660.5899000000001, 294.2102}, {688.0898000000001, 280.4602}, {
     660.5898000000001, 266.7102}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
     0}, {0, 1, 0}}}, {{{500.25780000000003`, 283.4966999999999}, {534.7815, 
     283.49659999999994`}, {534.7815, 277.99659999999994`}, {
     500.25780000000003`, 277.9966999999999}}, {{534.7815, 280.7466}, {
     523.7815, 294.49659999999994`}, {551.2815, 280.7466}, {523.7814000000001,
      266.99659999999994`}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJwtlAtYTHkYxlNCrt3k0oYoiu5yqV3mzaUssa2wNpceNWfuM3SZM2fmzNQW
LTJSETaxUVOuqbCSFVJa2thNuaxbqBDRhWzbxv7PjvM885zne54z/+/7v7/v
fR0j1i+lTE1MTNaSH/e2Wul3+rdkJUJ3O6Yodyhwx7oj4GaBEtd9Koo87BS4
+uDMJu1tJXpHxtyxzpLDIzX7b+8+NB5HJac0jpfDuXHjgRoPGpL1bUnXjspQ
ucNb5R5OY/fcbbLnU2VwaR1S5pVOY9W4gPbIMilKJw0bdKaKxiWdw0zhQik6
CkOkmZ9oWBsuXB5xVwLed6uKLvqpsGKoe/F+oQSWL8+eNKNVSCXHOnaL4Rmc
NzDwtAqxZ4b3VOvFKP0ruZd6p0K4a7Vl1Xgxqt9cuzJnOoNl5jnp/udF8FTk
9PlVzaBkTNKrb1eI8LGY7SgsY9DS19dq+jshij3IB+ZqhGzfo7DOEKLkpNlz
fbAa84Oiu4f5CTGVezLUSB4b+SasQQCezbortx6pwRrc5n6xTYDD02q+XOKq
gedDp34JfgI0DNp5JDFWgzXyyo/FryicIu1CLmlQOeeE+NFBCru6+oXvHcwi
2n5Ig/tqCnnqKlf/71nE9/hvuDGaQv/wvcHD81h0ZwtPtTzkw+s8EayTxdJJ
2VsLDXy0xJCL87Roj/x9zaJoPor2v82/qtfibdic2S/m8vHNGDvJ4nta2PII
udHk+4ziwVHOOjj2dikbuiKx51NqXI+7zsi7MxIxHHCeDrUmj0wtsvmYNfBO
zoYZOkT4LPeanMMHa1sQ9GSmDsu4AQ7xEWTGDHJ6o4XoFJmkkg9X//Tq+Lda
2HMCkHre3bZ3C3O1eMrp0MqHW9eehzsNWiOf13xjnzAtRmXUWYjIfeW+P5zF
Ki1sNl66fnAUZdRxmBZhnLDBFB5zglpqkZhBFmoRhZ9rjt6sr2CRsTkp7FYi
BZs/SMdKFvPIuvUkUCj9erDpFA0L/poHgWZln/VlWXSmhMY6XaAgzVRlHfJk
USq16M7upVCf2eyQ78ViMhmv9F8KnWNr14c3feYZIDByb9bgbkJM4C4Q/pwh
9hG+5Hhmq8D4ztKAW5+NWwTQLySbtVQDN2rU05X1Ajwz7KsYF6rBV0v+TFtd
JwCHPdVCg/tkbT84CWHOGWagBtHETh0ThEh8WrX3/GU1OJldGCHMMgfYHyhX
Y3yKMspeJcRR7sIaNZp5uY/LbgghW6Er+IVVI2Fi+Y/5NUJMVJpmDpimhlVV
acl2FxF8mgucG0ntEqc/J51EamJrRRuDinGF0aIkEZ5oCOB2BvmcTptEENQ/
l0w5wRj91iQy+q+AQaOtw7WmZyIcaa9dHCFlQLbq+LYgsfF/MgYKjmOgGGmt
Wt60KQwi4+/NUh8X48lLsoBuDNzriNDHxPikSOhb+VqFhiwrwwUbidHnrSos
v3w4d4m1BE3rDt72LVTBwv7AWlcdyQNyzaFFKpDuvFxWggkyRmNQqlD+3mX1
jhcSeHCcSD4Q+kfamyVYHGG50m+WCmnV8QsuLpeCwzBitgpcDJgvk+KDknTu
T/KC2ExfIUUFFwikLuIGLZeiX5vdgpBbNEI5cL4yI886GiUcGR8ZyHZttjtE
G/cqT4b350gAkfp/3+bKME9MgjCGNnIcKUdjB1moWBpErfsiOzlmc/kW9Dnv
9HK0TPQecHwBDe649K1yeHO8xtAg0+scTBQgqbCldiyNAM7wvXIQN2psu5WY
70xAxyqMfP5RIvMn8kQpkBZHgoTk9YxjpNNLBf4DNhesfw==
      "], {{467.4138, 162.3046}, {454.5143, 150.3185}, {483.73499999999996`, 
      159.88210000000004`}, {458.5517, 177.5205}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxdlH9IU1EUx2erhhrW8AdaJhplQ8bIUjFleRJk2Q9lWoG0fphYoq/rUtkd
a6alMwvUTKMirWSIVqj5h2hiEGMViJSgpJhEllQgmGJDC8Xue+fWgx7cPz6c
e8+P7znnRZwtzMhVKhQKL3ZS2FnDzsdPvg3eeyloTXWunmUBIl1Vbb0xFKZt
AZ2qUQFCZz7HbdZRCO40TPX3CPDyRPj+6B0U3B6N6V2LADlDJw8dCKXwzDBl
G60RoKfSPuyvptBu1vuMVSA3KGUmTq+B1lXLPx7c7e6uXbbAQJhjxliJnPbb
IsU3ODBeN7ODz5hzrlmA771dyrYVC+SdYx/jO6s3L39g/uzsekQzf8/i/WWx
vusqmcX3O30pjDvN+oMPOftRaHR5NE1Oziz/w1O2gNk2jD/vj0y6MH9HEN4P
7ef6hKC/QbcALe9jfli3oB6NIwKs5C5Ot2xF/WxfUY+RRNT3zfwFyb96u8xi
/rpICksa1pB1RKrvklZmq61Vq4zm/tYTKZ9Xeygc7WMCqojUj+o45AJvAulh
Qfkd8bw+XwK77kUFxyZQ2DDmNJf6EViozSxxJ/L61ASedoyfDtKjXR9IIMvz
fCJqH/cfQkClv38sKYnCmTqXpz2MwFVjavMjoDBnZBciCeqfTGEtm63yaCLp
n2pA/bMziFT/QhrOT3oB5ncki8Kk2A87wf7moL+UGiLpO2Hm9d9G+7dymcV6
Am/ILOajuIWc3IjxH9/lXE9g1Dtvm7aB55ONPFQlsxjP5sD8NgpcnwrU40Ux
6vHkCtfXSqT+1ZehHppSAgnmt9VFduzntTKuh1Vmcb8Wi2ROMRT9KiQUqmeM
fQ/saO/NpzA8xD4L1qs6j/r4XCSgDkh6PZnD+5VHpHmLz6YQztZnyYT2plNU
2qd6I8bXmXC/Y5ORZ5neJWz9vuiwfuE47+8mtNfaZBb7VUz5vP3k85kp8///
jz9IEvUW
     "]]}, 
   {FaceForm[{RGBColor[1., 0., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxVVGtIVFEQvmqyJlZaYoq6ZmVtZg/bUtHECRErtVwfhY82X7taeW6iwp42
EcksIXKDgtqyQCz1R9lDsM0MTCwixCwhLcRHWlpLWcjio1i7e+fgrQvnx8ec
883MN99c/5yTSRoHjuPshJMkHHvh1L3fOWUqoXCl06IY7CdQqdp3c6RAwhFF
PdWPBNxUFOncP0ig9WxZr1LAKSZ5lXmEwHRNcmlePoVao9HoNU5gpXvUy1ot
3j88gfH1GgpBmYZOyySBqwuXyn/nSNiWj8uWsFUzM16nppAlQIXw3inyRupw
BoUuiyLTMIb8Pmns/jCBvO4jcQWpFJYIvXR8wPfPEynEj+rdf/QSoPo7Qevi
sR+fVwRs/YbFUGgXyndrw7jDbuR/00DgouL7svI4dn8PgZjY4jlDAgXP5tjR
NiWB1zu6HtYcpFBtVpnUgQR8zJ9C9CoK43r3ZlkAAb7erl2TzOrxw3yehxif
L+p3OU3CtnrtMiUs8rP+J+XIHy7oMyu0f2Yt8n/ORf03b0B+Uz7mj92C/C2F
bF6hGB8oZf0pCKRbnnz8RiiAc3/9Ay/UPyuf6btcymfjPyFDvlUZbJ4cgWBj
oKclhUJvt/D9KRT1GjogYZueuXslbOtnazTq/ZbDfBDF/OWE/kqKoFCg1Wq/
uKL+1lA2HznOJ3oX03s7xm8pUJ+malaPP+MvZ/zeGC/QIa5wRz/wxYzPicJA
fVHkfnvsr29Kt4hF/zvivMNfENjYea5RJ8P8Q33S+zClUlkyLOE1VWbV7ISE
f6pM8phfTE8Z7odxBv2qcGT+ncd+5A5Yv8qKftu2oBP9w3G8GFfPSVic/zyr
15VHf/nSRWzLXxnwPx7zYPO/wPzqjX45b8B9fOrP7l8j8PXxfYfGTTjv1Q14
/3ow9jvdQuDuvYGjIeFM/y58fzoa+w8bwH2/HcfiZvRzjwr3oWIW+eaFfXXp
ry96ZkU/B6RjfmdHXtx3PzXz51JerGcim2EXXszfqmH7tYIX/fPuGPO/Gy/W
E8FLOFHucTyhRMLi/0iH850X9LHNu+MUhTIhnM30/Pd/+Beh5FKM
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxl1Hs0lGkYAHC3tjpJNmrQRCLpRNvFDm3i6ZyUdKHQdkZFF46t9920itdU
IjqErFkGG5rkslKRyGAkrS4TMqolosIZO7ZIF1o2sc/+s985u3+8f/zOd773
e27fY7730DZ/bQ0NDU08Pni08Hzs3z6fH8OA9DzaapRCgAisFgnOMHB8J6io
QYN9r+lgHIOdB5aEiyUEDg8ma69PYNC1uSInKZXAwJDdkdyzDIYarLrPpREo
L3fc2JbIINfF9ULyzwQa7S7H9vzIYKSK3y3KJNB93fhefxK+X9+ykkoJLGi5
O/2FmEGnyHCOIodAakaxb/lPDFT1bdHxlwh4FsevTklmkHAj8gthMQFWqbco
NYWBa3a46IiMwKQqh/nVEgb8RGXXs9sEdmfMG/XNZ2AYbjwU600h5M/Q19N+
YcAcgm4yHwodMwRrE9F3Ug+lVPtROKsSaqvRY+m8MC9/Cs6VJ391LmCwNOPW
rv7vKKRbzJxP0K5r9D3aKGeP+KkeRoc5l7n4GU8JpTDFZSI4F++70DZu5XiM
Ql9MO2/WP/Gs7WVlJyjcry+Vn87FeN2u9dhHULg+++aOK9kM5j2UpIVFUsg/
OPwmNotza9lXozOkGM+wKC0skUJWxqrMIM2wf13YVdUu/IvB20ef04zdKVRY
n88PHeS8LftgsCXa0lR6/N12Ci4fnEVNb7CfauGVmF0Ukk3nyI+iY22XLezc
S6Fnw8dPfPQmvf7KVYEUqvbE+YQNMLhmsS4qnlDgBzxtj+vHfKlzVMMhCg9k
s1XZrxlUyByipgVTCFM75QhfMQj0PHx271EKNsPuvBt9WG/4I7s5hMJiD0/e
LDXGs2RPuROjsDpa4fVSxaDZMqt2GL1PXKw06OFcFgIl52s4ly6f0VxXyqC2
wUI2bkzh24ejJ6YpOLd5R+QU1nNuuWpm2NbIwCvWzCTQhIJ7y1NlchOD45q8
rm/mUDBwO8XzbmbgMOvDTSM+hRWTC4JVj3BeXq0JSZtL4ZruBtWaJ/g8Unuq
zIxCqG9nV+5vDJKuXyrtNqdwvOe25PcWnOeF4UMKSwo1klGtyU8Z2HRHNBBr
ChoblgUtbMP7zkVd1Leh4Js31zegHec5Wmtx5VKcx8IaZd0zBkHSz/sDBBRs
R0rz1SrOj/V1Sl50YD4BFlvT+wh8bPWWT3r8f1dMJCjcBwm022avVGP8OrsT
pMlDBKQd9oJCdEGkeeu+EQL7zzQtp+hNeeW6dmMEhG48wz7M3zpdKZ4YJxBu
OvOZCdpOSPzvaVDIea97YbMS/8/yAY90LZyn0tror7F+jqe2mBRoU4jzs419
jPXdUZ14exit55PAO9rAQFdcGrFFB71A533eAwZ+n1y6ROi4mhSe/33OLe/T
5adLOK8UZ03fncegOq7eOhP3Bc+z6G7/Hc59l3Vtnig419Q6jo3h94bG3ULt
swhkiJ0EBzA+P/VGw+/PE6grXj7Wifk0KzeV5OK+GVMUuxlhPxsrQtdrXiSw
7vkNcz72z+tiY2tUHoEOp6LoBdi/IKsvwr/E/XPSRi6xwn459l66O7OIwIr8
Ti8z7MeVF7KrMWUEltG30rnP8f/4ofDqZDkBtwmlLP0l1jdQoi+uI3Bi57HM
JJzniFus1aKJgEEjX543wLk3tlAZhf127RYZFsUQ0DOwGhw5zfm/+/lvqq2/
uA==
     "]]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJpIGYC4oapzt1vHMsctGL6D01dUuwA44fskGs93Vzs
8OGSb5KBe5lDkS3X9cMZxQ5ArsCOwDKHtteBO+qCix2mOHfnuMeUOeySa31t
aFfsoMLWODU5p8zB42GVyDt9iHk8TWUOJsbGxps1IPw1dWUOYuvcH96SLXYA
GhdhmQyxX1S12OH3yo+XdP0g9i02KXboynn+u9O+zOFNINBBPhD5twYQ++NS
ih02nyjbN1+zzOGHRky/UyOCbwfUbrAYwX9UJbKO/Wixwx2gA78aQPz3+mGx
g95dFbaFQPMnHPqqcecnxH0+QPs3uD+suiJYAvZ/ANB9XkD/5CmWwN0f13/o
6wqNErD59U0Q+y7IlkDcmwMNT7ESePiAw5qjBB5+R74CHfwZEb4g/8y7hxr+
3kcQfFj8AABSBcWf
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJjIGYC4kSBCMspL8scMtLS0tiaih1gfDuu64sn1BQ7
7J0vpX8XyN/g/rCqpKLYoXTffKn8V2UOu+RaX28sLXbgj7DcwvG6zOHIV42Y
90XFDtnPf68UfAPhry8odujKef678y1E/cc8CJ/zPcQ8k9xiB9bGqc7aH8sc
lhXYcl3PLnb4vfLjpbefyxxmzZw582ZWscMl3ySBHd/KHIqA0o8zix2Ol+2b
b/ULwlcG8u+osDWW/oOon5lR7PABqGEDUznYPHEoP4Cj3EErpv/Q1XSI+lB+
TD7IvwWxxQ5A632Tlpdh8BVaXwf+SIeYJ7AJwQeFx/qdZQ4TDgE9DLTPYsuJ
Mrt9qO67eqjMwcTY2PhzJiR8Q45BwlstG+KfXSfKHHiA1u3NgYSnxmlI+ITk
QcPjDIQ/BRqenOcg6muLix0k9e+qqJ2HmJdWBjF/C5D/qEpknXo1gl8jss79
YCOCD4r7B59R+Qu+FztMce7OYQfy214H7oj7BbF/7VmI/2T+FDs4dec8jz4D
jZ+/xQ56d1XYEk9BwmPHP0h62XscwQe5b9kRBH8eMDm5HChzOHfmzBkdoH5g
aEbM3FUGjg9RqH1vt0Ds//et2KFhqnP3m7UQ+/d8goTn1KVlDh4Pq0T83hY7
bD5Rti9+fpmD2Dr3h1I/IOHj+ajMIa7/0NcV8iXw9IyVL4bg31hcYKvFheCD
3fcLkR9g+QMA2jiFIw==
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
     375.7414999999999, 314.34000000000003`}, {375.7414999999999, 
     315.5100000000001}, {386.5696249999999, 315.5100000000001}, {
     386.5696249999999, 314.34000000000003`}, {375.7414999999999, 
     314.34000000000003`}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}}}, CompressedData["
1:eJxdlG1Ik1EUx618iTFp1bKYMHwZJZYpLLIR2qFhimFiBGkvUkIrUFC8T+NO
kjTRQMEXcIUSGkgvfllFg3xJzVkotsSENEnT1XCaii1dUUPsPs+59EAf7ocf
Z8/5n/P/37vIvMLTV7YEBARsYieFnc3s5Hv87VkvKRQnKSYqzhF4PmTu3XhB
YcTpdB44QaDdO5aR94zCNZPJFJxIICNPlW15TCFZMdGmiiPwnZXrWykc0uv1
O6MJHK8p8JxvpPA01VWi1iJ/qpLZzxou35L5rME+NH6TQpe2cjGL851S1Hdq
Ue83q99Q21Ij9xO43tuqWSmjUO/wxUzFEtAFl1ujKyg0NzU1dcby76tkFvd7
Xy2z+H1hLYU0Jj/C+xU2UHhYlKT4FceZzS96E5GA+oa7yLN6nP9dE/4+0cD9
uYf9apMJHJzWBfe3oB+rKQSqCzz+hfvonykT/Qjvw/2UH7B/ziOZxfnN7RQ+
tjGBGdxv4InMQeVW40k77zeD84SyvKoWszq0s5jHaCfyZ8ZTrIGvm+/nItDT
qokv7aHwpURtu/qVQJnVWKPs4/u5CRxh8rmvsD44R2COCRT38/4LBBqNNQW3
HRSUE21FpYsEtmUb7PMDFM50aCvzV7j/byjk1jl882vof8Mw+p8TJEj7Hx3D
+zO6XZDms05RSGf+ndIImO8c9nsbJUj+Rq3x/fcJYGb1+EDLPxb3uRgqszhP
2i7k9L2CpO8NRx7WCXCZxSmEWaR5JpXIaoXMop5jq0WaL2GHgP6EWCQ/QsIE
yY8fTF/0I3ePIOU3udki+dHD5h9kA3ZtYJ5L4QL64ZdZfF/HfsrM4lJ1eClE
sOtPNVjfWKbw2hdzoW43+pH5Df2xqQVo0cRP6zyY1yWVIN23cjeFJRbPAwXW
3S58T95A1DfP4Ps2rmM+h6cphNlSXc2rRNrfPon5trj5e1yXWcyr+w+/b+P8
fo7L/P//x18c4gcj
     "]]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGJpIGYCYt8kgQjL7EoHrZj+Q1OXFDvA+CE75Fq9j0D4
P1MrHdpeB+6Ydw/Cr4yudDjyVSOm/zNUPqDSAWRWA0eJQ7jllhPbHKDmiZU4
5Dz/vXKjVqWDHdf1xRdkSyD69Sod4voPfV2hUeKwb76U/l3PSgevh1UieYol
DiDuk7hKhw3uD6uuCJY4fLzkmzQht9JhwqGvGnd+Fjs4d+c8t66BuO/1w2Kw
+RObKx0eVYmsYz+K4IPsM1iM4P8AOtepsdhhy4myffY1EP/EpUDMmw00/00g
0EAfiPx/oP1FtkADTIodQMHxxRPiH1HVYrj7xda5P7wlC+FLalc6mBgbG2/W
KHZYCXTwIaD/PYD+eadf7AA0bv4tYPjsAjrX0A4inxQNsb8uGOK+j6kQ+w5n
oIb/6WYEHxY/ABlHwuk=
     "]]}, 
   {FaceForm[{RGBColor[1., 0., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxVVFtIVFEUdZSkJEhCTAxFcyrpZS8TA4dNkpqlNDKl1vga3+/JU6Iniyys
wA8NEtEeSoIYmfohZUFTTCJTTmYhafgAZUhCoYImQkk6d9bBWx/nY919ztp7
r732DTaVJ+V6uLm5acRJEsddnD3TWk9NOadOc5TXJhsj75TI/tAcFdsqLW1L
2Zz6Ymf57beMoutL5i8KfH1BP3DfzuhKU3R9t4nTDmODNXyEUZt/2LQjC/fH
3iNeksmpIsprvGOUkdaztik6XcVKvjijigX98tdUTuvHO8wvxHvl+fZkTjoR
/v4O/DkG3A8R+X98TDD1neSU3mB1rn2D9+tOcFJ6ax9ktEakK45FPxGvGCn9
1hKn54F1C/ueIX48AvyNvYwEvXYoBvef1jAS9N4TcZwK8vLyPCsZJUf22z7F
cwqqW9CnnGP0UBRgFflG7HZ7dxmjZfHhcaKspwT5svSSrwj6TRpUrNR7LFnF
Ln7Z/71i8F8V+kx0mKOKSsG/OwP668rBr8lGfnsF+Jfzob9PFeLBZtmfmdG8
INhfyKnGpydWUwj9u0yIm7PVfAr/TAb4zp4Gn8HIyCIGECX0HnSGGhvOQK9t
8SpW9HwUrWKln0od9L5lRL6bh9Fvcyb81XqIU6PVGXo3B3wxB+R8isFXv1fq
fR7xLyHQ51K7rCdA8t+R/L6ITzcD2zbAD5lNks+DU5yQJzEN/W1eqF7FLv9r
MO8hCyNRveWlO/L7Danvf4v25oZVvKgfCNw6qmLDQGDd8JjU0x374RyHX81u
0u+f0U/eSrWrfv0k/Fa1VO3yT+gU4p0/Veya/y9Zr0P6y4+vYiX/cND/eOdG
zNf7gfSrL/yy2IF99AiQ97sYiXH4f9Ni3gd7cX9uF/rd8oSRMs7L4VJ/C96/
1qH/ozbs+2IM4n8+YP6+CdiHggnwHRH7MMd9em5Mop/SU8jfM4N9z0+V/pxF
PWFpwLVzyL+SKffLAf/450r/O1DPtUIVTykfylTs+h9VYL6dDsx77QVOrS0t
LalSz3//h38BhCBRLQ==
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
     0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxl1GtUzGkYAPA2hC4rxgm1VtpuW5lxibSa7YmtpQ2TtcQkqabskZrTs6fj
vC6t1aqdKLlUW6Oh3JbYKJ0uqhnKxDRiJKlpzaJRCpXYTWSf/fQ/Z/fD++F3
3nPe89zeZ2ZE/CrJKBMTk4/oiOmY0kl+FeAd9RODBf1drpZuCG99bGBXMoP8
bXahG8m3hPfme+1lwJ8/pbaB/OH1HtuMFAZ9zvrgpe4I24cd03pTGbyVHJJq
yV9Ve0TYyxjoHBxv3/BAWL8oT+GWxmDHhnSpkI8QXzG+w3MfA2nnM3mZAKGk
/bKj834GcUKZ1ZM5CI4FisQRcoIk9mq9J8Kfl7ev1qczuN4Go857IZgpR3z/
yGBwQuQrrFyEcEjp6j06k8HH6hjpc0DoPW5tfeY4A/NaS1YnQxg9EmO6uoCB
zyflYVf2I3xv4yxuIUdovALDDiDY9QTaCgoZ7GpM8zl7EEFbG/8ghZyjfch/
cxjB2c3Uu5R8wn6ca28W5zP1o1335XBucyi2TM5DyPrmpayX3hfFJvHyjyIk
pt/gb/g3noIEn7Z8hO/uFOq0CorXKaTf7hgCTD8fPyhncMB4U3OF7JnQOeZO
DueoqhnWIbkUD6vW+JxGcC9wLyl/x3nh07N9Ba8Z/N01otmXghAgSK+ufcbZ
cFosiyVPylhZsy0N4e6QINOGfAFntVxLR5jpZKGr7mZQl5XDi8tEkIqMkyRk
57Fv9NMp/6WbWYKqi0HrxEKVP+V/Nlbdp3tK+ZYpVJ3ZCGtrzIa7jQz0Yrnq
518Rxr7gVxZ0Mij9rTzgYi5C5bAv//1jqvexQdFmqk/FmiX8DY8onuzZ4hly
BI2sfIuLgcHmgysMjNyfrTCKOzgv3jm7wVjB2c/7g9HidwaGzkzxh1iEzrvd
h7+9xjk6VFo5UM85snSCu30DA7e6CVaeWxE62tXG9hsMan60kB4lHxcl8I9q
GMhlQ2GWcQgqqxyZh5bm5bV9lYb8Jc97+JdbdK/cndwejzAmuvGv3iYGSx80
P+iTIph3Xyzi36H/wPNlUQkIQfLuaSt1DLKkSsmCHxDSV85Mib9L72n9gscl
Ijw/Z5V4oZlBwOLdR0K30TxevGC0aGFQ3rRr7rztCFUjhdUCA+fwKYNq5/sM
wksyXYNWIyR3+OuWa/9vfVLAk9NrEWI8M0UCsqngetOy9QizHrksH2hk0Ky0
7pkTijCQUbPsMvnUKrGZbRhCl2is+2zy5ManDUkbESydTPsjqB62s8rmRoYj
zBl6V3bkJv3P9kTXoE00TxXFeTupfp/6uVg1k6fGTFfYUn09wtSGt2T5ph38
6usM9jasA5cIsvvguBd1DIrfO0iF5Kn1yfzzVzlHDqXqtEWc1dn7HU8dYxDm
L5m8gvbFyXX5ek8l58RL7xbb1XEOUnvw/NUMWNLJqjzy5zn85ZcovuJXTuZe
tF+Cyxx4TpRfV8ypEB1Z1qTYFE79jNZXFZrQvml+fHJh1G2aj+DoHtVc6od/
ft5W6t9C3qjaVNo/VvPOFcVRv/IHmiPG0/5RFTVuiaF+rXnZ3rLkC4RaNJRJ
WhmEeN9r2SNEaB2jvGVoo/9TGpja4IdgEbmlpJXmWbnRp2fi1zRvOkvd8y7O
mJFr1Dyk/SIVmt//jOo1zcbMbzfn/+7nfwCPPrK1
     "]]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxNVGlIVFEUHhuycslKG1zHfRyH0aJRc0k7amgRFmNJSJpbLkWleW1RhHll
RRmpaWpjiaGtlGMrmYGVaPVDbMEtMcuFJDUqcSpboPveufF6cH98nHO/c853
v/NcU7Nj06USicSEnlh65tDz3rziWoSag5vRwwWbywlo19VyvQoRN/Yn7X9E
cYv86OSrMwQmRgLsOYrL2ozKwSoCC7LcdtlS7KfRaMhZAnqVbeVdT8xfXIPx
Hx4cFNoYoocp3uoS/nXUXcR8vQ9uIi7ZlOdx35UDGYU/9QSsVz8djHPhYO1w
gY0v45+RY34Krf/k2JUt9k4cZGVkZERV4P1n9hxY9DXkvC0h0Jm4/vkBW5wn
r5gAP++cpRy0G5UJ2UUYz1yE/F35BHr9Pgd6svyZKAIr2m/5+tpxkBtq1hcJ
BIwPBop9KL8qobStMoSAXLYzxt2Bg/6GnNCJQALRubNWdo6snwCsl+vE+PxQ
v+XOIub7zXQRMc/fyOYf8Ed+KdVrpMDGcGUl8sd7oP6FQcgfocD6ZqHI/1iJ
+msjMP5azeYLJrDqXFzdVm8Ojk1qm8M0qL9MgXGDj1iP53dUId8XZ+Q7rSCg
/GTZ+p7O19VJPw/Uq8dOxLye1TIR8/P8sUa9XyiwnukSnLdbhf6yovrX6PX6
N77Il76QvY8/8s2zZHqHYfyeKerTshP7SZYy/nTGL8G4fSqB+vJgk5hZneCH
2iQC1Q+ryqw+6SC2WX70pBeBno7dfhe6RcznN07ohPeWniAQJT1ovmZKJ9SP
KxPv87vjUiXib8qE0tQaEW8rbTPOryMQou6uMaX3+f3Q1BMostzYNPNRh35v
IHBjx9DeiXGd0H/pJQLbj6cl/h7VCf7JuIxx1ZCIT41NO99+x/o14PtO03n/
YV4vr7ki5vtp+qUT3nfDLuZXCfpFtQf3MVLK8nMJHCl8eSdoHr733nzM15hz
wrzJHIH072Mph6yY/sfxvrsNJ8x/uBz3PdAW48Hn8f1jHHAfLtcjXxrdhylt
s7zjEvo53xnrT17Ffd/nyvx5HfuJd0fcegPrh3uy/TKgfzZ6Mf83YT9F3iK+
3yQdt1CLWPgf+eA+jxrQL1HLOLhIw9VMz///h38Bh90/Pw==
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxd1GlQU1cUB3CI7IKRoRgToQZBxVKFUsSEpRwVpIJEwiaCLAHFQlDouzYC
ZbkCbjCOooxj61LcOuIIVtmpiFpxEJkBEeIWBKJiA8UigoEapccvfTP98ObN
b+a+d+75n/euXUJayBaOnp5eOF6f7m88H3OTV1I4c+yCbc82AurnCpV3JOtl
JzOrBqJZHzEqvC2Io6DXbP7KF20lPMrVyChcn9mT6ZBKQBR/Wti4mUJu5Elz
AzmBx2kt2fyt6AXWr9ySCbyTcByMk3F9spdpXRKBhjBRiTYF33cl0Um8mUCF
qrQpPZWCLinFaSqeQNcgr5zZRqG6ONhUu4nACV5p1M7tFGo/OJJ/IglwXEKq
ptDmf4oreGGsqwMK6iQS1pxT3gkNawhMxnHT/NC6jGYvMyAw2Lx/UIX1zj01
8V/pQeDBfIPYHXIKx4p9e3PcCGTlaR5l4H5v3OdZVDsTePJMvGEoiYJNZb7y
uROB/s0Fx2Ox34yikV+sHAns6pq1NxjzSE+YOfzVQgJNi1X8GzEUTNxVdd/Y
Y/3s8kvOURTKTCsKA+0IvLBJLPGJoJBCrIelQgLU2LT1bynrU5ryj9xg1rNG
u5riJaw7BIWG6nWsD/ktD0oMZC12Dl0uDGB992Fv09y1rNtr7jCN31L4bonN
sKUtAfDpGVyHVqwVSuR8Aot2mAo6/TGPB3afxVoTuNLhbhWBboyxfxJsSSA5
fqnX2BoKvs/uVWy1ICBZNFJ6Du0ePu/gGVMCrn9dGolAM/wYndqQwHRf0E1r
9Jwt908oOARq9Tu5A34UFogy0mOmGUi1D4m9hFZEWnau1THg73bE8DC61uU2
7/0Ua/WNQ/7fT7L+zUSdwNcyYKeM6/oVnT1w/ezoBAM9/Cl5JzogcLGZdpyB
pYXF93ToeE6+joOODOgXrsL99F8u0Lm+ZSA8VSsvQ98J/dJs7xgDk9XGOfrY
b6W2m/f0DQMXBPWy/ejXhrN3R6OTTpoIRJjXvtxeqQm6bU3IMQ1aqL34ec0o
A0b24yZ9mPf2KsvdxWiB62v53EDWcs+rMhnOx+zh2XTvIQYs5N1FvW6s9R+l
OqQtp3Biw/qDDK6/lt29ONudgkHfrlstaKpsVIWvoFB6PGehM9aXvJy/WoeO
OLCqvhJ9U5Cbdl6E/bZPKb/GfqIquR1iMQXR/iJ3F+xXUNYta0Cr/xhXnsU8
npT8NC7yoKAMlM6wfcfADE1mWgU6o00jDsK8j57/oWuOJ4U2n+tZbu8Z6NiX
8j4fbVNz+Pd5HxnQhLq3TqN1X5RMOOJ8Xxo9Fh3wopB0usFxkzGBeS8MV5f6
UnBINs8KkxLIl4sUr9BnrC4OSfH/5UpPqRbifO7cWqJ8G0HgVukKxXr0UUWx
l8dGfH76bs+P6Ks7+5btiSb/zV+ldimUx7C2qc/zGopl7fpBv2VMRiDvwPqb
fp++H+PL5QI8b0Z8WkUVWN/10Z4h2RYC+nwPBQ/dPhFcV4nnU2d8cUnzKgo/
G9Tahm8lsJF3reg8sP7/+fkv93xZOA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQBmIQvYbN65JZQIODioft1xNaxQ4seRWLDEIQfOdK/4a6
8AYHG1MF3iXaxQ6ZGuezFaIaHLL4n9lE6RY7TLjuF34opsFhxsvVOQL6xQ6R
W6QO3o1rcLgwecuDKsNihyP7jFYWJTQ4CPAxzJxpUuxgcNJrIntSg8Osq7Z3
95oXO5wJ7bRQTW5wUAqQm5RvXewwK+XdvNNA/rLahdvX2Rc7pBcHsxalNDho
rFa5+9a52OHcr1aLo0C+j+IO4T4PBF/sQXR0vy+Cz7b3cwZzaLFDaam+20ag
eQkWk4XzooodDmc1JXYmNjioBVlFn48tdtjeds4pJb7B4U32w0UGiUD/MqjE
sQD9c+7HFreHSUD/Xm/anBmO4Iee6AgwCEPwtZ7nA+1B8F8YW/x+FIzg+yz/
GXw0CEm/45aiVYEIPjNTRvikAAT/b25puJAXIvzR4wcA2dvC3Q==
      "]}]}, 
   {FaceForm[{RGBColor[1., 0., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}}}, {CompressedData["
1:eJxTTMoPSmViYGAwAmIQHaS+oPOCdqmD6Dr3h7tsKx3Wb0uqt3QqdUhPS0t7
ZlrpEPvP+Veub6kD9/XFBbHqCD4jUK+CEIJ/9syZMzrslQ6PXk7d9Mar1AGo
3PbVnwqHNwcslV+5ljrIt74OjPhc4XBD6JPjeweI+cdeVjjIf8kJm2tZ6nD4
q0aM/qMKh8MpqxK+6Jc6GAPB5DsVDh4BfySC1UodlhbYcn2/VgFxn3SpQ2z/
oa8aVyocvk2/O3k5H4JvVxmxYiobgg9SX/m/BOyeU1eg5v0sAbuX5xrEPpPP
JWD7/a9XOLRFXd7z+E0J2H8NNyscJhiW6yY+K3EAOn/HPKB7QP71vQ5R3z+r
wqG6Wd8n7QCCD3bPqxKH9e4Pq0pCKh2uA/2b/67E4TtQWim10gEU3hOA9oH8
97mo0iH96vMs7l8lkPCurQSb18ZQ6lAtAoyQjkqHJff38c3hgPg/fCIkfH2E
Sh0eVwEVTK8Eh99faUh8OMytBNufrl7qMBHofZsFEPO7TRB8UPjrOyP4szik
59X5QcN3DiT+K8Mg8ZkzDWJ/TVwp2P2P+iH21SaVOsyeCQRtCP5OudbXE6sQ
fFB62VsKce+ZRIj6ygKIe7IToPGfVQlOH1zxkPQnlQqR946B2NcUD3VvBMS8
v5GVDpqnBY5LhUD82xACNc8Pkt6y/CvB8aXoDvHfHq9Kh529bB+u2Zc6aMb0
HxJ1qwTH/2UzaPp1qgSnF1EdiP237CDxg5wfAL2OcwI=
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQfThlVcIV4VIH0XXuD6tcKh1i/zn/0pVD8M9a+12c
qF7qYAwEwu6VDqKyJ5/+1y91KLTluu7sA1Gfa1HqMPHQV42awEqHb9PvTma3
L3U4/FUjxj+i0uHRy6mbzjiXOnBfX1ywN6HSYf22pPqZHqUOwTvkWrUzoeZ5
lTq8Ddwhl1qE4AOV22bVoMm3VDpMMCzXZfQsdWAEur2hq9KhLeryHmZXiHt3
9VU6VDfr+7A5Quz7O6nSwa4yYoWodalD62ugAVMh/jE0RvDB+tURfHB4yED8
E9MPkV8sUuqwtADo4eZKB4+APxLFPKUOO+WAOiog9h1jLXWQB3JvpFU6yH/J
CZvLAHW/P8S9im9LIO75VgFWv+xNicPZM0DwpcKhcE337Qwgfz0wuL98QuWX
fETwQeH5/l2FA7ebaikT0Lz0tLS0Y28qwP4zfVfiMHvmzJk/X0HVv4foN3lZ
AYnPjxD9+c8rHBjyG1laP5eA3bfqaYXDkvv7+O58hbjnzeMKsH8f/4Dwcx5B
5Of8gajXelgBDp8QoP8eVomse36/AhyegkD/g9zjdh8if4ULwQenHyEEX/O0
wPFZkqVg984Emndd6JPje3lIfDo8q3BIv/o8y1sNov4Z0D9vDlgqe2lD0lvz
R4j8az1IeEv8gtg3xagU7N8tTJUQ/5tA1fMg+CDz2sQRfE+gB/iUIOkzxxDC
99OCxH+JNtS9BpVg/9eoQtKHnRkk/j/LQNKblSUkPd8URPDR8xMAAmGUag==

      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}}, {CompressedData["
1:eJxd1HtMk1cUAPCKrBIGrIQOFUREKaBDHQV8Rj1TKaIMHA9hPLTCgKEoBHbt
/XAyEEVi0YoiCioiz1hstUtBMKY4xQFa3ogOZZQhE8uURRJeUbrjP37JvuTL
l19yc757zrnnOkQlBsQYcTicYHw/fjdeHOOtYggIw4tEbnYMLBpeIe+vYH07
zCPUWcn66HKf1AI1gTMZRrxrCxjIEB/grbpDwK/1UUm6LQOPdZnCZ/UELGzP
eYptGDDnaPX5DeghU17uPAa2abzWJjfheleh0MqagZZmlVWgFuOlfB903oqB
6j/2JXi1EchZKg4K5jFgeJO0xaeDwFY/kTDQjIE8//iKgC4ConsLL+8yYWB3
+lBISDeBy/KVPSmzWW81Z3TyD/STz4rdpV+OU/DV7Wl724nx11fHxI5ScCoO
0ti1E/Aomkm88prCLLGPwreFgIvfOm7vIAV/e35pcDOBnXnmq3j9FHh/qq+u
wXxuJFHDpucUFui9XRwwX5NvB5sSn1KIfLjbYFxHgCOYxT/dTaE7ccrxpYrA
xckOXWEnhR02edsfyAl8rS1RVLZTWBI2hz9YQmDa83O+so1C2MrAjC2FrC+M
5b3NzGct4bxKEJxjPRXs8975DOvDVVXSZadYa9NehZedZP1P2/uE89ms30lb
e56dIDA5Ysk/qKXwvGhE8yGLANfMWtLYRKHSJEhgjHbJn7vhTgMFTb1yLu84
ge2L5s9W3KOwYuBS/LZjBLqLf+t5cJfCeIKtrSKTwO9zLWtnainUTxZqLdFG
LwIEm6oxP92LFNlRAhXOjQ87VRQalwzwnNC/Th8oqFNS8IgbUtzNwP/bzpkq
r6Kgz457fwItGquDkOuskzOzkloqWcPjp1JSQeGKlpOvQpuVqbW+5RSMg9yb
jTF+r7mde2AZhRqX0OxI9L8NEsGeUgpm1bPch9FJyYxAVkKBO7WyuQz3u8t6
sfvgNezXyZ0jsZjfxjuPYDW6KlilPoT5pzV9prxdTMElPEDQjfWZ901X6g/o
UcWQw2qs7626Ym9LdFzs0tmLsf4zZI7y1VUKsmN2zXk5rN0ulKudpAQKCz4+
FA6Nv+bai1lHttus27yXgKuNV20rru+ar4eIaAJ51yQjDhg/oqVG/kUMAcfd
KX5S9IQ+XRIRS+Bv/zUDprjfvuAN7co4zPf0qEGG5h0Ry57+SKBpR/qeHMxX
Jtare+Kxnll6gwHrYbH1p94n+wjEWni7Mli/ve882jX78Xyf6o+6jvXO3u+a
n5tAIMxIXXpGjufPzXo4/gDOgyT7pURBYXmTIiP6IM7Xm6yFx7G/jivGotIS
CYxH3/yutoZC7rCvJOcXAuqvjEpvcXBeJ1R9wnS8X3quWilxfun9I/Kb6F3H
7Q3+XAb6fW71GWE/ndZmxOTjvOcufHI5HL153ZOQv0yZT/1PKHdSNJqxvpFK
YkQWrO/XT7zxs2QgdL0uZRTjJz8q6zyE941ncUeUBvdzv/BnKw2fgciA6r6z
aQQiakU6U7yfpgdC+IOHCSxrrBKp0Bb+ddybEtb/vz//AxzqdGU=
      "], CompressedData["
1:eJxTTMoPSmViYGCQBmIQvVn36tSL00odtnAZy6neqnBI/mNodnQegv9Q6MHH
hKWlDme+i5ox3K5w0Cu8f2LJqlKHXxdvp267U+FQff7e/BfrSx001iycmnOv
woG3s6xYfkupQ0LYKs7rDyocnsxd5uy5vdRhwYWvB78+rnDYvemacPGuUget
GcZsUs8rHL6cDk5at6fUYZOQyO7Tryoc+l/K6v/eW+pg5jD9Adf7Cgct9he/
3feXOuzIlWLz+lzh8F3UN+kdkH/n8VqbV98R/GWLAlte/0Hwp9W/nBjPUung
yr2g9hjQvA+/OmxOcVY6PPzquqVsZ6nDNhGDFm3eSocTuvfKdLaWOtToXT/d
I1Dp8Eihc23OulKHuN2r8m2FKh10z7tFmC9F8Fk3Bk06sgjBX/9O4VDWAgRf
u2Pjc815CP6nPJOZ72Yj6V+88tqOmQh+korggo7pCH7oH+0FHV2I8EePHwCj
Y9A0
      "]}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxdlG1IU2EUx9eyzK2wyCiptBLnVSzfwiBcHgqavVBNI4w2ehFnYOEM93gf
ZYrltMxmpmkmSKFFJGoFlX6QUD9EMIkwHBHZ1CzZVOxlDs2y595z6YKDy/hx
z3Ne/v/z3K3nclIzlQqFQsce4b/nUcsRl4GAs9msPVhH4c7hdZXuLJkdxSmv
/pgJ9Hk5Q85tCqf27hkP5gk0NjQ0dNVQcPvtXJNYTCBXq3IuvUWhtKn/caAN
OaOKAheofv7wGsZ/uI75tHbMd/QqBbsld2NbNYEE9hu4QsE8bXvzq4bApL4z
JLOIgj77bn5SHQGbR9/5l6cg9HumnkBXiM3z9JLMwvui7EXvjRTiv7aH+9US
ULOBuvUU1p7tGzh0g0BhULvuvo6C96OzpKYM69m0FFzbb97jrQSSVc7m1YkU
Bk9MxPzOxXn2xWH/VpNULxrjO9MJVPd6uU1RmL81ReaX7xRDymSZxfkSZU7q
Tq0riZV54Vnhj2Mc1jcrUN/BCPSjYp7HeMZZJpOpbJYX+0+LkPTy8dA2Z7gY
zjiNjXPIy2P/Gsmfn7xY/z3jA8MFQfZpXsz/gnEoG2jDFI9+afC8xyMzC2/3
dy/ibzzoameWL2iw3ydfeNH/DlbfxxmqlKM8NId1zWexeTp0wwXHh7F+XiTu
Q7AL6w9GoV/6z5gvORq5egjr7Y9BjmMs7MtkgszCPp6MR31UTl70u2XO8p8z
g0fSd81boN/hcEx8Qv16FizoHzsv+GlUEjBW9XrPs/qCf2o/nL/VJcUvQ72m
WP8BFaEZO/yl92y+gteRu1NXoL6jY5jPGoAcNo7xdhXqMeLG/krVBJawu7dl
SvJzJe6n8TvOM7uKwAPWfr1PmjeQiP07FLiPjRqJL1DMz0l6EirqXR6J5/Ot
Mgv7MXZZZsGPvHK8r2853OemCirqfzpCur+VuH8z4ehvrB3vy8A2zL+e3W9B
X99mmYXzxaHy92Px9+UfDasLOg==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAGIQfabeY/9exzKH9e4Pq0TMKh2+3r7eaOyL4D/QnbCg
IqzMQb71daCFeaVDX2mhdG9smQMjUG+DZaWDzd6gaQtTyhyAqtcdt650EE48
fDk7q8xhpxxQgz2E/zqvzAHI2yHnApUvLnMI3gFU4FHpoMHPvfVZWZmD6Dr3
h7P8Kh0Cs2eVx1SWOZw9c+aMTmilQ9VxTatL1WUO6WlpaceiIfbz1pY5VIus
c2dMRvC5ry8uuJuF4IPcX1Ja6eA+5RubfVWZw+yZM2da1lY6bL/IcG9RCdT8
pkoHzi75ZL58iH8U2isd1v6KyT2aClE/s7PSYbHyzj/HIxB8sHuDEHyQe/f4
IPhyFukunm4Ifsu8s6veGyHCEz28AdJ7q2o=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJwllAlUTmkYxxtlxv6RaCE0pYyGjjOl7P9JixBaOIka7v32DyllSdJ3lyYx
TWUs06aimZIWWzktI0qLT6EQUwxfsi+lRaKZeW/fPeee9/zuve99nuf//N/H
ggrylgzR09MLJLewBrS66fdZRGOtt036gesq9KXLziuNo5HT2ehJxakw4bPm
ncd/PKQxdEDrGBVcJr/WFrXzuGMrMdXGK5FxwbHv6nUeOYyXR6qREhH5RdT+
fB49y9dHOyUpsEOe8PZLPI8ttr3HHlooEO6X7eAZwsNM62dcnCuHsC3Km4fp
jmbDD45yRNf5Xsmew2MK/9rrUrUMYYdNDO6JeKT8kHnB0U+G38ll+pZDn09b
VvIbKcpDD5twdRxWvDKwH8dJMUM08qJ1Fgdf8rpqihSnviobahjFIdq/qayt
TIKG0zfvrvPn4KVK2pUSKIGLIqhjqD2HnUOShk0ykODW3XVv7EZzmKj07IrL
E6PNyLyuvZ1F8q6UTMsNYl0ef7FoPrl90YjR4kE95h5lcahFrhdUSWOqsHEr
i1aC6kgama5FXftcWSRGfp6/fTGNl8UF+s8ns7gpvftcqU8jUbN/2ZJuBiWq
4Z/S6yloa46XHtUwMKvYMO3HVAq7R1rN+DeTGVwjQyhcMbb24cMZpEVZX432
pHCA929a6M3gEvntodkU1OSxzUwGQhmlEyisGzPrnHm/Gt+2fIpU6lGD+Qxo
1CBUFtqzebCPVJ0aK/8Y4TY9i4JznuJRZ68a81zdQz4VUHjxmTihR414n1Cr
Y4TdyPY7VgySq6YVhlRRGHZmsv9TSwYhsXFPP1RSsJlDnqxg4J/tUL+gVbff
ezmDfhGpvIVC+Nzcxc3BDL6YkIb3UwCjrTEh/N5JCEhh4OfulubjDIiqZhXm
NKrOzt5mSfitXamNiLBDYInHqAoGxsvWfDFxp9EQ0/ho02UGDzq6l693o9Ek
1POcgSBfZxgN0n2jy88YdMWRAgg/DjfKrxnDosHU6+9Jp2lUvElb+D3hfeZO
MpccGu1sWv3MuSzUR5Ye3NJGI7bwycsjDiyILMGxWhrzSZp7AliIBCNYiGFJ
dH21kcVYv3kXaqeJsajc+2gGx4KEXVItFuOF0rbXmDBRZ2ojLUZv2OOUhFwW
q4SEzohB/n5uFOG8vPs/7cwVo3qrfZRjIwslCRfXJ8axeFF40W0Wqwt+k8R8
FEOwmbqPhbNgoGUSlBH/GxBeeyI37767BM6d9I2AKRzO7/1QuCZVggcNH33a
zDmkCr5NkWCGZmxNyVIO5K0qqUcCzbu6SmfC/1kM9IZ1S5Aq+ErOgRtNInpJ
UUvsOJbwRXLMxWukg+ej4BAHoVuis1KQ9osXEMb4zZVNBVKkm9k9tCrkIJTf
Ol4GtcG1X88WcLDxGXoy0VCm+66RQ+138xM1e2TYa5TvvpmwIEPwbhkSRMQh
3Zxu1cqQcc/+vRNhMkYiljyRIUkYABN4CGWuWCXX+Z1w/Q1yrZRDsuCf1b84
8KhpvchFlMkRJpxrwoN6lchx0+V+R6gvD60QcJYC9lHFGEI4ediktEBbBcqF
xpH5NJHMvboTCqS9/7NaE8xjvXHxbb00Bb4WjBPH41n+9KcsmXcJ6X1zpIQH
55GhEokkTYfTPEh2td8cVOJq9qlVFTk8PGYThWOUEMpaXMXr5om+CuME31Ty
MLpFEtNTgahj297Kw8SaCBahwvDYqfQ2wlzF9QzXcPJ9VvkV424eQR18ne9H
FTb5ksHdxeNM/8at17pVuvkzwKNUmCd2W/A/fFvGgw==
      "], {{705.9949, 223.9088}, {688.5333, 221.6387}, {714.5553, 
      238.01449999999997`}, {712.0427, 207.37140000000002`}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxVVG1IU2EUnjORzIhk+FEhTklMpKJp2Yd5snJYRMwUswyj91pSUBJFIv4o
uZrUzETRZmrYUquhzq85deaYHz9ilaKkRY0sI2r2Ibb8AKH33vPWrQv3x8M5
73POec7zvspTFxIz3GUymRv9E+kvp/9SxtyUsp+HiLRi2+UZAuf1bpaOXgk/
3TLQUkMxeI3rs34R8Iy5m5xO8bTGHJi/SCDUVtAwZ+EhUqVStS0RMPG5w6UW
zP8h48T4eA8PA66wtGI5B9k5dRH93RIW6g12SdjQOJFebuZhnkIbPb9ZF+4f
1ckDRa4wxj/awfIXCDjerShdaOOhSqfTpc4S8Xx9Cw9TOYqm618IfO5sdk9p
xnk6JgkI804aeEii7RtGMa5uQP5MK4HZW0cuLfuTf4zA4UDfsyuNPBjVkzlJ
hwj4KGKHvCl/UL5TM7+XwM6s54XyVh5yFU3q2t0EOPuJg/OtrJ/tWE/Tzvi2
on6rTBIW+o3vlLDAr2Xz50Uj/3uqz206/rpdyB/dg/oPxiK/shfrT8Yj/70+
ti8Nxlv62XxxBFJdXa93WHmY0GfFHFDhvl0Wpm+YVE/g91Ai3wsT22cAgf3q
iwt9VO/M0/TzRb3ajRIW9LzSKGFhnjePUe9za7Dex4fMX8Hor2/1PFAryq6G
I9++Orafbcj3Sc/0TsB4WTXqE3cf+4mtZPx3GH85xuUliPNL0Q+eWuQ7U8RD
VozX+Ie1ON+maxIW8qO0uO8xBwHr8aA9bkVYP/urdH7Ybrd7L0iYlneWuHF/
caFTY3Z4cainFu+HajUn+vXVTeZfBSfOM3YD+3f6caLf3haif3QBGP+ZL2Fh
/+YC1u8GTtzvSIWEhfqeVf/jzjK2/zrm1wr0i/IREe9jSCXLbyFQ+zLyu38N
7tvYh/k+93Fe7TMCeZqE6pP1TH8Hnnc34PwjM/ge+DWzuAcn7j+C3YcAH9Qj
jt6HB7Rgij/Oc9SE9fWBeN+TzcyfIZzYT3Q3w6GcWD/Iwu4XnU/wz8YnzP/h
+L4Qq4THlmcGT9skLL5HA7jfsnB8f9YP8SCEF5me/76HvwFMKWdQ
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxd1H9Qk2UcAPA5zhEKDAzsgPIol2nYPCjihxFfuVUog4SYveCM4yE5yUuN
7MYqS+ezc0fUuiV1eHTdpUJxYsJ5IExHDDa2BW5z8ksRNtHkQBDMURwvrm9/
wMv1x3vvfe593ud5vj+e51lyMGcvn8fj7cDnv7fGPWaSTFAQr6gwVtYRCFXO
VIfcp5DFH/X5mgiMx6vYwEkK60LTi2uaCezXHGWH0GnlqZuVlwh8d+h+9dEp
CsYPrdllLQT0DJMiekDhxkSCVtVKICImsK0OLTAvGBIvEzh3z/+5sGmcn430
nDIQSD3jpz6C1sUl+i38ToC3MuVhD5p/WzoR20ngQcDFkpUz+H1VXlWShQCN
F9Wmog092wuk3QSyMoZMcvQu5VZjpZPze0FiY/gA5+ThLazqBuc1zvRjWbc4
j98tyy5zL5uv8uuk+lHO1wrTvE/c45yf8QP9apzzp3ZHTMQUZ7PGxb8yw/l1
xU8BCi/nxr37Q2Lnltn52W47u2y83jGezSuCb08O6jyDnIVpN3Wh6FUtGwWt
8wReWdvHSAZwvSp35vwsgcchtjvKftzPnn/awx8SsKw2HPqtD/Olf5S5dZJA
1zG139+9WO+3WwMUYwTmSqN/3Im++tR2rwXjdZZfZM9dp3DA3e+OHMH6jczB
JnT+LMOUYv6cB6dLTC4K3+R177b3Etjygpt5H53/rkiRgPm/xWccL6MFKe+8
eqGb82L9Fm2Wt2UzWP+26OaqJ3F9Qf7kx6ewn1TyTza7Brj+6xwUHRahX5Rr
jd5fCDxK25Nhaec87fXpZUZu/JitRbGtg+tXoaQhJayTQpy26fQFnL+o8M+g
q2jd5+JL67A/m7+IGj5hojBVUtNdoSfACl/j7TBT2HB8fZTlCoG48PTDYV3Y
P5azpx3Yn0HbMs970LdrAyV3OgjYcjdVtFnw/5zr9f4Y376dQ0Hnrdh/Vtad
3ENAINVqq20Yb+rzYQeuEUj3mdnLf1CwecUF0kEC4g+Oy4Q9FIonIoy9HgIJ
Gz/SNOJ5KpUu5AmbiuBkkdN0ZpbzsGW9rGAe85V3tr5rmCy5VfZr32g/gaqc
LhNF254JtgpxPWFxcK0dndzgohm4H7VSpolkKbw5coTR4X5NP+dqVOgNSS8V
1+B5c3hW1/ov4HkweOpPtBO4Gd1hqkDXSb737sN67aqOscY+pkCClS4BnmfI
faNhFr3m6fK3CjGfjjimwODD+Du/dJkx343xf1U28dRL9bgrXysbWaFeqldm
4pw9Cr14//z/PvoXNIZPvA==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQfWXm6zkv3rU4RO07OX1mZ7JDCXt5x63XLQ7zclq+
u5YlO7C9fHv0yosWB7+GKPvnSckOHXYBodeftjik/fTOr/VPduCasunJzUct
DmK8StvlbJIdZpdqKl253+Kg1Sb8fItGsoPN4y28x+60OGxKUfhvL5rsYHk2
tyPoAyZ/0ZG5B7/KIvh2uzpU6tUQ/CbXh+p39BD8QxcstS3NEfxnqQ2yrA5I
fJat/+w9Efw6u3PfW4MQfK836fbpMUh8vqarj9MQfD+DOdkJhQj+vyzO8E81
CD4svNDDDwBU8aPh
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}}, {CompressedData["
1:eJxTTMoPSmViYGBwBmIQ/TknrNZvZbNDXP+hryscyxys/S5OrFnc7KDQ+jrw
h2GZw/19fHMWz2l2yEhLS1smB+EfntLsYGJsbLyZvcxh4RbzH5smNzs8qhJZ
x/6t1KFJ32eZ1mSIeR0vEfwlBbZc5o8QfKDVDAp3SsH6m4D8tteBO/ZdLwWb
bww1X/hqqUMv2wexF0D+ka8aMfmXSh3yGlmO8k9rduC5vrhA9iLEvFXTEfxT
Asd3/ZiB4L+cuomncFazg8fDKhG9SxDzhedAzPO/UurgqlrKtGsuxL8V16Du
mQ9x/4mbpQ6g8Mlb2OxQI7LO3fEexLzGpRD3PwCqF/rkeH4aUH7WzJkzK8+V
OhiU6yrqz4P4d/sJiPlesyHmzzgKcV/GDIh5jYeg5k9tdtCKAVp4oNThgKWy
V/QkBH/63cntqj0IPsi/XJ2Q+Hh2EsEHhf/x2wj+m8AdckfvlzpURKww1QXy
v2nE9Cs9KXVIWZUQUtQJdf8LiPlHOxB8cPg1Q8Lv7i2Ie7LrIfZvvQAxT7Ya
Ej4ZpyDhdams2WHCoa8aMkcg/rUqQrgXZF9QLqr7X2Wi+pc7vdnh3JkzZ94A
w0Pm5FP7LSnNDmLr3B/eOgaxLzYJGh9A+9QWdG5YmAAJ75/nIfzGeIj+nGsQ
/6TGQcLjOTB9+f+RKL4eC03PjxF8UHqb9xrBB1pXFfIHGh9A84J2yLVq80Dy
wxyg/UW2XNeVpcvA7j+VCvWvVhnYPtMsqHtNy8DuvZsPCc8EuzJweHaUQv3n
VgZOL8+qIenb2LsMbP/3JgQfnP47EPxtSfU3fYHxf2Nxge0r9zKHK8+ztN36
If6JAOZXkHvtJkHSwzEriPt2QfOfhiGCD3JPg0oZOP0unAJJD4tUIPK3gOl/
lxzQQA+IPOMqBB+9fAAA8lnzEA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQfeV5lvaxrmYHrZj+Q1vZyhxcVUuZuroh/FKBMoe/
zr/evobyRSVR+VMVEPwiW67rztplDjInn9qrAPlHvmrE6BuXOURe3vN4Smez
g0Lr68AIizKH6Xcnt7N2NDvUiKxzb7Qtc/D/I1E8vRVqvkOZQ5O+zzKvJgS/
l+2DGEcdgr+6+3aGQFWzwzeNmH4nmzKH+/v45iSXNTtMOPRVY44JRP+uIoj6
rzoQ953Oh8orQe3LhbivX7TMYeEW8x9J2c0ONxYX2HZxlDmcEji+yyOr2cGO
6/pig9+lcD7Ivqa3CP6SAlsu8SelDgcslb1+A/mzZs6cKXm3FOy+hByoeTdK
wf49CrRPbJ37w1+XSx0qIlaY3gW6x8TY2HjzxVKwe5YXIfig8FpShuC/nLqJ
5yDQvzzXFxfEXisF++c3MDx2ybW+3ni/1EHok+N5s+ZmB4+HVSJ8LyH6Vdoh
/uP/VuqAHr8AJ8/q9A==
      "]}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {CompressedData["
1:eJxdlmtQFFcWx12MAUYEFlYx+AC1TSydKBuDmmXbHCQBRRwnRNM8BFxHcVTQ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      "], CompressedData["
1:eJxTTMoPSmViYGBQBWIQrds5d6/Ak0YHo2Se64sZKhx6F/hm/L6N4D+ewKuy
/Wqjg0wc53Vl1goHw6i7H5wvNjq8Cma+rsxX4VCvvHbvhTONDh1nWuN1xCsc
1DhEVaafanT45LdhkrwKgq90u6ngrwmCzyTmZetlW+FwbI6IivlpoP7dIX63
3Soc2I8Jq5QDzdtxetHiDYEVDup9HxhFzzU6VCmeuZacUOFgJOQSfupCowPf
LQkdy9wKB80gPpXpVxodKr52LDaoqHBQmHTjQ/KNRocHAj+lNJorHCpijtwX
utvoMEl03tFJ3UD3b7z4YfGjRoc+5orFBRMrHALcld0sXwDt/xjY6De9wuGA
t2NG9LtGh7YXdgW2syoc6vZph3N9RfB1aqrXxP9F8G9dEnDbydzkcC5r5/Mt
Uysc2g+9VhbnaHJIyl93bXFPhcOcz1xulTxNDt+KFx+dBHSPeo9U+Cq+Jod9
eR84p5ch8eOnLt6QiuArfVDV2RlZ4cAVrJMxm7fJ4UuFrPQLnwqHCw/8u2q5
mxyMflUX2NpXOPxbv/1DMmeTQ0n1raOTDCscmmJK19SzAfUbPzoqpFbhEPes
Y+8FpiYHB8XJBXtlKhwWbnwgpPa/0SGB30U6Q7jC4Ub8/HMHfzU6TGhguZ7M
U+HA8vHIh8VA/14oubJ4A3uFw7TDeuFdHxodhDKXFPxlqnDw/1Y2e90rRPpA
Tz8ANikHZA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQPWv5jQ/ONxodTF4rcIXrVTjA+DLrvHR+KlU42J4+
dr/oZqPDpVcvj06SqnBoEVq898LtRoeghf+uKYtWOJyOrJ+td6/R4Uq48Ist
/BUOze6XPhx+2OggtnluwV+eCod1t2fvnfAMwW/2Kpu97jWCb3nit7L5B6D9
Rem2XYIVDhdDdMK1vjQ65H34dW0x0L6LSgvPKf5odFiV11ewV7nC4RPn/HOO
v4H2zXPUqTSocDDhUgvv+tvo8KZBhOu6Q4XDPe+Pytf/A937NL/ANrDCYfOb
sK6/DE0OQYvOXFscj+DnbNOy5cpB8Fc9OvvcpLzCQURg34fHQP3flur5za6v
cLgW1rN3A9B8LwbfAtvWCof/9+adawTan3f3s9SLrgoHpgUSbpJA9zH4uBfs
7a1weDDzp3L5ZwQ/KYDPlOMdgn/lYGilz8tGB6lArwLbzgoHi3fnPzg/BZof
HVBg21DhMFvKK8MaGH4VqWEFtkD3uOTXz+YDhu+6FzZ+0VkVDsZv8rv2AsP/
xRNmrumRFQ5KmQmVOcD4UXp46uglD0T8WT3WlM6wQvBh8QsAuTjxPw==
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
     1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxdlG1MU2cUx3nRsZZgZqPyEnADGXOxdF2DL1SfeRARqRULI3cTwVIRWCbo
FREfykD68CaQoWN3YYBxxGudZAEq1mYjmWZG0owsRJNZWCPL0JUOp4QQxO4a
l51vN9mH58MvN+f5n+f/P+fGHzmRWxIaFBQUjCcTTwieR8O/SqOpDBIqFxXd
pyi41g9PTX3A4M+FL51pNgpBBSmWn9IZjK441mXuoHC77KhQtZfB1cEz4sIX
FHzOqXD1fgZdXJPT9jWFgbDDwlIOg9e/U5LxPgqKoqXkCU7moP5bUm++zB/t
a3O7CxnkvvxnUypyxJE8Ia8I9fumFJG9FIyznCAUMLict4Eoz1CwNpx3t+bJ
vNV/R9Ijr0t9GMiopRCWMDL384cMEo3rSXs9hTltoZCCPPH5nGKygYLOZmwU
cxnsySVmdSOFgo0NrmXstzQmhow3UShLCiRrkDWzZ0VHM4XKRN5eYmKwfN2n
6G6hsLjQ5S47wOBhdxRRtlLwdxQJKdkyj843ujijzPcve8ONBvR3dYPI433q
a0eFNeifI/QATxiFlsH52OkMBqtqro6pzlL4oVa104x+V66dV0RaKdxV3ZN6
gcEfU28TA+az5e/7kpcwMF0s5OvKKQTe73d/u52Brvo3/1IJBaVfbwnWMzhX
2iM6zBTYdPRO8zYGv3MHzeUHKZx4ssMSvJXB7puHzeU5FO5FXHH7NzNw2gZE
RybqX9plsWkYxE54RO0KCrP7fJL0lsy1vjc02WoGKfst/KtSCvoNv8wpkrF/
b5Q6tYJCsyHdYkM+rhseU1Wiv4eqBScyxyWS9tMU+gafhT9F3mHtcQbXoF/c
gDsM9T6dfxXzV63Mj0ZyeFIvM9etVNegX8+jdSYH1id9/CDQjH6W96dbgpHz
nl/3FKPfWZ/0uDjsL3ttJDG0UahZ1WbP2MTAaM/iSTsFqUulmXhXZu/4ZpN2
o8whfTOSNYnBlmORZPwc5h+6TjOUyOC1FyOex6iXNdhp9yXg/K+cDKzE+TH8
qzfx6I/1ZIQ6FfutXo7RZMcxaNFzfB3O593bTyRvFNbfaRQXMN9WFd8o4nfH
N9vMatRTNJ232+MZdIZSkcd9ylqTZZlBvUvP0vgfv6LQdiUkLg77q88XxlS4
D17Tas0Qvmf+AuHJRQok+rQgvCfzjYqXsdM6mZ++c1Kownwdk+FEifX+TI+U
j/lrS655RLz/cdl2Sxruv3NxN09Qf+ZFhZCC89M5sZev65D5+8ANT3GTzLvI
qa438T3W4xdcLqzXfhZPxjHPoUMPpFGct4abtzzFVRT+/3/5D3cT93M=
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}}}, CompressedData["
1:eJxd021MjWEYB/DSsnOOskaWIy8nL6Wc6AWt5am/irE9apWxPuSktKn18oi4
8nZ0e5mUpEMkevEYEVYn39SWVUvHsTVRrBYrHs1SWaZizP3tMR+uD78v9/2/
r+u6vVJy4tOcHBwcHHlt4DWL14jrKTGhgsEtt1RqMRACS3+22a4w1O0yzHQs
IJypWaZkljJUGYtND10Jg+Hj1tBihunJHlnSEGqWOrXrzjMYwu9IghOh6Otw
bd1phqBUlz7ZgVBdf1mcb1Yd1nfYL/CQam1Wur41myHD0blPnqP6rfCjV/ZS
jaJvvfJqQmjQUb/AHIbzR2xPHAMIN5orxfkSQ8OsAqklhLC57bl5az5DJDwE
XSEh5HuIYsxU7TPl1JSYxXD75YC2z0Iwzcxrz5BUr7wVPdWSy/Dl0Z81oVcI
eUPXxQSe93B2pPSbe216oDKax/Cqca5gu0o4+O5sWOQRBpcdqWXvywlRweVi
AjEsBSThOsH94t2kfTxPUPCSmMoKgtEcMZV0lCHFI7agpJJwUbtXj2MM1tE3
Wo8qwpiFhS0/ztAd/WlRXQ1hfbMw9Zt7cLePaVTmeVmZ2HOCe9XN3uF7hAvb
PtfWneSedIvpryfYDii1I7zfo687tR5NBMOfS6KlgEHX1aq91kJI8x23Jhar
3hmxSnHh83PvdxV01wiLYxco9mrV0xHDVn2V2r+AgElr4jnVQ9F79Mn8vm4c
lASRsNHSYZ7N84SbHssSCBMZunY/nndi5/Tn73w+bnajYufv+egVJ9iC+Hn+
sZoc7oGx+2XV/oRnScl6cGfEbTXm+6ou3+6t2+39jzXw3K8nNJp3aMb5fe4j
dnliHsHS5qOIZ1Rvcp60VpxTbYj/UKspZMh++kJucCeEPxi3VhQxrEzpkgMW
EtqiojTrSvj+aTrlBk/Cry3xelxmuNt60vSQ7+OnhsWKnf+PksKJ3hV+hP//
z1/IjnXK
     "]], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}, {{1, 
      4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxFk2tMU1kQxxsCqFepPNat2dYnJPioWlBU1IuT4geQAKL4iGJ3o8UYjFpl
rxklm7VHrfFVfARvNIjrNsEbHykBfJCwRgwYLEswKK1YrKRYxSxGXEGLUnbH
D+Z8ODn55Zz/zJn5n5m2ZffqwjCVSrWc1rf9YMN4oy7AIC1iv6O/FOH+lDQp
t4+BrTfNIl5EeNC4RMr9wCD8PFj+khFO+hRvB903VDGLmIJwR0yXnK8YLByY
r90+GyF7Z7RRRxxd1V7bEM+5scckrpzM+aTQ7DD8hGA6VijvIV6Xq+5doEH4
/h59dZKwfgKCsHTE0EL8t/yi1hqHYL9lMPteM6g4Pl+QYxGikq561/ZyPv1x
r+J/yzn55y+GE/8w6KpJFjykHygWpdx3DEyRFP9HhEmuxpDmPYPuDfMEz0SE
PDEw5SLVu3euqFUmIZxprfB2DDCIPbpRdCUgpIe3qTOHqD+z5ggaHcLhYIW3
jM6nvl6hnUH5bl+94i3rZ6A7t1jQjEXojPGoMynfvqTRnp5IhOGSccbhb+9b
/Yu+Lozi2ev6tlE9yVvHeRwqBGeGT33Mz9k9tF3Oe8k5wrrIfK+Lwa6O3toG
0i/xZUptzxn4665YQhTfsrTA1v2M+lmxUZ9K+ccWBdRvPQyuBTHHG825u3nY
3aPh/HSGXpCp3hclBbaDpK9MTNUq5J/18krJ2clgQ1O8oJlF/mVlSU46932u
d1QRW4u0xvonDP6tfugwUD/UaY/6ItsYlNdct9pjEAab8qVSF4NnQztEl0D1
liYYdQ8Z/AD6oYhwhMdb2vu2NfD6LoFJ2l3POXZ6se3+bc5++7vQ+moGK7Ld
jn7SRx1t9aY4GZinFYnHoxAW/36zLu4G+TMYcseTvzkllxR2jcGnuVn61Omc
q1rzRFcS5wNKrCCnIyg55YqR9HfHBN7U5iNsHrygPKD4uz40u+MLEWLKZcVY
wyCh80bTWQnh/apDcsxd+s+bPMEjDOFz3GZp3j3qH2ZYQicQ/nMvXJPdyOD0
RKPltzKEYH66eXILny//Kab82c65YKbJpnJzDuT94Uqg/gcTv87efwGhZFSm
NJ7876osdvTTPOJIinnEx8Cu/OqwnEc4sAyVMPo/kc0twaZzfJ6+z/f/xdXO
yg==
      "], CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7WfxkE/zXpPDLq/T1xYnVjgYyYk4zQHy9fRbJt1P
rXAo2f6A7yWQ/yZZx7Yrs8JBjMW9lP9+k8OHF4evLc6pcJCb9FHeCsg/8uHx
j6P5FQ5KN91K/YF8u57915SLEfyE3WEFe8sQfL1bJ55vqatwmHBx7e1SoPmH
2uIa+1oqHHIOVa84dKfJQeaguK1XR4WD+2bPUv7bTQ5lvy/8YO2pcGho0AzW
vdHksGjG2muPeyscRLSknWSuIPiZq3gNT59D8CMrVp1iOdXkMGndY87pnRUO
Tyd/5Dt5tMmh4JZ/wd+GCoebH2qmTzzY5ODHtudackWFw5+oTadc9jU5zKip
n3Qf6D+/SxNXPNrd5OBhO2txQVyFA3v31lMtO5scfv3dsoUxoMIhOf347dAd
TQ41jhF+sx0R/BPsLQW2xgi+xV83nUqNCgflpU3TBYH606bXx+coVDgsUvjJ
17mrySHomi6XuHSFg8Kc/DaGPU0ODqJ3thwUrXC4nP30bznQPdtMjLnEhSsc
dvZHlb4/iOAzrtt3O/Qogr/2mKDh6hPA8MtNseUSq3DYczO49P3pJodnd48t
/gA030jv1l/z800O6/w0ua4rAsOP+5f8rEtA/wh2FdhqVTgkFmy+LXoNGJ/q
L68pm1Y4rLuaM33izSaHuAMXjgo5VDisaTnwhg0YP1vUli3e4FPhEFu77nbp
3SaHU1GZBX+jgOGFlp4A+Swk4g==
      "], CompressedData["
1:eJxd02tIU2EYAOChpm6ZqVN3dF6ajjQVElNoTetVtKJOGimaSRmebpTOhWGv
maw6KiYhXhmIGDmRSqg4rexithS1DCRvZ4o/GoYyQmowNI+k9PnrQD8+Ds+P
97y371MVlZ666CKRSBLJ2fpa6GbubSALuqgRqfEVQoYhls5WsPDOqbnr/R6h
YGFm9QPxlR/+hcUfESTlTZxAjKu5pheDCDuON3EaioWcByr9xjBCa1ITl0+s
PrGcLPsi2r6/T2r9KnoArLHCOELxZgwtJ3areynNm0AIaTxnqCX/7/emTY5J
hESGX90g9aVTJcPN0wg9Xc2chnhJW2D+NINQltnCaQJY6KkI1FfxCIfWif1Z
uNQ3EauxIvQqyxrz/Fg4nPtcaiR+zcXTLTtFm9MYQ60PC8d8ynmTDeGkeyTt
jBRdF5VtqI0W3V4jUHdIvsm/dp5JQmB+dg9dJfnOdPQ2h8cijHasUzY5C+OB
7vYbkaLji9d4Jkx0tM+cOTUYYfZNli6JxDfI582pCoR1h0DZiM+Xb/JMAELo
nu6hepIvYU4l1MgRJndl6tpI/531+2RGPwTl7B9KQon+ptCerQ4S7fiu0EYo
Sb8r5ZnzJP52fAM3F8JC69gGzwQilA4e1bWFsbDwsLpwmSL9TrnE+KpYSFsL
FoZDET4z/Yu0mgXzlMXkUCPcal+mLGQe0Tdb9CkhCBUrvykLmVfnusRq8kVw
Jlc+ehzOQszsNisjQ7DrG7gKkm9kZ5e+yp3cr6VFjyxS34UjB2VGF3K/KpXa
wa3+GC+rSYIQE7+XnvIVreCNXIW36N3mp0Nj28n+E+5lKl0RTo9dNoxIyX4m
S1Jkngj1NrV20IOFZ9fz4wQvhK5rrkEWd1KvW4SQIRfN3R81OYJF0zkHlHYV
QtGTgelKEv/LlB4nkH3a1Em005PMC5f4SA3C/+/lH9YyaSM=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 
      3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, {{{
      619.3637972884001, 397.3368744761251}, {618.9137973064002, 
      395.439999552}, {617.1856723755251, 395.439999552}, {617.6356723575251, 
      397.3368744761251}, {619.3637972884001, 
      397.3368744761251}}, CompressedData["
1:eJxd0mtI01EUAPA5e2x/apGSq/kqe1ipNaw0zcVZjXw2daUDjQb5+qDhEIeH
Fdm8QjjCyTTNfZDq3welqD7MfPcQZ/lPraxt2IRKySwqizScFnX79I8+XC4/
Lufec+45m06VagqEAoFgF11/948flhksSgKPvT/E7hKEbcO3QrsPEQgoLjKp
KxBUfb6G9MMEjD6gi6zk/aX3PKuv5p0y+vD93hqEOXVsaz+NDwuO1ZVcRMgq
a5G00fuNbW/E0lqEYHdyVz0QaOn0U3AWhCHhSkPpQQLyBzdcbB2Cdt6pTDjA
e9QmMqxJIBBjLGPvNCNsdyyV707nfSbJKhk6xnu/s1lSk0TzyanS9+1D4Az4
qTCRwJWzI3ZTBIL/YJHHeYQAfgvwOjbzHus8qTCH8F4cv2vVyRC2TPbKI2h8
XY6c0UoREmX0nLox/gmrX4fwrD6Lq6bv2WSFCrM/wtXPBZ5LybQ+8x6myQ+h
M/yyRJzKm41oDbWl8fZ2ZHIqNYGbMT3W1zS+e7hBIs4gwNVyrD4AYSosqOl5
JoGZ6XG7zwaEfIOsKfM47U//gmsqGCFhwCKp0RLI3hjOSLcizC7eV/7MJdDw
O5LRBiGYRna0TmYTEM7POqxrEQYzZvLuaQh8HZ6yKxmEnuqlcgv9z5wLInfe
CoT1ixoun+bXONBuqhUiPDqq6npB64vOW+VmBdSVT5UTKt7vrt0ONSp5vwo5
wQ3Qfk5HV6kDfRGuf3+p7KX9Sxk7rWBECC6x9VdHPIFzc2/tPqtpvg16T3sc
gZ2pFepcf94aVxQjDfzHZVLvctqver1DXkzjF0QVusgohInwUo+TzgvY0hTm
OIT/5/kPpjpITg==
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}}}, CompressedData["
1:eJxd038s1HEYB3A/G5dr1q5Oh0blkmMz1i5r39szi51+MGaY/rjmKvbNj+8Y
HpSmD4pu8iuXcVLfhJGJplv5VU1G2u78XqRVrF9mRKaS9fnv2/rj+eP11+f9
PJ/ncY9LiThnbWFhYUnrMC0rWjLNmkmlJ+CYWsr1uCGcfZ+s7ion0BTl9nNg
F0LXSgUbU0KgzlunaRUjOJZqlR7FBDZWx3jODmE0JVO9XkDATXWPY6wRelQx
8so8An5ahyneAsG8aWveuig4yfNbm0uq4KO9bw0tiQRYS9spfrvgaWZ9kncX
DNdXJnlPhESy1OaSROBa5vAjS1+EEbGjeYu63SqP61EipEkYG79MAoEgZURF
CGxQK+vECo5VozLoAoG7r2ftpyoQyo5fVUclC45aMuY0cwS+PthSBFQiNPqL
zSqaNyM5kPtDfeZJAzudRmD04Q5m+CZCg9evPp90Ag6ntOXvqhDS80VmVQaB
vQAccwsheE72IYzm8fN3Da2pRtCYOnNCkECcNCyvpAahL3bCoMgi0LE4YS+t
Q3BbWO8TZxMwHVuQNdUjnBd35Hyhnos+qFnkad6xbebeHGqP2smPjQjd1afl
lXS+c6uOoTMtCJvPY+Xjlwgsjg/aSzsRIsJszLmXCYiG+u31PQj6bK0yqFhw
YWk1u0H/TzIjZkR6hND6ItZoEOxVFq20rRXmF5cXrwzKFyypGjWcoO+ZII1j
TiIkzAfYfKf5VJo2ngOEfd256t3Uy5Ebn9bo/wS63mGNtJ9593Bm2A9Bm/tC
F0s9u9RcftsHYbVt3KCgZsODvbMOCa4KkYui5f/YDpwT9iDMm57p3tD+JZ9H
+OWdCAOSWvbIFcEpUfHKgnzBEXykfK2QQPLTV3y7BIH7rVUWFBE4EDfE+zoh
/Kh8rJPp6P7ZDfLtzgg++pcGxQ0C9/tzNa10H6VWZayR3kdJ0fLkfi+E/+/n
L/+rfvw=
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, CompressedData["
1:eJxllGtQU1cQxwGhklSpoygqVKsWeZjQ6KA82thNQaiMBgTq2FprABFKAS+i
3gM+wxkUcUTLVaBIK5KIFJAiEywIjPK6VMpQ5JEoDwFRCVSjoyjEKbbbT5lp
P5wPv7n37Nn97393Wfie4MgZZmZm5njC8FjgGduRzfvzFCbuC3QRlgTcl4Sm
NDZRiOmTCLMXEJAwvgkVDRS6O9o0ShGBgZBozvYWhTU3B7Qr/Ajoxx0Dg+oo
OGy40ZwZRuBkxx1jcg2FDy7EKDP2Eqi3jOXO3aCwvt4gsEsisNy5y5hcTYHp
DWSmjxHYfCKOC62iABY9U1bHCfgs/1ix7FcKZZ5HVJI0AvThUXXkdQpNq7Yr
M04SsJ6atD9cSWHT5Y2MNJ1Ax9cqPkpj4nlnKnVVFSbeH0PVjtco5L8s145g
vNeGWeKyXygEnD2qkuB7bGJW5boyCs9FcuYwxfprivioUgo54eHK9iMEVvE+
Clkxhc9W12pXEAL33swTu12msPvRuECH3xXfPRO2FVFwjbvYnIn5ZTg9FYrw
fkXJs8XO3xMI/2i2WI7v/ZXfJ8g+T8DDQxzIYH5+WS1TVrkEPOusxQasx3BW
ykjzCETWX+Rbqk0cd91SbKgxcVvHtpRG1Nu6RChtvUDg2Jw83v8m6jeo1o5g
vHHnaC4U+7NgUZDSBjlE5q4Iq6eQ+9BtZ2kOgdovzcTx2M8OmYypyyLguLfN
mNxIQbusX6A7h/rm5/BR2P/HfxsWO2diPiO7OPdmCm/7klTlGdjPlasV5uiX
hVWWIq9TBCqGIzgN8vG9LvLtJ7A+22mRvIWC77t6gR3q+WFar/AJspm6sLkT
9XozVKjL+Y1Cg4OZfRHqWb0knAu9TSF9/4Qgm8Hv/mHcuVYK8ek29s4RBGIN
OmHb76hfwTWN+RcE3pvLG9+0mfxXsVajd2nHfvQJjBs8COQW9whFf1Dw7m7X
KF0INDGuCvMO9NPPIqHOgUCEvWfC3B4KnUZfUdIqAvusLNbvvEdBvmeTtNWL
wKRbGj/aj/4V+khb/Qkkb7MJZIYovFB7SVvx/dvi87qpBxR2OfaPTqDfH5U5
KJQPKSSfcpUGxBKITtCLbB5T+GqfuX3RAQLFwXKuG9kmqbB57lETZ/ywSJqe
auIXnlaipH/96qcXyZHf4fKaO08TmOXmoJA9osBfGRRknyFQMD+Ic8f30mqX
y7ejv8RD46J4zEfv58tIsV+lp5+IDIMmNsQHcxrM/7h+PSNFP+zsYnn/Vybe
vPsAHzWJ+nPF2gj8//HWOmHsSwpuiTai6kMEfrzzk15goJASmqjMiCSQqF2s
kI1i/h73tCObCGgiJAmZGH9Idl1V7k6g/22pfuwu5r8gQX4B9X5y5Szvj/qb
aQQ6Fe4Xn9VZ/Ezsf/S1RmX7UxZsn9XqXdCfZSnp0oABFhTDluIy9LvW6Ruh
XRcLForX9gO4D7x3/Jm5tI2F+2MCsRvOu3eVIXNpCwsTRz5VXCpHP3tGC+2a
WLi9RRLYcZXCysk8aWs9Cwfd54jbcX6DtnroVLdYEDgNGnOvmPjOqXR1aqGJ
B2TfpvjgfDc4ruQ7kcUbD3LdKtwfTTPUEox3KOi0OrKAwrGIYWUGsmtIp37j
JZyv2cNKmwYW1m4JUCjzcV4bLNTlyJ+XDBt78f4n3jXM9BALXiHF/Mzi//MD
6/l8cC8LDbZrAiUlFNY9r2emtSx0ZcsUyqsm7u6h6tRyE6vvjwpnoR6KqzMq
6/E+VMRxtrhPy51OSAMeYD2pL+3fr6VgUSDkO8dYiLEt1d3F/bBwcEglecXC
f/f/P0V15wA=
     "]]}, 
   {FaceForm[{RGBColor[1., 0.38431370000000004`, 0.21960780000000002`], 
    Opacity[0.4]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}}}, {{{
     422.20189999999997`, 280.45169999999996`}, {422.20189999999997`, 
     302.1734}, {439.81080000000003`, 319.7824}, {461.5326, 319.7824}, {
     483.2543, 319.7824}, {500.8633, 302.1734}, {500.8633, 
     280.45169999999996`}, {500.8633, 258.7299}, {483.2543, 241.121}, {
     461.5326, 241.121}, {439.81080000000003`, 241.121}, {422.20189999999997`,
      258.7299}, {422.20189999999997`, 280.45169999999996`}}}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxdlE9IFGEYxtc/YUwXzWMmSZBoICy7qZirXyGuigxpwYJURFKikH4zCoLs
ENsYhkaI7rrtttXmmMKGESZ2qYMJ7ilNMCaDguiw4MFblw7Szve87DAeluHH
+3zP+z7vzjcVt4e67+S7XC5/9mc9+11DoXCZxhSfZG7IKsuPHz9VU+/kX7LG
miXTSHaqzNIv3NLYnsF9PW0q2777LTOgQl/aApZCYN0H/fhj6FNe+B1G4ff1
POrhJOrxMypLeOZX/Ysae819UlEp/P69AU8cg373LTj9V3HyHyf71xXRb3AR
8/QaCrvw5aL8KqKxE6bBT0+Sfhx6kyusNlsvGYTec1MR8wS6iLvh98JL/q3w
c59EnisMXLIfzLE1//6OzZZf+pOTl5ZtFvuPBUW/s9858kfBvVtc6CuzbO3r
xyYX86/OBbGfdS76XyL2f4TejOD87Bp4NMtW/nvv4F8dIX0KfoXE5oLNYl9J
Jz9/in6/yX9jBn7xKPJMP0G/vhj0NybBRQnM3zEB/dhL9As8hF+eAR7V0S+c
onwPwN41J7esoL/BOd6vc04+qKZ9hdA/7aG8OupyA81L/UNNqH94RPrLmP/n
FDjQinrdNPTudsofgV95J/1fz+i8DH82j3pNF+bpSaG+dBX64RXkuRYAF3ym
vNehl/agz4SJM/Q+xWifh+C6BM6/L1ZzLPKW22zlWa6i+xtHPepWRZ6dOepf
i3rHLFhvwP0bmaK8jbjP8n2brfMVejD3/Tj6ffkPR/jeIA==
      "], CompressedData["
1:eJxTTMoPSmViYGCQAGIQzTSLQ3rfjRoH7uuLC2zjCh0yGfIbU74i+KZnrf0m
8tQ6LC2w5RJPhMi7yNU63ARKn0ordJhjvGjLd/1asPraHIj6QjuI+vBSCH+j
J5TfCOF/DIHyeyHmLYmF6O+dXehwPu3q81PJEPN/rYaqz4Twq/ZA1LPkQtWf
Q/ALbbmuGz9ClV/7B6KfMQ2iX0qgCGz+r3CoeTJFYPeze0H4tzSKwOovGkH4
XPoQ+XAhBB/sXmYEH2Se1ZcaFL7UE1T+rs2I8EQPbwD3dqYI
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxVk0soRFEcxmeIZIVi58rOI2RBaooTGyWLIaU8MsICce9lDEUyNR7RzCAN
IyMmiYXH7pLGK4+MEmKSBhMbJiw8s5jce7+TMYuz+PV9/+c5J766uag2WKFQ
KMWTKZ4g8SR9WtzOST2JM3jVCckc+dqpWQyz6kmxwBjKYjki6ffjeiLKQmUU
R3ZN6boKkdcYgzc9nCMVic4Il0VPntUCExIE/6gF+swP+8dS/rB3NkDXPLLE
XO7LC58AezysnO+L9tPvhv/ehvqpV9B1dviVLlbud2UhkIV5+Jk9sLkqkPur
0W/JJSvP81EHfcmFegX14Jcr8GAj/NFu+C+asB/VHfrZZOG3PSB/Pg/OfsJ8
Zy3gm1f4c7Tod/UTbGrDvIIPfKuDfhpK99uB+toYsK6T7jeF6lbEf6t46FP0
vorBBzZ6X3WBzLX6WYpv7+blfnNpPNPHy/NkWVG/dhD+NAt0hwm8PIJ9eIfh
F4b8LOWbNVK2g48u/Cz5785Rf3wEev0J3YeZl/edcYz6Y0ba3xF9D0OILz1E
vusB9DO9T+fvRXz0Hs3Xw+M+dzF/ZBf4bRu8rYW/cAv+wwbkX3HQ96mBPrdB
86kRn7yO+gUq8P//9AuPMK11
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxVlWtIU3EYxkclIRplIBnSdNDVbCBkF4x5lmSGpk0nmrdQXM0Wds5yoViQ
kJtUCH0JYSZJWsJEXWt61DEaXTBGlkloqPNWsVoOpT4EQeQ5z6uHfRD58Tzn
ed/3f5ui4mquboNMJjOs/gn/T6r8n7sPWpglDS+PruOYro5sJi3JwlgCGr6H
5RgTF7tlJNnCxDUGNC0XoacctzCD8sbAWBHHTE80XOs5YWHyeHljRA7HCHk1
qfB3qaA3q4kP4HvrKdRzyjhma4TzyXw66o3+YkU9LwOs9LNi/eUz8H+aYcW8
B5moVz8Obj4LTvHCP5lD87xmxXxFLvKCbuQ7tOhfM8SK/d4rgK4awPdsEfFz
+B+XUX921NtbSXm98OsrUD/QCn00SWJBj1GiXtQz5HkTsB6F1K9/H/LcNO+5
eNIPY33C46gfNdb39i6aLwu6Jxb1prRY7387aX1Lsd5TO5DXVIn9LIyGnl8F
v287OLkaumwbWMehnisS/NWIenXhyKutQX59GOZTm6gfmcRCXvySeZ0Ff/Gc
WZzHt4nO06xZzOP/Yv2u+8D639ifSB/8wSDtxwz0pu/gtFUW5vcuwv9zmvJm
sJ6P1ngC56FuGv7ijxIL/bW/k1jwZ7yh/aP8uy+Qr/WBDS7Ut86CM3n4b80T
O6Fv/EJ+B+Yzf6M8O/Jaf4CtfdDTlyUW9JIg9d9G69MZytVPzevnUdxvG81n
xzxJvWZx/zodYM5O69UP/7AD868Mol6Hk/p3I185gHqTLzEfz4Nr38K/ewj5
+R/ANcPop3oS/MpF+zUHdrnBMcs0nwd++WY6b7PE0UboC+CyRHD3Ir4fUUks
zpslsTCPpwCcuADddoGYzltMpVGc7wjtd4veKK6PfYLmvQy9bUxiYf6mceIb
8JcrLCHsOSSx+B4dxX0or0f9jlTcJ1OtEffnNO6v1QT//my6Pxx0Wx7y9Ab0
ozwPvV0H3VsKVpShfkM5/H4tWK2D7skER+nBnBq8UgX/n2TwmAH6/QSa5wq9
R3KJxfMRFcq2Jbwnqkv0vrzH/T9Wgu8z+um+a+i9foj9jlTDv+cOeO33KOxm
KAu/T/8BVRsbjw==
      "], CompressedData["
1:eJxTTMoPSmViYGBQBGIQvWKJn8NrlnaHt4E75FonFzo42b24uUQUwS8tlOa9
oQThs86AyLfoQPkLCx1A+q3NoPxVEP5r23aHnXKtrw/ugKif4tzuEAw0zvps
ocOd643Fdp7tDvKtrwNPPISoF/aBqP/4HcEHye/gL4LzQfq7JSH82d4Q9YFK
EP5qL4g8t1YR2L4jnhD3HDUscuDn3rpsoke7QzvQOD0LCF/QHWK+hy1U3hVi
XqJTEdi/K5wh/IduEPNCHKHu9YKoZ7SHmLfOD8KXtIHw+YIg6udYQNS/CIHI
a5pC3HM1vAjsfzVDiPp3kRD3T4aGp2k0RD2nBsQ/1TEQ864oQtTLxUL4XyQR
fJB554QRfJD+QF5U+To2VPnCD23w+EWPfwDGeepY
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGAwBGIQPVdw6d7MvgYHruuLC2y5Eh3MVtuFB09ocLADCegk
OoDkLac3OCwDyl7XS3TIvFfYZTYHIj/BEiLvOR+if64PRD5tEUT+QnyiwwWX
Gx++LG5wuAU0PqsRjb8RwQebdxjBB5kXex1V/sIbVP1c7kkOzBXcKh9CEXyQ
ewJ9oOYzJYHds88doj/gUSJYfYYLxD/bj0Hc6+cEdf96iPkmDg0ORUDvNs+A
qNewh8jLtiD4YPOLEHyQemdvCF/AFWLfB2MI/0EAIjxB9n3zQw1vYXZUPjcn
qvp1PBDzk/Ug7pMRgLhf3AQiHyYMcU+XLcS+CWIQ9crukPj5KQn1XyjE/Mmy
EP3fM6DxqQgNnxqI/gA1qP/mQN2vA/XfSYh5gXOh9l1OAfMb92HyweYdSUSR
z5oPMW/Dfqj6Joh/eA5B1G/IhajPPAJx798IiHsXH4e63xMiv/M0NL3YQ8y7
cB5i3ipTiH/irkD4XvoQ81NuIsITZF71dUR4o6d/AECXVB8=
      "], {{523.7336624999999, 148.1325}, {532.03756875, 148.1325}, {
      532.03756875, 155.20593750000006`}, {532.03756875, 156.1715625}, {
      532.03756875, 157.37859375}, {532.03756875, 158.82703125000006`}, {
      532.03756875, 160.28015625000006`}, {532.03756875, 161.3278125}, {
      532.03756875, 161.97000000000008`}, {531.53131875, 
      161.97000000000008`}, {523.7336624999999, 148.1325}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 
     0}, {0, 1, 0}}}, {{{598.4169999999999, 321.2573}, {598.4169999999999, 
     350.2347}, {592.9169999999999, 350.2347}, {592.9169999999999, 
     321.2573}}, {{595.6669999999999, 350.2347}, {609.4169999999999, 
     339.2347}, {595.6670999999999, 366.7347}, {581.9169999999999, 
     339.2348}}}]}, 
   {FaceForm[{RGBColor[0., 0.6901960999999999, 0.3137255], Opacity[1.]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0,
      1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxVVFtIVFEU1SwK8acYJELESkyGEmq0zNJOWVpEiZpEoPlCETNfx+ckPq8y
mjjqNOr4nHEcx5wcjTBEQsMsQszKLE000oQgA6mcgsLo3NaBWxfOx2Lvs/Ze
a+9zd8elhSU42NnZ2bMTxs4mdsKz3BtH+wQyELykvFRPyfhdr9TwHgm7nfwS
f5zhYdfy1Ze3KIk6/3TrhlkgtWM2z4UGSgpe3LuiZdhboVDQJkqcNLdLD5qR
v70Z8exugRTIrMFLDE+ppt/FmCQs1ovvkrD9gy07vI0CcWbwp46SCvPliWmD
QM4uKWVenD9Dj/xYVt97zfdMY7tAkhITE4M0uH+6VSBOs8b0xRpKTjxZGFzX
QU9WFSWi3qIGgYzbPCPTyhBfqQP/VD4l59qKPTp5/noQJab9gS6WZoFk+jvO
BhJKkvak5PW2CEQeqR7THqOkrvCXn57VmzOm+3/ypWR4vmpD28b7OYx6a+2c
zxv+9eklLPa7YpCwyC/n+ud9wF/M/FlWyqzmI+B/bYL/BUfBP2pGfUd/8Pv3
wv/QU4iHWLk+P0r6HT5Wz7F4xWroUIAC/mvMiFsPSPVEfhc5+K4bwFfnQUlL
RIcliumZmmSfO/wKa5Gw6KesScKiHqUWfj/3QL0yDfTOyLFf1cz/Zp1O99YL
fMtqPh8f8Ak13O8AxA+p4M9wMvpZFDh/AucvQXxXHPDeQuxDWzT4NucJJGzI
tfzmPuh7dk3CYv6rHMzboZIS5+QL39pzUT+iVrovvh23Bgl/94xUxzVL+Kp6
zLatg/uZi/eh6MS+5ubwfTdCT2Y2+lebsG83KPYnsRvx+nQJi/OPyOD9WjHf
tFIJi/W7Kv7Hl4ow34spfF9LsC/yVLzHhwLPz6Tkx0qs4b4K887IR/5ANfTG
FFMyF50T8ruW+6/Cfb0W+kvr8d4HdYj7tWL+E63ov7sTfO/Z/nwOHXJ9bIIe
mx71V3vw3r928v20oJ83XcAjd1B/pJu/Lyv2Z7KH738/+rGzSFi+UztT2Sfh
v/+jfsz3gxXzfjQgkC4WbuR+/vs//ANiUm4E
     "]], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0,
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}}}, CompressedData["
1:eJxd02tMk1cYB/AWvExcRUSBAZuBaheCLUwX7QzEhwrGgNxrUSoolFdGE1Hf
w6CZ60jHGZlMwQvRxjGIWi1aBFEErygMpmC5Wl5uyXAM5gLVjMu4qCV79qnJ
PpwPv7wn7/Oc/3OOT+rhOMaRx+PxcW3D5YBr7igxnXxGYXqgg8tbQuDNxocn
PkA3KQVGsSOBiDHTMeNTCh6lj2I1PAIueplGjbZefMmpFljoDevPEqOfXHHc
F/2ehXsl66ZWoGviBlP3vrW7sTx9XDdnt9xLHWX6hwWzz59/FaHTXqqrDVMs
TPhnWE7/189sxurMSRbcNlsfn22h0LlP6Rg8wYKxdMug63MK4Gz52vA3C1eZ
CNGqNrvXu0aKZGYKTr2XjwSPsZD7gtEk1tpNYMHFii5JiC5icb9klFkzX0dh
0ZCusRmtZ8JO9dylUPyTdn0A1qtuKPlOd4+C4qTsbiX6cOjrrYH3KRwwz3Ob
sL/5CLXVjJYeL9gciP1H97meT3hAYfiXae7yNAvhP9YuHUUXLCTnuM+wkLRS
Y2Me4veAxb4yzCM/fY9mAD2W8IoTvmOhql46FfWIwta2B+7LMV/BaWtWD7o+
47a7lwOBst+I7VA9hSxxOxe/lEDDsKTVCfMrbbk55hJLgNTFH1ehPbOilM5y
AnOKKo+raJmwfUe1gkBsQ4imG72qN+DG7B4CMXFtP/Mx7w19eWXblQQ6PM8G
foSW+lfov0iyO6izXN+fbHemWK7tSiGQmP3Erwz/N5ItpOMqAkfFXt6mX7Gf
CrcbnzIEfhj5akVdMwVDwPuUjINYf/dn4s+bKKybyAxySifwPDdS49tot8qg
to2iN3yfElRwiMCkyybRQJ/ds8mn7uxCJ1tUTDbuz/7wzJ1veim0un/pIEAz
M6EXzBzm4x2urcZ6Td7XVEFoxfAyToUWbheIK3rwPOUtEjd07UioTYxe1GxZ
fB371fJjLA0WCpVSf+VadNgnStNutKJCd7M4jcBr32DR2xcUakMS5T143hzn
mdAqdPtczY7fUwkYfcv90tEbbfzmScwn71KS6WN0frwwvPIAAUGRW2t3N97n
dx6c634CwZeeVRag0yZ4b77FvJ8W6tq2oW/lDEnycR4meYhosgvrFdbo/fYS
KPLk5xrQS6aOFXbjPKVr/5jfib6lNUaOxxO4kvrq3FAnvjfJFo7E4Pz/977/
BeDa51A=
     "]]}, 
   {FaceForm[{RGBColor[1., 0., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}}}, {CompressedData["
1:eJxTTMoPSmViYGAwAmIQbc3o26LbX+iwrMCWK/xbosOMCfxV05YWOng9rBJZ
9yzRwe3Ghy+nNhQ6TDr0VWPOSQS/TmSdu+J8BF9snftDq85Eh9OHndZ6rit0
0IrpP7S1JNHh6qxnsu4rCx12ybW+npiY6HDwzTwbnyUQ8/P8Eh04zkkG/ppT
6AByi4N9osMau/DowMmFDo+A1rObJDoYaq0U3tBZ6HDsq0bMeQ2o++oKHcyM
gUA50eF+YVcfSxGCrx7MuvhTJoIPUn8tCeKeUhWoeTEQ9/5Sg9g3MQxif4Nm
okO+ScN2hwCI/x7qJjpUcqto7PMsdGh7HbhDzgTi31VWEPUMGxIcUmLvuB1W
RvDB7vErdLi1uMD2lHKSwwGgf88EFjpkpaWlqbkmOYDC+20YxH/HE5IcAtZP
Sc2IhYZ3WRLYvMfJhQ5FtlzXF/ckOfTuzOb8mQ3xf//cJHD4riwtdHACShes
TAKHX1Q9xL2JW5PA9h/pKnSYN3PmzMjdEPNfTEfwQeHfswzBb350fMbtjdDw
3ZIECa+dkPDZtRxi/82DEPcvmwWx79bRQodN7kAHdyD474DBw1qA4IPSS0wa
xL2aUPVXoiHuOXEYGv8BSeD0kX4Ikv7EXSHyK/ZD7HtmCQm/nt0Q8+7oJTkI
Ld17sHw7NH6UoeZthKY3ySRwfNWtgvpPIMlhUfrmV8aLCx3OnTlzhoc9CRz/
BrOg6fc/JL0UQdP/9B+JDuj5AQBv7F+b
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQvcYuPNqwvNBhWYEt13XmJAe3Gx++dDUi+NtEf59+
11Xo8KhKZB07Z5LDv2+lD2ImFzrE9R/6miEMUX9qdqHDvJkzZ96UTXK4X9jV
l7Ko0AFkdoN2ksPpw05rNZcXOkw69FUjxibJYcYE/qpvqwsdlFpfB1r4Qs1b
V+gQtkOudXU8gq8V039oazGafHOSQyW3ikbcmkKHOpF17g/7kxzyTRq2J6yA
uDd8RpJDSuwdt+QlEPvuLEhyUA9mXVw0r9Ch7XXgDrmlEP/0TUPwwfq7EHxw
eDRA/DNzJkSeoaLQ4RjQ+f1NSQ6GWiuFL+QXOrwDKm/NhtinnFnosEuu9fVE
jyQHjnOSgb+Soe6XhLi3LgDqnoxEsHpmIF8M6PyqlESHqDaLa0f9Cx1uLS6w
PZWAxo9F8EHheSAi0eGL/KX8eKB+r4dVInkhiWD/TQosdNgENO5KAFR9EES/
l28iJD5DoPo9Ex1eeuj9fxgGcZ+pW6JD785sTstIiHt2OSWC/esQA+XbQ+R/
xkPV2yaCw2cj0H92XNcXb7BKBIdnXgbUPZYQecM8BB+cfkoRfKGlew9+r4G4
V8Qu0eHAm3k2Ps2Q+Ex0T3QIWD8ldUUnRP06oH+uznomu7wPkt5exELkPSZB
wlswH2Lfx6lQ/zZA/T8dqn4ygg8y791KBJ/v+uKCv/sSwenz5BQIv/Y8xLyL
fVD33ob4/2YHJH3EPU8Ex39AAzS9vU0Ep2ezUgQfPT8BAGDvhqM=
      "]}], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}, {{1, 4, 3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
      3}, {1, 3, 3}, {0, 1, 0}}}, {CompressedData["
1:eJxdlH9Q03UYx0nZYMQQmBYDQqD2gx/hSYTdZvUgbgp6Ip2VoUefQYiHlXy+
mN5IKE9FRNqOBQMMcCh0RznCTmFHFyejKSMBG2wyfghya/NmEWJqTBp9/AO+
Xn9873uv+36+z+d5nvf7eSKyDr6Ts8LDwyOVPE/fx6Ky5UwvClz9u5VZHQhU
GYcEDd4UBA/+cONGDwLpcJVd7UOBc2L1awW/INgiV9kTfSnwe993XmJAUJ2S
JyhmU6AQqcMk1xA4uJv2G/wo+FbnuTftOoLzXS0HTKsoMKn6zjCMCIwbGtc3
+5P4Roc291cEf7XVPD4SQEHmoudNYz8CTD1vCgqkYKCVq3PfRLDz6PzVU4Qz
b/H2Mc0I5ENW8QLhsrMvxHKtCPwWU+SJHAoipd7KrNs0R4+6FNM2mpnfL/Sm
OWi+Xb9mR4iT5vYfJWGSP5+Jl5XBLJyluSFuld78gGZ+0Efpux/TLK2r/+d3
F82qdzWDp900+2z+2JK8QrbMxfFvTPzLeIYbtgrrWDT7lNZ3hLFlUFGxmQM2
vMzKP7ZwNNMYLCcfmkq8ZTBS+eY5xh0Mqn3a4N6VMvikjNeRP4lBGm1QTJP7
n/uSPTg2gaGstDvYm+TnPlD3d944BlfIKUvyQwTZO0yCsDEMZ21r9FWkXk6x
y26xYhBpm7SOewia+CcPDo5g4PfweG+T/nG2Ut1ehDP4tcK6aQQD7ennJLfI
91fuJ3uS/sd+mqSwWTCYWOEri6w0L+m3xKqo8jDeU/1bFsObRsl5fifkEj99
FnFU+jKpb8l/8yFjZsMUhkfCvUr9FQQZM9tOsC/TnL6rIkd4hT6/ye05sdiO
l/2qmH2wv1mHwb3neH4Rib8hJpPF7ST5pDw5cY/4dSqnt6X8JwydiQW1H/Qi
yCtlzfj/jGEubdZR2YfArIqwNHdhYFZR+fXEn+XOmFS4iqH1kNX/EvEnI9DG
WOgm/69tLBweRpDESmVZezBEq41ar1EERR5tvu0GUq/v3JRokuiRu9bx6DoG
tf5JDNeOoH9jTc03fRjidXbF+RkEk7oC9x0yT29x+/jjehnUrkuQX3uJ5ldd
I9ViAZknHlVYSfRZ4pLIwxfaiN8vsMPlJYTVztGqcaKHMqFVHCok/i/WpAeR
fD7fs9F9iXDgxVTeh0SPBa3IfSyKgjmGK77gNwQBsS3i8mgyD2daC3cNIBB8
96JcHUPB4YBs/etEr9DGu19MxVIQNybRDJF+3fcP3ZkXR+bp7nur48i8Bw4k
XZxfR+avYrvma9Jv89ARrnM9vT9EkV3V4gR6v/hYj391OZ7eP//fR/8B19gd
8w==
      "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQLTEnQ92Pr8hBrXtaStq0RIfI8vp/hhxFDlmWgUeE
mhMdaqxyK9WYihykfNV5tuQnOjQ8NZyh/afQweiYhI1XTKJDy4Rv2wy+FTo8
uvmu+bVHosPy4CeGqh8KHb4FPdjcaJro8ELvNwfnq0KHOsO3p3mUEh0eM+X+
UxQswuDnTczqO6SF4HO1h370Nkbw/YTWfVlhjeD3zWX7weqC4G8y8n110QeJ
f7HxNE8Ygu/FPftIUDyCL7bThMckE4l/22/RhmIEX+pvhoVuHYJ/yvya8v5O
BB8WXujhBwAxpYvX
      "]}]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{0, 2, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}}, {{0, 
      2, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 
      0}}}, {CompressedData["
1:eJxTTMoPSmViYGAwBGIQnRJ7x015R5GDVkz/oa8aiQ5uNz58WbWzyKHIluv6
YrNEB0OtlcIG+4sc5s0EAvNEBxtG3xbdwxD5x9aJDiD9i48WOfzSiOlvck50
yDdp2K5wosjBDqjdwDvR4Yv8pfz4k0UOdSLr3BdGIPib3B9WXclG8JcV2HKJ
FyP4IPOYqlHlpzcj+F4Pq0TWLU90kK1JNPraheCD3OPcXOQgts79oVVPogPH
OcnAWfUQ9ybXJzpsE/19+l0NxD+RJRD3OlQXOUwC+l4G6B71YNbFkyqLHNpe
B+64l5jo0Pzo+IzdFZDw2RqJ4IP9E4TgK7W+DvzhBHFPaS00/CwTHQLWT0l9
0YYIT5B9Ca2I8K7kVtG4543gr7ELjy70RagHuT8qoMghbIdcazYw/Ht3ZnNK
Bhc5mBkbG2+2hMTH2lCIf6tsEx1eeej9d4woctglB3SQY6LDv2+lD/5EQf3n
DrUvFuL/m36JDldnPZM9ngAN3zCIf26nQMIzLxnCl86ChEdcKSQ9CByBhvea
JLD5c+5h8sHhXZwI54PDKwUS/n33IfEvEgkJ76KHRQ581xcX7A1IdJgxgb8q
7DEkPEo9IOnx1dMih2NfNWL8naDp8WWRw63FBbZedtDwfgMxL8QKEl5SH4oc
HgGdc9wckl7kvyDCU3jp3oPTPyHCGz39AwDSCGMy
      "], {{297.0814250000001, 142.00500000000005`}, {300.40298750000005`, 
      142.00500000000005`}, {300.40298750000005`, 144.83437500000008`}, {
      300.40298750000005`, 145.2206250000001}, {300.40298750000005`, 
      145.70343750000012`}, {300.40298750000005`, 146.28281250000003`}, {
      300.40298750000005`, 146.8640625000001}, {300.40298750000005`, 
      147.2831250000001}, {300.40298750000005`, 147.54000000000002`}, {
      300.20048750000007`, 147.54000000000002`}, {297.0814250000001, 
      142.00500000000005`}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0,
       1, 0}, {0, 1, 0}}}, {{{449.5699, 322.4675}, {446.7707, 327.7794}, {
      443.74420000000003`, 332.91229999999996`}, {443.6451, 333.0632}, {
      441.13689999999997`, 331.41729999999995`}, {441.21619999999996`, 
      331.2964999999999}, {441.1782, 331.35760000000005`}, {444.1682, 
      326.28659999999996`}, {444.13329999999996`, 326.3491}, {
      446.91589999999997`, 321.0689}}, {{438.5343, 340.556}, {
      437.0962999999999, 342.5329}, {433.4934999999999, 347.014}, {430.8719, 
      349.9695}, {428.62760000000003`, 347.9788}, {431.22509999999994`, 
      345.0504}, {431.1783, 345.1059}, {434.7356, 340.6814}, {434.6916, 
      340.73889999999994`}, {436.1083, 338.7912999999999}}, {{424.4796, 
      356.50480000000005`}, {421.68129999999996`, 359.1011}, {417.4402, 
      362.6671}, {415.2208, 364.3551}, {413.4048, 361.9672}, {
      415.59499999999997`, 360.3015}, {415.5376, 360.3473}, {419.7226, 
      356.82849999999996`}, {419.6677, 356.8769}, {422.43919999999997`, 
      354.3056}}, {{407.72849999999994`, 369.59619999999995`}, {
      403.93619999999993`, 371.93089999999995`}, {399.2056, 374.5299}, {
      397.1393, 375.53499999999997`}, {395.8271, 372.8372}, {
      397.85990000000004`, 371.8484}, {397.79369999999994`, 371.8827}, {
      402.4592, 369.3195}, {402.395, 369.3568}, {406.15580000000006`, 
      367.0415}}, {{388.77139999999997`, 379.2272}, {384.45599999999996`, 
      380.815}, {379.3845, 382.3952}, {377.21299999999997`, 382.9525}, {
      376.46729999999997`, 380.0467}, {378.6018, 379.49889999999994`}, {
      378.52849999999995`, 379.5197}, {383.52729999999997`, 
      377.96209999999996`}, {383.4556, 377.98639999999995`}, {
      387.73549999999994`, 376.41169999999994`}}, {{368.2692, 
      384.88309999999996`}, {363.83609999999993`, 385.54609999999997`}, {
      358.5732, 386.0557}, {356.189, 386.1611}, {356.05649999999997`, 
      383.1641}, {358.40139999999997`, 383.0604}, {358.32309999999995`, 
      383.0659}, {363.5082, 382.5638}, {363.43089999999995`, 382.5734}, {
      367.8255, 381.9160999999999}}, {{347.03509999999994`, 386.1859}, {
      342.6753, 385.917}, {337.3712, 385.3043}, {334.9528, 384.8924}, {
      335.4566, 381.93499999999995`}, {337.83529999999996`, 
      382.34020000000004`}, {337.7555, 382.3288}, {342.9798, 
      382.93229999999994`}, {342.9, 382.92519999999996`}, {347.2198, 
      383.1916}}, {{325.9976, 382.9786}, {321.5774, 381.7226}, {316.3841, 
      379.93709999999993`}, {314.46029999999996`, 379.1566}, {315.5882, 
      376.37669999999997`}, {317.47429999999997`, 377.1419}, {
      317.39799999999997`, 377.1134}, {322.5143, 378.8723}, {
      322.43659999999994`, 378.84790000000004`}, {326.8176, 380.0928}}, {{
      306.0956, 375.42529999999994`}, {301.1519, 372.7643}, {
      296.4164999999999, 369.87940000000003`}, {295.59129999999993`, 
      369.3151}, {297.2847, 366.83869999999996`}, {298.0773, 367.3807}, {
      298.01099999999997`, 367.3379}, {302.6785, 370.1814}, {302.6091, 
      370.14160000000004`}, {307.5175, 372.78369999999995`}}, {{
      288.23619999999994`, 363.99899999999997`}, {287.4425, 
      363.39329999999995`}, {283.21619999999996`, 359.8088}, {279.1721, 
      356.00809999999996`}, {279.0754, 355.90749999999997`}, {
      281.23749999999995`, 353.8278}, {281.308, 353.90109999999993`}, {
      281.2541, 353.84790000000004`}, {285.2429, 357.59659999999997`}, {
      285.1859, 357.5457}, {289.3535, 361.08029999999997`}, {
      289.29329999999993`, 361.03189999999995`}, {290.05629999999996`, 
      361.61420000000004`}}, {{272.9188, 349.244}, {271.6546000000001, 
      347.79099999999994`}, {268.1936, 343.3914}, {265.51619999999997`, 
      339.6214}, {267.9622, 337.8844}, {270.6182, 341.6243}, {270.5742, 
      341.5654}, {273.98949999999996`, 345.90689999999995`}, {273.9422, 
      345.8498000000001}, {275.1821, 347.2749}}, {{260.65280000000007`, 
      331.8808}, {259.07480000000004`, 329.1285}, {256.47709999999995`, 
      324.0473}, {255.1315, 321.07329999999996`}, {257.86480000000006`, 
      319.8366}, {259.1956, 322.77809999999994`}, {259.16460000000006`, 
      322.7136}, {261.7296, 327.73089999999996`}, {261.6953, 
      327.66760000000005`}, {263.2554, 330.3887}}, {{251.69379999999998`, 
      312.6057}, {251.1469, 311.0095}, {253.985, 310.0372}, {254.5319, 
      311.6334}}, {{252.566, 310.52329999999995`}, {247.1718, 318.4702}, {
      249.9088, 301.92449999999997`}, {261.50309999999996`, 314.0415}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}}}, {{{564.6245, 310.71689999999995`}, {560.3827, 317.0643}, {
      560.1311999999999, 317.4}, {558.5305, 316.2009}, {558.7659, 
      315.88669999999996`}, {558.7348000000001, 315.93059999999997`}, {
      562.9617, 309.60560000000004`}}, {{556.5338, 322.202}, {
      555.8105999999999, 323.1675}, {551.4209, 328.42189999999994`}, {
      549.8860999999999, 327.13960000000003`}, {554.2587000000001, 
      321.9056}, {554.2258, 321.9472}, {554.9331999999999, 321.0029}}, {{
      547.3331999999999, 332.8838}, {545.7778000000001, 334.5597}, {541.6446, 
      338.5784}, {540.2504, 337.1444000000001}, {544.3651999999998, 
      333.14360000000005`}, {544.3293, 333.1803}, {545.8672999999999, 
      331.5232}}, {{537.1618, 342.6394}, {534.6544, 344.843}, {
      530.9660999999999, 347.7744}, {529.7217, 346.20869999999996`}, {
      533.3906, 343.29269999999997`}, {533.3526999999999, 343.3244}, {
      535.8414999999999, 341.1371}}, {{526.1379, 351.4148}, {522.5534, 
      353.99029999999993`}, {519.5047000000001, 355.9676}, {518.4164, 
      354.2896}, {521.4450999999999, 352.32529999999997`}, {521.4057, 
      352.3521}, {524.971, 349.7906}}, {{514.3806, 359.1753}, {509.5872, 
      361.9746}, {507.3769, 363.1324}, {506.4489, 361.36080000000004`}, {
      508.6387, 360.21369999999996`}, {508.59839999999997`, 
      360.23599999999993`}, {513.372, 357.44829999999996`}}, {{502.0039, 
      365.90129999999994`}, {495.868, 368.7693}, {494.6932, 369.2558}, {
      493.92799999999994`, 367.40799999999996`}, {495.0822, 
      366.92999999999995`}, {495.0414, 366.948}, {501.15700000000004`, 
      364.0895}}, {{489.1496000000001, 371.55129999999997`}, {
      488.76099999999997`, 371.7122}, {481.5959, 374.3156}, {480.9129, 
      372.43589999999995`}, {488.0573, 369.84000000000003`}, {
      488.01619999999997`, 369.8559}, {488.3845, 369.70349999999996`}}, {{
      475.8324, 376.134}, {474.1221, 376.6723}, {468.0849, 378.2898}, {
      467.5673, 376.358}, {473.5836, 374.746}, {473.54220000000004`, 
      374.75809999999996`}, {475.23189999999994`, 374.2262999999999}}, {{
      462.2018, 379.6655}, {459.0094, 380.3758}, {454.31129999999996`, 
      381.21309999999994`}, {453.9604, 379.2441}, {458.6375, 378.4106}, {
      458.5958, 378.41889999999995`}, {461.7674, 377.7132}}, {{448.343, 
      382.1478000000001}, {443.5344, 382.79569999999995`}, {440.3575, 
      383.0876}, {440.1745, 381.09599999999995`}, {443.33029999999997`, 
      380.80609999999996`}, {443.28829999999994`, 380.81080000000003`}, {
      448.0759, 380.1657}}, {{434.33639999999997`, 383.5829}, {427.8083, 
      383.9049}, {426.302, 383.91529999999995`}, {426.28819999999996`, 
      381.91529999999995`}, {427.7734, 381.90509999999995`}, {
      427.73099999999994`, 381.90629999999993`}, {434.23789999999997`, 
      381.5854}}, {{420.3021, 383.9566}, {419.88599999999997`, 383.9595}, {
      412.2644, 383.6875}, {412.3358, 381.6888}, {419.9360999999999, 
      381.96}, {419.89349999999996`, 381.9594}, {420.28839999999997`, 
      381.9566}}, {{406.23949999999996`, 383.2278}, {403.99229999999994`, 
      383.05129999999997`}, {398.246, 382.3498000000001}, {398.4882999999999, 
      380.36460000000005`}, {404.21329999999995`, 381.0634}, {404.1705, 
      381.0591}, {406.39619999999996`, 381.234}}, {{392.2709, 381.4532}, {
      388.12609999999995`, 380.7637}, {384.3673, 379.96809999999994`}, {
      384.78149999999994`, 378.01149999999996`}, {388.5189, 
      378.80260000000004`}, {388.47589999999997`, 378.7944}, {392.599, 
      379.48029999999994`}}, {{378.4726, 378.638}, {372.4047, 377.0707}, {
      370.7102, 376.5721}, {371.2747, 374.65340000000003`}, {372.9532, 
      375.14730000000003`}, {372.92099999999994`, 375.1384}, {378.9727, 
      376.7016}}, {{364.95709999999997`, 374.7922}, {364.62309999999997`, 
      374.6857}, {360.7629, 373.3584}, {357.3741, 372.1065}, {358.0671, 
      370.2304}, {361.4453, 371.47839999999997`}, {361.42389999999995`, 
      371.47069999999997`}, {365.2627, 372.79069999999996`}, {
      365.24129999999997`, 372.7836}, {365.56460000000004`, 372.8866}}, {{
      351.7609, 369.862}, {349.3149, 368.829}, {345.54900000000004`, 
      367.1353}, {344.4106, 366.59129999999993`}, {345.2729, 
      364.78669999999994`}, {346.4009, 365.3258}, {346.3799, 
      365.31609999999995`}, {350.1247, 367.0003}, {350.10360000000003`, 
      366.9910999999999}, {352.539, 368.0196}}, {{339.0118, 
      363.90729999999996`}, {336.1953, 362.45669999999996`}, {
      331.95149999999995`, 360.07099999999997`}, {332.93159999999995`, 
      358.3276}, {337.15940000000006`, 360.7044}, {337.1273, 360.687}, {
      339.92749999999995`, 362.1293}}, {{326.77529999999996`, 
      356.96599999999995`}, {325.4077, 356.12960000000004`}, {320.246, 
      352.7043}, {320.0216, 352.543}, {321.1888, 350.91889999999995`}, {
      321.39809999999994`, 351.0693}, {321.36740000000003`, 351.0481}, {
      326.4980999999999, 354.4529}, {326.46689999999995`, 
      354.43299999999994`}, {327.8188, 355.25980000000004`}}, {{315.1223, 
      349.01480000000004`}, {310.4124, 345.3541}, {308.82529999999997`, 
      344.02099999999996`}, {310.1116, 342.4896}, {311.68420000000003`, 
      343.8104}, {311.6548000000001, 343.78659999999996`}, {
      316.34970000000004`, 347.43569999999994`}}, {{304.2525, 340.0792}, {
      301.2658, 337.3693}, {298.4054, 334.565}, {299.8055, 
      333.13689999999997`}, {302.65220000000005`, 335.92769999999996`}, {
      302.6241, 335.90119999999996`}, {305.59639999999996`, 
      338.59809999999993`}}, {{294.2049, 330.22749999999996`}, {292.8471, 
      328.78819999999996`}, {288.92339999999996`, 324.2858}, {
      288.84290000000004`, 324.1856}, {290.402, 322.93289999999996`}, {
      290.46999999999997`, 323.0176}, {290.4443, 322.98689999999993`}, {
      294.3419, 327.4593}, {294.3154, 327.4300999999999}, {
      295.65970000000004`, 328.8551}}, {{285.06629999999996`, 319.4718}, {
      281.6732, 314.88149999999996`}, {280.3643, 312.9506}, {282.0199, 
      311.82849999999996`}, {283.3172, 313.74240000000003`}, {
      283.29359999999997`, 313.7091}, {286.67460000000005`, 318.2829}}, {{
      277.0601, 307.8945}, {275.34720000000004`, 305.1277}, {277.0477, 
      304.075}, {278.7606, 306.8417}}, {{276.1974, 304.6013}, {273.8079, 
      310.5419}, {273.2495, 299.3755}, {282.5176, 305.6286}}}], 
    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
      0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
      1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
      0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
      0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{497.043, 
      127.91410000000002`}, {490.8557, 124.94720000000002`}, {
      489.75329999999997`, 124.49120000000002`}, {488.98879999999997`, 
      126.3392}, {490.0658, 126.7848}, {490.0157, 126.7625}, {496.1783, 
      129.71749999999997`}}, {{484.1533, 122.194}, {477.9382999999999, 
      120.0028}, {476.53639999999996`, 119.58869999999999`}, {475.9698, 
      121.5067}, {477.3469, 121.91350000000001`}, {477.29769999999996`, 
      121.89760000000001`}, {483.4882999999999, 124.0802}}, {{470.727, 
      117.90120000000002`}, {464.45609999999994`, 116.38589999999999`}, {
      462.8872, 116.0866}, {462.5124, 118.05120000000001`}, {
      464.05740000000003`, 118.3459}, {464.0099, 118.3356}, {470.2573, 
      119.8452}}, {{456.9425, 114.98150000000001`}, {450.5179, 114.0673}, {
      448.9686, 113.9187}, {448.7776, 115.90960000000001`}, {
      450.30420000000004`, 116.056}, {450.2587, 116.0506}, {456.6607, 
      116.96150000000002`}}, {{442.9502, 113.3621}, {436.23189999999994`, 
      113.01790000000001`}, {434.91589999999997`, 113.0074}, {434.8999, 
      115.0073}, {436.1943, 115.0177}, {436.1511, 115.0164}, {
      442.84790000000004`, 115.3595}}, {{428.874, 112.96420000000002`}, {
      421.7058, 113.2088}, {420.8395, 113.2741}, {420.9898, 115.2685}, {
      421.8356, 115.2047}, {421.7946, 115.20700000000001`}, {428.9422, 
      114.96300000000001`}}, {{414.8565, 113.725}, {414.38629999999995`, 
      113.7604}, {407.047, 114.6114}, {406.83, 114.64529999999999`}, {
      407.13849999999996`, 116.62129999999999`}, {407.33599999999996`, 
      116.5905}, {407.29689999999994`, 116.5958}, {414.59659999999997`, 
      115.74940000000001`}, {414.5566, 115.7533}, {415.0068, 115.7193}}, {{
      400.9018, 115.57079999999999`}, {399.70129999999995`, 115.7582}, {
      393.00509999999997`, 117.0713}, {393.3899, 119.0339}, {400.0672, 
      117.7245}, {400.029, 117.7313}, {401.21029999999996`, 117.5468}}, {{
      387.1232, 118.43440000000001`}, {385.04440000000005`, 118.9252}, {
      379.35580000000004`, 120.49740000000001`}, {379.8886, 122.4251}, {
      385.559, 120.8579}, {385.5224, 120.8673}, {387.5827, 120.3808}}, {{
      373.5832, 122.2629}, {370.5228, 123.2335}, {365.9794, 
      124.86269999999999`}, {366.65450000000004`, 126.7453}, {371.1803, 
      125.12239999999998`}, {371.1451, 125.1343}, {374.1877, 124.1694}}, {{
      360.3393, 127.0128}, {356.2435, 128.6553}, {352.93199999999996`, 
      130.12810000000002`}, {353.7447, 131.9555}, {357.03929999999997`, 
      130.49030000000002`}, {357.00509999999997`, 130.50469999999999`}, {
      361.08369999999996`, 128.8691}}, {{347.447, 132.6481}, {342.3139, 
      135.1633}, {340.2691, 136.2617}, {341.21549999999996`, 138.0236}, {
      343.2438, 136.934}, {343.2106, 136.95110000000003`}, {348.327, 
      134.4441}}, {{334.962, 139.13959999999997`}, {328.8413, 142.73}, {
      328.0475, 143.237}, {329.12420000000003`, 144.9225}, {
      329.90189999999996`, 144.4257}, {329.86960000000005`, 
      144.44549999999998`}, {335.974, 140.8647}}, {{322.99099999999993`, 
      146.4669}, {322.31, 146.9019}, {316.3705, 151.0248}, {
      317.51099999999997`, 152.6677}, {323.43469999999996`, 148.5558}, {
      323.4027, 148.5771}, {324.0677, 148.15240000000003`}}, {{
      311.53509999999994`, 154.6418}, {309.7246, 156.0058}, {
      305.25460000000004`, 159.6586}, {306.5202, 161.2073}, {310.9749, 
      157.5669}, {310.9439, 157.59130000000002`}, {312.73859999999996`, 
      156.23919999999998`}}, {{300.6823, 163.60369999999998`}, {
      297.86560000000003`, 166.10049999999998`}, {294.7836, 169.0658}, {
      296.1703, 170.507}, {299.23749999999995`, 167.5559}, {299.2075, 
      167.5836}, {302.009, 165.1004}}, {{290.5041, 173.32860000000002`}, {
      286.84090000000003`, 177.1591}, {285.03139999999996`, 
      179.21959999999996`}, {286.5342, 180.5393}, {288.3297, 178.4947}, {
      288.301, 178.526}, {291.9495, 174.71079999999998`}}, {{281.0747, 
      183.7764}, {278.5743, 186.8357}, {276.08389999999997`, 
      190.06369999999998`}, {277.66740000000004`, 191.2854}, {
      280.14920000000006`, 188.0685}, {280.13169999999997`, 188.0905}, {
      282.6232, 185.0421}}, {{272.51460000000003`, 194.95690000000002`}, {
      270.07349999999997`, 198.5258}, {268.07169999999996`, 
      201.64389999999997`}, {269.7547, 202.7244}, {271.7487, 
      199.61849999999998`}, {271.73249999999996`, 199.6428}, {
      274.16540000000003`, 196.08610000000002`}}, {{264.9328, 206.8265}, {
      262.8117, 210.6088}, {261.10400000000004`, 213.88440000000003`}, {
      262.8774, 214.809}, {264.5782, 211.5469}, {264.5636, 
      211.57369999999997`}, {266.6772, 207.8048}}, {{258.4591, 
      219.33880000000002`}, {256.8334, 222.9985}, {255.3171, 
      226.72979999999998`}, {257.17, 227.48270000000002`}, {258.6802, 
      223.7663}, {258.66760000000005`, 223.79579999999999`}, {
      260.28689999999995`, 220.1508}}, {{253.2378, 232.42720000000003`}, {
      252.1832, 235.6087}, {250.9361, 239.8461}, {250.8615, 240.1362}, {
      252.79840000000002`, 240.6344}, {252.86880000000002`, 
      240.36090000000002`}, {252.8596, 240.3942}, {254.097, 
      236.18959999999998`}, {254.0869, 236.2219}, {255.1362, 233.0565}}, {{
      251.23379999999997`, 242.70319999999998`}, {247.2594, 
      237.68280000000001`}, {249.88690000000003`, 248.55}, {257.0041, 
      239.92770000000002`}}}]}, 
   {FaceForm[{RGBColor[1., 0., 0.], Opacity[1.]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {
     1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0,
      1, 0}}, {{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}}}, {CompressedData["
1:eJxTTMoPSmViYGAwAmIQLWx/7M7V3iqHG4sLbL0SKh0KznVcsltS5aAV03+o
NKLSQU4sy7d4fZXDuTNnzrzxRPCPfNWIWW+C4E849FVjj2alw2LGPayf1lQ5
zJo5c2alfKXD2hvxZe+XVzk8qhJZ91y00mGmlsTUL4sg5ofyVDo84J68ctHs
Koe214E79rFUOrTUXNj8c2KVwzeNmH6l/xUOnBlKOREdVQ4ZaWlpbT8rIO6r
rXJQaAVq+FbhsH098/M1BQj+/wl1v2dlIPgg9XWJEPdEfoeaFw1x75wfFWD7
LEMh9t8Dmu9e9JP/pR/Ef/x/KhwCPec2pHlUOXg8rBLRA7oH5N9gS4h6ub0V
DjazQ+dnKyH4YPf4VDkU2XJdZy6vdJgB9G9JQJXDLrnW1xvbKx1A4T01FOK/
pqmVDhpvefcJxEDDe0El2LzupCoHO67riwtWVzqkfn+SuDAL4v9nmyHhG1RS
5bCsAGjBTkj4MdVB3Ht+fyXY/pzOKoeQHXKtpw9BzJ8wDcEHhb/JUgQ/WsHx
Y/MGaPjuh8R/3Q5I+PzZAbG/8QDE/YWbIPY1HalyiOsHKliJ4NeIrHNXnIvg
g9KLzwyIey8dhqjnmAxxT8EhaPz3QtIH/0FI+lvVDpEP2AexT7AJEn4muyDm
9dRUOrx6ZCalsA0aP+VQ8zZA4vdnYSU4vtRWQvznnVvpULVUx/nOwiqHN8Do
WZpRCY7/GzOg6TelEpxepPog9mclQuIHOT8AAG1rfxM=
      "], CompressedData["
1:eJxTTMoPSmViYGAwA2IQ3VJzYfPN0iqHG4sLbLnSKx3kxLJ8jRsQ/L7gEpXp
nVUO3zRi+hdlVjpcM3lvwTqpysHE2Nj4ch5EffGsKoeQHXKt3CWVDtvXMz/n
WVjl0PY6cMe9qkqHxYx7WC8trXI4d+bMGZ/mSoeCcx2X5q2qchBb5/5wVzfU
vLVVDhvcH1Z9mYLgz5o5c+bPeWjyyyodAj3nNrCtrnI48lUjhn9tpYN70U9+
zuUQ93ptrHSwmR06n3sxxL6erZUO/yfU/ZaaW+Xg8bBKZN12iH/MpyL4YP2d
CD44POog/nm9ESK/sqzKISMNCID2c2Yo5VTkVTnUiAA9MAti3+n0KodHQO3p
nZUOD7gnr1yUBHV/IcS9av5Q90hC1K/2q3KYcAjoAfFKB6MjG/XygPwiW67r
zaKofGYRBB8UnnWClQ5nYr1PsAPN04rpPxTKD/GfVUCVQ1z/oa8dvFD1gRD9
h7mh8RkM0f+Ps9LhYNvy8K5QiPssOSodUr8/SXwYDnFPDRvEvy+jIPw/LBD5
hXEQ9TuZIeETCfTfEmDyKGeChKd4OsQ9Vxmh4ZeD4IPTTwmC/+qRmdSCaoh7
NYDmz9CSmPqlERKf54Hu0XjLuy+gA6K+FOiftTfiy/x7IelNWAQi/2ECJLyX
y0DsmzkF4l9nVaj/p0HV6yP4IPNErRB8nuuLC+a6QNJn0WQI/64PxLzKXqh7
gyD+b2yHpI9zEZD4/1EHSW+noiHp+V4xgo+enwDDL4lO
      "]}], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0,
      1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
     3}, {0, 1, 0}}}, CompressedData["
1:eJxd03tMU3cUB/CyInZKFAJOW6IW6RgiqYhYCpR5GlQMucYHlTZksnSzF4Vt
urqZe3+V2WxsTkY25eHb+WJFUYlP2GQqmdACFRAmtYXV8Ng6V0BpxQel2B3/
WZPd5Pzxyb33l/P7nt8v8oNtGzRcDocTgLUc6w2swttrlcUOAk5uHL3qDwby
5P18/V8EbhRtlYxaGVhwqeHFzT8JzDDx+1MsDNRMfzyajh5oldHR9xlIzotw
tgwSqG1/fyi0iwFf+BVHCbpal+SOuOf3z513yIp2vzNXGO0fmxkQzV/W9T2u
l/OmCfJaGPhkaeq50tf9CI1n4psZqMuQ6w88ImD8uq7UZ2Sgd4619sAQAYk0
floe2mrwUWVP/LYEcNc8HSHAef00MPDdl4muqN/81r6nEWXcIVCqPz9vGX7/
6KfEReomAp6pD9d/i/7V8FQoMBEobrRdc6FHck9P0TYToGp/zPjUxED+5vSd
HS0Esp9tpJ+jv9iRZuOZCYivOJrc2O/Ckn3ieXcJWIfX0XQrA0J398zkNgL6
d+qDenC/K72qiZR2fK9SXw7EPA5V811RHQT69Om0A/MaUvU4gu8RiH8+u6rt
dwYMk3Inv5PAtdKZVfYHDLQcWjeR2UUgPzuWfsvOwIxTxvIizLPcHUzuR7Og
zQwJk2CeIcernZ0LWSjca1pSj5ZSsZYdcSwszh0eDcP58jglshtiFuL0XJkW
vSCgTxy0hIXY0B/Up9BiBS/Gm+B3wnhgzLFEvzdnXwouT2JB3vxP1kVcv+fE
7rCaZBa2SU5Imwawn26tzJnCwvFKxVx7H4EjKpVrkYwF8TfmnAd2AgKB2XwX
HdXLdV21+Z0lencipRf7qblpptJZ2O5rp6Km6v4zOby3gBekA8Xk7TFpGgvM
WEnBlkAdNEDj/g78P7vZncjj6iB/pSH4M3T4rHrT3wE6oKbTmmh0l/qrHBNH
Bwmdb9+yprLwstLtafXh/EfiKz5C73nIO+d+RaBSvcfZj/3PmjNfKUBT3fbl
SjQdOUh9OEngQn7t4EHcL/Eoitu8BBojQy1npCzYhL9kpaFjonMV1zGfMqFI
WT1BYNeu3bbtEhaqxivKw9FG0ecaC+YZJPRsKvLg+RdsKpQvZYE/XnD08TiB
sydTb63GeQwUDVFZ6At1ITHDOK/zIQWv6l4S8EZY51bgPL38xWMc9FkD134R
5205mSQWv8D7pizTSPA8/P9+/wtdx97N
     "]]}, 
   {Thickness[0.0010416666666666667`], 
    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {
     0, 1, 0}, {0, 1, 0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 
     0}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {1,
      3, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 3}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIzIGYCYqMjG/XOhVc73FhcYJulVOlwzeS9RWpYtcOb
wB1yT2UqHf5PqPtdFVrtAFLbIFHpsPZGfBk/kC+2zv2hlWilQ7SC48fFIdUO
WjH9h74KVjqAzMsD8mtE1rkz8iP4PNcXF8TyIPgg/VIclQ4tNRc2z4SaJ8Va
6aDxlnffh3CoeuZKh9Ox3ifcoyD2L2CEysdCzD/IUOlgMzt0/uskBJ8zQykn
IrHaYdZMIPhZAZbP1kDw8891XPqnWe0w4dBXjRqgerein/ydutUOGWlpaWxA
82doSUw1Mah2OHfmzJk3QH7q9yeJjEbVDke+asToA90jbH/szlXjaoddcq2v
C1kqHb7svNUVa1rtYGIMBGwQ+2eYQfjFQP/JimX5XjaH8DdzVTr0BZeofLeo
dvB4WCWSxwsJP2araociW67riwUg/hOwhvjnoTA0fG2qHb5pxPQrSUHs22tX
7fCoSmRdunKlw8G25eFc0Pjr6oeoV46E+OfZDIh5BlFQ+xYg+CDzFZch+GD9
qyDx8TMCGl5rIeHbHQbxv/96iP2yIZDw4dkIsa85oNohZAcwQIB8UPju80bw
Az3nNrj5Vju0vQYmqJ2Q8DBuQ/BB5q9uqXawA3rfYBPEfslGCL9gIzR+6iDp
a+oGqPtqoOkB6J5FjHtYi6oh8bFxHTT8qiDu81kLja8KqHmrIel5Vnm1wwb3
h1VTVkLiO6QMEp7LgeHxgHvySqZSSHisWgSJzx3FEPVb5kHMEy2CpE/bGRDz
pAog+cW1H5K+kfMTADDqeS8=
     "]]}},
  AspectRatio->Automatic,
  ImageSize->{553., 311.},
  PlotRange->{{0., 960.}, {0., 540.}}]], "Text",
 CellChangeTimes->{{3.7958013119491177`*^9, 
  3.79580131520986*^9}},ExpressionUUID->"68e1a9a6-ccc5-4d12-928a-\
78fd019db451"],

Cell["\<\
We develop ordinary differential equations for both the wildtype (w) and the \
mutant (m):\
\>", "Text",
 CellChangeTimes->{{3.795801321843596*^9, 
  3.795801347478683*^9}},ExpressionUUID->"bfc3a46d-303e-4549-91a1-\
57040ef0a241"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dSdt", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Beta]I", "*", "Iw"}], "+", 
         RowBox[{"\[Beta]A", "*", "Aw"}], "+", 
         RowBox[{"\[Beta]P", "*", "Pw"}]}], ")"}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Beta]Im", "*", "Im"}], "+", 
         RowBox[{"\[Beta]Am", "*", "Am"}], "+", 
         RowBox[{"\[Beta]P", "*", "Pm"}]}], ")"}]}], ")"}]}], "*", "S"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"dEwdt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Beta]I", "*", "Iw"}], "+", 
       RowBox[{"\[Beta]A", "*", "Aw"}], "+", 
       RowBox[{"\[Beta]P", "*", "Pw"}]}], ")"}], "*", "S"}], "-", 
    RowBox[{"\[Kappa]E", "*", "Ew"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dPwdt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "f"}], ")"}], "*", "\[Kappa]E", "*", "Ew"}], "-", 
    RowBox[{"\[Kappa]P", "*", "Pw"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dIwdt", "=", 
   RowBox[{
    RowBox[{"\[Kappa]P", "*", "Pw"}], "-", 
    RowBox[{"\[Alpha]", " ", "Iw"}], " ", "-", " ", 
    RowBox[{"\[Kappa]I", " ", "Iw"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"dAwdt", "=", 
    RowBox[{
     RowBox[{"f", "*", "\[Kappa]E", "*", "Ew"}], "-", 
     RowBox[{"\[Kappa]A", "*", "Aw"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"dEmdt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Beta]Im", "*", "Im"}], "+", 
       RowBox[{"\[Beta]Am", "*", "Am"}], "+", 
       RowBox[{"\[Beta]Pm", "*", "Pm"}]}], ")"}], "*", "S"}], "-", 
    RowBox[{"\[Kappa]Em", "*", "Em"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dPmdt", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "fm"}], ")"}], "*", "\[Kappa]Em", "*", "Em"}], "-", 
    RowBox[{"\[Kappa]Pm", "*", "Pm"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dImdt", "=", 
   RowBox[{
    RowBox[{"\[Kappa]Pm", "*", "Pm"}], "-", 
    RowBox[{"\[Alpha]m", " ", "Im"}], " ", "-", " ", 
    RowBox[{"\[Kappa]Im", " ", "Im"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dAmdt", "=", 
   RowBox[{
    RowBox[{"fm", "*", "\[Kappa]Em", "*", "Em"}], "-", 
    RowBox[{"\[Kappa]Am", "*", "Am"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7950922422722387`*^9, 3.795092247690918*^9}, {
   3.795092289558591*^9, 3.795092293235661*^9}, {3.7950923248908987`*^9, 
   3.795092350713396*^9}, {3.795095279451705*^9, 3.795095408661193*^9}, {
   3.795095696085598*^9, 3.795095696681026*^9}, 3.795098324296484*^9, {
   3.795372439012705*^9, 3.79537247163337*^9}, {3.795372554967564*^9, 
   3.795372596491542*^9}, {3.79537262749857*^9, 3.7953726586897383`*^9}, {
   3.795387298286441*^9, 3.795387335175191*^9}, {3.795387370582409*^9, 
   3.7953873811809*^9}, 3.795395062100111*^9, {3.795396179325543*^9, 
   3.79539621105123*^9}, {3.795396271318568*^9, 3.79539629851449*^9}, {
   3.795396530492292*^9, 3.7953965320050592`*^9}, {3.795396693924424*^9, 
   3.7953967273188457`*^9}, 3.795396861751514*^9, {3.795397927329146*^9, 
   3.795397933905798*^9}, {3.795456920939417*^9, 3.795456941324483*^9}, {
   3.795456979226663*^9, 3.7954569844897213`*^9}, {3.795459324123461*^9, 
   3.795459328218148*^9}, {3.7955444702467823`*^9, 3.795544478300623*^9}},
 ExpressionUUID -> "a247e5fe-edbf-4d23-9ac6-51303e4670f2"],

Cell["\<\
We assume that the disease is fairly rare and study its growth by analysing \
the properties of the local stability matrix:\
\>", "Text",
 CellChangeTimes->{{3.795801352186573*^9, 3.795801360174802*^9}, {
  3.795801420098105*^9, 
  3.795801467245961*^9}},ExpressionUUID->"7cfa179e-6868-485c-82af-\
686e546203c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"start", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Ew", "\[Rule]", "0"}], ",", 
     RowBox[{"Aw", "\[Rule]", "0"}], ",", 
     RowBox[{"Pw", "\[Rule]", "0"}], ",", 
     RowBox[{"Iw", "\[Rule]", "0"}], ",", 
     RowBox[{"Em", "\[Rule]", "0"}], ",", 
     RowBox[{"Am", "\[Rule]", "0"}], ",", 
     RowBox[{"Pm", "\[Rule]", "0"}], ",", 
     RowBox[{"Im", "\[Rule]", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.795092557767857*^9, 3.795092570592904*^9}, {
   3.795093412655442*^9, 3.7950934143864117`*^9}, {3.795095723280581*^9, 
   3.7950957292315283`*^9}, {3.79537243912359*^9, 3.795372471780603*^9}, {
   3.7953725551517687`*^9, 3.7953725965775623`*^9}, {3.7953874040445757`*^9, 
   3.795387407187849*^9}, {3.795396545545809*^9, 3.795396558029168*^9}, 
   3.795456992772818*^9},
 ExpressionUUID -> "934368f2-bab8-46d3-b7ab-55c519afd80c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"stabmat", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dSdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEwdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPwdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dIwdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAwdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dEmdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dPmdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dImdt", ",", "Am"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "S"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Ew"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Pw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Iw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Aw"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Em"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Pm"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Im"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"dAmdt", ",", "Am"}], "]"}]}], "}"}]}], "}"}], "/.", 
    "start"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.795092366470154*^9, 3.7950924765479383`*^9}, {
  3.795092544348423*^9, 3.795092574136277*^9}, {3.795095795218708*^9, 
  3.795095941502092*^9}, {3.7950960178269863`*^9, 3.7950960397880793`*^9}, {
  3.795098325671227*^9, 3.7950983264674263`*^9}, {3.7953724391784153`*^9, 
  3.795372473521512*^9}, {3.7953725551995697`*^9, 3.795372598607711*^9}, {
  3.795396328086575*^9, 3.795396351913103*^9}, {3.795801397011943*^9, 
  3.795801415496501*^9}},
 ExpressionUUID -> "47f74b98-6ab3-47ca-a40e-780b8e515545"],

Cell[TextData[{
 "In the special case where the exposed class is highly transitory and most \
infections occur during the pre-symptomatic phase, we have the simpler \
equations:\n\n\tdPwdt=(1-f)*\[Beta]P*Pw-\[Kappa]P*Pw\n\tdPmdt = \
(1-fm)*\[Beta]Pm*Pm-\[Kappa]Pm*Pm;\n\t\nThe change in allele frequency, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    FractionBox["Pm", 
     RowBox[{"Pm", "+", "Pw"}]]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", is thus given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["dp", "dt"], "=", 
    FractionBox[
     RowBox[{"d", "(", 
      FractionBox["Pm", 
       RowBox[{"Pm", "+", "Pw"}]], ")"}], "dt"]}], TraditionalForm]]],
 ", which is:"
}], "Text",
 CellChangeTimes->{{3.7986464563330393`*^9, 3.798646600287067*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            FractionBox[
             RowBox[{"Pm", "[", "t", "]"}], 
             RowBox[{
              RowBox[{"Pw", "[", "t", "]"}], "+", 
              RowBox[{"Pm", "[", "t", "]"}]}]], ",", "t"}], "]"}], "/.", 
          RowBox[{
           RowBox[{
            SuperscriptBox["Pm", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "->", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "fm"}], ")"}], "*", "\[Beta]Pm", "*", "S", 
             " ", "Pm"}], "-", 
            RowBox[{"\[Kappa]Pm", "*", "Pm"}]}]}]}], "/.", 
         RowBox[{
          RowBox[{
           SuperscriptBox["Pw", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "->", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "f"}], ")"}], "*", "\[Beta]P", "*", "S", "*", 
            "Pw"}], "-", 
           RowBox[{"\[Kappa]P", "*", "Pw"}]}]}]}], "/.", 
        RowBox[{
         RowBox[{"Pm", "[", "t", "]"}], "->", "Pm"}]}], "/.", 
       RowBox[{
        RowBox[{"Pw", "[", "t", "]"}], "->", "Pw"}]}], "/.", 
      RowBox[{"fm", "\[Rule]", 
       RowBox[{"f", "+", "\[CapitalDelta]f"}]}]}], "/.", 
     RowBox[{"\[Beta]Pm", "\[Rule]", 
      RowBox[{"\[Beta]P", "+", "\[CapitalDelta]\[Beta]"}]}]}], "/.", 
    RowBox[{"\[Kappa]Pm", "->", 
     RowBox[{"\[Kappa]P", "+", "\[CapitalDelta]\[Kappa]"}]}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pm", "\[Rule]", 
      RowBox[{"p", 
       RowBox[{"(", 
        RowBox[{"Pm", "+", "Pw"}], ")"}]}]}], ",", 
     RowBox[{"Pw", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"Pm", "+", "Pw"}], ")"}]}]}]}], "}"}]}], "//", 
  "Factor"}]], "Input",
 CellChangeTimes->{{3.798645773530404*^9, 3.798645952450598*^9}, 
   3.798646324675177*^9, {3.798646618308558*^9, 3.7986466239741983`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", "p", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"S", " ", "\[Beta]P", " ", "\[CapitalDelta]f"}], "-", 
    RowBox[{"S", " ", "\[CapitalDelta]\[Beta]"}], "+", 
    RowBox[{"f", " ", "S", " ", "\[CapitalDelta]\[Beta]"}], "+", 
    RowBox[{"S", " ", "\[CapitalDelta]f", " ", "\[CapitalDelta]\[Beta]"}], 
    "+", "\[CapitalDelta]\[Kappa]"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.798646325865966*^9, 3.798646343808708*^9}, 
   3.798646625853345*^9, 3.79898068683917*^9}]
}, Open  ]],

Cell["\<\
Assuming that \[CapitalDelta]f \[CapitalDelta]\[Beta] is small, relative to \
the other terms (weak selection), gives equations (1) and (2).\
\>", "Text",
 CellChangeTimes->{{3.7986466049336233`*^9, 3.7986466066373453`*^9}, {
  3.79864663775992*^9, 3.798646654079761*^9}}],

Cell["\<\
Returning to the generic model:\
\>", "Text",
 CellChangeTimes->{{3.7986466603453836`*^9, 3.7986466670968933`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stabmat", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.795092481586726*^9, 3.795092487557768*^9}},
 ExpressionUUID -> "3d79a2e4-5f49-4b06-8a19-93f1e69fa77e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]P"}], 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]I"}], 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]A"}], "0", 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]P"}], 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]Im"}], 
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Beta]Am"}]},
     {"0", 
      RowBox[{"-", "\[Kappa]E"}], 
      RowBox[{"S", " ", "\[Beta]P"}], 
      RowBox[{"S", " ", "\[Beta]I"}], 
      RowBox[{"S", " ", "\[Beta]A"}], "0", "0", "0", "0"},
     {"0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "f"}], ")"}], " ", "\[Kappa]E"}], 
      RowBox[{"-", "\[Kappa]P"}], "0", "0", "0", "0", "0", "0"},
     {"0", "0", "\[Kappa]P", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "-", "\[Kappa]I"}], "0", "0", "0", "0", "0"},
     {"0", 
      RowBox[{"f", " ", "\[Kappa]E"}], "0", "0", 
      RowBox[{"-", "\[Kappa]A"}], "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{"-", "\[Kappa]Em"}], 
      RowBox[{"S", " ", "\[Beta]Pm"}], 
      RowBox[{"S", " ", "\[Beta]Im"}], 
      RowBox[{"S", " ", "\[Beta]Am"}]},
     {"0", "0", "0", "0", "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "fm"}], ")"}], " ", "\[Kappa]Em"}], 
      RowBox[{"-", "\[Kappa]Pm"}], "0", "0"},
     {"0", "0", "0", "0", "0", "0", "\[Kappa]Pm", 
      RowBox[{
       RowBox[{"-", "\[Alpha]m"}], "-", "\[Kappa]Im"}], "0"},
     {"0", "0", "0", "0", "0", 
      RowBox[{"fm", " ", "\[Kappa]Em"}], "0", "0", 
      RowBox[{"-", "\[Kappa]Am"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.795092482852619*^9, 3.7950924881218977`*^9}, 
   3.7950925762858257`*^9, 3.79509341767725*^9, 3.795094223572423*^9, 
   3.795096056576933*^9, 3.795098331976386*^9, 3.795373011954474*^9, 
   3.795373107327097*^9, 3.795383480105343*^9, 3.795387472151019*^9, 
   3.7953942271377277`*^9, 3.795394263225655*^9, {3.795394357743884*^9, 
   3.795394381358932*^9}, {3.795394500839807*^9, 3.795394524928289*^9}, 
   3.7953947955655127`*^9, 3.7953950646752577`*^9, 3.7953951421246147`*^9, 
   3.795395239089617*^9, 3.795395341865641*^9, 3.795396503413823*^9, {
   3.795396562140329*^9, 3.795396572146656*^9}, 3.795396755926572*^9, 
   3.795396881765216*^9, 3.795457056156878*^9, 3.795457162119228*^9, 
   3.7954577030930567`*^9, 3.7954577701738243`*^9, 3.795457837724461*^9, 
   3.795459257346092*^9, {3.795459308507307*^9, 3.795459330423869*^9}, 
   3.795460368306901*^9, {3.795543944939453*^9, 3.795543965050877*^9}, 
   3.795544517144178*^9, {3.7958013993910427`*^9, 3.79580141851838*^9}, 
   3.798978471729952*^9, 3.798980686938327*^9},
 ExpressionUUID -> "d8f9a911-070f-48b8-8145-fd51b901feee"]
}, Open  ]],

Cell["\<\
The eigenvalues, \[Lambda], are determined by the roots of the following \
characteristic polynomial:\
\>", "Text",
 CellChangeTimes->{{3.795801477328866*^9, 
  3.795801496294043*^9}},ExpressionUUID->"9192c0db-48d5-42c0-b7ce-\
f4913ecdf396"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"charpoly", "=", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"IdentityMatrix", "[", "9", "]"}]}], "-", "stabmat"}], "]"}], "//",
    "Factor"}]}]], "Input",
 CellChangeTimes->{{3.795092905074766*^9, 3.795092923408206*^9}, {
   3.7950930139341383`*^9, 3.795093016219849*^9}, 3.795096069418149*^9, {
   3.795096107440062*^9, 3.795096112419106*^9}, {3.7953874753689137`*^9, 
   3.795387475775178*^9}, 3.795396506482399*^9},
 ExpressionUUID -> "af53a4e4-2fba-44be-b538-a9263251b812"],

Cell[BoxData[
 RowBox[{"\[Lambda]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "S"}], " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A", 
     " ", "\[Kappa]E"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A", " ", 
     "\[Kappa]E"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Kappa]I"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Kappa]I"}], "-", 
    RowBox[{
    "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
     "\[Kappa]P"}], "+", 
    RowBox[{
    "\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Kappa]P"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Kappa]P"}], "-", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
     "\[Kappa]P"}], "+", 
    RowBox[{
    "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
    RowBox[{
    "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
     "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
     "\[Lambda]"}], "-", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
     "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
     "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
    RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "-", 
    RowBox[{"f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "-", 
    RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]", " ", "\[Kappa]P", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]A", " ", "\[Kappa]P", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]E", " ", "\[Kappa]P", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]I", " ", "\[Kappa]P", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]A", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]E", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]I", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]P", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    SuperscriptBox["\[Lambda]", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "S"}], " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", 
     "\[Kappa]Am", " ", "\[Kappa]Em"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Am", 
     " ", "\[Kappa]Em"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em", " ", 
     "\[Kappa]Im"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em", 
     " ", "\[Kappa]Im"}], "-", 
    RowBox[{
    "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Am", " ", "\[Kappa]Em", 
     " ", "\[Kappa]Pm"}], "+", 
    RowBox[{
    "\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}], 
    "-", 
    RowBox[{
    "S", " ", "\[Beta]Im", " ", "\[Kappa]Am", " ", "\[Kappa]Em", " ", 
     "\[Kappa]Pm"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Im", " ", "\[Kappa]Am", " ", "\[Kappa]Em", 
     " ", "\[Kappa]Pm"}], "-", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im", 
     " ", "\[Kappa]Pm"}], "+", 
    RowBox[{
    "\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im", " ", "\[Kappa]Pm"}], 
    "-", 
    RowBox[{
    "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Am", " ", "\[Kappa]Em", 
     " ", "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Em", 
     " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Lambda]"}], 
    "-", 
    RowBox[{
    "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em", 
     " ", "\[Lambda]"}], "-", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im", 
     " ", "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", "\[Kappa]Im", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", "\[Kappa]Im", 
     " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im", " ", "\[Lambda]"}], 
    "+", 
    RowBox[{
    "\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Pm", " ", "\[Lambda]"}], 
    "+", 
    RowBox[{
    "\[Alpha]m", " ", "\[Kappa]Em", " ", "\[Kappa]Pm", " ", "\[Lambda]"}], 
    "-", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Pm", 
     " ", "\[Lambda]"}], "-", 
    RowBox[{
    "S", " ", "\[Beta]Im", " ", "\[Kappa]Em", " ", "\[Kappa]Pm", " ", 
     "\[Lambda]"}], "+", 
    RowBox[{
    "fm", " ", "S", " ", "\[Beta]Im", " ", "\[Kappa]Em", " ", "\[Kappa]Pm", 
     " ", "\[Lambda]"}], "+", 
    RowBox[{
    "\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Pm", " ", "\[Lambda]"}], 
    "+", 
    RowBox[{
    "\[Kappa]Am", " ", "\[Kappa]Im", " ", "\[Kappa]Pm", " ", "\[Lambda]"}], 
    "+", 
    RowBox[{
    "\[Kappa]Em", " ", "\[Kappa]Im", " ", "\[Kappa]Pm", " ", "\[Lambda]"}], 
    "+", 
    RowBox[{"\[Alpha]m", " ", "\[Kappa]Am", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]m", " ", "\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "-", 
    RowBox[{"fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "-", 
    RowBox[{"S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Am", " ", "\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Am", " ", "\[Kappa]Im", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Em", " ", "\[Kappa]Im", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]m", " ", "\[Kappa]Pm", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Am", " ", "\[Kappa]Pm", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Em", " ", "\[Kappa]Pm", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Kappa]Im", " ", "\[Kappa]Pm", " ", 
     SuperscriptBox["\[Lambda]", "2"]}], "+", 
    RowBox[{"\[Alpha]m", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]Am", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]Em", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]Im", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    RowBox[{"\[Kappa]Pm", " ", 
     SuperscriptBox["\[Lambda]", "3"]}], "+", 
    SuperscriptBox["\[Lambda]", "4"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.795387640647418*^9, 3.795394227222328*^9, 3.7953942632941647`*^9, {
   3.795394357811068*^9, 3.79539438142848*^9}, {3.795394500925029*^9, 
   3.795394525010681*^9}, 3.795394795648584*^9, 3.795395064754986*^9, 
   3.795395142188801*^9, 3.795395239189603*^9, 3.795395341965931*^9, 
   3.7953965071007767`*^9, 3.79539657495205*^9, 3.795396756023872*^9, 
   3.7953968407871637`*^9, 3.795396883844293*^9, 3.795457056456204*^9, 
   3.795457162239311*^9, 3.7954577031835318`*^9, 3.795457770291995*^9, 
   3.795457837842202*^9, 3.795459257636015*^9, {3.795459308611932*^9, 
   3.795459331186143*^9}, 3.795460368422616*^9, {3.7955439450732613`*^9, 
   3.795543965844352*^9}, 3.7955445172802467`*^9, 3.798978475255703*^9, 
   3.79898068707658*^9},
 ExpressionUUID -> "87df90fe-7dec-457f-a315-e80f67185123"]
}, Open  ]],

Cell["\<\
This separates into a characteristic polynomial describing the growth of the \
resident:\
\>", "Text",
 CellChangeTimes->{{3.795457124982335*^9, 
  3.795457142583557*^9}},ExpressionUUID->"d7dc7d1c-d52a-41fd-8b38-\
aa5122ae360b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{"Collect", "[", " ", 
   RowBox[{
    RowBox[{"charpoly", "[", 
     RowBox[{"[", "2", "]"}], "]"}], ",", "\[Lambda]", ",", "Factor"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.79509764041783*^9, 3.795097660765595*^9}, {
   3.795372637477748*^9, 3.7953726587936497`*^9}, 3.795387629820044*^9, 
   3.795394373487709*^9, 3.7953965808573093`*^9, 3.795396892321094*^9, {
   3.795457078676092*^9, 3.795457081089923*^9}, {3.795459282692212*^9, 
   3.79545928309239*^9}},
 ExpressionUUID -> "90e75027-6840-4efb-bb9f-19f03c75e6de"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Kappa]E", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "S"}], " ", "\[Alpha]", " ", "\[Beta]P", " ", 
      "\[Kappa]A"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A"}], "-", 
     RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}], 
     "-", 
     RowBox[{
     "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "-", 
     RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}], 
     "-", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], 
     "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}]}], ")"}]}], 
  "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "f"}], " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
      "\[Kappa]E"}], "-", 
     RowBox[{"S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
     RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
     "-", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
     "-", 
     RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
     "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
     "-", 
     RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
     RowBox[{
     "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
     "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}]}], ")"}], " ", 
   "\[Lambda]"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Alpha]", " ", "\[Kappa]A"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]E"}], "-", 
     RowBox[{"f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E"}], "-", 
     RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
     RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]E"}], "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]I"}], "+", 
     RowBox[{"\[Kappa]E", " ", "\[Kappa]I"}], "+", 
     RowBox[{"\[Alpha]", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Kappa]A", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Kappa]E", " ", "\[Kappa]P"}], "+", 
     RowBox[{"\[Kappa]I", " ", "\[Kappa]P"}]}], ")"}], " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
    "\[Alpha]", "+", "\[Kappa]A", "+", "\[Kappa]E", "+", "\[Kappa]I", "+", 
     "\[Kappa]P"}], ")"}], " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  SuperscriptBox["\[Lambda]", "4"]}]], "Output",
 CellChangeTimes->{{3.795097645319846*^9, 3.7950976612536077`*^9}, 
   3.79509834302592*^9, 3.7953730120853863`*^9, 3.795373107426833*^9, 
   3.7953834830036983`*^9, 3.795394227385253*^9, 3.795394263357983*^9, {
   3.795394357878326*^9, 3.79539438149443*^9}, {3.7953945010134172`*^9, 
   3.795394525094049*^9}, 3.795394795697174*^9, 3.795395064827011*^9, 
   3.795395142254867*^9, 3.795395239257111*^9, 3.795395342032837*^9, 
   3.79539658153684*^9, 3.795396756125033*^9, 3.7953968930954523`*^9, {
   3.795457056568664*^9, 3.795457082824501*^9}, 3.795457162369142*^9, 
   3.795457703243759*^9, 3.7954577704053497`*^9, 3.795457837956959*^9, {
   3.79545925777607*^9, 3.795459331307496*^9}, 3.795460368493894*^9, {
   3.795543945234481*^9, 3.795543966150695*^9}, 3.795544517413498*^9, 
   3.798978476062735*^9, 3.798980687169402*^9},
 ExpressionUUID -> "ec443492-da87-4a14-966d-bc459b684a57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"poly", "/.", 
    RowBox[{"\[Beta]I", "\[Rule]", "0"}]}], "/.", 
   RowBox[{"\[Beta]A", "\[Rule]", "0"}]}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.798978359408749*^9, 3.798978376381856*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"\[Kappa]A", "+", "\[Lambda]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "S"}], " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
    RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
    RowBox[{"\[Kappa]E", " ", "\[Kappa]P"}], "+", 
    RowBox[{"\[Kappa]E", " ", "\[Lambda]"}], "+", 
    RowBox[{"\[Kappa]P", " ", "\[Lambda]"}], "+", 
    SuperscriptBox["\[Lambda]", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.798978365964241*^9, 3.798978376909902*^9}, 
   3.7989784790259047`*^9, 3.7989785871032267`*^9, 3.79898068727131*^9}]
}, Open  ]],

Cell["\<\
And a characteristic polynomial describing the growth of the mutant:\
\>", "Text",
 CellChangeTimes->{{3.795457124982335*^9, 3.795457151550264*^9}},
 ExpressionUUID -> "5779189c-06af-48f1-b210-4554e91625d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"polym", "=", 
  RowBox[{
   RowBox[{"Collect", "[", " ", 
    RowBox[{
     RowBox[{"charpoly", "[", 
      RowBox[{"[", "3", "]"}], "]"}], ",", "\[Lambda]", ",", "Factor"}], 
    "]"}], "/.", 
   RowBox[{"\[Lambda]", "\[Rule]", "\[Lambda]m"}]}]}]], "Input",
 CellChangeTimes->{{3.79509764041783*^9, 3.7950976806259413`*^9}, {
   3.795098250352092*^9, 3.795098252497315*^9}, 3.795098350421989*^9, {
   3.795372637504793*^9, 3.795372658820538*^9}, {3.795387648133621*^9, 
   3.795387650948697*^9}, 3.795394378535387*^9, 3.7953952364666443`*^9, 
   3.795396588250004*^9, 3.7953969019822702`*^9, {3.7954570930328293`*^9, 
   3.795457115664274*^9}, {3.795459286813154*^9, 3.7954592870003977`*^9}},
 ExpressionUUID -> "2852098e-38e6-46c4-97e8-5c86a777cda4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Kappa]Em", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "S"}], " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", 
      "\[Kappa]Am"}], "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Am"}], 
     "-", 
     RowBox[{"S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Im"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Im"}],
      "-", 
     RowBox[{
     "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Am", " ", "\[Kappa]Pm"}], 
     "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Pm"}], "-", 
     RowBox[{"S", " ", "\[Beta]Im", " ", "\[Kappa]Am", " ", "\[Kappa]Pm"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Im", " ", "\[Kappa]Am", " ", "\[Kappa]Pm"}],
      "-", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Im", " ", "\[Kappa]Pm"}],
      "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Im", " ", "\[Kappa]Pm"}]}], ")"}]}], 
  "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "fm"}], " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Am", " ", 
      "\[Kappa]Em"}], "-", 
     RowBox[{"S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Em"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Alpha]m", " ", "\[Beta]Pm", " ", "\[Kappa]Em"}], 
     "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Em"}], "-", 
     RowBox[{"S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Am", " ", "\[Kappa]Em"}],
      "-", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im"}],
      "-", 
     RowBox[{"S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", "\[Kappa]Im"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Em", " ", "\[Kappa]Im"}],
      "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Im"}], "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Am", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}], "-", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}],
      "-", 
     RowBox[{"S", " ", "\[Beta]Im", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}], 
     "+", 
     RowBox[{
     "fm", " ", "S", " ", "\[Beta]Im", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}],
      "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Em", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Im", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Kappa]Em", " ", "\[Kappa]Im", " ", "\[Kappa]Pm"}]}], ")"}], 
   " ", "\[Lambda]m"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Am"}], "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Em"}], "-", 
     RowBox[{"fm", " ", "S", " ", "\[Beta]Am", " ", "\[Kappa]Em"}], "-", 
     RowBox[{"S", " ", "\[Beta]Pm", " ", "\[Kappa]Em"}], "+", 
     RowBox[{"fm", " ", "S", " ", "\[Beta]Pm", " ", "\[Kappa]Em"}], "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Em"}], "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Im"}], "+", 
     RowBox[{"\[Kappa]Em", " ", "\[Kappa]Im"}], "+", 
     RowBox[{"\[Alpha]m", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Kappa]Am", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Kappa]Em", " ", "\[Kappa]Pm"}], "+", 
     RowBox[{"\[Kappa]Im", " ", "\[Kappa]Pm"}]}], ")"}], " ", 
   SuperscriptBox["\[Lambda]m", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
    "\[Alpha]m", "+", "\[Kappa]Am", "+", "\[Kappa]Em", "+", "\[Kappa]Im", "+",
      "\[Kappa]Pm"}], ")"}], " ", 
   SuperscriptBox["\[Lambda]m", "3"]}], "+", 
  SuperscriptBox["\[Lambda]m", "4"]}]], "Output",
 CellChangeTimes->{{3.795097645319846*^9, 3.7950976810696507`*^9}, 
   3.7950982531437263`*^9, 3.795098351625893*^9, 3.795373012154192*^9, 
   3.795373107476139*^9, 3.795383483474945*^9, 3.795387651634755*^9, 
   3.795394227535555*^9, 3.795394263425828*^9, {3.795394357943697*^9, 
   3.7953943815607157`*^9}, {3.7953945010959997`*^9, 3.795394525177103*^9}, 
   3.795394622225346*^9, 3.795394795747767*^9, 3.7953950648945217`*^9, 
   3.795395142320189*^9, 3.795395239323084*^9, 3.795395342098301*^9, 
   3.795396589039557*^9, 3.7953967562243767`*^9, 3.795396903067958*^9, 
   3.795457056685713*^9, {3.7954571035904217`*^9, 3.795457116580323*^9}, 
   3.795457162485763*^9, 3.7954577033100433`*^9, 3.795457770521826*^9, 
   3.795457838075569*^9, 3.795459257908999*^9, {3.795459308774654*^9, 
   3.79545933147486*^9}, 3.79546036856137*^9, {3.795543945386044*^9, 
   3.7955439662328978`*^9}, 3.795544517547175*^9, 3.798980687467475*^9},
 ExpressionUUID -> "0c5bc78f-186a-4099-8539-93b45655c5df"]
}, Open  ]],

Cell["\<\
As expected, when most individuals are susceptible, mutations spread \
independently and the one with the largest eigenvalue will spread fastest.  \
To determine the difference in the leading eigenvalue, we assume that the \
mutational effects are small (all of the \[OpenCurlyDoubleQuote]m\
\[CloseCurlyDoubleQuote] terms above are near the wildtype rate, with the \
difference of order \[Epsilon]). We can then calculate \[CapitalDelta]\
\[Lambda]m=\[Lambda]m-\[Lambda], by taking the Taylor series and solving the \
characteristic polynomial for \[CapitalDelta]\[Lambda]m.\
\>", "Text",
 CellChangeTimes->{{3.795097523454101*^9, 3.79509753989533*^9}, {
  3.79509757692021*^9, 3.795097614570549*^9}, {3.795097695183839*^9, 
  3.795097695504539*^9}, {3.795098006865163*^9, 3.795098009249943*^9}, {
  3.795099586680846*^9, 3.795099674441852*^9}, {3.795099961247007*^9, 
  3.795099992470366*^9}, {3.795457763703965*^9, 
  3.795457763826214*^9}},ExpressionUUID->"1596cbc6-0d3b-4b99-ada6-\
cf08f4649a97"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"smallmutant", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]m", "\[Rule]", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Alpha]"}]}]}], ",", 
     RowBox[{"fm", "\[Rule]", 
      RowBox[{"f", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]f"}]}]}], ",", 
     RowBox[{"\[Kappa]Im", "\[Rule]", 
      RowBox[{"\[Kappa]I", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Kappa]I"}]}]}], ",", 
     RowBox[{"\[Kappa]Em", "\[Rule]", 
      RowBox[{"\[Kappa]E", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Kappa]E"}]}]}], ",", 
     RowBox[{"\[Kappa]Am", "\[Rule]", 
      RowBox[{"\[Kappa]A", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Kappa]A"}]}]}], ",", 
     RowBox[{"\[Kappa]Pm", "\[Rule]", 
      RowBox[{"\[Kappa]P", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Kappa]P"}]}]}], ",", 
     RowBox[{"\[Beta]Am", "\[Rule]", 
      RowBox[{"\[Beta]A", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Beta]A"}]}]}], ",", 
     RowBox[{"\[Beta]Pm", "\[Rule]", 
      RowBox[{"\[Beta]P", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Beta]P"}]}]}], ",", 
     RowBox[{"\[Beta]Im", "\[Rule]", 
      RowBox[{"\[Beta]I", "+", 
       RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Beta]I"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smallterms", "=", 
   RowBox[{"{", 
    RowBox[{
    "\[CapitalDelta]\[Alpha]", ",", "\[CapitalDelta]f", ",", 
     "\[CapitalDelta]\[Kappa]I", ",", "\[CapitalDelta]\[Kappa]E", ",", 
     "\[CapitalDelta]\[Kappa]A", ",", "\[CapitalDelta]\[Kappa]P", ",", 
     "\[CapitalDelta]\[Beta]A", ",", "\[CapitalDelta]\[Beta]P", ",", 
     "\[CapitalDelta]\[Beta]I"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7953946530550623`*^9, 3.7953947215516357`*^9}, {
  3.795396605143566*^9, 3.795396637376248*^9}, {3.795396739660409*^9, 
  3.7953967490765467`*^9}, {3.795457000912794*^9, 3.795457051155725*^9}, {
  3.7954577638480253`*^9, 3.795457764451416*^9}, {3.7954578188051243`*^9, 
  3.795457834381906*^9}, {3.795544491393282*^9, 3.795544515133253*^9}},
 ExpressionUUID -> "3bd643da-c7bb-42c0-9c8c-5112adb41b19"],

Cell["\<\
As expected, polym is zero to O(1) (reduces to poly for the wildtype, which \
is zero by definition of the eigenvalues): \
\>", "Text",
 CellChangeTimes->{{3.795099994165485*^9, 
  3.795100043938407*^9}},ExpressionUUID->"759c44b2-4a0b-47b2-8191-\
7c8937d74aa1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"polym", "/.", 
       RowBox[{"\[Lambda]m", "\[Rule]", 
        RowBox[{"\[Lambda]", "+", 
         RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Lambda]m"}]}]}]}], "/.",
       "smallmutant"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7950982342765493`*^9, 3.7950983057703657`*^9}, {
   3.795098356205902*^9, 3.79509837786581*^9}, {3.795099693295628*^9, 
   3.795099702722001*^9}, {3.795372637533967*^9, 3.79537265883389*^9}, {
   3.795394558229815*^9, 3.795394614234398*^9}, 3.7953946657407913`*^9, 
   3.7954577644787817`*^9},
 ExpressionUUID -> "f5aed5ae-6370-4773-9679-a5e1ed6404f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "S"}], " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A", 
   " ", "\[Kappa]E"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A", " ", 
   "\[Kappa]E"}], "-", 
  RowBox[{
  "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Kappa]I"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Kappa]I"}], "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
   "\[Kappa]P"}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
  "-", 
  RowBox[{
  "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Kappa]P"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Kappa]P"}], "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
   "\[Kappa]P"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}],
   "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "-", 
  RowBox[{
  "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}],
   "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
  "-", 
  RowBox[{
  "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
   "\[Lambda]"}], "-", 
  RowBox[{
  "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}],
   "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
  "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
  "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
   "\[Lambda]"}], "-", 
  RowBox[{
  "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}],
   "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}],
   "+", 
  RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}],
   "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "-", 
  RowBox[{"f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "-", 
  RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]E", " ", "\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Kappa]I", " ", "\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"\[Alpha]", " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  RowBox[{"\[Kappa]A", " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  RowBox[{"\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  RowBox[{"\[Kappa]I", " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  RowBox[{"\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "3"]}], "+", 
  SuperscriptBox["\[Lambda]", "4"]}]], "Output",
 CellChangeTimes->{{3.795394617301979*^9, 3.7953946268932953`*^9}, 
   3.7953946667697287`*^9, 3.7953947958303003`*^9, 3.795395064991926*^9, 
   3.795395142437633*^9, 3.795395239422607*^9, 3.795395342198576*^9, 
   3.7953966409879627`*^9, 3.795396785513769*^9, 3.79539690943371*^9, 
   3.7954570571841307`*^9, 3.795457162682349*^9, 3.795457242888719*^9, 
   3.795457703411338*^9, 3.7954577706717787`*^9, 3.795457838224332*^9, 
   3.795459258141767*^9, {3.7954593089068623`*^9, 3.7954593316221333`*^9}, 
   3.795460368657764*^9, {3.7955439458729258`*^9, 3.79554396638393*^9}, 
   3.7955445177296057`*^9, 3.798980689185708*^9},
 ExpressionUUID -> "d972d2b7-463e-4bfa-9562-59b022a735e2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"%", "-", "poly"}], "]"}]], "Input",
 CellChangeTimes->{{3.795098387107432*^9, 3.795098394179573*^9}},
 ExpressionUUID -> "4800bf1d-e328-4fd0-a815-8f22516ae9ca"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.795098394608625*^9, 3.795100048149293*^9, 3.7953730122842197`*^9, 
   3.795373107576123*^9, 3.795383483606556*^9, {3.795394206860341*^9, 
   3.795394227820634*^9}, 3.795394263558166*^9, {3.795394358079031*^9, 
   3.7953943816920424`*^9}, {3.795394501262309*^9, 3.795394525343618*^9}, 
   3.795394628876854*^9, 3.795394795881445*^9, 3.795395065058937*^9, 
   3.795395142504052*^9, 3.795395239488759*^9, 3.795395342271906*^9, 
   3.795396643652987*^9, 3.795396788228672*^9, 3.795396911404139*^9, 
   3.79545705730224*^9, 3.795457162801629*^9, 3.795457243022834*^9, 
   3.795457703477378*^9, 3.795457770788468*^9, 3.7954578383229017`*^9, 
   3.7954592584590073`*^9, {3.795459308989105*^9, 3.7954593317388287`*^9}, 
   3.795460368725655*^9, {3.795543945988611*^9, 3.795543966467371*^9}, 
   3.7955445178610353`*^9, 3.798980689319674*^9},
 ExpressionUUID -> "3493d391-14b3-4c1f-bbb2-33fa28ee0caa"]
}, Open  ]],

Cell["\<\
To order \[Epsilon], we can find effect of the mutation on the rate of \
growth, \[CapitalDelta]\[Lambda]m:\
\>", "Text",
 CellChangeTimes->{{3.7951000503165827`*^9, 3.795100053332406*^9}, {
   3.79545718251795*^9, 3.7954572079645433`*^9}, 
   3.795457764581502*^9},ExpressionUUID->"f8b4dd23-7ea3-488e-9fae-\
6d42ee8e2345"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Factor", "[", 
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"polym", "/.", 
         RowBox[{"\[Lambda]m", "\[Rule]", 
          RowBox[{"\[Lambda]", "+", 
           RowBox[{"\[Epsilon]", "*", "\[CapitalDelta]\[Lambda]m"}]}]}]}], "/.",
         "smallmutant"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     "1"}], "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Factor", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"%", "\[Equal]", "0"}], ",", "\[CapitalDelta]\[Lambda]m"}], 
    "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.795098400973742*^9, 3.795098423430113*^9}, {
   3.795098532050888*^9, 3.7950985394190063`*^9}, {3.795099698686063*^9, 
   3.795099700005094*^9}, {3.795372637545053*^9, 3.79537265884521*^9}, 
   3.795394670899749*^9, 3.7953994964388247`*^9, {3.795457180401565*^9, 
   3.79545718077462*^9}, {3.795457764619628*^9, 3.795457764710915*^9}},
 ExpressionUUID -> "c741ba82-3f37-45f8-a461-2e6ae3d75b2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[CapitalDelta]\[Lambda]m", "\[Rule]", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E",
         " ", "\[Kappa]A"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", 
        "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]A",
         " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", 
        "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
        "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]A",
         " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Alpha]", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]A",
         " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]P", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", 
        "\[Kappa]E"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Kappa]I"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Kappa]I"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
       RowBox[{
       "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]I"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
        "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Alpha]", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]f", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "S", " ", "\[CapitalDelta]\[Beta]I", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]I", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", "\[Kappa]I", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
        "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
        "\[CapitalDelta]\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E",
         " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", 
        "\[CapitalDelta]\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]A", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Alpha]", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]E",
         " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Alpha]", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E",
         " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[CapitalDelta]\[Beta]P", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]I", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]A", " ", 
        "\[Kappa]E", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", "\[Kappa]I", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", "\[Kappa]I", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E", " ", 
        "\[Kappa]I", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[Alpha]", " ", "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "S", " ", "\[Beta]I", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]A", " ", "\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "+", 
       RowBox[{
       "S", " ", "\[CapitalDelta]\[Beta]I", " ", "\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]I", " ", "\[Kappa]E", " ", 
        "\[Kappa]P", " ", "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{
       "\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{"\[Alpha]", " ", "\[CapitalDelta]\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[Alpha]", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{"S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[CapitalDelta]\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[Alpha]", " ", "\[CapitalDelta]\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Alpha]", " ", "\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{
       "S", " ", "\[Beta]A", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{
       "S", " ", "\[Beta]P", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Alpha]", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]A", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "+", 
       RowBox[{"S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]I", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]I", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]P", " ", "\[Kappa]I", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Alpha]", " ", "\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]A", " ", "\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]E", " ", "\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]I", " ", "\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Alpha]", " ", 
        SuperscriptBox["\[Lambda]", "3"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "3"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "3"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]I", " ", 
        SuperscriptBox["\[Lambda]", "3"]}], "-", 
       RowBox[{"\[CapitalDelta]\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "3"]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E"}], 
       "+", 
       RowBox[{"S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], 
       "-", 
       RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
       RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
       "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
       "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
       "+", 
       RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
       "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
       "-", 
       RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
       RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "-", 
       RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
       "+", 
       RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
       "-", 
       RowBox[{
       "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
       "-", 
       RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
       RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
       RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
       RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]A", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
       "+", 
       RowBox[{
       "2", " ", "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "+", 
       RowBox[{
       "2", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{
       "2", " ", "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
        "\[Lambda]"}], "-", 
       RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"2", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
       "-", 
       RowBox[{"3", " ", "\[Alpha]", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"3", " ", "\[Kappa]A", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"3", " ", "\[Kappa]E", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"3", " ", "\[Kappa]I", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"3", " ", "\[Kappa]P", " ", 
        SuperscriptBox["\[Lambda]", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Lambda]", "3"]}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7954572431148663`*^9, 3.795457703546344*^9, 3.795457771170673*^9, 
   3.7954578384232073`*^9, 3.795459258651616*^9, {3.795459309074499*^9, 
   3.795459331984302*^9}, 3.795460368795906*^9, {3.795543946104332*^9, 
   3.7955439667159033`*^9}, 3.795544518151387*^9, 3.798980689776184*^9},
 ExpressionUUID -> "dc2f64e3-167e-433f-91c6-c5f00247fdc5"]
}, Open  ]],

Cell["\<\
The denominator is shared and equals the slope of the characteristic \
polynomial at the leading eigenvalue (positive given the form of the cubic):\
\>", "Text",
 CellChangeTimes->{{3.7950991856592216`*^9, 
  3.795099220650326*^9}},ExpressionUUID->"6db1a904-99ad-4a7f-99b2-\
f4e5a7392125"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"denom", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"poly", ",", "\[Lambda]"}], "]"}], "//", "Factor"}]}]], "Input",
 CellChangeTimes->{{3.795098981131771*^9, 3.7950989898478127`*^9}, 
   3.795099167514152*^9},
 ExpressionUUID -> "b856f5c2-a44c-4c8d-8bbe-b1a099b73aa8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "f"}], " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
   "\[Kappa]E"}], "-", 
  RowBox[{"S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
  RowBox[{"f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}],
   "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
  RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
  RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "+", 
  RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
  RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
  RowBox[{
  "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
  RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
  RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]A", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
  RowBox[{
  "2", " ", "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "-", 
  RowBox[{
  "2", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], "+", 
  RowBox[{
  "2", " ", "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
   "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Alpha]", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
  RowBox[{"2", " ", "\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
  RowBox[{"3", " ", "\[Alpha]", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"3", " ", "\[Kappa]A", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"3", " ", "\[Kappa]E", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"3", " ", "\[Kappa]I", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"3", " ", "\[Kappa]P", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[Lambda]", "3"]}]}]], "Output",
 CellChangeTimes->{{3.7950991690469627`*^9, 3.795099174912919*^9}, 
   3.7951004502617073`*^9, {3.7951008263723783`*^9, 3.795100831438889*^9}, 
   3.7951013445310373`*^9, 3.795373012485529*^9, 3.795373107743895*^9, 
   3.795383483938312*^9, {3.7953942135465*^9, 3.795394228401354*^9}, 
   3.7953942637578163`*^9, {3.795394358311491*^9, 3.795394381894093*^9}, {
   3.795394501514186*^9, 3.7953945255763807`*^9}, 3.795394690964136*^9, 
   3.795394736412252*^9, 3.795394796064155*^9, 3.7953950652582808`*^9, 
   3.795395142720129*^9, 3.795395239887971*^9, 3.795395342471951*^9, 
   3.795396653374885*^9, 3.795396794066033*^9, 3.795396919978232*^9, 
   3.79545705768507*^9, 3.7954571632177277`*^9, {3.7954572190854397`*^9, 
   3.795457243241787*^9}, 3.7954577036109858`*^9, 3.795457771289063*^9, 
   3.7954578387903023`*^9, 3.795459258793929*^9, {3.7954593091568813`*^9, 
   3.795459332110096*^9}, 3.7954603688600082`*^9, {3.795543946220408*^9, 
   3.795543966799618*^9}, 3.795544518645482*^9, 3.798980690438541*^9},
 ExpressionUUID -> "c7bdf76a-5763-419e-a24a-69e82baa16e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"selection", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"denom", " ", 
      RowBox[{"\[CapitalDelta]\[Lambda]m", "/", "slope"}]}], "/.", "%%"}], 
    ",", "smallterms", ",", "Factor"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.79509845257301*^9, 3.7950984580658207`*^9}, {
   3.795098556322668*^9, 3.795098599206254*^9}, {3.795098994152438*^9, 
   3.7950989980874453`*^9}, {3.795100432179105*^9, 3.795100447013496*^9}, {
   3.795100820352157*^9, 3.7951008230576153`*^9}, {3.795372637597848*^9, 
   3.7953726588900747`*^9}, {3.795394726115531*^9, 3.795394727355502*^9}, 
   3.795457764920179*^9},
 ExpressionUUID -> "b88c517f-9a50-4875-88e1-19414d863cce"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", "S", " ", 
     "\[CapitalDelta]\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P", " ", 
     RowBox[{"(", 
      RowBox[{"\[Kappa]A", "+", "\[Lambda]"}], ")"}]}], "slope"]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", "S", " ", 
    "\[CapitalDelta]\[Beta]P", " ", "\[Kappa]E", " ", 
    RowBox[{"(", 
     RowBox[{"\[Kappa]A", "+", "\[Lambda]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}]}], 
   "slope"], "+", 
  FractionBox[
   RowBox[{
   "f", " ", "S", " ", "\[CapitalDelta]\[Beta]A", " ", "\[Kappa]E", " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Kappa]P", "+", "\[Lambda]"}], ")"}]}], "slope"], "-", 
  FractionBox[
   RowBox[{"S", " ", "\[CapitalDelta]f", " ", "\[Kappa]E", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A"}], "+", 
      RowBox[{"\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]P"}], "+", 
      RowBox[{"\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "-", 
      RowBox[{"\[Beta]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Beta]A", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Alpha]", " ", "\[Beta]P", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Beta]P", " ", "\[Kappa]A", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Beta]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Beta]P", " ", "\[Kappa]I", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Beta]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Beta]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Beta]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"\[Beta]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}]}], ")"}]}], "slope"], "+", 
  RowBox[{
   FractionBox["1", "slope"], 
   RowBox[{"\[CapitalDelta]\[Kappa]P", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]E"}], 
      "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "+", 
      RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Lambda]"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]E", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]I", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      SuperscriptBox["\[Lambda]", "3"]}], ")"}]}]}], "+", 
  FractionBox[
   RowBox[{"\[CapitalDelta]\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]E", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      SuperscriptBox["\[Lambda]", "3"]}], ")"}]}], "slope"], "+", 
  FractionBox[
   RowBox[{"\[CapitalDelta]\[Kappa]I", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]E", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      SuperscriptBox["\[Lambda]", "3"]}], ")"}]}], "slope"], "+", 
  RowBox[{
   FractionBox["1", "slope"], 
   RowBox[{"\[CapitalDelta]\[Kappa]E", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]A"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Kappa]P"}], 
      "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "+", 
      RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Lambda]"}], "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]I", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]I", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], 
      "-", 
      RowBox[{"\[Kappa]A", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "-", 
      RowBox[{"\[Alpha]", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"f", " ", "S", " ", "\[Beta]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"S", " ", "\[Beta]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]A", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]I", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      RowBox[{"\[Kappa]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "-", 
      SuperscriptBox["\[Lambda]", "3"]}], ")"}]}]}], "-", 
  RowBox[{
   FractionBox["1", "slope"], 
   RowBox[{"\[CapitalDelta]\[Kappa]A", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "S"}], " ", "\[Alpha]", " ", "\[Beta]P", " ", 
       "\[Kappa]E"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], 
      "-", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
      "+", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "-", 
      RowBox[{"S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
      "+", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}], "+", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Lambda]"}], "-", 
      RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], "+", 
      RowBox[{
      "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Lambda]"}], 
      "+", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]I", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Alpha]", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Kappa]E", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Kappa]I", " ", "\[Kappa]P", " ", "\[Lambda]"}], "+", 
      RowBox[{"\[Alpha]", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"\[Kappa]E", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"\[Kappa]I", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      RowBox[{"\[Kappa]P", " ", 
       SuperscriptBox["\[Lambda]", "2"]}], "+", 
      SuperscriptBox["\[Lambda]", "3"]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{
  3.795098458541724*^9, 3.7950986007568197`*^9, 3.795098999249318*^9, 
   3.7950991749801807`*^9, 3.795100450328677*^9, {3.795100826456523*^9, 
   3.7951008315074453`*^9}, 3.795101344598187*^9, 3.7953730125512114`*^9, 
   3.795373107810932*^9, 3.795383484004859*^9, {3.795394215179656*^9, 
   3.79539422847008*^9}, 3.7953942638255568`*^9, {3.795394358397105*^9, 
   3.795394381960051*^9}, {3.7953945015968*^9, 3.7953945256607237`*^9}, {
   3.7953947277480803`*^9, 3.795394736494668*^9}, 3.795394796163245*^9, 
   3.795395065324616*^9, 3.795395142788289*^9, 3.795395240088632*^9, 
   3.7953953425378637`*^9, 3.795396658381227*^9, 3.79539679637181*^9, 
   3.795396923183158*^9, 3.79545705781721*^9, 3.7954571633375874`*^9, {
   3.7954572246369743`*^9, 3.795457243375071*^9}, 3.7954577036789713`*^9, 
   3.795457771405959*^9, 3.795457838907854*^9, 3.7954592589278803`*^9, {
   3.795459309241302*^9, 3.795459332343186*^9}, 3.795460368928574*^9, {
   3.7955439463376513`*^9, 3.795543966884952*^9}, 3.795544518967868*^9, 
   3.798980690740341*^9},
 ExpressionUUID -> "4be6fefe-9841-4e89-856b-207f9c3e7ab8"]
}, Open  ]],

Cell[TextData[{
 "We can also understand selection on mutants by using the method in Box 10.2 \
of Otto and Day, calculating selection as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d\[Lambda]", "dz"], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["v", "T"], " ", 
      FractionBox[
       StyleBox[
        RowBox[{"d", 
         StyleBox["M",
          FontWeight->"Bold"]}]], "dz"], "u"}], 
     RowBox[{
      SuperscriptBox["v", "T"], " ", "u"}]]}], TraditionalForm]],
  ExpressionUUID->"e89c1fd7-7b49-4b61-b342-de4efa1cae13"],
 ", where z represents some underlying trait that the mutation affects (e.g., \
replication rate) and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["v", "T"], TraditionalForm]],ExpressionUUID->
  "584f0f64-c7d1-46f8-b829-337066c70e5d"],
 " and ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]],ExpressionUUID->
  "5b48b895-6e3c-4b6b-bb41-e5aa5156a959"],
 " are the left and right eigenvectors of ",
 StyleBox["M",
  FontWeight->"Bold"],
 ", the matrix describing movement between the infected classes for the \
resident:"
}], "Text",
 CellChangeTimes->{{3.795383686523823*^9, 3.79538388021908*^9}, {
  3.795457273435726*^9, 
  3.795457275131687*^9}},ExpressionUUID->"3d7b6fa6-94c3-42e9-aabd-\
a2998d5ccfcc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"submat", "=", 
   RowBox[{"stabmat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"2", ";;", "5"}], ",", 
      RowBox[{"2", ";;", "5"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.795381127190331*^9, 3.795381225373082*^9}, {
  3.795394247473083*^9, 3.795394249338809*^9}, {3.795397048916704*^9, 
  3.795397050117765*^9}},
 ExpressionUUID -> "46973fb1-bd9a-4b99-9c87-e87c2940c0e0"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "\[Kappa]E"}], 
      RowBox[{"S", " ", "\[Beta]P"}], 
      RowBox[{"S", " ", "\[Beta]I"}], 
      RowBox[{"S", " ", "\[Beta]A"}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "f"}], ")"}], " ", "\[Kappa]E"}], 
      RowBox[{"-", "\[Kappa]P"}], "0", "0"},
     {"0", "\[Kappa]P", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "-", "\[Kappa]I"}], "0"},
     {
      RowBox[{"f", " ", "\[Kappa]E"}], "0", "0", 
      RowBox[{"-", "\[Kappa]A"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.795381138081778*^9, 3.795381179287569*^9}, {
   3.795381221709256*^9, 3.795381225913114*^9}, 3.795383480187934*^9, 
   3.795383547264825*^9, 3.79539422951818*^9, 3.795394264275447*^9, {
   3.79539435894669*^9, 3.7953943824099617`*^9}, {3.795394502447049*^9, 
   3.795394526313747*^9}, 3.795394796448332*^9, 3.795395065524736*^9, 
   3.795395143221271*^9, 3.79539524040443*^9, 3.7953953427386627`*^9, 
   3.79539705059433*^9, 3.795457058273941*^9, 3.795457163456822*^9, 
   3.795457703744143*^9, 3.79545777152195*^9, 3.795457839022265*^9, 
   3.795459259058999*^9, {3.795459309322589*^9, 3.795459333059018*^9}, 
   3.795460368993071*^9, {3.795543946435985*^9, 3.795543967182822*^9}, 
   3.795544519331078*^9, 3.79898069089063*^9},
 ExpressionUUID -> "64bb6a83-1f90-4796-9f24-4f70456215ce"]
}, Open  ]],

Cell["and for the mutant:", "Text",
 CellChangeTimes->{{3.795457277329327*^9, 
  3.7954572797095613`*^9}},ExpressionUUID->"686b0338-e911-416a-b7a6-\
5748206fc41a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"submatm", "=", 
   RowBox[{"stabmat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"6", ";;", "9"}], ",", 
      RowBox[{"6", ";;", "9"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.795382006693698*^9, 3.795382026744288*^9}, {
  3.795394254178994*^9, 3.795394260694998*^9}, {3.79539705793372*^9, 
  3.7953970647671432`*^9}},
 ExpressionUUID -> "73cb7802-dadd-4c56-84d6-f0a38ac85643"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "\[Kappa]Em"}], 
      RowBox[{"S", " ", "\[Beta]Pm"}], 
      RowBox[{"S", " ", "\[Beta]Im"}], 
      RowBox[{"S", " ", "\[Beta]Am"}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "fm"}], ")"}], " ", "\[Kappa]Em"}], 
      RowBox[{"-", "\[Kappa]Pm"}], "0", "0"},
     {"0", "\[Kappa]Pm", 
      RowBox[{
       RowBox[{"-", "\[Alpha]m"}], "-", "\[Kappa]Im"}], "0"},
     {
      RowBox[{"fm", " ", "\[Kappa]Em"}], "0", "0", 
      RowBox[{"-", "\[Kappa]Am"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.7953820275652514`*^9, 3.795382243620099*^9, 3.795383481737966*^9, 
   3.795394229658399*^9, 3.7953942643422823`*^9, {3.795394359028009*^9, 
   3.79539438254149*^9}, {3.7953945025465593`*^9, 3.795394526380539*^9}, 
   3.795394796635171*^9, 3.7953950656433563`*^9, 3.795395143288073*^9, 
   3.795395240536696*^9, 3.795395342843094*^9, 3.795397065043779*^9, 
   3.795457058423731*^9, 3.7954571635902853`*^9, 3.79545770380996*^9, 
   3.795457771637436*^9, 3.795457839137521*^9, 3.795459259192707*^9, {
   3.795459309406642*^9, 3.7954593331590652`*^9}, 3.795460369060225*^9, {
   3.795543946642426*^9, 3.7955439672685747`*^9}, 3.795544519948978*^9, 
   3.798980691357794*^9},
 ExpressionUUID -> "3bad4566-9064-4e95-a67f-1c8f25df4bfc"]
}, Open  ]],

Cell["\<\
Calculating the relative reproductive values (the left eigenvector):\
\>", "Text",
 CellChangeTimes->{{3.795381445202491*^9, 3.7953814667336884`*^9}, {
  3.795381745793202*^9, 
  3.795381749381009*^9}},ExpressionUUID->"c27caff4-04a6-4e18-aa4b-\
ad8b928b111b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"left", "=", 
   RowBox[{"{", 
    RowBox[{"vE", ",", "vP", ",", "vI", ",", "vA"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7955438732433233`*^9, 3.795543898589037*^9}},
 ExpressionUUID -> "39b00d81-360a-40d8-88de-a0e496a76524"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"left", ".", "submat"}], "-", 
  RowBox[{"\[Lambda]", " ", "left"}]}]], "Input",
 CellChangeTimes->{{3.795381234001446*^9, 3.795381260392812*^9}, {
  3.795394271409626*^9, 3.795394276703849*^9}, {3.795397068628619*^9, 
  3.795397070295394*^9}, {3.7955439016447487`*^9, 3.795543904347855*^9}},
 ExpressionUUID -> "95ffa31e-99de-4ef5-b78e-bd684b45a7a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", " ", "vA", " ", "\[Kappa]E"}], "-", 
    RowBox[{"vE", " ", "\[Kappa]E"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "f"}], ")"}], " ", "vP", " ", "\[Kappa]E"}], "-", 
    RowBox[{"vE", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{"S", " ", "vE", " ", "\[Beta]P"}], "+", 
    RowBox[{"vI", " ", "\[Kappa]P"}], "-", 
    RowBox[{"vP", " ", "\[Kappa]P"}], "-", 
    RowBox[{"vP", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{"S", " ", "vE", " ", "\[Beta]I"}], "+", 
    RowBox[{"vI", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "-", "\[Kappa]I"}], ")"}]}], "-", 
    RowBox[{"vI", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{"S", " ", "vE", " ", "\[Beta]A"}], "-", 
    RowBox[{"vA", " ", "\[Kappa]A"}], "-", 
    RowBox[{"vA", " ", "\[Lambda]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.795381261759366*^9, {3.7953813109235697`*^9, 3.795381395879634*^9}, {
   3.795381429731696*^9, 3.795381457448728*^9}, 3.7953817860278*^9, 
   3.795382228575117*^9, 3.7953834802715473`*^9, 3.7953835473675833`*^9, 
   3.795394229719431*^9, {3.795394264402203*^9, 3.7953942770805893`*^9}, {
   3.79539435911127*^9, 3.795394382742139*^9}, {3.7953945026464233`*^9, 
   3.795394526446145*^9}, 3.795394796703124*^9, 3.795395065709382*^9, 
   3.795395143354906*^9, 3.795395240671027*^9, 3.795395342904149*^9, 
   3.795397070711358*^9, 3.795457058572665*^9, 3.795457163706429*^9, 
   3.795457302507868*^9, 3.7954574472185373`*^9, 3.7954577038577633`*^9, 
   3.795457771755385*^9, 3.795457839256494*^9, 3.795459259496127*^9, {
   3.795459309522049*^9, 3.7954593333752203`*^9}, 3.795460369126906*^9, {
   3.795543947105013*^9, 3.7955439674149446`*^9}, 3.7955445200497513`*^9, 
   3.798980691541108*^9},
 ExpressionUUID -> "822dae83-4d53-46f4-a789-c2ca1226a2f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leftvector", "=", 
  RowBox[{
   RowBox[{"left", "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"%", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", "4"}], "]"}], "]"}], ")"}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"left", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}]}],
    "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.795381373304646*^9, 3.795381375018056*^9}, 
   3.795381455614551*^9, {3.795381755787224*^9, 3.795381789476923*^9}, {
   3.795394280720057*^9, 3.7953942850748987`*^9}, {3.795397075565139*^9, 
   3.795397082106823*^9}, {3.79554391136115*^9, 3.795543939820404*^9}},
 ExpressionUUID -> "900db3df-7822-4e3b-954b-b770dac61c9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"vE", ",", 
   FractionBox[
    RowBox[{"S", " ", "vE", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "\[Beta]P"}], "+", 
       RowBox[{"\[Beta]I", " ", "\[Kappa]P"}], "+", 
       RowBox[{"\[Beta]P", " ", 
        RowBox[{"(", 
         RowBox[{"\[Kappa]I", "+", "\[Lambda]"}], ")"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"\[Kappa]P", "+", "\[Lambda]"}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"S", " ", "vE", " ", "\[Beta]I"}], 
    RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}]], ",", 
   FractionBox[
    RowBox[{"S", " ", "vE", " ", "\[Beta]A"}], 
    RowBox[{"\[Kappa]A", "+", "\[Lambda]"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7953817910874567`*^9, 3.795382231125454*^9, 3.795383480437037*^9, 
   3.795383547431156*^9, 3.795394229785913*^9, {3.795394264487638*^9, 
   3.795394286382736*^9}, {3.795394359195436*^9, 3.7953943828081408`*^9}, {
   3.795394502746441*^9, 3.795394526513726*^9}, 3.795394796835231*^9, 
   3.7953950657767353`*^9, 3.7953951434194727`*^9, 3.7953952407401257`*^9, 
   3.795395342971726*^9, 3.795397083215404*^9, 3.795457058723261*^9, 
   3.795457163840022*^9, 3.795457302629634*^9, 3.795457703909823*^9, 
   3.7954577718717213`*^9, 3.795457839490519*^9, 3.795459259626874*^9, {
   3.795459309588954*^9, 3.795459334073667*^9}, 3.79546036919212*^9, {
   3.795543947220647*^9, 3.795543971287712*^9}, 3.795544520132745*^9, 
   3.798980691691113*^9},
 ExpressionUUID -> "bcdfc9f1-bfff-4fce-87d3-be69bab4a5f2"]
}, Open  ]],

Cell["\<\
In addition, the fact that the characteristic polynomial is zero guarantees \
that the first term in v M - v \[Lambda]  is also zero:\
\>", "Text",
 CellChangeTimes->{{3.7953824959353237`*^9, 
  3.795382611155779*^9}},ExpressionUUID->"f0203d8a-162a-4333-a1c2-\
3c3765d8f51b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"left", ".", "submat"}], "-", 
        RowBox[{"\[Lambda]", " ", "left"}]}], ")"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "/.", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"left", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", 
        RowBox[{"leftvector", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], "//", "Factor"}],
    ")"}], "/.", 
  RowBox[{
   RowBox[{"Factor", "[", "poly", "]"}], "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.795544028645753*^9, 3.795544050963615*^9}},
 ExpressionUUID -> "6e7e5766-6a64-4f07-9681-04e080ff5809"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.7955440516277113`*^9, 3.795544520297285*^9, 
  3.798980691839329*^9},
 ExpressionUUID -> "15bd1722-c692-44d8-acf5-e790d216ff34"]
}, Open  ]],

Cell["\<\
Calculating the proportion in each class (the right eigenvector):\
\>", "Text",
 CellChangeTimes->{{3.795381445202491*^9, 3.7953814667336884`*^9}, {
  3.7953815440192738`*^9, 3.795381552784775*^9}, {3.795381762222804*^9, 
  3.795381765474804*^9}},ExpressionUUID->"40eda3a8-b498-4db9-bad4-\
bfa10f0b1862"],

Cell[BoxData[
 RowBox[{
  RowBox[{"right", "=", 
   RowBox[{"{", 
    RowBox[{"uE", ",", "uP", ",", "uI", ",", "uA"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7955438732433233`*^9, 3.795543898589037*^9}, {
  3.795544085224002*^9, 3.795544091125071*^9}},
 ExpressionUUID -> "34cacdde-2f45-4a4c-8388-3c30c0906fe0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"submat", ".", "right"}], "-", 
  RowBox[{"\[Lambda]", " ", "right"}]}]], "Input",
 CellChangeTimes->{{3.795381234001446*^9, 3.795381260392812*^9}, {
  3.7953815564012337`*^9, 3.795381564003352*^9}, {3.795394390299951*^9, 
  3.79539439275413*^9}, {3.7953971387194643`*^9, 3.795397139878603*^9}, {
  3.795544095539316*^9, 3.795544097928872*^9}},
 ExpressionUUID -> "7529fa62-1a6d-4d29-a12f-80fa1761c7a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"S", " ", "uA", " ", "\[Beta]A"}], "+", 
    RowBox[{"S", " ", "uI", " ", "\[Beta]I"}], "+", 
    RowBox[{"S", " ", "uP", " ", "\[Beta]P"}], "-", 
    RowBox[{"uE", " ", "\[Kappa]E"}], "-", 
    RowBox[{"uE", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "f"}], ")"}], " ", "uE", " ", "\[Kappa]E"}], "-", 
    RowBox[{"uP", " ", "\[Kappa]P"}], "-", 
    RowBox[{"uP", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{"uI", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], "-", "\[Kappa]I"}], ")"}]}], "+", 
    RowBox[{"uP", " ", "\[Kappa]P"}], "-", 
    RowBox[{"uI", " ", "\[Lambda]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "uA"}], " ", "\[Kappa]A"}], "+", 
    RowBox[{"f", " ", "uE", " ", "\[Kappa]E"}], "-", 
    RowBox[{"uA", " ", "\[Lambda]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.795381261759366*^9, {3.7953813109235697`*^9, 3.795381395879634*^9}, {
   3.795381429731696*^9, 3.795381457448728*^9}, {3.795381558969563*^9, 
   3.7953816182664347`*^9}, 3.795381793087686*^9, 3.795382234815242*^9, 
   3.79538348076969*^9, 3.7953836482505417`*^9, 3.795394229984913*^9, 
   3.7953942646590357`*^9, {3.7953943594487553`*^9, 3.79539439311935*^9}, {
   3.795394503096017*^9, 3.79539452671204*^9}, 3.7953947971681013`*^9, 
   3.7953950659731894`*^9, 3.79539514355333*^9, 3.795395240938922*^9, 
   3.795395343104685*^9, 3.795397140345893*^9, 3.795457060346736*^9, 
   3.79545716408915*^9, 3.7954574584408083`*^9, 3.795457704042886*^9, 
   3.7954577721384573`*^9, 3.795457840424399*^9, 3.7954592598951283`*^9, {
   3.7954593097232647`*^9, 3.795459334276444*^9}, 3.7954603693592377`*^9, 
   3.795544121976439*^9, 3.795544520764941*^9, 3.7989806924563103`*^9},
 ExpressionUUID -> "198c0a9b-4b91-4f5a-b3a8-73d9ee118e24"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rightvector", "=", 
  RowBox[{
   RowBox[{"right", "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"%", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", "4"}], "]"}], "]"}], ")"}], "\[Equal]", "0"}], 
       ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"right", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2", ",", "4"}], "}"}]}], "]"}]}], "]"}], "]"}]}],
    "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.795381373304646*^9, 3.795381375018056*^9}, 
   3.795381455614551*^9, {3.7953815665974817`*^9, 3.795381613652728*^9}, {
   3.795381711541554*^9, 3.795381715429534*^9}, {3.795381773230918*^9, 
   3.795381774446991*^9}, {3.795394395870727*^9, 3.7953943990636044`*^9}, {
   3.795397142853292*^9, 3.795397151613573*^9}, {3.795544103002565*^9, 
   3.7955441119702*^9}},
 ExpressionUUID -> "9bbbbf1e-08b0-43ba-9311-648956f8acae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"uE", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", "uE", " ", "\[Kappa]E"}], 
     RowBox[{"\[Kappa]P", "+", "\[Lambda]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "f"}], ")"}], " ", "uE", " ", "\[Kappa]E", 
      " ", "\[Kappa]P"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Kappa]P", "+", "\[Lambda]"}], ")"}]}]]}], ",", 
   FractionBox[
    RowBox[{"f", " ", "uE", " ", "\[Kappa]E"}], 
    RowBox[{"\[Kappa]A", "+", "\[Lambda]"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7953813756397943`*^9, {3.795381441298326*^9, 3.795381459249119*^9}, {
   3.79538157337563*^9, 3.7953816183879232`*^9}, 3.795381794786604*^9, 
   3.7953822369810534`*^9, 3.795383481486742*^9, 3.795383652344266*^9, 
   3.795394230609467*^9, 3.7953942647489758`*^9, {3.795394359540749*^9, 
   3.7953943995026903`*^9}, {3.79539450319632*^9, 3.795394527025649*^9}, 
   3.7953947972355623`*^9, 3.795395066174321*^9, 3.79539514362036*^9, 
   3.795395241004251*^9, 3.795395343170473*^9, 3.7953971519273643`*^9, 
   3.795457060870585*^9, 3.795457164274719*^9, 3.795457460062805*^9, 
   3.795457704094009*^9, 3.795457772254084*^9, 3.7954578405424232`*^9, 
   3.795459260159203*^9, {3.795459309790258*^9, 3.795459334376134*^9}, 
   3.795460369426751*^9, {3.795544114188443*^9, 3.795544122061894*^9}, 
   3.795544520832905*^9, 3.79898069272164*^9},
 ExpressionUUID -> "fa85bbbf-a08a-429f-ad64-eca1a8406d16"]
}, Open  ]],

Cell["\<\
In addition, the fact that the characteristic polynomial is zero guarantees \
that the first term in v M - v \[Lambda]  is also zero:\
\>", "Text",
 CellChangeTimes->{{3.7953824959353237`*^9, 
  3.795382611155779*^9}},ExpressionUUID->"63bb1d65-abf9-4140-86a5-\
c71dfce88cd0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"submat", ".", "right"}], "-", 
        RowBox[{"\[Lambda]", " ", "right"}]}], ")"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "/.", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"right", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", 
        RowBox[{"rightvector", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], "//", "Factor"}],
    ")"}], "/.", 
  RowBox[{
   RowBox[{"Factor", "[", "poly", "]"}], "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.795544028645753*^9, 3.795544050963615*^9}, {
  3.795544133807149*^9, 3.795544141208791*^9}},
 ExpressionUUID -> "7ae65e92-6305-4581-83ef-49398ecfecef"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.7955440516277113`*^9, 3.795544142669052*^9, 
  3.795544520898631*^9, 3.798980693005735*^9},
 ExpressionUUID -> "93215d50-cef0-4cb9-a9e4-41d31a5d3c3f"]
}, Open  ]],

Cell[TextData[{
 "Note that the elements of both left and right eigenvectors are positive in \
a growing population (\[Lambda]>0).  Although the length of these \
eigenvectors is arbitrary, we constrain them so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["v", "T"], " ", "u"}], TraditionalForm]],ExpressionUUID->
  "d9714fdf-4ee2-4e67-be27-bbe745aaeb29"],
 " in the denominator of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d\[Lambda]", "dz"], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["v", "T"], " ", 
      FractionBox[
       StyleBox[
        RowBox[{"d", 
         StyleBox["M",
          FontWeight->"Bold"]}]], "dz"], "u"}], 
     RowBox[{
      SuperscriptBox["v", "T"], " ", "u"}]]}], TraditionalForm]],
  ExpressionUUID->"524eb145-55dc-432d-a833-8d8f9dcb5001"],
 " is one by rescaling the right eigenvector (choosing this one keeps the \
left eigenvector easier to read):"
}], "Text",
 CellChangeTimes->{{3.7954602134154367`*^9, 3.795460326615349*^9}, {
  3.795544152955701*^9, 
  3.795544173919385*^9}},ExpressionUUID->"e6b82824-e798-4367-8da1-\
00952e4f9ea8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rightvector", "=", 
   FractionBox["rightvector", 
    RowBox[{"leftvector", ".", "rightvector"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.795460335056766*^9, 3.795460344641739*^9}},
 ExpressionUUID -> "12813883-1599-4d5f-9a4b-80a021e47c55"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox[
     RowBox[{"d", 
      StyleBox["M",
       FontWeight->"Bold"]}]], "dz"], TraditionalForm]],ExpressionUUID->
  "60785559-0d1b-4aa9-b50e-76c5ea148f76"],
 " represents the mutational effect on the transition matrix for a viral \
genotype:"
}], "Text",
 CellChangeTimes->{{3.79538404170461*^9, 3.795384063542027*^9}, {
  3.79539952457977*^9, 
  3.795399529282461*^9}},ExpressionUUID->"0e872fb5-3f6d-47f3-a0c6-\
a87aaa1b28e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mutmat", "=", " ", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"Normal", "[", 
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"submatm", "-", "submat"}], "/.", "smallmutant"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], "/.", 
     RowBox[{"\[Epsilon]", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{
  3.795381807225751*^9, {3.795381883821542*^9, 3.795381900720747*^9}, {
   3.795381957464881*^9, 3.79538198285995*^9}, 3.795382030387022*^9, {
   3.795382060586383*^9, 3.795382074141878*^9}, {3.7953840463007402`*^9, 
   3.7953840500870457`*^9}, {3.795385513997287*^9, 3.795385515169208*^9}, {
   3.7953944682487926`*^9, 3.7953944804526663`*^9}, {3.795394825235683*^9, 
   3.79539482737886*^9}},
 ExpressionUUID -> "053bae7f-0468-4c5b-baaf-b420891a6504"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "\[CapitalDelta]\[Kappa]E"}], 
      RowBox[{"S", " ", "\[CapitalDelta]\[Beta]P"}], 
      RowBox[{"S", " ", "\[CapitalDelta]\[Beta]I"}], 
      RowBox[{"S", " ", "\[CapitalDelta]\[Beta]A"}]},
     {
      RowBox[{"\[CapitalDelta]\[Kappa]E", "-", 
       RowBox[{"f", " ", "\[CapitalDelta]\[Kappa]E"}], "-", 
       RowBox[{"\[CapitalDelta]f", " ", "\[Kappa]E"}]}], 
      RowBox[{"-", "\[CapitalDelta]\[Kappa]P"}], "0", "0"},
     {"0", "\[CapitalDelta]\[Kappa]P", 
      RowBox[{
       RowBox[{"-", "\[CapitalDelta]\[Alpha]"}], "-", 
       "\[CapitalDelta]\[Kappa]I"}], "0"},
     {
      RowBox[{
       RowBox[{"f", " ", "\[CapitalDelta]\[Kappa]E"}], "+", 
       RowBox[{"\[CapitalDelta]f", " ", "\[Kappa]E"}]}], "0", "0", 
      RowBox[{"-", "\[CapitalDelta]\[Kappa]A"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.795381901204914*^9, {3.79538196630517*^9, 3.7953819873020906`*^9}, 
   3.7953820307613583`*^9, {3.795382062307972*^9, 3.795382074496512*^9}, 
   3.79538217577984*^9, 3.795382279014854*^9, 3.795383305860179*^9, {
   3.7953833574430447`*^9, 3.795383368103115*^9}, {3.7953834096063433`*^9, 
   3.7953834260028753`*^9}, 3.795383481902898*^9, 3.795384050557767*^9, {
   3.7953845124963293`*^9, 3.795384560955812*^9}, {3.795384631544416*^9, 
   3.7953846659797773`*^9}, {3.795384742525326*^9, 3.795384756736841*^9}, 
   3.795384821383501*^9, 3.7953849099988327`*^9, 3.795385027987812*^9, {
   3.79538548863977*^9, 3.795385515941605*^9}, 3.795394230893675*^9, 
   3.7953942650218*^9, {3.7953943597118807`*^9, 3.7953943841088142`*^9}, 
   3.795394438514861*^9, {3.7953944687925043`*^9, 3.7953945271638117`*^9}, 
   3.7953947973688927`*^9, 3.795394828218314*^9, 3.7953950665081987`*^9, 
   3.795395143753991*^9, 3.795395241138508*^9, 3.795395343305009*^9, 
   3.79539719019839*^9, 3.795457061107059*^9, 3.795457164507922*^9, 
   3.795457704212277*^9, 3.7954577724879093`*^9, 3.795457841742236*^9, 
   3.795459260959228*^9, {3.795459309939432*^9, 3.7954593346258383`*^9}, {
   3.795460349936687*^9, 3.795460369592887*^9}, 3.795544205586589*^9, 
   3.7955445209989433`*^9, 3.798980693691024*^9},
 ExpressionUUID -> "8ec62ca1-c521-4d26-adf7-f29ccc1d3538"]
}, Open  ]],

Cell["\<\
This gives us an equivalent way to write the selection coefficient on the \
mutation, using the fact that the characteristic polynomial is zero:\
\>", "Text",
 CellChangeTimes->{{3.795457595341538*^9, 3.795457657691503*^9}, {
  3.795457688515584*^9, 
  3.795457692216642*^9}},ExpressionUUID->"0e182d93-15e6-4c2b-aa86-\
c0066b0b6756"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"leftvector", ".", "mutmat", ".", "rightvector"}], "-", 
    RowBox[{"(", 
     RowBox[{"selection", "/.", 
      RowBox[{"slope", "->", "denom"}]}], ")"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"Factor", "[", "poly", "]"}], "\[Rule]", "0"}]}]], "Input",
 CellChangeTimes->{{3.795384783911018*^9, 3.795384810357683*^9}, {
   3.795384934214786*^9, 3.7953849351892347`*^9}, 3.795457633493372*^9, {
   3.7954593062818737`*^9, 3.795459306415745*^9}, 3.7954603553141108`*^9},
 ExpressionUUID -> "188ab0d0-4547-44f3-a3f6-48a010bd19e6"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.795384789921788*^9, 3.795384821684745*^9}, 
   3.795384935838122*^9, 3.7953942325629377`*^9, 3.795394265393612*^9, {
   3.795394359929743*^9, 3.795394384757194*^9}, 3.795394444118216*^9, {
   3.7953944862084017`*^9, 3.795394527321855*^9}, 3.7953947975020027`*^9, 
   3.795395066763361*^9, 3.795395143910668*^9, 3.795395241356784*^9, 
   3.795395343438221*^9, 3.7953972078106956`*^9, 3.795457066054618*^9, 
   3.795457166042705*^9, 3.795457635635201*^9, 3.7954577046265173`*^9, 
   3.795457772905798*^9, 3.7954578425304937`*^9, 3.795459262135457*^9, {
   3.79545931037709*^9, 3.7954593356569*^9}, {3.7954603609707403`*^9, 
   3.795460374410652*^9}, 3.795544214218307*^9, 3.7955445260863457`*^9, 
   3.798980700044517*^9},
 ExpressionUUID -> "88a430d9-8fd2-4aa4-bee9-027ed9f5d898"]
}, Open  ]],

Cell["Selection is thus proportional to:", "Text",
 CellChangeTimes->{{3.7953949061390343`*^9, 3.795394910884624*^9}},
 Background->RGBColor[
  0.88, 1, 0.88],ExpressionUUID->"2d0e963f-0e5b-42b1-89d7-25699c689c15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"left", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], ".", "mutmat", ".", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"right", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ",", "smallterms",
    ",", "Factor"}], "]"}]], "Input",
 CellChangeTimes->{{3.79538556390664*^9, 3.795385588648755*^9}, {
  3.795394882385744*^9, 3.795394888048019*^9}, {3.795397215759638*^9, 
  3.795397216877694*^9}, {3.79554422662763*^9, 3.795544234178113*^9}},
 Background->RGBColor[0.88, 1, 0.88],
 ExpressionUUID -> "b4ca99b1-9226-492f-8617-cd5a16338e77"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "uI"}], " ", "vI", " ", "\[CapitalDelta]\[Alpha]"}], "+", 
  RowBox[{"S", " ", "uA", " ", "vE", " ", "\[CapitalDelta]\[Beta]A"}], "+", 
  RowBox[{"S", " ", "uI", " ", "vE", " ", "\[CapitalDelta]\[Beta]I"}], "+", 
  RowBox[{"S", " ", "uP", " ", "vE", " ", "\[CapitalDelta]\[Beta]P"}], "-", 
  RowBox[{"uA", " ", "vA", " ", "\[CapitalDelta]\[Kappa]A"}], "+", 
  RowBox[{"uE", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", " ", "vA"}], "-", "vE", "+", "vP", "-", 
     RowBox[{"f", " ", "vP"}]}], ")"}], " ", "\[CapitalDelta]\[Kappa]E"}], 
  "-", 
  RowBox[{"uI", " ", "vI", " ", "\[CapitalDelta]\[Kappa]I"}], "+", 
  RowBox[{"uP", " ", 
   RowBox[{"(", 
    RowBox[{"vI", "-", "vP"}], ")"}], " ", "\[CapitalDelta]\[Kappa]P"}], "+", 
  RowBox[{"uE", " ", 
   RowBox[{"(", 
    RowBox[{"vA", "-", "vP"}], ")"}], " ", "\[CapitalDelta]f", " ", 
   "\[Kappa]E"}]}]], "Output",
 CellChangeTimes->{
  3.795385589244852*^9, 3.795394888563682*^9, 3.795395066930008*^9, 
   3.795395144486392*^9, 3.7953952414209642`*^9, 3.795395343505889*^9, {
   3.795397212722184*^9, 3.795397217352903*^9}, 3.795457066524303*^9, 
   3.795457166191617*^9, 3.795457704680197*^9, 3.795457773071374*^9, 
   3.795457842609664*^9, 3.795459262395237*^9, {3.795459310458086*^9, 
   3.7954593361101503`*^9}, 3.79546037453001*^9, 3.7955442357046213`*^9, 
   3.795544526203685*^9, 3.79898070049188*^9},
 Background->RGBColor[0.88, 1, 0.88],
 ExpressionUUID -> "6527f49b-d387-4c51-b5a2-6aec58271c93"]
}, Open  ]],

Cell["\<\
S vE (uA \[CapitalDelta]\[Beta]A+ uI \[CapitalDelta]\[Beta]I + uP \
\[CapitalDelta]\[Beta]P)-uI vI \[CapitalDelta]\[Alpha]+uE ((1-f)vP+f vA-vE) \
\[CapitalDelta]\[Kappa]E+uE (vA-vP) \[CapitalDelta]f \[Kappa]E-uI vI \
\[CapitalDelta]\[Kappa]I-uP (vP-vI) \[CapitalDelta]\[Kappa]P-uA vA \
\[CapitalDelta]\[Kappa]A

This way of calculating selection makes it clearer what selection acts upon \
when a disease is spreading (\[Lambda]>0):

\t* Always favors increased transmission [\[CapitalDelta]\[Beta]A, \
\[CapitalDelta]\[Beta]P, \[CapitalDelta]\[Beta]I]
\t* Always favors lower virulence [\[CapitalDelta]\[Alpha]] and slower \
recovery [\[CapitalDelta]\[Kappa]I] 
\t* Always favors faster progression from E -> A/P [\[CapitalDelta]\[Kappa]E] \
because (1-f)vP+f vA>vE [see Note 1]
\t* Favors slower progression from P -> I [\[CapitalDelta]\[Kappa]P] if vP > \
vI [always true if \[Beta]I \[LessEqual] \[Beta]P (1+1/(D\[Lambda]) - see \
Note 2]
\t* Favors more asymptomatics individuals [\[CapitalDelta]f] only if vA>vP \
[true only with high enough \[Beta]A - see Note 3]
\t* Never favors faster progression from A -> R [\[CapitalDelta]\[Kappa]Am]\
\>", "Text",
 CellChangeTimes->{{3.795385749617373*^9, 3.7953857536570272`*^9}, {
   3.795385785011318*^9, 3.795385845871057*^9}, {3.7953859205626583`*^9, 
   3.7953860976166973`*^9}, {3.795386231133898*^9, 3.795386249529908*^9}, {
   3.7953868651569138`*^9, 3.795386968832485*^9}, {3.795387174941731*^9, 
   3.795387230876944*^9}, {3.795394930551478*^9, 3.7953950016167927`*^9}, {
   3.7953952576468277`*^9, 3.79539527642688*^9}, {3.7953972225247297`*^9, 
   3.7953972943786297`*^9}, {3.795397352340024*^9, 3.795397372106493*^9}, 
   3.795397405351387*^9, {3.795397435720532*^9, 3.795397477871873*^9}, {
   3.795397526898275*^9, 3.795397578209035*^9}, {3.7953979623836823`*^9, 
   3.795397963538535*^9}, {3.79539829154974*^9, 3.79539829717551*^9}, {
   3.7953987210751543`*^9, 3.795398763075148*^9}, {3.7953989135589848`*^9, 
   3.795398979940229*^9}, {3.7954003407797327`*^9, 3.795400342987261*^9}, {
   3.79545775557843*^9, 3.7954577636597*^9}, {3.7954616278697977`*^9, 
   3.795461665150717*^9}, {3.795544537786942*^9, 3.795544575096037*^9}, {
   3.7957875248934717`*^9, 3.795787545935527*^9}, {3.795787604499702*^9, 
   3.795787616351643*^9}, 3.795788715553712*^9, {3.798921460429809*^9, 
   3.7989215371658707`*^9}},
 Background->RGBColor[0.88, 1, 0.88],
 ExpressionUUID -> "d54ce338-75d1-4534-a484-6d868daa5e92"],

Cell["\<\
[Note 1] In a spreading disease, (1-f)vP+f vA is always greater than vE \
because the next stage individuals (P&A)  pass on the disease earlier than \
exposed individuals, contributing earlier to growth.\
\>", "Text",
 CellChangeTimes->{
  3.7954616559114943`*^9, {3.795754069476379*^9, 3.795754075378872*^9}},
 ExpressionUUID -> "bd5506d8-101a-49a3-93ff-c037560e986c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "f"}], ")"}], 
     RowBox[{"leftvector", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", "f", ")"}], 
     RowBox[{"leftvector", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}], "-", 
    RowBox[{"leftvector", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"poly", "\[Equal]", "0"}], ",", "\[Beta]P"}], "]"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.795386731032893*^9, 3.795386734667595*^9}, {
   3.7953868024538593`*^9, 3.795386807529208*^9}, {3.795386851092207*^9, 
   3.795386857321884*^9}, 3.7953952874148912`*^9, {3.795397529681952*^9, 
   3.7953975422389193`*^9}},
 ExpressionUUID -> "d9fb4764-1c30-4034-8c20-43b16d9ab983"],

Cell[BoxData[
 RowBox[{"{", 
  FractionBox[
   RowBox[{"vE", " ", "\[Lambda]"}], "\[Kappa]E"], "}"}]], "Output",
 CellChangeTimes->{
  3.79538673513861*^9, 3.7953868082628193`*^9, 3.7953868577705593`*^9, 
   3.7953942326955557`*^9, 3.795394265492693*^9, {3.795394360030046*^9, 
   3.795394384860237*^9}, {3.795394503746073*^9, 3.795394527429166*^9}, 
   3.79539479775028*^9, 3.795394840662835*^9, 3.7953950671300697`*^9, 
   3.795395144619638*^9, 3.795395241489871*^9, {3.795395282498522*^9, 
   3.795395287884543*^9}, 3.795395343571354*^9, 3.795397506017633*^9, 
   3.7953975425020103`*^9, 3.7954570666272707`*^9, 3.795457166305561*^9, 
   3.79545770472989*^9, 3.7954577731877203`*^9, 3.795457842692342*^9, 
   3.795459262510652*^9, {3.795459310573533*^9, 3.795459336242969*^9}, 
   3.795460374596717*^9, 3.7955442466983957`*^9, 3.795544526269588*^9, 
   3.7989807005851927`*^9},
 ExpressionUUID -> "a637958b-ab9c-4417-940d-7d09bf237621"]
}, Open  ]],

Cell["\<\
[Note 2] vP is greater than vI as long as \[Beta]I \[LessEqual] \[Beta]P (1+(\
\[Alpha]+\[Gamma])/(\[Lambda])) because infected individuals have less time \
to pass on the disease than pre-asymptomatics.\
\>", "Text",
 CellChangeTimes->{{3.795386976330306*^9, 3.795386978116839*^9}, {
   3.795387119333457*^9, 3.795387165133754*^9}, {3.795387206161438*^9, 
   3.795387218252338*^9}, {3.795395389740952*^9, 3.795395410763316*^9}, 
   3.795397583792036*^9, {3.795400312792049*^9, 3.795400326065832*^9}, {
   3.795459790193267*^9, 3.7954597970840197`*^9}, {3.7957540825940723`*^9, 
   3.795754099110956*^9}, {3.798921455271895*^9, 3.7989214564683104`*^9}},
 ExpressionUUID -> "695a4912-5260-4d96-a5d2-8a8c953fadc4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"leftvector", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "-", 
   RowBox[{"leftvector", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.795395354379122*^9, {3.795398532425527*^9, 3.795398561260695*^9}},
 ExpressionUUID -> "63ef4ca1-4463-46e3-beac-960114a2fc32"],

Cell[BoxData[
 FractionBox[
  RowBox[{"S", " ", "vE", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], " ", "\[Beta]P"}], "-", 
     RowBox[{"\[Beta]P", " ", "\[Kappa]I"}], "+", 
     RowBox[{"\[Beta]I", " ", "\[Lambda]"}], "-", 
     RowBox[{"\[Beta]P", " ", "\[Lambda]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[Kappa]P", "+", "\[Lambda]"}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.795395354842441*^9, 3.795397687494967*^9, {3.795398534054551*^9, 
   3.795398561973521*^9}, 3.795400264796009*^9, 3.7954002971695957`*^9, 
   3.7954004221437273`*^9, 3.795457066742975*^9, 3.795457166423358*^9, 
   3.7954577047792997`*^9, 3.7954577733030787`*^9, 3.795457842775711*^9, 
   3.795459262628564*^9, {3.795459310654748*^9, 3.795459336508916*^9}, 
   3.795459763064414*^9, 3.795460374663053*^9, 3.7955442490356817`*^9, 
   3.79554452633635*^9, 3.798980700666204*^9},
 ExpressionUUID -> "708d4a26-66b7-47ed-a662-1f7208fe815b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "\[Equal]", "0"}], ",", "\[Beta]I"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.795400265210046*^9, 3.795400298996561*^9}, {
  3.7954597649931183`*^9, 3.795459766477985*^9}},
 ExpressionUUID -> "61b90670-6696-41a1-8c63-f9386079d7f7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Beta]I", "\[Rule]", 
    FractionBox[
     RowBox[{"\[Beta]P", " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}]}], 
     "\[Lambda]"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.795400270498743*^9, 3.7954002995845833`*^9}, 
   3.795400423926076*^9, 3.795457066860036*^9, 3.7954571665403547`*^9, 
   3.7954577048286*^9, 3.795457773422669*^9, 3.795457842991315*^9, 
   3.795459262745615*^9, {3.795459310758046*^9, 3.795459336775*^9}, 
   3.7954597670810204`*^9, 3.795460374729989*^9, 3.795544250083261*^9, 
   3.7955445264022408`*^9, 3.798980700751686*^9},
 ExpressionUUID -> "9bb98b37-8c01-4ecb-9d6a-e3aaefeb9407"]
}, Open  ]],

Cell[TextData[{
 "[Note 3] vP is greater than vA as long as presymptomatics are expected to \
give rise to enough more cases than asymptomatics that ",
 Cell[BoxData[
  RowBox[{
   FractionBox["\[Beta]P", 
    RowBox[{"\[Kappa]P", "+", "\[Lambda]"}]], "\[GreaterEqual]", 
   FractionBox["\[Beta]A", 
    RowBox[{"\[Kappa]A", "+", "\[Lambda]"}]]}]],
  CellChangeTimes->{
   3.795398057311811*^9, {3.795398090577791*^9, 3.7953980976699047`*^9}},
  ExpressionUUID->"7953e88f-adee-4233-b83a-6a44d75079de"],
 " (symptomatic infectious individuals make this condition even easier to \
satisfy)."
}], "Text",
 CellChangeTimes->{{3.795386976330306*^9, 3.795386978116839*^9}, {
   3.795387119333457*^9, 3.795387165133754*^9}, {3.795387206161438*^9, 
   3.795387218252338*^9}, {3.795395389740952*^9, 3.795395410763316*^9}, 
   3.795397583792036*^9, 3.795397715676396*^9, 3.795397784245831*^9, {
   3.7953981583727007`*^9, 3.795398185265168*^9}, {3.795398225849659*^9, 
   3.795398281642386*^9}, 3.795398481562909*^9, {3.795398616112328*^9, 
   3.795398621778901*^9}, {3.795754106577724*^9, 
   3.795754111809712*^9}},ExpressionUUID->"fe1117f8-d22b-4803-95fc-\
9f2144eb8e84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"leftvector", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "-", 
    RowBox[{"leftvector", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]P", ",", "\[Beta]I", ",", "\[Beta]A"}], "}"}], ",", 
   "Factor"}], "]"}]], "Input",
 CellChangeTimes->{{3.795398056859058*^9, 3.795398097227618*^9}},
 ExpressionUUID -> "43ee5754-fbfd-4ac6-b18e-4d1840c29f17"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"S", " ", "vE", " ", "\[Beta]A"}], 
   RowBox[{"\[Kappa]A", "+", "\[Lambda]"}]], "-", 
  FractionBox[
   RowBox[{"S", " ", "vE", " ", "\[Beta]P"}], 
   RowBox[{"\[Kappa]P", "+", "\[Lambda]"}]], "-", 
  FractionBox[
   RowBox[{"S", " ", "vE", " ", "\[Beta]I", " ", "\[Kappa]P"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", "\[Kappa]I", "+", "\[Lambda]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"\[Kappa]P", "+", "\[Lambda]"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.795398057311811*^9, {3.795398090577791*^9, 3.7953980976699047`*^9}, 
   3.795398301877666*^9, {3.795400510935843*^9, 3.795400533762643*^9}, 
   3.7954570671259604`*^9, 3.79545716677435*^9, 3.795457704929233*^9, 
   3.795457773654973*^9, 3.79545784332524*^9, 3.795459262978819*^9, {
   3.795459310906073*^9, 3.795459337645774*^9}, 3.795460374796351*^9, 
   3.79554425333673*^9, 3.795544526469523*^9, 3.798980700834462*^9},
 ExpressionUUID -> "a2ac1757-89b5-4045-97b4-649b7af232a0"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Figure 3 - Numerical analyses", "Subsection",
 CellChangeTimes->{{3.7955366113427*^9, 3.7955366164080772`*^9}, 
   3.795801538077416*^9, {3.796782227562502*^9, 3.796782232651113*^9}, {
   3.7989261907219563`*^9, 3.7989261911402597`*^9}, {3.798930816414566*^9, 
   3.798930817281575*^9}, {3.79969570800991*^9, 3.799695708984808*^9}},
 ExpressionUUID -> "ced8bf48-01c2-4b2a-b96e-7faf028e06ee"],

Cell[CellGroupData[{

Cell["Code", "Subsubsection",
 CellChangeTimes->{{3.796666752229251*^9, 3.796666752958826*^9}},
 ExpressionUUID -> "c6b80917-27fc-46f5-b1e7-b2813aec3a01"],

Cell["Common settings", "Text",
 CellChangeTimes->{{3.796666761037819*^9, 3.796666764817444*^9}, {
  3.796672456858787*^9, 3.7966724607240677`*^9}},
 ExpressionUUID -> "c29e9377-ae41-4174-9f31-b84904e4719a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"Off", "[", 
   RowBox[{"General", "::", "spell1"}], "]"}], "MR"], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"Off", "[", 
   RowBox[{"General", "::", "spell"}], "]"}], "MR"], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   StyleBox[
    RowBox[{"NDSolve", "::", "nlnum"}], "MessageName"], 
   StyleBox["]", "MessageName"]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfinal", "=", "500"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfig", "=", "500"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"label", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<Time (days)\>\"", ",", "\"\<Frequency\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"label", "=", "None"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.4161128348858385`*^9, 3.416112844259699*^9}, {
   3.416112881552038*^9, 3.416112883348695*^9}, {3.4161134184688807`*^9, 
   3.416113428467601*^9}, 3.416139388198444*^9, 3.4161395505516205`*^9, {
   3.416218382304528*^9, 3.4162183826795044`*^9}, {3.4162193171040726`*^9, 
   3.4162193178227763`*^9}, 3.4335673959144773`*^9, 3.433567436976452*^9, {
   3.4335713740041823`*^9, 3.433571380754096*^9}, {3.4480826678769674`*^9, 
   3.4480826917829113`*^9}, {3.4480827384385643`*^9, 3.448082781703635*^9}, {
   3.4480829436390624`*^9, 3.4480829482640033`*^9}, {3.6175271849861135`*^9, 
   3.6175272829250135`*^9}, {3.617527314590599*^9, 3.617527725501156*^9}, {
   3.6175277615129566`*^9, 3.6175279380617914`*^9}, {3.6175280090473423`*^9, 
   3.617528024632123*^9}, {3.617528650804524*^9, 3.6175288042381983`*^9}, {
   3.617529885182274*^9, 3.617530288597533*^9}, {3.617530421730193*^9, 
   3.617530422550234*^9}, {3.61753054263024*^9, 3.617530579932105*^9}, {
   3.617530615595889*^9, 3.617530639187069*^9}, {3.617530719235073*^9, 
   3.6175307202391253`*^9}, {3.6175308487495527`*^9, 3.617530855399885*^9}, 
   3.617530935025868*^9, {3.617530973549795*^9, 3.617530979510093*^9}, {
   3.6175310276865053`*^9, 3.6175310679485183`*^9}, 3.6175311967157335`*^9, {
   3.6175313851780343`*^9, 3.6175313869986167`*^9}, {3.6175315436217656`*^9, 
   3.617531544521901*^9}, {3.6175323834723682`*^9, 3.6175323839523973`*^9}, {
   3.617532730966709*^9, 3.617532731466734*^9}, 3.6175422878816776`*^9, 
   3.6175433647733555`*^9, {3.617628047854742*^9, 3.6176280494399004`*^9}, {
   3.6708499525126762`*^9, 3.670849986874257*^9}, {3.670908302375362*^9, 
   3.67090833371317*^9}, {3.6713450344679565`*^9, 3.6713450394290113`*^9}, {
   3.6713500490300355`*^9, 3.671350050360104*^9}, 3.6718119185762367`*^9, {
   3.6830268660778074`*^9, 3.6830269247606745`*^9}, {3.7932520467384253`*^9, 
   3.7932522780993557`*^9}, {3.793252309330852*^9, 3.793252370258357*^9}, {
   3.793252429812289*^9, 3.793252433638415*^9}, {3.7932527008478785`*^9, 
   3.7932527099799166`*^9}, {3.7932542371116366`*^9, 3.793254283218315*^9}, {
   3.7932547402176485`*^9, 3.79325476738878*^9}, {3.7932553337278647`*^9, 
   3.7932553677405186`*^9}, {3.793255865666687*^9, 3.793255905821158*^9}, {
   3.7932802958463106`*^9, 3.793280297552601*^9}, {3.793280363520993*^9, 
   3.7932803640344677`*^9}, {3.7932809868753977`*^9, 
   3.7932810074116583`*^9}, {3.7932810520897775`*^9, 3.7932810818664227`*^9}, 
   3.7932821094498477`*^9, {3.7932945244332867`*^9, 3.793294577621045*^9}, {
   3.7932947213830147`*^9, 3.7932947431537323`*^9}, {3.7932952033794823`*^9, 
   3.793295211283325*^9}, {3.793295957934411*^9, 3.793295958406705*^9}, {
   3.7936170225933914`*^9, 3.7936170969759502`*^9}, {3.7936171325949373`*^9, 
   3.793617138290338*^9}, {3.7937670761390533`*^9, 3.7937670803142776`*^9}, {
   3.7937671577794476`*^9, 3.7937672513454533`*^9}, {3.793767282244646*^9, 
   3.79376741574907*^9}, {3.7937674521978397`*^9, 3.793767653633992*^9}, {
   3.7937676861663694`*^9, 3.79376788053158*^9}, {3.7937679282330427`*^9, 
   3.7937679972735634`*^9}, {3.7937682067219715`*^9, 
   3.7937682509500318`*^9}, {3.7937682848297515`*^9, 
   3.7937686171558514`*^9}, {3.7937686498817406`*^9, 3.793768706131793*^9}, {
   3.793768870220974*^9, 3.793769250549735*^9}, {3.7937694118055735`*^9, 
   3.7937694429201236`*^9}, {3.7937695213729577`*^9, 3.7937696007975492`*^9}, 
   3.7937696772265415`*^9, {3.793769779290016*^9, 3.7937698373349175`*^9}, {
   3.7937701470326366`*^9, 3.7937702623063354`*^9}, {3.793770659443477*^9, 
   3.7937708630123096`*^9}, {3.7937710121449113`*^9, 
   3.7937710185228415`*^9}, {3.7937710537581453`*^9, 3.793771115287094*^9}, {
   3.793771161655549*^9, 3.7937712259674363`*^9}, 3.7937713041117287`*^9, 
   3.7937714415243998`*^9, {3.793771518154591*^9, 3.7937715316510015`*^9}, {
   3.7937716088372993`*^9, 3.79377165215051*^9}, 3.793771706283412*^9, {
   3.7937717775286827`*^9, 3.793771785437127*^9}, {3.7937719787012568`*^9, 
   3.7937720325703306`*^9}, {3.7937753834127083`*^9, 3.79377538535345*^9}, {
   3.793775429720338*^9, 3.7937754371654105`*^9}, 3.7937774477899094`*^9, {
   3.7937776058210936`*^9, 3.7937776061603746`*^9}, {3.793778307255213*^9, 
   3.793778390176879*^9}, {3.7937784307743425`*^9, 3.7937784332423587`*^9}, {
   3.793778829428452*^9, 3.793778829827566*^9}, {3.7937790967571783`*^9, 
   3.7937794490182104`*^9}, {3.793779502668833*^9, 3.7937795308208227`*^9}, {
   3.793779568361616*^9, 3.7937796339575853`*^9}, {3.793779729158598*^9, 
   3.7937798675464544`*^9}, {3.7937799071707087`*^9, 
   3.7937800627560267`*^9}, {3.7937801069305253`*^9, 3.793780110895706*^9}, {
   3.7937807281638107`*^9, 3.7937807324184446`*^9}, {3.793781624458156*^9, 
   3.7937816248194933`*^9}, 3.793781689925479*^9, {3.7937818821204233`*^9, 
   3.7937818960107803`*^9}, 3.793782031499791*^9, {3.793791360653163*^9, 
   3.7937913638665776`*^9}, {3.7937914143739915`*^9, 3.793791418425779*^9}, 
   3.793791459038638*^9, 3.7937916096347203`*^9, {3.793791799149558*^9, 
   3.793791804873181*^9}, {3.7937919308682613`*^9, 3.7937919407278514`*^9}, {
   3.793792057369224*^9, 3.7937920687258153`*^9}, {3.7938032254775543`*^9, 
   3.79380326174209*^9}, {3.79380337798571*^9, 3.7938034506905203`*^9}, 
   3.793803530042262*^9, 3.7938035922401824`*^9, {3.793803637201274*^9, 
   3.7938036375801983`*^9}, {3.7938037428668327`*^9, 3.793803743238055*^9}, {
   3.7938038098833137`*^9, 3.793803811941939*^9}, 3.793804001575981*^9, {
   3.7938041002974806`*^9, 3.793804195117983*^9}, {3.79380428199909*^9, 
   3.79380428235896*^9}, {3.793804320302788*^9, 3.793804320838462*^9}, 
   3.793804434028906*^9, 3.7938053122627068`*^9, {3.7938053846204944`*^9, 
   3.7938053851327877`*^9}, 3.79380543668266*^9, 3.793805569647746*^9, {
   3.7938082024894543`*^9, 3.7938082221550617`*^9}, 3.793808277113516*^9, {
   3.7938083428998833`*^9, 3.7938083654414053`*^9}, {3.793875775714511*^9, 
   3.793875776070907*^9}, {3.793939352702578*^9, 3.7939393530696907`*^9}, {
   3.7939416351642933`*^9, 3.793941635884459*^9}, {3.79394194907939*^9, 
   3.793941949813406*^9}, {3.793942838625359*^9, 3.793942840822699*^9}, {
   3.793942890452755*^9, 3.7939428924893637`*^9}, {3.794133693288739*^9, 
   3.7941337075610723`*^9}, {3.794133742396649*^9, 3.794133765459721*^9}, {
   3.794133797773653*^9, 3.7941338054116383`*^9}, {3.794176477740041*^9, 
   3.7941765280802135`*^9}, 3.7941772665933886`*^9, {3.794177370271239*^9, 
   3.7941773748807344`*^9}, {3.7941774214809585`*^9, 3.794177460263593*^9}, {
   3.7941776742408447`*^9, 3.7941776795108395`*^9}, {3.7941784556720095`*^9, 
   3.794178459241479*^9}, 3.7941785871140323`*^9, {3.7941786936419473`*^9, 
   3.794178714741746*^9}, {3.7952384691693034`*^9, 3.7952384787391577`*^9}, {
   3.7952385218612804`*^9, 3.7952386144401717`*^9}, {3.795238646264972*^9, 
   3.7952386793063345`*^9}, {3.7952387129964633`*^9, 3.795239024527986*^9}, {
   3.79523908622867*^9, 3.7952390868519077`*^9}, {3.795239118854699*^9, 
   3.795239328048627*^9}, {3.7952393744146113`*^9, 3.7952394398999777`*^9}, {
   3.795239493710269*^9, 3.7952396890510397`*^9}, {3.7952397407880754`*^9, 
   3.795239774380334*^9}, {3.795239805662438*^9, 3.795239813936191*^9}, {
   3.7952398783966427`*^9, 3.795239910100745*^9}, {3.795239943384858*^9, 
   3.79524000774778*^9}, {3.795240061062271*^9, 3.79524007933016*^9}, {
   3.795240122638049*^9, 3.795240189815981*^9}, {3.7952402228009825`*^9, 
   3.7952402890887737`*^9}, {3.7952403253918924`*^9, 
   3.7952405901603613`*^9}, {3.7952406809759674`*^9, 
   3.7952406834835987`*^9}, {3.7952407217648506`*^9, 3.795240742457837*^9}, {
   3.795240962938321*^9, 3.7952409654936075`*^9}, {3.7952410010326457`*^9, 
   3.7952410079386744`*^9}, {3.795241165885907*^9, 3.7952411947849007`*^9}, {
   3.7952413165085754`*^9, 3.7952413168936787`*^9}, {3.795241668360338*^9, 
   3.795241672341084*^9}, {3.7952417258676414`*^9, 3.7952418019040327`*^9}, {
   3.7952421291060147`*^9, 3.795242129575966*^9}, {3.7952425950269012`*^9, 
   3.795242596262283*^9}, {3.7952432951140366`*^9, 3.7952433466588306`*^9}, {
   3.7952435247282705`*^9, 3.7952435976491127`*^9}, {3.7953270784802656`*^9, 
   3.795327084401738*^9}, {3.795327256290831*^9, 3.795327262537977*^9}, {
   3.795327334158845*^9, 3.795327338834541*^9}, 3.7953274690375347`*^9, {
   3.7953275404930964`*^9, 3.795327575935504*^9}, {3.795328274474171*^9, 
   3.7953282783710756`*^9}, {3.7953285809940543`*^9, 3.795328586039318*^9}, {
   3.79542703109338*^9, 3.795427041096656*^9}, {3.795427115422948*^9, 
   3.795427152559721*^9}, {3.795486783578695*^9, 3.795486811833171*^9}, {
   3.795486842752037*^9, 3.79548686137853*^9}, {3.7954878918674097`*^9, 
   3.7954878922570705`*^9}, {3.7954882469698615`*^9, 
   3.7954883480560017`*^9}, {3.7954887438129187`*^9, 
   3.7954888420416813`*^9}, {3.7954888774151545`*^9, 
   3.7954888887740707`*^9}, {3.795488975883173*^9, 3.7954890005008707`*^9}, {
   3.7954894224543257`*^9, 3.7954894925729628`*^9}, {3.795490196770687*^9, 
   3.795490201324075*^9}, 3.795490305916844*^9, {3.795490412359619*^9, 
   3.79549043642258*^9}, {3.7954920706441755`*^9, 3.7954920710075827`*^9}, {
   3.795506824590975*^9, 3.7955069332809925`*^9}, {3.795507028943137*^9, 
   3.7955070449274483`*^9}, {3.795507075018781*^9, 3.7955071052061343`*^9}, {
   3.7955072277820573`*^9, 3.7955072287078376`*^9}, 3.795507300084668*^9, {
   3.795507925825162*^9, 3.7955079343149266`*^9}, {3.7955080585886593`*^9, 
   3.795508115834535*^9}, {3.7955081508957405`*^9, 3.795508151279022*^9}, {
   3.795527967769864*^9, 3.7955279717443447`*^9}, {3.795528041362472*^9, 
   3.795528044999992*^9}, {3.795532768945137*^9, 3.795532811609736*^9}, {
   3.795532987324922*^9, 3.795533005163423*^9}, {3.7955330713730097`*^9, 
   3.7955330879033117`*^9}, {3.7955331269996567`*^9, 3.795533155433947*^9}, {
   3.795533197125471*^9, 3.795533200362115*^9}, {3.795533254232605*^9, 
   3.7955332634103622`*^9}, {3.7955332954754057`*^9, 3.795533297809287*^9}, 
   3.7955338314644127`*^9, {3.795533862124702*^9, 3.7955338645695677`*^9}, {
   3.795534602791931*^9, 3.795534607898134*^9}, {3.7955349196957893`*^9, 
   3.795534920009066*^9}, {3.795596721224597*^9, 3.795596759921836*^9}, {
   3.7955967946935835`*^9, 3.795596930242381*^9}, {3.796664254272159*^9, 
   3.796664262834317*^9}, {3.796664306590403*^9, 3.796664318857242*^9}, {
   3.7966644846841173`*^9, 3.7966645353363743`*^9}, {3.796665706607801*^9, 
   3.796665768495434*^9}, {3.796666789312475*^9, 3.79666680124384*^9}, {
   3.796666860977997*^9, 3.7966668710805264`*^9}, 3.796671902564974*^9, 
   3.7966721983292*^9, {3.796673464021304*^9, 3.796673468778533*^9}, {
   3.796677676984585*^9, 3.796677677617597*^9}},
 Background->RGBColor[1, 1, 0],
 ExpressionUUID -> "955c69cd-cf5d-440f-aa71-8d59bb049359"],

Cell[BoxData[
 RowBox[{
  RowBox[{"parvec", "=", 
   RowBox[{"{", 
    RowBox[{
    "\[Beta]", ",", " ", "\[Beta]m", ",", "\[Alpha]", ",", " ", "\[Alpha]m", 
     ",", "\[Kappa]yP", ",", "\[Kappa]yPm", ",", "f", ",", "fm", ",", 
     "\[Kappa]yE", ",", " ", "\[Kappa]yI", ",", "\[Kappa]yA", ",", " ", "c1", 
     ",", "c2", ",", "c3", ",", "mut"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7966645977554283`*^9, 3.7966646623809547`*^9}, {
   3.796665257656982*^9, 3.7966652589655027`*^9}, {3.796665291405052*^9, 
   3.7966652935051928`*^9}, 3.798925389881586*^9},
 ExpressionUUID -> "d9a25fd0-8234-4f24-81d4-06abf1335c6f"],

Cell[BoxData[{
 RowBox[{"Clear", "[", 
  RowBox[{"finalfreq", ",", "NSolution"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "vec_", "]"}], ":=", 
  RowBox[{
   RowBox[{"finalfreq", "[", "vec", "]"}], "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Beta]", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
       RowBox[{"\[Beta]m", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"\[Alpha]", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
       RowBox[{"\[Alpha]m", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], ",", 
       RowBox[{"\[Kappa]yP", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "5", "]"}], "]"}]}], ",", 
       RowBox[{"\[Kappa]yPm", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "6", "]"}], "]"}]}], ",", 
       RowBox[{"f", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "7", "]"}], "]"}]}], ",", 
       RowBox[{"fm", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "8", "]"}], "]"}]}], ",", 
       RowBox[{"\[Kappa]yE", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "9", "]"}], "]"}]}], ",", " ", 
       RowBox[{"\[Kappa]yI", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "10", "]"}], "]"}]}], ",", 
       RowBox[{"\[Kappa]yA", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "11", "]"}], "]"}]}], ",", 
       RowBox[{"c1", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "12", "]"}], "]"}]}], ",", 
       RowBox[{"c2", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "13", "]"}], "]"}]}], ",", 
       RowBox[{"c3", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "14", "]"}], "]"}]}], ",", 
       RowBox[{"mut", "=", 
        RowBox[{"vec", "[", 
         RowBox[{"[", "15", "]"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"REMAINING", " ", "PARAMETERS"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Beta]yA", "=", 
       RowBox[{"\[Beta]", "/", "10"}]}], ";", 
      RowBox[{"\[Beta]yP", "=", "\[Beta]"}], ";", 
      RowBox[{"\[Beta]yI", "=", 
       RowBox[{"\[Beta]", "/", "3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Kappa]yAm", "=", "\[Kappa]yA"}], ";", 
      RowBox[{"\[Kappa]yIm", "=", "\[Kappa]yI"}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Beta]yAm", "=", 
       RowBox[{"\[Beta]m", "/", "10"}]}], ";", 
      RowBox[{"\[Beta]yPm", "=", "\[Beta]m"}], ";", 
      RowBox[{"\[Beta]yIm", "=", 
       RowBox[{"\[Beta]m", "/", "3"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"E", ":", " ", 
        RowBox[{"Exposed", " ", 
         RowBox[{"(", 
          RowBox[{"non", "-", "infectious"}], ")"}], " ", "cases"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"A", ":", " ", 
        RowBox[{"asymptomatic", " ", "cases"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"P", ":", " ", 
        RowBox[{"pre", "-", 
         RowBox[{"symptomatic", " ", "cases"}]}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"S", ":", " ", 
        RowBox[{"symptomatic", " ", "cases"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"f", ":", " ", 
        RowBox[{
        "proportion", " ", "of", " ", "fsymptomatic", " ", "hosts"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"c", ":", " ", 
        RowBox[{"amount", " ", "of", " ", "distancing", " ", "applied"}]}], 
       " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "INOCULATION", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"start", "=", 
       SuperscriptBox["10", 
        RowBox[{"-", "5"}]]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"t", "=."}], ";", "\[IndentingNewLine]", 
      RowBox[{"c", "=."}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"c", "[", "t_", "]"}], ":=", 
       RowBox[{"Evaluate", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"t", "<", "t1min"}], ",", "0", ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"t", "<", "t1max"}], ",", "c1", ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"t", "<", "t2min"}], ",", "0", ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"t", "<", "t2max"}], ",", "c2", ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"t", "<", "t3min"}], ",", "0", ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"t", "<", "t3max"}], ",", "c3", ",", "0"}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "t", "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"c", "[", "t", "]"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Beta]yA", " ", 
           RowBox[{"yA", "[", "t", "]"}]}], "+", 
          RowBox[{"\[Beta]yP", " ", 
           RowBox[{"yP", "[", "t", "]"}]}], "+", 
          RowBox[{"\[Beta]yI", " ", 
           RowBox[{"yI", "[", "t", "]"}]}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"hm", "[", "t", "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"c", "[", "t", "]"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Beta]yAm", " ", 
           RowBox[{"yAm", "[", "t", "]"}]}], "+", 
          RowBox[{"\[Beta]yPm", " ", 
           RowBox[{"yPm", "[", "t", "]"}]}], "+", 
          RowBox[{"\[Beta]yIm", " ", 
           RowBox[{"yIm", "[", "t", "]"}]}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"sys", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"S", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"h", "[", "t", "]"}], "+", 
              RowBox[{"hm", "[", "t", "]"}]}], ")"}]}], " ", 
           RowBox[{"S", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yE", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{"h", "[", "t", "]"}], " ", 
            RowBox[{"S", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yE", " ", 
            RowBox[{"yE", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yA", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"f", " ", "\[Kappa]yE", " ", 
            RowBox[{"yE", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yA", " ", 
            RowBox[{"yA", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yP", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "f"}], ")"}], " ", "\[Kappa]yE", " ", 
            RowBox[{"yE", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yP", " ", 
            RowBox[{"yP", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yI", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Kappa]yP", " ", 
            RowBox[{"yP", "[", "t", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[Kappa]yI", "+", "\[Alpha]"}], ")"}], " ", 
            RowBox[{"yI", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yR", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Kappa]yA", " ", 
            RowBox[{"yA", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Kappa]yI", " ", 
            RowBox[{"yI", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yD", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Alpha]", " ", 
           RowBox[{"yI", "[", "t", "]"}]}]}]}], "}"}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{
       "yD", " ", "serves", " ", "as", " ", "a", " ", "counter", " ", "of", 
        " ", "the", " ", "cumulative", " ", "number", " ", "of", " ", 
        "deaths"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"sysm", "=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["yEm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{"hm", "[", "t", "]"}], " ", 
            RowBox[{"S", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yE", " ", 
            RowBox[{"yEm", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yAm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"fm", " ", "\[Kappa]yE", " ", 
            RowBox[{"yEm", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yAm", " ", 
            RowBox[{"yAm", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yPm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "fm"}], ")"}], " ", "\[Kappa]yE", " ", 
            RowBox[{"yEm", "[", "t", "]"}]}], "-", 
           RowBox[{"\[Kappa]yPm", " ", 
            RowBox[{"yPm", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yIm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Kappa]yPm", " ", 
            RowBox[{"yPm", "[", "t", "]"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"\[Kappa]yIm", "+", "\[Alpha]m"}], ")"}], " ", 
            RowBox[{"yIm", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yRm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Kappa]yAm", " ", 
            RowBox[{"yAm", "[", "t", "]"}]}], "+", 
           RowBox[{"\[Kappa]yIm", " ", 
            RowBox[{"yIm", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           SuperscriptBox["yDm", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
          RowBox[{"\[Alpha]m", " ", 
           RowBox[{"yIm", "[", "t", "]"}]}]}]}], "}"}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{
       "yDm", " ", "serves", " ", "as", " ", "a", " ", "counter", " ", "of", 
        " ", "the", " ", "cumulative", " ", "number", " ", "of", " ", 
        "deaths"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"FIRST", " ", "BOUT", " ", "OF", " ", "CONTROL"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"t1min", "=", "75"}], ";", "\[IndentingNewLine]", 
      RowBox[{"t1max", "=", "150"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"SECOND", " ", "BOUT", " ", "OF", " ", "CONTROL"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"t2min", "=", "225"}], ";", "\[IndentingNewLine]", 
      RowBox[{"t2max", "=", "300"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"THIRD", " ", "BOUT", " ", "OF", " ", "CONTROL"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"t3min", "=", "375"}], ";", "\[IndentingNewLine]", 
      RowBox[{"t3max", "=", "450"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"S", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
         RowBox[{
          RowBox[{"yE", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"start", 
           RowBox[{"(", 
            RowBox[{"1", "-", "mut"}], ")"}]}]}], ",", 
         RowBox[{
          RowBox[{"yA", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yP", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yI", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yR", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yD", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"initm", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"yEm", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"start", 
           RowBox[{"(", "mut", ")"}]}]}], ",", 
         RowBox[{
          RowBox[{"yAm", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yPm", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yIm", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yRm", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"yDm", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"var", "=", 
       RowBox[{"{", 
        RowBox[{
        "S", ",", "yE", ",", "yA", ",", "yP", ",", "yI", ",", "yR", ",", 
         "yD"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"varm", "=", 
       RowBox[{"{", 
        RowBox[{
        "yEm", ",", "yAm", ",", "yPm", ",", "yIm", ",", "yRm", ",", "yDm"}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NSolution", "[", "vec", "]"}], "=", "\[IndentingNewLine]", 
       RowBox[{"NDSolve", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"sys", ",", "sysm", ",", "init", ",", "initm"}], "}"}], 
          "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"var", ",", "varm"}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tfinal"}], "}"}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "100"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "R0", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<R0 of the wild type = \>\"", ",", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Beta]yA", " ", "f"}], "\[Kappa]yA"], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "f"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Beta]yP", " ", 
              RowBox[{"(", 
               RowBox[{"\[Alpha]", "+", "\[Kappa]yI"}], ")"}]}], "+", 
             RowBox[{"\[Beta]yI", " ", "\[Kappa]yP"}]}], ")"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]", "+", "\[Kappa]yI"}], ")"}], " ", 
           "\[Kappa]yP"}]]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "Rm", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<R0 of the mutant type = \>\"", ",", 
        RowBox[{
         FractionBox[
          RowBox[{"\[Beta]yAm", " ", "f"}], "\[Kappa]yAm"], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "f"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Beta]yPm", " ", 
              RowBox[{"(", 
               RowBox[{"\[Alpha]m", "+", "\[Kappa]yIm"}], ")"}]}], "+", 
             RowBox[{"\[Beta]yIm", " ", "\[Kappa]yPm"}]}], ")"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\[Alpha]m", "+", "\[Kappa]yIm"}], ")"}], " ", 
           "\[Kappa]yPm"}]]}]}], "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"CASE", " ", "MORTALITY"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Case mortality = \>\"", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "f"}], ")"}], 
         FractionBox["\[Alpha]", 
          RowBox[{"\[Kappa]yI", "+", "\[Alpha]"}]]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Case mortality (mutant) = \>\"", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "fm"}], ")"}], 
         FractionBox["\[Alpha]m", 
          RowBox[{"\[Kappa]yI", "+", "\[Alpha]m"}]]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"CUMULATIVE", " ", "MORTALITY"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Cumulative mortality (total) = \>\"", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"yD", "[", "tfinal", "]"}], "+", 
          RowBox[{"yDm", "[", "tfinal", "]"}]}], "/.", 
         RowBox[{"Flatten", "[", 
          RowBox[{"NSolution", "[", "vec", "]"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Cumulative mortality (mutant) = \>\"", ",", 
        RowBox[{
         RowBox[{"yDm", "[", "tfinal", "]"}], "/.", 
         RowBox[{"Flatten", "[", 
          RowBox[{"NSolution", "[", "vec", "]"}], "]"}]}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.796664929092071*^9, 3.796665156692325*^9}, {
   3.796665222690524*^9, 3.796665238580114*^9}, {3.796665297237145*^9, 
   3.796665303231967*^9}, 3.796665398911735*^9, {3.796665429751423*^9, 
   3.796665467142736*^9}, {3.796665794021421*^9, 3.796665802262817*^9}, {
   3.796665959789385*^9, 3.796665960309992*^9}, {3.7966660121358213`*^9, 
   3.796666014804558*^9}, {3.796666050265291*^9, 3.796666065468891*^9}, {
   3.7966661128754673`*^9, 3.796666147660692*^9}, {3.796666452284183*^9, 
   3.796666494542247*^9}, {3.796666564259611*^9, 3.796666567816587*^9}, 
   3.796666631672793*^9, {3.7966666661836576`*^9, 3.796666668061428*^9}, {
   3.7966668116652613`*^9, 3.7966668129915247`*^9}, {3.796666954029954*^9, 
   3.796666957462798*^9}, 3.796672158561154*^9, {3.796672371426942*^9, 
   3.7966723720426493`*^9}, {3.796673405003129*^9, 3.796673412072277*^9}, {
   3.7966734728282223`*^9, 3.796673474082473*^9}, {3.7966735520716476`*^9, 
   3.796673573841267*^9}, {3.796673631500847*^9, 3.796673631960051*^9}, {
   3.7966736759697847`*^9, 3.796673679433344*^9}, {3.7966737578683357`*^9, 
   3.796673761440154*^9}, {3.796673845609805*^9, 3.796673868939562*^9}, {
   3.7966739295777073`*^9, 3.7966739746628847`*^9}, {3.796677433605054*^9, 
   3.7966775429614897`*^9}, {3.796677585842512*^9, 3.796677721363153*^9}, {
   3.796677940803088*^9, 3.796677955640045*^9}, {3.7989093053017893`*^9, 
   3.798909305613696*^9}, {3.798909385784869*^9, 3.798909388558667*^9}, {
   3.798925334886963*^9, 3.798925338407535*^9}, 3.798925372219879*^9, {
   3.7989254182189074`*^9, 3.7989254421942368`*^9}, 3.798925838124942*^9},
 ExpressionUUID -> "002052a2-9cef-449c-81bf-1d3e39bc8536"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3a: Evolution of transmission \[Beta], no control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
  3.79667414806647*^9, 3.796674151575295*^9}, {3.798648138620607*^9, 
  3.7986481429757137`*^9}},
 ExpressionUUID -> "7d5e21ce-8ab9-4438-9191-8ef698caf60a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1.2"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "\[Rule]", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0"}], ",", 
     RowBox[{"c2", "->", "0"}], ",", 
     RowBox[{"c3", "\[Rule]", "0"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.7966886978193817`*^9, 3.796688729450388*^9}, 3.796779934339828*^9, {
   3.7967799646042013`*^9, 3.79678001703584*^9}, {3.796780096821123*^9, 
   3.796780097726459*^9}, {3.79678014185299*^9, 3.796780144581677*^9}, {
   3.7967802345391283`*^9, 3.7967802360429897`*^9}, {3.7967814863037243`*^9, 
   3.796781487404283*^9}, {3.7986529037365026`*^9, 3.798652915225585*^9}, 
   3.798925880472714*^9},
 ExpressionUUID -> "038c5510-e157-4ac1-b63a-aef7f5c7fdf6"],

Cell["\<\
The doublng time of the disease when rare, as calculated from the eigenvalue \
(\[OpenCurlyDoubleQuote]poly\[CloseCurlyDoubleQuote]) of the stability matrix:\
\>", "Text",
 CellChangeTimes->{{3.7966907220292*^9, 3.7966907585676317`*^9}, {
  3.796690822654565*^9, 3.796690833910757*^9}, {3.796779843729797*^9, 
  3.796779847572578*^9}, {3.796781614047514*^9, 3.7967816242440977`*^9}},
 ExpressionUUID -> "ba0ffdf3-ecdb-4d79-9c96-1235bdaefdfc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Sort", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"\[Kappa]E", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "S"}], " ", "\[Alpha]", " ", "\[Beta]P", " ",
                     "\[Kappa]A"}], "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", 
                    "\[Kappa]A"}], "-", 
                   RowBox[{
                   "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]I"}],
                    "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", 
                    "\[Kappa]I"}], "-", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]A", " ", 
                    "\[Kappa]P"}], "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], 
                   "-", 
                   RowBox[{
                   "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", "\[Kappa]P"}],
                    "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]A", " ", 
                    "\[Kappa]P"}], "-", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]I", " ", 
                    "\[Kappa]P"}], "+", 
                   RowBox[{
                   "\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "f"}], " ", "S", " ", "\[Alpha]", " ", 
                    "\[Beta]A", " ", "\[Kappa]E"}], "-", 
                   RowBox[{
                   "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", "\[Kappa]E"}], 
                   "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Alpha]", " ", "\[Beta]P", " ", 
                    "\[Kappa]E"}], "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]E"}], 
                   "-", 
                   RowBox[{
                   "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", "\[Kappa]E"}],
                    "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]A", " ", 
                    "\[Kappa]E"}], "-", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
                    "\[Kappa]I"}], "-", 
                   RowBox[{
                   "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", "\[Kappa]I"}],
                    "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E", " ", 
                    "\[Kappa]I"}], "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]I"}], 
                   "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]A", " ", "\[Kappa]P"}], 
                   "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
                   "-", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E", " ", 
                    "\[Kappa]P"}], "-", 
                   RowBox[{
                   "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", "\[Kappa]P"}],
                    "+", 
                   RowBox[{
                   "f", " ", "S", " ", "\[Beta]I", " ", "\[Kappa]E", " ", 
                    "\[Kappa]P"}], "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]E", " ", "\[Kappa]P"}], 
                   "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]I", " ", "\[Kappa]P"}], 
                   "+", 
                   RowBox[{
                   "\[Kappa]E", " ", "\[Kappa]I", " ", "\[Kappa]P"}]}], ")"}],
                  " ", "\[Lambda]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"\[Alpha]", " ", "\[Kappa]A"}], "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]E"}], "-", 
                   RowBox[{"f", " ", "S", " ", "\[Beta]A", " ", "\[Kappa]E"}],
                    "-", 
                   RowBox[{"S", " ", "\[Beta]P", " ", "\[Kappa]E"}], "+", 
                   RowBox[{"f", " ", "S", " ", "\[Beta]P", " ", "\[Kappa]E"}],
                    "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]E"}], "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]I"}], "+", 
                   RowBox[{"\[Kappa]E", " ", "\[Kappa]I"}], "+", 
                   RowBox[{"\[Alpha]", " ", "\[Kappa]P"}], "+", 
                   RowBox[{"\[Kappa]A", " ", "\[Kappa]P"}], "+", 
                   RowBox[{"\[Kappa]E", " ", "\[Kappa]P"}], "+", 
                   RowBox[{"\[Kappa]I", " ", "\[Kappa]P"}]}], ")"}], " ", 
                 SuperscriptBox["\[Lambda]", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                  "\[Alpha]", "+", "\[Kappa]A", "+", "\[Kappa]E", "+", 
                   "\[Kappa]I", "+", "\[Kappa]P"}], ")"}], " ", 
                 SuperscriptBox["\[Lambda]", "3"]}], "+", 
                SuperscriptBox["\[Lambda]", "4"]}], "/.", 
               RowBox[{"S", "\[Rule]", "1"}]}], "/.", 
              RowBox[{"\[Beta]A", "->", 
               RowBox[{"\[Beta]", "/", "10"}]}]}], "/.", 
             RowBox[{"\[Beta]P", "->", "\[Beta]"}]}], "/.", 
            RowBox[{"\[Beta]I", "->", 
             RowBox[{"\[Beta]", "/", "3"}]}]}], "/.", 
           RowBox[{"\[Kappa]A", "->", "\[Kappa]yA"}]}], "/.", 
          RowBox[{"\[Kappa]E", "->", "\[Kappa]yE"}]}], "/.", 
         RowBox[{"\[Kappa]P", "->", "\[Kappa]yP"}]}], "/.", 
        RowBox[{"\[Kappa]I", "->", "\[Kappa]yI"}]}], "/.", "pars"}], ")"}], 
     "\[Equal]", "0"}], ",", "\[Lambda]"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"\[Lambda]", " ", "t"}], "]"}], "\[Equal]", "2"}], ")"}], "/.", 
    RowBox[{"Last", "[", "%", "]"}]}], ",", "t"}], "]"}]}], "Input",
 CellChangeTimes->{{3.7966901414465227`*^9, 3.7966901419481707`*^9}, {
  3.796690177015966*^9, 3.796690237366644*^9}, {3.7966902681523647`*^9, 
  3.796690317739421*^9}, {3.796690472606928*^9, 3.796690474928656*^9}, {
  3.7966905066656322`*^9, 3.796690510953787*^9}, {3.796690600655954*^9, 
  3.796690602731243*^9}, {3.7966906403096867`*^9, 3.796690712613781*^9}, {
  3.7966907845374317`*^9, 3.796690796599963*^9}},
 ExpressionUUID -> "5b556429-1b7b-49dc-bb61-8c5c64dc8c19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", "1.1450036414753126`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", "0.43149577221617147`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", "0.11536375506130506`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", "\[Rule]", "0.1268631687527893`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.796690145137162*^9, 3.796690238059113*^9, {3.7966902820189342`*^9, 
   3.796690318352277*^9}, 3.796690475590436*^9, {3.796690516610406*^9, 
   3.796690536410672*^9}, {3.7966905681796417`*^9, 3.7966906579900846`*^9}, {
   3.796690692549904*^9, 3.796690712980442*^9}, {3.796690786765732*^9, 
   3.796690800362376*^9}, 3.7966908490304213`*^9, 3.796691321690483*^9, 
   3.796691514644053*^9, 3.796691593265388*^9, 3.7966916896602182`*^9, 
   3.7966919372711697`*^9, 3.796692134596149*^9, 3.796692237777768*^9, 
   3.7966923584963818`*^9, 3.796692504880992*^9, 3.796692623645166*^9, 
   3.7966928283062353`*^9, 3.796692971215629*^9, 3.7966931145073357`*^9, 
   3.7966931649383097`*^9, 3.796693466428802*^9, 3.796779834950597*^9, {
   3.796779951238456*^9, 3.796780031063991*^9}, 3.7967801467850227`*^9, 
   3.796780238760434*^9, 3.796781517593645*^9, 3.796781561528002*^9, 
   3.796781796241337*^9, 3.796781878698118*^9, 3.796783574282942*^9, 
   3.796784377180286*^9, 3.7967966619461503`*^9, 3.7983651371331635`*^9, 
   3.7986477211869593`*^9, 3.798647803286056*^9, 3.798647926242837*^9, 
   3.798648009115399*^9, 3.798648311585299*^9, {3.798652906320657*^9, 
   3.798652917589864*^9}, 3.7986552101856956`*^9, 3.798655742979288*^9, 
   3.798655909941969*^9, 3.798657222960964*^9, 3.798657508949107*^9, 
   3.798657612025261*^9, 3.798657739770995*^9, 3.798657886641625*^9, 
   3.7986597382222548`*^9, 3.798714295626635*^9, 3.7988261353261833`*^9, 
   3.798909015277974*^9, 3.798909309610301*^9, 3.7989093968164577`*^9, {
   3.798910511201887*^9, 3.7989105228306913`*^9}, {3.798925895594398*^9, 
   3.7989259062495823`*^9}, 3.798926240298183*^9, 3.798926615625533*^9, 
   3.7989271949318857`*^9, 3.798928078049836*^9, 3.79892844272053*^9, 
   3.79892998155805*^9, 3.7996957357921886`*^9, 3.7996968455070677`*^9, 
   3.80012575506291*^9},
 ExpressionUUID -> "911fe083-23dd-45cd-8619-baf341a3df6e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", "5.463738509564111`"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.796690145137162*^9, 3.796690238059113*^9, {3.7966902820189342`*^9, 
   3.796690318352277*^9}, 3.796690475590436*^9, {3.796690516610406*^9, 
   3.796690536410672*^9}, {3.7966905681796417`*^9, 3.7966906579900846`*^9}, {
   3.796690692549904*^9, 3.796690712980442*^9}, {3.796690786765732*^9, 
   3.796690800362376*^9}, 3.7966908490304213`*^9, 3.796691321690483*^9, 
   3.796691514644053*^9, 3.796691593265388*^9, 3.7966916896602182`*^9, 
   3.7966919372711697`*^9, 3.796692134596149*^9, 3.796692237777768*^9, 
   3.7966923584963818`*^9, 3.796692504880992*^9, 3.796692623645166*^9, 
   3.7966928283062353`*^9, 3.796692971215629*^9, 3.7966931145073357`*^9, 
   3.7966931649383097`*^9, 3.796693466428802*^9, 3.796779834950597*^9, {
   3.796779951238456*^9, 3.796780031063991*^9}, 3.7967801467850227`*^9, 
   3.796780238760434*^9, 3.796781517593645*^9, 3.796781561528002*^9, 
   3.796781796241337*^9, 3.796781878698118*^9, 3.796783574282942*^9, 
   3.796784377180286*^9, 3.7967966619461503`*^9, 3.7983651371331635`*^9, 
   3.7986477211869593`*^9, 3.798647803286056*^9, 3.798647926242837*^9, 
   3.798648009115399*^9, 3.798648311585299*^9, {3.798652906320657*^9, 
   3.798652917589864*^9}, 3.7986552101856956`*^9, 3.798655742979288*^9, 
   3.798655909941969*^9, 3.798657222960964*^9, 3.798657508949107*^9, 
   3.798657612025261*^9, 3.798657739770995*^9, 3.798657886641625*^9, 
   3.7986597382222548`*^9, 3.798714295626635*^9, 3.7988261353261833`*^9, 
   3.798909015277974*^9, 3.798909309610301*^9, 3.7989093968164577`*^9, {
   3.798910511201887*^9, 3.7989105228306913`*^9}, {3.798925895594398*^9, 
   3.7989259062495823`*^9}, 3.798926240298183*^9, 3.798926615625533*^9, 
   3.7989271949318857`*^9, 3.798928078049836*^9, 3.79892844272053*^9, 
   3.79892998155805*^9, 3.7996957357921886`*^9, 3.7996968455070677`*^9, 
   3.8001257550652514`*^9},
 ExpressionUUID -> "911fe083-23dd-45cd-8619-baf341a3df6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796677993541563*^9, 3.796678073273438*^9}, 
   3.798910154316429*^9, 3.798910187765225*^9, 3.798910242312059*^9, {
   3.7990161439009743`*^9, 3.799016143933751*^9}},
 ExpressionUUID -> "8c74bfc5-8e2e-464d-b680-7c284a088ac4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.800125755201824*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.7391574279379154`"}],
  SequenceForm["R0 of the mutant type = ", 2.7391574279379154`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.800125755205811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.8001257552202377`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.800125755229252*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016768489869798765`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016768489869798765`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.80012575523409*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981639968*^9, 3.79969573603876*^9, 
  3.799696845647633*^9, 3.800125755240347*^9}]
}, Open  ]],

Cell[BoxData["265"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674352960471*^9, 3.79667728927499*^9, 3.7966776894201193`*^9, {
   3.796677726429648*^9, 3.7966777442448273`*^9}, {3.7966778784631357`*^9, 
   3.796677904811221*^9}, {3.796678019427198*^9, 3.796678065125917*^9}, 
   3.796681920197859*^9, 3.796682027618973*^9, 3.7966877530503693`*^9, 
   3.796687870304674*^9, 3.796688098489977*^9, 3.796688736405006*^9, 
   3.7966891190293417`*^9, 3.796690849120008*^9, {3.796690888889802*^9, 
   3.796690895857486*^9}, 3.796693894327153*^9, 3.7967518963702583`*^9, 
   3.796752252272594*^9, 3.7967524300481033`*^9, {3.79675265911789*^9, 
   3.796752671703714*^9}, 3.796780031158366*^9, 3.796780146878481*^9, 
   3.796781564520233*^9, 3.796781796321018*^9, 3.796781878806176*^9, 
   3.796783574380929*^9, 3.796784377277505*^9, 3.796796662225836*^9, 
   3.798365137400753*^9, 3.798647721344379*^9, 3.7986478033806067`*^9, 
   3.798647926341177*^9, 3.798648009218124*^9, 3.798648311689402*^9, {
   3.7986529064169407`*^9, 3.798652917671363*^9}, 3.798655210367074*^9, 
   3.798655743066621*^9, 3.798655910176421*^9, 3.798657223400682*^9, 
   3.798657509050836*^9, 3.7986576121275806`*^9, 3.798657739884115*^9, 
   3.798657886744986*^9, 3.798659738304937*^9, 3.79871429572945*^9, 
   3.798826135446743*^9, 3.79890901543935*^9, 3.7989093097035646`*^9, 
   3.798909396892614*^9, {3.798910511309196*^9, 3.7989105229269133`*^9}, {
   3.798925895751905*^9, 3.7989259063511887`*^9}, 3.798926240432847*^9, 
   3.798926615712081*^9, 3.798927195034278*^9, 3.7989280781334047`*^9, 
   3.798928442810738*^9, 3.798929981658269*^9, 3.799695736058567*^9, 
   3.799696845681962*^9, 3.8001257552438374`*^9},
 ExpressionUUID -> "0d2f7171-2f6f-412b-b1ad-2c9b703712a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigTOP1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", "fSDashed", ",", 
    "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, {3.796674347420554*^9, 
   3.7966743477587757`*^9}, {3.796674381626519*^9, 3.7966743837492247`*^9}, {
   3.7966780818725967`*^9, 3.796678092090136*^9}, {3.7966781284158077`*^9, 
   3.796678283829677*^9}, {3.796678356288395*^9, 3.7966783726730328`*^9}, {
   3.7966784229969254`*^9, 3.796678425436117*^9}, {3.7966785330513783`*^9, 
   3.7966786365355167`*^9}, {3.7966812998556337`*^9, 3.796681327799061*^9}, {
   3.796681359402153*^9, 3.796681364465515*^9}, 3.79668141925086*^9, {
   3.7966815270625687`*^9, 3.796681572165103*^9}, {3.796681785603858*^9, 
   3.796681795511486*^9}, {3.796681976171627*^9, 3.7966819834339247`*^9}, {
   3.7966877381412563`*^9, 3.79668775005236*^9}, 3.7966880687302847`*^9, 
   3.7966945647524233`*^9, {3.79675190406423*^9, 3.796751905839028*^9}, 
   3.796751940139696*^9, {3.796751993110878*^9, 3.79675217112566*^9}, {
   3.7967522026974707`*^9, 3.796752263078944*^9}, {3.7967525141566477`*^9, 
   3.796752536568726*^9}, 3.796752650764069*^9, {3.798647575390394*^9, 
   3.798647761577011*^9}, {3.798647884299344*^9, 3.798647910508626*^9}, {
   3.7986552736536627`*^9, 3.798655429867436*^9}, {3.798655465097229*^9, 
   3.7986557060985107`*^9}, 3.798655893355291*^9, {3.79865748564135*^9, 
   3.798657497855126*^9}, 3.798657735688542*^9, 3.798657868083868*^9, {
   3.798659693982424*^9, 3.7986597242649717`*^9}, {3.7989100639197607`*^9, 
   3.798910071011417*^9}, 3.798910317846755*^9, 3.7989269564189453`*^9, {
   3.7989280747669497`*^9, 3.798928074953125*^9}, {3.798928121915924*^9, 
   3.798928143520063*^9}, {3.7989281843414*^9, 3.7989282398558064`*^9}, 
   3.798928429957953*^9, 3.798928473600739*^9, {3.798928559018237*^9, 
   3.798928588627709*^9}, {3.798928641940008*^9, 3.7989287440110617`*^9}, 
   3.798928776467749*^9, {3.79892880790781*^9, 3.79892881671721*^9}, {
   3.7989290955221987`*^9, 3.79892913646145*^9}, {3.798929185365611*^9, 
   3.7989291902936487`*^9}, {3.798929438635232*^9, 3.798929460364149*^9}, {
   3.798929624991852*^9, 3.7989297190146103`*^9}, {3.798929750540509*^9, 
   3.79892977878399*^9}, {3.7990161292347937`*^9, 3.799016129577323*^9}},
 ExpressionUUID -> "9b778e28-48ed-4b18-9f59-448b605994ba"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.800125755391461*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.7391574279379154`"}],
  SequenceForm["R0 of the mutant type = ", 2.7391574279379154`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.800125755398369*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.800125755405016*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.800125755409822*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.017056482621370862`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.017056482621370862`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.8001257554148493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.003299283740908259`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.003299283740908259],
  Editable->False]], "Print",
 CellChangeTimes->{3.798929981739887*^9, 3.7996957368914433`*^9, 
  3.799696845799231*^9, 3.800125755420298*^9}]
}, Open  ]],

Cell[BoxData["261"], "Output",
 CellChangeTimes->{{3.798928721916667*^9, 3.7989287257311773`*^9}, 
   3.798928817650303*^9, {3.7989290979335003`*^9, 3.798929137236945*^9}, {
   3.798929186520012*^9, 3.798929190938401*^9}, 3.7989294607974577`*^9, 
   3.7989296259852533`*^9, {3.7989296589274*^9, 3.7989297195057297`*^9}, {
   3.798929751546867*^9, 3.798929779701354*^9}, 3.798929981758307*^9, 
   3.799695736911153*^9, 3.799696845829557*^9, 3.800125755430045*^9}],

Cell[BoxData[
 RowBox[{"{", "0.5165984274213007`", "}"}]], "Output",
 CellChangeTimes->{{3.798928721916667*^9, 3.7989287257311773`*^9}, 
   3.798928817650303*^9, {3.7989290979335003`*^9, 3.798929137236945*^9}, {
   3.798929186520012*^9, 3.798929190938401*^9}, 3.7989294607974577`*^9, 
   3.7989296259852533`*^9, {3.7989296589274*^9, 3.7989297195057297`*^9}, {
   3.798929751546867*^9, 3.798929779701354*^9}, 3.798929981758307*^9, 
   3.799695736911153*^9, 3.799696845829557*^9, 3.8001257554351683`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJxF13k4Vd3bB/CMTaIyhJBooIRkiLBuQ8g8z/M8z/OYUqFIQslcSGUoKUPS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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwVlWlczAsbhke0iI4QOSRHtKDTDFon5nmaGtIiSSvtShrVoAnRSKaaViqV
lmlUlA5ZKtmKKElKRVqU+peIMNNo0SLzej/cv/vL9bs/Xvdqr6DdPlIkEunc
n/y/GaJZabaObbSQ1Te294Vywa7WotGDUwa9xQ+uxJ3kgk1moaoupwYsbehz
Q8O4ENxS1GZQ+QqmOFeJlHAuWM9xeL6S0wojOuH+T7hcIFY55gv4nfDNXkv8
NYYLR4ydTq+u7IGzjl1jM+e4EHHterGtsA8mKDyrD2lcsDIqzlrEGQDGjPKG
mBwuLH1eHPNGYRCoD010egq40LvnxrEL/C/gpn/F8fXNP3usm3ZLK4Wg5jD4
zq2aC6qS9kvMgmGQQUr1+0YuSG3rULYSimG92KSxroMLDW86pBU4oyD/15k3
FSIu3F7eeer7szHQtyCT7kxzIc2zc6RR4SdEHNOP/SkbCe6izr5E/iTYtQbL
mq6OhB/yXZWKlb9hZPDiYn+HSJifK6TKc+agSwlHQ6MuEjg1gSFTq6VRg+++
8HNbJIgHhbeHnkmjxaZxn5qPkdCmI9J6qSCL08NGNXWzo0BQIVoaz5+LO4sW
lXzDKNjUMfxDofIvzC8NoRo+joLr0SfeynGUMFCp1ptSHw2JK7dIf2pTwoeT
V3YLu6OBVfpbt5q8BJWbpdqqRNGg23v2QljfEiTuL6TlL+FBhX6i3Q8zZVT6
FW2/14sHDR/zWrrmLUdxJjU2RsKD76YNjTcyViHZcllUvHksKIcv8P7PRR2t
LqfmJiolAJXL09XkqiPPb0OnYH0CuPFmyVwuVsczUif2P8UEKDg/cpVP0sCL
o7sExgEJoJvbLjxfoIE3Vx1vktQmwO6ngtBjPzRxyM+nvC0sERLnUJLNYtej
kNk/NnvyHMjE7HrSc5+MQu/Slq8pSVCoSt4S109G8TVRhXRuEqx9F9WVJU3B
sBXv3NfdSILaIB8Hcx0KMmftEyXUJYF8lppV7mkKdroOpzTMJMF5cbaBndpG
1NvA3KThnww5OUl/3T2wCbnaX+6csEiBBxOhFZwfumiSO7eIvCEVUgf8aYly
eiicHo4z3ZIKrGaXKr6qHjYZMMf3W6eCxlVqTYWFHtr3/RPbHJQKyY5TL6fy
9FBV/KXF8k4qMMtPdIXY6WPzq8qcLnoaqAQfnwosM0BtT/naIr90OC1iG7qH
ULHXadjYrS8DRu9ubB+LpaKe+Y9f1aMZ4Bf+nR0voOI1qwVzDOUyYddCn9L7
dVTkjk/LWpIzQW3zHh2lFcY4S37cVoWTCbUhm9a+eGyMr3Y8b2erZoHCb+GC
zXO3oveDERUL/2zImu83KJMNaBvUWFZJEcDykMv1DiWA/FuHCod3COBiL1Fc
UAdo4GVibeAtgLQS5+BtY4DPNO0ZpDQBmF+/QjLVRCTrWxNnfgnAdHd6QkQ4
Yo7HlN8V30tgmBNaOGuzCfYIJF/IkAtr9E26JOl0PMIYuz+smA/0JsO7I3l0
jC47tHJkVT54+FFSBovpmBFHbyGR8yEnc5VlUzUdl7rmGNOs82G5ZOZBjoiO
8tp9FHpsPijWPcjcut0U5XdKy7FlLsNvZ12Xk+Om6OySO1ghewU6wjQ7x/cw
kOJbFp5KLgQz6UhTHXcGNnE0TxzBQrgZ31/sc5CBGcx4kYttIURl8SNawxg4
oFXF33m0EHTvL9YuKWBgmpvypad3C+H8qIQTMMHAACO9AYJ+FcyZHWsHsrZh
eWV2nqZXEdxzimG19G9H9bTbyp611/74R5LeWmiBtfKVMdkdt2DzwLDTw63W
mBSaddRoRRn4xhnfyq61wU9fZU/KNt0F0bpGSztTWzSd4n2u8amAJ47U+fVx
uxFKft0TJ1eBQdptpbciO4zULH6oZV0NfA97P1dre9QWpXtWjz+Di6PlPMcU
B7wguV6cvK0ODDLUxB9HHXFNOC1YPbweDslaaXyiOaO9O197YFcDmEWdzg+9
7IJV09k/rRa8gvlJvcz42fvQt9lBypTfBP4+MyRFS1dkfOn7YHOqGZgW6j2a
N9zQam30jITcAlKT8rzbk+7YvHGKYvq6BZ5lJNL2CTww0vdt3r2A17D3scr7
IhtPfNStevPw4jdQ8WKuF2XUE+0d+isXX38Dgd3T8mcKvJD9PJf/yaYVlulx
nc/be6MWT009RdQKCUeYiR0T3hh4Ptmm4exb2HPPcXCoaD/yzVPDFda2waf+
PA19Gx/8kJebd+B+G7DsuPNQ7IMKCiOhjy3bwbLBX0kp1xc7Clr3Zg+1g3jd
rdmrGQfw0Rh7voTTAV/OTS2dGD+AzI60har/dML1d/mKcnw/LO1oX95T3gkH
mB9utsFB/Bza3zJh8Q6C52gdDRo+iHdq5UKnvr4Dq4iXKiap/rjmYFF1SkQX
sOWCh7q3M7Evi16potENaa0lrgY/mbj+8KMVE7XdEBG562595iFksoMXget7
qKKN6GpZBWDtVml7D1IPvOgevfhIHID9zuq2dRd7oL4qPm/xhUDUWiLcQ9Xp
BZXidc2bzIIwJ35xqV1zLxhx1AdiPwdhKtu+5uFmArKN/O75fQ3CcQdtKQU9
Akhj/8VvEwahjfa/fz6QgDomRU9qNAiNr82UkowIcHI2jjohCULK6yccBo2A
LZlaSrrzWHhq+3TpK3MC9rJp5WpqLPxkuIzZ60rA/Dful5LWsHDv1o9eFHcC
HlHOxJLUWchiazqd8SBA7Vu1W48mC0N7843XeBMw5LVDNvNfFibPyR7w9SMg
dNcep4VGLPx729qK70cI0L7BpodTWWhIOxxHCyagZ166tsiYhTJt85zOsQmg
P+8kNdJYeGvhh8+U4wTI09yLeGYsbK73HDoaRkBFVnjKTwYL9/u359dwCAic
zA3z3c7Ck4oZLkvCCXhdNmBrZsFCPi/9cXkEAdxFMltKLVm4LkcYIMslQJ+l
qaFmzUJjsvffTpEEfG40V0za+YevHntyNYqAzA3+UxIbFoLuowOT0QT8D/JJ
QDE=
      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVl3c4198bxiWkQRIZIStZIdnj/TxmQvbMnh/bx8xINiV8Iw0a9iiihEoi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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVl3c4l+8XxyWVrJBRKsoOX5QtPefYWzYhe37MjIZkZ2WFJHvvVYREoagQ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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJxF13c8le//B3ArySw7s5AoZG+ut5Gyt+xx7L0zQkukoZKUskrUp9KQMpJ0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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{256, 0.49659842742130067`}, {266, 0.5365984274213007}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{256, 0.5365984274213007}, {266, 0.49659842742130067`}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8676848797564667}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8705648073294779}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{{3.798928721916667*^9, 3.7989287257311773`*^9}, 
   3.798928817650303*^9, {3.7989290979335003`*^9, 3.798929137236945*^9}, {
   3.798929186520012*^9, 3.798929190938401*^9}, 3.7989294607974577`*^9, 
   3.7989296259852533`*^9, {3.7989296589274*^9, 3.7989297195057297`*^9}, {
   3.798929751546867*^9, 3.798929779701354*^9}, 3.798929981758307*^9, 
   3.799695736911153*^9, 3.799696845829557*^9, 3.800125755445087*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3b: Evolution of asymptomatic fraction f,  no control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
   3.79667414806647*^9, 3.796674151575295*^9}, {3.796674398066517*^9, 
   3.7966743998192387`*^9}, 3.798648198591292*^9, {3.7989299385579977`*^9, 
   3.798929940518031*^9}},
 ExpressionUUID -> "27a49726-70bd-4896-845a-18215a61a4bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0"}], ",", 
     RowBox[{"c2", "->", "0"}], ",", 
     RowBox[{"c3", "\[Rule]", "0"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796675574845084*^9, 3.7966755812180653`*^9}, {3.796682383871626*^9, 
   3.796682418973427*^9}, 3.796688697841316*^9, 3.796780059961252*^9, {
   3.796780127159319*^9, 3.796780137903137*^9}, 3.796780175979947*^9, {
   3.796781643180389*^9, 3.796781650643845*^9}, {3.798648230196433*^9, 
   3.798648233629788*^9}, 3.798648575841824*^9, {3.798652926828912*^9, 
   3.798652929195222*^9}, 3.798925880834399*^9, {3.7989262113342733`*^9, 
   3.798926221767622*^9}, 3.798926444143777*^9},
 ExpressionUUID -> "2f0ccda9-a043-4446-b043-8e6135e3c57c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681888528461*^9, 3.7966818891702414`*^9}, 
   3.798910154603928*^9, 3.798910188063703*^9, 3.798910240840308*^9, {
   3.7990161296034946`*^9, 3.79901612965807*^9}},
 ExpressionUUID -> "cd61e1ec-aa3e-4708-abb2-bd23caf15afb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.800125756225421*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the mutant type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.800125756229726*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.8001257562390003`*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.021951219512195124`"}],
  SequenceForm["Case mortality (mutant) = ", 0.021951219512195124`],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.80012575624747*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016768489869798765`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016768489869798765`],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.8001257562543907`*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.796690896129356*^9, 3.796693894627302*^9, 
  3.7967524303654013`*^9, 3.796752672028511*^9, 3.796780063187842*^9, 
  3.796780179380103*^9, 3.796781796684764*^9, 3.7967818791079073`*^9, 
  3.796783574704196*^9, 3.7967843775897617`*^9, 3.79679666330142*^9, 
  3.7983651529382734`*^9, 3.798647803677586*^9, 3.798648009488504*^9, 
  3.798648311990841*^9, 3.798655743359329*^9, 3.798655910527144*^9, 
  3.79865722377081*^9, 3.79865761241474*^9, 3.798657740178647*^9, 
  3.798657887032814*^9, 3.798659738677105*^9, 3.798714296109351*^9, 
  3.7989090157031403`*^9, 3.798909309968597*^9, 3.798909397275662*^9, 
  3.7989105231709547`*^9, 3.798925906640501*^9, 3.798926240681225*^9, 
  3.798926616033539*^9, 3.798927195360677*^9, 3.798929981986547*^9, 
  3.7996957371669703`*^9, 3.799696846738325*^9, 3.8001257562585*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"]
}, Open  ]],

Cell[BoxData["265"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674352960471*^9, 3.796676879260261*^9, 3.796677289988789*^9, 
   3.796677744571653*^9, 3.7966819205631313`*^9, 3.796682027967502*^9, {
   3.796682386995455*^9, 3.7966824212725887`*^9}, 3.796687870655746*^9, 
   3.7966880987383213`*^9, 3.79669089613831*^9, 3.796693894638055*^9, 
   3.796752430375972*^9, 3.7967526720386953`*^9, 3.79678006319882*^9, 
   3.7967801793913507`*^9, 3.79678179669534*^9, 3.796781879119297*^9, 
   3.796783574718542*^9, 3.796784377605101*^9, 3.7967966633239603`*^9, 
   3.7983651529895325`*^9, 3.798647803689609*^9, 3.7986480095011377`*^9, 
   3.798648312009048*^9, 3.798655743373624*^9, 3.798655910541298*^9, 
   3.7986572237870197`*^9, 3.798657612431684*^9, 3.798657740195063*^9, 
   3.798657887050264*^9, 3.798659738691825*^9, 3.798714296126556*^9, 
   3.798909015713542*^9, 3.798909309978484*^9, 3.798909397286367*^9, 
   3.798910523186509*^9, 3.798925906656349*^9, 3.798926240699992*^9, 
   3.798926616054162*^9, 3.7989271953780537`*^9, 3.798929982003846*^9, 
   3.799695737183654*^9, 3.799696846755052*^9, 3.800125756261549*^9},
 ExpressionUUID -> "3f02b33c-7fd9-4379-b6fd-27ce4b4dbf68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigTOP2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", "fSDashed", ",", 
    "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, {3.796674347420554*^9, 
   3.7966743477587757`*^9}, {3.796674381626519*^9, 3.7966743837492247`*^9}, 
   3.796676953546609*^9, {3.796681822063713*^9, 3.796681829058319*^9}, 
   3.796681998228374*^9, 3.796687817601808*^9, 3.7966880743177156`*^9, {
   3.7966945682604837`*^9, 3.796694587598927*^9}, {3.796752277334374*^9, 
   3.796752290948235*^9}, {3.796752514434359*^9, 3.7967525367356*^9}, {
   3.7967526236941757`*^9, 3.7967526509131193`*^9}, 3.79864770379408*^9, 
   3.798647750443288*^9, 3.798647997371441*^9, 3.798655729925475*^9, 
   3.798655893554132*^9, 3.798657582526106*^9, 3.798657735887179*^9, 
   3.7986578684045486`*^9, 3.7986597246011887`*^9, {3.798910081582502*^9, 
   3.798910089126842*^9}, 3.798910318343523*^9, 3.798926545581962*^9, {
   3.798926970915636*^9, 3.798926971248973*^9}, {3.7989298024739923`*^9, 
   3.798929815468849*^9}, {3.799016129717903*^9, 3.799016129888036*^9}},
 ExpressionUUID -> "4dbad5d4-77d8-428a-bc68-fa9facb378cc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.800125756510648*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the mutant type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.8001257565157957`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.800125756522909*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.021951219512195124`"}],
  SequenceForm["Case mortality (mutant) = ", 0.021951219512195124`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.8001257565288887`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.01688219782121172`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.01688219782121172],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.800125756536088*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.0007979168219603476`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.0007979168219603476],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926616142621*^9, 3.798927195514744*^9, 
  3.798929982139324*^9, 3.799695737931218*^9, 3.799696847010511*^9, 
  3.800125756544099*^9}]
}, Open  ]],

Cell[BoxData["264"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, 3.798648312145615*^9, 
   3.798655743519074*^9, 3.798655910684381*^9, 3.798657223927062*^9, 
   3.798657612572578*^9, 3.798657740327848*^9, 3.798657887190518*^9, 
   3.798659738827448*^9, 3.79871429627201*^9, 3.798909015844006*^9, 
   3.798909310117002*^9, 3.798909397420225*^9, 3.798910523319057*^9, 
   3.7989259067996883`*^9, 3.7989262407916927`*^9, 3.798926549648419*^9, 
   3.798926616167417*^9, 3.798927195532115*^9, 3.79892998215691*^9, 
   3.799695737949127*^9, 3.799696847026224*^9, 3.8001257565491533`*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 RowBox[{"{", "0.039494044807486126`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, 3.798648312145615*^9, 
   3.798655743519074*^9, 3.798655910684381*^9, 3.798657223927062*^9, 
   3.798657612572578*^9, 3.798657740327848*^9, 3.798657887190518*^9, 
   3.798659738827448*^9, 3.79871429627201*^9, 3.798909015844006*^9, 
   3.798909310117002*^9, 3.798909397420225*^9, 3.798910523319057*^9, 
   3.7989259067996883`*^9, 3.7989262407916927`*^9, 3.798926549648419*^9, 
   3.798926616167417*^9, 3.798927195532115*^9, 3.79892998215691*^9, 
   3.799695737949127*^9, 3.799696847026224*^9, 3.800125756553953*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJxF1nc8Vu/7AHBbWakoO6MhSbJJ7svI3hnZ47H33iMNUiohKilS0VKfFFKR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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwd13k4lN0bB3CJUKSUyEuylOxrWtC5s0ShLJkZM2YhVEQjWyVMGbtIJKFC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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVl3c4198bxiWkQRIZIStZIdnj/TxmQvbMnh/bx8xINiV8Iw0a9iiihEoi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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVV3c4l+8XluysKMoOGUlGEtJ7DlkZZe/tY69PKcpKIlshErIzSnaJFJVk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJxF13c8le//B3ArySw7s5AoZG+ut5Gyt+xx7L0zQkukoZKUskrUp9KQMpJ0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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{259, 0.019494044807486125`}, {269, 0.05949404480748613}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{259, 0.05949404480748613}, {269, 0.019494044807486125`}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8676848797564667}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8688219592576941}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontOpacity -> 0, FontSize -> 0], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, 3.798648312145615*^9, 
   3.798655743519074*^9, 3.798655910684381*^9, 3.798657223927062*^9, 
   3.798657612572578*^9, 3.798657740327848*^9, 3.798657887190518*^9, 
   3.798659738827448*^9, 3.79871429627201*^9, 3.798909015844006*^9, 
   3.798909310117002*^9, 3.798909397420225*^9, 3.798910523319057*^9, 
   3.7989259067996883`*^9, 3.7989262407916927`*^9, 3.798926549648419*^9, 
   3.798926616167417*^9, 3.798927195532115*^9, 3.79892998215691*^9, 
   3.799695737949127*^9, 3.799696847026224*^9, 3.800125756557736*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3c: Evolution of pre-symptomatic phase \[Kappa], no control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
  3.79667414806647*^9, 3.796674151575295*^9}, {3.796674398066517*^9, 
  3.7966743998192387`*^9}, {3.798648125427601*^9, 3.7986481326302977`*^9}, {
  3.79864820732091*^9, 3.7986482085202*^9}, {3.7989262003531427`*^9, 
  3.798926205300027*^9}, {3.7989262996640873`*^9, 3.7989263006011953`*^9}, {
  3.798929942717984*^9, 3.798929943618949*^9}},
 ExpressionUUID -> "27a49726-70bd-4896-845a-18215a61a4bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", 
      RowBox[{"2", "/", "3"}]}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0"}], ",", 
     RowBox[{"c2", "->", "0"}], ",", 
     RowBox[{"c3", "\[Rule]", "0"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796675574845084*^9, 3.7966755812180653`*^9}, {3.796682383871626*^9, 
   3.796682418973427*^9}, 3.796688697841316*^9, 3.796780059961252*^9, {
   3.796780127159319*^9, 3.796780137903137*^9}, 3.796780175979947*^9, {
   3.796781643180389*^9, 3.796781650643845*^9}, 3.798925880749415*^9},
 ExpressionUUID -> "2f0ccda9-a043-4446-b043-8e6135e3c57c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681888528461*^9, 3.7966818891702414`*^9}, 
   3.7989101548881702`*^9, 3.798910188347671*^9, 3.798910241005343*^9, {
   3.799016129955834*^9, 3.799016130008524*^9}},
 ExpressionUUID -> "cd61e1ec-aa3e-4708-abb2-bd23caf15afb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.800125757281588*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.682631189948263`"}],
  SequenceForm["R0 of the mutant type = ", 2.682631189948263],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.800125757284374*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.800125757289415*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.8001257572935266`*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016768489869798765`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016768489869798765`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.800125757297591*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896129356*^9, 3.796693894627302*^9, 3.7967524303654013`*^9, 
   3.796752672028511*^9, 3.796780063187842*^9, 3.796780179380103*^9, 
   3.796781796684764*^9, 3.7967818791079073`*^9, 3.796783574704196*^9, 
   3.7967843775897617`*^9, 3.79679666330142*^9, 3.7983651529382734`*^9, 
   3.798647803677586*^9, 3.798648009488504*^9, 3.798648256751431*^9, 
   3.79864831233694*^9, 3.7986485784619503`*^9, 3.798652931819169*^9, 
   3.798655743706843*^9, 3.798655910863699*^9, 3.798657224108893*^9, 
   3.79865761275111*^9, 3.79865774050861*^9, 3.798657887365089*^9, 
   3.798659739007061*^9, 3.7987142965066338`*^9, 3.7989090160357513`*^9, 
   3.798909310706255*^9, 3.7989093978875847`*^9, 3.7989105235105057`*^9, 
   3.7989259073290167`*^9, {3.798926226358799*^9, 3.7989262409799433`*^9}, 
   3.7989264464894867`*^9, 3.798926616822805*^9, 3.798927196253099*^9, 
   3.798929982699038*^9, 3.7996957381945343`*^9, 3.799696847266309*^9, 
   3.8001257573016253`*^9},
 ExpressionUUID -> "fcf496df-f7b5-4b15-8e39-87d111128f8e"]
}, Open  ]],

Cell[BoxData["265"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674352960471*^9, 3.796676879260261*^9, 3.796677289988789*^9, 
   3.796677744571653*^9, 3.7966819205631313`*^9, 3.796682027967502*^9, {
   3.796682386995455*^9, 3.7966824212725887`*^9}, 3.796687870655746*^9, 
   3.7966880987383213`*^9, 3.79669089613831*^9, 3.796693894638055*^9, 
   3.796752430375972*^9, 3.7967526720386953`*^9, 3.79678006319882*^9, 
   3.7967801793913507`*^9, 3.79678179669534*^9, 3.796781879119297*^9, 
   3.796783574718542*^9, 3.796784377605101*^9, 3.7967966633239603`*^9, 
   3.7983651529895325`*^9, 3.798647803689609*^9, 3.7986480095011377`*^9, 
   3.798648256763116*^9, 3.7986483123533373`*^9, 3.798648578475141*^9, 
   3.798652931831152*^9, 3.798655743721665*^9, 3.798655910878332*^9, 
   3.798657224125146*^9, 3.798657612767928*^9, 3.798657740526425*^9, 
   3.7986578873833847`*^9, 3.798659739022975*^9, 3.798714296522928*^9, 
   3.79890901604449*^9, 3.7989093107171173`*^9, 3.798909397899703*^9, 
   3.7989105235258007`*^9, 3.798925907343603*^9, {3.7989262263761044`*^9, 
   3.798926240996468*^9}, 3.7989264465063868`*^9, 3.798926616844553*^9, 
   3.798927196272126*^9, 3.798929982715988*^9, 3.799695738211294*^9, 
   3.799696847283559*^9, 3.800125757306921*^9},
 ExpressionUUID -> "3f02b33c-7fd9-4379-b6fd-27ce4b4dbf68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigTOP3", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", "fSDashed", ",", 
    "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, {3.796674347420554*^9, 
   3.7966743477587757`*^9}, {3.796674381626519*^9, 3.7966743837492247`*^9}, 
   3.796676953546609*^9, {3.796681822063713*^9, 3.796681829058319*^9}, 
   3.796681998228374*^9, 3.796687817601808*^9, 3.7966880743177156`*^9, {
   3.7966945682604837`*^9, 3.796694587598927*^9}, {3.796752277334374*^9, 
   3.796752290948235*^9}, {3.796752514434359*^9, 3.7967525367356*^9}, {
   3.7967526236941757`*^9, 3.7967526509131193`*^9}, 3.79864770379408*^9, 
   3.798647750443288*^9, 3.798647997371441*^9, {3.798648248875649*^9, 
   3.7986482490123158`*^9}, 3.798655730328236*^9, 3.798655893755432*^9, 
   3.7986575829363127`*^9, 3.798657736089271*^9, 3.798657868502877*^9, 
   3.798659724748213*^9, {3.798910093594838*^9, 3.79891009777279*^9}, 
   3.798910318864682*^9, {3.798926563617153*^9, 3.7989265643201933`*^9}, {
   3.7989269807919703`*^9, 3.798926980992482*^9}, {3.7989298267154512`*^9, 
   3.798929828715342*^9}, {3.79901613006566*^9, 3.799016130235757*^9}},
 ExpressionUUID -> "4dbad5d4-77d8-428a-bc68-fa9facb378cc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.8001257574446983`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.682631189948263`"}],
  SequenceForm["R0 of the mutant type = ", 2.682631189948263],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.800125757449581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.80012575745546*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.800125757460554*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016948449088489102`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016948449088489102`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.800125757465088*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.0022820644266018045`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.0022820644266018045`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7986482568895597`*^9, 3.79864831266282*^9, 3.798648578602427*^9, 
   3.798652931960931*^9, 3.798655743980268*^9, 3.798655911133195*^9, 
   3.798657224377091*^9, 3.798657613009287*^9, 3.7986577406465273`*^9, 
   3.798657887619594*^9, 3.7986597391444902`*^9, 3.798714297208579*^9, 
   3.7989090164485083`*^9, 3.798909310790121*^9, 3.7989093981650267`*^9, 
   3.798910523593862*^9, 3.798925907512741*^9, {3.798926226438923*^9, 
   3.798926241397603*^9}, 3.798926446568779*^9, 3.798926616926168*^9, 
   3.798927196351687*^9, 3.798929982842051*^9, 3.79969573831942*^9, 
   3.799696847361121*^9, 3.800125757473097*^9}]
}, Open  ]],

Cell[BoxData["262"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, {3.798926226456099*^9, 
   3.7989262414152117`*^9}, 3.798926446586648*^9, 3.798926616948007*^9, 
   3.798927196371152*^9, 3.7989299828613*^9, 3.79969573833705*^9, 
   3.799696847379451*^9, 3.800125757479642*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 RowBox[{"{", "0.35926759389868895`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, {3.798926226456099*^9, 
   3.7989262414152117`*^9}, 3.798926446586648*^9, 3.798926616948007*^9, 
   3.798927196371152*^9, 3.7989299828613*^9, 3.79969573833705*^9, 
   3.799696847379451*^9, 3.80012575748234*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJxF1Xc8lt//B3AriUqiErIrhGSrOG+jlL2SvW7bbUtWpEFTZZXsSBqkUkaq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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwVzXk81AkfB/Bxs+MoYR2pda2tpEJ52k3fr1sW68ods+O+f1ueahml3d+Y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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVl3c4198bxiWkQRIZIStZIdnj/TxmQvbMnh/bx8xINiV8Iw0a9iiihEoi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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVV3c8198XluxNVnZmVLJC5H1Odvbee++VWTSMLyIJlUIpozIiGdlkVOYn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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJxF13c8le//B3ArySw7s5AoZG+ut5Gyt+xx7L0zQkukoZKUskrUp9KQMpJ0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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{257, 0.33926759389868894`}, {267, 0.37926759389868897`}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{257, 0.37926759389868897`}, {267, 0.33926759389868894`}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8676848797564667}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8694844718022836}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontOpacity -> 0, FontSize -> 0], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, {3.798926226456099*^9, 
   3.7989262414152117`*^9}, 3.798926446586648*^9, 3.798926616948007*^9, 
   3.798927196371152*^9, 3.7989299828613*^9, 3.79969573833705*^9, 
   3.799696847379451*^9, 3.800125757488408*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3d: Evolution of virulence \[Alpha], no control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
  3.79667414806647*^9, 3.796674151575295*^9}, {3.796674398066517*^9, 
  3.7966743998192387`*^9}, {3.798648125427601*^9, 3.7986481326302977`*^9}, {
  3.79864820732091*^9, 3.7986482085202*^9}, {3.798926254997504*^9, 
  3.798926255097467*^9}},
 ExpressionUUID -> "27a49726-70bd-4896-845a-18215a61a4bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.0"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0"}], ",", 
     RowBox[{"c2", "->", "0"}], ",", 
     RowBox[{"c3", "\[Rule]", "0"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796675574845084*^9, 3.7966755812180653`*^9}, {3.796682383871626*^9, 
   3.796682418973427*^9}, 3.796688697841316*^9, 3.796780059961252*^9, {
   3.796780127159319*^9, 3.796780137903137*^9}, 3.796780175979947*^9, {
   3.796781643180389*^9, 3.796781650643845*^9}, {3.798648230196433*^9, 
   3.798648233629788*^9}, 3.798648575841824*^9, {3.798652926828912*^9, 
   3.798652929195222*^9}, 3.798925880834399*^9},
 ExpressionUUID -> "2f0ccda9-a043-4446-b043-8e6135e3c57c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681888528461*^9, 3.7966818891702414`*^9}, 
   3.7989101548881702`*^9, 3.798910188347671*^9, 3.798910241005343*^9, {
   3.7990161303235693`*^9, 3.799016130373776*^9}},
 ExpressionUUID -> "cd61e1ec-aa3e-4708-abb2-bd23caf15afb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.800125758148432*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.3151515151515154`"}],
  SequenceForm["R0 of the mutant type = ", 2.3151515151515154`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.800125758152154*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.800125758157811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["Case mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.8001257581615887`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016768489869798765`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016768489869798765`],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.800125758165596*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.79892661719022*^9, 3.798927196648193*^9, 
  3.798929983106138*^9, 3.799695739395689*^9, 3.799696847589242*^9, 
  3.800125758171118*^9}]
}, Open  ]],

Cell[BoxData["265"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674352960471*^9, 3.796676879260261*^9, 3.796677289988789*^9, 
   3.796677744571653*^9, 3.7966819205631313`*^9, 3.796682027967502*^9, {
   3.796682386995455*^9, 3.7966824212725887`*^9}, 3.796687870655746*^9, 
   3.7966880987383213`*^9, 3.79669089613831*^9, 3.796693894638055*^9, 
   3.796752430375972*^9, 3.7967526720386953`*^9, 3.79678006319882*^9, 
   3.7967801793913507`*^9, 3.79678179669534*^9, 3.796781879119297*^9, 
   3.796783574718542*^9, 3.796784377605101*^9, 3.7967966633239603`*^9, 
   3.7983651529895325`*^9, 3.798647803689609*^9, 3.7986480095011377`*^9, 
   3.798648256763116*^9, 3.7986483123533373`*^9, 3.798648578475141*^9, 
   3.798652931831152*^9, 3.798655743721665*^9, 3.798655910878332*^9, 
   3.798657224125146*^9, 3.798657612767928*^9, 3.798657740526425*^9, 
   3.7986578873833847`*^9, 3.798659739022975*^9, 3.798714296522928*^9, 
   3.79890901604449*^9, 3.7989093107171173`*^9, 3.798909397899703*^9, 
   3.7989105235258007`*^9, 3.798925907343603*^9, 3.798926278158293*^9, 
   3.7989263359791403`*^9, 3.7989266172107353`*^9, 3.7989271966656733`*^9, 
   3.798929983124074*^9, 3.799695739422695*^9, 3.799696847605283*^9, 
   3.8001257581743307`*^9},
 ExpressionUUID -> "3f02b33c-7fd9-4379-b6fd-27ce4b4dbf68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigTOP4", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", "fSDashed", ",", 
    "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, {3.796674347420554*^9, 
   3.7966743477587757`*^9}, {3.796674381626519*^9, 3.7966743837492247`*^9}, 
   3.796676953546609*^9, {3.796681822063713*^9, 3.796681829058319*^9}, 
   3.796681998228374*^9, 3.796687817601808*^9, 3.7966880743177156`*^9, {
   3.7966945682604837`*^9, 3.796694587598927*^9}, {3.796752277334374*^9, 
   3.796752290948235*^9}, {3.796752514434359*^9, 3.7967525367356*^9}, {
   3.7967526236941757`*^9, 3.7967526509131193`*^9}, 3.79864770379408*^9, 
   3.798647750443288*^9, 3.798647997371441*^9, {3.798648248875649*^9, 
   3.7986482490123158`*^9}, 3.798655730328236*^9, 3.798655893755432*^9, 
   3.7986575829363127`*^9, 3.798657736089271*^9, 3.798657868502877*^9, 
   3.798659724748213*^9, {3.798910093594838*^9, 3.79891009777279*^9}, 
   3.798910318864682*^9, {3.7989262612646217`*^9, 3.798926261375216*^9}, {
   3.798926577664319*^9, 3.798926580654023*^9}, {3.7989269863090763`*^9, 
   3.798926990029483*^9}, 3.798929839862649*^9, {3.799016130435691*^9, 
   3.799016130624737*^9}},
 ExpressionUUID -> "4dbad5d4-77d8-428a-bc68-fa9facb378cc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.800125758313992*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.3151515151515154`"}],
  SequenceForm["R0 of the mutant type = ", 2.3151515151515154`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.800125758318386*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.8001257583223124`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["Case mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.8001257583258333`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.016580448364757167`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.016580448364757167`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.800125758331197*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989266173419733`*^9, 3.798927197158489*^9, 
  3.798929983188702*^9, 3.799695740668398*^9, 3.79969684773419*^9, 
  3.800125758335689*^9}]
}, Open  ]],

Cell[BoxData["265"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, 3.798926278295368*^9, 
   3.79892633605048*^9, 3.798926617363467*^9, 3.798927197179202*^9, 
   3.798929983207592*^9, 3.799695740685089*^9, 3.799696847750708*^9, 
   3.8001257583419123`*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 RowBox[{"{", "0.01406463884329544`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, 3.798926278295368*^9, 
   3.79892633605048*^9, 3.798926617363467*^9, 3.798927197179202*^9, 
   3.798929983207592*^9, 3.799695740685089*^9, 3.799696847750708*^9, 
   3.800125758346897*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJxF1Xc81e/7B3AkCtEgIyNpUEiyyX0ZKXvLXseex95aIpRKi4xISaU0iCR0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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwVx3s4lIkewHFN5IRWyVpRIpeTbVeWcYn4/fKkpFK5tnUcjOuWy5vqUYjl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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVl3c4198bxiWkQRIZIStZIdnj/TxmQvbMnh/bx8xINiV8Iw0a9iiihEoi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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVl3c8lu8XxyUkSpEi2SsrpGzuc2yRPR6y9+Yxs7OSpBJSqWRGKSEkGRGF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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJxF13c8le//B3ArySw7s5AoZG+ut5Gyt+xx7L0zQkukoZKUskrUp9KQMpJ0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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{260, -0.005935361156704561}, {270, 0.03406463884329544}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{260, 0.03406463884329544}, {270, -0.005935361156704561}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8676848797564667}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8658044650072602}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontOpacity -> 0, FontSize -> 0], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674348373801*^9, 
   3.796674353028098*^9}, 3.7966743841497726`*^9, 3.796676879624835*^9, 
   3.796677290435643*^9, 3.796677744771879*^9, 3.796681920697056*^9, 
   3.796682028108192*^9, {3.7966823871480427`*^9, 3.796682421416326*^9}, 
   3.7966878707932043`*^9, 3.796688098772517*^9, 3.796690896261724*^9, 
   3.796693894775474*^9, 3.796752430524557*^9, 3.796752627240995*^9, 
   3.796752672182143*^9, 3.796780063337674*^9, 3.796780179524404*^9, 
   3.796781796901504*^9, 3.796781879251829*^9, 3.796783574878639*^9, 
   3.7967843777689457`*^9, 3.7967966636107535`*^9, 3.7983651532366138`*^9, 
   3.798647803838002*^9, 3.79864800964292*^9, {3.7986482518685007`*^9, 
   3.798648256904091*^9}, 3.798648312686472*^9, 3.7986485786167297`*^9, 
   3.7986529319752483`*^9, 3.7986557439952097`*^9, 3.798655911148739*^9, 
   3.79865722439357*^9, 3.798657613026969*^9, 3.798657740665182*^9, 
   3.798657887637039*^9, 3.7986597391597853`*^9, 3.7987142972361393`*^9, 
   3.798909016456708*^9, 3.798909310800358*^9, 3.798909398176626*^9, 
   3.798910523610916*^9, 3.798925907527964*^9, 3.798926278295368*^9, 
   3.79892633605048*^9, 3.798926617363467*^9, 3.798927197179202*^9, 
   3.798929983207592*^9, 3.799695740685089*^9, 3.799696847750708*^9, 
   3.800125758353364*^9},
 ExpressionUUID -> "ad695914-d3c4-4b3a-920e-33051219d634"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3e: Evolution of transmission \[Beta], control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
   3.79667414806647*^9, 3.796674164129323*^9}, {3.7983654362606225`*^9, 
   3.798365437217821*^9}, {3.7986481342215557`*^9, 3.7986481634185753`*^9}, 
   3.798926285679631*^9},
 ExpressionUUID -> "b251d960-94c6-41df-8df2-88aa35fef221"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1.2"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0.6"}], ",", 
     RowBox[{"c2", "->", "0.6"}], ",", 
     RowBox[{"c3", "\[Rule]", "0.6"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796674191058156*^9, 3.796674196138136*^9}, 3.796688697874941*^9, {
   3.7967801982994432`*^9, 3.796780205388029*^9}, {3.796781674166744*^9, 
   3.796781680454599*^9}, 3.798909011488963*^9, 3.798925880918099*^9},
 ExpressionUUID -> "1242bf0f-c2bb-4cbc-9946-50ff2687dd35"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681897792633*^9, 3.796681898195109*^9}, 
   3.798910155155753*^9, 3.798910188646118*^9, 3.798910241172492*^9, {
   3.7990161307051973`*^9, 3.799016130757237*^9}},
 ExpressionUUID -> "29798033-b294-4db5-9474-839933a887fa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.800125758625671*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.7391574279379154`"}],
  SequenceForm["R0 of the mutant type = ", 2.7391574279379154`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.80012575862738*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.800125758636916*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.8001257586432133`*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.011587408462006054`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.011587408462006054`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.800125758648591*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.796690896861621*^9, 3.796693895458794*^9, 3.7967524317075644`*^9, 
   3.796752672986611*^9, 3.7967802075569963`*^9, 3.796781797910911*^9, 
   3.796781879978095*^9, 3.796783575690936*^9, {3.796784366960107*^9, 
   3.796784378796219*^9}, 3.7967966649851*^9, 3.798365316630988*^9, 
   3.798647804137951*^9, 3.798648009875821*^9, 3.7986483129462643`*^9, 
   3.79865574420604*^9, 3.798655911365117*^9, 3.7986572246045523`*^9, 
   3.798657613251231*^9, 3.798657741020132*^9, 3.798657887906756*^9, 
   3.798659739486803*^9, 3.7987142974595623`*^9, 3.7989090168692017`*^9, 
   3.7989093110315733`*^9, 3.798909495716914*^9, 3.7989105257775307`*^9, 
   3.798925907879591*^9, 3.798926336275681*^9, 3.798926618243874*^9, 
   3.798927197416668*^9, 3.798929984047146*^9, 3.799695741675775*^9, 
   3.799696847963141*^9, 3.800125758652525*^9},
 ExpressionUUID -> "b1d33354-6117-446e-866b-7caba61975f1"]
}, Open  ]],

Cell[BoxData["449"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674201385605*^9, 3.7966743569131804`*^9, 3.7966772917342653`*^9, 
   3.79667774599032*^9, 3.7966819214318657`*^9, 3.796682028950756*^9, 
   3.7966878714651413`*^9, 3.796688099106151*^9, 3.796690896870577*^9, 
   3.796693895468997*^9, 3.7967524317176857`*^9, 3.796752672997549*^9, 
   3.796780207568124*^9, 3.7967817979223337`*^9, 3.796781879989675*^9, 
   3.796783575704155*^9, {3.7967843669742413`*^9, 3.796784378808982*^9}, 
   3.7967966650282583`*^9, 3.7983653167132664`*^9, 3.798647804153973*^9, 
   3.798648009888694*^9, 3.798648312962674*^9, 3.7986557442216454`*^9, 
   3.798655911380849*^9, 3.7986572246213417`*^9, 3.798657613269256*^9, 
   3.798657741037013*^9, 3.798657887923703*^9, 3.798659739503096*^9, 
   3.798714297475771*^9, 3.798909016877527*^9, 3.7989093110420647`*^9, 
   3.7989094957283983`*^9, 3.798910525796419*^9, 3.798925907894*^9, 
   3.798926336292997*^9, 3.798926618261701*^9, 3.7989271974336157`*^9, 
   3.798929984064275*^9, 3.799695741692121*^9, 3.799696847984848*^9, 
   3.800125758656555*^9},
 ExpressionUUID -> "58136b4e-39ff-466c-8630-07307167ffe3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigBOT1", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fcontrol", ",", "fS", ",", "fSDashed", ",", " ", "FIGfreq", ",", 
    "fnoevol", ",", "fevol", ",", "line1", ",", "line2", ",", "DeathRates", 
    ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, 3.796674228784727*^9, {
   3.7966743013088284`*^9, 3.796674334808358*^9}, {3.796674373952984*^9, 
   3.7966743755540648`*^9}, {3.796681845064183*^9, 3.796681855701137*^9}, 
   3.796682008631616*^9, 3.796687841512721*^9, 3.796688082233633*^9, {
   3.796694594947007*^9, 3.796694602186692*^9}, 3.7967523132852592`*^9, 
   3.796752419231223*^9, {3.796752514943055*^9, 3.796752537067772*^9}, 
   3.7967526494104548`*^9, {3.796784359939619*^9, 3.796784362242854*^9}, 
   3.798647703865554*^9, 3.7986477505423803`*^9, 3.798647997689065*^9, 
   3.79865573047725*^9, 3.798655893953411*^9, 3.798657583081628*^9, 
   3.798657736291203*^9, 3.798657868604785*^9, 3.798659724899588*^9, 
   3.798909485164094*^9, {3.7989101019975967`*^9, 3.798910106103875*^9}, 
   3.7989103193623447`*^9, {3.798926995520467*^9, 3.7989269957220783`*^9}, {
   3.7989298473757467`*^9, 3.798929858675489*^9}, {3.799016130813542*^9, 
   3.799016130972337*^9}},
 ExpressionUUID -> "8521f45c-3d39-418f-9f6e-36615f59b22b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.800125759383264*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.7391574279379154`"}],
  SequenceForm["R0 of the mutant type = ", 2.7391574279379154`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.8001257593878813`*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.8001257593921633`*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.8001257593965473`*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.013377430921052712`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.013377430921052712`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.800125759400723*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.005453415593329141`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.005453415593329141],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7966908970031023`*^9, 3.796693895618821*^9, 3.7967524318706827`*^9, 
   3.796752673188923*^9, 3.796780207712021*^9, 3.796781798094943*^9, 
   3.796781880210842*^9, 3.7967835758788767`*^9, {3.796784367137752*^9, 
   3.796784379107616*^9}, 3.796796665416844*^9, 3.7983653169190936`*^9, 
   3.798647804433867*^9, 3.798648010177617*^9, 3.7986483131337633`*^9, 
   3.7986557443765793`*^9, 3.798655911536409*^9, 3.7986572247781982`*^9, 
   3.7986576134150352`*^9, 3.798657741193388*^9, 3.79865788805716*^9, 
   3.7986597396616993`*^9, 3.798714297843449*^9, 3.798909017030096*^9, 
   3.798909311226404*^9, 3.7989094958775806`*^9, 3.798910526016852*^9, 
   3.798925908497134*^9, 3.798926336437405*^9, 3.798926618435998*^9, 
   3.798927197592712*^9, 3.798929984222094*^9, 3.7996957418265953`*^9, 
   3.79969684881255*^9, 3.800125759405589*^9},
 ExpressionUUID -> "4f5bfe54-adb3-44ab-83fb-1788155ab78c"]
}, Open  ]],

Cell[BoxData["435"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677292140209*^9, 3.796677746162609*^9, 3.796681921593741*^9, 
   3.796682029103793*^9, 3.796687871689303*^9, 3.796688099139308*^9, 
   3.796690897012044*^9, 3.796693895628612*^9, 3.796752431880952*^9, 
   3.7967526731988583`*^9, 3.796780207725068*^9, 3.7967817981095657`*^9, 
   3.796781880221716*^9, 3.7967835758942842`*^9, {3.796784367151478*^9, 
   3.796784379123417*^9}, 3.796796665439513*^9, 3.798365316978812*^9, 
   3.798647804446316*^9, 3.798648010191515*^9, 3.798648313159381*^9, 
   3.798655744391637*^9, 3.798655911551166*^9, 3.798657224795665*^9, 
   3.798657613432549*^9, 3.798657741210286*^9, 3.7986578880776854`*^9, 
   3.7986597396769114`*^9, 3.79871429786071*^9, 3.798909017082047*^9, 
   3.7989093112365923`*^9, 3.798909495888782*^9, 3.79891052603192*^9, 
   3.798925908513402*^9, 3.798926336455194*^9, 3.7989266184533033`*^9, 
   3.798927197611286*^9, 3.798929984239229*^9, 3.79969574185111*^9, 
   3.799696848828498*^9, 3.8001257594111357`*^9},
 ExpressionUUID -> "fc55fdeb-8489-465f-9bbd-750f8277b397"],

Cell[BoxData[
 RowBox[{"{", "0.979012496769441`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677292140209*^9, 3.796677746162609*^9, 3.796681921593741*^9, 
   3.796682029103793*^9, 3.796687871689303*^9, 3.796688099139308*^9, 
   3.796690897012044*^9, 3.796693895628612*^9, 3.796752431880952*^9, 
   3.7967526731988583`*^9, 3.796780207725068*^9, 3.7967817981095657`*^9, 
   3.796781880221716*^9, 3.7967835758942842`*^9, {3.796784367151478*^9, 
   3.796784379123417*^9}, 3.796796665439513*^9, 3.798365316978812*^9, 
   3.798647804446316*^9, 3.798648010191515*^9, 3.798648313159381*^9, 
   3.798655744391637*^9, 3.798655911551166*^9, 3.798657224795665*^9, 
   3.798657613432549*^9, 3.798657741210286*^9, 3.7986578880776854`*^9, 
   3.7986597396769114`*^9, 3.79871429786071*^9, 3.798909017082047*^9, 
   3.7989093112365923`*^9, 3.798909495888782*^9, 3.79891052603192*^9, 
   3.798925908513402*^9, 3.798926336455194*^9, 3.7989266184533033`*^9, 
   3.798927197611286*^9, 3.798929984239229*^9, 3.79969574185111*^9, 
   3.799696848828498*^9, 3.800125759415155*^9},
 ExpressionUUID -> "fc55fdeb-8489-465f-9bbd-750f8277b397"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxNlQk01HsUx8mUlMj6ImtDIctkS4u9prKNoaM4nhjrMC9rlpSebO2JNiFL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    "], {{}, 
     {GrayLevel[0.85], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{141, 52, 193, 190}, {182, 174, 188, 192}, {169, 185, 189, 
        191}}]]}, {}, {}}], {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd1nk8lF8XAHBbyhKRpEJCIrKvKffYsy+pELKTdWYsM5aIJG3SQrZCiVSk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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwd13k41F8XAHBLlCUK2Wkh2RJCWe+xl31NhOz7MsYydi0i/UpKaRNCaFES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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwV1nk0FG4XB3AioiyRUCJRkl1CxL1FiMqakPplSJaxNMVYomRQKtlS2UIo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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVV3c41m8XVyJbJDMjyQwlM/U9hxBCNiF7b4/x8JBkp5KiSERIQhEyy0hG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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVV3k4ll8TFkqELFkqESFChCj0zNjXsu/Kvm/v+9rXEBIlW1JJtuz7miiK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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{430, 0.959012496769441}, {440, 0.999012496769441}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{430, 0.999012496769441}, {440, 0.959012496769441}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8158740221149205}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8337742795711647}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  Method->{"AxesInFront" -> True},
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677292140209*^9, 3.796677746162609*^9, 3.796681921593741*^9, 
   3.796682029103793*^9, 3.796687871689303*^9, 3.796688099139308*^9, 
   3.796690897012044*^9, 3.796693895628612*^9, 3.796752431880952*^9, 
   3.7967526731988583`*^9, 3.796780207725068*^9, 3.7967817981095657`*^9, 
   3.796781880221716*^9, 3.7967835758942842`*^9, {3.796784367151478*^9, 
   3.796784379123417*^9}, 3.796796665439513*^9, 3.798365316978812*^9, 
   3.798647804446316*^9, 3.798648010191515*^9, 3.798648313159381*^9, 
   3.798655744391637*^9, 3.798655911551166*^9, 3.798657224795665*^9, 
   3.798657613432549*^9, 3.798657741210286*^9, 3.7986578880776854`*^9, 
   3.7986597396769114`*^9, 3.79871429786071*^9, 3.798909017082047*^9, 
   3.7989093112365923`*^9, 3.798909495888782*^9, 3.79891052603192*^9, 
   3.798925908513402*^9, 3.798926336455194*^9, 3.7989266184533033`*^9, 
   3.798927197611286*^9, 3.798929984239229*^9, 3.79969574185111*^9, 
   3.799696848828498*^9, 3.800125759557578*^9},
 ExpressionUUID -> "fc55fdeb-8489-465f-9bbd-750f8277b397"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3f: Evolution of asymptomatic fraction f, control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
   3.79667414806647*^9, 3.796674164129323*^9}, {3.796676916421912*^9, 
   3.796676919585401*^9}, {3.7983654435345707`*^9, 3.798365443709165*^9}, 
   3.798648135272422*^9, 3.7986481986767473`*^9, 3.798926288464212*^9, {
   3.7989299676663313`*^9, 3.7989299778634357`*^9}},
 ExpressionUUID -> "c875ee02-bb43-4be2-811b-002106a978e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "->", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.1"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0.6"}], ",", 
     RowBox[{"c2", "->", "0.6"}], ",", 
     RowBox[{"c3", "\[Rule]", "0.6"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796674191058156*^9, 3.796674196138136*^9}, {3.796676925542235*^9, 
   3.796676928806604*^9}, {3.7966824315176363`*^9, 3.796682432172542*^9}, 
   3.7966886978905993`*^9, {3.7986482908355827`*^9, 3.798648292858808*^9}, {
   3.798648550036828*^9, 3.798648550354871*^9}, 3.798652940264064*^9, 
   3.798909011844165*^9, 3.798925881084461*^9, {3.798926313351157*^9, 
   3.798926316885289*^9}, 3.798926422841567*^9},
 ExpressionUUID -> "ddf86d85-24e2-4313-840c-c645e9b01969"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681904037208*^9, 3.796681904535309*^9}, 
   3.798910153676701*^9, 3.798910187372961*^9, 3.798910241340049*^9, {
   3.799016131055232*^9, 3.799016131107463*^9}},
 ExpressionUUID -> "6ae33989-aac5-4368-ad00-b18931ce109a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.800125760223154*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the mutant type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.8001257602246637`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.800125760229754*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.021951219512195124`"}],
  SequenceForm["Case mortality (mutant) = ", 0.021951219512195124`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.800125760233984*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.011587408462006054`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.011587408462006054`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.8001257602383347`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619009481*^9, 3.798927198183342*^9, 
  3.7989299851735153`*^9, 3.79969574271065*^9, 3.799696849029914*^9, 
  3.800125760243608*^9}]
}, Open  ]],

Cell[BoxData["449"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674201385605*^9, 3.7966743569131804`*^9, 3.7966772929641237`*^9, 
   3.796677746512498*^9, 3.796681921823151*^9, 3.796682029332395*^9, 
   3.7966824343485622`*^9, 3.796687871854019*^9, 3.7966880993398027`*^9, 
   3.7966908973046637`*^9, 3.796693895853547*^9, 3.796752432108746*^9, 
   3.796752673434168*^9, 3.7967817986253843`*^9, 3.7967818804282303`*^9, 
   3.796783576192992*^9, 3.796784349441544*^9, 3.796784379545883*^9, 
   3.796796666003852*^9, 3.7983653174245367`*^9, 3.798647804708379*^9, 
   3.7986480104196444`*^9, 3.7986483135587797`*^9, 3.798648345191478*^9, 
   3.798655744730844*^9, 3.798655911777915*^9, 3.798657225017391*^9, 
   3.798657613673315*^9, 3.7986577414367723`*^9, 3.798657888473402*^9, 
   3.79865973990228*^9, 3.798714298158019*^9, 3.7989090176746607`*^9, 
   3.7989093119112263`*^9, 3.79890949615315*^9, 3.7989105263197727`*^9, 
   3.798925908905395*^9, {3.798926336718113*^9, 3.7989263657636833`*^9}, 
   3.798926619028536*^9, 3.79892719820331*^9, 3.798929985193981*^9, 
   3.7996957427268457`*^9, 3.799696849045014*^9, 3.800125760247883*^9},
 ExpressionUUID -> "72b28f06-c012-4182-b6a5-042bce4449a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigBOT2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fcontrol", ",", "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", 
    "fSDashed", ",", "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, 3.796674228784727*^9, {
   3.7966743013088284`*^9, 3.796674334808358*^9}, {3.796674373952984*^9, 
   3.7966743755540648`*^9}, 3.796676986723856*^9, {3.796681861384461*^9, 
   3.796681867035219*^9}, {3.796682016144153*^9, 3.796682016642682*^9}, {
   3.796687849959033*^9, 3.79668785268452*^9}, {3.79668806244241*^9, 
   3.796688062913072*^9}, 3.796694608473276*^9, 3.7967523184768744`*^9, 
   3.796752419669855*^9, {3.7967525151920853`*^9, 3.796752537235073*^9}, 
   3.7967526495584507`*^9, {3.796784343035324*^9, 3.796784346168426*^9}, 
   3.7986477039326563`*^9, 3.79864775064361*^9, 3.79864799778578*^9, 
   3.798655730628587*^9, 3.798655894154611*^9, 3.798657583230296*^9, 
   3.7986577364905777`*^9, 3.798657868755131*^9, 3.798659725048211*^9, 
   3.798909485302991*^9, {3.7989101218500443`*^9, 3.798910140258606*^9}, 
   3.7989103198649807`*^9, 3.798926595911792*^9, {3.7989269984401503`*^9, 
   3.798926998624856*^9}, {3.798929869653881*^9, 3.798929880092711*^9}, {
   3.799016131170961*^9, 3.7990161313545923`*^9}},
 ExpressionUUID -> "b3e75750-9952-419e-8878-bfeedaa99ab2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.800125760381997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the mutant type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.800125760385846*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.800125760389867*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.021951219512195124`"}],
  SequenceForm["Case mortality (mutant) = ", 0.021951219512195124`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.800125760395308*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.011705586644900215`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.011705586644900215`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.8001257603991013`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.0008322879131918464`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.0008322879131918464],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926619178557*^9, 3.7989271983346567`*^9, 
  3.79892998532757*^9, 3.7996957428591213`*^9, 3.799696849775083*^9, 
  3.8001257604045343`*^9}]
}, Open  ]],

Cell[BoxData["450"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677293468957*^9, 3.7966777467948847`*^9, 3.7966819219739637`*^9, 
   3.796682029621365*^9, 3.796682434516294*^9, 3.796687872089184*^9, 
   3.796688099372064*^9, 3.7966908974451427`*^9, 3.796693896008141*^9, 
   3.796752432278822*^9, 3.796752673765243*^9, 3.796781798818375*^9, 
   3.79678188059021*^9, 3.7967835765429296`*^9, 3.796784349634851*^9, 
   3.796784379731773*^9, 3.796796666346838*^9, 3.798365317742833*^9, 
   3.798647804905424*^9, 3.798648010592786*^9, 3.798648313931823*^9, 
   3.798648345257983*^9, 3.798655744847629*^9, 3.798655911948001*^9, 
   3.7986572251934443`*^9, 3.7986576138936*^9, 3.798657741666518*^9, 
   3.798657888958753*^9, 3.7986597400776577`*^9, 3.798714298361383*^9, 
   3.7989090178557158`*^9, 3.798909312063919*^9, 3.798909496322501*^9, 
   3.798910526523726*^9, 3.798925909012253*^9, {3.79892633688914*^9, 
   3.798926365849469*^9}, 3.7989266191978817`*^9, 3.7989271983544283`*^9, 
   3.798929985344664*^9, 3.7996957428782988`*^9, 3.799696849790019*^9, 
   3.800125760408573*^9},
 ExpressionUUID -> "890eaecf-ed61-4813-aef0-9f547539f643"],

Cell[BoxData[
 RowBox[{"{", "0.20784655218789455`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677293468957*^9, 3.7966777467948847`*^9, 3.7966819219739637`*^9, 
   3.796682029621365*^9, 3.796682434516294*^9, 3.796687872089184*^9, 
   3.796688099372064*^9, 3.7966908974451427`*^9, 3.796693896008141*^9, 
   3.796752432278822*^9, 3.796752673765243*^9, 3.796781798818375*^9, 
   3.79678188059021*^9, 3.7967835765429296`*^9, 3.796784349634851*^9, 
   3.796784379731773*^9, 3.796796666346838*^9, 3.798365317742833*^9, 
   3.798647804905424*^9, 3.798648010592786*^9, 3.798648313931823*^9, 
   3.798648345257983*^9, 3.798655744847629*^9, 3.798655911948001*^9, 
   3.7986572251934443`*^9, 3.7986576138936*^9, 3.798657741666518*^9, 
   3.798657888958753*^9, 3.7986597400776577`*^9, 3.798714298361383*^9, 
   3.7989090178557158`*^9, 3.798909312063919*^9, 3.798909496322501*^9, 
   3.798910526523726*^9, 3.798925909012253*^9, {3.79892633688914*^9, 
   3.798926365849469*^9}, 3.7989266191978817`*^9, 3.7989271983544283`*^9, 
   3.798929985344664*^9, 3.7996957428782988`*^9, 3.799696849790019*^9, 
   3.800125760411202*^9},
 ExpressionUUID -> "890eaecf-ed61-4813-aef0-9f547539f643"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxNlQk01HsUx8mUlMj6ImtDIctkS4u9prKNoaM4nhjrMC9rlpSebO2JNiFL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    "], {{}, 
     {GrayLevel[0.85], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{141, 52, 193, 190}, {182, 174, 188, 192}, {169, 185, 189, 
        191}}]]}, {}, {}}], {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13c81d8bAHC7smfJKvObkexQnEf2HqmQvbeL4hoNJaWBKE1FoS2FSEJk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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwV13k4VO8XAHCUyFfIHipbabNFtDrH2qLEmFTaGKGyZcgIRWVJEimylIwl
hgiRMKMImZudLJUQlZBsCaV+9/fXfT7Pe57znvec97nPvUo0D4ojHw8Pjw8v
D8//nwKGl3zpRgMGOzfl7e73C4YhyTB7TnYl+GyeeCwWEAzfVVI/xGW3AFt2
taRdYDA4cYIEmwLfgfqvp9qM4GA4n6OZeC27H8bGnjYsiQiGTbOr8ldLfYFs
t/kEbkwwfDMRqS0PHIZvC8u3BCcFg7bHzOzF7AkQeLfaQelJMERLjS2q652C
wgO1t5+XBsNY+WcRaakZGNywnp1XHQzZgm9VCwPnQev5wPvT74NBvOXougvZ
vLhxzxXhcKEQMEx/q65Qw4c/xXiPBkmHwHmGlc6r3kU4JjVfckU5BBpX7jVY
LrUE9yXY30vcHgIR57ZScwOFMO+F3eZlLiHAd/W/l/Ts5Wht41El2hACiS5c
o1p9cXT+ma7r1R0C2ofCalbUiKOi6Nvh3s8hYLdu0ZuXvRKoU3M3suNvCFQ0
zr8VkZJG7zzVF6gdCv7ywyPZgXJ4ob3rmHZ8KPjZDkZ4ZivhtbfH73a6h8HN
JwLDwr+U0Eux5WbDpTBIXrxxT5axMj4138BpvhkGr/I8F/d+UMbXk/rhf7PD
QHjRv4D9oqoYUzMkMfM1DB7mrHBX816L2TcnaHtOX4fqPxaWPbs24tP86dZN
TuEQ1nT8RvqZzfhsga/6a2QEbDC0eH7/6A5c/a0/dPi/aKBcKNXsFDHCo2Ui
VgLMGGA03m6aazLDQb25lWoDsbA3Sj39E5jj+B2rheYzCWCUHZZKF7BEoCzl
a659AIuZRpUDYpaY6qNAWdr9AGrvLfRS5Szx1bMYmX0jD8A8xGulvrolWjbZ
Ev2iyUC1OxX/m2KJqiqCB88cTQZnaf1bwcmWKEnoVVV9T4abV79cjNtihb/l
36hEL0sBi4vMeAGwwn/bx/XEZVJA7PzxEt89VvglsbQgTjEFYk+0Ttses0K9
ZZfSH+mkQPLWCo/VV6xw2cdPn/uOpkD+WKxjVr0Vvpx1uZr/KAXony2DV3RY
ofqy1jyr/BTQ/fBf2o1eK2QLfNw6XZoCpdwrfa6TVnh+SnfFroYUqEp3O6Yt
S0E+aaXe91Mp8NbW1KrMgYKs9JkNOwyZ4NR19s91VwqqrEwTNdrHhNlDtzIP
X6Dg+mtGf/ZYM0HBqnNhOpSCb17zJ9k4MiGv8XfWqygK7nB6tP6EOxNgvyI1
Jp6CnZJ8ng4MJtB2n83WzKbgyyLndvdwJkxXRx76W0jB9uh4wiuGCaFGhTwN
5RSMmJRT801iguzLjpykagpGeu0za2MygbXrt825Bgouu/J+K5HBhO3lq/m2
dVAwPWKeXcdiQv1Wk1yBXgryzsg/fpPLhHGdyEUZ4xQ0beERe1vMhKsFBXle
cxTcdvB7c2cpEyQ0O44a8VnjGo/HHp0cJuhtWJ3fK2GNdUvSQrg1TLikWHBc
Tt8a3c3ohufeMkFo2dviqEvWOB5OP3t9ign3b8zZnQy1Rq8KG1udX0xQF1wl
rB5ljSIBbkHd80ywXORMI1KsMVyu8ZQsXyrcm5sV4a+2xiN1v384iaWC6heF
M35CVNzYx97isykVDF6clnO8R0WR+seeLg6p0FWnNDeRQsURRQXbVc6p4NX6
sfNyNhX7Jxz7m8+lQtbnI7HxHCoqnv3Kv4WeCuLCB8TqB6i4zWztwnxQKnw+
smWJjtYhJBq23ghJToWbk/yTPNxDaGJBmDzrToX3azK59+dtMK95l06pZRoc
RPM7+luOoubeZfrRWunwfN3O8vjTx1Bif2mQnEgG2EhYckNfnUBmeIeWG98j
4BbUTHTOncLMYoZf+8gj2LZek+e9pj2qHXZsODGeCdLTgnujde2xqTrJxn06
E6YrPt023WaPywHcAmczIY8ap5JvZI8ff740TuPJAuWgBbOQQ/bYLH74wYRY
Fgh3vonU9LdHwRebDVjaWdAXfEY+uNYeB6MHJ0K8soBz0Oj0tjf22HZXNjOL
kQWJcgq5Y032eOua6OQb/yw4lN9kcLTbHlNeze+WDM4C4r0eTWPUHsMsLv/L
uZsFRZv5WV3Ladj1vrPuV3EWhPUx9dRP0PCgic9hvrksqHfPN71tT0Ol/V1B
P/5kgdhCBfWnIw0FZOK0e3hYkLjiA53jTsOTuT3rygRZkEeRfnIgiIYvggsD
/GRZMNWnWlEQTMPv4t+GXBRYsNVDp0EqnIbxOa4fTyiyoCrCcqTnNg31dvQ5
Gq9jQUf1DTX3NBo+eSc2IrmVBfLWCXqtmTRMdR7LENrJArv+TFO9xzT8uYY6
woMsyPB4Rk3Mp+FIlUf5L2MWDC9UO/wtoqFt30npH7tZoHmzjU4rpSF/gPWf
L+Ys8Jb7dKWWQ0O+f+fdeg+y4HnWePSGKhr2MbNnnY6wYEHv38NbtTRsHHMv
ueTIAqOaZU8mCRqadD7Q9KazINRaocKmiYYBKnJXrANZ5Ptq24dVXTRceuJ1
0lA8C1RZXrJPvtEQTA6VDb9hwVn9q2oSY+R5NxR1F3aR/amJ1mNM0pD2w+pv
0GeyH59yqfCbhrfUbAQ2/2OBufxQdJOwA1LUNHaPbs4GeuTxpeOaDqh1bndO
aFI2VHqazmv5OGDV1PamAPccEDJTVJn2c8BhC/28uoAcoMr9Ni8JdMCorxnm
EhE58KUq/8GucAf00xlySs/MAWFJBcN99x2wLlEirqgvB2yeTYY5VDngHZ2e
nAjKYxiZfygVJ3Iax0eo4fQtuSAVPK/1+9FpXK9T0tb0Jw+o5/umfV454ssU
/uvGegWQ19O5sfSXEz5RUv3Ir/MUFhX+vH1y7RmU825RDjUrBiM7k5BiPIu/
B0717TMvgftR6SOt9HN4evqw/pvgUqhso6vtY5zDfEfVUzKRpfBFxtCh0v8c
inZvWuUQWwpaKT3vngSfw8XGUdS5jFKozpcmbsadQ2nVYwcVX5fC95brWWZl
5zBaqvTYoaVlYCDp5ljG64IWyrtOmESWgcORHUztJS7oJWQwGRBbBtfvL+3J
EnJBg1r/oqIHZdCq+oh6T8IF9cegSCmvDJy39Bp7r3HBw7Xx+ycayyDaxkpZ
Y68LLr+eqntarBz647f0MqNdsN5XJiU4phxSfV5m8sW6IDd59oJ3YjnQqObn
HRJcUD03ZL1DajkMitrzrkkl84kkKe4qLIeh0JsqWU9dUFeTLTzQUg7j3gPO
eR0uuEVBoX9ajA0FFHct0fcumN92P6hFlg10rblZj14XvF0k+e6xIhumR0Ru
aA+54LzmhqentNgwS9v+uGjOBU0KNWuKD7KhFGu8pf66oH/D0J+ww2zwW2W5
y4fPFa0/Tn48cooNf7odG/X/c0VTyU2JM+5s4JSMx8WLuqJqQKTHKx82XI71
PzUnQbqy++uty2wAryXrbGVd8ZHBLt6joWzgsbo9Xqbgiu8Gp0uVbrGhUkOh
VF7JFQu99//KvMuGq8KZVwLWuGKu/+UKn3tsMB7W3tez3hV9tcoVDRLZsLiO
LW6g4Yoq7SoH/txnQ03G7vfJm11xqry3+clDNoRea037p0fGz7tfP5zKBkEY
0q0EVwzdfORAUCYbuApeC0omrhidO7aLJ5sNN+YXaq7ucUWdkBWy9MdsEH4m
cdjEyhWbI2NnNhSwQUwdLr6muWJVzkT4ZCkbWoQIw3XOZH2aBn952WyIGaIK
hbu4YsRxg82LK9ggmX4uaZ83mX/z4MpPlWyQlY/jNIS4ooxjdcoyLhu6ZxVD
NW6Q9Tpevsom2JDYkWMRdYvMJyE6ZFfPBoWYyl7Le64oovE6PaKJDYpLv/O2
Z5HOULGkv2XDl00mg3dyXZHfWCZjuoMNOZZJtdaFrsj+z7rcrYsNevF7I9rK
XTH9p+4D0/dsMFd7JNnWSM5jr3BCbB95HvOFmZg2cn4K6+id/WzocKd2U7pc
ker2LFF8gA12z/iSW/td8bF48ZcLn9ngY3pKrXXaFVfraav8+saGnWefLY2Z
c8VO29bdQiNs4I1cNmr11xUXRHdFyY6y4WZ7eX6LgBtGfQ8wUhtjQ6qD7PYW
OTf88klwfPkkGxqutOxvRjes+JlA3TlH9i9jnWa0qRvGv/s2KTHPhiPcwOWW
+9xQRzbp4xDpT2IaHU3WZD7LXXM3/pD39eGNU01Obrj7kW1Y4T82qFYY0xtv
kvEd6lnJ/Bzwmy++V9/lhiPVa4bNxDiQ2W+IO3rccOpbweIPpNvrGoZY/W4Y
09K14fxyDmjc+7wtbNgNf89M5MaKc+CTjtQHwz9u2DUcuqxDkgPmbt6KJavd
MUHchq25ggMKfZtZTCd3PKSsrnpCiQMvap6U+Uy749SO7W+ktTgwPilwyWSO
XO8s8LhFWlnRDsT/umMVOt/n1+ZAsJ9Yda6AByZc2Ht3kvQ+Tc+GQTkPfDg/
teq1Dgc64jf3UQw90GRJW9IxfQ6MuRTza97yQOWt1yjbDDggGn4ia0riPIZM
P7zyax8H2LSZGz3Z55HozczcZs+BUyw13RR9T/SX9aF89eJAVH6/tFmzJ2rr
nyn9GMoBu/nQ5UGtnnjjQ3ebShgHtEw2CZe1e+LnlVKDZ0i3dvrwanR7YpiJ
8pdJ0pL//huV+uSJFxuUvZaEcyD+gF7l5ylP5O/Uf7UxggOpwzdcQmToWBZY
WesRxQG6rpbTixV0zCT2Vz4lbXz5rd2cPB29jvAW/SI9uFzRxk2RjpY7NK8G
RnNg7bZiPLSejnUrN1Xfus2BnLBeqTU76PgwXmY05w4HilR1X1afpGPzWL1+
/z0OUMr1r0zZ0fG1/xl+lXgOTFjtMFJ2oGN9H3/DadIagUbVgc7kfl7P9g2R
zuq2rNt+no5f90os+ZHAgQe33Jrzr9DRwpS4/DuJAzvXeN7uvUZHe7+3Mzvv
c+BduTdFJJSOvHdfn71MWvabf7vLDTrKjx415H3AgRjjG11r79Cxk/dLyZJk
DoTOPuq7n07HvVMdtWIpHFCNyma+eUTHPo2b01akX63Jo81n0TFy085Vd0jz
WBcPHs6lY9I+qqMUkwPJ355nhD6hY+6rM1dtSO8KYjsVF9CxZfXqpHuk/XJf
DYk/o6Pet5EXK1LJekxeswyf0zF/2YV6W9Il74hz58voGPB48dsk0jaejRsf
sumouyOp+wPpaYHW0YYKOl5rwncr08j6k9/m/nlJR9uFbvclmRzQ3tLtvvEV
HYea/EZtn3Cg+c0HTdsaOiY3GzkXlHDAndY3fv01HXsqq7uXveSA8NxAQQmX
jt86g7286sh5RX2lf3lDxxmL7SWDzRwYYo9NGzfTcXBvZvBEPwdoMguzf7vo
qHRnh1rz4go4XL+C98IwHXPEFF8XHaiA2ZBFB9tG6aiaEzPUf7gC4uH7fe0f
dMyoD9+2ilYB7wpfbh2bIu9DUezYS58KOJHgfN55gY4Jf0ZL4lIqwMGpuPeo
mBf+12G2ofNnBXjwWFUY6HmhQEG4S2PqCwjTve4veNULL82Xe1cHvITHS6PY
3qLe6Kb9d3HL00o4+XCVfnWWN75r/9TQt/gVLEk18x3Vv4AX9cyM1+6tho1d
vFZm1RfwpZtUtc3dGvjYaOpw7bgPrvcY2VEg/BpCNyvvTBj2wQPfI1cKXaoD
mdcuirzffXD4QcEi12t1kHWsePHZHz6oyapZ3xReB9zgPQ1bp32wYbeaXkJc
Hfl97n6ya8EHvZurKDvz6+COf3mQzHIGPrh45EnFQB2oivE7Bkow0FTo50Pd
4TooSrfY+1WKgfda/rXkjNdBR0P/8hI5BtZ7Fs8/WKgDOUXBNBtVBq5MiLW7
LcOFlGpqTaw+A69YmN0qMueC9tFk1sI2Bg6trk82oHCh6vvXSMedDJRy+DHB
PcKFQWl/my2GDAzRVrMbdOSC2lnm1/Z9DDzyIu7kuiAuPF8YfrPzAANP2jJD
2KFc2BOjm59+kIHfF2p/WEVy4Vz5a19vKgMFRBMigxK5kLdsbKnkSQY+aRkY
Hy3iAqTqj/nbMZCfab45opwLzXpXWgdo5Ho1lGyo4sLEKcmkp84MHKf9iHBr
4sLV6ROB8ucY2KZg1y7WwQXx8EyHa64MHFwQPFP8gQtpKyd2j7gzMDzFF44N
cEG3cPsma08Gbrx+pCruKxdqzILFyr0YmFB66VnbNy7YvG+YVvZh4PasIDnB
US74LrbnTPox8PYxWXWrcS6U24RZxAQzMPGxTqn5LBfktmrOjYUy0NpOI2/1
PBm/ojPNPJyBY87XjL785oLeh7Vzi28xUGuiNcP8HxdiOY1p9tEMdF4r3zjM
Q8B0so9FRQwD106FG17iI6DQvjaNcY/cf1ZA7xI/AcuN3S3aExh4fID3xMgS
As6rSs9p3WfgL6NYGQtBAtS/OloMpzBwv1xuyaQQAVmu/HPHsxn4aUS0vUqU
AAGL3LTSxwykCxU86xUjwEnzkIX0EwZmnM9YOr2cAJXJ9LSmpwykTN2nLpYk
IJlhYmHEYeAmLSWjehkCFo6Mzia/YGDS1Qa/XFkCjm+/m/a7koFTBYsirq8g
YMXCwGxRLQN3jH/QVZcn4O7Va2lqzQxctyVlm/4qAqYcNloEtzKwm1++/jtp
imnbbF87A5U1hhceriZAVFDFIrGb7L+s2PwvRQJuRFbNCg8wUN9S75+fCgHf
3M+lnf3MQCNq2G4JVQL2WIpb1H5l4POvVV5ZpJdI0NICRxmoeu3cb+4aAq7E
81pM/mSgsWi/yHc1AvousmYtZhnI4iwhPNYRYHDMKi1nntz/qMWBcdJ/VjJn
T/9joImAmcDIegJ80zCtU9AXTakZsdyNBLjnBc6y5X3xcUnr8+2aBARNGC6Z
WOmLU5dCxpJI39FdLLlG0RcLd25V+kP6edl1zUhVX8yorkot1SJg0evbTifU
fdFyVJ1vw2YC4nvT2hcMfFEmfE30F10CqsTq8g1ovpiueatnehsB0l5iZ19m
+WJbh4y9pDEBG7ufL1LN8cWneRHMU6QR7JPDcn1xXmcwL5v02f8K2ywKyXp+
f9dBEwLYadYGPeW+GOUe+++MKQEO7XES842+eLPxuWnhbgLyt6ys0Pnpi58r
t6Wp7SfAfHa9RKbhRbwpHz5TSCXAZ/j9Nafmi/jmKNv6kQMBq8SUbh4+7odU
gZAeZ08CrGfGGjZO+6Hw2d0mOYEEXN57qKPrij++EGLF371JgJfHW7pVsD+e
5uF52ED6TOwhUSLUHw2CClKWRJLz7z+0pzzCH/Hh9jhf0moXbcoexPpj1h8w
P36LgOasw8k0lj+ajRp8Vo4mQEnQ1mm02R9bNzyQyb1D9kfjHZ9jmz++mxNK
+kxamGr7sOetP665/Vtu1V0CZh7adjW+88fMpx5iUaQJ/WP7Cgb9MWJhQ+v5
WALozsc1fGb9Mb9v5rnOPQKcIz8QY/P++ORXiIAr6eNPjzs7L/hj9f0SSjpp
s3/HU47wBWB/UkGvZDwB8vdOiO8QDiD/n4mun6TFOD15T0UCMI+4IKqRQN7H
gRPmm5YHYI/+ImMn0uMaJ4NXSgegFu9TZgfpz9SPinGyAbjdSbtBJJGAd34n
OSLyASiUNPbTjHRTysejYSsD8A5lRj6QdHXtyZl/qwMw/CxACen/AYMzQxM=

      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwVV3c41m8XVyJbJDMjyQwlM/U9hxBCNiF7b4/x8JBkp5KiSERIQhEyy0hG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      "]]}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.005], LineBox[CompressedData["
1:eJwVl3c4l98bx5FRmVlZRWia2aOe+0ZGSFYlIXuPjw9ZH5ERQkgZScjeWyFK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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], Dashing[{Small, Small}], 
     LineBox[CompressedData["
1:eJwd13k41F8XAHBLlCUK2Wkh2RJCWe+xl31NhOz7MsYydi0i/UpKaRNCaFES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      "]]}}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{445, 0.18784655218789456`}, {455, 0.22784655218789454`}}]}, 
   {GrayLevel[0], Thickness[0.007], 
    LineBox[{{445, 0.22784655218789454`}, {455, 0.18784655218789456`}}]}, {
    {RGBColor[1, 0.5, 0.5], 
     RectangleBox[{425, 0.7}, {450, 0.8158740221149205}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{450, 0.7}, {475, 0.8170557972073023}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {420., 0.705}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.8}, {420., 0.805}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.9}, {420., 0.905}]}, 
    {GrayLevel[0], RectangleBox[{415., 0.7}, {414.5, 0.905}]}}},
  AspectRatio->0.75,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameTicks->{{{{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}, {{0.2, 
       FormBox["0.2`", TraditionalForm]}, {0.4, 
       FormBox["0.4`", TraditionalForm]}, {0.6, 
       FormBox["0.6`", TraditionalForm]}, {0.8, 
       FormBox["0.8`", TraditionalForm]}}}, {{{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}, {{0, 
       FormBox["0", TraditionalForm]}, {100, 
       FormBox["100", TraditionalForm]}, {200, 
       FormBox["200", TraditionalForm]}, {300, 
       FormBox["300", TraditionalForm]}, {400, 
       FormBox["400", TraditionalForm]}, {500, 
       FormBox["500", TraditionalForm]}}}},
  FrameTicksStyle->{{
     Directive[FontOpacity -> 0, FontSize -> 0], 
     Directive[FontOpacity -> 0, FontSize -> 0]}, {
     Directive[FontSize -> 12], 
     Directive[FontOpacity -> 0, FontSize -> 0]}},
  LabelStyle->Directive[12, FontFamily -> "Helvetica", 
    GrayLevel[0]],
  Method->{"AxesInFront" -> True},
  PlotRange->{{0, 500}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  TicksStyle->Directive[
    GrayLevel[0], FontFamily -> "Helvetica", 11]]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677293468957*^9, 3.7966777467948847`*^9, 3.7966819219739637`*^9, 
   3.796682029621365*^9, 3.796682434516294*^9, 3.796687872089184*^9, 
   3.796688099372064*^9, 3.7966908974451427`*^9, 3.796693896008141*^9, 
   3.796752432278822*^9, 3.796752673765243*^9, 3.796781798818375*^9, 
   3.79678188059021*^9, 3.7967835765429296`*^9, 3.796784349634851*^9, 
   3.796784379731773*^9, 3.796796666346838*^9, 3.798365317742833*^9, 
   3.798647804905424*^9, 3.798648010592786*^9, 3.798648313931823*^9, 
   3.798648345257983*^9, 3.798655744847629*^9, 3.798655911948001*^9, 
   3.7986572251934443`*^9, 3.7986576138936*^9, 3.798657741666518*^9, 
   3.798657888958753*^9, 3.7986597400776577`*^9, 3.798714298361383*^9, 
   3.7989090178557158`*^9, 3.798909312063919*^9, 3.798909496322501*^9, 
   3.798910526523726*^9, 3.798925909012253*^9, {3.79892633688914*^9, 
   3.798926365849469*^9}, 3.7989266191978817`*^9, 3.7989271983544283`*^9, 
   3.798929985344664*^9, 3.7996957428782988`*^9, 3.799696849790019*^9, 
   3.800125760415062*^9},
 ExpressionUUID -> "890eaecf-ed61-4813-aef0-9f547539f643"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Figure 3g: Evolution of pre-symptomatic phase \[Kappa], control measures\
\>", "Subsubsection",
 CellChangeTimes->{{3.796667016409075*^9, 3.796667052029455*^9}, {
   3.79667414806647*^9, 3.796674164129323*^9}, {3.796676916421912*^9, 
   3.796676919585401*^9}, {3.7983654435345707`*^9, 3.798365443709165*^9}, 
   3.798648135272422*^9, 3.7986481986767473`*^9, {3.798648277252512*^9, 
   3.7986482832719097`*^9}, {3.7989262904192247`*^9, 
   3.7989263042641983`*^9}, {3.7989299693213167`*^9, 3.798929971933342*^9}},
 ExpressionUUID -> "c875ee02-bb43-4be2-811b-002106a978e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Beta]", "->", "1"}], ",", " ", 
     RowBox[{"\[Beta]m", "->", "1"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"TRANSMISSION", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "->", "0.005"}], ",", " ", 
     RowBox[{"\[Alpha]m", "->", "0.005"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"VIRULENCE", " ", "OF", " ", "THE", " ", "MUTANT"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yP", "->", "1"}], ",", 
     RowBox[{"\[Kappa]yPm", "\[Rule]", 
      RowBox[{"2", "/", "3"}]}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "PRESYMPTOMATIC", " ", 
       "CLASS", " ", "FOR", " ", "THE", " ", "MUTANT"}], " ", "*)"}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"f", "->", "0.2"}], ",", " ", 
     RowBox[{"fm", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"PROPORTION", " ", "OF", " ", "ASYMPTOMATIC", " ", "CASES"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yE", "->", "0.25"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "EXPOSED", " ", "CLASS"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yI", "->", "0.2"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "SYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Kappa]yA", "->", "0.11"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"1", "/", "TIME"}], " ", "IN", " ", "ASYMPTOMATIC", " ", 
       "CLASS"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Strength", " ", "of", " ", "control", " ", "measures"}], 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c1", "->", "0.6"}], ",", 
     RowBox[{"c2", "->", "0.6"}], ",", 
     RowBox[{"c3", "\[Rule]", "0.6"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.796664370574654*^9, 3.796664378027216*^9}, {
   3.7966644134403753`*^9, 3.796664436156101*^9}, {3.796664545792569*^9, 
   3.7966645915965967`*^9}, 3.796664638689022*^9, {3.7966652610231247`*^9, 
   3.796665288121649*^9}, 3.7966664303705053`*^9, 3.796667062381825*^9, {
   3.796674191058156*^9, 3.796674196138136*^9}, {3.796676925542235*^9, 
   3.796676928806604*^9}, {3.7966824315176363`*^9, 3.796682432172542*^9}, 
   3.7966886978905993`*^9, 3.7989090117679787`*^9, 3.7989258810008802`*^9},
 ExpressionUUID -> "ddf86d85-24e2-4313-840c-c645e9b01969"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tNOevolNC", "=", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"yE", "[", "t", "]"}], "+", 
             RowBox[{"yA", "[", "t", "]"}], "+", 
             RowBox[{"yP", "[", "t", "]"}], "+", 
             RowBox[{"yI", "[", "t", "]"}], "+", 
             RowBox[{"yEm", "[", "t", "]"}], "+", 
             RowBox[{"yAm", "[", "t", "]"}], "+", 
             RowBox[{"yPm", "[", "t", "]"}], "+", 
             RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
          RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], 
      "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fnoevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tNOevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red", ",", 
          "Dashed"}], "}"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fSDashed", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Dashed", ",", " ", 
         "Blue"}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mortalitynoevol", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"yD", "[", "tNOevolNC", "]"}], "+", 
     RowBox[{"yDm", "[", "tNOevolNC", "]"}]}], "/.", 
    RowBox[{"Flatten", "[", 
     RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.796667008838949*^9, 3.796667009194861*^9}, {
   3.796667070842825*^9, 3.796667157355983*^9}, {3.796667273928275*^9, 
   3.796667274261375*^9}, {3.7966720945482883`*^9, 3.796672122623597*^9}, {
   3.796672240237385*^9, 3.796672249143201*^9}, {3.7966725779799023`*^9, 
   3.796672580378277*^9}, {3.796672618571775*^9, 3.7966726243701363`*^9}, {
   3.796672662963419*^9, 3.7966726649906063`*^9}, {3.7966732474362307`*^9, 
   3.796673258442985*^9}, {3.796673784848586*^9, 3.79667379075447*^9}, 
   3.7966740376560373`*^9, {3.796681904037208*^9, 3.796681904535309*^9}, 
   3.798910153975029*^9, 3.7989101876537943`*^9, 3.798910241549554*^9, {
   3.799016131420062*^9, 3.7990161314765987`*^9}},
 ExpressionUUID -> "6ae33989-aac5-4368-ad00-b18931ce109a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.8001257606498003`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.682631189948263`"}],
  SequenceForm["R0 of the mutant type = ", 2.682631189948263],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.8001257606521397`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.800125760657824*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.8001257606615343`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.011587408462006054`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.011587408462006054`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.8001257606671133`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.7989264251344433`*^9, 3.798926619407525*^9, 
  3.7989271985210857`*^9, 3.798929985927506*^9, 3.799695743751563*^9, 
  3.799696849999044*^9, 3.80012576067155*^9}]
}, Open  ]],

Cell[BoxData["449"], "Output",
 CellChangeTimes->{{3.796667105647694*^9, 3.7966671233707037`*^9}, 
   3.7966671578794947`*^9, 3.796667274910541*^9, 3.796672042732346*^9, {
   3.79667210114775*^9, 3.796672116981563*^9}, 3.796672216595389*^9, 
   3.796672246738545*^9, 3.796672387586549*^9, {3.796672581065564*^9, 
   3.796672588735523*^9}, {3.796672629566416*^9, 3.796672665990589*^9}, {
   3.796673252541327*^9, 3.796673258972966*^9}, 3.796673301319007*^9, 
   3.796673338423213*^9, 3.7966734278854218`*^9, 3.796673487323223*^9, 
   3.7966735850746803`*^9, 3.796673656875914*^9, 3.7966736883603983`*^9, {
   3.7966737711150208`*^9, 3.796673812078114*^9}, 3.796673859479602*^9, {
   3.7966739645822887`*^9, 3.796673991074184*^9}, 3.796674038230788*^9, 
   3.796674201385605*^9, 3.7966743569131804`*^9, 3.7966772929641237`*^9, 
   3.796677746512498*^9, 3.796681921823151*^9, 3.796682029332395*^9, 
   3.7966824343485622`*^9, 3.796687871854019*^9, 3.7966880993398027`*^9, 
   3.7966908973046637`*^9, 3.796693895853547*^9, 3.796752432108746*^9, 
   3.796752673434168*^9, 3.7967817986253843`*^9, 3.7967818804282303`*^9, 
   3.796783576192992*^9, 3.796784349441544*^9, 3.796784379545883*^9, 
   3.796796666003852*^9, 3.7983653174245367`*^9, 3.798647804708379*^9, 
   3.7986480104196444`*^9, {3.798648298570303*^9, 3.79864831410275*^9}, 
   3.7986483453911877`*^9, 3.7986485525434837`*^9, 3.7986529424976597`*^9, 
   3.798653015139822*^9, 3.798655745220419*^9, 3.798655912323831*^9, 
   3.798657225571518*^9, 3.798657614446292*^9, 3.798657741837762*^9, 
   3.798657889192647*^9, 3.798659740302287*^9, 3.798714298670116*^9, 
   3.798909018155254*^9, 3.798909312279315*^9, 3.798909496988473*^9, 
   3.798910526847994*^9, 3.798925909700604*^9, {3.798926337413816*^9, 
   3.7989263660299473`*^9}, 3.798926425149*^9, 3.79892661942583*^9, 
   3.798927198538888*^9, 3.798929985945154*^9, 3.799695743774558*^9, 
   3.79969685001998*^9, 3.800125760675241*^9},
 ExpressionUUID -> "72b28f06-c012-4182-b6a5-042bce4449a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"parset", "=", 
   RowBox[{
    RowBox[{"parvec", "/.", "pars"}], "/.", 
    RowBox[{"mut", "\[Rule]", "0.01"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalfreq", "[", "parset", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"tevolNC", "=", 
  RowBox[{"LengthWhile", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
         RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "tfig", ",", "1"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{
     RowBox[{"#", ">", 
      SuperscriptBox["10", 
       RowBox[{"-", "7"}]]}], "&"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fevol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"yE", "[", "t", "]"}], "+", 
           RowBox[{"yA", "[", "t", "]"}], "+", 
           RowBox[{"yP", "[", "t", "]"}], "+", 
           RowBox[{"yI", "[", "t", "]"}], "+", 
           RowBox[{"yEm", "[", "t", "]"}], "+", 
           RowBox[{"yAm", "[", "t", "]"}], "+", 
           RowBox[{"yPm", "[", "t", "]"}], "+", 
           RowBox[{"yIm", "[", "t", "]"}]}], ")"}], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "7"}]}], ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Red"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"freqERADIC", "=", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"yE", "[", "t", "]"}], "+", 
         RowBox[{"yA", "[", "t", "]"}], "+", 
         RowBox[{"yP", "[", "t", "]"}], "+", 
         RowBox[{"yI", "[", "t", "]"}], "+", 
         RowBox[{"yEm", "[", "t", "]"}], "+", 
         RowBox[{"yAm", "[", "t", "]"}], "+", 
         RowBox[{"yPm", "[", "t", "]"}], "+", 
         RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "/.", 
      RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], "/.", 
    RowBox[{"t", "\[Rule]", "tevolNC"}]}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FIGfreq", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"yE", "[", "t", "]"}], "+", 
            RowBox[{"yA", "[", "t", "]"}], "+", 
            RowBox[{"yP", "[", "t", "]"}], "+", 
            RowBox[{"yI", "[", "t", "]"}], "+", 
            RowBox[{"yEm", "[", "t", "]"}], "+", 
            RowBox[{"yAm", "[", "t", "]"}], "+", 
            RowBox[{"yPm", "[", "t", "]"}], "+", 
            RowBox[{"yIm", "[", "t", "]"}]}], ")"}]], "}"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tevolNC"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.008", "]"}], ",", "Black"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fS", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"S", "[", "t", "]"}], "/.", 
        RowBox[{"NSolution", "[", "parset", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Blue"}], 
        "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fcontrol", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"c", "[", "t", "]"}]}], "/.", "pars"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tfig"}], "}"}], ",", 
      RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
      RowBox[{"FillingStyle", "\[Rule]", "LightGray"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "None"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "tfig"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.75"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line1", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "-", "5"}], ",", 
            RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"tevolNC", "+", "5"}], ",", 
            RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}]}], "}"}], 
       "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line2", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.007", "]"}], ",", "Black", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "-", "5"}], ",", 
             RowBox[{"freqERADIC", "+", "0.02"}]}], "}"}], "]"}], ",", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"tevolNC", "+", "5"}], ",", 
             RowBox[{"freqERADIC", "-", "0.02"}]}], "}"}], "]"}]}], "}"}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mortalityevol", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"yD", "[", "tevolNC", "]"}], "+", 
      RowBox[{"yDm", "[", "tevolNC", "]"}]}], "/.", 
     RowBox[{"Flatten", "[", 
      RowBox[{"NSolution", "[", "parset", "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"mortality", "=", 
     StyleBox[
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"StringJoin", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", "mortalitynoevol"}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], " ", "]"}], "]"}], ",", 
              "\"\<% (\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"N", "[", 
                RowBox[{"Round", "[", 
                 RowBox[{
                  RowBox[{"100", " ", 
                   RowBox[{"(", "mortalityevol", ")"}]}], ",", 
                  SuperscriptBox["10", 
                   RowBox[{"-", "1"}]]}], "]"}], "]"}], "]"}], ",", 
              "\"\<%)\>\""}], "]"}], ",", "12", ",", 
            RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t3min", "+", "t3max"}], ")"}], "/", "2"}], ",", 
            "0.3"}], "}"}]}], "]"}], "}"}], "]"}],
      FontWeight->"Bold"]}], ";"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DeathRates", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", "/", "20"}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t3max", ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalitynoevol"}]}]}], "}"}]}], "]"}], ",", 
       "Red", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t3max", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "+", 
            RowBox[{"tfig", "/", "20"}]}], ",", 
           RowBox[{"0.7", "+", 
            RowBox[{"10", "*", "mortalityevol"}]}]}], "}"}]}], "]"}], ",", 
       "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.705"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.805"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.2", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], "]"}], 
       ",", "Black", ",", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.4", "/", "20"}]}]}], ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t3max", "-", 
            RowBox[{"tfig", " ", 
             RowBox[{"1.42", "/", "20"}]}]}], ",", "0.905"}], "}"}]}], 
        "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"FigBOT3", "=", 
  RowBox[{"Show", "[", 
   RowBox[{
   "fcontrol", ",", "fS", ",", "FIGfreq", ",", "fnoevol", ",", "fevol", ",", 
    "fSDashed", ",", "line1", ",", "line2", ",", "DeathRates", ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "11"}], 
      "]"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"12", ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", "Black"}],
       "]"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], "]"}], 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{"{", 
           RowBox[{"0.2", ",", "0.4", ",", "0.6", ",", "0.8"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "100", ",", "200", ",", "300", ",", "400", ",", "500"}], 
          "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FrameTicksStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"FontSize", "\[Rule]", "12"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"FontOpacity", "\[Rule]", "0"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "0"}]}], "]"}]}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.7966727105857487`*^9, 3.796672842251453*^9}, {
   3.7966729162146072`*^9, 3.79667292227555*^9}, {3.796673040621821*^9, 
   3.796673041421997*^9}, 3.796673095207383*^9, {3.7966731611804667`*^9, 
   3.796673161549141*^9}, 3.796674086160819*^9, 3.796674228784727*^9, {
   3.7966743013088284`*^9, 3.796674334808358*^9}, {3.796674373952984*^9, 
   3.7966743755540648`*^9}, 3.796676986723856*^9, {3.796681861384461*^9, 
   3.796681867035219*^9}, {3.796682016144153*^9, 3.796682016642682*^9}, {
   3.796687849959033*^9, 3.79668785268452*^9}, {3.79668806244241*^9, 
   3.796688062913072*^9}, 3.796694608473276*^9, 3.7967523184768744`*^9, 
   3.796752419669855*^9, {3.7967525151920853`*^9, 3.796752537235073*^9}, 
   3.7967526495584507`*^9, {3.796784343035324*^9, 3.796784346168426*^9}, 
   3.7986477039326563`*^9, 3.79864775064361*^9, 3.79864799778578*^9, {
   3.798648335240569*^9, 3.798648336258809*^9}, 3.798655730778737*^9, 
   3.798655894353848*^9, 3.798657583381255*^9, 3.798657736688218*^9, {
   3.79865782616949*^9, 3.798657842146142*^9}, {3.798714287079075*^9, 
   3.7987142882283907`*^9}, 3.798909485497435*^9, {3.798910122243959*^9, 
   3.7989101405399113`*^9}, 3.798910320363269*^9, 3.7989266017541523`*^9, {
   3.798927000782419*^9, 3.79892700103557*^9}, 3.798929890034513*^9, {
   3.799016131532876*^9, 3.799016131713924*^9}},
 ExpressionUUID -> "b3e75750-9952-419e-8878-bfeedaa99ab2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the wild type = \"\>", "\[InvisibleSpace]", 
   "2.2826311899482636`"}],
  SequenceForm["R0 of the wild type = ", 2.2826311899482636`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760833164*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R0 of the mutant type = \"\>", "\[InvisibleSpace]", 
   "2.682631189948263`"}],
  SequenceForm["R0 of the mutant type = ", 2.682631189948263],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760837414*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760843206*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Case mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.019512195121951223`"}],
  SequenceForm["Case mortality (mutant) = ", 0.019512195121951223`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760848445*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (total) = \"\>", "\[InvisibleSpace]", 
   "0.012802240922571508`"}],
  SequenceForm["Cumulative mortality (total) = ", 0.012802240922571508`],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760852087*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cumulative mortality (mutant) = \"\>", "\[InvisibleSpace]", 
   "0.003971090555324553`"}],
  SequenceForm["Cumulative mortality (mutant) = ", 0.003971090555324553],
  Editable->False]], "Print",
 CellChangeTimes->{3.798926425310354*^9, 3.79892661958611*^9, 
  3.798927198697316*^9, 3.798929986112814*^9, 3.79969574389767*^9, 
  3.799696850109684*^9, 3.800125760859125*^9}]
}, Open  ]],

Cell[BoxData["444"], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677293468957*^9, 3.7966777467948847`*^9, 3.7966819219739637`*^9, 
   3.796682029621365*^9, 3.796682434516294*^9, 3.796687872089184*^9, 
   3.796688099372064*^9, 3.7966908974451427`*^9, 3.796693896008141*^9, 
   3.796752432278822*^9, 3.796752673765243*^9, 3.796781798818375*^9, 
   3.79678188059021*^9, 3.7967835765429296`*^9, 3.796784349634851*^9, 
   3.796784379731773*^9, 3.796796666346838*^9, 3.798365317742833*^9, 
   3.798647804905424*^9, 3.798648010592786*^9, {3.7986482987450037`*^9, 
   3.7986483454747257`*^9}, 3.798648552711515*^9, 3.798652942648225*^9, 
   3.79865301518874*^9, 3.798655745413896*^9, 3.798655912498961*^9, 
   3.798657225738784*^9, 3.798657614610077*^9, 3.798657742123314*^9, 
   3.798657889375042*^9, 3.798659740863834*^9, 3.7987142990287333`*^9, 
   3.798909018892337*^9, 3.7989093127904463`*^9, 3.798909497165104*^9, 
   3.798910527383336*^9, 3.798925909876327*^9, {3.7989263376179037`*^9, 
   3.798926366113628*^9}, 3.798926425327142*^9, 3.798926619610113*^9, 
   3.798927198714232*^9, 3.798929986137826*^9, 3.7996957439136133`*^9, 
   3.79969685012514*^9, 3.800125760864093*^9},
 ExpressionUUID -> "890eaecf-ed61-4813-aef0-9f547539f643"],

Cell[BoxData[
 RowBox[{"{", "0.9508033832983563`", "}"}]], "Output",
 CellChangeTimes->{
  3.796672745487239*^9, {3.796672775753848*^9, 3.79667279036089*^9}, 
   3.796672941268649*^9, 3.796673042119224*^9, 3.796673095912416*^9, 
   3.796673163176268*^9, 3.796674003112623*^9, {3.796674201836341*^9, 
   3.796674231135644*^9}, {3.796674324765099*^9, 3.796674376480276*^9}, 
   3.796677293468957*^9, 3.7966777467948847`*^9, 3.7966819219739637`*^9, 
   3.796682029621365*^9, 3.796682434516294*^9, 3.796687872089184*^9, 
   3.796688099372064*^9, 3.7966908974451427`*^9, 3.796693896008141*^9, 
   3.796752432278822*^9, 3.796752673765243*^9, 3.796781798818375*^9, 
   3.79678188059021*^9, 3.7967835765429296`*^9, 3.796784349634851*^9, 
   3.796784379731773*^9, 3.796796666346838*^9, 3.798365317742833*^9, 
   3.798647804905424*^9, 3.798648010592786*^9, {3.7986482987450037`*^9, 
   3.7986483454747257`*^9}, 3.798648552711515*^9, 3.798652942648225*^9, 
   3.79865301518874*^9, 3.798655745413896*^9, 3.798655912498961*^9, 
   3.798657225738784*^9, 3.798657614610077*^9, 3.798657742123314*^9, 
   3.798657889375042*^9, 3.798659740863834*^9, 3.7987142990287333`*^9, 
   3.798909018892337*^9, 3.7989093127904463`*^9, 3.798909497165104*^9, 
   3.798910527383336*^9, 3.798925909876327*^9, {3.7989263376179037`*^9, 
   3.798926366113628*^9}, 3.798926425327142*^9, 3.798926619610113*^9, 
   3.798927198714232*^9, 3.798929986137826*^9, 3.7996957439136133`*^9, 
   3.79969685012514*^9, 3.8001257608691587`*^9},
 ExpressionUUID -> "890eaecf-ed61-4813-aef0-9f547539f643"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxNlQk01HsUx8mUlMj6ImtDIctkS4u9prKNoaM4nhjrMC9rlpSebO2JNiFL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    "], {{}, 
     {GrayLevel[0.85], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{141, 52, 193, 190}, {182, 174, 188, 192}, {169, 185, 189, 
        191}}]]}, {}, {}}], {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.005], LineBox[CompressedData["
1:eJwd13k8lF8XAPBIskaFyBKJkESWqLhHRPYlCdn33RgyYyxFfkpJshRFKKkk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      "]]}}, {{}, {}, 
    {GrayLevel[0], Thickness[0.008], LineBox[CompressedData["
1:eJwVlmk4FG4Xh22lpIXQImUpyR5CKeeQZKkYUf8kyyDFEGMZjK0ae9myky2V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