# Course Organizers

<img src="../../images/organizers/chang.jpg" width="200"/>
 [Luke Chang](http://lukejchang.com/), PhD is an Assistant Professor of Psychological and Brain Sciences at Dartmouth College and directs the [Computational Social Affective Neuroscience Laboratory](http://cosanlab.com/). He completed a BA in psychology at Reed College, an MA in psychology at the New School for Social Research, and a PhD in clinical psychology and cognitive neuroscience at the University of Arizona with Alan Sanfey, PhD. He completed his predoctoral clinical internship training in behavioral medicine at the University of California Los Angeles and a postdoctoral fellowship at the University of Colorado Boulder under the mentorship of Tor Wager, PhD. His research program is focused on understanding the neurobiological and computational mechanisms underlying emotions and social interactions. Professor Chang is highly committed to innovating training in methods. He is the lead developer of the [dartbrains](https://dartbrains.org/) course, the [nltools](https://neurolearn.readthedocs.io/en/latest/) python data analysis project, the [Computational Social and Affective Neuroscience](http://compsan.org/) community page, and Co-Director of the [Methods in Neuroscience at Dartmouth Computational Summer School](http://mindsummerschool.org/).

<img src="../../images/organizers/finn.jpg" width="200"/>
[Emily Finn](https://esfinn.github.io/), PhD is an Assistant Professor of Psychological and Brain Sciences at Dartmouth College and directs the [Functional Imaging & Naturalistic Neuroscience (FINN) Lab](http://thefinnlab.github.io/). She completed a BA in linguistics at Yale University and a PhD in neuroscience, also at Yale. She then did her postdoctoral training in the Section on Functional Imaging Methods in the Laboratory of Brain and Cognition and the National Institute of Mental Health. Her research is focused on individual variability in brain activity and behavior, especially as it relates to appraisal of ambiguous information under naturalistic conditions. Professor Finn is committed to the ideals of open science, including data and code sharing (see examples [here](https://openneuro.org/datasets/ds001338), [here](https://github.com/esfinn/cpm_tutorial), and [here](https://github.com/esfinn/intersubj_rsa), and to helping train other scientists in innovative new methods for neuroimaging data acquisition and analysis.

<img src="../../images/organizers/manning.png" width="200"/>
[Jeremy Manning](https://pbs.dartmouth.edu/people/jeremy-rothman-manning), PhD is an Assistant Professor of Psychological and Brain Sciences at Dartmouth College and directs the [Contextual Dynamics Laboratory](http://www.context-lab.com).  He holds BS degrees from Brandeis University in Computer Science and Neuroscience, and a PhD in Neuroscience from the University of Pennsylvania.  He completed his postdoctoral training at Princeton University under the mentorship of Ken Norman, PhD (Neuroscience) and Dave Blei, PhD (Computer Science).  Professor Manning is passionate about computational training and methods development.  He leads development of several popular Python toolboxes including [hypertools](hypertools.readthedocs.io/), [supereeg](supereeg.readthedocs.io/), and [timecorr](timecorr.readthedocs.io/), and is a contributor to [brainIAK](https://brainiak.org/) and [NumPy](https://numpy.org/), among others.  He Co-Directs the [Methods in Neuroscience at Dartmouth Computational Summer School](https://mindsummerschool.org/) and teaches open data science courses including [Storytelling with Data](https://github.com/ContextLab/storytelling-with-data), [Introduction to Programming for Psychological Scientists](https://github.com/ContextLab/cs-for-psych), and a [Short Course in Computational Neuroscience](https://github.com/ContextLab/computational-neuroscience).

<img src="../../images/organizers/wager.jpg" width="200"/>
[Tor Wager](https://sites.dartmouth.edu/canlab/), PhD is the Diana L. Taylor Distinguished Professor in Neuroscience at Dartmouth College. He received his Ph.D. from the University of Michigan in Cognitive Psychology in 2003, and served as an Assistant (2004-2008) and Associate Professor (2009) at Columbia University, and as Associate (2010-2014) and Full Professor (2014-2019) at the University of Colorado, Boulder. Since 2004, he has directed the [Cognitive and Affective Neuroscience laboratory](https://sites.dartmouth.edu/canlab/), a research lab devoted to work on the neurophysiology of affective processes—pain, emotion, stress, and empathy—and how they are shaped by cognitive and social influences. Dr. Wager and his lab are also dedicated to developing analysis methods for functional neuroimaging and sharing ideas, tools, and scientific data with the scientific community and public. See https://canlab.github.io for papers, data, tools, and code.
