# Neuroimaging Analysis Methods For Naturalistic Data
*Edited by Luke Chang, Emily Finn, Jeremy Manning*

Naturalistic stimuli, such as films or stories, are growing in popularity for human neuroimaging experiments. More controlled than resting-state data, and more engaging and ecologically valid than traditional tasks, these rich, dynamic paradigms yield data that can be analyzed in many different ways to answer a variety of scientific questions. However, unlike resting-state and task-based designs, there are currently no standard methods to analyze data from naturalistic experiments. While traditional methods (e.g., univariate GLM and functional connectivity) can be used, naturalistic designs open up the possibility for new opportunities for methodological innovation that can take advantage of the unique features of these data. Unfortunately, most of the most widely used neuroimaging analysis toolboxes do not currently include any of the modern analysis techniques that are being used for naturalistic data. 

To meet this need, we have created [naturalistic-data.org](http://naturalistic-data.org/) an online book that includes a collection of the state-of-the-art techniques used in analyzing naturalistic data. Most of the techniques were developed in individual labs (including some of the contributors to this project). We have prepared a collection of interactive tutorials that provide background information and walkthroughs of how to perform the analytic technique on two different open datasets (**Sherlock** from [Chen et al., 2017](https://www.nature.com/articles/nn.4450) and **Paranoia** from [Finn et al., 2018](https://www.nature.com/articles/s41467-018-04387-2)) using open science tools developed within the Python and R programming languages. Most of the tutorials also include videos explaining the theory or applications of the technique that complement the more technical hands-on tutorials. All of the videos can also be viewed separately on our Naturalistic Data Analysis [youtube channel](https://www.youtube.com/playlist?list=PLbaGqHoEYoN8Le4l2-hx5zYA94UZ6A7kF). This resource was developed as a new format for a full day Educational Course for OHBM 2020 by [Luke Chang](http://cosanlab.com/), [Emily Finn](https://esfinn.github.io/), [Jeremy Manning](http://www.context-lab.com/), and [Tor Wager](https://sites.dartmouth.edu/canlab/) who are all professors at Dartmouth College in the [Department of Psychological and Brain Sciences](https://pbs.dartmouth.edu/). We have an additional 10 contributors from all over the world that are emerging as leaders in this nascent field. We hope to continue adding content as new analysis methods are developed in the field and welcome [contributions](http://naturalistic-data.org/features/markdown/Contributing.html) from all.

# Contributing

One of the wonderful aspects of both the neuroimaging and Python scientific computing communities is the strong commitment to developing and sharing knowledge and tools within the broader community. The goal of  this project is to provide a resource for people to learn about how to analyze naturalistic neuroimaging data. We try to incorporate as much open content as we can find that contributes to this goal. Please let us know if we have inadvertently omitted credit for any content generated by others. Though this course was originally developed for an OHBM educational workshop, we welcome contributions from anyone in the broader imaging community. In particular, we welcome tutorials with new methods, recorded talks of applications of interesting methods to naturalistic data, and corrections to any of our materials.

## Getting Started
The naturalistic_data_analysis project is hosted on [github](https://github.com/ljchang/naturalistic_data_analysis). If you have any questions, comments, or suggestions, please open an issue.

If you notice any mistakes or have idea for new content, please either open an issue or submit a pull request for us to review.

The website is built using [jupyter book](https://jupyter.org/jupyter-book/intro.html), which creates a jekyll website from markdown and jupyter notebooks. Please read their [materials](https://jupyter.org/jupyter-book/intro.html) to learn more about this neat resource.

## License for this book

All content in this book (ie, any files and content in the `content/` folder)
is licensed under the [Creative Commons Attribution-ShareAlike 4.0 International](https://creativecommons.org/licenses/by-sa/4.0/)
(CC BY-SA 4.0) license.

