GWR

dat

### INSTALLING PACKAGES  
    install.packages("GWmodel")
    library(GWmodel)
    install.packages("usdm")
    library(usdm)
    install.packages("vegan")
    library(vegan)


### READING DATA
    variables<-read.table("Data.txt", header="T")
    

    head(variables)
    
### VARIABLES TRANSFORMATION
    variables$protected_area<-log(variables$Protected_area_dist+1)
    variables$research_center<-log(variables$Research_center_dist+1)
    variables$dens_populat<-log(variables$Population_density+1)
    variables$dens_routes<-log(variables$Terr_route_density+1)
    variables$dist_routes<-log(variables$Terr_route_dist+1)
    variables$dist_river<-log(variables$River_dist+1)
    variables$dens_river<-log(variables$River_density+1)
    variables$effort<-log(variables$effort+1)

    head(variables)

    variables$protected_area<-decostand(variables$protected_area,method="s")
    variables$research_center<-decostand(variables$research_center,method="s")
    variables$dens_populat<-decostand(variables$dens_populat,method="s")
    variables$dens_routes<-decostand(variables$dens_routes,method="s")
    variables$dist_routes<-decostand(variables$dist_routes,method="s")
    variables$dist_river<-decostand(variables$dist_river,method="s")
    variables$dens_river<-decostand(variables$dens_river,method="s")
        
Obs. All variables were log-transformed and afterward standardized (z-score), except the response variable (sampling effort).    
   
head(variables)

### COLLINEARITY DIAGNOSTIC
    variables_cor<-subset(variables,select=c(protected_area,research_center,dens_populat,dens_routes,dist_routes,dens_river, dist_river))
    vifcor_var<-vifcor(variables_cor)
    vifcor_var
 cor(variables)
 
 head(variables_cor) 
### DATA TRANSFORMATION FOR SPATIALPOINTSDATAFRAME
    coord<-cbind(variables$Longitude,variables$Latitude)
    variables_points<-SpatialPointsDataFrame(coord,variables)


### Bandwhith calculation
   
    bw_bisquare1<-bw.gwr(effort~protected_area+research_center+dens_populat+dens_routes+dens_river, data=variables_points,approach="AICc", kernel="bisquare",adaptive=T)
   
  

### Non-stationarity test (MONTE CARLO)
    montecarlo.gwr(effort~protected_area+research_center+dens_populat+dens_routes+dens_river,data=variables_points, bw=bw_bisquare1,kernel="bisquare",adaptive=T,longlat=F)

### Geographically Weichted Regression - GWR
	dist_matrix<-gw.dist(dp.locat=coordinates(variables_points))

	gwr.model_full<-gwr.basic(effort~protected_area+research_center+dens_populat+dens_routes+dens_river,
                         data=variables_points,bw=bw_bisquare1,kernel="bisquare",
                         adaptive=T,dMat=dist_matrix,F123.test=T)
    gwr.model_full
 
 	### save in table 
    resultsfull<-as.data.frame(gwr.model_full$SDF)

write.table(resultsfull,"resultsfull_dez2020.txt")

### Adjust p-value
    gwr.model.ajust<-gwr.t.adjust(gwr.model_full)

### saving results
    results<-as.data.frame(gwr.model_full$SDF)
    results.ajust<-as.data.frame(gwr.model.ajust$SDF)
write.table(results,"results.txt")

