% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat_wrapper.R
\name{write_meta}
\alias{write_meta}
\alias{write_meta.seurat}
\alias{write_meta.Seurat}
\alias{write_meta.SingleCellExperiment}
\title{Function to write metadata to object}
\usage{
write_meta(object, ...)

\method{write_meta}{seurat}(object, meta, ...)

\method{write_meta}{Seurat}(object, meta, ...)

\method{write_meta}{SingleCellExperiment}(object, meta, ...)
}
\arguments{
\item{object}{object after tsne or umap projections
and clustering}

\item{...}{additional arguments}

\item{meta}{new metadata dataframe}
}
\value{
object with newly inserted metadata columns
}
\description{
Function to write metadata to object
}
\examples{
obj <- write_meta(
    object = s_small,
    meta = seurat_meta(s_small)
)
obj <- write_meta(
    object = s_small3,
    meta = seurat_meta(s_small3)
)
obj <- write_meta(
    object = sce_small,
    meta = object_data(sce_small, "meta.data")
)
}
